<?php

/*
Author : Kadian Salmon
Date : August 14, 2020
*/

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting scripts

include("../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../includes/headers/strings.php");//has all the constants needed

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");

//define("MAIN_DB_NAME", "initia19_paperweight");
define("MAIN_DB_NAME", "initia19_election");

define("TABLE_CLIENT", "client");
define("TABLE_CANDIDATE", "candidates");
define("TABLE_CONSTITUENCY", "constituency");
define("TABLE_DIVISION", "electoral_division");
define("TABLE_PARTY", "political_parties");
define("TABLE_ELECTION", "election");
define("TABLE_ELECTION_REL", "election_relationship");
define("TABLE_PARTY_REL", "party_relationship");
define("TABLE_CONSTITUENCY_REL", "constituency_relationship");
define("TABLE_DIVISION_ENTRY", "division_entry");
define("TABLE_BALLOT_ENTRY", "ballot_entry");

define("STATUS_OK", "OK");
define("STATUS_ERROR", "ERROR");

$paperweight = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);

if (isset($_POST["action"])){
    $action = $_POST["action"];
    $param_json = $_POST["param_json"];

    if ($action == 'store_page'){
        $page = $_GET["page"];
        $data = $param_json;//json_decode($param_json, true);

        $myfile = fopen("pdf-2016/" . $page, "w") or die("Unable to open file!");
        $txt = $data;
        fwrite($myfile, $txt);
        fclose($myfile);

        //$update_time = getCurrentTime();
        //$prediction_id = "p-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$prediction_code = getRandomNumber(5) . getRandomNumber(5);



    }

    if ($action == 'upload_prediction'){
        $data = $param_json;//json_decode($param_json, true);

        $update_time = getCurrentTime();
        $prediction_id = "p-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        $prediction_code = getRandomNumber(5) . getRandomNumber(5);

        $add_query = "insert into " . TABLE_ELECTION . " (prediction_id,update_time,prediction_data,prediction_code) values ('$prediction_id','$update_time','$data','$prediction_code')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["prediction_id"] = $prediction_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        //$result["prediction_id"] = "hfkedduisoakljhvdnakjnslfn";


        echo json_encode($result);
    }

    if ($action == 'get_prediction'){
        $data = json_decode($param_json, true);
        $result["status"] = "EMPTY";
        $result["result"] = "{}";

        $prediction_id = clean($data["prediction_id"]);

        $prediction_query = "select * from " . TABLE_ELECTION . " where prediction_id = '$prediction_id'";
        $prediction_result = $paperweight->query($prediction_query);


        if ($prediction_result != null)
        {

            while ($row = $prediction_result->fetch_array())
            {
                $result["status"] = "OK";

                $prediction_id = $row["prediction_id"];
                $prediction_data = json_decode($row["prediction_data"], true);

                $result["result"] = $prediction_data;

                break;

            }

        }


        echo json_encode($result);
    }
}

if (isset($_REQUEST["action"])){
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    $data = $_REQUEST["data"];


    //functional
    function getElectionRelationshipById($candidate_id,$election_id,$paperweight){
        $election_query = "select * from " . TABLE_ELECTION_REL . " where election_id = '$election_id' and candidate_id = '$candidate_id' order by update_time DESC";
        $election_result = $paperweight->query($election_query);

        if ($election_result != null && $election_result->is_row_found())
        {
            if ($row = $election_result->fetch_array()){

                $relationship_id = $row["relationship_id"];
                $election_id = $row["election_id"];
                $candidate_id = $row["candidate_id"];
                $party_id = $row["party_id"];
                $constituency_id = $row["constituency_id"];

                $result["relationship_id"] = $relationship_id;
                $result["election_id"] = $election_id;
                $result["candidate_id"] = $candidate_id;
                $result["party_id"] = $party_id;
                $result["constituency_id"] = $constituency_id;

                return $result;
            }

        }
        return null;
    }
    function getElectionDetailByYear($election_year,$paperweight){
        $pnp_data["candidate_id"] = "";
        $pnp_data["fname"] = "";
        $pnp_data["lname"] = "";

        $jlp_data["candidate_id"] = "";
        $jlp_data["fname"] = "";
        $jlp_data["lname"] = "";

        $detail["election_id"] = "";
        $detail["election_year"] = "";
        $detail["prime_pnp"] = "";
        $detail["prime_jlp"] = "";

        $pnp_id = getPartyByName("pnp",$paperweight)["party_id"];
        $jlp_id = getPartyByName("jlp",$paperweight)["party_id"];

        $election_query = "select * from " . TABLE_ELECTION . " where election_year = '$election_year'";
        $election_result = $paperweight->query($election_query);

        if ($election_result != null && $election_result->is_row_found())
        {
            if ($row = $election_result->fetch_array()){
                $election_id = $row["election_id"];
                $candidate_1_id = $row["candidate_1_id"];
                $candidate_2_id = $row["candidate_2_id"];
                $election_type = $row["election_type"];

                $candidate_1_election = getElectionRelationshipById($candidate_1_id,$election_id,$paperweight);
                $candidate_2_election = getElectionRelationshipById($candidate_2_id,$election_id,$paperweight);

                $candidate_1_info = getCandidateInformation($candidate_1_id,$paperweight);
                $candidate_2_info = getCandidateInformation($candidate_2_id,$paperweight);

                if($candidate_1_election["party_id"] == $pnp_id){
                    $pnp_data["candidate_id"] = $candidate_1_info["candidate_id"];
                    $pnp_data["fname"] = stringCase($candidate_1_info["first_name"],2);
                    $pnp_data["lname"] = stringCase($candidate_1_info["last_name"],2);
                }
                else if($candidate_1_election["party_id"] == $jlp_id){
                    $jlp_data["candidate_id"] = $candidate_1_info["candidate_id"];
                    $jlp_data["fname"] = stringCase($candidate_1_info["first_name"],2);
                    $jlp_data["lname"] = stringCase($candidate_1_info["last_name"],2);
                }

                if($candidate_2_election["party_id"] == $pnp_id){
                    $pnp_data["candidate_id"] = $candidate_2_info["candidate_id"];
                    $pnp_data["fname"] = stringCase($candidate_2_info["first_name"],2);
                    $pnp_data["lname"] = stringCase($candidate_2_info["last_name"],2);
                }
                else if($candidate_2_election["party_id"] == $jlp_id){
                    $jlp_data["candidate_id"] = $candidate_2_info["candidate_id"];
                    $jlp_data["fname"] = stringCase($candidate_2_info["first_name"],2);
                    $jlp_data["lname"] = stringCase($candidate_2_info["last_name"],2);
                }

                $detail["election_id"] = $election_id;
                $detail["election_year"] = $election_year;
                $detail["prime_pnp"] = $pnp_data;
                $detail["prime_jlp"] = $jlp_data;

                return $detail;
            }
        }
        return $detail;
    }
    function getElectionDetailById($election_id){}
    function hasImage($candidate_id){

        $fn = fopen("resources/candidate/$candidate_id.png","r");

        if($fn != false){
            fclose($fn);
            return true;
        }

        fclose($fn);
        return false;
    }
    function getMemberParliamentDetail($constituency_id,$election_id,$paperweight){
        $election_query = "select * from " . TABLE_ELECTION_REL . " where election_id = '$election_id' and constituency_id = '$constituency_id' order by update_time DESC";
        $election_result = $paperweight->query($election_query);

        $pnp_id = getPartyByName("pnp",$paperweight)["party_id"];
        $jlp_id = getPartyByName("jlp",$paperweight)["party_id"];

        $pnp_candidate["candidate_id"] = "";
        $pnp_candidate["fname"] = "";
        $pnp_candidate["lname"] = "";

        $jlp_candidate["candidate_id"] = "";
        $jlp_candidate["fname"] = "";
        $jlp_candidate["lname"] = "";

        $MP["pnp_candidate"] = $pnp_candidate;
        $MP["jlp_candidate"] = $jlp_candidate;

        if ($election_result != null && $election_result->is_row_found())
        {
            while ($row = $election_result->fetch_array()){

                $relationship_id = $row["relationship_id"];
                $election_id = $row["election_id"];
                $candidate_id = $row["candidate_id"];
                $party_id = $row["party_id"];
                $constituency_id = $row["constituency_id"];

                $has_image = hasImage($candidate_id);

                $candidate_info = getCandidateInformation($candidate_id,$paperweight);
                if($party_id == $pnp_id){
                    if ($has_image){
                        $pnp_candidate["image"] = $candidate_info["candidate_id"] . ".png";
                    }
                    else{
                        $pnp_candidate["image"] = "pnp_icon.svg";
                    }
                    $pnp_candidate["candidate_id"] = $candidate_info["candidate_id"];
                    $pnp_candidate["fname"] = stringCase($candidate_info["first_name"],2);
                    $pnp_candidate["lname"] = stringCase($candidate_info["last_name"],2);
                }
                else if($party_id == $jlp_id){
                    if ($has_image){
                        $jlp_candidate["image"] = $candidate_info["candidate_id"] . ".png";
                    }
                    else{
                        $jlp_candidate["image"] = "jlp_icon.svg";
                    }

                    $jlp_candidate["candidate_id"] = $candidate_info["candidate_id"];
                    $jlp_candidate["fname"] = stringCase($candidate_info["first_name"],2);
                    $jlp_candidate["lname"] = stringCase($candidate_info["last_name"],2);
                }

            }

            $MP["pnp_candidate"] = $pnp_candidate;
            $MP["jlp_candidate"] = $jlp_candidate;


            return $MP;

        }
        else{
            $pnp_candidate["candidate_id"] = "";
            $pnp_candidate["fname"] = "People's";
            $pnp_candidate["lname"] = "National Party";

            $jlp_candidate["candidate_id"] = "";
            $jlp_candidate["fname"] = "Jamaica";
            $jlp_candidate["lname"] = "Labour Party";

            $MP["pnp_candidate"] = $pnp_candidate;
            $MP["jlp_candidate"] = $jlp_candidate;
        }

        return $MP;
    }
    function getCandidateInformation($candidate_id,$paperweight){

        $candidate_query = "select * from " . TABLE_CANDIDATE . " where candidate_id = '$candidate_id'";
        $candidate_result = $paperweight->query($candidate_query);

        if ($candidate_result != null && $candidate_result->is_row_found())
        {
            if ($row = $candidate_result->fetch_array()){

                $result["candidate_id"] = $row["candidate_id"];
                $result["first_name"] = $row["first_name"];
                $result["last_name"] = $row["last_name"];

                return $result;

            }

        }

        return null;
    }
    function getConstituencyListVote($client_id,$election_id,$paperweight){
        $constituency_query = "select * from " . TABLE_CONSTITUENCY;
        $constituency_result = $paperweight->query($constituency_query);

        $constituency_list = array();
        $constituency_index = 0;

        if ($constituency_result != null && $constituency_result->is_row_found())
        {

            while ($row = $constituency_result->fetch_array())
            {
                $constituency_id = $row["constituency_id"];
                $constituency_name = stringCase($row["constituency_name"],2);
                $constituency_number = $row["constituency_number"];
                $MP = getMemberParliamentDetail($constituency_id,$election_id,$paperweight);



                $constituency_list[$constituency_index]["constituency_id"] = $constituency_id;
                $constituency_list[$constituency_index]["name"] = $constituency_name;
                $constituency_list[$constituency_index]["number"] = $constituency_number;
                $constituency_list[$constituency_index]["pnp_candidate"] = $MP["pnp_candidate"];
                $constituency_list[$constituency_index]["jlp_candidate"] = $MP["jlp_candidate"];


                $division_list = array();
                $division_index = 0;

                $division_query = "select * from " . TABLE_DIVISION . " where constituency_id = '$constituency_id'";
                $division_result = $paperweight->query($division_query);

                if ($division_result != null && $division_result->is_row_found()){
                    while ($row = $division_result->fetch_array()){

                        $division_id = $row["division_id"];
                        $division_name = stringCase($row["division_name"],2);
                        $division_number = $row["division_number"];
                        $divisionVotes = getDivisionVotes($division_id,$client_id,$election_id,$paperweight);

                        $division_list[$division_index]["division_id"] = $division_id;
                        $division_list[$division_index]["name"] = $division_name;
                        $division_list[$division_index]["number"] = $division_number;
                        $division_list[$division_index]["ballots_counted"] = $divisionVotes["ballots_counted"];
                        $division_list[$division_index]["ballots_total"] = $divisionVotes["ballots_total"];
                        $division_list[$division_index]["result_pnp"] = $divisionVotes["result_pnp"];
                        $division_list[$division_index]["result_jlp"] = $divisionVotes["result_jlp"];

                        $division_index++;
                    }
                    $constituency_list[$constituency_index]["division_list"] = $division_list;
                }

                $constituency_index++;

            }

            return $constituency_list;
        }

        return $constituency_list;
    }

    function getDivisionVotes($division_id,$client_id,$election_id,$paperweight){

        $ballot_query = "select * from " . TABLE_BALLOT_ENTRY . " where election_id = '$election_id' and division_id = '$division_id' and client_id = '$client_id'";
        $ballot_result = $paperweight->query($ballot_query);

        $pnp_id = getPartyByName("pnp",$paperweight)["party_id"];
        $jlp_id = getPartyByName("jlp",$paperweight)["party_id"];

        $ballots_counted = 0;
        $ballots_total = 0;
        $pnp_result = 0;
        $jlp_result = 0;

        $station_list = array();

        if ($ballot_result != null && $ballot_result->is_row_found())
        {
            while($row = $ballot_result->fetch_array()){
                $entry_id = $row["entry_id"];
                $party_id = $row["party_id"];
                $polling_station_id = $row["polling_station_id"];
                $result = $row["result"];

                if($party_id == $pnp_id){
                    $pnp_result += $result;
                }
                else if($party_id == $jlp_id){
                    $jlp_result += $result;
                }

                $station_list[$polling_station_id] += $result;

                //$ballots_counted++;

            }

            $ballots_counted = count($station_list);

        }







        $votes["ballots_counted"] = $ballots_counted;
        $votes["ballots_total"] = $ballots_total;
        $votes["result_pnp"] = $pnp_result;
        $votes["result_jlp"] = $jlp_result;



        return $votes;
    }

    function getResultArray($line_data){
        $stripped_line = str_replace('"', "", $line_data);
        $stripped_line = trim(preg_replace('/\s+/', ' ', $stripped_line));
        $line_array = explode(",",$stripped_line);

        $data["poll_stn_id"] = $line_array[0];
        $data["cnstncy_nbr"] = $line_array[1];
        $data["cnstncy_nm"] = $line_array[2];
        $data["ed_nbr"] = $line_array[3];
        $data["ed_nm"] = $line_array[4];
        $data["poll_station"] = $line_array[5];
        $data["party_name"] = $line_array[6];
        $data["party_candidate_lname"] = $line_array[7];
        $data["party_candidate_fname"] = $line_array[8];
        $data["results"] = $line_array[9];


        return $data;
    }
    //done
    function getDivisionByNumber($constituency_number,$division_number,$paperweight){
        $constituency_query = "select * from " . TABLE_CONSTITUENCY . " where constituency_number = '$constituency_number'";
        $constituency_result = $paperweight->query($constituency_query);


        if ($constituency_result != null)
        {

            while ($row = $constituency_result->fetch_array())
            {
                $result["status"] = "OK";

                $constituency_id = $row["constituency_id"];
                $constituency_name = $row["constituency_name"];

                $division_query = "select * from " . TABLE_DIVISION . " where constituency_id = '$constituency_id' and division_number = '$division_number'";
                $division_result = $paperweight->query($division_query);

                if ($division_result != null){
                    $row = $division_result->fetch_array();

                    $division_id = $row["division_id"];
                    $division_name = $row["division_name"];

                    $result["constituency_id"] = $constituency_id;
                    $result["division_id"] = $division_id;
                    $result["constituency_name"] = $constituency_name;
                    $result["division_name"] = $division_name;

                    return $result;
                }



                break;

            }

        }

        return null;
    }
    function getPartyByName($party_short_name,$paperweight){
        $party_short_name = stringCase($party_short_name);

        $party_query = "select * from " . TABLE_PARTY . " where short_name = '$party_short_name'";
        $party_result = $paperweight->query($party_query);


        if ($party_result != null)
        {

            while ($row = $party_result->fetch_array())
            {
                $result["status"] = "OK";

                $party_id = $row["party_id"];
                $party_full_name = $row["long_name"];
                $party_short_name = $row["short_name"];

                $result["party_id"] = $party_id;
                $result["long_name"] = $party_full_name;
                $result["short_name"] = $party_short_name;

                return $result;

            }

        }

        return null;
    }

    function generateBallot($resultArray,$election_id,$client_id,$paperweight){
        //$update_time = getCurrentTime();
        $entry_id = "ba-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        $division_info = getDivisionByNumber($resultArray["cnstncy_nbr"],$resultArray["ed_nbr"],$paperweight);
        $party_info = getPartyByName($resultArray["party_name"],$paperweight);


        $data["entry_id"] = $entry_id;
        $data["election_id"] = $election_id;
        $data["division_id"] = $division_info["division_id"];
        $data["constituency_id"] = $division_info["constituency_id"];
        $data["client_id"] = $client_id;
        $data["party_id"] = $party_info["party_id"];
        $data["polling_station_code"] = $resultArray["poll_station"];
        $data["polling_station_id"] = $resultArray["poll_stn_id"];
        $data["result"] = $resultArray["results"];

        return $data;
    }
    function updateBallot($ballot, $paperweight){
        $update_time = getCurrentTime();

        $entry_id = $ballot["entry_id"];
        $election_id = $ballot["election_id"];
        $constituency_id = $ballot["constituency_id"];
        $division_id = $ballot["division_id"];
        $client_id = $ballot["client_id"];
        $party_id = $ballot["party_id"];
        $station_code = $ballot["polling_station_code"];
        $station_id = $ballot["polling_station_id"];
        $result = $ballot["result"];


        $ballot_query = "select * from " . TABLE_BALLOT_ENTRY . " where election_id = '$election_id' and constituency_id = '$constituency_id' and division_id = '$division_id' and client_id = '$client_id' and party_id = '$party_id' and polling_station_code = '$station_code' and polling_station_id = '$station_id'";
        $ballot_result = $paperweight->query($ballot_query);

        if ($ballot_result != null && $ballot_result->is_row_found())
        {
            if ($row = $ballot_result->fetch_array()){
                $entry_id = $row["entry_id"];

                $ballot_update = "update " . TABLE_BALLOT_ENTRY . " set result='$result', update_time='$update_time' where entry_id = '$entry_id'";
                $ballot_update_result = $paperweight->query($ballot_update);

                if ($ballot_update_result != null && $ballot_update_result->is_row_affected()){

                }

            }

        }
        else{
            $add_query = "insert into " . TABLE_BALLOT_ENTRY . " (entry_id,division_id,constituency_id,client_id,party_id,polling_station_code,polling_station_id,update_time,election_id,result) values ('$entry_id','$division_id','$constituency_id','$client_id','$party_id','$station_code','$station_id','$update_time','$election_id','$result')";
            $add_result = $paperweight->query($add_query);

            if($add_result != null && $add_result->is_row_affected()){


            }
        }

    }



    //SETUP SYSTEM
    //=================================

    if ($action == "add_client"){
        $update_time = getCurrentTime();
        $client_id = "c-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        $client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);

        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_CLIENT . " (client_id,client_name,client_key) values ('$client_id','$data','$client_key')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["client_key"] = $client_key;
            $result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }
    if ($action == "add_party"){
        $update_time = getCurrentTime();
        $party_id = "p-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        $name = json_decode($data,true);
        $l = $name["l"];
        $s = $name["s"];

        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_PARTY . " (party_id,long_name,short_name,update_time) values ('$party_id','$l','$s','$update_time')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["party_id"] = $party_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=add_election_cycle&data=
    if ($action == "add_election_cycle"){
        $election_type = "gen_election";
        $update_time = getCurrentTime();
        $election_id = "e-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $cands = json_decode($data,true);
        $f = $cands["f"];
        $s = $cands["s"];
        $y = $cands["year"];

        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_ELECTION . " (election_id,candidate_1_id,candidate_2_id,update_time,election_year,election_type) values ('$election_id','$f','$s','$update_time','$y','$election_type')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["election_id"] = $election_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }
    if ($action == "import_constituency_list_DONE"){
        $constituency = '
        {
    "election_year": "2016",
    "election_month": "2",
    "election_day": "25",
    "prime_pnp": {
        "fname": "Portia",
        "lname": "Simpson-Miller"
    },
    "prime_jlp": {
        "fname": "Andrew",
        "lname": "Holness"
    },
    "constituencies": {
        "1": {
            "name": "KINGSTON WESTERN",
            "number": "1",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "DENHAM TOWN",
                    "number": "1"
                },
                "2": {
                    "name": "TIVOLI GARDENS",
                    "number": "2"
                }
            }
        },
        "2": {
            "name": "KINGSTON CENTRAL",
            "number": "2",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "3": {
                    "name": "ALLMAN TOWN",
                    "number": "3"
                },
                "4": {
                    "name": "RAE TOWN",
                    "number": "4"
                }
            }
        },
        "3": {
            "name": "KINGSTON EAST & PORT ROYAL",
            "number": "3",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "NORMAN GARDENS",
                    "number": "5"
                },
                "6": {
                    "name": "SPRINGFIELD",
                    "number": "6"
                }
            }
        },
        "4": {
            "name": "ST. ANDREW WEST RURAL",
            "number": "4",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "7": {
                    "name": "LAWRENCE TAVERN",
                    "number": "7"
                },
                "8": {
                    "name": "BRANDON HILL",
                    "number": "8"
                },
                "9": {
                    "name": "STONY HILL",
                    "number": "9"
                },
                "10": {
                    "name": "RED HILLS",
                    "number": "10"
                }
            }
        },
        "5": {
            "name": "ST. ANDREW WESTERN",
            "number": "5",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "11": {
                    "name": "DUHANEY PARK",
                    "number": "11"
                },
                "12": {
                    "name": "WATERHOUSE",
                    "number": "12"
                },
                "13": {
                    "name": "SEAVIEW GARDENS",
                    "number": "13"
                }
            }
        },
        "6": {
            "name": "ST. ANDREW WEST CENTRAL",
            "number": "6",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "14": {
                    "name": "MOLYNES GARDENS",
                    "number": "14"
                },
                "15": {
                    "name": "OLYMPIC GARDENS",
                    "number": "15"
                },
                "16": {
                    "name": "SEIVWRIGHT GARDENS",
                    "number": "16"
                }
            }
        },
        "7": {
            "name": "ST. ANDREW EAST CENTRAL",
            "number": "7",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "17": {
                    "name": "CASSIA PARK",
                    "number": "17"
                },
                "18": {
                    "name": "HAGLEY PARK",
                    "number": "18"
                },
                "19": {
                    "name": "MAXFIELD PARK",
                    "number": "19"
                }
            }
        },
        "8": {
            "name": "ST. ANDREW SOUTH WESTERN",
            "number": "8",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "20": {
                    "name": "WHITFIELD TOWN",
                    "number": "20"
                },
                "21": {
                    "name": "PAYNE LANDS",
                    "number": "21"
                },
                "22": {
                    "name": "GREENWICH TOWN",
                    "number": "22"
                }
            }
        },
        "9": {
            "name": "ST. ANDREW SOUTHERN",
            "number": "9",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "23": {
                    "name": "TRENCH TOWN",
                    "number": "23"
                },
                "24": {
                    "name": "ADMIRAL TOWN",
                    "number": "24"
                }
            }
        },
        "10": {
            "name": "ST. ANDREW SOUTH EASTERN",
            "number": "10",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "25": {
                    "name": "TRAFALGAR",
                    "number": "25"
                },
                "26": {
                    "name": "VINEYARD TOWN",
                    "number": "26"
                }
            }
        },
        "11": {
            "name": "ST. ANDREW EASTERN",
            "number": "11",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "27": {
                    "name": "MONA",
                    "number": "27"
                },
                "28": {
                    "name": "PAPINE",
                    "number": "28"
                }
            }
        },
        "12": {
            "name": "ST. ANDREW NORTH EASTERN",
            "number": "12",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "29": {
                    "name": "BARBICAN",
                    "number": "29"
                },
                "30": {
                    "name": "WATERLOO",
                    "number": "30"
                }
            }
        },
        "13": {
            "name": "ST. ANDREW NORTH CENTRAL",
            "number": "13",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "31": {
                    "name": "WHITEHALL",
                    "number": "31"
                },
                "32": {
                    "name": "NORBROOK",
                    "number": "32"
                }
            }
        },
        "14": {
            "name": "ST. ANDREW NORTH WESTERN",
            "number": "14",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "33": {
                    "name": "HAVENDALE",
                    "number": "33"
                },
                "34": {
                    "name": "HUGHENDEN",
                    "number": "34"
                },
                "35": {
                    "name": "CHANCERY HALL",
                    "number": "35"
                }
            }
        },
        "15": {
            "name": "ST. ANDREW EAST RURAL",
            "number": "15",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "36": {
                    "name": "GORDON TOWN",
                    "number": "36"
                },
                "37": {
                    "name": "MAVIS BANK",
                    "number": "37"
                },
                "38": {
                    "name": "DALLAS",
                    "number": "38"
                },
                "39": {
                    "name": "HARBOUR VIEW",
                    "number": "39"
                },
                "40": {
                    "name": "KINTYRE",
                    "number": "40"
                }
            }
        },
        "16": {
            "name": "ST. THOMAS WESTERN",
            "number": "16",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "CEDAR VALLEY",
                    "number": "1"
                },
                "2": {
                    "name": "LLANDEWEY",
                    "number": "2"
                },
                "3": {
                    "name": "YALLAHS",
                    "number": "3"
                },
                "4": {
                    "name": "TRINITYVILLE",
                    "number": "4"
                },
                "5": {
                    "name": "SEAFORTH",
                    "number": "5"
                },
                "6": {
                    "name": "WHITE HORSES",
                    "number": "6"
                }
            }
        },
        "17": {
            "name": "ST. THOMAS EASTERN",
            "number": "17",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "7": {
                    "name": "BATH",
                    "number": "7"
                },
                "8": {
                    "name": "DALVEY",
                    "number": "8"
                },
                "9": {
                    "name": "PORT MORANT",
                    "number": "9"
                },
                "10": {
                    "name": "MORANT BAY",
                    "number": "10"
                }
            }
        },
        "18": {
            "name": "PORTLAND EASTERN",
            "number": "18",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "PORT ANTONIO",
                    "number": "1"
                },
                "2": {
                    "name": "PROSPECT",
                    "number": "2"
                },
                "3": {
                    "name": "FAIRY HILL",
                    "number": "3"
                },
                "4": {
                    "name": "MANCHIONEAL",
                    "number": "4"
                },
                "5": {
                    "name": "FELLOWSHIP",
                    "number": "5"
                }
            }
        },
        "19": {
            "name": "PORTLAND WESTERN",
            "number": "19",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "6": {
                    "name": "ST. MARGARETS BAY",
                    "number": "6"
                },
                "7": {
                    "name": "HOPE BAY",
                    "number": "7"
                },
                "8": {
                    "name": "BUFF BAY",
                    "number": "8"
                },
                "9": {
                    "name": "BALCARRES",
                    "number": "9"
                }
            }
        },
        "20": {
            "name": "ST. MARY SOUTH EASTERN",
            "number": "20",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "RICHMOND",
                    "number": "1"
                },
                "2": {
                    "name": "CASTLETON",
                    "number": "2"
                },
                "3": {
                    "name": "BELFIELD",
                    "number": "3"
                },
                "4": {
                    "name": "ANNOTTO BAY",
                    "number": "4"
                }
            }
        },
        "21": {
            "name": "ST. MARY CENTRAL",
            "number": "21",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "ISLINGTON",
                    "number": "5"
                },
                "6": {
                    "name": "PORT MARIA",
                    "number": "6"
                },
                "7": {
                    "name": "HAMPSTEAD",
                    "number": "7"
                },
                "8": {
                    "name": "HIGHGATE",
                    "number": "8"
                }
            }
        },
        "22": {
            "name": "ST. MARY WESTERN",
            "number": "22",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "9": {
                    "name": "CARRON HALL",
                    "number": "9"
                },
                "10": {
                    "name": "GAYLE",
                    "number": "10"
                },
                "11": {
                    "name": "ORACABESSA",
                    "number": "11"
                },
                "12": {
                    "name": "BOSCOBEL",
                    "number": "12"
                },
                "13": {
                    "name": "RETREAT",
                    "number": "13"
                }
            }
        },
        "23": {
            "name": "ST. ANN SOUTH EASTERN",
            "number": "23",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "MONEAGUE",
                    "number": "1"
                },
                "2": {
                    "name": "BENSONTON",
                    "number": "2"
                },
                "3": {
                    "name": "CLAREMONT",
                    "number": "3"
                },
                "4": {
                    "name": "BEECHER TOWN",
                    "number": "4"
                }
            }
        },
        "24": {
            "name": "ST. ANN NORTH EASTERN",
            "number": "24",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "EXCHANGE",
                    "number": "5"
                },
                "6": {
                    "name": "OCHO RIOS",
                    "number": "6"
                },
                "7": {
                    "name": "LIME HALL",
                    "number": "7"
                },
                "8": {
                    "name": "ST. ANNS BAY",
                    "number": "8"
                }
            }
        },
        "25": {
            "name": "ST. ANN NORTH WESTERN",
            "number": "25",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "9": {
                    "name": "BAMBOO",
                    "number": "9"
                },
                "10": {
                    "name": "STURGE TOWN",
                    "number": "10"
                },
                "11": {
                    "name": "DRY HARBOUR",
                    "number": "11"
                },
                "12": {
                    "name": "BROWNS TOWN",
                    "number": "12"
                }
            }
        },
        "26": {
            "name": "ST. ANN SOUTH WESTERN",
            "number": "26",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "13": {
                    "name": "GIBRALTAR",
                    "number": "13"
                },
                "14": {
                    "name": "ALEXANDRIA",
                    "number": "14"
                },
                "15": {
                    "name": "CALDERWOOD",
                    "number": "15"
                },
                "16": {
                    "name": "BOROBRIDGE",
                    "number": "16"
                }
            }
        },
        "27": {
            "name": "TRELAWNY NORTHERN",
            "number": "27",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "MARTHA BRAE",
                    "number": "1"
                },
                "2": {
                    "name": "FALMOUTH",
                    "number": "2"
                },
                "3": {
                    "name": "DUNCANS",
                    "number": "3"
                },
                "4": {
                    "name": "SHERWOOD CONTENT",
                    "number": "4"
                },
                "5": {
                    "name": "WAKEFIELD",
                    "number": "5"
                }
            }
        },
        "28": {
            "name": "TRELAWNY SOUTHERN",
            "number": "28",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "6": {
                    "name": "LORRIMERS",
                    "number": "6"
                },
                "7": {
                    "name": "WARSOP",
                    "number": "7"
                },
                "8": {
                    "name": "ALBERT TOWN",
                    "number": "8"
                },
                "9": {
                    "name": "ULSTER SPRING",
                    "number": "9"
                }
            }
        },
        "29": {
            "name": "ST. JAMES EAST CENTRAL",
            "number": "29",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "ROSE HALL",
                    "number": "1"
                },
                "2": {
                    "name": "SOMERTON",
                    "number": "2"
                },
                "3": {
                    "name": "SPRING MOUNT",
                    "number": "3"
                }
            }
        },
        "30": {
            "name": "ST. JAMES NORTH WESTERN",
            "number": "30",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "4": {
                    "name": "MONTEGO BAY NORTH EASTERN",
                    "number": "4"
                },
                "5": {
                    "name": "MONTEGO BAY CENTRAL",
                    "number": "5"
                },
                "6": {
                    "name": "MONTEGO BAY NORTH",
                    "number": "6"
                },
                "7": {
                    "name": "MONTEGO BAY WEST",
                    "number": "7"
                }
            }
        },
        "31": {
            "name": "ST. JAMES CENTRAL",
            "number": "31",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "8": {
                    "name": "MONTEGO BAY SOUTH",
                    "number": "8"
                },
                "9": {
                    "name": "MONTEGO BAY SOUTH EAST",
                    "number": "9"
                },
                "10": {
                    "name": "SALT SPRING",
                    "number": "10"
                }
            }
        },
        "32": {
            "name": "ST. JAMES WEST CENTRAL",
            "number": "32",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "11": {
                    "name": "MOUNT SALEM",
                    "number": "11"
                },
                "12": {
                    "name": "GRANVILLE",
                    "number": "12"
                },
                "13": {
                    "name": "SPRING GARDEN",
                    "number": "13"
                }
            }
        },
        "33": {
            "name": "ST. JAMES SOUTHERN",
            "number": "33",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "14": {
                    "name": "CAMBRIDGE",
                    "number": "14"
                },
                "15": {
                    "name": "WELCOME HALL",
                    "number": "15"
                },
                "16": {
                    "name": "MAROON TOWN",
                    "number": "16"
                },
                "17": {
                    "name": "CATADUPA",
                    "number": "17"
                }
            }
        },
        "34": {
            "name": "HANOVER EASTERN",
            "number": "34",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "CHESTER CASTLE",
                    "number": "1"
                },
                "2": {
                    "name": "HOPEWELL",
                    "number": "2"
                },
                "3": {
                    "name": "SANDY BAY",
                    "number": "3"
                }
            }
        },
        "35": {
            "name": "HANOVER WESTERN",
            "number": "35",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "4": {
                    "name": "LUCEA",
                    "number": "4"
                },
                "5": {
                    "name": "RIVERSIDE",
                    "number": "5"
                },
                "6": {
                    "name": "CAULDWELL",
                    "number": "6"
                },
                "7": {
                    "name": "GREEN ISLAND",
                    "number": "7"
                }
            }
        },
        "36": {
            "name": "WESTMORELAND WESTERN",
            "number": "36",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "NEGRIL",
                    "number": "1"
                },
                "2": {
                    "name": "SHEFFIELD",
                    "number": "2"
                },
                "3": {
                    "name": "LITTLE LONDON",
                    "number": "3"
                },
                "4": {
                    "name": "GRANGE HILL",
                    "number": "4"
                },
                "5": {
                    "name": "FRIENDSHIP",
                    "number": "5"
                }
            }
        },
        "37": {
            "name": "WESTMORELAND CENTRAL",
            "number": "37",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "6": {
                    "name": "PETERSFIELD",
                    "number": "6"
                },
                "7": {
                    "name": "FROME",
                    "number": "7"
                },
                "8": {
                    "name": "SAVANNALAMAR NORTH",
                    "number": "8"
                },
                "9": {
                    "name": "SAVANNALAMAR",
                    "number": "9"
                },
                "10": {
                    "name": "CORNWALL MOUNTAIN",
                    "number": "10"
                }
            }
        },
        "38": {
            "name": "WESTMORELAND EASTERN",
            "number": "38",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "11": {
                    "name": "BETHEL TOWN",
                    "number": "11"
                },
                "12": {
                    "name": "LEAMINGTON",
                    "number": "12"
                },
                "13": {
                    "name": "DARLISTON",
                    "number": "13"
                },
                "14": {
                    "name": "WHITEHOUSE",
                    "number": "14"
                }
            }
        },
        "39": {
            "name": "ST. ELIZABETH NORTH WESTERN",
            "number": "39",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "NEW MARKET",
                    "number": "1"
                },
                "2": {
                    "name": "IPSWICH",
                    "number": "2"
                },
                "3": {
                    "name": "LACOVIA",
                    "number": "3"
                }
            }
        },
        "40": {
            "name": "ST. ELIZABETH NORTH EASTERN",
            "number": "40",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "4": {
                    "name": "BALACLAVA",
                    "number": "4"
                },
                "5": {
                    "name": "SILOAH",
                    "number": "5"
                },
                "6": {
                    "name": "BRAES RIVER",
                    "number": "6"
                },
                "7": {
                    "name": "SANTA CRUZ",
                    "number": "7"
                }
            }
        },
        "41": {
            "name": "ST. ELIZABETH SOUTH WESTERN",
            "number": "41",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "8": {
                    "name": "BROMPTON",
                    "number": "8"
                },
                "9": {
                    "name": "BLACK RIVER",
                    "number": "9"
                },
                "10": {
                    "name": "MOUNTAINSIDE",
                    "number": "10"
                },
                "11": {
                    "name": "PEDRO PLAINS",
                    "number": "11"
                }
            }
        },
        "42": {
            "name": "ST. ELIZABETH SOUTH EASTERN",
            "number": "42",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "12": {
                    "name": "MALVERN",
                    "number": "12"
                },
                "13": {
                    "name": "MYERSVILLE",
                    "number": "13"
                },
                "14": {
                    "name": "SOUTHFIELD",
                    "number": "14"
                },
                "15": {
                    "name": "JUNCTION",
                    "number": "15"
                }
            }
        },
        "43": {
            "name": "MANCHESTER SOUTHERN",
            "number": "43",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "PORUS",
                    "number": "1"
                },
                "2": {
                    "name": "GROVE TOWN",
                    "number": "2"
                },
                "3": {
                    "name": "ALLIGATOR POND",
                    "number": "3"
                },
                "4": {
                    "name": "NEWPORT",
                    "number": "4"
                }
            }
        },
        "44": {
            "name": "MANCHESTER CENTRAL",
            "number": "44",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "KNOCKPATRICK",
                    "number": "5"
                },
                "6": {
                    "name": "MANDEVILLE",
                    "number": "6"
                },
                "7": {
                    "name": "ROYAL FLAT",
                    "number": "7"
                },
                "8": {
                    "name": "BELLEFIELD",
                    "number": "8"
                }
            }
        },
        "45": {
            "name": "MANCHESTER NORTH WESTERN",
            "number": "45",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "9": {
                    "name": "SPUR TREE",
                    "number": "9"
                },
                "10": {
                    "name": "NEW GREEN",
                    "number": "10"
                },
                "11": {
                    "name": "JOHNS HALL",
                    "number": "11"
                },
                "12": {
                    "name": "MILE GULLY",
                    "number": "12"
                }
            }
        },
        "46": {
            "name": "MANCHESTER NORTH EASTERN",
            "number": "46",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "13": {
                    "name": "CRAIGHEAD",
                    "number": "13"
                },
                "14": {
                    "name": "CHRISTIANA",
                    "number": "14"
                },
                "15": {
                    "name": "WALDERSTON",
                    "number": "15"
                }
            }
        },
        "47": {
            "name": "CLARENDON NORTH WESTERN",
            "number": "47",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "SPALDING",
                    "number": "1"
                },
                "2": {
                    "name": "RITCHIES",
                    "number": "2"
                },
                "3": {
                    "name": "FRANKFIELD",
                    "number": "3"
                },
                "4": {
                    "name": "THOMPSON TOWN",
                    "number": "4"
                }
            }
        },
        "48": {
            "name": "CLARENDON NORTHERN",
            "number": "48",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "AENON TOWN",
                    "number": "5"
                },
                "6": {
                    "name": "KELLITS",
                    "number": "6"
                },
                "7": {
                    "name": "CROFTS HILL",
                    "number": "7"
                }
            }
        },
        "49": {
            "name": "CLARENDON NORTH CENTRAL",
            "number": "49",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "8": {
                    "name": "CHAPELTON",
                    "number": "8"
                },
                "9": {
                    "name": "ROCK RIVER",
                    "number": "9"
                },
                "10": {
                    "name": "MOCHO",
                    "number": "10"
                }
            }
        },
        "50": {
            "name": "CLARENDON CENTRAL",
            "number": "50",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "11": {
                    "name": "MAY PEN NORTH",
                    "number": "11"
                },
                "12": {
                    "name": "DENBIGH",
                    "number": "12"
                },
                "13": {
                    "name": "MAY PEN EAST",
                    "number": "13"
                },
                "14": {
                    "name": "MAY PEN WEST",
                    "number": "14"
                }
            }
        },
        "51": {
            "name": "CLARENDON SOUTH WESTERN",
            "number": "51",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "15": {
                    "name": "TOLL GATE",
                    "number": "15"
                },
                "16": {
                    "name": "YORK TOWN",
                    "number": "16"
                },
                "17": {
                    "name": "MILK RIVER",
                    "number": "17"
                },
                "18": {
                    "name": "RACE COURSE",
                    "number": "18"
                }
            }
        },
        "52": {
            "name": "CLARENDON SOUTH EASTERN",
            "number": "52",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "19": {
                    "name": "PALMERS CROSS",
                    "number": "19"
                },
                "20": {
                    "name": "MINERAL HEIGHTS",
                    "number": "20"
                },
                "21": {
                    "name": "HAYES",
                    "number": "21"
                },
                "22": {
                    "name": "ROCKY POINT",
                    "number": "22"
                }
            }
        },
        "53": {
            "name": "ST. CATHERINE NORTH WESTERN",
            "number": "53",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "1": {
                    "name": "LLUIDAS VALE",
                    "number": "1"
                },
                "2": {
                    "name": "EWARTON",
                    "number": "2"
                },
                "3": {
                    "name": "TREADWAYS",
                    "number": "3"
                },
                "4": {
                    "name": "LINSTEAD",
                    "number": "4"
                }
            }
        },
        "54": {
            "name": "ST. CATHERINE SOUTH WESTERN",
            "number": "54",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "5": {
                    "name": "OLD HARBOUR NORTH",
                    "number": "5"
                },
                "6": {
                    "name": "OLD HARBOUR CENTRAL",
                    "number": "6"
                },
                "7": {
                    "name": "OLD HARBOUR SOUTH",
                    "number": "7"
                },
                "8": {
                    "name": "CHURCH PEN",
                    "number": "8"
                }
            }
        },
        "55": {
            "name": "ST. CATHERINE SOUTHERN",
            "number": "55",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "9": {
                    "name": "GREATER PORTMORE NORTH",
                    "number": "9"
                },
                "10": {
                    "name": "BRAETON",
                    "number": "10"
                },
                "11": {
                    "name": "GREATER PORTMORE EAST",
                    "number": "11"
                },
                "12": {
                    "name": "HELLSHIRE",
                    "number": "12"
                }
            }
        },
        "56": {
            "name": "ST. CATHERINE CENTRAL",
            "number": "56",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "13": {
                    "name": "ENSOM CITY",
                    "number": "13"
                },
                "14": {
                    "name": "HAMPTON GREEN",
                    "number": "14"
                },
                "15": {
                    "name": "SPANISH TOWN",
                    "number": "15"
                }
            }
        },
        "57": {
            "name": "ST. CATHERINE SOUTH EASTERN",
            "number": "57",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "16": {
                    "name": "WATERFORD",
                    "number": "16"
                },
                "17": {
                    "name": "INDEPENDENCE CITY",
                    "number": "17"
                },
                "18": {
                    "name": "WESTCHESTER",
                    "number": "18"
                },
                "19": {
                    "name": "EDGEWATER",
                    "number": "19"
                },
                "20": {
                    "name": "BRIDGEPORT",
                    "number": "20"
                }
            }
        },
        "58": {
            "name": "ST. CATHERINE NORTH CENTRAL",
            "number": "58",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "21": {
                    "name": "BOG WALK",
                    "number": "21"
                },
                "22": {
                    "name": "SLIGOVILLE",
                    "number": "22"
                },
                "23": {
                    "name": "ABOVE ROCKS",
                    "number": "23"
                },
                "24": {
                    "name": "ANGELS",
                    "number": "24"
                }
            }
        },
        "59": {
            "name": "ST. CATHERINE WEST CENTRAL",
            "number": "59",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "25": {
                    "name": "GINGER RIDGE",
                    "number": "25"
                },
                "26": {
                    "name": "POINT HILL",
                    "number": "26"
                },
                "27": {
                    "name": "RED HILLS",
                    "number": "27"
                },
                "28": {
                    "name": "BELLEVUE",
                    "number": "28"
                }
            }
        },
        "60": {
            "name": "ST. CATHERINE NORTH EASTERN",
            "number": "60",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "29": {
                    "name": "GUYS HILL",
                    "number": "29"
                },
                "30": {
                    "name": "TROJA",
                    "number": "30"
                },
                "31": {
                    "name": "MOUNT INDUSTRY",
                    "number": "31"
                }
            }
        },
        "61": {
            "name": "ST. CATHERINE EASTERN",
            "number": "61",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "32": {
                    "name": "GREENDALE",
                    "number": "32"
                },
                "33": {
                    "name": "LAURISTON",
                    "number": "33"
                },
                "34": {
                    "name": "DE LA VEGA CITY",
                    "number": "34"
                },
                "35": {
                    "name": "TWICKENHAM PARK",
                    "number": "35"
                }
            }
        },
        "62": {
            "name": "ST. CATHERINE SOUTH CENTRAL",
            "number": "62",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "36": {
                    "name": "HOMESTEAD",
                    "number": "36"
                },
                "37": {
                    "name": "SYDENHAM",
                    "number": "37"
                },
                "38": {
                    "name": "HORIZON PARK",
                    "number": "38"
                }
            }
        },
        "63": {
            "name": "ST. CATHERINE EAST CENTRAL",
            "number": "63",
            "pnp_candidate": {
                "fname": "",
                "lname": ""
            },
            "jlp_candidate": {
                "fname": "",
                "lname": ""
            },
            "divisions": {
                "39": {
                    "name": "GREGORY PARK",
                    "number": "39"
                },
                "40": {
                    "name": "SOUTHBORO",
                    "number": "40"
                },
                "41": {
                    "name": "PORTMORE PINES",
                    "number": "41"
                }
            }
        }
    }
}';



        $constituency_obj = json_decode($constituency, true);
        $constituency_data = $constituency_obj["constituencies"];


        $election_type = "gen_election";
        $update_time = getCurrentTime();
        $election_id = "e-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


        $result["status"] = STATUS_ERROR;

        foreach ($constituency_data as $constituency_item) {
            $con_id = "cid-" . getRandomString(10) . getRandomString(10) . getRandomNumber(5);
            $con_name = stringCase($constituency_item["name"]);
            $con_number = $constituency_item["number"];

            echo $con_name . " (" . $con_number . ") " . " (" . $con_id . ")<br>";

            $add_query = "insert into " . TABLE_CONSTITUENCY . " (constituency_id,constituency_name,constituency_number) values ('$con_id','$con_name','$con_number')";
            $add_result = $paperweight->query($add_query);

            if($add_result != null && $add_result->is_row_affected()){

                //$result["election_id"] = $candidate_id;
                //$result["client_id"] = $client_id;
                //$result["url"] = "";
                //$result["status"] = STATUS_OK;

                foreach ($constituency_item["divisions"] as $division_item){
                    $div_id = "did-" . getRandomString(10) . getRandomString(10) . getRandomNumber(5);
                    $div_name = stringCase($division_item["name"]);
                    $div_number = $division_item["number"];

                    $sub_query = "insert into " . TABLE_DIVISION . " (division_id,division_name,division_number,constituency_id) values ('$div_id','$div_name','$div_number','$con_id')";
                    $sub_result = $paperweight->query($sub_query);

                    echo "&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp" . $div_name . " (" . $div_number . ")" . " (" . $div_id . ")" . " (" . $con_id . ")<br>";
                }

            }



        }



    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=add_candidate&data=
    if ($action == "add_candidate"){
        $update_time = getCurrentTime();
        $candidate_id = "c-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $name = json_decode($data,true);
        $f = $name["f"];
        $l = $name["l"];

        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_CANDIDATE . " (candidate_id,first_name,last_name,update_time) values ('$candidate_id','$f','$l','$update_time')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["candidate_id"] = $candidate_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }
    if ($action == "add_party_relationship"){
        $update_time = getCurrentTime();
        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $cands = json_decode($data,true);
        $candidate_id = $cands["candidate"];
        $party_id = $cands["party"];


        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_PARTY_REL . " (relationship_id,candidate_id,party_id,update_time) values ('$relationship_id','$candidate_id','$party_id','$update_time')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["can_id"] = $candidate_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }
    if ($action == "add_constituency_relationship"){
        //{ "candidate": "","constituency":""}
        $update_time = getCurrentTime();
        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $cands = json_decode($data,true);
        $candidate_id = $cands["candidate"];
        $constituency_id = $cands["constituency"];



        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_CONSTITUENCY_REL . " (relationship_id,candidate_id,constituency_id,update_time) values ('$relationship_id','$candidate_id','$constituency_id','$update_time')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["can_id"] = $candidate_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=add_election_relationship&data=
    if ($action == "add_election_relationship"){
        //{ "candidate": "","party":"","constituency":"","election_id":""}
        $update_time = getCurrentTime();
        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $cands = json_decode($data,true);
        $candidate_id = $cands["candidate"];
        $constituency_id = $cands["constituency"];
        $party_id = $cands["party"];
        $election_id = $cands["election_id"];


        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_ELECTION_REL . " (relationship_id,candidate_id,party_id,constituency_id,update_time,election_id) values ('$relationship_id','$candidate_id','$party_id','$constituency_id','$update_time','$election_id')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            $result["can_id"] = $candidate_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

        echo json_encode($result);

    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=parse_candidates&param_json={"year":"2016","client_key":"c-NwS3Ft2KRK.1vydOhnWn010821"}
    if ($action == "parse_candidates"){
        $cred = json_decode($param_json,true);
        $client_key = $cred["client_key"];
        $year = $cred["year"];

        $CONSTITUENCY = array();
        //$CONSTITUENCY["id"] = "";
        //$CONSTITUENCY["p-s1kKhpJVx1.F1RiIeHAtX68677"]["fname"] = ""; //pnp
        //$CONSTITUENCY["p-s1kKhpJVx1.F1RiIeHAtX68677"]["lname"] = ""; //pnp
        //$CONSTITUENCY["p-mttXACloIy.2BAWR4ylAh84950"]["fname"] = ""; //jlp
        //$CONSTITUENCY["p-mttXACloIy.2BAWR4ylAh84950"]["fname"] = ""; //jlp



        $election_data = getElectionDetailByYear($year,$paperweight);

        $election_id = $election_data["election_id"];
        $file_path = $cred["path"];
        //$file_path = "testdata/DTL20190624182806.txt";
        $file_path = "testdata/GENERAL_ELECTION_2016.txt";

        $fn = fopen($file_path,"r");
        $line_index = 0;

        while(! feof($fn))  {
            $result = fgets($fn);

            if($line_index != 0){
                //echo $result . '<br>';

                $line_array = getResultArray($result);
                $ballot_detail = generateBallot($line_array,$election_id,$client_key,$paperweight);

                //updateBallot($ballot,$paperweight);

                //echo $result . "<br><br>";

                //echo json_encode($ballot_detail) . "<br><br>";
                //if($line_index > 0){
                //    break;
                //}
                $constituency_id = $ballot_detail["constituency_id"];
                $party_id = $ballot_detail["party_id"];
                $fname = $line_array["party_candidate_fname"];
                $lname = $line_array["party_candidate_lname"];


                $CONSTITUENCY[$constituency_id]["id"] = $constituency_id;
                if($party_id == "p-s1kKhpJVx1.F1RiIeHAtX68677"){
                    //pnp
                    $CONSTITUENCY[$constituency_id]["pnp"]["party_ip"] = $party_id;
                    $CONSTITUENCY[$constituency_id]["pnp"]["fname"] = stringCase($fname);
                    $CONSTITUENCY[$constituency_id]["pnp"]["lname"] = stringCase($lname);
                }
                else if($party_id == "p-mttXACloIy.2BAWR4ylAh84950"){
                    //jlp
                    $CONSTITUENCY[$constituency_id]["jlp"]["party_ip"] = $party_id;
                    $CONSTITUENCY[$constituency_id]["jlp"]["fname"] = stringCase($fname);
                    $CONSTITUENCY[$constituency_id]["jlp"]["lname"] = stringCase($lname);
                }

            }

            $line_index++;


            //echo json_encode(getResultArray($result));



        }
        //echo $line_index ."<br>";

        //echo json_encode($CONSTITUENCY);

        fclose($fn);

        foreach ($CONSTITUENCY as $constituency_item) {
            $con_id = $constituency_item["id"];
            $pnp_data = $constituency_item["pnp"];
            $jlp_data = $constituency_item["jlp"];

            if($con_id == ""){
                break;
            }

            $update_time = getCurrentTime();

            $candidate_id1 = "c-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
            $candidate_id2 = "c-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);



            if ((($pnp_data["fname"] != "peter d.") && ($pnp_data["lname"] != "phillips")) || (($pnp_data["fname"] != "portia") && ($pnp_data["lname"] != "simpson miller"))){
                $fn = $pnp_data["fname"];
                $ln = $pnp_data["lname"];

                echo json_encode($pnp_data) . "<br>";

                $add_query1 = "insert into " . TABLE_CANDIDATE . " (candidate_id,first_name,last_name,update_time) values ('$candidate_id1','$fn','$ln','$update_time')";
                //$add_result1 = $paperweight->query($add_query1);
                $add_result1 = null;
                if($add_result1 != null && $add_result1->is_row_affected()){

                    $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
                    $party_id = $pnp_data["party_ip"];

                    $rel_query1 = "insert into " . TABLE_PARTY_REL . " (relationship_id,candidate_id,party_id,update_time) values ('$relationship_id','$candidate_id1','$party_id','$update_time')";
                    $rel_result1 = $paperweight->query($rel_query1);


                    if($rel_result1 != null && $rel_result1->is_row_affected()){

                        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                        $con_query = "insert into " . TABLE_CONSTITUENCY_REL . " (relationship_id,candidate_id,constituency_id,update_time) values ('$relationship_id','$candidate_id1','$con_id','$update_time')";
                        $con_result = $paperweight->query($con_query);
                        if($con_result != null && $con_result->is_row_affected()){

                            $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                            $election_query = "insert into " . TABLE_ELECTION_REL . " (relationship_id,candidate_id,party_id,constituency_id,update_time,election_id) values ('$relationship_id','$candidate_id1','$party_id','$con_id','$update_time','$election_id')";
                            $election_result = $paperweight->query($election_query);
                            if($election_result != null && $election_result->is_row_affected()){


                                $result["status"] = STATUS_OK;

                            }


                        }

                    }


                }
            }

            if(($jlp_data["fname"] != "andrew m.") && ($jlp_data["lname"] != "holness")){
                $fn = $jlp_data["fname"];
                $ln = $jlp_data["lname"];



                echo json_encode($jlp_data) . "<br>";

                $add_query2 = "insert into " . TABLE_CANDIDATE . " (candidate_id,first_name,last_name,update_time) values ('$candidate_id2','$fn','$ln','$update_time')";
                //$add_result2 = $paperweight->query($add_query2);
                $add_result2 = null;
                if($add_result2 != null && $add_result2->is_row_affected()){

                    $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
                    $party_id = $jlp_data["party_ip"];

                    $rel_query2 = "insert into " . TABLE_PARTY_REL . " (relationship_id,candidate_id,party_id,update_time) values ('$relationship_id','$candidate_id2','$party_id','$update_time')";
                    $rel_result2 = $paperweight->query($rel_query2);


                    if($rel_result2 != null && $rel_result2->is_row_affected()){

                        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                        $con_query = "insert into " . TABLE_CONSTITUENCY_REL . " (relationship_id,candidate_id,constituency_id,update_time) values ('$relationship_id','$candidate_id2','$con_id','$update_time')";
                        $con_result = $paperweight->query($con_query);
                        if($con_result != null && $con_result->is_row_affected()){

                            $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                            $election_query = "insert into " . TABLE_ELECTION_REL . " (relationship_id,candidate_id,party_id,constituency_id,update_time,election_id) values ('$relationship_id','$candidate_id2','$party_id','$con_id','$update_time','$election_id')";
                            $election_result = $paperweight->query($election_query);
                            if($election_result != null && $election_result->is_row_affected()){


                                $result["status"] = STATUS_OK;

                            }


                        }

                    }


                }
            }

        }

        //echo json_encode(getDivisionByNumber(1,1,$paperweight));
        //echo json_encode(getPartyByName("jlp",$paperweight));


        //echo $election_data["election_id"];


    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=parse_results&param_json={%22year%22:%222020%22,%22client_key%22:%22c-NwS3Ft2KRK.1vydOhnWn010821%22}
    if ($action == "parse_results"){
        $cred = json_decode($param_json,true);
        $client_key = $cred["client_key"];
        $year = $cred["year"];

        //echo $client_key;
        //echo $year;
        //echo "test";

        $election_data = getElectionDetailByYear($year,$paperweight);

        $election_id = $election_data["election_id"];
        $file_path = $cred["path"];
        //$file_path = "testdata/DTL20200903174100.txt";
        //$file_path = "testdata/DTL20200903175040.txt";
        //$file_path = "testdata/DTL20200903222440.txt";
        //$file_path = "testdata/t.txt";
        $file_path = "testdata/CURRENT_ELECTION.txt";
        //$file_path = "testdata/GENERAL_ELECTION_2016.txt";

        $fn = fopen($file_path,"r");
        $line_index = 0;

        $entry = 0;


        //1000
        //280

        while(! feof($fn))  {
            $result = fgets($fn);

            if($line_index != 0){
                //echo $result . '<br>';

                $line_array = getResultArray($result);
                $ballot = generateBallot($line_array,$election_id,$client_key,$paperweight);

                if($entry >= 1000){
                    $entry = 0;


                    sleep(20);
                }

                updateBallot($ballot,$paperweight);

                //echo $result . "<br><br>";

                //echo json_encode(getResultArray($result));
                //if($line_index > 0){
                //    break;
                //}

            }



            $line_index++;
            $entry++;


            //echo json_encode(getResultArray($result));



        }
        echo $line_index;

        fclose($fn);

        //echo json_encode(getDivisionByNumber(1,1,$paperweight));
        //echo json_encode(getPartyByName("jlp",$paperweight));


        //echo $election_data["election_id"];


    }

    //link candidate to 2020 election
    if ($action == "set_2020_candidate"){

        $update_time = getCurrentTime();
        $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
        //$client_key = "c-" . getRandomString(9) . "." . getRandomString(9) . getRandomNumber(5);
        $cands = json_decode($param_json,true);
        $candidate_id = $cands["candidate_id"];
        $constituency_id = $cands["constituency_id"];
        $party_id = $cands["party_id"];
        $election_id = $cands["election_id"];


        $result["status"] = STATUS_ERROR;


        $add_query = "insert into " . TABLE_ELECTION_REL . " (relationship_id,candidate_id,party_id,constituency_id,update_time,election_id) values ('$relationship_id','$candidate_id','$party_id','$constituency_id','$update_time','$election_id')";
        $add_result = $paperweight->query($add_query);
        if($add_result != null && $add_result->is_row_affected()){

            //$result["can_id"] = $candidate_id;
            //$result["client_id"] = $client_id;
            //$result["url"] = "";
            $result["status"] = STATUS_OK;

        }

    }

    //CREATE candidate; link them to party, link them to constituency, link them to election
    if ($action == "setup_candidate_2020"){
        $candidate_id1 = "c-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);

        $update_time = getCurrentTime();
        $cands = json_decode($param_json,true);

        $constituency_id = $cands["constituency_id"];
        $party_id = $cands["party_id"];
        $fn = stringCase($cands["fname"]);
        $ln = stringCase($cands["lname"]);
        $election_id = "e-DfnbeUCnxn.eeHiKc1fqm86425";

        //echo json_encode($cands) . "<br>";

        $add_query1 = "insert into " . TABLE_CANDIDATE . " (candidate_id,first_name,last_name,update_time) values ('$candidate_id1','$fn','$ln','$update_time')";
        $add_result1 = $paperweight->query($add_query1);
        //$add_result1 = null;
        if($add_result1 != null && $add_result1->is_row_affected()){

            $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);
            //$party_id = $pnp_data["party_ip"];

            $rel_query1 = "insert into " . TABLE_PARTY_REL . " (relationship_id,candidate_id,party_id,update_time) values ('$relationship_id','$candidate_id1','$party_id','$update_time')";
            $rel_result1 = $paperweight->query($rel_query1);


            if($rel_result1 != null && $rel_result1->is_row_affected()){

                $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                $con_query = "insert into " . TABLE_CONSTITUENCY_REL . " (relationship_id,candidate_id,constituency_id,update_time) values ('$relationship_id','$candidate_id1','$constituency_id','$update_time')";
                $con_result = $paperweight->query($con_query);
                if($con_result != null && $con_result->is_row_affected()){

                    $relationship_id = "rid-" . getRandomString(10) . "." . getRandomString(10) . getRandomNumber(5);


                    $election_query = "insert into " . TABLE_ELECTION_REL . " (relationship_id,candidate_id,party_id,constituency_id,update_time,election_id) values ('$relationship_id','$candidate_id1','$party_id','$constituency_id','$update_time','$election_id')";
                    $election_result = $paperweight->query($election_query);
                    if($election_result != null && $election_result->is_row_affected()){

                        $result["status"] = STATUS_OK;

                    }

                }
            }

        }

    }

    if ($action == "list_mp"){

        $constituency_query = "select * from " . TABLE_CONSTITUENCY;
        $constituency_result = $paperweight->query($constituency_query);
        while ($row = $constituency_result->fetch_array()) {
            $constituency_id = $row["constituency_id"];
            $constituency_name = stringCase($row["constituency_name"], 2);
            //$election_id = "e-doUhtgf03L.a2evIfpEZz64186";
            $election_id = "e-DfnbeUCnxn.eeHiKc1fqm86425";

            $detail = getMemberParliamentDetail($constituency_id,$election_id,$paperweight);

            //pnp_candidate
            //jlp_candidate


            $pid = $detail["pnp_candidate"]["candidate_id"];
            $pfull = $detail["pnp_candidate"]["fname"] . " " . $detail["pnp_candidate"]["lname"];

            $jid = $detail["jlp_candidate"]["candidate_id"];
            $jfull = $detail["jlp_candidate"]["fname"] . " " . $detail["jlp_candidate"]["lname"];


            echo "<div onclick='candidateClicked(\"$constituency_id\",\"$pid\",\"p-s1kKhpJVx1.F1RiIeHAtX68677\",this)'>" . "(pnp) -- $constituency_name <-> $pfull <-> $pid</div><br>";
            echo "<div onclick='candidateClicked(\"$constituency_id\",\"$jid\",\"p-mttXACloIy.2BAWR4ylAh84950\",this)'>" . "(jlp) -- $constituency_name <-> $jfull <-> $jid</div><br><br>";
        }
    }

    //load member of Parliament for the 2020 / 2016 election
    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=list_new_mp
    if ($action == "list_new_mp"){

        $constituency_query = "select * from " . TABLE_CONSTITUENCY;
        $constituency_result = $paperweight->query($constituency_query);
        while ($row = $constituency_result->fetch_array()) {
            $constituency_id = $row["constituency_id"];
            $constituency_name = stringCase($row["constituency_name"], 2);
            $election_id = "e-doUhtgf03L.a2evIfpEZz64186";//2016
            //$election_id = "e-DfnbeUCnxn.eeHiKc1fqm86425";//2020

            $detail = getMemberParliamentDetail($constituency_id,$election_id,$paperweight);

            //pnp_candidate
            //jlp_candidate


            $pid = $detail["pnp_candidate"]["candidate_id"];
            $pfull = $detail["pnp_candidate"]["fname"] . " " . $detail["pnp_candidate"]["lname"];

            $jid = $detail["jlp_candidate"]["candidate_id"];
            $jfull = $detail["jlp_candidate"]["fname"] . " " . $detail["jlp_candidate"]["lname"];


            //echo "(pnp) -- $constituency_name <-> $pfull <-> $pid<br>";
            //echo "(jlp) -- $constituency_name <-> $jfull <-> $jid<br>";
            echo "<div onclick='candidateClicked(\"$constituency_id\",\"p-s1kKhpJVx1.F1RiIeHAtX68677\",this)'>" . "(pnp) -- $constituency_name <-> $pfull</div><br>";
            echo "<div onclick='candidateClicked(\"$constituency_id\",\"p-mttXACloIy.2BAWR4ylAh84950\",this)'>" . "(jlp) -- $constituency_name <-> $jfull</div><br><br>";
        }
    }

    //load member of Parliament for specific constituency for the 2020 / 2016 election
    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=get_mp&constituency_id=cid-RIWKT8mSuaJU6oCzYmHJ03383
    if ($action == "get_mp"){
        $constituency_id = $_GET["constituency_id"];
        //$election_id = "e-doUhtgf03L.a2evIfpEZz64186";//2016
        $election_id = "e-DfnbeUCnxn.eeHiKc1fqm86425";//2020

        $detail = getMemberParliamentDetail($constituency_id,$election_id,$paperweight);

        echo json_encode($detail);
    }

    if ($action == "constituency_list"){

        $constituency_query = "select * from " . TABLE_CONSTITUENCY;
        $constituency_result = $paperweight->query($constituency_query);
        while ($row = $constituency_result->fetch_array()) {
            $constituency_id = $row["constituency_id"];
            $constituency_number = $row["constituency_number"];
            $constituency_name = stringCase($row["constituency_name"], 2);

            //echo "<div onclick='constituencyClicked(\"$constituency_id\",\"$constituency_name\",this)'>" . "$constituency_name</div><br>";
            echo $constituency_number . "- " . $constituency_name . " <-> " . $constituency_id . "<br><br>";
        }
    }

    if ($action == "list_con"){

        $constituency_query = "select * from " . TABLE_CONSTITUENCY;
        $constituency_result = $paperweight->query($constituency_query);
        while ($row = $constituency_result->fetch_array()) {
            $constituency_id = $row["constituency_id"];
            $constituency_number = $row["constituency_number"];
            $constituency_name = stringCase($row["constituency_name"], 2);

            echo "<div onclick='constituencyClicked(\"$constituency_id\",\"$constituency_name\",this)'>" . "$constituency_name</div><br>";
            //echo $constituency_name . " <-> " . $constituency_id . "<br><br>";
        }
    }

    if ($action == "edit_map"){
        if(isset($_GET["constituency_id"])){
            $constituency_id = $_GET["constituency_id"];

            //$fn = fopen("resources/map/electoral_divisions/converted/$constituency_id.svg","r");

            $fn = fopen("resources/map/electoral_divisions/converted/$constituency_id.svg","w");
            fwrite($fn, $param_json);

            fclose($fn);

            echo "successful";
        }
        else{


            $fn = fopen("resources/map/constituency_map.svg","w");
            fwrite($fn, $param_json);

            fclose($fn);
        }
    }


    //USE SYSTEM
    //=================================

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=load_election_test&param_json={"year":"2020","client_key":"c-NwS3Ft2KRK.1vydOhnWn010821"}
    if ($action == "load_election"){
        $credentials = json_decode($param_json,true);
        $client_key = $credentials["client_key"];
        $year = $credentials["year"];

        $election_data = getElectionDetailByYear($year,$paperweight);

        $election_id = $election_data["election_id"];

        $constituency_list = getConstituencyListVote($client_key,$election_id,$paperweight);

        $ELECTION_FINAL = $election_data;
        $ELECTION_FINAL["constituency_list"] = $constituency_list;


        echo json_encode($ELECTION_FINAL);
    }

    //https://api.queritel.com/api/general/election/election-jamaica-setup.php?action=load_map&constituency_id=cid-bNbAOI4WdsEjp5wgYSHB69273
    if ($action == "load_map"){
        if(isset($_GET["constituency_id"])){
            $constituency_id = $_GET["constituency_id"];

            $fn = fopen("resources/map/electoral_divisions/converted/$constituency_id.svg","r");

            while(! feof($fn))  {
                $result = fgets($fn);

                echo $result;

            }

            fclose($fn);
        }
        else{

            $fn = fopen("resources/map/constituency_map.svg","r");

            while(! feof($fn))  {
                $result = fgets($fn);

                echo $result;

            }

            fclose($fn);
        }
    }


    /*
     *

     *

     *
     *
     * $filename = "ftp://username:pa‌​ssword@hostname/path/to/file";
     * $handle = fopen($filename, "r");
     * $contents = fread($handle, filesize($filename));
     * fclose($handle);
     * echo $contents;
     *
     *
     *
     *
     *
     * $conn_id = ftp_connect('hostname');

    ftp_login($conn_id, 'username', 'password');

    ftp_pasv($conn_id, true);

    $h = fopen('php://temp', 'r+');

    ftp_fget($conn_id, $h, '/path/to/file', FTP_BINARY, 0);

    $fstats = fstat($h);
    fseek($h, 0);
    $contents = fread($h, $fstats['size']);

    fclose($h);
    ftp_close($conn_id);




     * https://stackoverflow.com/questions/18392321/php-how-do-i-read-a-txt-file-from-ftp-server-into-a-variable/38875844







     *
     * */


}




