<?php


class Config
{
    private $conn;
    private $manager;

    /**
     * Config constructor.
     * @param Database $conn
     * @param int $manager_id
     */
    public function __construct(\Database $conn, int $manager_id)
    {
        $this->conn = $conn;
        $this->manager = $manager_id;
    }

    public function getConfigValue($array)
    {
        $in = "";
        foreach ($array as $value) {
            $in .= "'" . $value . "',";
        }

        $in = rtrim($in, ',');

        $query = "select `value` from " . TABLE_CONFIG . "  where `key` in ($in) and manager_id = " . $this->manager;
        return ($this->conn->query($query)->fetch_assoc());
    }

    public function getStoreList()
    {

        $res = getOKStatus();
        try {
            $store_ids = (new People($this->conn))->getStores('CL', USER_TYPE_MANAGER);
//            echo json_encode($store_ids);
            foreach ($store_ids as $store) {
                $store = $this->getStoreInfo($store['manager_id']);
                array_push($res, $store);
            }
            return $res;
        } catch (Exception $ex) {
            return getErrorStatus(ERROR_NAME_OP_FAILED);
        }

    }

    private function getStoreInfo($manager)
    {

        $query = "select * from " . TABLE_CONFIG . " where `key` in ('address', 'company_logo', 'country_codes', 'currency_code', 'currency_decimals', 'email', 'number_locale','phone') and manager_id = " . $manager;
        $res = array();
        $select_result = $this->conn->query($query);
        while ($row = $select_result->fetch_assoc()) {
//            echo $row['key'];
            $res[$row['key']] = $row['value'];
        }
        return $res;
    }
}