<?php
include("Customer.php");

/**
 * Class CustomerService
 */
class CustomerService
{

    /**
     * @var
     */
    var $conn;
    /**
     * @var
     */
    var $manager;

    /**
     * CustomerService constructor.
     * @param $cornersave
     */
    public function __construct($cornersave, $manager_id)
    {
        $this->conn = $cornersave;
        $this->manager = $manager_id;
    }

    /**
     * @param $data
     * @return array
     */
    public function updateCustomer($data)
    {
        $result = getErrorStatus(ERROR_NAME_OP_FAILED);

        if (array_key_exists("fname", $data)) {
            if ($this->updateUnVerifiedUser($data)) return getOKStatus();
        } else {
            if ($this->updateVerifiedUser($data)) return getOKStatus();
        }

        return $result;
    }

    /**
     * @param $data
     * @return bool
     */
    private function updateVerifiedUser($data): bool
    {
        $customer = new stdClass();
        $customer->points = text_clean($data['points']);
        $customer->discount_type = text_clean($data['discount_type']);
        $customer->discount = text_clean($data['discount']);
        $customer->customer_id = text_clean($data['customer_id']);
        return (new Customer($this->conn, $this->manager))->updateVerifiedUser($customer);
    }

    /**
     * @param $data
     * @return bool
     */
    private function updatePerson($data): bool
    {
        $set = new stdClass();
        $set->first_name = text_clean($data['fname']);
        $set->last_name = text_clean($data['lname']);
        $set->email = text_clean($data['email']);
        $set->gender = $this->gender(text_clean($data['gender']));
        $set->phone_number = text_clean($data['phone_number']);
        $set->address_1 = text_clean($data['location_address_1']);
        $set->address_2 = text_clean($data['location_address_2']);
        $set->state = text_clean($data['location_state']);
        $set->country = text_clean($data['country_code']);
        $set->city = text_clean($data['location_city']);
        $set->zip = text_clean($data['postal_code']);
        $set->date_of_birth = text_clean($data['date_of_birth']);

        $where = new stdClass();
//        $where->manager_id = $this->manager;
        $where->person_id = text_clean($data['user_id']);
        return (new Person($this->conn))->updatePerson($set, $where);
    }

    /**
     * @param string $gender
     * @return int
     */
    private function gender(string $gender): int
    {
        if ($gender == GENDER_MALE) return GENDER_MALE_CODE;
        elseif ($gender == GENDER_FEMALE) return GENDER_FEMALE_CODE;
        else return GENDER_NOT_TO_SAY_CODE;
    }

    /**
     * @param $data
     * @return bool
     */
    private function updateUnVerifiedUser($data): bool
    {
        try {

            $this->conn->transaction();
            if (!$this->updateVerifiedUser($data)) throw new Exception("update customer table failed :: " . $this->conn->get_error());
            if (!$this->updatePerson($data)) throw new Exception("update people table failed :: " . $this->conn->get_error());
            $this->conn->commit();
            return true;

        } catch (Exception $e) {
            $this->conn->rollback();
            debugAPIResponse(ACTION_UPDATE_CUSTOMER, $e);
//            die($e);
        }

        return false;
    }

    public function deleteCustomer($customer_id)
    {
        if ((new Customer($this->conn, $this->manager))->delete($customer_id)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

}