<?php


class Permission
{
    private $conn;
    private $user_id;

    public function __construct($db_connector, $user_id = '')
    {
        $this->conn = $db_connector;
        $this->user_id = $user_id;
    }

    private function getAllPermissionsByUser()
    {

        if ($this->conn != null) {
            $Query = "SELECT permission_id FROM " . TABLE_GRANT . " where person_id = '$this->user_id'";

            $select_query = $this->conn->query($Query);

            if (!is_null($select_query)) {
                $permissions = array();
                while ($row = $select_query->fetch_array()) {
                    array_push($permissions, $row['permission_id']);
                }

                return $permissions;
            }
        }

        return null;

    }

    public function getModulesFromPermissions()
    {
        $modules = array();
        $permissions = $this->getAllPermissionsByUser();

        if (is_null($permissions)) return null;

        foreach ($permissions as $permission) {
            if ($permission == "config")
                $modules[] = "module_configuration";

            if ($permission == "customers")
                $modules[] = "module_customer";

            if ($permission == "employees")
                $modules[] = "module_team";

            if ($permission == "expenses")
                $modules[] = "module_expense";

            if ($permission == "giftcards")
                $modules[] = "module_giftcard";

            if ($permission == "item_kits")
                $modules[] = "module_promotion";

            if ($permission == "items")
                $modules[] = "module_item";

            if ($permission == "messages")
                $modules[] = "module_message";

            if ($permission == "preorders")
                $modules[] = "module_order";

            if ($permission == "receivings")
                $modules[] = "module_receiving";

            if ($permission == "reports")
                $modules[] = "module_report";

            if ($permission == "sales")
                $modules[] = "module_sale";

            if ($permission == "suppliers")
                $modules[] = "module_supplier";

            if ($permission == "supplier_market")
                $modules[] = "module_supplier_market";

            if ($permission == "catalog")
                $modules[] = "module_catalog";

            if ($permission == "add_items")
                $modules[] = "module_add_items";

        }

        return $modules;
    }

    public function addGrants(array $inserts)
    {
        $query = get_insert_query(TABLE_GRANT, $inserts);
        return !is_null($this->conn) && $this->conn->insert($query);
    }


}