<?php
//include "Supplier.php";
//include "Person.php";

class SupplierService
{
    private $db_connector;
    private $host_info;
    private $currentLocation;
    private $manager_id;

    function __construct($db_connector, $manager_id)
    {
        $this->db_connector = $db_connector;
        $this->host_info = new HostInfo($db_connector);
        $this->currentLocation = new LocationPoint(null, null);
        $this->manager_id = $manager_id;
    }

    public function getList()
    {
        $model = new Supplier($this->db_connector, $this->manager_id);

        $list = $model->getSupplierList();

        if (is_null($list)) return getErrorStatus(ERROR_MSG_INVALID_LOGIN);

        $result = getOKStatus();
        $result['supplier_list'] = $list;

        return $result;
    }

    public function getSupplier(string $supplier_id)
    {
        $model = new Supplier($this->db_connector, $supplier_id);

        $supplier = $model->getSupplierById();

        if (is_null($supplier)) return getErrorStatus(ERROR_NO_DATA_FOUND);

        $result = getOKStatus();
        $result['supplier_data'] = $supplier;

        return $result;
    }

    public function deleteSupplier(string $supplier_id)
    {
        if ((new Supplier($this->db_connector, $supplier_id))->deleteSupplier()) return getOKStatus();
        return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    }

    public function addSupplier(object $supplier_data)
    {
        $result = getErrorStatus(ERROR_NAME_OP_FAILED);
        try {
            $this->db_connector->transaction();
            $person_model = new Person($this->db_connector);
            $person_id = $person_model->addPerson($supplier_data);
            if (is_null($person_id)) throw new Exception("failed to insert to persons table");
            $supplier_model = new Supplier($this->db_connector);
            if (!$supplier_model->addSupplier($supplier_data, $person_id)) throw new Exception("failed to insert to suppliers' table");
            $this->db_connector->commit();
            return getOKStatus();
        } catch (Exception $exception) {
            $this->db_connector->rollback();
            debugAPIResponse(ACTION_ADD_SUPPLIER, $exception);
        }
        return $result;
    }

}