<?php
ini_set('display_errors', '1');

//echo json_export("heeh");
//return;
/**
 * @Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : process all service request for mobile merchant application
 * @link : http://api.queritel.com/api/mobile/cornersave/merchant/v1/api.php?action=jjghhfh
 */

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');

/**
 * @Title Official Mobile Application Version Information
 * @Obj VERSION_NAME : This the version string name is is only used for labeling
 * @Obj VERSION_CODE : This is the actual version code used to maintain app version
 * @Obj VERSION_COMMENT : This is an optional string to be used in messaging
 * @Obj VERSION_PRIORITY : (0 -> This update is not priority and can be ignored by the user | 1 -> This update cannot be ignored)
 * @Usage : verifyLogin and processed by SplashScreen on the mobile App
 */
/*define("MOBILE_AGENT_ANDROID", "android");
define("MOBILE_AGENT_IOS", "ios");
define("MOBILE_VERSION_NAME", "version_name");
define("MOBILE_VERSION_CODE", "version_code");
define("MOBILE_VERSION_COMMENT", "version_comment");
define("MOBILE_VERSION_PRIORITY", "version_priority");

define("ANDROID_VERSION_NAME", "1.0");
define("ANDROID_VERSION_CODE", 1);
define("ANDROID_VERSION_COMMENT", ".");
define("ANDROID_VERSION_PRIORITY", 0);

define("IOS_VERSION_NAME", "1.0");
define("IOS_VERSION_CODE", 1);
define("IOS_VERSION_COMMENT", ".");
define("IOS_VERSION_PRIORITY", 0);
*/

include("../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../includes/headers/miscellaneous-v1.php");//additional functions
include("../includes/headers/strings.php");//has all the constants needed
include("api/Merchant.php");//has all merchant-related functions
include "api/SupplierService.php";
include("model/Item.php");//has all the constants needed
include("model/Order.php");
include("model/Query.php");
include "service/OrderService.php";
include "service/ItemService.php";
include "api/CustomerService.php";
include "service/GiftCardService.php";
include "service/KitsService.php";
include("service/ExpensesService.php");
include("service/ExpenseCategoryService.php");
include("service/SupplierMarketService.php");
include("model/SupplierMarket.php");
include("service/MsgNotificationService.php");
include("model/MsgNotification.php");
include("model/ExpenseCategory.php");
include("model/Expenses.php");
include("model/GiftCard.php");
include("model/Kits.php");
include("model/ItemKit.php");
include("model/Supplier.php");
include("service/ProfileService.php");
include("service/ConfigService.php");
include("service/ReceivingService.php");
include("service/TeamMembersService.php");
include("service/ReportingService.php");
include("service/SubscriptionsService.php");
include("model/Receiving.php");
include("model/Subscription.php");
include("model/Person.php");
include("model/Config.php");
include("model/Reporting.php");
include("model/Wallet.php");

//https://app.cornersave.com/public/uploads/item_pics/704080.jpg
//https://app.cornersave.com/public/uploads/item_pics/581446.jpg


$cornersave = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME, MAIN_DB_HOST);


//API CANCEL STATE
if (isset($_REQUEST["release"]) && $_REQUEST["release"] == "demo") {

    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    if ($action == 'get_package_list') {
        $data = json_decode($param_json, true);
        $package_list = $data['package_list'];
        $filter = $data['filter'];

//        die($data['package_list'][0]);

        $result = (new SubscriptionsService($cornersave, $package_list, $filter))->getPackages();

        /*
        $res = getOKStatus();

        $result[0]['package_id'] = 'pd_fhgGFgd7546cn675HG867JhlOIn';
        $result[0]['store_id'] = '4687314909';
        $result[0]['store_name'] = 'Zendos Snackables2';
        $result[0]['store_type'] = 'grocerystore';
        $result[0]['logo_url'] = 'https://source.queritel.com/figozo/uploads/store/logo/company_logo.jpg';
        $result[0]['store_url'] = 'https://market.figozo.com/store/?storeid=4687314909';
        $result[0]['country_code'] = 'CL';
        $result[0]['address'] = 'Bellavista 186, Recoleta, Chile';
        $result[0]['currency_code'] = 'CLP';
        $result[0]['total_products'] = 500;
        $result[0]['days_active'] = '365';
        $result[0]['daily_transactions'] = 100;
        $result[0]['avg_monthly_sales'] = 1000000;
        $result[0]['monthly_subscription'] = 5000;

        $res['store_list'] = $result;

        */

        echo json_export($result);

    }
}


if (isset($_REQUEST["release"]) && $_REQUEST["release"] == "1.0.0.1") {

}

$skip = true;

if ((isset($_REQUEST["release"]) && $_REQUEST["release"] == "development") || $skip) {
    $release = $_REQUEST["release"];
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];


    if ($action == "log_paywall") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $activity = text_clean($data["activity"]);

        //todo - activity types
        //activity_add_product
        //activity_subscription_year
        //activity_subscription_month
        //activity_


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);


            //todo : API Debug
            $fname = $merchant->get_firstName();
            $lname = $merchant->get_lastName();
            $date = getCurrentTime();
            $country_code = $merchant->get_locationCountry();


            $heading = "User ID, Session Token, First Name, Last Name, Activity, Date, Country\n";
            $row_data = "$user_id, $login_token, $fname, $lname, $activity, $date, $country_code\n";

            debugPaywallLog($row_data);

            $result = getOKStatus();
        }

        echo json_export($result);
    }


    if ($action == ACTION_LOCALE_CONVERSION) {
        $data = json_decode($param_json, true);

        $number_locale = text_clean($data["number_locale"]);
        $value = text_clean($data["value"]);

        $result = locale_converter($number_locale, $value);

        echo json_export($result);
    }


    if ($action == ACTION_LOG_IN) {
        $data = json_decode($param_json, true);


        $username = strtolower(text_clean($data["user_name"]));
        $password = text_clean($data["password"]);

        $merchant = new Merchant($cornersave);
        $result = $merchant->login($username, $password);

        echo json_export($result);
    }
    if ($action == ACTION_LOG_OUT) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);

        $result = $merchant->signout($user_id, $login_token);

        echo json_encode($result);

    }
    if ($action == ACTION_AUTHENTICATE_USER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $result = $merchant->verifyLogin($user_id, $login_token);

        echo json_export($result);
    }
    if ($action == ACTION_STORE_DATA_GET) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $store_data = $merchant->getStoreData();

            if (!empty($store_data)) {
                $data = array();
                $result = getOKStatus();

                $user_data["store_name"] = clean_reverse($store_data["name"]);
                $user_data["phone_number"] = $store_data["phone"];
                $user_data["store_id"] = $store_data["store_id"];
                $user_data["website"] = SITE_CUSTOMER_ROOT . $store_data["store_id"];
                $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
                $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
                $user_data["currency_code"] = $store_data["currency_code"];
                $user_data["currency_decimals"] = $store_data["currency_decimals"];
                $user_data["discoverable"] = $store_data["discoverable"];
                $user_data["email"] = $store_data["email"];
                $user_data["country_code"] = $store_data["country_codes"];
                $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
                $user_data["address"] = $store_data["address"];
                //$user_data["coordinates"] = (empty($store_data["coordinates"]) ? array() : json_decode($store_data["coordinates"],true));
                $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array("lat" => floatval(0), "lng" => floatval(0)) : json_decode($store_data["coordinates"], true));

                //$val = text_clean("Maria's Wholesñail and Retail");

                //$update = "update ospos_app_config set `value` = '$val' where `key` = 'company' and manager_id = 90";
                //$cornersave->query($update);

                $result["store_date"] = $user_data;

            }

        }

        echo json_export($result);
        //echo json_encode($result);
    }
    if ($action == ACTION_PROFILE_DATA_GET) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            /** @var TYPE_NAME $cornersave */
            $result = (new ProfileService($cornersave, $merchant->getManagerId()))->getProfile();

//            $result = getOKStatus();
//
//            $user_data["fname"] = $merchant->get_firstName();
//            $user_data["lname"] = $merchant->get_lastName();
//            $user_data["user_name"] = $merchant->get_userName();
//            $user_data["user_type"] = $merchant->getUserType();
//            $user_data["email"] = $merchant->get_email();
//            $user_data["gender"] = $merchant->get_gender();
//            $user_data["registration_date"] = $merchant->get_registrationDate();
//            $user_data["phone_number"] = $merchant->get_phoneNumber();
//            $user_data["location_address_1"] = $merchant->getLocationAddress1();
//            $user_data["location_address_2"] = $merchant->getLocationAddress2();
//            $user_data["location_city"] = $merchant->get_locationCity();
//            $user_data["location_state"] = $merchant->get_locationState();
//            $user_data["postal_code"] = "";
//            $user_data["country_code"] = $merchant->get_locationCountry();
//
//
//            $result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_SIGN_UP) {
        $data = json_decode($param_json, true);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);


        //todo : API Debug
        debugAPIResponse(ACTION_SIGN_UP, json_encode($data, JSON_PRETTY_PRINT));


        /*
             Request
             {
                "": "Kevin", //([First name])
                "": "Smith", //([Last name])
                "": "KevinStore", //(no spaces)([user name - used for login])
                "": "myPass", //([password - used for login])
                "": "kevin.smith@queritel.com", //([Email])
                "": "male", //([GENDER CONSTANTS])
                "": "866811467", //([Phone Number])
                "": "", //([Address 1])
                "": "", //([Address 2])
                "": "", //([City])
                "": "", //([State / municipality])
                "": "", //([Postal code])
                "": "CL" //([Country code])
                "": "en-US" //([LANGUAGE CONSTANTS])
                "": "grocerystore" //([STORE TYPE CONSTANTS])
            }
            */

        $general_success = false;

        $merchant = new Merchant($cornersave);

        $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        $first_name = stringCase(text_clean($data["fname"]));
        $last_name = stringCase(text_clean($data["lname"]));
        $user_name = stringCase(text_clean($data["user_name"]));
        $password_txt = text_clean($data["password"]);
        $password = encryptPassword($password_txt);
        $email = stringCase(text_clean($data["email"]));
        $gender = text_clean($data["gender"]);
        if ($gender == GENDER_MALE) {
            $gender = GENDER_MALE_CODE;
        } elseif ($gender == GENDER_FEMALE) {
            $gender = GENDER_FEMALE_CODE;
        } elseif ($gender == GENDER_NOT_TO_SAY) {
            $gender = GENDER_NOT_TO_SAY_CODE;
        } else {
            $gender = null;
        }
        $phone_number = text_clean($data["phone_number"]);

        $location_address_1 = stringCase(text_clean($data["location_address_1"]));
        $location_address_2 = stringCase(text_clean($data["location_address_2"]));
        $location_city = stringCase(text_clean($data["location_city"]));
        $location_state = stringCase(text_clean($data["location_state"]));
        $postal_code = stringCase(text_clean($data["postal_code"]));
        $country_code = stringCase(text_clean($data["country_code"]), STRING_CASE_UPPER);
        $language_code = stringCase(text_clean($data["store_language"]));
        $store_type = stringCase(text_clean($data["store_type"]));

        //todo DEBUG : store_type in app
        if ($store_type == "null") {
            $store_type = "grocerystore";
        }

        $user_type = USER_TYPE_MANAGER;
        $user_ref_id = generateUserReferenceId();
        $creation_time = getCurrentTime();

        $comments = null;
        $manager_id = 0;
        $deleted = 0;
        $disabled = 0;
        $hash_version = 2;


        $add_user = "insert into " . TABLE_PEOPLE . " (first_name, last_name, gender, phone_number, email, address_1, address_2, city, state, zip, country, comments, user_type, user_ref_id, created_on) values('$first_name','$last_name','$gender','$phone_number','$email','$location_address_1','$location_address_2','$location_city','$location_state','$postal_code','$country_code','$comments','$user_type','$user_ref_id','$creation_time')";
        $add_user_result = $cornersave->query($add_user);
        //$add_user_result = null;

        //$add_user_result
        if ($add_user_result != null && $add_user_result->is_row_affected()) {

            $user_id = $add_user_result->insert_id();

            $add_employee = "insert into " . TABLE_EMPLOYEE . " (username, password, person_id, deleted, hash_version, user_type, manager_id, disabled) values('$user_name','$password','$user_id','$deleted','$hash_version','$user_type','$manager_id','$disabled')";
            $add_employee_result = $cornersave->query($add_employee);
            if ($add_employee_result != null && $add_employee_result->is_row_affected()) {

                $default_modules = get_default_modules();
                $default_permissions = get_default_permissions();
                $disabled_modules = get_disabled_modules();

                $grants_array = array();
                $disabled_permission = get_disabled_permissions();
                $menu_group = get_menu_group();

                foreach (get_all_permissions($cornersave) as $permission) {
                    $grants = array();

                    if (!isset($disabled_permission[$permission])) {
                        $grants['permission_id'] = $permission;
                        $grants['menu_group'] = $menu_group[$permission];

                        $grants_array[] = $grants;
                    }

                }

                $config_data = getConfigData(DEFAULT_LANGUAGE, DEFAULT_LOCALE, $store_type, $country_code);

                //this is a test

                foreach ($grants_array as $grant) {
                    $permission_id = $grant["permission_id"];
                    $menu_group = $grant["menu_group"];


                    $insert_permission = "insert into " . TABLE_USER_PERMISSIONS . " (permission_id, person_id, menu_group) values('$permission_id','$user_id','$menu_group')";
                    $insert_permission_result = $cornersave->query($insert_permission);
                    if ($insert_permission_result != null && $insert_permission_result->is_row_affected()) {
                    }

                }

                //todo : API Debug
                //debugAPIResponse("ACTION_SIGN_UP-CONFIG",json_encode($config_data,JSON_PRETTY_PRINT) . " : Manager : $user_id");


                foreach ($config_data as $key => $val) {
                    $insert_data = "insert into " . TABLE_CONFIG . " (`key`, `value`, `manager_id`) values('$key','$val','$user_id')";
                    $insert_data_result = $cornersave->query($insert_data);
                    if ($insert_data_result != null && $insert_data_result->is_row_affected()) {
                    }
                }


                $general_success = true;

            }
        }


        /*
     Request
     {
        "fname": "Demo",
        "lname": "User1",
        "user_name": "KevinStore",
        "password": "myPass",
        "email": "kevin.smith@queritel.com",
        "gender": "male",
        "phone_number": "866811467",
        "location_address_1": "",
        "location_address_2": "",
        "location_city": "",
        "location_state": "",
        "postal_code": "",
        "country_code": "CL",
        "store_language": "en-US",
        "store_type": "grocerystore"
    }

    */

        /*
         Request
         {
            "fname": "Kevin", //([First name])
            "lname": "Smith", //([Last name])
            "user_name": "KevinStore", //(no spaces)([user name - used for login])
            "password": "myPass", //([password - used for login])
            "email": "kevin.smith@queritel.com", //([Email])
            "gender": "male", //([GENDER CONSTANTS])
            "phone_number": "866811467", //([Phone Number])
            "location_address_1": "", //([Address 1])
            "location_address_2": "", //([Address 2])
            "location_city": "", //([City])
            "location_state": "", //([State / municipality])
            "postal_code": "", //([Postal code])
            "country_code": "CL" //([Country code])
            "store_language": "en-US" //([LANGUAGE CONSTANTS])
            "store_type": "grocerystore" //([STORE TYPE CONSTANTS])
        }

        */


        //$general_success = true;
        if ($general_success) {
            $result = $merchant->login($user_name, $password_txt);
            //$result = $merchant->login("jon.garcia", "newstore");
            //$result = $merchant->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            /*$result = getOKStatus();
            $result["user_id"] = "55";
            $result["user_type"] = "type_manage";
            $result["login_token"] = "98542845";
            $result["request_echo"] = $data;*/


        }


        echo json_export($result);
    }


    if ($action == "get_") {

        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);

        $catalog_list = array();
        $country_code = "CL";

        /*$sql_query = "select * from " . TABLE_CATALOG . " where country_code = '$country_code'";
        $sql_query_result = $cornersave->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            while($row = $sql_query_result->fetch_array()){
                $catalog_item = array();
                $catalog_item = get_catalog_info($row["catalog_id"],$cornersave);

                $catalog_list[] = $catalog_item;
            }
        }*/

        $project_list = array();
        $manager_id = 55;

        /*$sql_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id'";
        $sql_query_result = $cornersave->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            while($row = $sql_query_result->fetch_array()){
                $product_item = array();
                $product_item = get_product_info($row["item_id"],$cornersave);

                $project_list[] = $product_item;
            }
        }

        //$result["catalog_list"] = $catalog_list;
        $result["project_list"] = $project_list;
        $result["user"] = $user_id;
        */


        //$result["catalog_list"] = $catalog_list;
        //$result["demo"] = get_catalog_info("catalog-zztppfp-5565564-xsrpwvo",$cornersave);
        //$result["test"] = get_default_permissions();
        //$result["test"] = getConfigData();
        //$result["test"] = get_all_modules($cornersave);
        //$result["test"] = get_all_permissions($cornersave);
        //$result["test"] = get_user_permissions(6,$cornersave);

        /*$grants_array = array();
        $disabled_permission = get_disabled_permissions();
        $menu_group = get_menu_group();

        foreach(get_all_permissions($cornersave) as $permission) {
            $grants = array();

            if (!isset($disabled_permission[$permission])){
                $grants['permission_id'] = $permission;
                $grants['menu_group'] = $menu_group[$permission];

                $grants_array[] = $grants;
            }

        }
        $country_code = "JM";
        $store_type1 = STORE_TYPE_WHOLESALE;

        //$result["test"] = getConfigData($language = DEFAULT_LANGUAGE,$language_code = DEFAULT_LOCALE,$store_type = STORE_TYPE_GROCERYSTORE);
        $config_data = getConfigData($language = DEFAULT_LANGUAGE,$language_code = DEFAULT_LOCALE,$store_type = $store_type1,$country_code);

        $grant_entry = array();
        foreach($grants_array as $grant)
        {
            $entry = array();
            $entry["permission_id"] = $grant["permission_id"];
            $entry["person_id"] = 0;
            $entry["menu_group"] = $grant["menu_group"];

            //$grant_entry[] = $entry;
        }

        $config_entry = array();
        foreach($config_data as $key => $val)
        {
            $entry = array();
            $entry["key"] = $key;
            $entry["value"] = $val;
            $entry["manager_id"] = 0;

            $config_entry[] = $entry;
        }

        $result["grants"] = $grant_entry;
        $result["config"] = $config_entry;
        */


        //echo json_export(get_person_info(55, $cornersave));

        $action = "get_customer_list";
    }

    //todo - NOT-YET-IMPLEMENTED
    if ($action == "set_profile_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("set_profile_data", json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            /* request

            {
                    "user_id":21654,
                    "login_token":849345537,
                    "fname": "Kevin", //([First name])
                    "lname": "Smith", //([Last name])
                    "user_name": "Smith", //([user name - used for login])
                    "email": "kevin.smith@queritel.com", //([Email])
                    "gender": "male", //([GENDER CONSTANTS])
                    "phone_number": "866811467", //([Phone Number])
                    "location_address_1": "", //([Address 1])
                    "location_address_2": "", //([Address 2])
                    "location_city": "", //([City])
                    "location_state": "", //([State / municipality])
                    "postal_code": "", //([Postal code])
                    "country_code": "CL" //([Country code])

                }

             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_PASSWORD_CHANGE) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_PASSWORD_CHANGE, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $old_password = text_clean($data["password"]);
        $new_password = text_clean($data["new_password"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            if (encryptPassword($old_password) == $merchant->get_encrytedPassword()) {
                $result = $merchant->changePassword($user_id, $new_password);
            } else {
                $result = getErrorStatus(ERROR_MSG_INVALID_CRED);
            }
        }

        echo json_export($result);
    }

    if ($action == ACTION_PASSWORD_RESET) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_PASSWORD_RESET, json_encode($data, JSON_PRETTY_PRINT));

        $email = text_clean($data["email"]);

        $merchant = new Merchant($cornersave);

        $result = $merchant->resetPassword($email);

        echo json_export($result);
    }


    //ACTION_IS_USERNAME_VALID : is_username_valid : {"username": "kevin"}
    //fixme : implement is_username_valid
    if ($action == ACTION_IS_USERNAME_VALID) {
        $data = json_decode($param_json, true);

        //t o d o : API Debug
        //debugAPIResponse("is_username_valid",json_encode($data,JSON_PRETTY_PRINT));

        $username = text_clean($data["username"]);
        $merchant = new Merchant($cornersave);


        $result = $merchant->usernameIsValid($username);
//        $result = getOKStatus();
//        $result["is_valid"] = true;


        echo json_export($result);
    }


    //======== module_configuration =========
    //ACTION_GET_CONFIG_INFO = "get_config_information" //(--)
    //ACTION_SET_CONFIG_INFO = "set_config_information" //(--)
    //ACTION_ADD_COMPANY_LOGO = "add_company_logo" //(--)
    //ACTION_REMOVE_COMPANY_LOGO = "remove_company_logo" //(--)

    if ($action == "get_config_information") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $store_data = $merchant->getStoreData();

            if (!empty($store_data)) {
                $data = array();
                $result = getOKStatus();

                //rounding
                //etc
                $user_data["store_name"] = clean_reverse($store_data["name"]);
                $user_data["phone_number"] = $store_data["phone"];
                $user_data["store_id"] = $store_data["store_id"];
                $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
                $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
                $user_data["currency_code"] = $store_data["currency_code"];
                $user_data["currency_decimals"] = $store_data["currency_decimals"];
                $user_data["discoverable"] = $store_data["discoverable"];
                $user_data["email"] = $store_data["email"];
                $user_data["country_code"] = $store_data["country_codes"];
                $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
                $user_data["address"] = $store_data["address"];
                $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array("lat" => floatval(0), "lng" => floatval(0)) : json_decode($store_data["coordinates"], true));

                //$user_data["number_locale"] = $store_data[""];
                //$user_data["thousands_separator"] = $store_data[""];
                //$user_data["timezone"] = $store_data[""];
                //$user_data["financial_year"] = $store_data[""];
                //$user_data["currency_symbol"] = $store_data[""];
                //$user_data["website"] = $store_data[""];
                //$user_data["fax"] = $store_data[""];
                //$user_data["return_policy"] = $store_data[""];

                //$user_data["number_locale"] = "es-CL";
                //$user_data["thousands_separator"] = true;
                //$user_data["timezone"] = "America/Santiago";
                //$user_data["financial_year"] = 1;
                //$user_data["currency_symbol"] = "$";
                //$user_data["website"] = null;
                //$user_data["fax"] = null;
                //$user_data["return_policy"] = null;

                $user_data["number_locale"] = $store_data["number_locale"];
                $user_data["thousands_separator"] = $store_data["thousands_separator"] == 1; //
                $user_data["timezone"] = $store_data["timezone"];; //America/Santiago
                $user_data["financial_year"] = intval($store_data["financial_year"]);
                $user_data["currency_symbol"] = $store_data["currency_symbol"];
                $user_data["website"] = SITE_CUSTOMER_ROOT . $store_data["store_id"];
                $user_data["fax"] = $store_data["fax"];
                $user_data["return_policy"] = $store_data["return_policy"];
                $user_data["store_price"] = $store_data["store_price"];
                $user_data["data_market_status"] = $store_data["data_market_status"];

                $result["config_data"] = $user_data;

            }

        }

        echo json_export($result);
    }
    if ($action == "set_config_information") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        //debugAPIResponse("set_config_information_original",json_encode($data,JSON_PRETTY_PRINT));

        //TODO : API DEBUG : fix dropdown selectors
        //$data["number_locale"] = reverse_localization(text_clean($data["number_locale"]));

        //$locale_data = locale_converter($data["number_locale"],0);
        //$data["currency_code"] = $locale_data["currency_code"];
        //$data["currency_symbol"] = $locale_data["currency_symbol"];
        //$data["currency_decimals"] = 2;


        $data_updated = false;

        //todo : API Debug
        //debugAPIResponse("set_config_information",json_encode($data,JSON_PRETTY_PRINT));

        $store_name = text_clean($data["store_name"]);
        $phone_number = text_clean($data["phone_number"]);
        $currency_code = text_clean($data["currency_code"]);
        $currency_decimals = text_clean($data["currency_decimals"]);
        $email = text_clean($data["email"]);
        $country_code = text_clean($data["country_code"]);
        $address = text_clean($data["address"]);
        $number_locale = text_clean($data["number_locale"]);
        $thousands_separator = text_clean($data["thousands_separator"]) == true ? 1 : 0;
        $currency_symbol = text_clean($data["currency_symbol"]);
        //$website = text_clean($data["website"]);
        $fax = text_clean($data["fax"]);
        $return_policy = text_clean($data["return_policy"]);
        $financial_year = text_clean($data["financial_year"]);
        $store_price = text_clean($data["store_price"]);
        $data_market_status = text_clean($data["data_market_status"]);


        $config_data = array();
        $config_data["address"] = $address;
        $config_data["company"] = $store_name;
        //$config_data["company_logo"] = "no_store.png";
        $config_data["country_codes"] = $country_code;
        $config_data["currency_code"] = $currency_code;
        $config_data["currency_symbol"] = $currency_symbol;
        $config_data["currency_decimals"] = $currency_decimals;
        $config_data["discoverable"] = 1;
        $config_data["email"] = $email;
        $config_data["fax"] = $fax;
        $config_data["financial_year"] = $financial_year;
        //$config_data["language"] = "";
        //$config_data["language_code"] = $language_code;
        $config_data["number_locale"] = $number_locale;
        $config_data["phone"] = $phone_number;
        $config_data["return_policy"] = $return_policy;
        $config_data["store_price"] = $store_price;
        $config_data["data_market_status"] = $data_market_status;
        //$config["timezone"] = "America/New_York";

        /*$user_data["store_name"] = clean_reverse($store_data["name"]);
        $user_data["phone_number"] = $store_data["phone"];
        $user_data["store_id"] = $store_data["store_id"];
        $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
        $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
        $user_data["currency_code"] = $store_data["currency_code"];
        $user_data["currency_decimals"] = $store_data["currency_decimals"];
        $user_data["discoverable"] = $store_data["discoverable"];
        $user_data["email"] = $store_data["email"];
        $user_data["country_codes"] = $store_data["country_codes"];
        $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
        $user_data["address"] = $store_data["address"];
        $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array("lat" => 0,"lng" => 0) : json_decode($store_data["coordinates"],true));
        $user_data["number_locale"] = $store_data["number_locale"];
        $user_data["thousands_separator"] = true;
        $user_data["timezone"] = ""; //America/Santiago
        $user_data["financial_year"] = 1;
        $user_data["currency_symbol"] = "$";
        $user_data["website"] = SITE_CUSTOMER_ROOT . $store_data["store_id"];
        $user_data["fax"] = null;
        $user_data["return_policy"] = null;*/


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $manager_id = $merchant->getManagerId();

            //$result = getOKStatus();

            if (!empty($store_name) && !empty($config_data)) {
                foreach ($config_data as $key => $val) {

                    $con = array();
                    $con["Key"] = $key;
                    $con["Value"] = $val;

                    //debugAPIResponse("debug_log-success-" . getRandomNumber(4),json_encode($con,JSON_PRETTY_PRINT));
                    //debugAPIResponse("debug_log-" . getRandomNumber(4),json_encode($con,JSON_PRETTY_PRINT));


                    $insert_data = "update " . TABLE_CONFIG . " set `value` = '$val' where `key` = '$key' and `manager_id` = '$manager_id'";
                    $insert_data_result = $cornersave->query($insert_data);
                    if ($insert_data_result != null && $insert_data_result->is_row_affected()) {
                        $data_updated = true;
                    }

                }
            }

            /*$config_data = getConfigData(DEFAULT_LANGUAGE,DEFAULT_LOCALE,STORE_TYPE_WHOLESALE,DEFAULT_COUNTRY_CODE);

            foreach($config_data as $key => $val)
            {
                $insert_data = "insert into " . TABLE_CONFIG . " (`key`, `value`, `manager_id`) values('$key','$val','$user_id')";
                $insert_data_result = $cornersave->query($insert_data);
                if($insert_data_result != null && $insert_data_result->is_row_affected()){}
            }*/


            if ($data_updated) {
                $result = getOKStatus();
            } else {
                $result = getErrorStatus(ERROR_MSG_UN_CHANGED);
            }


            //$result["request_echo"] = $data;

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "store_name": "Zendos Snackables",
                    "phone_number": "8764420992",
                    "currency_code": "CLP", //(can be obtained from the ACTION_LOCALE_CONVERSION service)
                    "currency_decimals": "0", //(the number of decimal places)
                    "email": "change@example.com",
                    "country_code": "CL", //(country code)
                    "address": "Bellavista 186, Recoleta, Chile", //(auto complete from places service)
                    "coordinates": {
                        "lat": -33.433553299999999808278516866266727447509765625, //(from places service)
                        "lng": -70.6427249999999986584953148849308490753173828125 //(from places service)
                    },
                    "number_locale": "es-CL", //(list can be seen in the lacale section)
                    "thousands_separator": true, //(whether or not the a thousand separator should be applied to currencies )
                    "timezone": "America/Santiago", //(list can be found in the locale section)
                    "financial_year": 1, //(can be found in the WebApp -> Localization -> Fiscal Year Start)
                    "currency_symbol": "$", //(can be obtained from the ACTION_LOCALE_CONVERSION service)
                    "website": null, //(string)
                    "fax": null, //(string)
                    "return_policy": null //(string)
                }

             */
            /*Response
            {
                "status": "OK",
            }
            */


        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_COMPANY_LOGO) {

        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $image_name = text_clean($data["image_name"]);

        debugAPIResponse(ACTION_ADD_COMPANY_LOGO, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ConfigService($cornersave, $merchant->getManagerId()))->updateLogo($image_name);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            if (isset($_FILES["image"]["type"])) {
                $fileName = $_FILES['image']['name'];
                $fileType = $_FILES['image']['type'];
                $fileError = $_FILES['image']['error'];
                $fileSize = $_FILES["image"]["size"];
                //$fileContent = file_get_contents($_FILES['image']['tmp_name']);
                $sourcePath = $_FILES['image']['tmp_name'];

                $result["file_name"] = $fileName;
                $result["file_type"] = $fileType;
                $result["file_size"] = $fileSize;

                $targetPath = "uploads/store/logo/" . $fileName;

                if (uploadFile($targetPath, $sourcePath) == "success") {
                    $result = getOKStatus();
                    $result["image_name"] = $image_name;
                }

                //move_uploaded_file($sourcePath, $targetPath); // Moving Uploaded file

//                if (move_uploaded_file($sourcePath, $targetPath)) {
//                    $result = getOKStatus();
//                    $result["image_name"] = $image_name;
//                }

            } else {
                $result["demo_field_file_name"] = "No Files were uploaded";
            }

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "image_name": "new_image.jpg"
                }
                //-- IMPORTANT -- ADDITIONAL FILE PARAMETER
                //Multipart File
                //name = "image"
             */

            /*Response
            {
                "status": "OK"
            }
            */

        }

        echo json_export($result);
    }
    if ($action == ACTION_REMOVE_COMPANY_LOGO) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse(ACTION_REMOVE_COMPANY_LOGO, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ConfigService($cornersave, $merchant->getManagerId()))->removeLogo();

        }

        echo json_export($result);

    }


    //======== module_team =========
    //ACTION_GET_PERMISSIONS = "get_permissions" //(--)
    //ACTION_GET_TEAM_LIST = "get_team_list" //(--)
    //ACTION_GET_TEAM_MEMBER = "get_team_member" //(--)
    //ACTION_UPDATE_TEAM_MEMBER = "update_team_member" //(--)
    //ACTION_ADD_TEAM_MEMBER = "add_team_member" //(--)
    //ACTION_DISABLE_TEAM_MEMBER = "disable_team_member" //(--)
    //ACTION_ENABLE_TEAM_MEMBER = "enable_team_member" //(--)
    //ACTION_DELETE_TEAM_MEMBER = "delete_team_member" //(--)


    if ($action == ACTION_GET_PERMISSIONS) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = $merchant->getGrants($user_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_TEAM_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        debugAPIResponse(ACTION_GET_TEAM_LIST, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $manager_id = $merchant->getManagerId();

            $result = $merchant->getTeamList($manager_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_TEAM_MEMBER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = $merchant->getTeamMember($member_id);
        }

        echo json_export($result);
    }
    if ($action == "update_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("update_team_member", json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "team_member_id":25, //([the id for the team member])
                    "fname": "John",
                    "lname": "Nixon",
                    "user_name": "j_nixon_emp",
                    "new_password": "my.pass",
                    "email": "john.nixon@cornersave.com",
                    "gender": "male",
                    "phone_number": "8668114567",
                    "location_address_1": "220 Loreto Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "",
                    "location_state": "Santiago",
                    "postal_code": "",
                    "country_code": "CL",
                    "permissions": [
                        "module_configuration",
                        "module_customer",
                        "module_team",
                        "module_expense",
                        "module_giftcard",
                        "module_promotion",
                        "module_item",
                        "module_message",
                        "module_order",
                        "module_receiving",
                        "module_report",
                        "module_sale",
                        "module_supplier",
                        "module_catalog"
                    ]

                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    if ($action == ACTION_ADD_TEAM_MEMBER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_ADD_TEAM_MEMBER, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();


        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new TeamMembersService($cornersave, $merchant->getManagerId()))->addMember($data);

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "fname": "John",
                    "lname": "Nixon",
                    "user_name": "j_nixon_emp",
                    "new_password": "my.pass",
                    "email": "john.nixon@cornersave.com",
                    "gender": "male",
                    "phone_number": "8668114567",
                    "location_address_1": "220 Loreto Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "",
                    "location_state": "Santiago",
                    "postal_code": "",
                    "country_code": "CL",
                    "permissions": [
                        "module_configuration",
                        "module_customer",
                        "module_team",
                        "module_expense",
                        "module_giftcard",
                        "module_promotion",
                        "module_item",
                        "module_message",
                        "module_order",
                        "module_receiving",
                        "module_report",
                        "module_sale",
                        "module_supplier",
                        "module_catalog"
                    ]

                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_DISABLE_TEAM_MEMBER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);

        //todo : API Debug
        debugAPIResponse(ACTION_DISABLE_TEAM_MEMBER, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = $merchant->disableTeamMember($member_id);
        }

        echo json_export($result);
    }
    if ($action == ACTION_ENABLE_TEAM_MEMBER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);

        //todo : API Debug
        debugAPIResponse(ACTION_ENABLE_TEAM_MEMBER, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = $merchant->enableTeamMember($member_id);
        }

        echo json_export($result);
    }
    if ($action == "delete_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("delete_team_member", json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "team_member_id":25, //([the id for the team member])

                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_supplier =========
    //ACTION_GET_SUPPLIER_LIST = "get_supplier_list" //(--)
    //ACTION_GET_SUPPLIER_DATA = "get_supplier_data" //(--)
    //ACTION_UPDATE_SUPPLIER = "update_supplier" //(--)
    //ACTION_ADD_SUPPLIER = "add_supplier" //(--)
    //ACTION_DELETE_SUPPLIER = "delete_supplier" //(--)


    //change user_type of supplier to type_supply (in database table - ospos_people)
    if ($action == ACTION_GET_SUPPLIER_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new SupplierService($cornersave, $merchant->getManagerId()))->getList();

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_SUPPLIER_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $supplier_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $supplier = new SupplierService($cornersave, $merchant->getManagerId());
            $result = $supplier->getSupplier($supplier_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_SUPPLIER) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_ADD_SUPPLIER, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $supplier_data = new stdClass();
            $supplier_data->user_id = $user_id;
            $supplier_data->login_token = $login_token;
            $supplier_data->company_name = text_clean($data["company_name"]);
            $supplier_data->lname = text_clean($data["lname"]);
            $supplier_data->fname = text_clean($data["fname"]);
            $supplier_data->email = text_clean($data["email"]);
            $supplier_data->supplier_category = text_clean($data["supplier_category"]);
            $supplier_data->phone_number = text_clean($data["phone_number"]);
            $supplier_data->location_address_1 = text_clean($data["location_address_1"]);
            $supplier_data->location_address_2 = text_clean($data["location_address_2"]);
            $supplier_data->location_city = text_clean($data["location_city"]);
            $supplier_data->location_state = text_clean($data["location_state"]);
            $supplier_data->postal_code = text_clean($data["postal_code"]);
            $supplier_data->country_code = text_clean($data["country_code"]);
            $supplier_data->comments = text_clean($data["comments"]);
            $supplier_data->account_number = text_clean($data["account_number"]);
            $supplier_data->tax_id = text_clean($data["tax_id"]);
            $supplier_data->gender = text_clean($data["gender"]);

            $supplierService = new SupplierService($cornersave, $merchant->getManagerId());

            $result = $supplierService->addSupplier($supplier_data);

        }

        echo json_export($result);
    }
    if ($action == "update_supplier") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("update_supplier", json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "supplier_id":163,
                    "company_name": "Jon Dist",
                    "fname": "Curnel",
                    "lname": "Fernandez",
                    "email": "c_fernandez_supply@cornersave.com",
                    "supplier_category": "goods_supplier",
                    "gender": "male",
                    "phone_number": "8669284724",
                    "location_address_1": "354 Flestol Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "Santiago",
                    "location_state": "Región Metropolitana",
                    "postal_code": "",
                    "country_code": "CL",
                    "comments": "Delivering to all",
                    "account_number": "",
                    "tax_id": ""
                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_DELETE_SUPPLIER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);
        //todo : API Debug
        debugAPIResponse(ACTION_DELETE_SUPPLIER, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $supplier = new SupplierService($cornersave, $merchant->getManagerId());
            $result = $supplier->deleteSupplier($supplier_id);
        }

        echo json_export($result);
    }


    //======== module_customer =========
    //ACTION_GET_CUSTOMER_LIST = "get_customer_list" //(--)
    //ACTION_GET_CUSTOMER_DATA = "get_customer_data" //(--)
    //ACTION_ADD_CUSTOMER = "add_customer" //(--)
    //ACTION_UPDATE_CUSTOMER = "update_customer" //(--)
    //ACTION_DELETE_CUSTOMER = "delete_customer" //(--)


    if ($action == ACTION_GET_CUSTOMER_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();
            $manager_id = $merchant->getManagerId();

            //goods_supplier = 0
            //cost_supplier = 1
            $customer_list = array();


            $sql_query = "select * from " . TABLE_CUSTOMER . " where manager_id = '$manager_id' and deleted = '0' order by id asc";
            $sql_query_result = $cornersave->query($sql_query);

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                while ($row = $sql_query_result->fetch_array()) {
                    $customer = array();
                    $person_data = get_person_info($row["person_id"], $cornersave);

                    $customer["customer_id"] = intval($row["person_id"]);
                    $customer["fname"] = stringCase($person_data["first_name"], STRING_CASE_CAP_FIRST);
                    $customer["lname"] = stringCase($person_data["last_name"], STRING_CASE_CAP_FIRST);
                    $customer["email"] = $person_data["email"];
                    $customer["phone_number"] = $person_data["phone_number"];
                    $customer["points"] = intval($row["points"]);
                    $customer["total_spent"] = intval(customer_total_spent($row["person_id"], $manager_id, $cornersave));
                    $customer["user_verified"] = $person_data["is_verified"];

                    $customer_list[] = $customer;
                }
            }


            /*$code = '{
                "status": "OK",
                "customer_list": [
                    {
                        "customer_id": 4,
                        "fname": "Sarah",
                        "lname": "Connor",
                        "email": "sarah.conner@cornersave.com",
                        "phone_number": "8668375463",
                        "points": 0,
                        "total_spent": 0,
                        "user_verified": false

                    },
                    {
                        "customer_id": 12,
                        "fname": "Kevin",
                        "lname": "Smith",
                        "email": "kevin.smith@queritel.com",
                        "phone_number": "8764420992",
                        "points": 0,
                        "total_spent": 0,
                        "user_verified": true
                    }

                ]
            }';
            $code_obj = json_decode($code,true);
            */

            $result["customer_list"] = $customer_list;
        }

        echo json_export($result);
    }
    if ($action == "get_customer_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data["customer_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            $manager_id = $merchant->getManagerId();

            $sql_query = "select * from " . TABLE_CUSTOMER . " where manager_id = '$manager_id' and person_id = '$customer_id' and deleted = '0' order by id asc";
            $sql_query_result = $cornersave->query($sql_query);

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                if ($row = $sql_query_result->fetch_array()) {
                    $result = getOKStatus();

                    $customer_data = array();
                    $person_data = get_person_info($row["person_id"], $cornersave);

                    $customer_data["customer_id"] = intval($row["person_id"]);
                    $customer_data["fname"] = stringCase($person_data["first_name"], STRING_CASE_CAP_FIRST);
                    $customer_data["lname"] = stringCase($person_data["last_name"], STRING_CASE_CAP_FIRST);
                    $customer_data["email"] = stringCase($person_data["email"]);
                    $customer_data["phone_number"] = $person_data["phone_number"];
                    $customer_data["gender"] = $person_data["gender"];
                    $customer_data["points"] = intval($row["points"]);
                    $customer_data["total_spent"] = intval(customer_total_spent($row["person_id"], $manager_id, $cornersave));

                    $discount_type = DISCOUNT_TYPE_PERCENT;
                    if ($row["discount_type"] == DISCOUNT_TYPE_PERCENT_CODE) {
                        $discount_type = DISCOUNT_TYPE_PERCENT;
                    } elseif ($row["discount_type"] == DISCOUNT_TYPE_FIXED_CODE) {
                        $discount_type = DISCOUNT_TYPE_FIXED;
                    }

                    $customer_data["discount_type"] = $discount_type;
                    $customer_data["discount"] = intval($row["discount"]); //"Rewards"

                    $customer_data["user_verified"] = $person_data["is_verified"];
                    //add separation based on user_verified
                    $customer_data["location_address_1"] = $person_data["address_1"];
                    $customer_data["location_address_2"] = $person_data["address_2"];
                    $customer_data["location_city"] = $person_data["city"];
                    $customer_data["location_state"] = $person_data["state"];
                    $customer_data["postal_code"] = $person_data["zip"];
                    $customer_data["country_code"] = $person_data["country"];
                    $customer_data["date_of_birth"] = $person_data["date_of_birth"];

                    $result["customer_data"] = $customer_data;
                }
            }


            /*$customer_data["4"]["customer_id"] = 4;
            $customer_data["4"]["fname"] = "Sarah";
            $customer_data["4"]["lname"] = "Connor";
            $customer_data["4"]["email"] = "sarah.conner@cornersave.com";
            $customer_data["4"]["phone_number"] = "8668375463";
            $customer_data["4"]["gender"] = "female";
            $customer_data["4"]["points"] = 0;
            $customer_data["4"]["total_spent"] = 0;
            $customer_data["4"]["discount_type"] = "type_percentage";
            $customer_data["4"]["discount"] = 2;
            $customer_data["4"]["user_verified"] = false;

            $customer_data["4"]["location_address_1"] = "Guardia Vieja 255 Of. 604";
            $customer_data["4"]["location_address_2"] = "";
            $customer_data["4"]["location_city"] = "Providencia";
            $customer_data["4"]["location_state"] = "Providencia";
            $customer_data["4"]["postal_code"] = "";
            $customer_data["4"]["country_code"] = "JM";
            $customer_data["4"]["date_of_birth"] = "1997-08-28";



            $customer_data["12"]["customer_id"] = 12;
            $customer_data["12"]["fname"] = "Kevin";
            $customer_data["12"]["lname"] = "Smith";
            $customer_data["12"]["email"] = "kevin.smith@queritel.com";
            $customer_data["12"]["phone_number"] = "8764420992";
            $customer_data["12"]["gender"] = "male";
            $customer_data["12"]["points"] = 0;
            $customer_data["12"]["total_spent"] = 0;
            $customer_data["12"]["discount_type"] = "type_fixed";
            $customer_data["12"]["discount"] = 20;
            $customer_data["12"]["user_verified"] = true;

            $customer_data["12"]["location_address_1"] = "Guardia Vieja 255 Of. 604";
            $customer_data["12"]["location_address_2"] = "";
            $customer_data["12"]["location_city"] = "Providencia";
            $customer_data["12"]["location_state"] = "Providencia";
            $customer_data["12"]["postal_code"] = "";
            $customer_data["12"]["country_code"] = "CL";
            $customer_data["12"]["date_of_birth"] = "1997-08-28";


            if ($customer_id == 4 || $customer_id == 12){

                $result = getOKStatus();

                $result["customer_data"] = $customer_data[$customer_id];

            }*/

        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_CUSTOMER) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        //debugAPIResponse("add_customer",json_encode($data,JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $first_name = text_clean($data["fname"]);
        $last_name = text_clean($data["lname"]);
        $email = text_clean($data["email"]);
        $gender_str = text_clean($data["gender"]);
        $phone_number = text_clean($data["phone_number"]);
        $location_address_1 = text_clean($data["location_address_1"]);
        $location_address_2 = text_clean($data["location_address_2"]);
        $location_city = text_clean($data["location_city"]);
        $location_state = text_clean($data["location_state"]);
        $postal_code = text_clean($data["postal_code"]);
        $country_code = text_clean($data["country_code"]);
        $date_of_birth = text_clean($data["date_of_birth"]);
        $discount_type_str = text_clean($data["discount_type"]);
        $discount = text_clean($data["discount"]);
        $user_type = USER_TYPE_CUSTOMER;
        $is_verified = 0;
        $user_ref_id = generateUserReferenceId();

        $gender = null;
        if ($gender_str == GENDER_MALE) {
            $gender = GENDER_MALE_CODE;
        } elseif ($gender_str == GENDER_FEMALE) {
            $gender = GENDER_FEMALE_CODE;
        } elseif ($gender_str == GENDER_NOT_TO_SAY) {
            $gender = GENDER_NOT_TO_SAY_CODE;
        }

        $discount_type = DISCOUNT_TYPE_PERCENT_CODE;
        if ($discount_type_str == DISCOUNT_TYPE_PERCENT) {
            $discount_type = DISCOUNT_TYPE_PERCENT_CODE;
        } elseif ($discount_type_str == DISCOUNT_TYPE_FIXED) {
            $discount_type = DISCOUNT_TYPE_FIXED_CODE;
        }


        //customer link data
        $company_name = null;
        $account_number = null;
        $taxable = 1;
        $tax_id = null;
        $sales_tax_code_id = null;
        $package_id = null;
        $points = null;
        $deleted = 0;
        $date = getCurrentTime();
        $employee_id = $user_id;
        $consent = 1;


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();
        $data_updated = false;

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $manager_id = $merchant->getManagerId();

            $people_query = "insert into " . TABLE_PEOPLE . " (first_name,last_name,gender,phone_number,email,address_1,address_2,city,state,zip,country,user_type,user_ref_id,is_verified, date_of_birth) values ('$first_name','$last_name','$gender','$phone_number','$email','$location_address_1','$location_address_2','$location_city','$location_state','$postal_code','$country_code','$user_type','$user_ref_id','$is_verified','$date_of_birth')";
            $people_result = $cornersave->query($people_query);
            if ($people_result != null && $people_result->is_row_affected()) {
                $customer_id = $people_result->insert_id();

                $customer_query = "insert into " . TABLE_CUSTOMER . " (person_id,taxable,tax_id,discount,discount_type,deleted,`date`,employee_id,consent,manager_id) values('$customer_id','$taxable','$tax_id','$discount','$discount_type','$deleted','$date','$user_id','$consent','$manager_id')";
                $customer_result = $cornersave->query($customer_query);
                if ($customer_result != null && $customer_result->is_row_affected()) {
                    $result = getOKStatus();
                }
            }

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "fname": "Sarah",
                    "lname": "Connor",
                    "email": "sarah.conner@cornersave.com",
                    "gender": "female",
                    "phone_number": "8668375463",
                    "location_address_1": "Guardia Vieja 255 Of. 604",
                    "location_address_2": "",
                    "location_city": "Providencia",
                    "location_state": "Providencia",
                    "postal_code": "",
                    "country_code": "CL",
                    "date_of_birth": "YYYY-MM-DD",
                    "discount_type": "type_percentage",
                    "discount": 2
                }
            {
                "user_id": 55,
                "login_token": 58530544,
                "fname": "Test",
                "lname": "User",
                "email": "email@jk.com",
                "gender": "female",
                "phone_number": "ss",
                "location_address_1": "",
                "location_address_2": "null",
                "location_city": "",
                "location_state": "null",
                "postal_code": "null",
                "country_code": "AD",
                "date_of_birth": "Select your year of birth",
                "discount_type": "",
                "discount": "10"
            }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        //$result = getOKStatus();

        echo json_export($result);
    }

    if ($action == ACTION_UPDATE_CUSTOMER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_UPDATE_CUSTOMER, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $manager_id = $merchant->getManagerId();

            $result = (new CustomerService($cornersave, $manager_id))->updateCustomer($data);

//            $result = getOKStatus();

            /*
            $user_id = text_clean($data["user_id"]);
            $login_token = text_clean($data["login_token"]);
            $customer_id = text_clean($data['customer_id']);
            $first_name = text_clean($data["fname"]);
            $last_name = text_clean($data["lname"]);
            $email = text_clean($data["email"]);
            $gender_str = text_clean($data["gender"]);
            $phone_number = text_clean($data["phone_number"]);
            $location_address_1 = text_clean($data["location_address_1"]);
            $location_address_2 = text_clean($data["location_address_2"]);
            $location_city = text_clean($data["location_city"]);
            $location_state = text_clean($data["location_state"]);
            $postal_code = text_clean($data["postal_code"]);
            $country_code = text_clean($data["country_code"]);
            $date_of_birth = text_clean($data["date_of_birth"]);
            $discount_type_str = text_clean($data["discount_type"]);
            $discount = text_clean($data["discount"]);

            */
            //$result = $merchant->getErrorStatus(ERROR_MSG_INVALID_LOGIN);

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "customer_id": 4,
                    //"fname": "Sarah",
                    //"lname": "Connor",
                    //"email": "sarah.conner@cornersave.com",
                    //"phone_number": "8668375463",
                    //"gender": "female",
                    "points": 0, //(The accumulated points)
                    "total_spent": 0, //(the total spent)
                    "discount_type": "type_percentage", //([DISCOUNT-TYPE CONSTANT])
                    "discount": 2
                }

            {
                "user_id": 55,
                "login_token": 54185967,
                "customer_id": "4",
                "fname": "Sarah",
                "lname": "Connor",
                "email": "sarah.conner@cornersave.com",
                "gender": "female",
                "phone_number": "8668375463",
                "location_address_1": "Guardia Vieja 255 Of. 604",
                "location_address_2": "null",
                "location_city": "Providencia",
                "location_state": "null",
                "postal_code": "null",
                "country_code": "CL",
                "date_of_birth": "1997-08-28",
                "points": null,
                "total_spent": null,
                "discount_type": "",
                "discount": 20
             }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    if ($action == ACTION_DELETE_CUSTOMER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data["customer_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $manager_id = $merchant->getManagerId();
            $result = (new CustomerService($cornersave, $manager_id))->deleteCustomer($customer_id);
        }

        echo json_export($result);
    }


    //======== module_item =========
    //ACTION_GET_PRODUCT_LIST = "get_product_list" //(--)
    //ACTION_GET_PRODUCT_DATA = "get_product_data" //(--)
    //ACTION_ADD_PRODUCT = "add_product" //(--)
    //ACTION_UPDATE_PRODUCT = "update_product" //(--)
    //ACTION_DELETE_PRODUCT = "delete_product" //(--)


    if ($action == "get_product_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $store_data = $merchant->getStoreData();
            $country_code = $store_data["country_codes"];
            $manager_id = $store_data["manager_id"];

            $category_list = array();

            $sql_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' group by category order by `category` asc";
            $sql_query_result = $cornersave->query($sql_query);

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                while ($row = $sql_query_result->fetch_array()) {
                    $category_name = $row["category"];
                    $category_id = generate_category_code($category_name);

                    $category = array();
                    $category["category_name"] = $category_name;
                    $category["category_id"] = $category_id;

                    $category_list[] = $category;
                }
            }

            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */

            $result = getOKStatus();
            $result["category_list"] = $category_list;

        }

        echo json_export($result);
    }
    if ($action == "get_product_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);
        $search_limit = text_clean($data["search_limit"]);
        $offset_index = text_clean($data["offset_index"]);
        $category_id = text_clean($data["category_id"]);

        //todo : API Debug
        //debugAPIResponse("--get_product_list",json_encode($data,JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1

            /*$code = '{
                "status": "OK",
                "product_list": [
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panaderia",
                        "cost_price": 10.00,
                        "unit_price": 10.00,
                        "quantity": 4,
                        "brand": "Lider",
                        "unit_value": null,
                        "unit_label": null,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
                        "product_type": "type_item",
                        "barcode" : "9208455739873"
                    },
                    {
                        "product_id": 143,
                        "product_name": "Masa Pre Pizza Tradicional",
                        "category_name": "Panaderia",
                        "cost_price": 10.00,
                        "unit_price": 24.00,
                        "quantity": 1,
                        "brand": "Lider",
                        "unit_value": 1,
                        "unit_label": "Un",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                        "image_name": "581446.jpg",
                        "catalog_id": null,
                        "product_type": "type_item",
                        "barcode" : "1735649201482"
                    },
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lacteos",
                        "cost_price": 10.00,
                        "unit_price": 13.00,
                        "quantity": 1,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "catalog_id": "cid-dlsnfjc-9385729-slrfkdf",
                        "product_type": "type_item",
                        "barcode" : "9857392874639"
                    }

                ]
            }';

            $code_obj = json_decode($code,true);*/

            $project_list = array();
            $manager_id = $merchant->getManagerId();

            //$limit_from = 0;
            //$row_count = 200;
            // limit $limit_from, $row_count

            $limit_from = intval($offset_index);
            $row_count = $search_limit;

            $category_id_check = null;
            $category_name = null;

            if (!empty($category_id)) {
                $category_name = generate_category_name($category_id);
                $category_id_check = " and category = '$category_name' ";
            }

            if (!empty($search_id)) {
                $sql_query = "select * from " . TABLE_ITEMS . " where deleted = 0 and manager_id = '$manager_id' $category_id_check and ((`name` like '%$search_id%') or (`item_number` like '%$search_id%') or (`brand` like '%$search_id%')) order by `name` asc limit $row_count offset $limit_from";
            } else {
                $sql_query = "select * from " . TABLE_ITEMS . " where deleted = 0 and manager_id = '$manager_id' $category_id_check limit $row_count offset $limit_from ";
            }

            //$sql_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id'";
            $sql_query_result = $cornersave->query($sql_query);

            $items_returned = 0;

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                while ($row = $sql_query_result->fetch_array()) {
                    $product_item = array();

                    $product_id = intval($row["item_id"]);
                    $product_qty = get_product_quantity($product_id, $cornersave);


                    $product_item["product_id"] = $product_id;
                    $product_item["product_name"] = $row["name"];
                    $product_item["category_name"] = $row["category"];
                    $product_item["cost_price"] = intval($row["cost_price"]);
                    $product_item["unit_price"] = intval($row["unit_price"]);
                    $product_item["quantity"] = $product_qty;
                    $product_item["brand"] = $row["brand"];
                    $product_item["unit_value"] = intval($row["unit_value"]);
                    $product_item["unit_label"] = $row["unit_label"];
                    $product_item["image_url"] = IMG_ITEM_ROOT . $row["pic_filename"];
                    $product_item["image_name"] = $row["pic_filename"];
                    $product_item["catalog_id"] = $row["catalog_id"];
                    $product_item["product_type"] = PRODUCT_TYPE_ITEM; //$row["product_type"];//not used (stock type)
                    $product_item["barcode"] = $row["item_number"];

                    //$product_item = get_product_info($row["item_id"],$cornersave);

                    $project_list[] = $product_item;
                    $items_returned++;
                }
            }

            $last_index = (intval($offset_index) + intval($items_returned));

            $result["last_index"] = $last_index;
            $result["product_list"] = $project_list;

            //todo : API Debug
            //debugAPIResponse("--get_product_list_result",json_encode($result,JSON_PRETTY_PRINT));

        }


        echo json_export($result);
    }
    if ($action == ACTION_GET_PRODUCT_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $product_id = text_clean($data["product_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $product_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "product_id": 142
            }
            */

            /*$product_data["142"]["product_id"] = 142;
            $product_data["142"]["product_name"] = "Pan De Molde 500 Gr";
            $product_data["142"]["category_name"] = "Panadería";
            $product_data["142"]["cost_price"] = 0.0;
            $product_data["142"]["unit_price"] = 10.0;
            $product_data["142"]["quantity"] = 1;
            $product_data["142"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/704080.jpg";
            $product_data["142"]["image_name"] = "704080.jpg";
            $product_data["142"]["catalog_id"] = "cid-mowvgil-0117851-memqqnx";
            $product_data["142"]["barcode"] = "9208455739873";
            $product_data["142"]["brand"] = "Lider";
            $product_data["142"]["unit_value"] = "500";
            $product_data["142"]["unit_label"] = "g";
            $product_data["142"]["stock_type"] = "stock"; //stock -- non_stock
            $product_data["142"]["supplier_id"] = 22; //22
            $product_data["142"]["receiving_quantity"] = 1;
            $product_data["142"]["reorder_level"] = 0;
            $product_data["142"]["description"] = "";
            //$product_data["142"]["tax_names"] = [];
            //$product_data["142"]["tax_percents"] = [];




            $product_data["143"]["product_id"] = 143;
            $product_data["143"]["product_name"] = "Masa Pre Pizza Tradicional";
            $product_data["143"]["category_name"] = "Panadería";
            $product_data["143"]["cost_price"] = 0.00;
            $product_data["143"]["unit_price"] = 24.00;
            $product_data["143"]["quantity"] = 1;
            $product_data["143"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/581446.jpg";
            $product_data["143"]["image_name"] = "581446.jpg";
            $product_data["143"]["catalog_id"] = null;
            $product_data["143"]["barcode"] = "1735649201482";
            $product_data["143"]["brand"] = "Lider";
            $product_data["143"]["unit_value"] = "1";
            $product_data["143"]["unit_label"] = "Un";
            $product_data["143"]["stock_type"] = "stock"; //stock -- non_stock
            $product_data["143"]["supplier_id"] = 22; //22
            $product_data["143"]["receiving_quantity"] = 1;
            $product_data["143"]["reorder_level"] = 0;
            $product_data["143"]["description"] = "";
            //$product_data["143"]["tax_names"] = [];
            //$product_data["143"]["tax_percents"] = [];



            $product_data["150"]["product_id"] = 150;
            $product_data["150"]["product_name"] = "Yoghurt Batido Sabor Vainilla Bolsa";
            $product_data["150"]["category_name"] = "Lácteos";
            $product_data["150"]["cost_price"] = 0.00;
            $product_data["150"]["unit_price"] = 13.00;
            $product_data["150"]["quantity"] = 1;
            $product_data["150"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/264322.jpg";
            $product_data["150"]["image_name"] = "264322.jpg";
            $product_data["150"]["catalog_id"] = "cid-dlsnfjc-9385729-slrfkdf";
            $product_data["150"]["barcode"] = "9857392874639";
            $product_data["150"]["brand"] = "Colun";
            $product_data["150"]["unit_value"] = "1";
            $product_data["150"]["unit_label"] = "Kg";
            $product_data["150"]["stock_type"] = "stock"; //stock -- non_stock
            $product_data["150"]["supplier_id"] = 22; //22
            $product_data["150"]["receiving_quantity"] = 1;
            $product_data["150"]["reorder_level"] = 0;
            $product_data["150"]["description"] = "";
            //$product_data["150"]["tax_names"] = [];
            //$product_data["150"]["tax_percents"] = [];
            */

            $result = getOKStatus();

            $product_item = get_product_info($product_id, $cornersave);
            if ($product_item != null) {
                $product_data["product_id"] = intval($product_id);
                $product_data["product_name"] = $product_item["product_name"];
                $product_data["category_name"] = $product_item["category_name"];
                $product_data["cost_price"] = intval($product_item["cost_price"]);
                $product_data["unit_price"] = intval($product_item["unit_price"]);
                $product_data["quantity"] = intval($product_item["quantity"]);
                $product_data["brand"] = $product_item["brand"];
                $product_data["unit_value"] = $product_item["unit_value"];
                $product_data["unit_label"] = $product_item["unit_label"];
                $product_data["image_url"] = $product_item["image_url"];
                $product_data["image_name"] = $product_item["image_name"];
                $product_data["catalog_id"] = $product_item["catalog_id"];
                $product_data["product_type"] = $product_item["product_type"]; //$row["product_type"];//not used (stock type)
                $product_data["barcode"] = $product_item["barcode"];

                $product_data["stock_type"] = $product_item["stock_type"];
                $product_data["supplier_id"] = $product_item["supplier_id"];//intval($row["supplier_id"]);
                $product_data["receiving_quantity"] = intval($product_item["receiving_quantity"]);
                $product_data["reorder_level"] = intval($product_item["reorder_level"]);
                $product_data["description"] = $product_item["description"];
            }

            $result["product_data"] = $product_data;

            /*if ($product_id == 142 || $product_id == 143 || $product_id == 150){

                $result = getOKStatus();

                $result["product_data"] = $product_data[$product_id];

            }*/

            //$result["product_data"] = $product_data[142];

        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_PRODUCT) {

        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_ADD_PRODUCT, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);


        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $sourcePath = '';

            if (isset($_FILES["image"]["type"])) {
                $fileName = $_FILES['image']['name'];
                $fileType = $_FILES['image']['type'];
                $fileError = $_FILES['image']['error'];
                $fileSize = $_FILES["image"]["size"];
                //$fileContent = file_get_contents($_FILES['image']['tmp_name']);
                $sourcePath = $_FILES['image']['tmp_name'];

                $result["file_name"] = $fileName;
                $result["file_type"] = $fileType;
                $result["file_size"] = $fileSize;

                $targetPath = "uploads/store/product/" . $fileName;

//                move_uploaded_file($sourcePath, $targetPath); // Moving Uploaded file
//                $targetPath = "uploads/store/logo/" . $fileName;

                if (uploadFile($targetPath, $sourcePath) == "success") {
                    $result = getOKStatus();
                    $result["image_name"] = $image_name;
                }


            } else {
                $result["demo_field_file_name"] = "No Files were uploaded";
            }

            $item = new stdClass();
            $item->user_id = $user_id = text_clean($data["user_id"]);
            $item->product_name = $product_name = text_clean($data["product_name"]);
            $item->category_name = $category_name = text_clean($data["category_name"]);
            $item->cost_price = $cost_price = text_clean($data["cost_price"]);
            $item->unit_price = $unit_price = text_clean($data["unit_price"]);
            $item->quantity = $quantity = text_clean($data["quantity"]);
            $item->barcode = $barcode = text_clean($data["barcode"]);
            $item->brand = $brand = text_clean($data["brand"]);
            $item->unit_value = $unit_value = text_clean($data["unit_value"]);
            $item->unit_label = $unit_label = text_clean($data["unit_label"]);
            $item->stock_type = $stock_type = text_clean($data["stock_type"]) == "stock" ? 0 : 1; //1 - non_stock
            $item->supplier_id = $supplier_id = text_clean($data["supplier_id"]);
            $item->receiving_quantity = $receiving_quantity = text_clean($data["receiving_quantity"]);
            $item->receiving_quantity = $reorder_level = text_clean($data["receiving_quantity"]);
            $item->description = $description = text_clean($data["description"]);
            $item->image_name = $image_name = text_clean($data["image_name"]);
            $item->source_path = $sourcePath;

            $result = (new ItemService($cornersave))->addProduct($item);
            $result["image_name"] = $image_name;

        }

        echo json_export($result);
    }

    if ($action == ACTION_UPDATE_PRODUCT) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_UPDATE_PRODUCT, json_encode($data, JSON_PRETTY_PRINT));

        $item['product_id'] = $product_id = text_clean($data["product_id"]);
        $item['product_name'] = $product_name = text_clean($data["product_name"]);
        $item['category_name'] = $category_name = text_clean($data["category_name"]);
        $item['cost_price'] = $cost_price = text_clean($data["cost_price"]);
        $item['unit_price'] = $unit_price = text_clean($data["unit_price"]);
        $item['quantity'] = $quantity = text_clean($data["quantity"]);
        $item['barcode'] = $barcode = text_clean($data["barcode"]);
        $item['brand'] = $brand = text_clean($data["brand"]);
        $item['unit_value'] = $unit_value = text_clean($data["unit_value"]);
        $item['unit_label'] = $unit_label = text_clean($data["unit_label"]);
        $item['stock_type'] = $stock_type = text_clean($data["stock_type"]) == "stock" ? 0 : 1; //1 - non_stock
        $item['supplier_id'] = $supplier_id = text_clean($data["supplier_id"]);
        $item['receiving_quantity'] = $receiving_quantity = text_clean($data["receiving_quantity"]);
        $item['receiving_quantity'] = $reorder_level = text_clean($data["receiving_quantity"]);
        $item['description'] = $description = text_clean($data["description"]);
        $item['image_name'] = $image_name = text_clean($data["image_name"]);
        $item['catalog_id'] = $catalog_id = text_clean($data["catalog_id"]);
        $item['featured'] = $featured = 0;


        $merchant = new Merchant($cornersave);
        $item_model = new Item($cornersave, $product_id);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            $merchant->initializeMerchant($user_id);

            if (isset($_FILES["image"]["type"])) {
                $fileName = $_FILES['image']['name'];
                $fileType = $_FILES['image']['type'];
                $fileError = $_FILES['image']['error'];
                $fileSize = $_FILES["image"]["size"];
                //$fileContent = file_get_contents($_FILES['image']['tmp_name']);
                $sourcePath = $_FILES['image']['tmp_name'];

                $result["file_name"] = $fileName;
                $result["file_type"] = $fileType;
                $result["file_size"] = $fileSize;

                $targetPath = "uploads/store/product/" . $fileName;

                if (uploadFile($targetPath, $sourcePath) == "success") {
//                    $result = getOKStatus();
                    $result["image_name"] = $image_name;
                }

            } else {
                $result["demo_field_file_name"] = "No Files were uploaded";
            }

            $manager_id = $merchant->getManagerId();

            if (!empty($catalog_id)) {
                //edit only allowed fields

                $sql_query = "update " . TABLE_ITEMS . " set `item_number` = '$barcode', `description` = '$description', `cost_price` = '$cost_price', `unit_price` = '$unit_price', `reorder_level` = '$reorder_level', `receiving_quantity` = '$receiving_quantity', `stock_type` = '$stock_type', `featured` = '$featured', `pic_filename` = '$image_name' where `item_id` = '$product_id' and `manager_id` = '$manager_id'";

                $sql_query_result = $cornersave->query($sql_query);

                $item_edited = ($sql_query_result != null && $sql_query_result->is_row_affected());
                $quantity_updated = update_product_quantity($product_id, $quantity, $merchant, $cornersave);

                if ($item_edited || $quantity_updated) {

                    $result = getOKStatus();
                }

            } elseif (empty($catalog_id)) {//todo remove null here

                $sql_query = "update " . TABLE_ITEMS . " set `name` = '$product_name', `category` = '$category_name', `item_number` = '$barcode', `description` = '$description', `cost_price` = '$cost_price', `unit_price` = '$unit_price', `reorder_level` = '$reorder_level', `receiving_quantity` = '$receiving_quantity', `stock_type` = '$stock_type', `brand` = '$brand', `unit_label` = '$unit_label', `unit_value` = '$unit_value', `featured` = '$featured', `pic_filename` = '$image_name' where `item_id` = '$product_id' and `manager_id` = '$manager_id'";
                $sql_query_result = $cornersave->query($sql_query);

                $item_edited = ($sql_query_result != null && $sql_query_result->is_row_affected());
                $quantity_updated = update_product_quantity($product_id, $quantity, $merchant, $cornersave);

                if ($item_edited || $quantity_updated) {

                    $result = getOKStatus();

                }

            }


        }

        echo json_export($result);
    }

    if ($action == ACTION_DELETE_PRODUCT) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $product_id = text_clean($data["product_id"]);

        debugAPIResponse(ACTION_DELETE_PRODUCT, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $manager_id = $merchant->getManagerId();
            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $result = (new ItemService($cornersave))->deleteItem($product_id, $manager_id);

        }

        echo json_export($result);
    }


    //======== module_catalog =========
    //ACTION_GET_CATALOG_LIST = "get_catalog_list" //(--)
    //--ACTION_GET_CATALOG_CATEGORY = "get_catalog_category" //()
    //ACTION_CATALOG_ADD_TO_STORE = "catalog_add_to_store" //(--)


    if ($action == "get_catalog_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $store_data = $merchant->getStoreData();
            $country_code = $store_data["country_codes"];

            $category_list = array();

            $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " order by `name` asc";
            $sql_query_result = $cornersave->query($sql_query);

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                while ($row = $sql_query_result->fetch_array()) {
                    $category_name = $row["name"];
                    $category_id = $row["category_id"];

                    $category = array();
                    $category["category_name"] = $category_name;
                    $category["category_id"] = $category_id;

                    if (is_category_in_country($category_id, $country_code, $cornersave)) {
                        $category_list[] = $category;
                    }

                }
            }

            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */


            $result = getOKStatus();
            $result["category_list"] = $category_list;

        }

        echo json_export($result);
    }
    if ($action == "get_catalog_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);
        $search_limit = text_clean($data["search_limit"]);
        $offset_index = text_clean($data["offset_index"]);
        $category_id = text_clean($data["category_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            //get_catalog_info($catalog_id,$cornersave)


            //goods_supplier = 0
            //cost_supplier = 1

            //"category_name": "Panadería",
            //"category_name": "Lácteos",

            /*$code = '{
                "status": "OK",
                "catalog_list": [
                    {
                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panaderia",
                        "brand": "Lider",
                        "unit_value": "1",
                        "unit_label": "Un",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "in_store": false
                    },
                    {
                        "catalog_id": "catalog-peripva-6251245-knkwrje",
                        "product_name": "Salmón Sureño",
                        "category_name": "Carnes Y Pescados",
                        "brand": "Marine Harvest By Mowi",
                        "unit_value": "180",
                        "unit_label": "gr",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/736260.jpg",
                        "image_name": "736260.jpg",
                        "in_store": false
                    },
                    {
                        "catalog_id": "cid-dlsnfjc-9385729-slrfkdf",
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lacteos",
                        "brand": "Colun",
                        "unit_value": "1",
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "in_store": true
                    }

                ]
            }';*/

            /*$code = '{
                "status": "OK",
                "catalog_list": []
            }';*/

            //$code_obj = json_decode($code,true);

            $manage_id = $merchant->getManagerId();
            $store_data = $merchant->getStoreData();
            $country_code = $store_data["country_codes"];

            $catalog_list = array();
            //$country_code = "CL";
            $limit_from = intval($offset_index);
            $row_count = $search_limit;
            //$row_count = 4;

            $category_id_check = null;

            if (!empty($category_id)) {
                $category_id_check = " and category_id = '$category_id' ";
            }

            if (!empty($search_id)) {
                //select * from initia19_cornersave.catalog_item_list where country_code = 'CL' and `name` like '%Asado%' limit 15 offset 0;
                $sql_query = "select * from " . TABLE_CATALOG . " where country_code = '$country_code' $category_id_check and `name` like '%$search_id%' order by `name` asc limit $row_count offset $limit_from";
            } else {
                $sql_query = "select * from " . TABLE_CATALOG . " where country_code = '$country_code' $category_id_check limit $row_count offset $limit_from ";
            }


            $sql_query_result = $cornersave->query($sql_query);

            $items_returned = 0;

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                while ($row = $sql_query_result->fetch_array()) {
                    $catalog_item = array();
                    //$catalog_item = get_catalog_info($row["catalog_id"],$manage_id,$cornersave);

                    $brand = get_catalog_brand($row["brand_id"], $cornersave);
                    $category = get_catalog_category($row["category_id"], $cornersave);
                    $unit_label = get_catalog_label($row["unit_label_id"], $cornersave);

                    $catalog_item["catalog_id"] = $row["catalog_id"];
                    $catalog_item["product_name"] = $row["name"];
                    $catalog_item["category_name"] = $category;
                    $catalog_item["brand"] = $brand;
                    $catalog_item["unit_value"] = intval($row["unit_value"]);
                    $catalog_item["unit_label"] = $unit_label;
                    $catalog_item["image_url"] = IMG_ITEM_ROOT . $row["file_name"];
                    $catalog_item["image_name"] = $row["file_name"];
                    $catalog_item["in_store"] = catalog_is_in_store($row["catalog_id"], $merchant, $cornersave);

                    $catalog_list[] = $catalog_item;

                    $items_returned++;
                }
            }

            $last_index = (intval($offset_index) + intval($items_returned));

            $result["last_index"] = $last_index;
            $result["catalog_list"] = $catalog_list;

        }

        echo json_export($result);
    }
    if ($action == "catalog_add_to_store") {
        $data = json_decode($param_json, true);

        //todo : API Debug
        //debugAPIResponse("catalog_add_to_store",json_encode($data,JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $catalog_id = text_clean($data["catalog_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $manage_id = $merchant->getManagerId();

            $added = catalog_add_to_store($catalog_id, $merchant, $cornersave);

            if ($added != false) {
                $product_id = $added["product_id"];

                $result = getOKStatus();
                $result["product_id"] = $product_id;
            } else {
                $result = $merchant->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            }


            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "catalog_id":"cid-dlsnfjc-9385729-slrfkdf", //([the id for the catalog item])

                }
             */

            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_giftcard =========
    //ACTION_GET_GIFT_CARD_LIST = "get_gift_card_list" //(--)
    //ACTION_GET_GIFT_CARD_DATA = "get_gift_card_data" //(--)
    //ACTION_ADD_GIFT_CARD = "add_gift_card" //(--)
    //ACTION_UPDATE_GIFT_CARD = "update_gift_card" //(--)
    //ACTION_DELETE_GIFT_CARD = "delete_gift_card" //(--)

    if ($action == ACTION_GET_GIFT_CARD_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data['customer_id']);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new GiftCardService($cornersave))->getGiftCardList($customer_id, $merchant->getManagerId());
        }

        echo json_export($result);
    }
    if ($action == ACTION_UPDATE_GIFT_CARD) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);

        debugAPIResponse(ACTION_UPDATE_GIFT_CARD, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $data['manager_id'] = $merchant->getManagerId();
            $result = (new GiftCardService($cornersave))->updateGiftCard($data);
        }

        echo json_export($result);
    }
    if ($action == ACTION_DELETE_GIFT_CARD) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);

        debugAPIResponse(ACTION_DELETE_GIFT_CARD, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new GiftCardService($cornersave))->deleteGift($gift_card_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_GIFT_CARD) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_ADD_GIFT_CARD, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $data['manager_id'] = $merchant->getManagerId();

            $result = (new GiftCardService($cornersave))->addGiftCards($data);

//            $result = getOKStatus();

            /* request

                {
                    "user_id":55,
                    "login_token":91085539,
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "is_public": false,
                    //"card_code": 384763,
                    //"batch_code": 2938579347,
                    "card_value": 30
                    "gift_card_count": 2
                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_GIFT_CARD_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $card_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new GiftCardService($cornersave))->getGiftCardData($gift_card_id);

        }

        echo json_export($result);
    }


    //======== module_promotion =========
    //ACTION_GET_PROMOTION_LIST = "get_promotion_list" //(--)
    //ACTION_GET_PROMOTION_DATA = "get_promotion_data" //(--)
    //ACTION_UPDATE_PROMOTION = "update_promotion" //(--)
    //ACTION_ADD_PROMOTION = "add_promotion" //(--)
    //ACTION_DELETE_PROMOTION = "delete_promotion" //(--)

    if ($action == ACTION_GET_PROMOTION_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = isset($data["search_id"]) ? text_clean($data["search_id"]) : null;
        $search_limit = isset($data["search_limit"]) ? text_clean($data["search_limit"]) : null;
        $offset_index = isset($data["offset_index"]) ? text_clean($data["offset_index"]) : 0;
//        $offset_index = text_clean($data["offset_index"]);
        //$category_id = text_clean($data["category_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $manager_id = $merchant->getManagerId();

            $limit_from = intval($offset_index);
            $row_count = $search_limit;

            $result = (new KitsService($cornersave, $merchant->getManagerId()))->getKitsList($manager_id, $limit_from, $row_count);
        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_PROMOTION_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $promotion_id = text_clean($data["promotion_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $promotion_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $manager_id = $merchant->getManagerId();

            $result = (new KitsService($cornersave, $merchant->getManagerId()))->getKitItems($promotion_id, $manager_id);
            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "promotion_id": 3
            }
            */
            /*{
                "status": "OK",
                "promotion_data": {
                    "promotion_id": 3,
                    "promotion_name": "Fruit Box Mix",
                    "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                    "promotion_cost": 90,
                    "cost_price": 0,
                    "discount_type": "type_percentage",
                    "discount": 10,
                    "product_list": [
                        {
                            "product_id": 142,
                            "product_name": "Pan De Molde 500 Gr",
                            "category_name": "Panadería",
                            "cost_price": 0,
                            "unit_price": 10,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                            "image_name": "704080.jpg",
                            "catalog_id": "cid-mowvgil-0117851-memqqnx"
                        },
                        {
                            "product_id": 143,
                            "product_name": "Masa Pre Pizza Tradicional",
                            "category_name": "Panadería",
                            "cost_price": 0,
                            "unit_price": 24,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                            "image_name": "581446.jpg",
                            "catalog_id": null
                        },
                        {
                            "product_id": 150,
                            "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                            "category_name": "Lácteos",
                            "cost_price": 0,
                            "unit_price": 13,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                            "image_name": "264322.jpg",
                            "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                        }
                    ]
                }
            }*/
            /*
                        $promotion_data["3"]["promotion_id"] = 3;
                        $promotion_data["3"]["promotion_name"] = "Fruit Box Mix";
                        $promotion_data["3"]["promotion_description"] = "Fruit Box includes Real Flakes and Custard Apple";
                        $promotion_data["3"]["promotion_cost"] = 90.0;
                        $promotion_data["3"]["cost_price"] = 0.0;
                        $promotion_data["3"]["discount_type"] = "type_fixed";
                        $promotion_data["3"]["discount"] = 5;
                        $promotion_data["3"]["barcode"] = "7588674548756";

                        $product_list = '[
                                {
                                    "product_id": 142,
                                    "product_name": "Pan De Molde 500 Gr",
                                    "category_name": "Panadería",
                                    "cost_price": 0.00,
                                    "unit_price": 10.00,
                                    "brand": "Lider",
                                    "unit_value": 500,
                                    "unit_label": "g",
                                    "quantity": 1,
                                    "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                                    "image_name": "704080.jpg",
                                    "catalog_id": "cid-mowvgil-0117851-memqqnx"
                                },
                                {
                                    "product_id": 143,
                                    "product_name": "Masa Pre Pizza Tradicional",
                                    "category_name": "Panadería",
                                    "cost_price": 0.00,
                                    "unit_price": 24.00,
                                    "brand": "Lider",
                                    "unit_value": 1,
                                    "unit_label": "Un",
                                    "quantity": 1,
                                    "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                                    "image_name": "581446.jpg",
                                    "catalog_id": null
                                },
                                {
                                    "product_id": 150,
                                    "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                                    "category_name": "Lácteos",
                                    "cost_price": 0.00,
                                    "unit_price": 13.00,
                                    "brand": "Colun",
                                    "unit_value": 1,
                                    "unit_label": "Kg",
                                    "quantity": 1,
                                    "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                                    "image_name": "264322.jpg",
                                    "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                                }
                            ]';
                        $product_obj = json_decode($product_list, true);

                        $promotion_data["3"]["product_list"] = $product_obj;


                        if ($promotion_id == 3) {

                            $result = getOKStatus();

                            $result["promotion_data"] = $promotion_data[$promotion_id];

                        }

            */

        }

        echo json_export($result);
    }
    if ($action == ACTION_DELETE_PROMOTION) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $promotion_id = text_clean($data["promotion_id"]);

        debugAPIResponse(ACTION_DELETE_PROMOTION, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new KitsService($cornersave, $merchant->getManagerId()))->deleteKit($promotion_id, $merchant->getManagerId());
        }

        echo json_export($result);
    }
    if ($action == ACTION_UPDATE_PROMOTION) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_UPDATE_PROMOTION, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new KitsService($cornersave, $merchant->getManagerId()))->updateKit($data, $merchant->getManagerId());
        }

        echo json_export($result);
    }
    if ($action == ACTION_ADD_PROMOTION) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTION_ADD_PROMOTION, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();

            $result = (new KitsService($cornersave, $merchant->getManagerId()))->addKit($data);

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "promotion_name": "Fruit Box Mix",
                    "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                    "promotion_cost": 90,
                    "cost_price": 0,
                    "discount_type": "type_percentage",
                    "discount": 10,
                    "product_list": [
                        {
                            "product_id": 142,
                            "quantity": 1,
                            "catalog_id": "cid-mowvgil-0117851-memqqnx"
                        },
                        {
                            "product_id": 143,
                            "quantity": 1,
                            "catalog_id": null
                        },
                        {
                            "product_id": 150,
                            "quantity": 1,
                            "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                        }
                    ]
                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_order =========
    //ACTION_GET_ORDER_LIST = "get_order_list" //(--)
    //ACTION_GET_ORDER_DATA = "get_order_data" //(--)
    //ACTION_CONFIRM_ONLINE_ORDER = "confirm_online_order" //(--)
    //ACTION_MARK_ORDER_ITEM_IN_STOCK = "mark_order_item_in_stock" //(--)
    //ACTION_MARK_ORDER_ITEM_OUT_STOCK = "mark_order_item_out_stock" //(--)
    //ACTION_MARK_ORDER_DELIVERED = "mark_order_delivered" //(--)
    //ACTION_CANCEL_ORDER = "cancel_order" //(--)

    //fixme -- get_order_list
    //todo - IN-PROGRESS
    if ($action == "get_order_list_dev") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            //$result = $merchant->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            $manager_id = $merchant->getManagerId();
            $result = getOKStatus();

            $index = 0;
            $order_list = array();

            $order_query = "select * from " . TABLE_SALES . " where manager_id = '$manager_id'";
            $order_result = $cornersave->query($order_query);

            if ($order_result != null && $order_result->is_row_found()) {
                while ($row = $order_result->fetch_array()) {

                    $sale_time = $row["sale_time"];
                    $pickup_time = $row["pickup"];
                    $sale_id = $row["sale_id"];
                    $customer_id = $row["customer_id"];
                    $employee_id = $row["employee_id"];
                    $comment = $row["comment"];
                    $invoice_number = $row["invoice_number"];

                    if ($customer_id != null) {
                        $customer_data = get_person_info($customer_id, $cornersave);
                        $customer_name = stringCase($customer_data["first_name"], STRING_CASE_CAP_FIRST) . " " . stringCase($customer_data["last_name"], STRING_CASE_CAP_FIRST);
                    } else {
                        $customer_name = null;
                    }


                    $sale_status_raw = $row["sale_status"];
                    $sale_type = SALE_TYPE_POS;
                    $sale_type_raw = $row["sale_type"];
                    $is_approved = $row["approved"] == 1;
                    $is_pre_paid = $row["pre_paid"] == 1;
                    $is_online = $row["is_online"] == 1;

                    $order_type = ORDER_TYPE_IN_STORE;
                    if ($is_online) {
                        $order_type = ORDER_TYPE_ONLINE;
                    } else {
                        $order_type = ORDER_TYPE_IN_STORE;
                    }


                    if ($sale_status_raw == ORDER_CANCELED) {
                        $sale_status = ORDER_STATUS_CANCELLED;
                    } elseif ($sale_status_raw == ORDER_COMPLETED) {
                        $sale_status = ORDER_STATUS_COMPLETED;
                    } elseif ($sale_status_raw == ORDER_PENDING) {

                        if ($is_approved) {

                            if ($is_pre_paid) {
                                $sale_status = ORDER_STATUS_PAID;
                            } else {
                                $sale_status = ORDER_STATUS_CONFIRMED;
                            }

                        } else {
                            $sale_status = ORDER_STATUS_PENDING;
                        }

                    }


                    if ($sale_type_raw == SALE_TYPE_POS_CODE) {
                        $sale_type = SALE_TYPE_POS;
                    } elseif ($sale_type_raw == SALE_TYPE_INVOICE_CODE) {
                        $sale_type = SALE_TYPE_INVOICE;
                    } elseif ($sale_type_raw == SALE_TYPE_QUOTE_CODE) {
                        $sale_type = SALE_TYPE_QUOTE;
                    } elseif ($sale_type_raw == SALE_TYPE_RETURN_CODE) {
                        $sale_type = SALE_TYPE_RETURN;
                    }

                    //payment_method


                    $order_list[$index]["order_id"] = intval($sale_id);
                    $order_list[$index]["order_time"] = $sale_time;
                    $order_list[$index]["customer_id"] = ($customer_id != null) ? intval($customer_id) : null;
                    $order_list[$index]["customer_name"] = $customer_name;
                    $order_list[$index]["team_member_id"] = intval($employee_id);
                    $order_list[$index]["comment"] = $comment;
                    $order_list[$index]["invoice_number"] = $invoice_number;
                    $order_list[$index]["quote_number"] = $row["quote_number"];
                    $order_list[$index]["order_type"] = $order_type;
                    $order_list[$index]["order_status"] = $sale_status;
                    $order_list[$index]["approved"] = $is_approved;
                    $order_list[$index]["payment_method"] = null;
                    $order_list[$index]["sale_type"] = $sale_type;
                    $order_list[$index]["is_delivered"] = false;

                    $index++;

                }
            }


            $result["order_list"] = $order_list;

        }

        echo json_export($result);
    }


    if ($action == ACTION_GET_ORDER_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $result = (new OrderService($cornersave, $merchant->getManagerId()))->getOrderList();

        }

        echo json_export($result);
    }


    //todo - IN-PROGRESS
    if ($action == "get_order_data_dev") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $order_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = $merchant->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            $manager_id = $merchant->getManagerId();


            $sql_query = "select * from " . TABLE_SALES . " where manager_id = '$manager_id' and sale_id = '$order_id' order by sale_time desc";
            $sql_query_result = $cornersave->query($sql_query);

            if ($sql_query_result != null && $sql_query_result->is_row_found()) {
                if ($row = $sql_query_result->fetch_array()) {
                    $result = getOKStatus();


                    $sale_time = $row["sale_time"];
                    $pickup_time = $row["pickup"];
                    $sale_id = $row["sale_id"];
                    $customer_id = $row["customer_id"];
                    $employee_id = $row["employee_id"];
                    $comment = $row["comment"];
                    $invoice_number = $row["invoice_number"];

                    if ($customer_id != null) {
                        $customer_data = get_person_info($customer_id, $cornersave);
                        $customer_name = stringCase($customer_data["first_name"], STRING_CASE_CAP_FIRST) . " " . stringCase($customer_data["last_name"], STRING_CASE_CAP_FIRST);
                    } else {
                        $customer_name = null;
                    }


                    $sale_status_raw = $row["sale_status"];
                    $sale_type = SALE_TYPE_POS;
                    $sale_type_raw = $row["sale_type"];
                    $is_approved = $row["approved"] == 1;
                    $is_pre_paid = $row["pre_paid"] == 1;
                    $is_online = $row["is_online"] == 1;

                    $order_type = ORDER_TYPE_IN_STORE;
                    if ($is_online) {
                        $sale_status = ORDER_TYPE_ONLINE;
                    } else {
                        $sale_status = ORDER_TYPE_IN_STORE;
                    }

                    if ($sale_status_raw == ORDER_CANCELED) {
                        $sale_status = ORDER_STATUS_CANCELLED;
                    } elseif ($sale_status_raw == ORDER_COMPLETED) {
                        $sale_status = ORDER_STATUS_COMPLETED;
                    } elseif ($sale_status_raw == ORDER_PENDING) {

                        if ($is_approved) {

                            if ($is_pre_paid) {
                                $sale_status = ORDER_STATUS_PAID;
                            } else {
                                $sale_status = ORDER_STATUS_CONFIRMED;
                            }

                        } else {
                            $sale_status = ORDER_STATUS_PENDING;
                        }

                    }

                    if ($sale_type_raw == SALE_TYPE_POS_CODE) {
                        $sale_type = SALE_TYPE_POS;
                    } elseif ($sale_type_raw == SALE_TYPE_INVOICE_CODE) {
                        $sale_type = SALE_TYPE_INVOICE;
                    } elseif ($sale_type_raw == SALE_TYPE_QUOTE_CODE) {
                        $sale_type = SALE_TYPE_QUOTE;
                    } elseif ($sale_type_raw == SALE_TYPE_RETURN_CODE) {
                        $sale_type = SALE_TYPE_RETURN;
                    }

                    $order_item_data = getOrderItemList($order_id, $cornersave);
                    $order_item_list = $order_item_data["list"];
                    $order_item_total = $order_item_data["total"];


                    $order_data["order_id"] = intval($sale_id);
                    $order_data["order_time"] = $sale_time;
                    $order_data["customer_id"] = ($customer_id != null) ? intval($customer_id) : null;
                    $order_data["customer_name"] = $customer_name;
                    $order_data["team_member_id"] = ($employee_id != null) ? intval($employee_id) : null;
                    $order_data["comment"] = $comment;
                    $order_data["invoice_number"] = $invoice_number;
                    $order_data["quote_number"] = $row["quote_number"];
                    $order_data["order_type"] = $order_type;
                    $order_data["order_status"] = $sale_status;
                    $order_data["approved"] = $is_approved;
                    $order_data["payment_method"] = null; //"Cash";
                    $order_data["sale_type"] = $sale_type;
                    $order_data["pickup_time"] = $pickup_time;
                    $order_data["is_delivered"] = false;
                    $order_data["product_list"] = $order_item_list;


                }
            }

        }

        $result["order_data"] = $order_data;
        echo json_export($result);
    }

    if ($action == ACTION_GET_ORDER_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $order_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $result = $merchant->getOrder($order_id);
        }

        echo json_export($result);
    }
    if ($action == ACTION_CONFIRM_ONLINE_ORDER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new OrderService($cornersave, $merchant->getManagerId()))->confirm_online_order($order_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARK_ORDER_ITEM_IN_STOCK) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $product_id = text_clean($data["product_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new ItemService($cornersave))->mark_order_in_stock($product_id, $order_id);

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARK_ORDER_ITEM_OUT_STOCK) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $product_id = text_clean($data["product_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new ItemService($cornersave))->mark_order_out_of_stock($product_id, $order_id);
        }

        echo json_export($result);
    }
    if ($action == ACTION_MARK_ORDER_DELIVERED) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        //$product_id = text_clean($data["product_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new OrderService($cornersave, $merchant->getManagerId()))->mark_order_delivered($order_id);
        }
        echo json_export($result);
    }
    if ($action == ACTION_CANCEL_ORDER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new OrderService($cornersave, $merchant->getManagerId()))->cancelOrder($order_id, $merchant->getManagerId());
        }

        echo json_export($result);
    }


    //======== module_sale =========
    //ACTION_COMPLETE_SALE = "complete_sale" //(--)
    //ACTION_SUSPEND_SALE = "suspend_sale" //(--)

    if ($action == ACTION_COMPLETE_SALE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse(ACTION_COMPLETE_SALE, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);


//            $result = getOKStatus();

            $result = $merchant->completeSale($data, $merchant->getManagerId());

//            echo json_encode($result);

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": null, //(if the sale is being resumed from [pending] | [confirmed])
                    "customer_id": 12,
                    "gift_card_id": null, //(the gift card id if a gift card was used)
                    "gift_card_amount": 0, //(the amount used fro the giftcard)
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "in_store", //([ORDER TYPE CONSTANTS])
                    "sale_type": "sale", //([SALE TYPE CONSTANTS])
                    "payment_method": "Cash", //(as seen on the cornersave web application)
                    "payment_total": 16, //(cost after calculating the total including any discounts that may have been applied)
                    "product_list": [ //(the list of products in this order)
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": 10,
                            "description": null //(string)
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK",
                "order_id": 141
            }
            */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;
//            $result["order_id"] = 141;
        }

        echo json_export($result);
    }
    if ($action == ACTION_SUSPEND_SALE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new OrderService($cornersave, $merchant->getManagerId()))->suspendSale($data, $merchant->getManagerId());

//            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": null,
                    "customer_id": 12,
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "in_store",
                    "sale_type": "sale",
                    "payment_method": "Cash",
                    "payment_total": 16,
                    "product_list": [
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": "10",
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK",
                "order_id": 141
            }
            */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;
//            $result["order_id"] = 141;

        }

        echo json_export($result);
    }


    //======== module_message =========
    //ACTION_GET_MSG_LIST_MARKETING = "get_msg_list_marketing" //(--)
    //ACTION_GET_MSG_LIST_CONVERSATION = "get_msg_list_conversation" //(--)
    //ACTION_GET_CUSTOMER_MSG_THREAD = "get_customer_msg_thread" //(--)
    //ACTION_GET_MARKETING_MSG_THREAD = "get_marketing_msg_thread" //(--)

    //ACTION_SEND_NOTIFICATION_ID = "send_notification_id" //(--)
    //ACTION_SEND_MSG = "send_msg" //(--)
    //ACTION_MARK_AS_READ = "mark_as_read" //(--)

    //todo - NOT-YET-IMPLEMENTED
    if ($action == ACTION_GET_MSG_LIST_MARKETING) {
        $data = json_decode($param_json, true);


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave, $merchant->getManagerId()))->getMarketingList();
//
//            $code = '{
//                "status": "OK",
//                "message_list": [
//                    {
//                        "recipient_type": "msg_all",
//                        "timestamp": "2021-03-22 12:04:49",
//                        "msg_body": "This is a thank you to all our customers"
//                    },
//                    {
//                        "recipient_type": "msg_week",
//                        "timestamp": "2021-03-17 18:57:57",
//                        "msg_body": "This is a thank you to our customers who made a purchase in the last 7 days"
//                    },
//                    {
//                        "recipient_type": "msg_biweek",
//                        "timestamp": "2021-03-22 12:02:35",
//                        "msg_body": "This is a thank you to our customers who made a purchase in the last 14 days"
//                    },
//                    {
//                        "recipient_type": "msg_active",
//                        "timestamp": "2021-03-23 12:02:35",
//                        "msg_body": "This is a thank you to our customers who made a purchase in the last 30 days"
//                    }
//                ]
//            }';

//            $code_obj = json_decode($code, true);
//
//            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_MSG_LIST_CONVERSATION) {
        $data = json_decode($param_json, true);


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave, $merchant->getManagerId()))->getMsgListConversation();

            //"recipient_type": "msg_single",
            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "customer_id": 4,
                        "fname": "Sarah",
                        "lname": "Connor",
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "Good evening Sarah",
                        "unread": 0
                    },
                    { 
                        "customer_id": 12,
                        "fname": "Kevin",
                        "lname": "Smith",
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "Good Evening Kevin",
                        "unread": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_CUSTOMER_MSG_THREAD) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data["customer_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $thread_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave, $merchant->getManagerId()))->getCustomerMsgThread($customer_id);
//
//            $thread_list = '[
//                    {
//                        "message_id": "msg-btlrvzs-7294585-djghhrg",
//                        "recipient_id": 12,
//                        "recipient_store_id": null,
//                        "sender_id": ' . $user_id . ',
//                        "sender_store_id": "4687314909",
//                        "timestamp": "2021-03-12 18:04:04",
//                        "read_time": "2021-03-12 19:04:04",
//                        "msg_body": "Hi Kevin, We just wanted to reach to you."
//                    },
//                    {
//                        "message_id": "msg-bwthgvq-8765740-itxkvuq",
//                        "recipient_id": null,
//                        "recipient_store_id": "4687314909",
//                        "sender_id": 12,
//                        "sender_store_id": null,
//                        "timestamp": "2021-03-13 18:04:04",
//                        "read_time": null,
//                        "msg_body": "Hello store manager, Thank you for responding"
//                    },
//                    {
//                        "message_id": "msg-xnfqdta-7158904-zcqglfs",
//                        "recipient_id": 12,
//                        "recipient_store_id": null,
//                        "sender_id": ' . $user_id . ',
//                        "sender_store_id": "4687314909",
//                        "timestamp": "2021-03-14 18:04:04",
//                        "read_time": "2021-03-14 19:04:04",
//                        "msg_body": "Good Evening Kevin"
//                    },
//                    {
//                        "message_id": "msg-xnfqdta-7158904-hfoidk",
//                        "recipient_id": 12,
//                        "recipient_store_id": null,
//                        "sender_id": ' . $user_id . ',
//                        "sender_store_id": "4687314909",
//                        "timestamp": "2021-03-14 18:04:04",
//                        "read_time": "2021-03-14 19:04:04",
//                        "msg_body": "New Message to customer"
//                    }
//
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["12"] = $thread_obj;
//
//            $thread_list = '[
//                    {
//                        "message_id": "msg-paccinh-4416764-ceuffww",
//                        "recipient_id": 4,
//                        "recipient_store_id": null,
//                        "sender_id": ' . $user_id . ',
//                        "sender_store_id": "4687314909",
//                        "timestamp": "2021-03-12 18:04:04",
//                        "read_time": "2021-03-12 19:04:04",
//                        "msg_body": "Hello Sarah Conner, we are happy to have you as a customer"
//                    },
//                    {
//                        "message_id": "msg-yippnjr-5424056-kobuasg",
//                        "recipient_id": null,
//                        "recipient_store_id": "4687314909",
//                        "sender_id": 4,
//                        "sender_store_id": null,
//                        "timestamp": "2021-03-13 18:04:04",
//                        "read_time": null,
//                        "msg_body": "Hello store manager, Thank you for welcoming me"
//                    },
//                    {
//                        "message_id": "msg-kqxfprh-0655970-fttngui",
//                        "recipient_id": 4,
//                        "recipient_store_id": null,
//                        "sender_id": ' . $user_id . ',
//                        "sender_store_id": "4687314909",
//                        "timestamp": "2021-03-14 18:04:04",
//                        "read_time": "2021-03-14 19:04:04",
//                        "msg_body": "Good evening Sarah"
//                    }
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["4"] = $thread_obj;
//
//
//            if ($customer_id == "4" || $customer_id == "12") {
//
//                $result = getOKStatus();
//
//                $result["message_thread"] = $thread_data[$customer_id];
//
//            }
            //$code_obj = json_decode($code,true);

            //$result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_MARKETING_MSG_THREAD) {
        $data = json_decode($param_json, true);


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $recipient_type = text_clean($data["recipient_type"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $thread_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave, $merchant->getManagerId()))->getMarketingMsgThread($recipient_type);
//
//            $thread_list = '[
//                    {
//                      "message_id": "msg-paccinh-4416764-ceuffww",
//                      "sender_id": ' . $user_id . ',
//                      "sender_store_id": "4687314909",
//                      "timestamp": "2021-03-22 12:04:49",
//                      "msg_body": "This is a thank you to all our customers",
//                      "recipient_count": 4,
//                      "recipient_read": 2
//                    },
//                    {
//                      "message_id": "msg-paccinh-4416764-dfghrtd",
//                      "sender_id": ' . $user_id . ',
//                      "sender_store_id": "4687314909",
//                      "timestamp": "2021-03-22 12:04:49",
//                      "msg_body": "This is a thank you to all our customers x 10",
//                      "recipient_count": 4,
//                      "recipient_read": 2
//                    }
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["msg_all"] = $thread_obj;
//
//            $thread_list = '[
//                    {
//                      "message_id": "msg-yippnjr-5424056-kobuasg",
//                      "sender_id": ' . $user_id . ',
//                      "sender_store_id": "4687314909",
//                      "timestamp": "2021-03-17 18:57:57",
//                      "msg_body": "This is a thank you to our customers who made a purchase in the last 7 days",
//                      "recipient_count": 4,
//                      "recipient_read": 2
//                    }
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["msg_week"] = $thread_obj;
//
//            $thread_list = '[
//                    {
//                      "message_id": "msg-ffpgiuk-6428710-xrhpfgj",
//                      "sender_id": ' . $user_id . ',
//                      "sender_store_id": "4687314909",
//                      "timestamp": "2021-03-22 12:02:35",
//                      "msg_body": "This is a thank you to our customers who made a purchase in the last 14 days",
//                      "recipient_count": 4,
//                      "recipient_read": 2
//                    }
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["msg_biweek"] = $thread_obj;
//
//            $thread_list = '[
//                    {
//                      "message_id": "msg-yxthqij-8589647-jmodumn",
//                      "sender_id": ' . $user_id . ',
//                      "sender_store_id": "4687314909",
//                      "timestamp": "2021-03-23 12:02:35",
//                      "msg_body": "This is a thank you to our customers who made a purchase in the last 30 days",
//                      "recipient_count": 4,
//                      "recipient_read": 2
//                    }
//                ]';
//            $thread_obj = json_decode($thread_list, true);
//            $thread_data["msg_active"] = $thread_obj;
//
//            if ($recipient_type == "msg_all" || $recipient_type == "msg_week" || $recipient_type == "msg_biweek" || $recipient_type == "msg_active") {
//
//                $result = getOKStatus();
//
//                $result["message_thread"] = $thread_data[$recipient_type];
//
//            }

        }

        echo json_export($result);
    }

    //todo - NOT-YET-IMPLEMENTED
    if ($action == "send_notification_id") {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse("send_notification_id", json_encode($data, JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $notification_id = text_clean($data["notification_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARK_AS_READ) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_MARK_AS_READ, json_encode($data, JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave))->markAsRead(text_clean($data));

        }

        echo json_export($result);
    }
    if ($action == ACTION_SEND_MSG) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_SEND_MSG, json_encode($data, JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $message_data = text_clean($data['message_data']);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new MsgNotificationService($cornersave, $merchant->getManagerId()))->sendMsg($message_data);

        }

        echo json_export($result);
    }


    //======== module_expense =========
    //ACTON_GET_EXPENSE_LIST = "get_expense_list" //(--)
    //ACTON_GET_EXPENSE_CATEGORY_LIST = "get_expense_category_list" //(--)
    //ACTON_ADD_EXPENSE_CATEGORY = "add_expense_category" //(--)
    //ACTON_UPDATE_EXPENSE_CATEGORY = "update_expense_category" //(--)
    //ACTON_ADD_EXPENSE = "add_expense" //(--)
    //ACTON_UPDATE_EXPENSE = "update_expense" //(--)
    //ACTON_DELETE_EXPENSE = "delete_expense" //(--)
    //ACTON_DELETE_EXPENSE_CATEGORY = "delete_expense_category" //(--)

    if ($action == ACTON_GET_EXPENSE_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ExpensesService($cornersave, $merchant->getManagerId()))->getListByManagerId();

        }

        echo json_export($result);
    }
    if ($action == "get_expense_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ExpenseCategoryService($cornersave, $merchant->getManagerId()))->getList();

        }

        echo json_export($result);
    }
    if ($action == ACTON_ADD_EXPENSE_CATEGORY) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTON_ADD_EXPENSE_CATEGORY, json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ExpenseCategoryService($cornersave, $merchant->getManagerId()))->addCategory($data);

        }

        echo json_export($result);
    }
    if ($action == ACTON_UPDATE_EXPENSE_CATEGORY) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("update_expense_category", json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "category_id": 1,
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "category_description": "This is used with beverage-based purchases"
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "add_expense") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("add_expense", json_encode($data, JSON_PRETTY_PRINT));


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ExpensesService($cornersave, $merchant->getManagerId()))->addExpense($data);

        }

        echo json_export($result);
    }
    if ($action == ACTON_UPDATE_EXPENSE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        debugAPIResponse(ACTON_UPDATE_EXPENSE, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ExpensesService($cornersave, $merchant->getManagerId()))->updateExpense($data);
//            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "expense_id": 1, //(the id for the expense)
                    "expense_date": "2020-12-30 15:04:55", //(YYYY-MM-DD HH:mm:ss)(UTC)(must be converted to local)
                    "expense_amount": 100, //(the total associated with this expense entry)
                    "payment_type": "Cash",  //(the payment type used)
                    "category_id": 1, //(the id of the expense category)
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "expense_description": "The purchasing of beverages",
                    "creator_id": 55, //(the id for the team member who created the expense)
                    "creator_name": "Jon Garcia", //(the name of the team member who created the expense)
                    "supplier_id": null, //(the id for the supplier if any was attached)
                    "supplier_name": null, //(the name of the supplier if any was attached)
                    "supplier_tax_code": null, //(the supplier tax code if any)
                    "tax_amount": 0 //(fixed tax amount associated with the expense)
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTON_DELETE_EXPENSE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $expense_id = text_clean($data["expense_id"]);

        debugAPIResponse(ACTON_DELETE_EXPENSE, json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new ExpensesService($cornersave, $merchant->getManagerId()))->delete($expense_id);
        }

        echo json_export($result);
    }
    if ($action == "delete_expense_category") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);

        //todo : API Debug
        debugAPIResponse("delete_expense_category", json_encode($data, JSON_PRETTY_PRINT));

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new ExpenseCategoryService($cornersave, $merchant->getManagerId()))->delete($category_id);

        }

        echo json_export($result);
    }

    //======== module_receiving =========
    //ACTION_COMPLETE_RECEIVING = "complete_receiving" //()

    if ($action == ACTION_COMPLETE_RECEIVING) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_COMPLETE_RECEIVING, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new ReceivingService($cornersave, $merchant->getManagerId()))->completeReceive($data);

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 22, //(the id of the supplier) (if no supplier then use null)
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": null, //(not important)
                    "receiving_mode": "receive", //([RECEIVING MODE CONSTANTS])
                    "payment_method": "Cash",
                    "payment_total": 16,
                    "product_list": [
                        {
                            "product_id": 142,
                            "cost_price": 10, //(the cost price from product list) (NOTE: NOT unit_price)
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": "10",
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK"
            }
            */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;
//            $result["order_id"] = 141;

        }

        echo json_export($result);
    }

    if ($action == ACTION_GET_WALLET_DATA) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_GET_WALLET_DATA, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = $merchant->getWalletData();

        }

        echo json_export($result);
    }

    if ($action == ACTION_PAYOUT_ACCOUNT_LIST) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_PAYOUT_ACCOUNT_LIST, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = $merchant->getPayoutAccountList();

        }

        echo json_export($result);
    }


    //======== module_report =========
    //ACTION_GET_LOW_INV_LIST = "report_get_low_inventory_list" //(--)
    //ACTION_GET_SUM_INV_LIST = "report_get_summary_inventory_list" //(--)
    //ACTION_GET_RCV_LIST = "report_get_receiving_list" //(--)
    //ACTION_GET_TRN_LIST = "report_get_transaction_list" //(--)
    //ACTION_GET_TRN_CHART = "report_get_transaction_chart_data" //(--)
    //ACTION_GET_CUS_LIST = "report_get_customer_list" //()
    //ACTION_GET_CUS_CHART = "report_get_customer_chart_data" //()
    //ACTION_GET_DIS_LIST = "report_get_discount_list" //()
    //ACTION_GET_DIS_CHART = "report_get_discount_chart_data" //()
    //ACTION_GET_EMP_LIST = "report_get_employee_list" //()
    //ACTION_GET_EMP_CHART = "report_get_employee_chart_data" //()
    //ACTION_GET_SUP_LIST = "report_get_supplier_list" //()
    //ACTION_GET_SUP_CHART = "report_get_supplier_chart_data" //()
    //ACTION_GET_PAY_LIST = "report_get_payment_list" //()
    //ACTION_GET_PAY_CHART = "report_get_payment_chart_data" //()
    //ACTION_GET_ITM_LIST = "report_get_item_list" //()
    //ACTION_GET_ITM_CHART = "report_get_item_chart_data" //()
    //ACTION_GET_CAT_LIST = "report_get_category_list" //()
    //ACTION_GET_CAT_CHART = "report_get_category_chart_data" //()

    //todo - NOT-YET-IMPLEMENTED
    if ($action == "report_get_low_inventory_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getLowInvList();

            $code = '{
                  "status": "OK",
                  "inventory_data": [
                    {
                      "product_name": "4 Pack Ensure Advance Chocolate",
                      "barcode": "8475634",
                      "quantity": 0,
                      "reorder_level": 0,
                      "stock_type": "stock"
                    }
                  ]
                }';

//            $code_obj = json_decode($code, true);

//            $result["inventory_data"] = $code_obj["inventory_data"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_SUM_INV_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();

            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getSummaryInventoryList();

            $code = '{
                  "status": "OK",
                  "inventory_data": [
                    {
                      "product_name": "4 Pack Ensure Advance Chocolate",
                      "barcode": "8475634",
                      "category_name": "Bebidas",
                      "quantity": 2,
                      "low_sell_qty": 0,
                      "reorder_level": 0,
                      "stock_type": "stock",
                      "cost_price": 100,
                      "unit_price": 150,
                      "sub_total": 200
                    },
                    {
                      "product_name": "Bebida Light",
                      "barcode": "7465837",
                      "category_name": "Bebidas",
                      "quantity": 2,
                      "low_sell_qty": 0,
                      "reorder_level": 0,
                      "stock_type": "stock",
                      "cost_price": 90,
                      "unit_price": 120,
                      "sub_total": 180
                    }
                  ]
                }';

//            $code_obj = json_decode($code, true);

//            $result["inventory_data"] = $code_obj["inventory_data"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_RCV_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getReceivingList();

            $code = '{
                  "status": "OK",
                  "receiving_data": [
                    {
                      "receiving_id": 14,
                      "receiving_date": "2021-02-12 10:07:15",
                      "quantity": 2,
                      "received_by_id": 55,
                      "received_by_name": "Jon Garcia",
                      "supplied_by_id": 45,
                      "supplied_by_name": "Jon Fernandez Distribuidora",
                      "total": 250,
                      "payment_type": "Tarjeta de Débito",
                      "comments": ".",
                      "product_list": [
                        {
                          "product_name": "4 Pack Ensure Advance Chocolate",
                          "barcode": "8475634",
                          "category_name": "Bebidas",
                          "quantity": 1,
                          "total": 200,
                          "discount": 0
                        },
                        {
                          "product_name": "Gaseosa Guaraná",
                          "barcode": "85946445",
                          "category_name": "Bebidas",
                          "quantity": 1,
                          "total": 50,
                          "discount": 0
                        }
                      ]
                    }
                  ]
                }';


//            $code_obj = json_decode($code, true);
//
//            $result["receiving_data"] = $code_obj["receiving_data"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_TRN_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getTransactionList();

            $code = '{
                  "status": "OK",
                  "transaction_data": [
                    {
                      "transaction_id": 21,
                      "transaction_date": "2021-02-12 10:07:15",
                      "quantity": 2,
                      "sold_by_id": 55, 
                      "sold_by_name": "Jon Garcia", 
                      "customer_id": 12,
                      "customer_name": "Kevin Smith", 
                      "total": 250,
                      "tax": 0,
                      "cost_price": 1000,
                      "profit": 750, 
                      "payment_type": "Efectivo", 
                      "comments": "",
                      "points_used": 0,
                      "points_earned": 0,
                      "product_list": [
                        {
                          "product_name": "4 Pack Ensure Advance Chocolate",
                          "barcode": "8475634",
                          "category_name": "Bebidas",
                          "description": ".",
                          "quantity": 1,
                          "total": 200,
                          "tax": 0,
                          "cost_price": "200",
                          "discount": 0,
                          "profit": 10
                        },
                        {
                          "product_name": "Gaseosa Guaraná",
                          "barcode": "85946445",
                          "category_name": "Bebidas",
                          "description": ".",
                          "quantity": 1,
                          "total": 50,
                          "tax": 0,
                          "cost_price": "50",
                          "discount": 0,
                          "profit": 10
                        }
                      ]
                    }
                  ]
                }';

//            $code_obj = json_decode($code, true);

//            $result["transaction_data"] = $code_obj["transaction_data"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_TRN_CHART) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();

            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getTrnChart();
            $code = '{
              "status": "OK",
              "max_revenue": 70000,
              "min_revenue": 0,
              "increment": 10000,
              "chart_data": [
                {
                  "transaction_date": "2021-02-12 10:07:15",
                  "revenue": 4430
                },
                {
                  "transaction_date": "2021-02-13 10:07:15",
                  "revenue": 12120
                },
                {
                  "transaction_date": "2021-02-14 10:07:15",
                  "revenue": 14350
                },
                {
                  "transaction_date": "2021-02-15 10:07:15",
                  "revenue": 3170
                },
                {
                  "transaction_date": "2021-02-16 10:07:15",
                  "revenue": 3890
                },
                {
                  "transaction_date": "2021-02-17 10:07:15",
                  "revenue": 4620
                },
                {
                  "transaction_date": "2021-02-18 10:07:15",
                  "revenue": 12160
                },
                {
                  "transaction_date": "2021-02-19 10:07:15",
                  "revenue": 68131
                }
              ]
            }';

            $code_obj = json_decode($code, true);

//            $result["max_revenue"] = $code_obj["max_revenue"];
//            $result["min_revenue"] = $code_obj["min_revenue"];
//            $result["increment"] = $code_obj["increment"];
//            $result["chart_data"] = $code_obj["chart_data"];

        }

        echo json_export($result);
    }


    //todo - NOT-YET-IMPLEMENTED
    if ($action == "report_get_customer_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getCustomerList();
            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_customer_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getCustomerChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_discount_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getDiscountList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

//            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_discount_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getDiscountChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

//            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_employee_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getEmployeeList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_employee_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getEmployeeChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_supplier_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getSupplierList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_supplier_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getSupplierChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_payment_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getPaymentList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_payment_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getPaymentChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_item_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getItemList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_item_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getItemChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getCategoryList();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_category_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new ReportingService($cornersave, $merchant->getManagerId()))->getCategoryChartData();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

//            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }


    /* Error -- These reports are not working
        Customers
        Discount
        Employees
        Suppliers
        Payments
        Items
        Categories
    */


    //======== module_supplier_market =========
    //supplier_marketplace

    //ACTION_MARKET_GET_SUPPLIER_LIST = "market_get_supplier_list" //(--)
    //ACTION_MARKET_GET_PRODUCT_LIST = "market_get_product_list" //(--)
    //ACTION_MARKET_GET_PROMOTION_LIST = "market_get_promotion_list" //(--)
    //ACTION_MARKET_CANCEL_ORDER = "market_cancel_order" //(--)
    //ACTION_MARKET_COMPLETE_ORDER = "market_complete_order" //(--)
    //ACTION_MARKET_CLAIM_GIFT = "market_claim_gift_card" //(--)
    //ACTION_MARKET_SET_INTERESTED = "market_mark_as_interested" //(--)
    //ACTION_MARKET_GET_ORDER_LIST = "market_get_order_list" //(--)
    //ACTION_MARKET_GET_ORDER_DATA = "market_get_order_data" //(--)


    if ($action == ACTION_MARKET_GET_SUPPLIER_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = getOKStatus();
            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->getMarketSupplierList();

            //goods_supplier = 0
            //cost_supplier = 1

//
//            $code = '{
//                "status": "OK",
//                "supplier_list": [
//                    {
//                        "supplier_id": 163,
//                        "company_name": "Beverage Distributor",
//                        "email": "b_bev_supply@cornersave.com",
//                        "phone_number": "8669284724",
//                        "supplier_category": "goods_supplier",
//                        "market_place_id": "85740397",
//                        "is_connected": false,
//                        "supplier_url": null
//                    },
//                    {
//                        "supplier_id": 22,
//                        "company_name": "Dairy Supplier",
//                        "email": "e_dairy@cornersave.com",
//                        "phone_number": "8662847290",
//                        "supplier_category": "cost_supplier",
//                        "market_place_id": "87698564",
//                        "is_connected": true,
//                        "supplier_url": "https://cornersave.com/?lang=en"
//                    }
//                ]
//            }';

//            $code_obj = json_decode($code, true);


//            $result["supplier_list"] = $result;

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_GET_PRODUCT_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->getProductListBySupplier(text_clean($data['supplier_id']));

            //goods_supplier = 0
            //cost_supplier = 1

            //TODO information to be added the product list
            //brand
            //unit value
            //unit label
//
//            $code = '{
//                "status": "OK",
//                "product_list": [
//                    {
//                        "product_id": 142,
//                        "product_name": "Pan De Molde 500 Gr",
//                        "category_name": "Panaderia",
//                        "cost_price": 0.00,
//                        "unit_price": 10.00,
//                        "quantity": 20,
//                        "brand": "Lider",
//                        "unit_value": 500,
//                        "unit_label": "g",
//                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
//                        "image_name": "704080.jpg",
//                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
//                        "product_type": "type_item",
//                        "product_description": null,
//                        "is_interested": null
//                    },
//                    {
//                        "product_id": 143,
//                        "product_name": "Masa Pre Pizza Tradicional",
//                        "category_name": "Panaderia",
//                        "cost_price": 0.00,
//                        "unit_price": 24.00,
//                        "quantity": 24,
//                        "brand": "Lider",
//                        "unit_value": 1,
//                        "unit_label": "Un",
//                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
//                        "image_name": "581446.jpg",
//                        "catalog_id": null,
//                        "product_type": "type_item",
//                        "product_description": null,
//                        "is_interested": null
//                    },
//                    {
//                        "product_id": 182,
//                        "product_name": "Accounting Service",
//                        "category_name": "Finance",
//                        "cost_price": null,
//                        "unit_price": null,
//                        "quantity": null,
//                        "brand": null,
//                        "unit_value": null,
//                        "unit_label": null,
//                        "image_url": "https://app.cornersave.com/public/uploads/accounting_5689.jpg",
//                        "image_name": "accounting_5689.jpg",
//                        "catalog_id": null,
//                        "product_type": "type_service",
//                        "product_description": "Providing accounting services to small and medium size stores.",
//                        "is_interested": false
//
//                    }
//
//                ]
//            }';
//
//            $code_obj = json_decode($code, true);
//
//
//            $result["product_list"] = $code_obj["product_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_GET_PROMOTION_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();
            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->getPromotionList($supplier_id);

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "gift_list" : [
                    {
                        "product_type": "type_gift",
                        "batch_code": 7984619550,
                        "card_value": 100
                    }
                ],
                "promotion_list": [
                    {
                        "product_type": "type_promotion",
                        "promotion_id": 3,
                        "promotion_name": "Fruit Box Mix",
                        "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                        "promotion_cost": 90.00, 
                        "cost_price": 0.00, 
                        "discount_type": "type_percentage", 
                        "discount": 10,
                        "product_list": [
                            {
                                "product_id": 142,
                                "product_name": "Pan De Molde 500 Gr",
                                "category_name": "Panadería",
                                "cost_price": 0.00, 
                                "unit_price": 10.00, 
                                "brand": "Lider",
                                "unit_value": 500,
                                "unit_label": "g",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                                "image_name": "704080.jpg",
                                "catalog_id": "cid-mowvgil-0117851-memqqnx"
                            },
                            {
                                "product_id": 143,
                                "product_name": "Masa Pre Pizza Tradicional",
                                "category_name": "Panadería",
                                "cost_price": 0.00, 
                                "unit_price": 24.00, 
                                "brand": "Lider",
                                "unit_value": 1,
                                "unit_label": "Un",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                                "image_name": "581446.jpg",
                                "catalog_id": null
                            },
                            {
                                "product_id": 150,
                                "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                                "category_name": "Lácteos",
                                "cost_price": 0.00, 
                                "unit_price": 13.00, 
                                "brand": "Colun",
                                "unit_value": 1,
                                "unit_label": "Kg",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                                "image_name": "264322.jpg",
                                "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                            }
                        ]
                    }  
                ]
            }';

//            $code_obj = json_decode($code, true);


//            $result["gift_list"] = $code_obj["gift_list"];
//            $result["promotion_list"] = $code_obj["promotion_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_CANCEL_ORDER) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_MARKET_CANCEL_ORDER, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $supplier_id = text_clean($data["supplier_id"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->cancelOrder($order_id, $supplier_id);
        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_COMPLETE_ORDER) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_MARKET_COMPLETE_ORDER, json_encode($data, JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->completeMarketSale($data);

//            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 163,
                    "pickup": "2021-03-28 20:51:55",
                    "payment_total": 26,
                    "product_list": [
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": 10,
                            "description": null
                        },
                        {
                            "product_id": 143,
                            "unit_price": 10,
                            "quantity_purchased": 1,
                            "discount_type": "type_percentage",
                            "discount": 0,
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK"
            }
            */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;
            //$result["order_id"] = 141;

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_CLAIM_GIFT) {
        $data = json_decode($param_json, true);

        debugAPIResponse(ACTION_MARKET_CLAIM_GIFT, json_encode($data, JSON_PRETTY_PRINT));

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);
        $batch_code = text_clean($data["batch_code"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->claimGift($supplier_id, $batch_code);
        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_SET_INTERESTED) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_MARKET_SET_INTERESTED, json_encode($data, JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);
        $product_id = text_clean($data["product_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->MarkAsInterested($supplier_id, $product_id);
//            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 163,
                    "product_id": 150
                }
             */


            /*$user_data["fname"] = $merchant->get_firstName();
            $user_data["lname"] = $merchant->get_lastName();
            $user_data["user_name"] = $merchant->get_userName();
            $user_data["user_type"] = $merchant->getUserType();
            $user_data["email"] = $merchant->get_email();
            $user_data["gender"] = $merchant->get_gender();
            $user_data["registration_date"] = $merchant->get_registrationDate();
            $user_data["phone_number"] = $merchant->get_phoneNumber();
            $user_data["location_address_1"] = text_export($merchant->getLocationAddress1());
            $user_data["location_address_2"] = text_export($merchant->getLocationAddress2());
            $user_data["location_city"] = text_export($merchant->get_locationCity());
            $user_data["location_state"] = text_export($merchant->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $merchant->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_GET_ORDER_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);

//            $result = getOKStatus();

            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->getOrderList();

            //goods_supplier = 0
            //cost_supplier = 1

            //cancelled / confirmed demo
            $code = '{
                "status": "OK",
                "market_order_list": [
                    {
                        "order_id": 141,
                        "order_time": "2021-03-29 09:03:40",
                        "supplier_id": 163,
                        "supplier_name": "Beverage Distribution",
                        "market_place_id": "85740397",
                        "item_count": 1,
                        "total": 100,
                        "order_status": "pending"
                    },
                    {
                        "order_id": 143,
                        "order_time": "2021-03-30 09:03:40",
                        "supplier_id": 124,
                        "supplier_name": "Salsa Distribution",
                        "market_place_id": "47564837",
                        "item_count": 2,
                        "total": 23,
                        "order_status": "confirmed"
                    },
                    {
                        "order_id": 144,
                        "order_time": "2021-03-31 09:03:40",
                        "supplier_id": 125,
                        "supplier_name": "Dairy Distribution",
                        "market_place_id": "75645382",
                        "item_count": 2,
                        "total": 200,
                        "order_status": "completed"
                    }
                ]
            }';

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "supplier_id": 163
            }
            */
            /*{
                        "order_id": 144,
                        "order_time": "2021-03-31 09:03:40",
                        "supplier_id": 125,
                        "supplier_name": "Dairy Distribution",
                        "market_place_id": "75645382",
                        "item_count": 2,
                        "total": 200,
                        "order_status": "completed"
                    }*/

//            $code_obj = json_decode($code, true);
//
//            $result["market_order_list"] = $code_obj["market_order_list"];

        }

        echo json_export($result);
    }
    if ($action == ACTION_MARKET_GET_ORDER_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $merchant = new Merchant($cornersave);
        $isVerified = $merchant->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $order_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $merchant->initializeMerchant($user_id);
            $result = (new SupplierMarketService($cornersave, $merchant->getManagerId()))->getOrderData($order_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "order_id": 143
            }
            */
            /*{
                "status": "OK",
                "order_data": {
                    "order_id": 143,
                    "order_time": "2021-03-29 09:03:40",
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "team_member_id": "55",
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "online",
                    "order_status": "pending",
                    "approved": false,
                    "payment_method": null,
                    "sale_type": "sale",
                    "pickup_time": "2021-03-31 10:03:40",
                    "product_list": [
                        {
                            "product_id": 150,
                            "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                            "category_name": "Lácteos",
                            "unit_price": 13,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                            "image_name": "264322.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": false,
                            "description": null
                        },
                        {
                            "product_id": 142,
                            "product_name": "Pan De Molde 500 Gr",
                            "category_name": "Panadería",
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                            "image_name": "704080.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": true,
                            "description": null
                        }
                    ]
                }
            }*/


            $order_data["141"]["order_id"] = 141;
            $order_data["141"]["order_time"] = "2021-03-28 20:51:55";
            $order_data["141"]["supplier_id"] = 125;
            $order_data["141"]["supplier_name"] = "Beverage Distribution";
            $order_data["141"]["order_status"] = "pending";
            $order_data["141"]["total"] = 100;
            $order_data["141"]["pickup_time"] = null;
            $product_list = '[
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["141"]["product_list"] = $product_obj;


            $order_data["143"]["order_id"] = 143;
            $order_data["143"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["143"]["supplier_id"] = 124;
            $order_data["143"]["supplier_name"] = "Salsa Distribution";
            $order_data["143"]["order_status"] = "confirmed";
            $order_data["143"]["total"] = 23;
            $order_data["143"]["pickup_time"] = "2021-03-31 10:03:40";
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["143"]["product_list"] = $product_obj;


            $order_data["144"]["order_id"] = 144;
            $order_data["144"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["144"]["supplier_id"] = 125;
            $order_data["144"]["supplier_name"] = "Dairy Distribution";
            $order_data["144"]["order_status"] = "completed";
            $order_data["144"]["pickup_time"] = "2021-03-31 10:03:40";
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 100.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": false,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 100.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["144"]["product_list"] = $product_obj;


//            if ($order_id == 141 || $order_id == 143 || $order_id == 144) {
//
//                $result = getOKStatus();
//
//                $result["order_data"] = $order_data[$order_id];
//
//            }

        }

        echo json_export($result);
    }

    /*

    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '303');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '331');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '338');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '340');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '387');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '448');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '470');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '471');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '508');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '509');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '510');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '511');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '512');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '576');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '676');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '702');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '719');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '745');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '896');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '966');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1010');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1036');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1037');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1056');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1057');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1064');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1065');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1066');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1067');*/

}


function getOrderItemList($order_id, $cornersave)
{
    $result = array();
    $items = array();
    $index = 0;


    $result["total"] = 0;
    $result["list"] = $items;

    $sale_item_query = "select * from " . TABLE_SALES_ITEMS . " where sale_id = '$order_id'";
    $sale_item_result = $cornersave->query($sale_item_query);

    $final_total = 0;

    if ($sale_item_result != null && $sale_item_result->is_row_found()) {

        while ($row = $sale_item_result->fetch_array()) {


            $item_id = $row["item_id"];
            //$description = $row["description"];
            $serialnumber = $row["serialnumber"];
            $line = $row["line"];
            $quantity_purchased = $row["quantity_purchased"];
            $item_cost_price = $row["item_cost_price"];
            $item_unit_price = $row["item_unit_price"];
            $discount = $row["discount"];
            $discount_type_raw = $row["discount_type"];
            $item_location = $row["item_location"];
            $print_option = $row["print_option"];
            $is_approved = $row["approved"] == 1;

            $discount_type = DISCOUNT_TYPE_PERCENT;
            if ($discount_type_raw == DISCOUNT_TYPE_PERCENT_CODE) {
                $discount_type = DISCOUNT_TYPE_PERCENT;
            } elseif ($discount_type_raw == DISCOUNT_TYPE_FIXED_CODE) {
                $discount_type = DISCOUNT_TYPE_FIXED;
            }


            $item_total = $quantity_purchased * $item_unit_price;
            $discounted_total = 0;

            if ($discount_type == DISCOUNT_TYPE_PERCENT) {

                if ($discount > 0) {
                    $discounted_total = $item_total - (($discount / 100) * $item_total);
                }

            } elseif ($discount_type == DISCOUNT_TYPE_PERCENT) {
                $discounted_total = $item_total - $discount;

                if ($discounted_total < 0) {
                    $discounted_total = 0;
                }
            }


            $product_item = get_product_info($item_id, $cornersave);
            if (!empty($product_item)) {
                $product_name = $product_item["product_name"];
                $category_name = $product_item["category_name"];
                $brand = $product_item["brand"];
                $unit_value = $product_item["unit_value"];
                $unit_label = $product_item["unit_label"];
                $image_url = $product_item["image_url"];
                $image_name = $product_item["image_name"];
                $description = $product_item["description"];

            } else {
                $product_name = null;
                $category_name = null;
                $brand = null;
                $unit_value = null;
                $unit_label = null;
                $image_url = null;
                $image_name = null;
                $description = null;
            }

            $items[$index]["product_id"] = intval($item_id);
            $items[$index]["product_name"] = $product_name;
            $items[$index]["category_name"] = $category_name;
            $items[$index]["unit_price"] = intval($item_unit_price);
            $items[$index]["quantity_purchased"] = intval($quantity_purchased);
            $items[$index]["brand"] = $brand;
            $items[$index]["unit_value"] = intval($unit_value);
            $items[$index]["unit_label"] = $unit_label;
            $items[$index]["image_url"] = $image_url;
            $items[$index]["image_name"] = $image_name;
            $items[$index]["discount_type"] = $discount_type;
            $items[$index]["discount"] = $discount;
            $items[$index]["in_stock"] = $is_approved;
            $items[$index]["description"] = $description;


            $final_total += $discounted_total;

            $index++;
        }


    }

    if (!empty($items)) {
        $result["total"] = $final_total;
        $result["list"] = $items;
    }

    return $result;
}

function is_category_in_country($category_id, $country_code, $cornersave)
{
    $sql_query = "select * from " . TABLE_CATALOG . " where category_id = '$category_id' group by country_code";
    $sql_query_result = $cornersave->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        while ($row = $sql_query_result->fetch_array()) {
            if ($row["country_code"] == $country_code) {
                return true;
            }
        }
    }

    return false;
}

/**/

function generate_category_code($category_name)
{
    $lowered = strtolower($category_name);
    return str_replace(" ", "+", $lowered);
}

//todo : fix
function generate_category_name($category_code)
{
    $category_name = str_replace("+", " ", $category_code);
    //$category_name = remove_accents($category_name);
    //$category_name = clean($category_name);

    return $category_name;
}

function get_catalog_category($category_id, $cornersave)
{
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_CATEGORY . " where category_id = '$category_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if ($catalog_result != null && $catalog_result->is_row_found()) {
        if ($row = $catalog_result->fetch_array()) {
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}

function get_catalog_brand($brand_id, $cornersave)
{
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_BRAND . " where brand_id = '$brand_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if ($catalog_result != null && $catalog_result->is_row_found()) {
        if ($row = $catalog_result->fetch_array()) {
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}

function get_catalog_label($unit_label_id, $cornersave)
{
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_UNIT . " where unit_label_id = '$unit_label_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if ($catalog_result != null && $catalog_result->is_row_found()) {
        if ($row = $catalog_result->fetch_array()) {
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}

function get_product_quantity($product_id, $cornersave)
{
    $result = 0;

    $item_query = "select * from " . TABLE_ITEM_QUANTITY . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_found()) {
        if ($row = $item_result->fetch_array()) {
            $result = intval($row["quantity"]);
        }
    }

    return $result;
}

//todo : update inventory on quantity change


function update_product_quantity($product_id, $product_qty, $merchant, $cornersave)
{
    $result = false;

    $item_query = "update " . TABLE_ITEM_QUANTITY . " set quantity = $product_qty where item_id = '$product_id'";
//    echo "\n$item_query\n";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_affected()) {
        $result = true;
    }

    return $result;
}

function add_product_quantity($product_id, $merchant, $cornersave)
{
    $result = false;

    //$manager_id = $merchant->getManagerId();
    //$user_id = $merchant->get_userId();

    $sql_query = "insert into " . TABLE_ITEM_QUANTITY . " (item_id, location_id, quantity) values ('$product_id', 1, 0)";
    $sql_query_result = $cornersave->query($sql_query);
    if ($sql_query_result != null && $sql_query_result->is_row_affected()) {
        $result = true;
    }

    return $result;
}

function add_inventory($product_id, $inventory_value, $inventory_log, $merchant, $cornersave)
{
    $result = false;

    $manager_id = $merchant->getManagerId();
    $user_id = $merchant->get_userId();

    $sql_query = "insert into " . TABLE_INVENTORY . " (trans_items, trans_user, trans_comment, trans_location, trans_inventory, manager_id) values ('$product_id','$user_id','$inventory_log',1,'$inventory_value','$manager_id')";
    $sql_query_result = $cornersave->query($sql_query);
    if ($sql_query_result != null && $sql_query_result->is_row_affected()) {
        $result = true;
    }

    return $result;
}


//todo: in progress
function catalog_is_in_store($catalog_id, $merchant, $cornersave)
{
    $in_store = false;

    $manager_id = $merchant->getManagerId();

    $sql_query = "select * from " . TABLE_ITEMS . " where catalog_id = '$catalog_id' and manager_id = '$manager_id'";
    $sql_query_result = $cornersave->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        $in_store = true;
    }

    return $in_store;
}

function catalog_add_to_store($catalog_id, $merchant, $cornersave)
{
    $result = false;
    $manager_id = $merchant->getManagerId();

    $in_store = catalog_is_in_store($catalog_id, $merchant, $cornersave);

    if ($in_store) {
        return false;
    }

    $catalog_item = get_catalog_info($catalog_id, $merchant, $cornersave);

    $name = null;
    $category = null;
    $receiving_quantity = 0;
    $pic_filename = null;
    //$manager_id = null;
    $brand = null;
    $unit_label = null;
    $unit_value = 0;
    $catalog_id = null;

    if ($catalog_item != null) {
        $name = $catalog_item["product_name"];
        $category = $catalog_item["category_name"];
        $receiving_quantity = 0;
        $pic_filename = $catalog_item["image_name"];
        //$manager_id = $manager_id;
        $brand = $catalog_item["brand"];
        $unit_label = $catalog_item["unit_label"];
        $unit_value = $catalog_item["unit_value"];
        $catalog_id = $catalog_item["catalog_id"];

        $sql_query = "insert into " . TABLE_ITEMS . " (`name`, category, receiving_quantity, pic_filename, manager_id, brand, unit_label, unit_value, catalog_id) values ('$name', '$category', '$receiving_quantity', '$pic_filename', '$manager_id', '$brand', '$unit_label', '$unit_value', '$catalog_id')";
        $sql_query_result = $cornersave->query($sql_query);
        if ($sql_query_result != null && $sql_query_result->is_row_affected()) {

            $product_id = $sql_query_result->insert_id();
            add_product_quantity($product_id, $manager_id, $cornersave);
            add_inventory($product_id, 0, INVENTORY_LOG_FROM_CATALOG, $merchant, $cornersave);

            $result = array();
            $result["product_id"] = $product_id;


        }
    }

    return $result;
}

function get_catalog_info($catalog_id, $merchant, $cornersave)
{
    $result = null;

    $result = array();

    $catalog_query = "select * from " . TABLE_CATALOG . " where catalog_id = '$catalog_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if ($catalog_result != null && $catalog_result->is_row_found()) {
        if ($row = $catalog_result->fetch_array()) {
            $result = array();

            $brand = get_catalog_brand($row["brand_id"], $cornersave);
            $category = get_catalog_category($row["category_id"], $cornersave);
            $unit_label = get_catalog_label($row["unit_label_id"], $cornersave);

            $result["catalog_id"] = $catalog_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $category;
            $result["brand"] = $brand;
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $unit_label;
            $result["image_url"] = IMG_ITEM_ROOT . $row["file_name"];
            $result["image_name"] = $row["file_name"];
            $result["in_store"] = catalog_is_in_store($catalog_id, $merchant, $cornersave);

        }
    }

    return $result;
}

//todo: fix in app (process null for barcode) (unit value to integer)
function get_product_info($product_id, $cornersave)
{
    $result = null;

    $result = array();

    $item_query = "select * from " . TABLE_ITEMS . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_found()) {
        if ($row = $item_result->fetch_array()) {

            $product_id = intval($row["item_id"]);
            $product_qty = get_product_quantity($product_id, $cornersave);


            $result["product_id"] = $product_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $row["category"];
            $result["cost_price"] = intval($row["cost_price"]);
            $result["unit_price"] = intval($row["unit_price"]);
            $result["quantity"] = $product_qty;
            $result["brand"] = $row["brand"] == null ? "" : $row["brand"];
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $row["unit_label"];
            $result["image_url"] = IMG_ITEM_ROOT . $row["pic_filename"];
            $result["image_name"] = $row["pic_filename"];
            $result["catalog_id"] = $row["catalog_id"];
            $result["product_type"] = PRODUCT_TYPE_ITEM; //$row["product_type"];//not used (stock type)
            $result["barcode"] = $row["item_number"] == null ? "" : $row["item_number"];


            $result["stock_type"] = ($row["stock_type"] == 0) ? "stock" : "non_stock";
            $result["supplier_id"] = intval($row["supplier_id"]);
            $result["receiving_quantity"] = intval($row["receiving_quantity"]);
            $result["reorder_level"] = intval($row["reorder_level"]);
            $result["description"] = $row["description"] == null ? "" : $row["description"];
        }
    }

    return $result;
}

function get_person_info($person_id, $cornersave)
{
    $result = null;

    $result = array();

    $person_query = "select * from " . TABLE_PEOPLE . " where person_id = '$person_id'";
    $person_result = $cornersave->query($person_query);

    if ($person_result != null && $person_result->is_row_found()) {
        if ($row = $person_result->fetch_array()) {
            $result = array();

            // user_ref_id, created_on, deleted, deleted_on, date_of_birth

            //$brand = get_catalog_brand($row["brand_id"],$cornersave);
            //$category = get_catalog_category($row["category_id"],$cornersave);
            //$unit_label = get_catalog_label($row["unit_label_id"],$cornersave);

            $gender = null;

            if ($row["gender"] == GENDER_MALE_CODE) {
                $gender = GENDER_MALE;
            } elseif ($row["gender"] == GENDER_FEMALE_CODE) {
                $gender = GENDER_FEMALE;
            } elseif ($row["gender"] == GENDER_NOT_TO_SAY_CODE) {
                $gender = GENDER_NOT_TO_SAY;
            }

            $result["person_id"] = $row["person_id"];
            $result["first_name"] = $row["first_name"];
            $result["last_name"] = $row["last_name"];
            $result["gender_code"] = $row["gender"];
            $result["gender"] = $gender;
            $result["phone_number"] = $row["phone_number"];
            $result["email"] = $row["email"];
            $result["address_1"] = $row["address_1"];
            $result["address_2"] = $row["address_2"];
            $result["city"] = $row["city"];
            $result["state"] = $row["state"];
            $result["zip"] = $row["zip"];
            $result["country"] = $row["country"];
            $result["comments"] = $row["comments"];
            $result["user_type"] = $row["user_type"];
            $result["user_ref_id"] = $row["user_ref_id"];
            $result["created_on"] = $row["created_on"];
            $result["deleted"] = $row["deleted"];
            $result["deleted_on"] = $row["deleted_on"];
            $result["date_of_birth"] = $row["date_of_birth"];
            $result["is_verified_code"] = $row["is_verified"];
            $result["is_verified"] = ($row["is_verified"] == 1);

        }
    }

    return $result;
}


//fixme - customer_total_spent
function customer_total_spent($customer_id, $manager_id, $cornersave)
{
    $result = 0;

    $sales_query = "select * from " . TABLE_SALES . " where customer_id = '$customer_id' and manager_id = '$manager_id'";
    $sales_result = $cornersave->query($sales_query);

    /*
    if($sales_result != null && $sales_result->is_row_found()){
        if ($row = $sales_result->fetch_array()){
            $result = array();

            // user_ref_id, created_on, deleted, deleted_on, date_of_birth

            //$brand = get_catalog_brand($row["brand_id"],$cornersave);
            //$category = get_catalog_category($row["category_id"],$cornersave);
            //$unit_label = get_catalog_label($row["unit_label_id"],$cornersave);

            $gender = null;

            if ($row["gender"] == GENDER_MALE_CODE){
                $gender = GENDER_MALE;
            }
            elseif($row["gender"] == GENDER_FEMALE_CODE){
                $gender = GENDER_FEMALE;
            }
            elseif($row["gender"] == GENDER_NOT_TO_SAY_CODE){
                $gender = GENDER_NOT_TO_SAY;
            }

            $result["person_id"] = $row["person_id"];
            $result["first_name"] = $row["first_name"];
            $result["last_name"] = $row["last_name"];
            $result["gender_code"] = $row["gender"];
            $result["gender"] = $gender;
            $result["phone_number"] = $row["phone_number"];
            $result["email"] = $row["email"];
            $result["address_1"] = $row["address_1"];
            $result["address_2"] = $row["address_2"];
            $result["city"] = $row["city"];
            $result["state"] = $row["state"];
            $result["zip"] = $row["zip"];
            $result["country"] = $row["country"];
            $result["comments"] = $row["comments"];
            $result["user_type"] = $row["user_type"];
            $result["user_ref_id"] = $row["user_ref_id"];
            $result["created_on"] = $row["created_on"];
            $result["deleted"] = $row["deleted"];
            $result["deleted_on"] = $row["deleted_on"];
            $result["date_of_birth"] = $row["date_of_birth"];
            $result["is_verified_code"] = $row["is_verified"];
            $result["is_verified"] = ($row["is_verified"] == 1);

        }
    }
    */

    return $result;
}


//TODO : API DEBUG : Localizaton (convert localization string to localization value)
function get_localizations()
{
    return array(
        'aa-DJ' => 'Afar (Djibouti)',
        'aa-ER' => 'Afar (Eritrea)',
        'aa-ET' => 'Afar (Ethiopia)',
        'af-ZA' => 'Afrikaans (South Africa)',
        'sq-AL' => 'Albanian (Albania)',
        'sq-MK' => 'Albanian (Macedonia)',
        'am-ET' => 'Amharic (Ethiopia)',
        'ar-DZ' => 'Arabic (Algeria)',
        'ar-BH' => 'Arabic (Bahrain)',
        'ar-EG' => 'Arabic (Egypt)',
        'ar-IN' => 'Arabic (India)',
        'ar-IQ' => 'Arabic (Iraq)',
        'ar-JO' => 'Arabic (Jordan)',
        'ar-KW' => 'Arabic (Kuwait)',
        'ar-LB' => 'Arabic (Lebanon)',
        'ar-LY' => 'Arabic (Libya)',
        'ar-MA' => 'Arabic (Morocco)',
        'ar-OM' => 'Arabic (Oman)',
        'ar-QA' => 'Arabic (Qatar)',
        'ar-SA' => 'Arabic (Saudi Arabia)',
        'ar-SD' => 'Arabic (Sudan)',
        'ar-SY' => 'Arabic (Syria)',
        'ar-TN' => 'Arabic (Tunisia)',
        'ar-AE' => 'Arabic (United Arab Emirates)',
        'ar-YE' => 'Arabic (Yemen)',
        'an-ES' => 'Aragonese (Spain)',
        'hy-AM' => 'Armenian (Armenia)',
        'as-IN' => 'Assamese (India)',
        'ast-ES' => 'Asturian (Spain)',
        'az-AZ' => 'Azerbaijani (Azerbaijan)',
        'az-TR' => 'Azerbaijani (Turkey)',
        'eu-FR' => 'Basque (France)',
        'eu-ES' => 'Basque (Spain)',
        'be-BY' => 'Belarusian (Belarus)',
        'bem-ZM' => 'Bemba (Zambia)',
        'bn-BD' => 'Bengali (Bangladesh)',
        'bn-IN' => 'Bengali (India)',
        'ber-DZ' => 'Berber (Algeria)',
        'ber-MA' => 'Berber (Morocco)',
        'byn-ER' => 'Blin (Eritrea)',
        'bs-BA' => 'Bosnian (Bosnia and Herzegovina)',
        'br-FR' => 'Breton (France)',
        'bg-BG' => 'Bulgarian (Bulgaria)',
        'my-MM' => 'Burmese (Myanmar [Burma])',
        'ca-AD' => 'Catalan (Andorra)',
        'ca-FR' => 'Catalan (France)',
        'ca-IT' => 'Catalan (Italy)',
        'ca-ES' => 'Catalan (Spain)',
        'zh-CN' => 'Chinese (China)',
        'zh-HK' => 'Chinese (Hong Kong SAR China)',
        'zh-SG' => 'Chinese (Singapore)',
        'zh_TW' => 'Chinese (Taiwan)',
        'cv_RU' => 'Chuvash (Russia)',
        'kw_GB' => 'Cornish (United Kingdom)',
        'crh_UA' => 'Crimean Turkish (Ukraine)',
        'hr_HR' => 'Croatian (Croatia)',
        'cs_CZ' => 'Czech (Czech Republic)',
        'da_DK' => 'Danish (Denmark)',
        'dv-MV' => 'Divehi (Maldives)',
        'nl-AW' => 'Dutch (Aruba)',
        'nl-BE' => 'Dutch (Belgium)',
        'nl-NL' => 'Dutch (Netherlands)',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'en-AG' => 'English (Antigua and Barbuda)',
        'en-AU' => 'English (Australia)',
        'en-BW' => 'English (Botswana)',
        'en-BB' => 'English (Barbados)',
        'en-CA' => 'English (Canada)',
        'en-DK' => 'English (Denmark)',
        'en-HK' => 'English (Hong Kong SAR China)',
        'en-IN' => 'English (India)',
        'en-IE' => 'English (Ireland)',
        'en-JM' => 'English (Jamaica)',
        'en-NZ' => 'English (New Zealand)',
        'en-NG' => 'English (Nigeria)',
        'en-PH' => 'English (Philippines)',
        'en-SG' => 'English (Singapore)',
        'en-ZA' => 'English (South Africa)',
        'en-TT' => 'English (Trinidad and Tobago)',
        'en-GB' => 'English (United Kingdom)',
        'en-US' => 'English (United States)',
        'en-ZM' => 'English (Zambia)',
        'en-ZW' => 'English (Zimbabwe)',
        'eo' => 'Esperanto',
        'et-EE' => 'Estonian (Estonia)',
        'fo-FO' => 'Faroese (Faroe Islands)',
        'fil-PH' => 'Filipino (Philippines)',
        'fi-FI' => 'Finnish (Finland)',
        'fr-BE' => 'French (Belgium)',
        'fr-CA' => 'French (Canada)',
        'fr-FR' => 'French (France)',
        'fr-LU' => 'French (Luxembourg)',
        'fr-CH' => 'French (Switzerland)',
        'fur-IT' => 'Friulian (Italy)',
        'ff-SN' => 'Fulah (Senegal)',
        'gl-ES' => 'Galician (Spain)',
        'lg-UG' => 'Ganda (Uganda)',
        'gez-ER' => 'Geez (Eritrea)',
        'gez-ET' => 'Geez (Ethiopia)',
        'ka-GE' => 'Georgian (Georgia)',
        'de-AT' => 'German (Austria)',
        'de-BE' => 'German (Belgium)',
        'de-DE' => 'German (Germany)',
        'de-LI' => 'German (Liechtenstein)',
        'de-LU' => 'German (Luxembourg)',
        'de-CH' => 'German (Switzerland)',
        'el-CY' => 'Greek (Cyprus)',
        'el-GR' => 'Greek (Greece)',
        'gu-IN' => 'Gujarati (India)',
        'ht-HT' => 'Haitian (Haiti)',
        'ha-NG' => 'Hausa (Nigeria)',
        'iw-IL' => 'Hebrew (Israel)',
        'he-IL' => 'Hebrew (Israel)',
        'hi-IN' => 'Hindi (India)',
        'hu-HU' => 'Hungarian (Hungary)',
        'is-IS' => 'Icelandic (Iceland)',
        'ig-NG' => 'Igbo (Nigeria)',
        'id-ID' => 'Indonesian (Indonesia)',
        'ia' => 'Interlingua',
        'iu-CA' => 'Inuktitut (Canada)',
        'ik-CA' => 'Inupiaq (Canada)',
        'ga-IE' => 'Irish (Ireland)',
        'it-IT' => 'Italian (Italy)',
        'it-CH' => 'Italian (Switzerland)',
        'ja-JP' => 'Japanese (Japan)',
        'kl-GL' => 'Kalaallisut (Greenland)',
        'kn-IN' => 'Kannada (India)',
        'ks-IN' => 'Kashmiri (India)',
        'csb-PL' => 'Kashubian (Poland)',
        'kk-KZ' => 'Kazakh (Kazakhstan)',
        'km-KH' => 'Khmer (Cambodia)',
        'rw-RW' => 'Kinyarwanda (Rwanda)',
        'ky-KG' => 'Kirghiz (Kyrgyzstan)',
        'kok-IN' => 'Konkani (India)',
        'ko-KR' => 'Korean (South Korea)',
        'ku-TR' => 'Kurdish (Turkey)',
        'lo-LA' => 'Lao (Laos)',
        'lv-LV' => 'Latvian (Latvia)',
        'li-BE' => 'Limburgish (Belgium)',
        'li-NL' => 'Limburgish (Netherlands)',
        'lt-LT' => 'Lithuanian (Lithuania)',
        'nds-DE' => 'Low German (Germany)',
        'nds-NL' => 'Low German (Netherlands)',
        'mk-MK' => 'Macedonian (Macedonia)',
        'mai-IN' => 'Maithili (India)',
        'mg-MG' => 'Malagasy (Madagascar)',
        'ms-MY' => 'Malay (Malaysia)',
        'ml-IN' => 'Malayalam (India)',
        'mt-MT' => 'Maltese (Malta)',
        'gv-GB' => 'Manx (United Kingdom)',
        'mi-NZ' => 'Maori (New Zealand)',
        'mr-IN' => 'Marathi (India)',
        'mn-MN' => 'Mongolian (Mongolia)',
        'ne-NP' => 'Nepali (Nepal)',
        'se-NO' => 'Northern Sami (Norway)',
        'nso-ZA' => 'Northern Sotho (South Africa)',
        'nb-NO' => 'Norwegian Bokmål (Norway)',
        'nn-NO' => 'Norwegian Nynorsk (Norway)',
        'oc-FR' => 'Occitan (France)',
        'or-IN' => 'Oriya (India)',
        'om-ET' => 'Oromo (Ethiopia)',
        'om-KE' => 'Oromo (Kenya)',
        'os-RU' => 'Ossetic (Russia)',
        'pap-AN' => 'Papiamento (Netherlands Antilles)',
        'ps-AF' => 'Pashto (Afghanistan)',
        'fa-IR' => 'Persian (Iran)',
        'pl-PL' => 'Polish (Poland)',
        'pt-BR' => 'Portuguese (Brazil)',
        'pt-PT' => 'Portuguese (Portugal)',
        'pa-IN' => 'Punjabi (India)',
        'pa-PK' => 'Punjabi (Pakistan)',
        'ro-RO' => 'Romanian (Romania)',
        'ru-RU' => 'Russian (Russia)',
        'ru-UA' => 'Russian (Ukraine)',
        'sa-IN' => 'Sanskrit (India)',
        'sc-IT' => 'Sardinian (Italy)',
        'gd-GB' => 'Scottish Gaelic (United Kingdom)',
        'sr-ME' => 'Serbian (Montenegro)',
        'sr-RS' => 'Serbian (Serbia)',
        'sid-ET' => 'Sidamo (Ethiopia)',
        'sd-IN' => 'Sindhi (India)',
        'si-LK' => 'Sinhala (Sri Lanka)',
        'sk-SK' => 'Slovak (Slovakia)',
        'sl-SI' => 'Slovenian (Slovenia)',
        'so-DJ' => 'Somali (Djibouti)',
        'so-ET' => 'Somali (Ethiopia)',
        'so-KE' => 'Somali (Kenya)',
        'so-SO' => 'Somali (Somalia)',
        'nr-ZA' => 'South Ndebele (South Africa)',
        'st-ZA' => 'Southern Sotho (South Africa)',
        'es-AR' => 'Spanish (Argentina)',
        'es-BO' => 'Spanish (Bolivia)',
        'es-CL' => 'Spanish (Chile)',
        'es-CO' => 'Spanish (Colombia)',
        'es-CR' => 'Spanish (Costa Rica)',
        'es-DO' => 'Spanish (Dominican Republic)',
        'es-EC' => 'Spanish (Ecuador)',
        'es-SV' => 'Spanish (El Salvador)',
        'es-GT' => 'Spanish (Guatemala)',
        'es-HN' => 'Spanish (Honduras)',
        'es-MX' => 'Spanish (Mexico)',
        'es-NI' => 'Spanish (Nicaragua)',
        'es-PA' => 'Spanish (Panama)',
        'es-PY' => 'Spanish (Paraguay)',
        'es-PE' => 'Spanish (Peru)',
        'es-ES' => 'Spanish (Spain)',
        'es-US' => 'Spanish (United States)',
        'es-UY' => 'Spanish (Uruguay)',
        'es-VE' => 'Spanish (Venezuela)',
        'sw-KE' => 'Swahili (Kenya)',
        'sw-TZ' => 'Swahili (Tanzania)',
        'ss-ZA' => 'Swati (South Africa)',
        'sv-FI' => 'Swedish (Finland)',
        'sv-SE' => 'Swedish (Sweden)',
        'tl-PH' => 'Tagalog (Philippines)',
        'tg-TJ' => 'Tajik (Tajikistan)',
        'ta-IN' => 'Tamil (India)',
        'tt-RU' => 'Tatar (Russia)',
        'te-IN' => 'Telugu (India)',
        'th-TH' => 'Thai (Thailand)',
        'bo-CN' => 'Tibetan (China)',
        'bo-IN' => 'Tibetan (India)',
        'tig-ER' => 'Tigre (Eritrea)',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Ethiopia)',
        'ts-ZA' => 'Tsonga (South Africa)',
        'tn-ZA' => 'Tswana (South Africa)',
        'tr-CY' => 'Turkish (Cyprus)',
        'tr-TR' => 'Turkish (Turkey)',
        'tk-TM' => 'Turkmen (Turkmenistan)',
        'ug-CN' => 'Uighur (China)',
        'uk-UA' => 'Ukrainian (Ukraine)',
        'hsb-DE' => 'Upper Sorbian (Germany)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz-UZ' => 'Uzbek (Uzbekistan)',
        've-ZA' => 'Venda (South Africa)',
        'vi-VN' => 'Vietnamese (Vietnam)',
        'wa-BE' => 'Walloon (Belgium)',
        'cy-GB' => 'Welsh (United Kingdom)',
        'fy-DE' => 'Western Frisian (Germany)',
        'fy-NL' => 'Western Frisian (Netherlands)',
        'wo-SN' => 'Wolof (Senegal)',
        'xh-ZA' => 'Xhosa (South Africa)',
        'yi-US' => 'Yiddish (United States)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'zu-ZA' => 'Zulu (South Africa)'
    );
}

function reverse_localization($string_locale)
{
    $localization_list = get_localizations();

    foreach ($localization_list as $num_locale => $str_locale) {
        if ($string_locale == $str_locale) {
            return $num_locale;
        }
    }
    return null;
}

function locale_converter($number_locale, $value)
{
    $result = array();

    $formatted_locale = str_replace('_', '-', $number_locale);

    $fmt = new NumberFormatter($formatted_locale, NumberFormatter::DECIMAL);

    //$separator = $fmt->getSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL);
    //$fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, 2);
    //$fmt->setSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, "*");


    $result["number_locale"] = str_replace('_', '-', $fmt->getLocale());
    $result["currency_code"] = $fmt->getSymbol(NumberFormatter::INTL_CURRENCY_SYMBOL);
    $result["currency_symbol"] = $fmt->getSymbol(NumberFormatter::CURRENCY_SYMBOL);
    $result["converted_value"] = $fmt->format($value);

    return $result;
}

function getConfigData($language = DEFAULT_LANGUAGE, $language_code = DEFAULT_LOCALE, $store_type = STORE_TYPE_GROCERYSTORE, $country_code = DEFAULT_COUNTRY_CODE)
{
    $is_discoverable = "1";

    $config = array();
    $config["address"] = "--";
    $config["allow_duplicate_barcodes"] = "0";
    $config["barcode_content"] = "id";
    $config["barcode_first_row"] = "category";
    $config["barcode_font"] = "Arial";
    $config["barcode_font_size"] = "10";
    $config["barcode_formats"] = "[]";
    $config["barcode_generate_if_empty"] = "0";
    $config["barcode_height"] = "50";
    $config["barcode_num_in_row"] = "2";
    $config["barcode_page_cellspacing"] = "20";
    $config["barcode_page_width"] = "100";
    $config["barcode_second_row"] = "item_code";
    $config["barcode_third_row"] = "unit_price";
    //$config["barcode_type"] = "Code39";
    $config["barcode_type"] = "Ean13";
    $config["barcode_width"] = "250";
    $config["cash_decimals"] = "2";
    $config["cash_rounding_code"] = "1";
    $config["category_dropdown"] = "0";
    $config["company"] = "Cornersave Store";
    //$config["company_logo"] = "company_logo.png";
    $config["company_logo"] = "no_store.png";
    $config["country_codes"] = $country_code;
    $config["currency_code"] = "USD";
    $config["currency_decimals"] = "2";
    $config["currency_symbol"] = "$";
    $config["customer_reward_enable"] = "0";
    $config["dateformat"] = "m/d/Y";
    $config["date_or_time_format"] = "";
    $config["default_receivings_discount"] = "0";
    $config["default_receivings_discount_type"] = "0";
    $config["default_register_mode"] = "sale";
    $config["default_sales_discount"] = "0";
    $config["default_sales_discount_type"] = "0";
    $config["default_tax_1_name"] = "";
    $config["default_tax_1_rate"] = "";
    $config["default_tax_2_name"] = "";
    $config["default_tax_2_rate"] = "";
    $config["default_tax_category"] = "";
    $config["default_tax_code"] = "";
    $config["default_tax_jurisdiction"] = "";
    $config["default_tax_rate"] = "8";
    $config["derive_sale_quantity"] = "0";
    $config["dinner_table_enable"] = "0";
    $config["discoverable"] = $is_discoverable;
    $config["email"] = "[changeme@example.com]";
    $config["email_receipt_check_behaviour"] = "last";
    $config["enforce_privacy"] = "";
    $config["fax"] = "";
    $config["financial_year"] = "1";
    $config["gcaptcha_enable"] = "0";
    $config["gcaptcha_secret_key"] = "";
    $config["gcaptcha_site_key"] = "";
    $config["giftcard_number"] = "series";
    $config["image_allowed_types"] = "jpg|gif|png";
    $config["image_max_height"] = "480";
    $config["image_max_size"] = "128";
    $config["image_max_width"] = "640";
    $config["include_hsn"] = "0";
    $config["invoice_default_comments"] = "This is a default comment";
    $config["invoice_email_message"] = "Dear {CU}, In attachment the receipt for sale {ISEQ}";
    $config["invoice_enable"] = "1";
    $config["invoice_type"] = "invoice";
    $config["language"] = $language;
    $config["language_code"] = $language_code;
    $config["last_used_invoice_number"] = "0";
    $config["last_used_quote_number"] = "0";
    $config["last_used_work_order_number"] = "0";
    $config["lines_per_page"] = "25";
    $config["line_sequence"] = "0";
    $config["mailpath"] = "/usr/sbin/sendmail";
    $config["msg_msg"] = "";
    $config["msg_pwd"] = "";
    $config["msg_src"] = "";
    $config["msg_uid"] = "";
    $config["multi_pack_enabled"] = "0";
    $config["notify_horizontal_position"] = "center";
    $config["notify_vertical_position"] = "bottom";
    $config["number_locale"] = "en-US";
    $config["payment_options_order"] = "cashdebitcredit";
    $config["phone"] = "555-555-5555";
    $config["print_bottom_margin"] = "0";
    $config["print_delay_autoreturn"] = "0";
    $config["print_footer"] = "0";
    $config["print_header"] = "0";
    $config["print_left_margin"] = "0";
    $config["print_left_margin"] = "0";
    $config["print_receipt_check_behaviour"] = "last";
    $config["print_right_margin"] = "0";
    $config["print_silently"] = "1";
    $config["print_top_margin"] = "0";
    $config["protocol"] = "mail";
    $config["quantity_decimals"] = "0";
    $config["quote_default_comments"] = "This is a default quote comment";
    $config["receipt_font_size"] = "12";
    $config["receipt_show_company_name"] = "1";
    $config["receipt_show_description"] = "1";
    $config["receipt_show_serialnumber"] = "1";
    $config["receipt_show_taxes"] = "0";
    $config["receipt_show_tax_ind"] = "0";
    $config["receipt_show_total_discount"] = "1";
    $config["receipt_template"] = "receipt_default";
    $config["receiving_calculate_average_price"] = "0";
    $config["recv_invoice_format"] = "{CO}";
    $config["return_policy"] = "Test";
    $config["sales_invoice_format"] = "{CO}";
    $config["sales_quote_format"] = "Q%y{QSEQ:6}";
    $config["smtp_crypto"] = "ssl";
    $config["smtp_host"] = "";
    $config["smtp_pass"] = "";
    $config["smtp_port"] = "465";
    $config["smtp_timeout"] = "5";
    $config["smtp_user"] = "";
    $config["store_type"] = $store_type;
    $config["suggestions_first_column"] = "name";
    $config["suggestions_second_column"] = "";
    $config["suggestions_third_column"] = "";
    $config["tax_decimals"] = "2";
    $config["tax_id"] = "GCT";
    $config["tax_included"] = "0";
    //$config["theme"] = "cerulean";
    $config["theme"] = "lumen";
    $config["thousands_separator"] = "1";
    $config["timeformat"] = "H:i:s";
    $config["timezone"] = "America/New_York";
    $config["use_destination_based_tax"] = "0";
    $config["website"] = "";
    $config["work_order_enable"] = "0";
    $config["work_order_format"] = "W%y{WSEQ:6}";
    $config["store_price"] = "0";
    $config["data_market_status"] = "0";

    return $config;
}

function get_default_modules()
{
    $default_modules = array();

    $default_modules["home"] = "both";
    $default_modules["customers"] = "home";
    $default_modules["items"] = "home";

    $default_modules["item_kits"] = "home";
    $default_modules["suppliers"] = "home";
    $default_modules["reports"] = "home";
    $default_modules["receivings"] = "home";
    $default_modules["sales"] = "home";
    $default_modules["giftcards"] = "home";
    $default_modules["messages"] = "home";
    $default_modules["taxes"] = "home";
    //$default_modules["attributes"] = "home";
    $default_modules["expenses"] = "home";
    $default_modules["expenses_categories"] = "home";
    //$default_modules["cashups"] = "home";
    $default_modules["config"] = "home";
    $default_modules["office"] = "home";
    $default_modules["employees"] = "office";
    $default_modules["preorders"] = "home";
    $default_modules["catalog"] = "home";
    //$default_modules["managers"] = "office";


    return $default_modules;
}

function get_default_permissions()
{
    $default_permissions = array();

    $default_permissions["items_stock"] = "";
    $default_permissions["reports_categories"] = "";
    $default_permissions["reports_customers"] = "";
    $default_permissions["reports_discounts"] = "";
    $default_permissions["reports_employees"] = "";
    $default_permissions["reports_expenses_categories"] = "";
    $default_permissions["reports_inventory"] = "";
    $default_permissions["reports_items"] = "";
    $default_permissions["reports_payments"] = "";
    $default_permissions["reports_receivings"] = "";
    $default_permissions["reports_sales"] = "";
    $default_permissions["reports_sales_taxes"] = "";
    $default_permissions["reports_suppliers"] = "";
    $default_permissions["reports_taxes"] = "";
    $default_permissions["sales_change_price"] = "";
    $default_permissions["sales_delete"] = "";
    $default_permissions["sales_stock"] = "";
    $default_permissions["receivings_stock"] = "";

    return $default_permissions;
}

function get_disabled_modules()
{
    $disabled_modules = array();

    //$disabled_modules["employees"] = "";
    $disabled_modules["attributes"] = "";
    $disabled_modules["managers"] = "";
    $disabled_modules["none"] = "";

    return $disabled_modules;
}

function get_disabled_permissions()
{
    $disabled_permissions = array();

    //$disabled_permissions["employees"] = "";
    $disabled_permissions["attributes"] = "";
    $disabled_permissions["cashups"] = "";
    $disabled_permissions["managers"] = "";

    return $disabled_permissions;
}


function get_menu_group()
{
    $menu_group = array();

    $menu_group["home"] = "both";
    $menu_group["customers"] = "home";
    $menu_group["items"] = "home";
    $menu_group["item_kits"] = "home";
    $menu_group["suppliers"] = "home";
    $menu_group["reports"] = "home";
    $menu_group["receivings"] = "home";
    $menu_group["sales"] = "home";
    $menu_group["giftcards"] = "home";
    $menu_group["messages"] = "home";
    $menu_group["taxes"] = "home";
    $menu_group["expenses"] = "home";
    $menu_group["expenses_categories"] = "home";
    $menu_group["config"] = "home";
    $menu_group["office"] = "home";
    $menu_group["employees"] = "office";
    $menu_group["preorders"] = "home";
    $menu_group["catalog"] = "home";

    $menu_group["cashups"] = "home";
    $menu_group["attributes"] = "home";
    $menu_group["managers"] = "office";

    $menu_group["items_stock"] = "--";
    $menu_group["receivings_stock"] = "--";
    $menu_group["reports_categories"] = "--";
    $menu_group["reports_customers"] = "--";
    $menu_group["reports_discounts"] = "--";
    $menu_group["reports_employees"] = "--";
    $menu_group["reports_expenses_categories"] = "--";
    $menu_group["reports_inventory"] = "--";
    $menu_group["reports_items"] = "--";
    $menu_group["reports_payments"] = "--";
    $menu_group["reports_receivings"] = "--";
    $menu_group["reports_sales"] = "--";
    $menu_group["reports_sales_taxes"] = "--";
    $menu_group["reports_suppliers"] = "--";
    $menu_group["reports_taxes"] = "--";
    $menu_group["sales_change_price"] = "--";
    $menu_group["sales_delete"] = "--";
    $menu_group["sales_stock"] = "--";

    return $menu_group;
}


function get_all_modules($cornersave)
{
    $module = array();


    $module_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $module_result = $cornersave->query($module_query);

    if ($module_result != null && $module_result->is_row_found()) {
        while ($row = $module_result->fetch_array()) {
            $module[] = $row["module_id"];
        }
    }

    return $module;
}

function get_all_permissions($cornersave)
{
    $permission = array();

    $permission_query = "select * from " . TABLE_ALL_PERMISSIONS;
    $permission_result = $cornersave->query($permission_query);

    if ($permission_result != null && $permission_result->is_row_found()) {
        while ($row = $permission_result->fetch_array()) {
            $permission[] = $row["permission_id"];
        }
    }

    return $permission;
}

function get_user_permissions($manager_id, $cornersave)
{
    $permission = array();

    $permission_query = "select * from " . TABLE_USER_PERMISSIONS . " where person_id = " . $manager_id;
    $permission_result = $cornersave->query($permission_query);

    if ($permission_result != null && $permission_result->is_row_found()) {
        while ($row = $permission_result->fetch_array()) {
            $permission[] = $row["permission_id"];
        }
    }

    return $permission;
}


/*
 * Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : Main class for all operations relating to merchant
 */

function __get_template__($cornersave)
{
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $cornersave->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        while ($row = $sql_query_result->fetch_array()) {
            $module[] = $row["module_id"];
        }
    }
}

function get_modules($cornersave)
{
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $cornersave->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        while ($row = $sql_query_result->fetch_array()) {
//            $module[] = $row["module_id"];
            $module[$row["name_lang_key"]] = $row["module_id"];
        }
    }

    return $module;
}

function __insert_template__($cornersave)
{
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $cornersave->query($sql_query);
    if ($sql_query_result != null && $sql_query_result->is_row_affected()) {

    }
}

function __update_template__($cornersave)
{
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $cornersave->query($sql_query);
    if ($sql_query_result != null && $sql_query_result->is_row_affected()) {

    }
}

/*$ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);*/

function getModulesFromPermissions($permission_array)
{

}

function encryptPassword($password)
{//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}

function generateUserReferenceId()
{
    return getRandomNumber(10);
}

function generate_token()
{
    return getRandomNumber(4) . "" . getRandomNumber(4);
}

function generate_unique_id($prefix)
{
    return $prefix . "-" . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}

//return a formatted currency string based on the locale
function displayCurrency($number, $decimals = NULL, $locale = DEFAULT_LOCALE)
{
    $thousands_separator = true;

    //ignore empty strings and return
    if (empty($number)) {
        return $number;
    }

    if ($decimals == NULL) {
        $decimals = 0;
    }


    $fmt = new NumberFormatter($locale, NumberFormatter::DECIMAL);

    $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, intval($decimals));

    if (!$thousands_separator) {
        //remove thousand separator
        //$fmt->setAttribute(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, '');
    }

    try {
        //return $fmt->parse($number);
        return $fmt->format($number);

    } catch (Exception $e) {
        return FALSE;
    }
}


function debugAPIResponse($api, $msg)
{

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);

    return true;
}


function debugPaywallLog($msg)
{

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "__paywall_log.csv";

    if (!file_exists($fname)) {
        $handle = fopen($fname, "w");

        $heading = "User ID, Session Token, First Name, Last Name, Activity, Date, Country\n";

        fwrite($handle, $heading);
        fclose($handle);
    }

    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);

    return true;
}