<?php


class GiftCard
{

    var $conn;

    /**
     * GiftCard constructor.
     * @param $conn
     */
    public function __construct($conn)
    {
        $this->conn = $conn;
    }


    public function listCards($customer_id, $manager_id)
    {
        $query = "select gc.giftcard_id                           as gift_card_id,
       concat(op.first_name, ' ', op.last_name) as customer_name,
       c.id                                     as customer_id,
       IF(gc.public = 1, true, false)           as is_public,
       gc.batch_code,
       gc.giftcard_number                       as card_code,
       gc.value                                 as card_value
from " . TABLE_GIFT_CARDS . " gc
         inner join " . TABLE_CUSTOMER . " c on c.person_id = gc.person_id
         inner join " . TABLE_PEOPLE . " op on gc.person_id = op.person_id
         where gc.deleted = 0 and gc.manager_id = $manager_id
";
        if (!is_null($customer_id) && $customer_id != '') $query .= " where c.id = $customer_id";

        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            if (!is_null($select_query)) {

                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['is_public'] = $row['is_public'] == 1;
                    $row['gift_card_id'] = intval($row['gift_card_id']);
                    $row['customer_id'] = intval($row['customer_id']);
                    $row['card_value'] = intval($row['card_value']);
                    $row['batch_code'] = intval($row['batch_code']);
                    $row['card_code'] = intval($row['card_code']);
                    array_push($res, $row);
                }
                return $res;
            }
        }

        return null;
    }

    public function getGiftCard($gift_card_id)
    {

        $query = "select gc.giftcard_id                           as gift_card_id,
       concat(op.first_name, ' ', op.last_name) as customer_name,
       c.id                                     as customer_id,
       gc.public                                as is_public,
       gc.batch_code,
       gc.giftcard_number                       as card_code,
       gc.value                                 as card_value
from " . TABLE_GIFT_CARDS . " gc
         inner join " . TABLE_CUSTOMER . " c on c.person_id = gc.person_id
         inner join " . TABLE_PEOPLE . " op on gc.person_id = op.person_id
";
        if (!is_null($gift_card_id) && $gift_card_id != '') $query .= " where gc.giftcard_id = $gift_card_id";

        if (!is_null($this->conn)) {
            $res = $this->conn->fetch_assoc($query);
            $res['is_public'] = intval($res['is_public']) == 1;
            $res['customer_id'] = intval($res['customer_id']);
            $res['batch_code'] = intval($res['batch_code']);
            $res['gift_card_id'] = intval($res['gift_card_id']);
            $res['card_code'] = intval($res['card_code']);
            $res['card_value'] = intval($res['card_value']);
            return $res;
        }

        return null;
    }

    public function delete($gift_card_id): bool
    {
        $query = "update " . TABLE_GIFT_CARDS . " set deleted = 1 where giftcard_id = " . $gift_card_id;
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function update($set, $where): bool
    {
        $query = get_update_query(TABLE_GIFT_CARDS, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function addGiftCards($values): bool
    {
        $query = get_insert_query(TABLE_GIFT_CARDS, $values);
        return !is_null($this->conn) && $this->conn->insert($query);
    }

}