<?php


class ItemKit
{

    var $conn;

    /**
     * ItemKit constructor.
     * @param $db_connector
     */
    public function __construct($db_connector)
    {
        $this->conn = $db_connector;
    }

    public function getItemByKitId($promotion_id): ?array
    {
        $query = "select k.item_id       as product_id,
       oi.name         as product_name,
       oi.category     as category_name,
       oi.cost_price,
       oi.unit_price,
       oi.brand,
       oi.unit_value,
       oi.unit_label,
       k.quantity,
       oi.pic_url      as image_url,
       oi.pic_filename as image_name,
       oi.catalog_id
from ospos_item_kit_items k
         inner join ospos_items oi on k.item_id = oi.item_id
where k.item_kit_id = " . $promotion_id;

        if (!is_null($this->conn)) {
            $select_request = $this->conn->query($query);
            $res = array();
            while ($row = $select_request->fetch_assoc()) {
                $row['product_id'] = intval($row['product_id']);
                $row['quantity'] = intval($row['quantity']);
                $row['unit_value'] = floatval($row['unit_value']);
                $row['cost_price'] = floatval($row['cost_price']);
                $row['unit_price'] = floatval($row['unit_price']);
                $row['image_url'] = IMG_ITEM_ROOT . $row['image_name'];

                array_push($res, $row);
            }
            return $res;
        }

        return null;
    }


    public function getItemIdsByKitId($promotion_id)
    {
        $query = "select k.item_id as product_id from ospos_item_kit_items k where k.item_kit_id = " . $promotion_id;

        if (!is_null($this->conn)) {
            $select_request = $this->conn->query($query);
            $res = array();
            while ($row = $select_request->fetch_assoc()) {
//                $row['product_id'] = intval($row['product_id']);
                array_push($res, intval($row['product_id']));
            }
            return $res;
        }

        return null;
    }


    public function addKit(array $values): bool
    {
        $query = get_insert_query(TABLE_KITS_ITEMS, $values);

        return !is_null($this->conn) && $this->conn->insert($query);
    }

    public function update_item(object $set, object $where): bool
    {
        $query = get_update_query(TABLE_KITS_ITEMS, $set, $where);
        if (!is_null($this->conn)) {
            $update_query = $this->conn->query($query);
            return !is_null($update_query);
        }

        return false;
    }

    public function deleteByIds($items_to_be_deleted, $promotion_id): bool
    {
        $imploded = implode(",", $items_to_be_deleted);
        $query = "delete from " . TABLE_KITS_ITEMS . " where item_kit_id = " . $promotion_id . " and item_id in ($imploded)";
        return !is_null($this->conn) && $this->conn->update($query);
    }
}