<?php


class Order
{

    var $conn;
    var $order_id;

    public function __construct($db_connector, $order_id = '')
    {
        $this->conn = $db_connector;
        $this->order_id = $order_id;
    }

    public function getSalesById(): ?array
    {
        $res = array();
        if ($this->conn != null) {
            $Query = "SELECT S.sale_id as order_id, S.sale_time as order_time, S.customer_id, S.employee_id as team_member_id, S.comment, S.invoice_number, S.quote_number, S.sale_type, IF(S.is_online=0, 'in_store','online') as order_type, S.sale_status as order_status, S.approved, P.payment_type as payment_method, P.payment_amount as sale_total, S.pickup as pickup_time, CONCAT(C.first_name, ' ', C.last_name) as customer_name FROM " . TABLE_SALES . " S inner join " . TABLE_SALES_PAYMENTS . " P on S.sale_id = P.sale_id left outer join " . TABLE_PEOPLE . " C on S.customer_id = C.person_id WHERE S.sale_id = '$this->order_id'";

            $select_query = $this->conn->query($Query);

            if ($select_query != null && $select_query->is_row_affected()) {
                $rs = $select_query->fetch_object();
                $res['order_id'] = intval($rs->order_id);
                $res['order_time'] = $rs->order_time;
                $res['customer_id'] = $rs->customer_id == null || $rs->customer_id == 0 ? null : intval($rs->customer_id);
                $res['customer_name'] = $rs->customer_name;
                $res['team_member_id'] = intval($rs->team_member_id);
                $res['comment'] = $rs->comment;
                $res['invoice_number'] = intval($rs->invoice_number);
                $res['quote_number'] = intval($rs->quote_number);
                $res['order_type'] = $rs->order_type;
                $res['order_status'] = $this->getOrderStatus($rs->order_status);
                $res['approved'] = boolval($rs->approved);
                $res['payment_method'] = $rs->payment_method;
                $res['sale_type'] = getSaleTypeByInt($rs->sale_type);
                $res['sale_total'] = intval($rs->sale_total);
                $res['pickup_time'] = $rs->pickup_time;

                return $res;
            }

        }

        return null;

    }

    public function getOrderList($manager_id): ?array
    {
        $response = array();
        if ($this->conn != null) {
            $Query = "SELECT S.sale_id as order_id, S.sale_time as order_time, S.customer_id, S.employee_id as team_member_id,
       S.comment, S.invoice_number, S.quote_number, S.sale_type, IF(S.is_online=0, 'in_store','online') as order_type,
       S.sale_status as order_status, S.approved, P.payment_type as payment_method, P.payment_amount as sale_total,
       S.pickup as pickup_time, CONCAT(C.first_name, ' ', C.last_name) as customer_name
FROM
     " . TABLE_SALES . " S left outer join " . TABLE_SALES_PAYMENTS . " P on S.sale_id = P.sale_id
      left outer join " . TABLE_PEOPLE . " C on S.customer_id = C.person_id
       where S.manager_id = " . $manager_id;

            $select_query = $this->conn->query($Query);

            if ($select_query != null && $select_query->is_row_affected()) {
                while ($rs = $select_query->fetch_array()) {
                    $res = array();
                    $res['order_id'] = intval($rs['order_id']);
                    $res['order_time'] = $rs['order_time'];
                    $res['customer_id'] = $rs['customer_id'] == null || $rs['customer_id'] == 0 ? null : intval($rs['customer_id']);
                    $res['customer_name'] = $rs['customer_name'];
                    $res['team_member_id'] = intval($rs['team_member_id']);
                    $res['comment'] = $rs['comment'];
                    $res['invoice_number'] = intval($rs['invoice_number']);
                    $res['quote_number'] = intval($rs['quote_number']);
                    $res['order_type'] = $rs['order_type'];
                    $res['order_status'] = $this->getOrderStatus($rs['order_status']);
                    $res['approved'] = boolval($rs['approved']);
                    $res['payment_method'] = $rs['payment_method'];
                    $res['sale_type'] = getSaleTypeByInt($rs['sale_type']);
                    $res['sale_total'] = intval($rs['sale_total']);
                    $res['pickup_time'] = $rs['pickup_time'];
                    array_push($response, $res);
                }
                return $response;
            }

        }
        return null;
    }

    public function getSaleItemsByOrderId(): ?array
    {

        if ($this->conn != null) {
            $Query = "SELECT SI.sale_id,
       SI.item_id         as product_id,
       I.name             as product_name,
       I.category         as category_name,
       SI.item_unit_price as unit_price,
       SI.quantity_purchased,
       I.pic_url          as image_url,
       I.pic_filename     as image_name,
       SI.discount_type,
       SI.discount,
       I.description
FROM " . TABLE_SALES_ITEMS . " SI
         inner join " . TABLE_ITEMS . " I on SI.item_id = I.item_id WHERE sale_id = '$this->order_id'";

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['sale_id'] = intval($row['sale_id']);
                    $row['product_id'] = intval($row['product_id']);
                    $row['unit_price'] = floatval($row['unit_price']);
                    $row['quantity_purchased'] = intval($row['quantity_purchased']);
                    $row['image_url'] = IMG_ITEM_ROOT . $row['image_name'];
                    $row['discount'] = floatval($row['discount']);
                    array_push($result, $row);
                }
                return $result;
            }

        }

        return null;
    }

    public static function getOrderStatus($db_status): string
    {

        if ($db_status == ORDER_COMPLETED) return ORDER_STATUS_COMPLETED;
        elseif ($db_status == ORDER_PENDING) return ORDER_STATUS_PENDING;
        elseif ($db_status == ORDER_CANCELED) return ORDER_STATUS_CANCELLED;
        elseif ($db_status == ORDER_PAID) return ORDER_STATUS_PAID;
        elseif ($db_status == ORDER_CONFIRMED) return ORDER_STATUS_CONFIRMED;
        return "";

    }

    public function confirm_order($set, $where): bool
    {
        $query = get_update_query(TABLE_SALES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function mark_order_delivered($set, $where): bool
    {
        $query = get_update_query(TABLE_SALES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);

    }

    public function updateOrder($set, $where): bool
    {
        $query = get_update_query(TABLE_SALES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }
}