<?php


class Reporting
{

    public function getReceivingListQuery($manager): string
    {
        return "select R.receiving_time                       as    receiving_date,
       R.receiving_id,
       R.employee_id                          as    received_by_id,
       concat(P.first_name, ' ', P.last_name) as    received_by_name,
       R.supplier_id                          as    supplied_by_id,
       S.company_name                         as    supplied_by_name,
       R.payment_type,
       R.comment                              as    comments,
       IF(RI.receiving_id IS NULL, '[]', CONCAT('[',
                                              GROUP_CONCAT(JSON_OBJECT('barcode', OI.item_number,
                                                                       'product_name', OI.name,
                                                                       'category_name', OI.category,
                                                                       'quantity', RI.quantity_purchased,
                                                                       'discount', RI.discount)),
                                              ']')) product_list
from ospos_receivings as R
         left outer join ospos_people as P on P.person_id = R.employee_id
         left outer join ospos_suppliers as S on S.person_id = R.supplier_id
         left outer join ospos_receivings_items RI on RI.receiving_id = R.receiving_id
         left outer join ospos_items OI on RI.item_id = OI.item_id
where R.manager_id = $manager
GROUP BY R.receiving_id";
    }

    public function getItemList($manager)
    {
        return "select IFNULL(CONCAT('[', GROUP_CONCAT(JSON_OBJECT(
        'product_id', item_id,
        'product_name', name,
        'product_category', category,
        'barcode', item_number,
        cost_price,
        unit_price,
        unit_label,
        unit_value
    )), ']'), '[]') as products
from ospos_items
where manager_id = " . $manager;
    }

    public function getCustomerListQuery($manager)
    {
        return "select ifnull(CONCAT('[', GROUP_CONCAT(
        JSON_OBJECT(
                'customer_name', customers.customer_name,
                'customer_id', customer_id)
    ), ']'), '[]') customers
from (
         SELECT concat(first_name, ' ', last_name) as customer_name, C.person_id as customer_id
         from ospos_customers C
                  inner join ospos_people P on C.person_id = P.person_id
         where C.deleted = 0
           and C.manager_id = $manager
     ) customers";
    }

    public function getEmployeeListQuery($manager)
    {
        return "select ifnull(concat('[', group_concat(
        json_object(
                'employee_id',employee_id, 'employee_name',employee_name, 'username',username, 'user_type',user_type
            )
    ), ']'), '[]') employee_list
from (select username, E.person_id as employee_id, E.user_type, concat(first_name, ' ', last_name) as employee_name
      from ospos_employees E
               inner join ospos_people P on E.person_id = P.person_id
      where E.deleted = 0
        and manager_id = $manager) employees";
    }

    public function getTrnChartQuery($manager, $startDate = null, $endDate = null)
    {
        if ($startDate != null && $endDate != null) $date = " and cast(payment_time as date) between '2021-01-01' and '2021-12-31' ";
        else $date = "";
        return "select ifnull(
        concat(
            '[',
            group_concat(
                json_object(
                    'revenue', revenue,
                    'transaction_date', transaction_date
                )
            ),
            ']'),
        '[]') chart_data
from(
    select ROUND(SUM(payment_amount), 2) as revenue, CAST(payment_time as DATE) as transaction_date
         from ospos_sales S
                  inner join ospos_sales_payments P on S . sale_id = P . sale_id
         WHERE S . sale_status = 0 " . $date . "
         group by DAY(P . payment_time)
     ) chart_data";
    }

    public function getTrnList($manager)
    {
        return "select ifnull(concat('[', group_concat(
        json_object(
            'transaction_id', transaction_id,
            'transaction_date', transaction_date,
            'sold_by_id', sold_by_id,
            'sold_by_name', sold_by_name,
            'customer_id', customer_id,
            'customer_name', customer_name,
            'payment_type', payment_type,
            'product_list', product_list
        )
    ), ']'), '[]') as transaction_data
from(
    SELECT S . sale_id                                as transaction_id,
                sale_time                                as transaction_date,
                S . employee_id                            as sold_by_id,
                concat(P . first_name, ' ', P . last_name)   as sold_by_name,
                S . customer_id                            as customer_id,
                concat(CP . first_name, ' ', CP . last_name) as customer_name,
                SP . payment_type,
                S . comment                                as comments,
                if (SI . sale_id is null, '[]', IFNULL(
        concat(
            '[',
            group_concat(
                json_object(
                    'barcode', I . item_number,
                    'product_name', I . name,
                    'category_name', I . category,
                    'quantity', SI . quantity_purchased,
                    'discount', SI . discount
                )
            )
            ,
            ']'),
        '[]'))                              product_list

         FROM ospos_sales S
                  LEFT outer JOIN ospos_sales_payments SP on S . sale_id = SP . sale_id
                  left outer join ospos_sales_items SI on S . sale_id = SI . sale_id
                  left outer join ospos_people P on S . employee_id = P . person_id
                  left outer join ospos_people CP on S . customer_id = CP . person_id
                  left outer join ospos_items I on SI . item_id = I . item_id
         group by S . sale_id
     ) as transaction_data";
    }

    public function getTrnList__($manager)
    {
        return "SELECT S . sale_id                                as transaction_id,
       sale_time                                as transaction_date,
       S . employee_id                            as sold_by_id,
       concat(P . first_name, ' ', P . last_name)   as sold_by_name,
       S . customer_id                            as customer_id,
       concat(CP . first_name, ' ', CP . last_name) as customer_name,
       SP . payment_type,
       S . comment                                as comments,
       if (SI . sale_id is null, '[]', IFNULL(
        concat(
            '[',
            group_concat(
                json_object(
                    'barcode', I . item_number,
                    'product_name', I . name,
                    'category_name', I . category,
                    'quantity', SI . quantity_purchased,
                    'discount', SI . discount
                )
            )
            ,
            ']'),
        '[]'))                              product_list

FROM ospos_sales S
         LEFT outer JOIN ospos_sales_payments SP on S . sale_id = SP . sale_id
         left outer join ospos_sales_items SI on S . sale_id = SI . sale_id
         left outer join ospos_people P on S . employee_id = P . person_id
         left outer join ospos_people CP on S . customer_id = CP . person_id
         left outer join ospos_items I on SI . item_id = I . item_id
group by S . sale_id";
    }
}