<?php

class GiftCardService
{
    var $db_connector;

    /**
     * GiftCardService constructor.
     * @param $db_connector
     */
    public function __construct($db_connector)
    {
        $this->db_connector = $db_connector;
    }


    public function getGiftCardData($gift_card_id)
    {

        $data = (new GiftCard($this->db_connector))->getGiftCard($gift_card_id);

        if (is_null($data)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['gift_card_data'] = $data;
        return $res;
    }

    public function getGiftCardList($customer_id, $manager_id)
    {

        $list = (new GiftCard($this->db_connector))->listCards($customer_id, $manager_id);

        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);

        $result = getOKStatus();
        $result['card_list'] = $list;
        return $result;
    }

    public function deleteGift($gift_card_id)
    {
        if ((new GiftCard($this->db_connector))->delete($gift_card_id)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function updateGiftCard($data)
    {
        $set = new stdClass();
        $set->public = text_clean($data['is_public']) == true ? 1 : 0;
        $set->value = text_clean($data['card_value']);

        $where = new stdClass();
        $where->giftcard_id = text_clean($data['gift_card_id']);
        $where->manager_id = text_clean($data['manager_id']);
        if ((new GiftCard($this->db_connector))->update($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function addGiftCards($data)
    {

        $values = array();

        $gift_cards_count = text_clean($data['gift_card_count']);
        for ($i = 0; $i < $gift_cards_count; $i++) {
            $value = new stdClass();
            $value->value = text_clean($data['card_value']);
            $value->public = text_clean($data['is_public']) == true ? 1 : 0;
            $value->person_id = text_clean($data['customer_id']);
            $value->manager_id = text_clean($data['manager_id']);
            array_push($values, $value);
        }

        $added = (new GiftCard($this->db_connector))->addGiftCards($values);

        if ($added) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }
}