<?php


class MsgNotificationService
{

    var $db_connector;
    var $manager_id;

    /**
     * MsgNotification constructor.
     * @param $cornersave
     * @param $getManagerId
     */
    public function __construct($cornersave, $getManagerId)
    {
        $this->db_connector = $cornersave;
        $this->manager_id = $getManagerId;
    }

    public function sendMsg($message_data)
    {
        if ($message_data['recipient_id'] == null) $sent = $this->sendMarketingMsg($message_data);
        else $sent = $this->sendMsgConversation($message_data);

        if ($sent) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function getMarketingList()
    {
        $list = (new MsgNotification($this->db_connector))->getMarketingMsgList($this->manager_id);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['message_list'] = $list;
        return $result;
    }

    public function getMarketingMsgThread($recipient_type)
    {
        $list = (new MsgNotification($this->db_connector))->getMarketingMsgThread($this->manager_id, $recipient_type);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['message_thread'] = $list;
        return $result;
    }

    public function updateThread()
    {

    }

    public function getCustomerMsgThread($customer_id)
    {
        $list = (new MsgNotification($this->db_connector))->getCustomerMsgThread($this->manager_id, $customer_id);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['message_thread'] = $list;
        return $result;
    }

    public function getMsgListConversation()
    {
        $list = (new MsgNotification($this->db_connector))->getMsgListConversation($this->manager_id);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['message_list'] = $list;
        return $result;
    }

    public function markAsRead(mixed $data)
    {
        $updated = true;
        foreach ($data as $ids) {

            $set = new stdClass();
            $set->read = 1;

            $where = new stdClass();
            $where->message_id = text_clean($ids);

            $updated = (new MsgNotification($this->db_connector))->updateMsg($set, $where);

        }

        if ($updated) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function sendMarketingMsg($message_data)
    {
        $insert = new stdClass();
        $insert->customer_id = $message_data['recipient_id'];
        $insert->msg_body = $message_data['msg_body'];
        $insert->recipient_type = $message_data['recipient_type'];

        return (new MsgNotification($this->db_connector))->insertMsg($insert);
    }

    private function sendMsgConversation($message_data)
    {
        $insert = new stdClass();
        $insert->msg_body = $message_data['msg_body'];
        $insert->recipient_type = $message_data['recipient_type'];
        return (new MsgNotification($this->db_connector))->insertMsg($insert);
    }
}