<?php

/**
 * @param $param - this is an array of template variables : {{}}
 * @return string|string[]
 */
function __template__($param){

    $subject = 'Welcome!';

    $body = '';

    foreach ($param as $key => $value) {
        $body = str_replace($key, $value, $body);
    }

    return array(
        "subject" => $subject,
        "body" => $body
    );

}


/**
 * @param $param - {{invite_code}}, {{invite_link}}, {{organization}}
 * @return string|string[]
 */
function registered_agent_invite($param){

    $subject = 'Queritel Invitation';
    $body = 'Registered Agent Invitation - {{invite_code}}; <br> Invite - {{invite_link}}; <br> Organization - {{organization}}; <br> Message : {{customized_message}} ';

    foreach ($param as $key => $value) {
        $body = str_replace($key, $value, $body);
    }

    return array(
        "subject" => $subject,
        "body" => $body
    );

}


/**
 * @param $param - {{invite_code}}, {{organization}}, {{customized_message}}
 * @return array
 */
function unregistered_agent_invite($param){

    $subject = 'Queritel Invitation';
    $body = 'Agent Invitation - {{invite_code}}; <br> Organization - {{organization}}; <br> Use the provided code during your registration; <br> Message : {{customized_message}}';

    foreach ($param as $key => $value) {
        $body = str_replace($key, $value, $body);
    }

    return array(
        "subject" => $subject,
        "body" => $body
    );

}

/**
 * @param $param - {{invite_link}}, {{organization}}, {{customized_message}}
 * @return array
 */
function manager_invite($param){

    $subject = 'Queritel Invitation';
    $body = 'Manager Invitation - {{invite_link}}; <br> Organization - {{organization}}; <br> Message : {{customized_message}};';

    foreach ($param as $key => $value) {
        $body = str_replace($key, $value, $body);
    }

    return array(
        "subject" => $subject,
        "body" => $body
    );

}




/**
 * @param $param - {{verify_link}}
 * @return array
 */
function verify_email($param){

    $subject = 'Confirm Account';
    $body = 'Confirm account by visiting - {{verify_link}}';

    foreach ($param as $key => $value) {
        $body = str_replace($key, $value, $body);
    }

    return array(
        "subject" => $subject,
        "body" => $body
    );

}