<?php
//enable resourse sharing(allows this resource to be shared with "all[*]" requesting scripts
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');


//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");

//task status
define("TASK_STATUS_PENDING", 0);
define("TASK_STATUS_ACTIVE", 1);
define("TASK_STATUS_AWARDED", 2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT", 5);

//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
//-------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");

//task activity category
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");


//paperweight database
define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("PASSWORD_SALT", "ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK", "OK");
define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED", "LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");

//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED", 2);
define("SURVEY_STATE_CANCELLED", 3);

//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);

//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CUSTOMER", 0);

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_NORMAL", 0);
define("NETWORK_POSITION_OFFICIAL", 1);
define("NETWORK_POSITION_DEFAULT", 2);

//gender
define("GENDER_MALE", 1);
define("GENDER_FEMALE", 0);
//--------------------------------


include("../../includes/headers/classes-v1.php"); //has all the classes needed for queritel back-end
include("../../includes/headers/miscellaneous-v1.php"); //additional functions
include("../../includes/headers/strings.php"); //has all the constants needed


$paperweight = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);

/**
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 */




//TODO Replace sendMail with stmp version

define("USER_TOKEN","mku-djgggdlndg3fso-75664-djjxg");

if (isset($_REQUEST["action"]))
{

    $action = $_POST["action"];
    $param_json = $_POST["param_json"];

    if ($action == 'get_demo_locations')
    {
        $data = json_decode($param_json, true);

        $user_token = $data["user_token"];

        $result = array();
        $result["status"] = "OK";
        $location_data = array();
        $record_found = false;

        if ($user_token != USER_TOKEN){
            $error = array();
            $error["name"] = "opFailed";
            $error["message"] = "INV_CR";
            $result["status"] = "ERROR";
            $result["error"] = $error;

            echo json_export($result);
            return;

        }


        $location_sample = '{
          "status": "OK",
          "location_list": [
            {
              "address_id": "67581515",
              "address": "11 Hope Rd, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.011257",
              "lng": "-76.795425",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 1,
              "user_list": [
                {
                  "fname": "Damion",
                  "lname": "Tomlinson",
                  "user_id": "985",
                  "user_ref_id": "75766812",
                  "submissions_total": 1,
                  "submissions_completed": 0
                }
              ]
            },
            {
              "address_id": "74716544",
              "address": "6 Old Hope Road, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.020632",
              "lng": "-76.767189",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "46885376",
              "address": "134 Old Hope Rd Kingston 6 Jamaica, Old Hope Road, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.018799",
              "lng": "-76.767105",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "53504615",
              "address": "29 Upper Waterloo Road, MegaMart, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.024048",
              "lng": "-76.792137",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "96502137",
              "address": "7 Braeton Pkwy, Portmore, Jamaica",
              "address_region": "St. Catherine Parish",
              "lat": "17.961521",
              "lng": "-76.897514",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "54469278",
              "address": "Lot 101 A-B Mega Mart Complex Catherine Hall Montego Bay Jamaica, W Green Ave, Montego Bay, Jamaica",
              "address_region": "St. James Parish",
              "lat": "18.459906",
              "lng": "-77.924850",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 1,
              "users_required": 1,
              "users_available": 1,
              "user_list": [
                {
                  "fname": "Rochelle",
                  "lname": "Ward",
                  "user_id": "902",
                  "user_ref_id": "89017897",
                  "submissions_total": 1,
                  "submissions_completed": 1
                }
              ]
            },
            {
              "address_id": "29666527",
              "address": "2 Alice Eldemire Dr, Montego Bay, Jamaica",
              "address_region": "St. James Parish",
              "lat": "18.454336",
              "lng": "-77.925011",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 1,
              "users_required": 1,
              "users_available": 1,
              "user_list": [
                {
                  "fname": "Rochelle",
                  "lname": "Ward",
                  "user_id": "902",
                  "user_ref_id": "89017897",
                  "submissions_total": 1,
                  "submissions_completed": 1
                }
              ]
            },
            {
              "address_id": "77179442",
              "address": "Unit 5 & 6 Eight Rivers Town Centre, Buckfield, Ocho Rios, Jamaica",
              "address_region": "",
              "lat": "18.406324",
              "lng": "-77.103828",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 1,
              "user_list": [
                {
                  "fname": "Roshane",
                  "lname": "Anderson",
                  "user_id": "928",
                  "user_ref_id": "15958703",
                  "submissions_total": 1,
                  "submissions_completed": 0
                }
              ]
            },
            {
              "address_id": "28117179",
              "address": "14 South Race Course Road, Mandeville, Jamaica",
              "address_region": "Manchester Parish",
              "lat": "18.040396",
              "lng": "-77.508156",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "31299989",
              "address": "Manchester Shopping Centre, Mandeville, Jamaica",
              "address_region": "Manchester Parish",
              "lat": "18.046354",
              "lng": "-77.507439",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "77767457",
              "address": "Portmore Pines Plaza, Portmore, Jamaica",
              "address_region": "St. Catherine Parish",
              "lat": "17.963205",
              "lng": "-76.895393",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "869498",
              "address": "68 New Land Road, Bridgeport PO, Portmore, Jamaica",
              "address_region": "St. Catherine Parish",
              "lat": "17.974005",
              "lng": "-76.887932",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "23487861",
              "address": "1-5 Tobago Ave, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.008371",
              "lng": "-76.784973",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 1,
              "users_required": 1,
              "users_available": 1,
              "user_list": [
                {
                  "fname": "Daryll",
                  "lname": "Purrier",
                  "user_id": "945",
                  "user_ref_id": "42479774",
                  "submissions_total": 1,
                  "submissions_completed": 1
                }
              ]
            },
            {
              "address_id": "12958768",
              "address": "29 E Kings House Rd, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.030045",
              "lng": "-76.777420",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            },
            {
              "address_id": "49501705",
              "address": "18 Duhaney Dr, Kingston, Jamaica",
              "address_region": "St. Andrew Parish",
              "lat": "18.026438",
              "lng": "-76.847763",
              "country": "Jamaica",
              "country_iso": "JM",
              "submissions_total": 1,
              "submissions_completed": 0,
              "users_required": 1,
              "users_available": 0,
              "user_list": []
            }
          ]
        }';

        $code_obj = json_decode($location_sample,true);
        $result["location_list"] = $code_obj["location_list"];

        echo json_export($result);
    }


    if ($action == "get_user_list"){
        $data = json_decode($param_json, true);

        $user_token = $data["user_token"];

        $result = array();
        $result["status"] = "OK";
        $location_data = array();
        $record_found = false;

        if ($user_token != USER_TOKEN){
            $error = array();
            $error["name"] = "opFailed";
            $error["message"] = "INV_CR";
            $result["status"] = "ERROR";
            $result["error"] = $error;

            echo json_export($result);
            return;

        }


        $user_sample = '{
          "status": "OK",
          "user_list": [
            {
              "fname": "Damion",
              "lname": "Tomlinson",
              "user_id": "985",
              "user_ref_id": "75766812",
              "submissions_total": 1,
              "submissions_completed": 0,
              "location_list": [
                {
                  "address_id": "67581515",
                  "address": "11 Hope Rd, Kingston, Jamaica",
                  "address_region": "St. Andrew Parish",
                  "lat": "18.011257",
                  "lng": "-76.795425",
                  "country": "Jamaica",
                  "country_iso": "JM",
                  "submissions_total": 1,
                  "submissions_completed": 0,
                  "submissions_list": []
                }
              ]
            },
            {
              "fname": "Rochelle",
              "lname": "Ward",
              "user_id": "902",
              "user_ref_id": "89017897",
              "submissions_total": 2,
              "submissions_completed": 2,
              "location_list": [
                {
                  "address_id": "54469278",
                  "address": "Lot 101 A-B Mega Mart Complex Catherine Hall Montego Bay Jamaica, W Green Ave, Montego Bay, Jamaica",
                  "address_region": "St. James Parish",
                  "lat": "18.459906",
                  "lng": "-77.924850",
                  "country": "Jamaica",
                  "country_iso": "JM",
                  "submissions_total": 1,
                  "submissions_completed": 1,
                  "submissions_list": [
                    {
                      "submission_id": "8552603554",
                      "file_name": "Classic Big Buck Bunny",
                      "file_type": "type_video",
                      "file_url": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/BigBuckBunny.mp4"
                    }
                  ]
                },
                {
                  "address_id": "29666527",
                  "address": "2 Alice Eldemire Dr, Montego Bay, Jamaica",
                  "address_region": "St. James Parish",
                  "lat": "18.454336",
                  "lng": "-77.925011",
                  "country": "Jamaica",
                  "country_iso": "JM",
                  "submissions_total": 1,
                  "submissions_completed": 1,
                  "submissions_list": [
                    {
                      "submission_id": "3371165583",
                      "file_name": "A Beautiful View",
                      "file_type": "type_image",
                      "file_url": "https://www.gstatic.com/webp/gallery/1.jpg"
                    }
                  ]
                }
              ]
            },
            {
              "fname": "Roshane",
              "lname": "Anderson",
              "user_id": "928",
              "user_ref_id": "15958703",
              "submissions_total": 1,
              "submissions_completed": 0,
              "location_list": [
                {
                  "address_id": "77179442",
                  "address": "Unit 5 & 6 Eight Rivers Town Centre, Buckfield, Ocho Rios, Jamaica",
                  "address_region": "",
                  "lat": "18.406324",
                  "lng": "-77.103828",
                  "country": "Jamaica",
                  "country_iso": "JM",
                  "submissions_total": 1,
                  "submissions_completed": 0,
                  "submissions_list": []
                }
              ]
            },
            {
              "fname": "Daryll",
              "lname": "Purrier",
              "user_id": "945",
              "user_ref_id": "42479774",
              "submissions_total": 1,
              "submissions_completed": 1,
              "location_list": [
                {
                  "address_id": "23487861",
                  "address": "1-5 Tobago Ave, Kingston, Jamaica",
                  "address_region": "St. Andrew Parish",
                  "lat": "18.008371",
                  "lng": "-76.784973",
                  "country": "Jamaica",
                  "country_iso": "JM",
                  "submissions_total": 1,
                  "submissions_completed": 1,
                  "submissions_list": [
                    {
                      "submission_id": "7618506991",
                      "file_name": "The first Blender Open Movie from 2006",
                      "file_type": "type_video",
                      "file_url": "http://commondatastorage.googleapis.com/gtv-videos-bucket/sample/ElephantsDream.mp4"
                    }
                  ]
                }
              ]
            }
          ]
        }';

        $code_obj = json_decode($user_sample,true);
        $result["user_list"] = $code_obj["user_list"];

        echo json_export($result);
        //echo json_export($result);
        //echo generate_msg_id();
    }


    if ($action == "demo"){
        $data = json_decode($param_json, true);

        $id =      text_clean($data["user_token"]);


        $result = array();
        $result["status"] = "OK";


        $result["return_code"] = generate_id();


        //errol

        echo json_export($result);
        //echo json_export($result);
        //echo generate_msg_id();
    }

}

function generate_id() {
    return "" . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}



//completely remove a task (all reference to the task id) from the database
function eraseTask($task_id,$paperweight){

    $removed = false;

    $task_query = "delete from " . TABLE_TASKS . " where task_id = '$task_id'";
    $job_query = "delete from " . TABLE_JOBS . " where task_id = '$task_id'";
    $response_query = "delete from " . TABLE_RESPONSE . " where task_id = '$task_id'";
    $tag_query = "delete from " . TABLE_JOB_TAGS . " where task_id = '$task_id'";

    $task_result = $paperweight->query($task_query);
    $job_result = $paperweight->query($job_query);
    $response_result = $paperweight->query($response_query);
    $tag_result = $paperweight->query($tag_query);

    if($task_result != null && $task_result->is_row_affected()){
        $removed = true;
    }

    return $removed;
}

//has the task activity changed.. if so erase the project to recreate it
function hasActivityChanged($task_activity,$task_id,$paperweight){
    $changed = false;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null){
        if ($row = $task_result->fetch_array()){
            $activity = $row["task_activity"];

            if ($activity != $task_activity){
                $changed = true;
            }

        }

    }

    return $changed;
}


function getTagEffort($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result = array();

    $result["status"] = "NO_DATA";


    $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_effort'";
    $tag_result = $paperweight->query($tag_query);

    if ($tag_result != null){
        if ($row = $tag_result->fetch_array()){
            $tag_data = $row["tag_data"];
            $decoded = json_decode($tag_data,true);

            $result["status"] = "OK";
            $result["level"] = $decoded["level"];

        }

    }

    return $result;
}
function getPayPerResponse($task_id,$paperweight){

    $result = array();
    $result["status"] = "NO_DATA";

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null){
        while ($row = $location_result->fetch_array()){
            $cpq = $row["cpq"];
            if ($cpq != null){
                $result["status"] = "OK";
                $result["cpq"] = $cpq;
                break;
            }
        }
    }

    return $result;

}

/*
 * get job tags for editing the data
 */
function getJobTags($job_id,$paperweight){
    $record_found = false;
    $index = 0;

    $data = array();
    $result = array();

    $tag_query = "select * from " . TABLE_JOB_TAGS . " where job_id = '$job_id'";
    $tag_result = $paperweight->query($tag_query);

    if ($tag_result != null && $tag_result->is_row_found()){
        while ($row = $tag_result->fetch_array()){
            $record_found = true;

            $tag_id = $row["tag_id"];
            $tag_label = $row["tag_label"];
            $tag_data = $row["tag_data"];

            $decoded = json_decode($tag_data,true);

            $data[$index]["unique_id"] = $tag_id;
            $data[$index]["tag_label"] = $tag_label;
            $data[$index]["tag_data"] = $decoded;

            $index++;
        }

    }

    if ($record_found){
        $result = $data;
    }

    return $result;
}

/*
 * Get location detail for editing purposes
 */
function getLocationDetail($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result["status"] = "NO_DATA";
    $result["result"] = array();
    $data = array();

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null)
    {
        while ($row = $location_result->fetch_array())
        {
            $record_found = true;

            $job_id = $row["job_id"];
            $address = $row["address"];
            $location_state = $row["state"];
            $lat = $row["location_lat"];
            $lng = $row["location_lon"];
            $country_name = stringCase($row["country"],STRING_CASE_CAP_EACH);
            $country_iso = stringCase($row["country_code"],STRING_CASE_UPPER);
            $response_total = $row["survey_total"];
            $collector_total = $row["researcher_required"];
            //$collector_count = $row["researcher_count"];

            //$progress = getLocationProgress($job_id, $paperweight);

            //the number of actually completed questionnaires
            //$response_count = $progress["combined_total"];

            $data[$index]["country"] = $country_name;
            $data[$index]["country_code"] = $country_iso;
            $data[$index]["state"] = $location_state;
            $data[$index]["address"] = $address;
            $data[$index]["lat"] = $lat;
            $data[$index]["lng"] = $lng;
            $data[$index]["researchers"] = $collector_total;
            $data[$index]["responses"] = $response_total;
            $data[$index]["local_id"] = "location_" . ($index + 1);
            $data[$index]["unique_id"] = $job_id;
            $tags = getJobTags($job_id,$paperweight);
            $data[$index]["job_tags"] = $tags;

            //$data[$index]["progress"] = $progress["progress"];

            $index++;

        }
    }

    if ($record_found){
        $result["status"] = "OK";
        $result["result"] = $data;
    }


    return $result;
}

function addLocationDetail($location_detail,$paperweight){
    $task_ref_id = $location_detail["task_ref_id"];
    $task_id = $location_detail["task_id"];
    $user_id = $location_detail["user_id"];
    $cpq = $location_detail["cpq"];
    $activity_type = $location_detail["activity_type"];

    $location_count = $location_detail["location_count"];
    $location_list = $location_detail["location_list"];

    if($location_count > 0){
        //if we have location to process

        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = generateNumericId();
            $update_time = getCurrentTime();

            $required_researchers = text_clean($location_list[$x]["researchers"]);
            $required_responses = text_clean($location_list[$x]["responses"]);

            $address = text_clean($location_list[$x]["address"]);
            $state = text_clean($location_list[$x]["state"]);
            $country = text_clean($location_list[$x]["country"]);
            $country_code = text_clean($location_list[$x]["country_code"]);
            $location_lat = text_clean($location_list[$x]["lat"]);
            $location_lon = text_clean($location_list[$x]["lng"]);
            $job_tags = $location_list[$x]["job_tags"];


            //insert new job instance
            $add_job = "insert into " . TABLE_JOBS . " (job_id,update_time,task_id,user_id,address,state,country,country_code,location_lat,location_lon,researcher_required,survey_total,cpq) values ('$location_id','$update_time','$task_id','$user_id','$address','$state','$country','$country_code','$location_lat','$location_lon','$required_researchers','$required_responses','$cpq')";
            $add_job_result = $paperweight->query($add_job);
            if($add_job_result != null && $add_job_result->is_row_affected()){

                $tag_count = count($job_tags);
                if($tag_count > 0){
                    for($i = 0; $i < $tag_count; $i++){

                        $tag_id = generateNumericId();
                        $tag_label = $job_tags[$i]["tag_label"];
                        $tag_data = json_encode($job_tags[$i]["tag_data"]);


                        //insert new tag
                        $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                        $add_tag_result = $paperweight->query($add_tag);
                        if($add_tag_result != null && $add_tag_result->is_row_affected()){

                        }


                    }
                }

            }


        }
    }

    if (isset($location_detail["tag_effort"])){
        $update_time = getCurrentTime();
        $tag_id = generateNumericId();
        $tag_label = "tag_effort";

        $d = array();
        $d["level"] = $location_detail["tag_effort"];
        $tag_data = json_encode($d);

        $add_effort = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$update_time','$tag_label','$tag_data')";
        $add_effort_result = $paperweight->query($add_effort);
    }

}

//remove locations from the database that are no longer present after update
function removeDeletedLocations($locationDetails,$task_id,$paperweight){

    $index = 0;
    $update_found = false;
    $update_array = array();
    $update_string = " (";

    $location_count = $locationDetails["location_count"];
    $location_list = $locationDetails["location_list"];

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            if (!empty($location_id)){
                if ($x == 0){
                    $update_string .= "'$location_id'";
                    $update_found = true;
                }
                else{
                    $update_string .= ",'$location_id'";
                    $update_found = true;
                }
            }

        }

        if (!$update_found){
            $update_string .= "''";
        }

    }
    else{
        $update_string .= "''";
    }

    $update_string .= ") ";


    $location_query = "delete from " . TABLE_JOBS . " where task_id = '$task_id' and job_id not in " . $update_string;
    $location_result = $paperweight->query($location_query);

}

//remove tags from the database that are no longer present after update
function removeDeletedLTags($locationDetails,$task_id,$paperweight){
    $index = 0;
    $update_found = false;
    $update_array = array();
    $update_string = " (";


    $location_count = $locationDetails["location_count"];
    $location_list = $locationDetails["location_list"];

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            $job_tags = $location_list[$x]["job_tags"];

            $tag_count = count($job_tags);
            if($tag_count > 0){
                for($i = 0; $i < $tag_count; $i++){

                    $tag_id = $job_tags[$i]["unique_id"];
                    if (!empty($tag_id)){

                        if ($index == 0){
                            $update_string .= "'$tag_id'";
                        }
                        else{
                            $update_string .= ",'$tag_id'";
                        }

                        $update_found = true;

                        $index++;

                    }

                }
            }

        }

        if (!$update_found){
            $update_string .= "''";
        }

    }
    else{
        $update_string .= "''";
    }

    $update_string .= ") ";

    //SELECT * FROM initia19_paperweight.job_tag where task_id = 263 and job_id is not null and job_id not in ('51090173')

    $tag_query = "delete from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and job_id is not null and tag_id not in " . $update_string;
    $tag_result = $paperweight->query($tag_query);

}

function updateLocationDetail($location_detail,$paperweight){
    $task_ref_id = $location_detail["task_ref_id"];
    $task_id = $location_detail["task_id"];
    $user_id = $location_detail["user_id"];
    $cpq = $location_detail["cpq"];
    $activity_type = $location_detail["activity_type"];

    $location_count = $location_detail["location_count"];
    $location_list = $location_detail["location_list"];

    //purge database of unwanted locations
    removeDeletedLocations($location_detail,$task_id,$paperweight);
    removeDeletedLTags($location_detail,$task_id,$paperweight);


    $string = '';


    $location_exist = false;

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            if (!empty($location_id)){
                $location_exist = true;
            }
            else{
                $location_exist = false;
                $location_id = generateNumericId();
            }


            $update_time = getCurrentTime();

            $required_researchers = text_clean($location_list[$x]["researchers"]);
            $required_responses = text_clean($location_list[$x]["responses"]);

            $address = text_clean($location_list[$x]["address"]);
            //$address = text_clean($location_list[$x]["address"]);
            $state = text_clean($location_list[$x]["state"]);
            $country = text_clean($location_list[$x]["country"]);
            $country_code = text_clean($location_list[$x]["country_code"]);
            $location_lat = text_clean($location_list[$x]["lat"]);
            $location_lon = text_clean($location_list[$x]["lng"]);
            $job_tags = $location_list[$x]["job_tags"];

            if ($location_exist){

                //update existing job instance
                $update_job = "update " . TABLE_JOBS . " set update_time = '$update_time',address = '$address',state = '$state',country = '$country',country_code = '$country_code',location_lat = '$location_lat',location_lon = '$location_lon',researcher_required = '$required_researchers',survey_total = '$required_responses',cpq = '$cpq' where job_id = '$location_id'";
                $update_job_result = $paperweight->query($update_job);
                if($update_job_result != null && $update_job_result->is_row_affected()){

                    $tag_exist = false;

                    $tag_count = count($job_tags);
                    if($tag_count > 0){
                        for($i = 0; $i < $tag_count; $i++){

                            $tag_id = $job_tags[$i]["unique_id"];
                            if (!empty($tag_id)){
                                $tag_exist = true;
                            }
                            else{
                                $tag_exist = false;
                                $tag_id = generateNumericId();
                            }

                            $tag_label = $job_tags[$i]["tag_label"];
                            $tag_data = json_encode($job_tags[$i]["tag_data"]);

                            if ($tag_exist){
                                //update existing tag
                                $update_tag = "update " . TABLE_JOB_TAGS . " set update_time = '$update_time',tag_label = '$tag_label',tag_data = '$tag_data' where tag_id = '$tag_id'";
                                $update_tag_result = $paperweight->query($update_tag);
                                if($update_tag_result != null && $update_tag_result->is_row_affected()){

                                }
                            }
                            else{
                                //insert new tag
                                $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                                $add_tag_result = $paperweight->query($add_tag);
                                if($add_tag_result != null && $add_tag_result->is_row_affected()){

                                }
                            }

                        }
                    }

                }
            }
            else{
                //insert new job instance
                $add_job = "insert into " . TABLE_JOBS . " (job_id,update_time,task_id,user_id,address,state,country,country_code,location_lat,location_lon,researcher_required,survey_total,cpq) values ('$location_id','$update_time','$task_id','$user_id','$address','$state','$country','$country_code','$location_lat','$location_lon','$required_researchers','$required_responses','$cpq')";
                $add_job_result = $paperweight->query($add_job);
                if($add_job_result != null && $add_job_result->is_row_affected()){

                    $tag_count = count($job_tags);
                    if($tag_count > 0){
                        for($i = 0; $i < $tag_count; $i++){

                            $tag_id = generateNumericId();
                            $tag_label = $job_tags[$i]["tag_label"];
                            $tag_data = json_encode($job_tags[$i]["tag_data"]);


                            //insert new tag
                            $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                            $add_tag_result = $paperweight->query($add_tag);
                            if($add_tag_result != null && $add_tag_result->is_row_affected()){

                            }


                        }
                    }

                }

            }



        }

    }

    if (isset($location_detail["tag_effort"])){
        $update_time = getCurrentTime();
        $tag_id = generateNumericId();
        $tag_label = "tag_effort";

        $d = array();
        $d["level"] = $location_detail["tag_effort"];
        $tag_data = json_encode($d);

        $update_effort = "update " . TABLE_JOB_TAGS . " set update_time = '$update_time', tag_data = '$tag_data' where task_id = '$task_id' and tag_label = '$tag_label'";
        $add_effort_result = $paperweight->query($update_effort);
    }

}

function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}


//@NOTE : CREATE DataCollector CLASS TO HOLD ALL USER DATA === last location, persistent state, id, #, list of jobs, outstanding payments



/*function sendMail($to, $subject, $body, $extra_headers=''){
    $send_email_by = CONF_EMAIL_SEND_VIA;
    if($send_email_by==CONF_EMAIL_SEND_VIA_SMTP){
        $res = sendSmtpMail($to, $subject, $body);

        if($res['status']!='sent' || $res['reject_reason']!='')
        {
            $message = "Hi,<br><br>";
            $message .= "Current status to send email for ".$subject." to ".$res['email']." is ".$res['status'];
            $message .= ", due to: ".$res['reject_reason'];
            $message .= ".<br><br>";
            $message .= "Thanks,<br><br>";
            $message .= CONF_WEBSITE_NAME." Team";
            $sub = 'Mail could not sent via SMTP on '.CONF_WEBSITE_URL;
            mail(CONF_ADMIN_EMAIL_ID, $sub, $message);
        }
        else{
            return true;
        }
    }

    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' .CONF_EMAILS_FROM_NAME. '<'. CONF_EMAILS_FROM . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}*/
/*

//$to = "kadian.salmon@queritel.com";
        $to = "kadansalmon.ks@gmail.com";
        $subject = "This is a Debug test";
        $body = "This serves as an email debugging test3";

        sendMail($to, $subject, $body, $extra_headers='');

 */

function createEmailInvitationBody($url,$organization_name){

    $date = date("M d, Y h:i");
    $timezone = date_default_timezone_get();
    //$url = "https://www.google.com"; //' . $url . '
    $org_name = $organization_name;//"Queritel Business'";


    $body = '
    
    <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
	<tbody>
		<tr style="background:#bf0000 none repeat scroll 0px 0px;">
			<td style="padding:0px;">
				<table border="0" width="100%" cellspacing="0" cellpadding="0">
					<tbody>
						<tr>
							<td style="padding:10px 20px;">
								<a href="https://queritel.com" target="_blank" rel="noopener noreferrer"><img src="https://queritel.com/images/cms/white-logo-01%2520copy.png" alt="Queritel.com" width="76" height="32"  style=""></a>
							</td>
							<td style="text-align:right;vertical-align:top;padding:10px 20px 0px 0px;"><span style="font-size:13px;color:#fff;vertical-align:top;">' . $date . ' ' . $timezone . '</span></td>
						</tr>
						<tr>
							<td colspan="2">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tbody>
										<tr>
											<td style="background:#eeeeee;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="vertical-align:bottom;text-align:center;">
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">&nbsp;</h2>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hello there,</h2>
																<p style="color:#3e434a;font-size:14px;font-weight:bold;margin:0px;">You have been invited to be apart of the ' . $org_name . ' Data Collection Network.</p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">Click the link below or copy it to your browser\'s address bar to proceed with your registration</p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="' . $url . '" target="_blank" rel="noopener noreferrer">Click here to register your account</a></p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">&nbsp;</p>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="background:#3b3f46;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="color:#fff;font-weight:bold;text-align:center;padding:5px 0 10px;">Find us on :</td>
														</tr>
														<tr>
															<td style="padding-bottom:25px;">
																<table border="0" width="100%" cellspacing="0" cellpadding="0">
																	<tbody>
																		<tr>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.facebook.com/Queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/facebook.png" alt="Facebook" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://twitter.com/Queritel" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/twitter.png" alt="Twitter" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.instagram.com/queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/instagram.png" alt="Instagram" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.linkedin.com/company/queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/linkedin.png" alt="Linkedin" width="16"></a>
																			</td>
																		</tr>
																	</tbody>
																</table>
															</td>
														</tr>
														<tr>
															<td style="text-align:center;color:#f2f2f2;font-size:14px;font-weight:bold;">
																<div>Thanks! &nbsp; Queritel, <a style="color:#fff;" href="https://queritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
																<div>
																	<br> </div>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="text-align:center;padding-bottom:10px;background:rgb(191,0,0);">
												<div style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Need help? Have feedback? Feel free to Contact&nbsp;<a style="color:#fff;" href="http://queritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
												
												<span style="color:rgb(255,255,255);font-size:12px;font-weight:600;padding:8px 0px 0px;">Copyright © 2020 Queritel</span>
											</td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</tbody>
</table>
    
    ';

    //return $timezone;
    return $body;
}
function _createEmailBody_OLD(){

    $date = date("M d, Y h:i");
    $timezone = date_default_timezone_get();


    $body = '
    
    <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
	<tbody>
		<tr style="background:#bf0000 none repeat scroll 0px 0px;">
			<td style="padding:0px;">
				<table border="0" width="100%" cellspacing="0" cellpadding="0">
					<tbody>
						<tr>
							<td style="padding:10px 20px;">
								<a href="https://queritel.com" target="_blank" rel="noopener noreferrer"><img src="https://queritel.com/images/cms/white-logo-01%2520copy.png" alt="Queritel.com" width="76" height="32"  style=""></a>
							</td>
							<td style="text-align:right;vertical-align:top;padding:10px 20px 0px 0px;"><span style="font-size:13px;color:#fff;vertical-align:top;">' . $date . ' ' . $timezone . '</span></td>
						</tr>
						<tr>
							<td colspan="2">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tbody>
										<tr>
											<td style="background:#eeeeee;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="vertical-align:bottom;text-align:center;">
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">&nbsp;</h2>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hello Queritel Contributor,</h2>
																<p style="color:#3e434a;font-size:14px;font-weight:bold;margin:0px;">Thank you for your willingness to work with queritel.com.</p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">Click the link below or copy-paste it in your browser\'s address bar to confirm your email and proceed with your registration</p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com%2Fuser%2Fverify_email%2Fa2FkaWFuLnNhbG1vbkBxdWVyaXRlbC5jb20%253D_K8R8PXCZTK8KXO3" target="_blank" rel="noopener noreferrer">Click here to verify your account</a></p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">&nbsp;</p>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hola colaborador de Queritel,</h2>
																<p style="margin:4px 0px;"><span style="font-size:13px;font-weight:bold;color:rgb(62,67,74);">Gracias por su disposiciÃ³n a trabajar con queritel.com.</span></p>
																<p style="margin:4px 0px;"><span style="font-size:13px;color:rgb(62,67,74);">Haga clic en el enlace a continuaciÃ³n o cÃ³pielo y péguelo en la barra de direcciones de su navegador para confirmar su correo electrÃ³nico y continuar con su registro</span></p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com%2Fuser%2Fverify_email%2Fa2FkaWFuLnNhbG1vbkBxdWVyaXRlbC5jb20%253D_K8R8PXCZTK8KXO3" target="_blank" rel="noopener noreferrer">Haga clic aquÃ&shy; para verificar su cuenta</a></p>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="background:#3b3f46;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="color:#fff;font-weight:bold;text-align:center;padding:5px 0 10px;">Find us on | Encuéntranos en :</td>
														</tr>
														<tr>
															<td style="padding-bottom:25px;">
																<table border="0" width="100%" cellspacing="0" cellpadding="0">
																	<tbody>
																		<tr>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fwww.facebook.com%2FQueritel%2F" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ffacebook.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Facebook" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ffacebook.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="%7B--%7D" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ftwitter.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Twitter" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ftwitter.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="%7BCONF_INSTAGRAM%7D" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Finstagram.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Instagram" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Finstagram.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fwww.linkedin.com%2Fcompany%2Fqueritel%2F" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Flinkedin.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Linkedin" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Flinkedin.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																		</tr>
																	</tbody>
																</table>
															</td>
														</tr>
														<tr>
															<td style="text-align:center;color:#f2f2f2;font-size:14px;font-weight:bold;">
																<div>Thanks! Â¡Gracias!&nbsp; Queritel, <a style="color:#fff;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
																<div>
																	<br> </div>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="text-align:center;padding-bottom:10px;background:rgb(191,0,0);">
												<div style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Need help? Have feedback? Feel free to Contact&nbsp;<a style="color:#fff;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fqueritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
												<div><span style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Â¿Necesitas ayuda? Â¿Tienes comentarios? Siéntase libre de contactar queritel.com</span></div><span style="color:rgb(255,255,255);font-size:12px;font-weight:600;padding:8px 0px 0px;">Copyright Â© 2020 Queritel</span></td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</tbody>
</table>
    
    ';

    //return $timezone;
    return $body;
}
function sendMail($to, $subject, $body, $extra_headers=''){
    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' . "Queritel" . '<'. "queritel@queritel.co" . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}

//get user detail for viewing team information
function getUserDetail($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $email = stringCase($row["user_email"],STRING_CASE_LOWER);


            $result["user_id"] = $user_id;
            $result["user_ref_id"] = $row["user_ref_id"];
            $result["user_name"] = $fname . ' ' . $lname;
            $result["user_email"] = $email;
            $result["reg_date"] = $row["user_regdate"];


        }
    }

    return $result;
}


//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;


        }
    }

    return $result;
}

function network_rel_list($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];

            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;


        }
    }

    return $result;
}

/**@deprecated*/
function __getNetworkRelationship__($user_id, $paperweight){

    $result = array();

    $result["status"] = "NO_REL";

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $result["status"] = "OK";

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $result["network_id"] = $network_id;
            $result["network_role"] = $network_role;
            $result["relationship_state"] = $network_rel_state;

        }
    }


    return $result;
}

function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}
function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}

function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}




/*
 *  @uses : gets an array of the Data Collector progress at a specific job location
 *
 *  "combined_total" : 0
 *  "progress": [
{
"fname": "First",
"lname": "Last",
"response_total": 10,
"response_count": 4
},
{
"fname": "First-2",
"lname": "Last-2",
"response_total": 10,
"response_count": 2
}
]
 */
function getLocationProgress($job_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;

    $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {
        while ($row = $response_result->fetch_array())
        {
            $response_total = $row["survey_count"];
            $response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];
            $user_info = query_user($user_id, $paperweight);

            $progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            $progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            $progress[$index]["user_id"] = $user_info["user_id"];
            $progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            $progress[$index]["response_total"] = intval($response_total);
            $progress[$index]["response_count"] = intval($response_count);

            $combined_total = $combined_total + $response_count;

            $index++;

        }
    }

    $result["combined_total"] = intval($combined_total);
    $result["progress"] = $progress;

    return $result;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];

            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;


        }
    }

    return $result;
}

function extractActiveLocationList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];

            /*$project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;*/

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $record_found = true;

                    $location_id = $job["location_id"];
                    $location = $job["location"];
                    $location_state = $job["location_state"];
                    $lat = $job["lat"];
                    $lng = $job["lng"];
                    $country  = $job["country"];
                    $country_iso  = $job["country_iso"];
                    $response_total  = $job["response_total"];
                    $response_count  = $job["response_count"];
                    $collector_total  = $job["collector_total"];
                    $collector_count  = $job["collector_count"];
                    $progress  = $job["progress"];

                    $record = array();

                    $record["location_id"] = $location_id;
                    $record["location"] = $location;
                    $record["order_ref_id"] = $order_ref_id;
                    $record["location_state"] = $location_state;
                    $record["lat"] = $lat;
                    $record["lng"] = $lng;
                    $record["country"] = $country;
                    $record["country_iso"] = $country_iso;
                    $record["response_total"] = $response_total;
                    $record["response_count"] = $response_count;
                    $record["collector_total"] = $collector_total;
                    $record["collector_count"] = $collector_count;
                    $record["progress"] = $progress;

                    array_push($result_list,$record);

                }
            }

        }
    }

    return $result_list;
}
function extractActiveProjectList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            $record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);

        }
    }

    return $result_list;
}
function extractActiveProjectData($task_data){

    $result_list = array();
    //$location_list = array();

    //$record_found = false;

    $active_jobs_ = 0;
    $active_locations_ = 0;
    $collector_total_ = 0;
    $collector_count_ = 0;
    $response_total_ = 0;
    $response_count_ = 0;



    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            /*$record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);*/

            $active_jobs_ += 1;
            $active_locations_ += $location_count;
            $collector_total_ += $collector_total;
            $collector_count_ += $collector_count;
            $response_total_ += $response_total;
            $response_count_ += $response_count;

        }
    }

    $result_list["active_jobs"] = $active_jobs_;
    $result_list["active_locations"] = $active_locations_;
    $result_list["collector_total"] = $collector_total_;
    $result_list["collector_count"] = $collector_count_;
    $result_list["response_total"] = $response_total_;
    $result_list["response_count"] = $response_count_;

    /*if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }*/

    return $result_list;
}
function extractTopLocationList($task_data){
    $result_list = array();
    $location_list = array();

    $record_found = false;

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $country_iso = $job["country_iso"];
                    $record_found = true;

                    if (isset($location_list[$country_iso])){
                        $location_list[$country_iso]["count"] += 1;
                    }
                    else{
                        $location_list[$country_iso]["iso"] = $country_iso;
                        $location_list[$country_iso]["name"] = $job["country"];
                        $location_list[$country_iso]["count"] = 1;
                    }


                }
            }

        }
    }

    if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }

    return $result_list;
}
//get the job list for viewing the location instance including the data collector progress
function getJobList($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result["status"] = "NO_JOBS";
    $data = array();

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null)
    {
        while ($row = $location_result->fetch_array())
        {
            $record_found = true;

            $job_id = $row["job_id"];
            $address = $row["address"];
            $location_state = $row["state"];
            $lat = $row["location_lat"];
            $lng = $row["location_lon"];
            $country_name = stringCase($row["country"],STRING_CASE_CAP_EACH);
            $country_iso = stringCase($row["country_code"],STRING_CASE_UPPER);
            $response_total = $row["survey_total"];
            $collector_total = $row["researcher_required"];
            $collector_count = $row["researcher_count"];

            $progress = getLocationProgress($job_id, $paperweight);

            //the number of actually completed questionnaires
            $response_count = $progress["combined_total"];

            $data[$index]["location_id"] = $job_id;
            $data[$index]["location"] = $address;
            $data[$index]["location_state"] = $location_state;
            $data[$index]["lat"] = $lat;
            $data[$index]["lng"] = $lng;
            $data[$index]["country"] = $country_name;
            $data[$index]["country_iso"] = $country_iso;
            $data[$index]["response_total"] = $response_total;
            $data[$index]["response_count"] = $response_count;
            $data[$index]["collector_total"] = $collector_total;
            $data[$index]["collector_count"] = $collector_count;
            $data[$index]["progress"] = $progress["progress"];

            $index++;

        }
    }

    if ($record_found){
        $result["status"] = "OK";
    }

    $result["result"] = $data;

    return $result;
}


function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        while ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result[] = $net;

        }
    }


    return $result;
}
function getQuestCreatorNetwork($task_id,$paperweight){
    $network_id = null;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $network_id = $row["creator_net_id"];
        }
    }

    return $network_id;
}
function getLastMsg($agent_id,$network_id,$task_id,$paperweight){
    //get the last communication between an agent and the network
    //as well as the unread messages
    $last_msg = array();
    $last_msg["msg_body"] = "";
    $last_msg["timestamp"] = "";
    $last_msg["unread"] = 0; //the combined unread messages


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$network_id' or recipient_network_id = '$network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){


        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);
            $read = $row["read"];
            $unread = 0;


            $last_msg["msg_body"] = $msg_body;
            $last_msg["timestamp"] = $timestamp;

            if (($recipient_network_id == $network_id) && $read == 0){
                $prev_unread = $last_msg["unread"];
                $new_unread = $prev_unread + 1;

                $last_msg["unread"] = $new_unread;

            }

        }

    }


    return $last_msg;
}
//users who accepted the specific quest
function getQuestAgents($task_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;
    $processed_array = array();

    $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {

        $data = array();

        while ($row = $response_result->fetch_array())
        {

            //$response_total = $row["survey_count"];
            //$response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];


            if (!isset($processed_array[$user_id])){

                $user_info = query_user($user_id, $paperweight);

                $data["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
                $data["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
                $data["user_id"] = $user_info["user_id"];

                $processed_array[$user_id] = $data;

                $progress[$index] = $data;

                $index++;
            }

            //$progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["user_id"] = $user_info["user_id"];


            //$progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            //$progress[$index]["response_total"] = intval($response_total);
            //$progress[$index]["response_count"] = intval($response_count);

            //$combined_total = $combined_total + $response_count;
        }
    }

    //$result["combined_total"] = intval($combined_total);
    //$result["progress"] = $progress;

    return $progress;

}


/*
 my name is kadan
 */