<?php
//enable resourse sharing(allows this resource to be shared with "all[*]" requesting scripts
header("Access-Control-Allow-Origin: *");

//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_RESPONSE", "survey_response");

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("PASSWORD_SALT", "ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK", "OK");
define("STATUS_LOGIN_FAILED", "LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");

//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED", 2);
define("SURVEY_STATE_CANCELLED", 3);

//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);

//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CUSTOMER", 0);

//gender
define("GENDER_MALE", 1);
define("GENDER_FEMALE", 0);
//--------------------------------


include("../includes/headers/classes.php"); //has all the classes needed for queritel back-end
include("../includes/headers/miscellaneous.php"); //additional functions
include("../includes/headers/strings.php"); //has all the constants needed


$paperweight = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);

/**
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 */

if (isset($_REQUEST["action"]))
{

    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];


    //** INCOMPLETED **
    if ($action == 'register_client')
    {

        $data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }

    //** INCOMPLETED **
    if ($action == 'register_agent')
    {

        $data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }


    //https://api.queritel.com/api/general/qworkservices.php?action=invite_team&param_json={"key":value}
    //** INCOMPLETED **
    if ($action == 'invite_team')
    {


        /*$data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);*/

    }

    //** INCOMPLETED **
    if ($action == 'view_team')
    {

        $data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }

    //** INCOMPLETED **
    if ($action == 'view_team_invitation')
    {

        $data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }






    //https://api.queritel.com/api/general/fieldmanagement.php?action=get_job_instance&param_json={"task_id":180}
    if ($action == "demo")
    {
        $data = json_decode($param_json, true);

        echo "This is demo <br>";
        echo $data["name"];
    }

    /*
     *  @api get_job_instance
     *  @param task_id
     *  @uses gets general job_instance data for specific [task_id] (used by : Admin Field Management)
     *

        {
    "status": "OK | NO_JOBS",
    "result": [
        {
            "location": "Address Location 1",
            "lat": 17.596855,
            "lng": -127.596855,
            "country": "Country 1",
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location": "Address Location 2",
            "lat": 17.596855,
            "lng": -127.596855,
            "country": "Country 2",
            "response_total": 40,
            "response_count": 6,
            "progress": [
                {
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 4
                },
                {
                    "fname": "First-2",
                    "lname": "Last-2",
                    "response_total": 10,
                    "response_count": 2
                }
            ]
        }
    ]
}

     */
    // ** COMPLETED **
    if ($action == 'get_job_instance')
    {

        $data = json_decode($param_json, true);

        $task_id = clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }

    /*
     *  @api send_message
     *  @param
     *  @uses processes a send message request
     *
     * {
        "status": "OK",
        "send_result":
        {
            "timestamp" :"' . $stamp . '",
            "message_id": "' . $mID . '",
            "sender_id": -1,
            "recipient_id": ' . $o_rec . '"
        }

        }
     */
    //SAMPLE
    if ($action == 'send_message'){
        $data_p = json_decode($param_json, true);

        $o_body = clean($data_p["body"]);
        $o_rec = clean($data_p["recipient_id"]);

        $stamp = getCurrentTime();
        $sender = - 1;
        $body = $o_body;
        $mID = getRandomString(8);


        //$data = json_decode($sample, true);
        $f["timestamp"] = $stamp;
        $f["message_id"] = $mID;
        $f["sender_id"] = -1;
        $f["recipient_id"] = $o_rec;
        $f["body"] = $body;

        $data["status"] = "OK";
        $data["send_result"] = $f;
        echo json_encode($data);
    }

    /*
     *
     *  @api get_active_project
     *  @param
     *  @uses gets all active jobs (projects)
     *

        {
    "status": "OK | NO_DATA",
    "active_jobs": 2,
    "active_locations": 2,
    "collector_total": 8,
    "collector_count": 2,
    "response_total": 80,
    "response_count": 2,
    "top_location_list": [
        {
            "iso": "country-iso",
            "name": "country-name",
            "count": "job-location-count"
        }
    ],
    "project_list": [
        {
            "order_ref_id": "task-reference-id",
            "project_name": "task_topic",
            "project_detail": "task_instructions",
            "question_count": "task_question_count",
            "response_total": "task_respondent_count",
            "response_count": "responses-for-this-proj",
            "collector_total": "collector-needed",
            "collector_count": "accepted-so-far"
        }
    ]
}

     */
    //SAMPLE
    if ($action == 'get_active_project__')
    {

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $sample = '{
    "status": "OK",
    "active_jobs": 2,
    "active_locations": 3,
    "collector_total": 12,
    "collector_count": 2,
    "response_total": 120,
    "response_count": 2,
    "top_location_list": [
        {
            "iso": "JM",
            "name": "Jamaica",
            "count": 2
        },
        {
            "iso": "CL",
            "name": "Chile",
            "count": 1
        }
    ],
    "project_list": [
        {
            "order_ref_id": "2623641843",
            "project_name": "Stark Industry\'s Customer Review",
            "project_detail": "To determine the public\'s attitude to Stark Industry\'s profiteering from the selling of weapons of mass destruction",
            "location_count": 2,
            "question_count": 10,
            "response_total": 80,
            "response_count": 1,
            "collector_total": 8,
            "collector_count": 1
        },
        {
            "order_ref_id": "1080041606",
            "project_name": "Grace Kennedy Expansion Review",
            "project_detail": "Responses must be obtained from individuals who were born in latin america",
            "location_count": 1,
            "question_count": 25,
            "response_total": 40,
            "response_count": 0,
            "collector_total": 4,
            "collector_count": 0
        }
    ]
}';

        $data = json_decode($sample, true);

        //$task_id = clean($data["task_id"]);
        /*$index = 0;
        $result["status"] = "NO_JOBS";
        $data = array();
        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);
        if ($location_result != null) {
            while ($row = $location_result->fetch_array()) {
                $result["status"] = "OK";
                $job_id = $row["job_id"];
                $address = $row["address"];
                $country = $row["country"];
                $response_total = $row["survey_total"];
                $progress = getLocationProgress($job_id, $paperweight);
                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];
                $data[$index]["location"] = $address;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];
                $index++;
            }
        }
        $result["result"] = $data;
        */

        echo json_encode($data);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    // ** COMPLETED **
    if ($action == 'get_active_project')
    {

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        //$data = json_decode($sample, true);


        $result["status"] = "NO_DATA";

        $record_found = false;
        $task_data = array();
        $index = 0;

        $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
        $task_result = $paperweight->query($task_query);

        if ($task_result != null)
        {
            while ($row = $task_result->fetch_array())
            {
                $record_found = true;

                $task_id = $row["task_id"];
                $order_ref_id = $row["task_ref_id"];
                $project_name = $row["task_topic"];
                $project_detail = $row["task_instructions"];
                $location_count = $row["task_location_count"];
                $question_count = $row["task_question_count"];
                $job_list = array();

                $job_list_data = getJobList($task_id,$paperweight);

                if ($job_list_data["status"] == "OK"){
                    $job_list = $job_list_data["result"];
                }


                $task_data[$index]["task_id"] = $task_id;
                $task_data[$index]["order_ref_id"] = $order_ref_id;
                $task_data[$index]["project_name"] = $project_name;
                $task_data[$index]["project_detail"] = $project_detail;
                $task_data[$index]["location_count"] = $location_count;
                $task_data[$index]["question_count"] = $question_count;
                $task_data[$index]["job_list"] = $job_list;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $general_data = extractActiveProjectData($task_data);

            //$result["collector"] = $task_data;
            $result["active_jobs"] = $general_data["active_jobs"];
            $result["active_locations"] = $general_data["active_locations"];
            $result["collector_total"] = $general_data["collector_total"];
            $result["collector_count"] = $general_data["collector_count"];
            $result["response_total"] = $general_data["response_total"];
            $result["response_count"] = $general_data["response_count"];
            $result["top_location_list"] = extractTopLocationList($task_data);
            $result["project_list"] = extractActiveProjectList($task_data);

        }

        echo json_encode($result);

    }

    /*
     *
     *  @api get_active_location
     *  @param
     *  @uses gets all active jobs along with their locations and the data collectors connected to the job
     *
     {
    "status": "OK | NO_DATA",
    "location_list": [
        {
            "location_id": "100275",
            "lat": 18.493093,
            "lng": -77.658104,
            "location": "Albert Street, Falmouth, Jamaica",
            "order_ref_id": "2623641843",
            "country": "Jamaica",
            "country_iso": "JM",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "26",
                    "user_ref_id": "664801",
                    "fname": "Tracy-Ann",
                    "lname": "Wiltshire",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "108086",
            "lat": 18.006166,
            "lng": -76.812691,
            "location": "85 Hagley Park Rd, Kingston, Jamaica",
            "order_ref_id": "2623641843",
            "country": "Jamaica",
            "country_iso": "JM",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "28",
                    "user_ref_id": "223340",
                    "fname": "Colleen",
                    "lname": "Williams",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "131418",
            "lat": -33.417751,
            "lng": -70.606346,
            "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
            "order_ref_id": "1080041606",
            "country": "Chile",
            "country_iso": "CL",
            "collector_total": 4,
            "collector_count": 0,
            "response_total": 40,
            "response_count": 0,
            "progress": []
        }
    ]
}
     */
    //SAMPLE
    if ($action == 'get_active_location__') {
        $data_p = json_decode($param_json, true);
        $list = $data_p["filter_list"];
        $sample = '{
        "status": "OK",
        "location_list": [
            {
                "location_id": "100275",
                "lat": 18.493093,
                "lng": -77.658104,
                "location": "Albert Street, Falmouth, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "26",
                        "user_ref_id": "664801",
                        "fname": "Tracy-Ann",
                        "lname": "Wiltshire",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "108086",
                "lat": 18.006166,
                "lng": -76.812691,
                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "28",
                        "user_ref_id": "223340",
                        "fname": "Colleen",
                        "lname": "Williams",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "131418",
                "lat": -33.417751,
                "lng": -70.606346,
                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                "order_ref_id": "1080041606",
                "country": "Chile",
                "country_iso": "CL",
                "collector_total": 4,
                "collector_count": 0,
                "response_total": 40,
                "response_count": 0,
                "progress": []
            }
        ]
    }';
        if (count($list) > 0) {
            for ($i = 0;$i < count($list);$i++) {
                if ($list[$i]["filter_criteria"] == "2623641843") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                }
                if ($list[$i]["filter_criteria"] == "1080041606") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                }
            }
        }
        //filter_type
        //filter_state
        //filter_criteria
        //filter_list
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $data = json_decode($sample, true);
        //echo json_encode($list[0]["filter_criteria"]);
        echo json_encode($data);
    }

    // ** IN PROGRESS **
    if ($action == 'get_active_location') {
        $data_p = json_decode($param_json, true);
        $list = $data_p["filter_list"];

        /*if (count($list) > 0) {
            for ($i = 0;$i < count($list);$i++) {
                if ($list[$i]["filter_criteria"] == "2623641843") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                }
                if ($list[$i]["filter_criteria"] == "1080041606") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                }
            }
        }*/
        //filter_type
        //filter_state
        //filter_criteria
        //filter_list
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        $result["status"] = "NO_DATA";

        $task_data = array();
        $index = 0;
        $record_found = false;

        $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
        $task_result = $paperweight->query($task_query);

        if ($task_result != null)
        {
            while ($row = $task_result->fetch_array())
            {
                $record_found = true;

                $task_id = $row["task_id"];
                $order_ref_id = $row["task_ref_id"];
                $project_name = $row["task_topic"];
                $project_detail = $row["task_instructions"];
                $location_count = $row["task_location_count"];
                $question_count = $row["task_question_count"];
                $job_list = array();

                $job_list_data = getJobList($task_id,$paperweight);

                if ($job_list_data["status"] == "OK"){
                    $job_list = $job_list_data["result"];
                }


                $task_data[$index]["task_id"] = $task_id;
                $task_data[$index]["order_ref_id"] = $order_ref_id;
                $task_data[$index]["project_name"] = $project_name;
                $task_data[$index]["project_detail"] = $project_detail;
                $task_data[$index]["location_count"] = $location_count;
                $task_data[$index]["question_count"] = $question_count;
                $task_data[$index]["job_list"] = $job_list;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $location_list = extractActiveLocationList($task_data);

            $result["location_list"] = $location_list;

        }

        //$data = json_decode($sample, true);
        //echo json_encode($list[0]["filter_criteria"]);
        echo json_encode($result);
    }

    /*
     *
     *  @api get_active_location-deprecated
     *  @param
     *  @uses gets all active jobs along with their locations and the data collectors connected to the job
     *
        {
    "status": "OK | NO_JOBS",
    "active_jobs": 2,
    "active_locations": 2,
    "collector_total": 8,
    "collector_count": 2,
    "response_total": 80,
    "response_count": 2,
    "location_list": [
        {
            "location_id": "job-instance-id-1",
            "lat": 17.8945743,
            "lng": -127.8995574,
            "location": "location 1",
            "order_ref_id": "task-reference-id",
            "country": "Country 1",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "user-id",
                    "user_ref_id": "user-reference-id",
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "job-instance-id-2",
            "lat": 18.8945743,
            "lng": -128.8995574,
            "location": "location 2",
            "order_ref_id": "task-reference-id",
            "country": "Country 2",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "user-id",
                    "user_ref_id": "user-reference-id",
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        }
    ]
}
     */
    //SAMPLE
    if ($action == 'get_active_location-deprecated'){
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $sample = '{
        "status": "OK",
        "active_jobs": 2,
        "active_locations": 3,
        "collector_total": 8,
        "collector_count": 2,
        "response_total": 80,
        "response_count": 2,
        "location_list": [
            {
                "location_id": "100275",
                "lat": 18.493093,
                "lng": -77.658104,
                "location": "Albert Street, Falmouth, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "26",
                        "user_ref_id": "664801",
                        "fname": "Tracy-Ann",
                        "lname": "Wiltshire",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "108086",
                "lat": 18.006166,
                "lng": -76.812691,
                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "28",
                        "user_ref_id": "223340",
                        "fname": "Colleen",
                        "lname": "Williams",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "131418",
                "lat": -33.417751,
                "lng": -70.606346,
                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                "order_ref_id": "1080041606",
                "country": "Chile",
                "country_iso": "CL",
                "collector_total": 4,
                "collector_count": 0,
                "response_total": 40,
                "response_count": 0,
                "progress": []
            }
        ]
    }';
        $data = json_decode($sample, true);
        //$task_id = clean($data["task_id"]);
        //=====
        /*$index = 0;
        $result["status"] = "NO_JOBS";
        $data = array();
        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);
        if ($location_result != null) {
            while ($row = $location_result->fetch_array()) {
                $result["status"] = "OK";
                $job_id = $row["job_id"];
                $address = $row["address"];
                $country = $row["country"];
                $response_total = $row["survey_total"];
                $progress = getLocationProgress($job_id, $paperweight);
                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];
                $data[$index]["location"] = $address;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];
                $index++;
            }
        }
        $result["result"] = $data;*/
        //======
        echo json_encode($data);
        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    /*
    *
    *  @api get_data_collector_list
    *  @param
    *  @uses gets the completed list of all activated data collectors
    *

    {
    "status": "OK | NO_DATA",
    "collector_list": [
        {
            "user_id": "user-id",
            "user_ref_id": "user-reference-id",
            "user_email": "email 1",
            "fname": "First 1",
            "lname": "Last 1",
            "user_phone": "Phone 1",
            "gender": "gender 1",
            "country": "coountry 1",
            "country_iso": "iso 1"
        },
        {
            "user_id": "user-id",
            "user_ref_id": "user-reference-id",
            "user_email": "email 2",
            "fname": "First 2",
            "lname": "Last 2",
            "user_phone": "Phone 2",
            "gender": "gender 2",
            "country": "coountry 2",
            "country_iso": "iso 2"
        }
    ]
}
    */
    //SAMPLE
    if ($action == 'get_data_collector_list _DEMO')
    {

        $result["status"] = "NO_DATA";
        $result["collector_list"] = array();
        $collector_list = array();

        //$record_found = false;
        $record_found = true;

        $i = 0;
        $collector_list[$i]["user_id"] = 22;
        $collector_list[$i]["user_ref_id"] = 758453;
        $collector_list[$i]["user_email"] = "anderson.tailor@gmail.com";
        $collector_list[$i]["fname"] = "Anderson";
        $collector_list[$i]["lname"] = "Tailor";
        $collector_list[$i]["user_phone"] = "(876)392-9856";
        $collector_list[$i]["gender"] = "male";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 1;
        $collector_list[$i]["user_id"] = 28;
        $collector_list[$i]["user_ref_id"] = 223340;
        $collector_list[$i]["user_email"] = "colleen.williams@gmail.com";
        $collector_list[$i]["fname"] = "Colleen";
        $collector_list[$i]["lname"] = "Williams";
        $collector_list[$i]["user_phone"] = "(876)472-8365";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 2;
        $collector_list[$i]["user_id"] = 26;
        $collector_list[$i]["user_ref_id"] = 664801;
        $collector_list[$i]["user_email"] = "tracy.wiltshire@gmail.com";
        $collector_list[$i]["fname"] = "Tracy-Ann";
        $collector_list[$i]["lname"] = "Wiltshire";
        $collector_list[$i]["user_phone"] = "(876)786-6543";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 3;
        $collector_list[$i]["user_id"] = 30;
        $collector_list[$i]["user_ref_id"] = 944596;
        $collector_list[$i]["user_email"] = "sandra.wilson@gmail.com";
        $collector_list[$i]["fname"] = "Sandra";
        $collector_list[$i]["lname"] = "Wilson";
        $collector_list[$i]["user_phone"] = "(876)832-4752";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";


        if ($record_found)
        {
            $result["status"] = "OK";

            $result["collector_list"] = $collector_list;

        }

        echo json_encode($result);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    // ** COMPLETED **
    if ($action == 'get_data_collector_list')
    {

        $result["status"] = "NO_DATA";
        $result["collector_list"] = array();
        $collector_list = array();
        $record_found = false;

        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $verified_by_admin = VERIFIED;

        $index = 0;


        $user_query = "select * from " . TABLE_USERS . " where user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin'";
        $user_result = $paperweight->query($user_query);

        if ($user_result != null)
        {
            while ($row = $user_result->fetch_array())
            {
                $record_found = true;

                $user_id = $row["user_id"];
                $user_ref_id = $row["user_ref_id"];
                $user_email = stringCase($row["user_email"],STRING_CASE_LOWER);
                $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
                $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
                $user_phone = $row["user_phone_number"];
                $gender = ($row["user_sex"] == GENDER_MALE) ? "male" : "female";
                $country = ""; //$row[""];
                $country_iso = ""; // $row[""];


                $collector_list[$index]["user_id"] = $user_id;
                $collector_list[$index]["user_ref_id"] = $user_ref_id;
                $collector_list[$index]["user_email"] = $user_email;
                $collector_list[$index]["fname"] = $fname;
                $collector_list[$index]["lname"] = $lname;
                $collector_list[$index]["user_phone"] = $user_phone;
                $collector_list[$index]["gender"] = $gender;
                $collector_list[$index]["country"] = $country;
                $collector_list[$index]["country_iso"] = $country_iso;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $result["collector_list"] = $collector_list;

        }

        echo json_encode($result);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

}

//@NOTE : CREATE DataCollector CLASS TO HOLD ALL USER DATA === last location, persistent state, id, #, list of jobs, outstanding payments



/*function sendMail($to, $subject, $body, $extra_headers=''){
    $send_email_by = CONF_EMAIL_SEND_VIA;
    if($send_email_by==CONF_EMAIL_SEND_VIA_SMTP){
        $res = sendSmtpMail($to, $subject, $body);

        if($res['status']!='sent' || $res['reject_reason']!='')
        {
            $message = "Hi,<br><br>";
            $message .= "Current status to send email for ".$subject." to ".$res['email']." is ".$res['status'];
            $message .= ", due to: ".$res['reject_reason'];
            $message .= ".<br><br>";
            $message .= "Thanks,<br><br>";
            $message .= CONF_WEBSITE_NAME." Team";
            $sub = 'Mail could not sent via SMTP on '.CONF_WEBSITE_URL;
            mail(CONF_ADMIN_EMAIL_ID, $sub, $message);
        }
        else{
            return true;
        }
    }

    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' .CONF_EMAILS_FROM_NAME. '<'. CONF_EMAILS_FROM . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}*/
/*

//$to = "kadian.salmon@queritel.com";
        $to = "kadansalmon.ks@gmail.com";
        $subject = "This is a Debug test";
        $body = "This serves as an email debugging test3";

        sendMail($to, $subject, $body, $extra_headers='');

 */
function sendMail($to, $subject, $body, $extra_headers=''){
    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' . "Queritel Invitation" . '<'. "queritel@queritel.co" . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}
/*
 *  @uses : gets an array of the Data Collector progress at a specific job location
 *
 *  "combined_total" : 0
 *  "progress": [
{
"fname": "First",
"lname": "Last",
"response_total": 10,
"response_count": 4
},
{
"fname": "First-2",
"lname": "Last-2",
"response_total": 10,
"response_count": 2
}
]
 */
function getLocationProgress($job_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;

    $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state in (1,2)";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null)
    {
        while ($row = $response_result->fetch_array())
        {
            $response_total = $row["survey_count"];
            $response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];
            $user_info = query_user($user_id, $paperweight);

            $progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            $progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            $progress[$index]["user_id"] = $user_info["user_id"];
            $progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            $progress[$index]["response_total"] = intval($response_total);
            $progress[$index]["response_count"] = intval($response_count);

            $combined_total = $combined_total + $response_count;

            $index++;

        }
    }

    $result["combined_total"] = $combined_total;
    $result["progress"] = $progress;

    return $result;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];

            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;


        }
    }

    return $result;
}

function extractActiveLocationList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];

            /*$project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;*/

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $record_found = true;

                    $location_id = $job["location_id"];
                    $location = $job["location"];
                    $location_state = $job["location_state"];
                    $lat = $job["lat"];
                    $lng = $job["lng"];
                    $country  = $job["country"];
                    $country_iso  = $job["country_iso"];
                    $response_total  = $job["response_total"];
                    $response_count  = $job["response_count"];
                    $collector_total  = $job["collector_total"];
                    $collector_count  = $job["collector_count"];
                    $progress  = $job["progress"];

                    $record = array();

                    $record["location_id"] = $location_id;
                    $record["location"] = $location;
                    $record["order_ref_id"] = $order_ref_id;
                    $record["location_state"] = $location_state;
                    $record["lat"] = $lat;
                    $record["lng"] = $lng;
                    $record["country"] = $country;
                    $record["country_iso"] = $country_iso;
                    $record["response_total"] = $response_total;
                    $record["response_count"] = $response_count;
                    $record["collector_total"] = $collector_total;
                    $record["collector_count"] = $collector_count;
                    $record["progress"] = $progress;

                    array_push($result_list,$record);

                }
            }

        }
    }

    return $result_list;
}
function extractActiveProjectList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            $record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);

        }
    }

    return $result_list;
}
function extractActiveProjectData($task_data){

    $result_list = array();
    //$location_list = array();

    //$record_found = false;

    $active_jobs_ = 0;
    $active_locations_ = 0;
    $collector_total_ = 0;
    $collector_count_ = 0;
    $response_total_ = 0;
    $response_count_ = 0;



    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            /*$record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);*/

            $active_jobs_ += 1;
            $active_locations_ += $location_count;
            $collector_total_ += $collector_total;
            $collector_count_ += $collector_count;
            $response_total_ += $response_total;
            $response_count_ += $response_count;

        }
    }

    $result_list["active_jobs"] = $active_jobs_;
    $result_list["active_locations"] = $active_locations_;
    $result_list["collector_total"] = $collector_total_;
    $result_list["collector_count"] = $collector_count_;
    $result_list["response_total"] = $response_total_;
    $result_list["response_count"] = $response_count_;

    /*if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }*/

    return $result_list;
}
function extractTopLocationList($task_data){
    $result_list = array();
    $location_list = array();

    $record_found = false;

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $country_iso = $job["country_iso"];
                    $record_found = true;

                    if (isset($location_list[$country_iso])){
                        $location_list[$country_iso]["count"] += 1;
                    }
                    else{
                        $location_list[$country_iso]["iso"] = $country_iso;
                        $location_list[$country_iso]["name"] = $job["country"];
                        $location_list[$country_iso]["count"] = 1;
                    }


                }
            }

        }
    }

    if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }

    return $result_list;
}
function getJobList($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result["status"] = "NO_JOBS";
    $data = array();

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null)
    {
        while ($row = $location_result->fetch_array())
        {
            $record_found = true;

            $job_id = $row["job_id"];
            $address = $row["address"];
            $location_state = $row["state"];
            $lat = $row["location_lat"];
            $lng = $row["location_lon"];
            $country_name = stringCase($row["country"],STRING_CASE_CAP_EACH);
            $country_iso = stringCase($row["country_code"],STRING_CASE_UPPER);
            $response_total = $row["survey_total"];
            $collector_total = $row["researcher_required"];
            $collector_count = $row["researcher_count"];

            $progress = getLocationProgress($job_id, $paperweight);

            //the number of actually completed questionnaires
            $response_count = $progress["combined_total"];

            $data[$index]["location_id"] = $job_id;
            $data[$index]["location"] = $address;
            $data[$index]["location_state"] = $location_state;
            $data[$index]["lat"] = $lat;
            $data[$index]["lng"] = $lng;
            $data[$index]["country"] = $country_name;
            $data[$index]["country_iso"] = $country_iso;
            $data[$index]["response_total"] = $response_total;
            $data[$index]["response_count"] = $response_count;
            $data[$index]["collector_total"] = $collector_total;
            $data[$index]["collector_count"] = $collector_count;
            $data[$index]["progress"] = $progress["progress"];

            $index++;

        }
    }

    if ($record_found){
        $result["status"] = "OK";
    }

    $result["result"] = $data;

    return $result;
}