<?php
//enable resourse sharing(allows this resource to be shared with "all[*]" requesting scripts
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');


//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");

//task status
define("TASK_STATUS_PENDING", 0);
define("TASK_STATUS_ACTIVE", 1);
define("TASK_STATUS_AWARDED", 2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT", 5);
define("TASK_STATUS_DISABLED",  6);

//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
define("ACTIVITY_TYPE_VOX", "activity_vox");
//-------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");
define("ACTIVITY_TYPE_VOX_TXT", "Vox");

//task activity category
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
define("ACTIVITY_CATEGORY_VOX", "category_vox");
//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");
define("ACTIVITY_CATEGORY_VOX_TXT", "Vox");


//paperweight database
define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("PASSWORD_SALT", "ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK", "OK");
define("STATUS_ERROR","ERROR");
define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED", "LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");



//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED", 2);
define("SURVEY_STATE_CANCELLED", 3);

//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);

//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CUSTOMER", 0);

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_NORMAL", 0);
define("NETWORK_POSITION_OFFICIAL", 1);
define("NETWORK_POSITION_DEFAULT", 2);

//gender
define("GENDER_MALE", 1);
define("GENDER_FEMALE", 0);
//--------------------------------


include ("../includes/headers/classes-v1.php"); //has all the classes needed for queritel back-end
include ("../includes/headers/miscellaneous-v1.php"); //additional functions
include ("../includes/headers/strings.php"); //has all the constants needed


$paperweight = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);

/**
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 *  @return :
 */

//TODO Replace sendMail with stmp version

if (isset($_REQUEST["interface"])){

    $interface = $_REQUEST["interface"];
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    //** TO FIX **
    if ($interface == "team"){
        //https://api.queritel.com/api/general/qworkservices.php?action=invite_team&param_json={"key":value}
        //** TO FIX **
        if ($action == 'invite_team')
        {

            $data = json_decode($param_json, true);
            $list = $data["email_list"];
            $user_id = text_clean($data["user_id"]);
            $net_role = NETWORK_ROLE_COMMANDER;

            $result = array();

            $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_role = '$net_role'";
            $network_rel_result = $paperweight->query($network_rel_query);

            $result["status"] = "FAILED";

            if ($network_rel_result != null)
            {

                $row = $network_rel_result->fetch_array();

                if ($row != null)
                {
                    $network_id = $row["network_id"];
                    $network_detail = getNetworkDetails($network_id,$paperweight);

                    if (count($list) > 0) {
                        for ($i = 0; $i < count($list); $i++) {
                            $email = $list[$i];
                            $org_name = $network_detail["organization_name"];
                            $token = getRandomString(13);

                            $generated_link = "https://api.queritel.com/api/general/mailing/email/submission?ops=invitation&op=" . $network_id . "&token=" . $token;
                            $subject = "Queritel Invitation";
                            $body = createEmailInvitationBody($generated_link,$org_name);

                            sendMail($email,$subject,$body);

                        }

                        $result["status"] = "OK";
                    }
                }
            }

            /*$data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $index = 0;

            $result["status"] = "NO_JOBS";
            $data = array();

            $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $location_result = $paperweight->query($location_query);

            if ($location_result != null)
            {

                while ($row = $location_result->fetch_array())
                {
                    $result["status"] = "OK";

                    $job_id = $row["job_id"];
                    $address = $row["address"];
                    $lat = $row["location_lat"];
                    $lng = $row["location_lon"];
                    $country = $row["country"];
                    $response_total = $row["survey_total"];

                    $progress = getLocationProgress($job_id, $paperweight);

                    //the number of actually completed questionnaires
                    $response_count = $progress["combined_total"];

                    $data[$index]["location"] = $address;
                    $data[$index]["lat"] = $lat;
                    $data[$index]["lng"] = $lng;
                    $data[$index]["country"] = $country;
                    $data[$index]["response_total"] = $response_total;
                    $data[$index]["response_count"] = $response_count;
                    $data[$index]["progress"] = $progress["progress"];

                    $index++;

                }

            }

            $result["result"] = $data;

            echo json_encode($result);*/

            echo json_encode($result);

        }

        //** TO FIX **
        if ($action == 'view_team')
        {

            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);
            $commander_role = NETWORK_ROLE_COMMANDER;
            $collector_role = NETWORK_ROLE_COLLECTOR;

            $result = array();
            $team_list = array();

            $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_role = '$commander_role'";
            $network_rel_result = $paperweight->query($network_rel_query);

            $result["status"] = "OK";

            if ($network_rel_result != null)
            {

                $row = $network_rel_result->fetch_array();

                if ($row != null)
                {
                    $network_id = $row["network_id"];
                    $network_detail = getNetworkDetails($network_id,$paperweight);
                    $org_name = $network_detail["organization_name"];

                    $net_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where network_id = '$network_id' and network_role = '$collector_role'";
                    //$net_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where network_id = 'nid_hfg589368HWrvsp' and network_role = '$collector_role'";
                    $net_rel_result = $paperweight->query($net_rel_query);
                    $index = 0;

                    if ($net_rel_result != null){
                        while ($row = $net_rel_result->fetch_array()){
                            $uid = $row["user_id"];
                            $detail = getUserDetail($uid,$paperweight);
                            $role = $row["network_role"];
                            $net_state = $row["relationship_state"];
                            if ($role == "net_collector"){
                                $user_type = 0;
                            }
                            elseif ($role == "net_manager"){
                                $user_type = 1;
                            }


                            $team_list[$index]["user_id"] = $detail["user_id"];
                            $team_list[$index]["user_ref_id"] = $detail["user_ref_id"];
                            $team_list[$index]["user_name"] = $detail["user_name"];
                            $team_list[$index]["user_type"] = $user_type;
                            $team_list[$index]["user_email"] = $detail["user_email"];
                            $team_list[$index]["reg_date"] = $detail["reg_date"];
                            $team_list[$index]["net_state"] = $net_state; //active or suspended
                            $team_list[$index]["score"] = "0.0";//collector score
                            $team_list[$index]["quest_completed"] = 0;
                            $team_list[$index]["quest_active"] = 0;

                            //if ($index == 0){//me
                            //    $team_list[$index]["quest_active"] = 1;
                            //}

                            $index++;
                        }

                        $result["team_list"] = $team_list;
                    }

                }
            }

            /*$data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $index = 0;

            $result["status"] = "NO_JOBS";
            $data = array();

            $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $location_result = $paperweight->query($location_query);

            if ($location_result != null)
            {

                while ($row = $location_result->fetch_array())
                {
                    $result["status"] = "OK";

                    $job_id = $row["job_id"];
                    $address = $row["address"];
                    $lat = $row["location_lat"];
                    $lng = $row["location_lon"];
                    $country = $row["country"];
                    $response_total = $row["survey_total"];

                    $progress = getLocationProgress($job_id, $paperweight);

                    //the number of actually completed questionnaires
                    $response_count = $progress["combined_total"];

                    $data[$index]["location"] = $address;
                    $data[$index]["lat"] = $lat;
                    $data[$index]["lng"] = $lng;
                    $data[$index]["country"] = $country;
                    $data[$index]["response_total"] = $response_total;
                    $data[$index]["response_count"] = $response_count;
                    $data[$index]["progress"] = $progress["progress"];

                    $index++;

                }

            }

            $result["result"] = $data;

            echo json_encode($result);*/
            $_format = '{
            "status": "OK",
            "team_list": [
                {
                    "user_id": "121",
                    "user_ref_id": "146902",
                    "user_name": "Kadan Salmon",
                    "user_type": 0,
                    "user_email": "kadan_salmon@yahoo.com",
                    "reg_date": "2019-05-27 10:20:34",
                    "net_state": 1,
                    "score": "0.0",
                    "quest_completed": 0,
                    "quest_active": 0
                }
            ]
        }';

            //$data = json_decode($_format, true);

            echo json_encode($result);
        }

        //** INCOMPLETED **
        if ($action == 'view_team_invitation')
        {

            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $index = 0;

            $result["status"] = "NO_JOBS";
            $data = array();

            $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $location_result = $paperweight->query($location_query);

            if ($location_result != null)
            {

                while ($row = $location_result->fetch_array())
                {
                    $result["status"] = "OK";

                    $job_id = $row["job_id"];
                    $address = $row["address"];
                    $lat = $row["location_lat"];
                    $lng = $row["location_lon"];
                    $country = $row["country"];
                    $response_total = $row["survey_total"];

                    $progress = getLocationProgress($job_id, $paperweight);

                    //the number of actually completed questionnaires
                    $response_count = $progress["combined_total"];

                    $data[$index]["location"] = $address;
                    $data[$index]["lat"] = $lat;
                    $data[$index]["lng"] = $lng;
                    $data[$index]["country"] = $country;
                    $data[$index]["response_total"] = $response_total;
                    $data[$index]["response_count"] = $response_count;
                    $data[$index]["progress"] = $progress["progress"];

                    $index++;

                }

            }

            $result["result"] = $data;

            echo json_encode($result);

        }

        //** COMPLETED **
        if ($action == 'suspend_member'){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);
            $member_id = text_clean($data["member_id"]);

            $result = array();
            $result["status"] = STATUS_ERROR;

            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }

            $update_member_network = "update " . TABLE_NETWORK_RELATIONSHIP . " set relationship_state = 0 where network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and user_id = '$member_id'";
            $member_network_result = $paperweight->query($update_member_network);

            if ($member_network_result != null && $member_network_result->is_row_affected()){
                $result["status"] = STATUS_OK;
            }

            echo json_encode($result);

        }

        //** COMPLETED **
        if ($action == 'activate_member'){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);
            $member_id = text_clean($data["member_id"]);

            $result = array();
            $result["status"] = STATUS_ERROR;

            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }

            $update_member_network = "update " . TABLE_NETWORK_RELATIONSHIP . " set relationship_state = 1 where network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and user_id = '$member_id'";
            $member_network_result = $paperweight->query($update_member_network);

            if ($member_network_result != null && $member_network_result->is_row_affected()){
                $result["status"] = STATUS_OK;
            }

            echo json_encode($result);

        }
    }

    // ** IN PROGRESS **
    if ($interface == "payments"){

        if ($action == "pending_payments"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $result = array();
            $result["status"] = "OK";
            $result["payment_list"] = array();

            $_format = '{
            "status": "OK",
            "payment_list": [
                {
                    "payment_id": "787375",
                    "user_id": "121",
                    "user_ref_id": "146902",
                    "user_name": "Kadan Salmon",
                    "quest_name": "Restaurant business survey",
                    "quest_id": "277",
                    "quest_ref_id": "8857463",
                    "quest_payout": 10
                }
            ]
        }';

            $out = json_decode($_format, true);

            if ($user_id == 125){
                echo json_encode($out);
            }
            else{
                echo json_encode($result);
            }

            //echo json_encode($result);
        }

        if ($action == "payment_status"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $result = array();
            $result["status"] = "OK";
            $result["payment_list"] = array();

            $_format = '{
            "status": "OK",
            "payment_list": [
                {
                    "payment_id": "265463",
                    "user_id": "121",
                    "user_ref_id": "146902",
                    "user_name": "Kadan Salmon",
                    "quest_name": "Restaurant business survey",
                    "quest_id": "277",
                    "quest_ref_id": "8857463",
                    "quest_payout": 10,
                    "approved" : 1,
                    "approved_date" : "2019-05-27 10:20:34"
                },
                {
                    "payment_id": "263927",
                    "user_id": "121",
                    "user_ref_id": "784763",
                    "user_name": "Kevin Smith",
                    "quest_name": "Restaurant business survey2",
                    "quest_id": "277",
                    "quest_ref_id": "7463865",
                    "quest_payout": 20,
                    "approved" : 0,
                    "approved_date" : "2019-05-27 10:20:34"
                }
            ]
        }';

            $out = json_decode($_format, true);

            if ($user_id == 125){
                echo json_encode($out);
            }
            else{
                echo json_encode($result);
            }



            //echo json_encode($out);
            //echo json_encode($result);
        }
    }

    // ** IN PROGRESS **
    if ($interface == "quest_create"){

        // ** IN PROGRESS **
        if ($action == "create"){

            $json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            $data = $_REQUEST;

            $result = array();
            $result["status"] = STATUS_ERROR;

            $quest_ready = text_clean($json_input["quest_ready"]);//ready to publish

            $activity_type = text_clean($data["activity_type"]);

            $default_service_type = 3; //task_service_type = 3 [Face to Face]
            //$default_network = getDefaultNetworkId();
            $default_network = null;
            $default_task_status = TASK_STATUS_PENDING;
            //$default_task_status = TASK_STATUS_ACTIVE;
            $default_admin_approval = 0;
            $default_survey_ready = 1;

            if ($quest_ready == 1){
                $default_task_status = TASK_STATUS_PENDING;
            }
            elseif ($quest_ready == 0){
                $default_task_status = TASK_STATUS_DRAFT;
            }

            //echo json_encode($data);
            //return;

            //workforce_timezone
            //workforce_country

            if ($activity_type == ACTIVITY_TYPE_SENTIMENT){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);


                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_DISCOVERY){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_RETAIL){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_INSPECTION){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_MONITOR){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_VOX){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);


                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $task_id = $add_task_result->insert_id();

                    $location_detail["task_ref_id"] = $task_ref_id;
                    $location_detail["task_id"] = $task_id;
                    $location_detail["user_id"] = $user_id;
                    $location_detail["cpq"] = $payout_per_response;
                    $location_detail["activity_type"] = $activity_type;
                    $location_detail["tag_effort"] = $tag_effort;
                    addLocationDetail($location_detail,$paperweight);

                    $result["status"] = STATUS_OK;
                    $result["task_id"] = $task_id;

                }
            }

            echo json_export($result);
            //echo json_encode($add_task);


        }

        // ** IN PROGRESS **
        if ($action == "update"){

            $json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            $data = $_REQUEST;

            $result = array();
            $result["status"] = STATUS_ERROR;

            $task_id = text_clean($json_input["task_id"]);
            $quest_ready = text_clean($json_input["quest_ready"]);//ready to publish


            $activity_type = text_clean($data["activity_type"]);

            $default_service_type = 3; //task_service_type = 3 [Face to Face]
            //$default_network = getDefaultNetworkId();
            $default_network = null;
            $default_task_status = TASK_STATUS_PENDING;
            //$default_task_status = TASK_STATUS_ACTIVE;
            $default_admin_approval = 0;
            $default_survey_ready = 1;

            if ($quest_ready == 1){
                $default_task_status = TASK_STATUS_PENDING;
            }
            elseif ($quest_ready == 0){
                $default_task_status = TASK_STATUS_DRAFT;
            }

            //echo json_encode($data);
            //return;

            //todo : ON ERASE RETURN NEW ID AND RELOAD THE VARIABLES
            $activity_changed = false;
            $activity_changed = hasActivityChanged($activity_type,$task_id,$paperweight);
            if ($activity_changed){
                eraseTask($task_id,$paperweight);
            }


            if ($activity_type == ACTIVITY_TYPE_SENTIMENT){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));



                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',workforce_country = '$workforce_country',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }

            }
            else if ($activity_type == ACTIVITY_TYPE_DISCOVERY){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',workforce_country = '$workforce_country',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_RETAIL){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',workforce_country = '$workforce_country',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_INSPECTION){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_MONITOR){
                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = 0;//text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);

                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;

                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }
            }
            else if ($activity_type == ACTIVITY_TYPE_VOX){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);


                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);

                $start_date = date('Y-m-d H:i:s', strtotime($start_date));
                $due_date = date('Y-m-d H:i:s', strtotime($due_date));

                $workforce_country = text_clean($data["workforce_country"]);
                $workforce_timezone = text_clean($data["workforce_timezone"]);
                $start_date = localTimezoneToUTC($start_date,$workforce_timezone);
                $due_date = localTimezoneToUTC($due_date,$workforce_timezone);


                $response_limit = text_clean($data["response_limit"]);

                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);

                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }

                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                if ($activity_changed){
                    //if this is new

                    //insert into task table
                    $add_task = "insert into " . TABLE_TASKS .
                        " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment,workforce_timezone,workforce_country,response_limit)
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment','$workforce_timezone','$workforce_country','$response_limit')";

                    //$add_task_result = null;//$paperweight->query($add_task);
                    $add_task_result = $paperweight->query($add_task);
                    if($add_task_result != null && $add_task_result->is_row_affected()){

                        $task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;
                        addLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }


                }
                else{
                    //update an existing entry
                    $update_task = "update " . TABLE_TASKS . " set task_user_id = '$user_id',creator_net_id = '$creator_net_id',task_status = '$task_status',task_topic = '$project_name',task_budget = '$task_budget',task_due_date = '$due_date',task_service_type = '$service_type',task_instructions = '$project_instruction',task_posted_on = '$posted_on',task_respondent_count = '$respondent_count',task_question_count = '$question_count',task_location_count = '$location_count',survey_url = '$survey_url',completion_url = '$completion_url',survey_ready = '$survey_ready',task_time_day = '$time_day',task_question_type = '$question_type',my_network = '$my_team',network_id = '$network_id',task_activity = '$activity_type',task_start_date = '$start_date',handle_payment = '$handle_payment',workforce_timezone = '$workforce_timezone',response_limit = '$response_limit' where task_id = '$task_id'";

                    //$update_task_result = null;//$paperweight->query($update_task);
                    $update_task_result = $paperweight->query($update_task);
                    if($update_task_result != null && $update_task_result->is_row_affected()){

                        //$task_id = $add_task_result->insert_id();

                        $location_detail["task_ref_id"] = $task_ref_id;
                        $location_detail["task_id"] = $task_id;
                        $location_detail["user_id"] = $user_id;
                        $location_detail["cpq"] = $payout_per_response;
                        $location_detail["activity_type"] = $activity_type;
                        $location_detail["tag_effort"] = $tag_effort;


                        updateLocationDetail($location_detail,$paperweight);

                        $result["status"] = STATUS_OK;
                        $result["task_id"] = $task_id;

                    }

                }

            }

            echo json_export($result);
            //echo json_encode($add_task);

        }



        //Todo : ADD USER CHECK
        // ** COMPLETED **
        if ($action == "get_quest"){
            $data = json_decode($param_json, true);
            //$json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            //$data = $_REQUEST;

            //$user_id = text_clean($json_input["user_id"]);
            $task_id = text_clean($data["task_id"]);

            $result = array();
            $result["status"] = STATUS_ERROR;

            /*
            $test = '{
                "interface": "quest_create",
                
                "activity_type": "activity_sentiment",
                "task_topic": "Sample Test",
                "task_time_day": "1",
                "task_question_type": "2",
                "task_question_count": "10",
                "tag_effort": "300",
                "task_respondent_count": "10",
                "task_location_count": "1",
                "task_start_date": "2020-12-15T18:54",
                "task_due_date": "2021-01-01T18:54",
                "payout_per_response": "2",
                "payout_total": "20.00",
                "usage_fee": "2.20",
                "processing_fee": "3",
                "task_budget": "25.20",
                "task_instructions": "This is a test",
                "survey_url": "https://insight.queritel.com/index.php/715123?lang=en",
                "completion_url": "https://queritel.com/",
                "location_detail": "{"location_count":1,"location_list":[{"country":"Chile","country_code":"CL","state":"Región Metropolitana","address":"Libertad 32, Santiago, Región Metropolitana, Chile","lat":-33.4475005,"lng":-70.67362539999999,"researchers":0,"responses":0,"local_id":"location_1","unique_id":"","job_tags":[{"unique_id":"","tag_label":"tag_gender","tag_data":{"male":30,"female":"70"}},{"unique_id":"","tag_label":"tag_age","tag_data":{"min":16,"max":100}},{"unique_id":"","tag_label":"tag_radius","tag_data":{"value":500}}]}]}",
                "term_cond": "1",
                "action": "create",
                "param_json": "{"user_id":"125"}"
                }';
            */

            //task_id, task_ref_id, task_user_id, creator_net_id, task_writer_id, task_ready_for_review, task_status, task_paptype_id,
            //task_topic, task_pages, task_words_per_page, task_budget, task_due_date, task_discipline_id, task_service_type,
            //task_citstyle_id, task_instructions, task_file_id, task_posted_on, task_completed_on,
            //task_completion_date_writer, autodebit_on, task_type, task_cancel_request, task_desc_cancel_req,
            //task_review_request_status, task_revise_request_date, task_review_description, task_country_id,
            //task_state_id, task_city_id, task_county, task_parish, task_expertise_industry,
            //task_research_area, task_insight_service, task_respondent_count, task_question_count,
            //task_location_count, task_question_help_state, task_analysis_help_state, survey_id, survey_url,
            //completion_url, survey_ready, task_time_day, task_question_type, my_network, network_id,
            //task_activity, task_start_date, handle_payment

            $quest_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
            $quest_result = $paperweight->query($quest_query);
            //if ($quest_result != null) {
            if ($quest_result != null && $quest_result->is_row_found()) {
                $row = $quest_result->fetch_array();

                $result["status"] = "OK";

                $result["activity_type"] = $row["task_activity"];
                $result["quest_state"] = $row["task_status"];
                $result["task_topic"] = $row["task_topic"];
                $result["task_time_day"] = $row["task_time_day"];
                $result["task_question_type"] = $row["task_question_type"];
                $result["task_question_count"] = $row["task_question_count"];
                $result["task_respondent_count"] = $row["task_respondent_count"];

                $result["response_limit"] = $row["response_limit"];

                $result["my_team"] = $row["my_network"];
                $result["handle_payment"] = $row["handle_payment"];

                $result["task_location_count"] = $row["task_location_count"];

                $result["task_start_date"] = $row["task_start_date"];
                $result["task_due_date"] = $row["task_due_date"];

                //workforce_timezone,workforce_country
                $result["workforce_timezone"] = $row["workforce_timezone"];
                $result["workforce_country"] = $row["workforce_country"];

                $result["task_budget"] = $row["task_budget"];
                $result["task_instructions"] = $row["task_instructions"];
                $result["survey_url"] = $row["survey_url"];
                //$result["completion_url"] = $row["completion_url"];
                $result["completion_url"] = "https://api.queritel.com/api/mobile/queritel/insight/completion/trigger.html";

                $result["payout_per_response"] = 0;
                $cpq = getPayPerResponse($task_id,$paperweight);
                if ($cpq["status"] == "OK"){
                    $result["payout_per_response"] = $cpq["cpq"];
                }

                $result["tag_effort"] = 300;
                $effort = getTagEffort($task_id,$paperweight);
                if ($effort["status"] == "OK"){
                    $result["tag_effort"] = $effort["level"];
                }

                $result["location_detail"] = array();
                $loc_detail = getLocationDetail($task_id,$paperweight);
                if ($loc_detail["status"] == "OK"){
                    $result["location_detail"] = $loc_detail["result"];
                    //$result["location_detail"] = array();
                }

                //$result["payout_total"] = $row[""];
                //$result["usage_fee"] = $row[""];
                //$result["processing_fee"] = $row[""];
                //$result["status"] = "";
                //$result["status"] = "";

            }

            echo json_export($result);
            //echo json_encode($result,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
        }

        if ($action == "create_official"){

            $json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            //$data = $_REQUEST;
            $data = $_REQUEST;
            //$data[""] = $_REQUEST[""];


            $activity_type = text_clean($data["activity_type"]);

            $default_service_type = 3; //task_service_type = 3 [Face to Face]
            //$default_network = getDefaultNetworkId();
            $default_network = null;
            $default_task_status = TASK_STATUS_PENDING;
            //$default_task_status = TASK_STATUS_PENDING;
            $default_admin_approval = 0;
            $default_survey_ready = 1;


            if ($activity_type == ACTIVITY_TYPE_SENTIMENT){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);
                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);
                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);


                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }


                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment')";


                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $query_new_task = "select * from " . TABLE_TASKS . " where task_ref_id = '$task_ref_id'";
                    $query_new_task_result = $paperweight->query($query_new_task);

                    if ($query_new_task_result != null)
                    {
                        $row = $query_new_task_result->fetch_array();
                        if ($row != null)
                        {
                            $task_id = $row["task_id"];

                            $location_detail["task_ref_id"] = $task_ref_id;
                            $location_detail["task_id"] = $task_id;
                            $location_detail["user_id"] = $user_id;
                            $location_detail["cpq"] = $payout_per_response;
                            $location_detail["activity_type"] = $activity_type;
                            addLocationDetail($location_detail,$paperweight);

                        }
                    }

                }

            }
            else if ($activity_type == ACTIVITY_TYPE_DISCOVERY){

            }
            else if ($activity_type == ACTIVITY_TYPE_RETAIL){

            }


            //echo ($data);
            echo json_encode($data);
            //echo ($data);

        }

        if ($action == "__update__"){

            $json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            //$data = $_REQUEST;
            $data = $_REQUEST;
            //$data[""] = $_REQUEST[""];


            $activity_type = text_clean($data["activity_type"]);

            $default_service_type = 3; //task_service_type = 3 [Face to Face]
            //$default_network = getDefaultNetworkId();
            $default_network = null;
            $default_task_status = TASK_STATUS_PENDING;
            //$default_task_status = TASK_STATUS_PENDING;
            $default_admin_approval = 0;
            $default_survey_ready = 1;


            if ($activity_type == ACTIVITY_TYPE_SENTIMENT){

                //user provided
                $my_team = (isset($data["my_team"]) && $data["my_team"] == "1")  ? 1 : 0;
                $handle_payment = (isset($data["handle_payment"]) && $data["handle_payment"] == "1")  ? 1 : 0;
                $project_name = text_clean($data["task_topic"]);
                $time_day = text_clean($data["task_time_day"]);
                $question_type = text_clean($data["task_question_type"]);
                $question_count = text_clean($data["task_question_count"]);
                $tag_effort = text_clean($data["tag_effort"]);//TODO - apply here
                $respondent_count = text_clean($data["task_respondent_count"]);
                $location_count = text_clean($data["task_location_count"]);
                $start_date = text_clean($data["task_start_date"]);
                $due_date = text_clean($data["task_due_date"]);
                $payout_per_response = text_clean($data["payout_per_response"]);
                $payout_total = text_clean($data["payout_total"]);
                $usage_fee = text_clean($data["usage_fee"]);
                $processing_fee = text_clean($data["processing_fee"]);
                $task_budget = text_clean($data["task_budget"]);//total cost including payout
                $project_instruction = text_clean($data["task_instructions"]);//total cost including payout
                $survey_url = text_clean($data["survey_url"]);//total cost including payout
                $completion_url = text_clean($data["completion_url"]);//total cost including payout

                $location_detail = json_decode($data["location_detail"], true);


                //default
                $user_id = text_clean($json_input["user_id"]);
                $creator_net_rel = getNetworkRelationship($user_id,$paperweight);
                $creator_net_id = null;

                if ($creator_net_rel["status"] == "OK"){
                    $creator_net_id = $creator_net_rel["network_id"];
                }


                $task_ref_id = generateNumericId();
                $task_status = $default_task_status;
                $service_type = $default_service_type;
                $posted_on = getCurrentTime();
                $survey_ready = $default_survey_ready;
                $network_id = $default_network;


                //insert into task table
                $add_task = "insert into " . TABLE_TASKS .
                    " (task_ref_id,task_user_id,creator_net_id,task_status,task_topic,task_budget,task_due_date,task_service_type,task_instructions,task_posted_on,task_respondent_count,task_question_count,task_location_count,survey_url,completion_url,survey_ready,task_time_day,task_question_type,my_network,network_id,task_activity,task_start_date,handle_payment) 
                    values ('$task_ref_id','$user_id','$creator_net_id','$task_status','$project_name','$task_budget','$due_date','$service_type','$project_instruction','$posted_on','$respondent_count','$question_count','$location_count','$survey_url','$completion_url','$survey_ready','$time_day','$question_type','$my_team','$network_id','$activity_type','$start_date','$handle_payment')";


                //$add_task_result = null;//$paperweight->query($add_task);
                $add_task_result = $paperweight->query($add_task);
                if($add_task_result != null && $add_task_result->is_row_affected()){

                    $query_new_task = "select * from " . TABLE_TASKS . " where task_ref_id = '$task_ref_id'";
                    $query_new_task_result = $paperweight->query($query_new_task);

                    if ($query_new_task_result != null)
                    {
                        $row = $query_new_task_result->fetch_array();
                        if ($row != null)
                        {
                            $task_id = $row["task_id"];

                            $location_detail["task_ref_id"] = $task_ref_id;
                            $location_detail["task_id"] = $task_id;
                            $location_detail["user_id"] = $user_id;
                            $location_detail["cpq"] = $payout_per_response;
                            $location_detail["activity_type"] = $activity_type;
                            addLocationDetail($location_detail,$paperweight);

                        }
                    }

                }

            }
            else if ($activity_type == ACTIVITY_TYPE_DISCOVERY){

            }
            else if ($activity_type == ACTIVITY_TYPE_RETAIL){

            }


            //echo ($data);
            echo json_encode($data);
            //echo ($data);

        }

        if ($action == "create__"){

            //$data = json_decode($param_json, true);
            $data = $_REQUEST;
            //$data[""] = $_REQUEST[""];

            /*$screen_name = stringCase(text_clean($data["user_screen_name"]));
            $email = stringCase(text_clean($data["user_email"]));
            $password = encryptPassword(text_clean($data["user_password"]));
            $first_name = stringCase(text_clean($data["user_first_name"]));
            $last_name = stringCase(text_clean($data["user_last_name"]));
            $gender = text_clean($data["user_sex"]);
            $mobile = text_clean($data["user_mobile"]);
            $country_id = text_clean($data["user_country_id"]);
            $state_id = text_clean($data["user_state_id"]);
            $city_id = text_clean($data["user_city_id"]);
            $zip = text_clean($data["user_zip"]);
            $county = text_clean($data["user_county"]);
            $parish = text_clean($data["user_parish"]);
            $is_experienced = text_clean($data["user_is_experienced"]);
            //$more_cv_data = text_clean($data["user_more_cv_data"]);
            $user_assistance_company = "";//text_clean($data["user_is_experienced"]);
            $user_deg_id = 0;//text_clean($data["user_is_experienced"]);

            $user_type = USER_TYPE_RESEARCHER;
            $user_active = STATE_ACTIVE;
            $user_is_approved = VERIFIED;
            $email_is_verified = VERIFIED;//todo : remove auto email verification
            $user_regdate = getCurrentTime();
            $user_ref_id = generateUserReferenceId();*/

            echo json_encode($data);

        }

        if ($action == ""){
            $data = json_decode($param_json, true);
            //$user_id = text_clean($data["user_id"]);

            $_format = '{
            "status": "OK",
            "team_list": [
                {
                    "user_id": "121",
                    "user_ref_id": "146902",
                    "user_name": "Kadan Salmon",
                    "user_type": 0,
                    "user_email": "kadan_salmon@yahoo.com",
                    "reg_date": "2019-05-27 10:20:34",
                    "net_state": 1,
                    "score": "0.0",
                    "quest_completed": 0,
                    "quest_active": 0
                }
            ]
        }';

            $out = json_decode($_format, true);

            echo json_encode($out);
        }

        if ($action == 'delete_draft')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);

            //TODO - API - LOG
            debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

            $result = array();
            $result["status"] = "ERROR";


            /*$date_updated = updateDueDate($extension);

            if (!empty($date_updated))
            {
                $result["status"] = "OK";
                $result["response"] = $date_updated;

            }*/


            echo json_export($result);
        }
    }

    // ** IN PROGRESS **
    if ($interface == "quest_view"){
        if ($action == "view"){
            $data = json_decode($param_json, true);
            //$json_input = json_decode($param_json, true);
            //$data = $_REQUEST["location_detail"];
            //$data = $_REQUEST;

            //$user_id = text_clean($json_input["user_id"]);
            $task_id = text_clean($data["task_id"]);

            $result = array();
            $result["status"] = STATUS_ERROR;

            /*
            $test = '{
                "interface": "quest_create",

                "activity_type": "activity_sentiment",
                "task_topic": "Sample Test",
                "task_time_day": "1",
                "task_question_type": "2",
                "task_question_count": "10",
                "tag_effort": "300",
                "task_respondent_count": "10",
                "task_location_count": "1",
                "task_start_date": "2020-12-15T18:54",
                "task_due_date": "2021-01-01T18:54",
                "payout_per_response": "2",
                "payout_total": "20.00",
                "usage_fee": "2.20",
                "processing_fee": "3",
                "task_budget": "25.20",
                "task_instructions": "This is a test",
                "survey_url": "https://insight.queritel.com/index.php/715123?lang=en",
                "completion_url": "https://queritel.com/",
                "location_detail": "{"location_count":1,"location_list":[{"country":"Chile","country_code":"CL","state":"Región Metropolitana","address":"Libertad 32, Santiago, Región Metropolitana, Chile","lat":-33.4475005,"lng":-70.67362539999999,"researchers":0,"responses":0,"local_id":"location_1","unique_id":"","job_tags":[{"unique_id":"","tag_label":"tag_gender","tag_data":{"male":30,"female":"70"}},{"unique_id":"","tag_label":"tag_age","tag_data":{"min":16,"max":100}},{"unique_id":"","tag_label":"tag_radius","tag_data":{"value":500}}]}]}",
                "term_cond": "1",
                "action": "create",
                "param_json": "{"user_id":"125"}"
                }';
            */

            //task_id, task_ref_id, task_user_id, creator_net_id, task_writer_id, task_ready_for_review, task_status, task_paptype_id,
            //task_topic, task_pages, task_words_per_page, task_budget, task_due_date, task_discipline_id, task_service_type,
            //task_citstyle_id, task_instructions, task_file_id, task_posted_on, task_completed_on,
            //task_completion_date_writer, autodebit_on, task_type, task_cancel_request, task_desc_cancel_req,
            //task_review_request_status, task_revise_request_date, task_review_description, task_country_id,
            //task_state_id, task_city_id, task_county, task_parish, task_expertise_industry,
            //task_research_area, task_insight_service, task_respondent_count, task_question_count,
            //task_location_count, task_question_help_state, task_analysis_help_state, survey_id, survey_url,
            //completion_url, survey_ready, task_time_day, task_question_type, my_network, network_id,
            //task_activity, task_start_date, handle_payment

            $quest_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
            $quest_result = $paperweight->query($quest_query);
            if ($quest_result != null) {
                $row = $quest_result->fetch_array();

                $result["status"] = "OK";

                $result["activity_type"] = $row["task_activity"];
                $result["quest_state"] = $row["task_status"];
                $result["task_topic"] = $row["task_topic"];
                $result["task_time_day"] = $row["task_time_day"];
                $result["task_question_type"] = $row["task_question_type"];
                $result["task_question_count"] = $row["task_question_count"];
                $result["task_respondent_count"] = $row["task_respondent_count"];

                $result["my_team"] = $row["my_network"];
                $result["handle_payment"] = $row["handle_payment"];

                $result["task_location_count"] = $row["task_location_count"];

                $result["task_start_date"] = $row["task_start_date"];
                $result["task_due_date"] = $row["task_due_date"];


                $result["workforce_country"] = $row["workforce_country"];
                $result["workforce_timezone"] = $row["workforce_timezone"];

                $result["task_budget"] = $row["task_budget"];
                $result["task_instructions"] = $row["task_instructions"];
                $result["survey_url"] = $row["survey_url"];
                $result["completion_url"] = $row["completion_url"];

                $result["payout_per_response"] = 0;
                $cpq = getPayPerResponse($task_id,$paperweight);
                if ($cpq["status"] == "OK"){
                    $result["payout_per_response"] = $cpq["cpq"];
                }

                $result["tag_effort"] = 300;
                $effort = getTagEffort($task_id,$paperweight);
                if ($effort["status"] == "OK"){
                    $result["tag_effort"] = $effort["level"];
                }

                /*
                $result["location_detail"] = array();
                $loc_detail = getLocationDetail($task_id,$paperweight);
                if ($loc_detail["status"] == "OK"){
                    $result["location_detail"] = $loc_detail["result"];
                }*/

                //$result["payout_total"] = $row[""];
                //$result["usage_fee"] = $row[""];
                //$result["processing_fee"] = $row[""];
                //$result["status"] = "";
                //$result["status"] = "";

            }

            echo json_export($result);
        }
        if ($action == 'view_locations')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);

            $index = 0;

            $result = array();
            $result["status"] = "NO_DATA";
            $location_data = array();
            $record_found = false;

            $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $location_result = $paperweight->query($location_query);

            if ($location_result != null)
            {
                while ($row = $location_result->fetch_array())
                {
                    $record_found = true;
                    $result["status"] = "OK";

                    $job_id = $row["job_id"];
                    $address = $row["address"];
                    $location_state = $row["state"];
                    $country = $row["country"];
                    $country_iso = $row["country_code"];
                    $lat = $row["location_lat"];
                    $lng = $row["location_lon"];
                    $response_total = $row["survey_total"];
                    $collector_total = $row["researcher_required"];
                    $collector_count = $row["researcher_count"];

                    $progress = getLocationProgress($job_id, $paperweight);
                    $job_tags = getJobTags($job_id,$paperweight);

                    //the number of actually completed questionnaires
                    $response_count = $progress["combined_total"];

                    $location_data[$index]["location_id"] = $job_id;
                    $location_data[$index]["location"] = $address;
                    $location_data[$index]["location_state"] = $location_state;
                    $location_data[$index]["lat"] = $lat;
                    $location_data[$index]["lng"] = $lng;
                    $location_data[$index]["country"] = $country;
                    $location_data[$index]["country_iso"] = $country_iso;
                    $location_data[$index]["response_total"] = $response_total;
                    $location_data[$index]["response_count"] = $response_count;

                    $location_data[$index]["collector_total"] = $collector_total;
                    $location_data[$index]["collector_count"] = $collector_count;

                    $location_data[$index]["progress"] = $progress["progress"];
                    $location_data[$index]["job_tags"] = $job_tags;

                    $index++;
                }

            }

            if ($record_found)
            {
                $result["status"] = "OK";

                $location_list = $location_data;

                $result["location_list"] = $location_list;

            }


            echo json_export($result);
        }


        //todo - add security
        if ($action == 'extend_date')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);
            $extension = text_clean($data["extension"]);

            //TODO - API - LOG
            //debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

            $result = array();
            $result["status"] = "ERROR";


            $date_updated = updateDueDate($task_id,$extension,$paperweight);

            if ($date_updated)
            {
                $result["status"] = "OK";

                //$result["response"] = $date_updated;

            }


            echo json_export($result);
        }

        if ($action == 'update_end_date')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);
            $new_date_utc = text_clean($data["new_date"]);

            //TODO - API - LOG
            //debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

            $result = array();
            //$result["status"] = "ERROR";
            $result["status"] = "OK";
            $result["echo"] = $new_date_utc;

            /*$date_updated = updateDueDate($task_id,$extension,$paperweight);

            if ($date_updated)
            {
                $result["status"] = "OK";

                //$result["response"] = $date_updated;

            }*/


            echo json_export($result);
        }

        if ($action == 'mark_quest_completed')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);

            //TODO - API - LOG
            debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

            $result = array();
            $result["status"] = "ERROR";


            $sql_query = "update " . TABLE_TASKS . " set `task_status` = '". TASK_STATUS_COMPLETED ."' where `task_id` = '$task_id'";
            $sql_query_result = $paperweight->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){
                $result["status"] = "OK";
            }

            echo json_export($result);
        }

        if ($action == 'cancel_quest')
        {
            $data = json_decode($param_json, true);

            $task_id = text_clean($data["task_id"]);
            $user_id = text_clean($data["user_id"]);

            //TODO - API - LOG
            //debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

            $result = array();
            $result["status"] = "ERROR";

            //TABLE_TASKS


            $sql_query = "update " . TABLE_TASKS . " set `task_status` = '". TASK_STATUS_CANCELLED ."' where `task_id` = '$task_id'";
            $sql_query_result = $paperweight->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){
                $result["status"] = "OK";
            }


            echo json_export($result);
        }


        if ($action == '') {
            $data = json_decode($param_json, true);

            /*if (count($list) > 0) {
                for ($i = 0;$i < count($list);$i++) {
                    if ($list[$i]["filter_criteria"] == "2623641843") {
                        if ($list[$i]["filter_state"] == "inc") {
                            $sample = '{
                            "status": "OK",
                            "location_list": [
                                {
                                    "location_id": "100275",
                                    "lat": 18.493093,
                                    "lng": -77.658104,
                                    "location": "Albert Street, Falmouth, Jamaica",
                                    "order_ref_id": "2623641843",
                                    "country": "Jamaica",
                                    "country_iso": "JM",
                                    "collector_total": 4,
                                    "collector_count": 1,
                                    "response_total": 40,
                                    "response_count": 1,
                                    "progress": [
                                        {
                                            "user_id": "26",
                                            "user_ref_id": "664801",
                                            "fname": "Tracy-Ann",
                                            "lname": "Wiltshire",
                                            "response_total": 10,
                                            "response_count": 1
                                        }
                                    ]
                                },
                                {
                                    "location_id": "108086",
                                    "lat": 18.006166,
                                    "lng": -76.812691,
                                    "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                    "order_ref_id": "2623641843",
                                    "country": "Jamaica",
                                    "country_iso": "JM",
                                    "collector_total": 4,
                                    "collector_count": 1,
                                    "response_total": 40,
                                    "response_count": 1,
                                    "progress": [
                                        {
                                            "user_id": "28",
                                            "user_ref_id": "223340",
                                            "fname": "Colleen",
                                            "lname": "Williams",
                                            "response_total": 10,
                                            "response_count": 1
                                        }
                                    ]
                                }
                            ]
                        }';
                        }
                        if ($list[$i]["filter_state"] == "exc") {
                            $sample = '{
                            "status": "OK",
                            "location_list": [
                                {
                                    "location_id": "131418",
                                    "lat": -33.417751,
                                    "lng": -70.606346,
                                    "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                    "order_ref_id": "1080041606",
                                    "country": "Chile",
                                    "country_iso": "CL",
                                    "collector_total": 4,
                                    "collector_count": 0,
                                    "response_total": 40,
                                    "response_count": 0,
                                    "progress": []
                                }
                            ]
                        }';
                        }
                    }
                    if ($list[$i]["filter_criteria"] == "1080041606") {
                        if ($list[$i]["filter_state"] == "inc") {
                            $sample = '{
                            "status": "OK",
                            "location_list": [
                                {
                                    "location_id": "131418",
                                    "lat": -33.417751,
                                    "lng": -70.606346,
                                    "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                    "order_ref_id": "1080041606",
                                    "country": "Chile",
                                    "country_iso": "CL",
                                    "collector_total": 4,
                                    "collector_count": 0,
                                    "response_total": 40,
                                    "response_count": 0,
                                    "progress": []
                                }
                            ]
                        }';
                        }
                        if ($list[$i]["filter_state"] == "exc") {
                            $sample = '{
                            "status": "OK",
                            "location_list": [
                                {
                                    "location_id": "100275",
                                    "lat": 18.493093,
                                    "lng": -77.658104,
                                    "location": "Albert Street, Falmouth, Jamaica",
                                    "order_ref_id": "2623641843",
                                    "country": "Jamaica",
                                    "country_iso": "JM",
                                    "collector_total": 4,
                                    "collector_count": 1,
                                    "response_total": 40,
                                    "response_count": 1,
                                    "progress": [
                                        {
                                            "user_id": "26",
                                            "user_ref_id": "664801",
                                            "fname": "Tracy-Ann",
                                            "lname": "Wiltshire",
                                            "response_total": 10,
                                            "response_count": 1
                                        }
                                    ]
                                },
                                {
                                    "location_id": "108086",
                                    "lat": 18.006166,
                                    "lng": -76.812691,
                                    "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                    "order_ref_id": "2623641843",
                                    "country": "Jamaica",
                                    "country_iso": "JM",
                                    "collector_total": 4,
                                    "collector_count": 1,
                                    "response_total": 40,
                                    "response_count": 1,
                                    "progress": [
                                        {
                                            "user_id": "28",
                                            "user_ref_id": "223340",
                                            "fname": "Colleen",
                                            "lname": "Williams",
                                            "response_total": 10,
                                            "response_count": 1
                                        }
                                    ]
                                }
                            ]
                        }';
                        }
                    }
                }
            }*/
            //filter_type
            //filter_state
            //filter_criteria
            //filter_list
            //{lat: 18.222, lng: -77.222},
            //{lat: 18.459, lng: -77.459},

            $result["status"] = "NO_DATA";

            $task_data = array();
            $index = 0;
            $record_found = false;

            $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
            $task_result = $paperweight->query($task_query);

            if ($task_result != null)
            {
                while ($row = $task_result->fetch_array())
                {
                    $record_found = true;

                    $task_id = $row["task_id"];
                    $order_ref_id = $row["task_ref_id"];
                    $project_name = $row["task_topic"];
                    $project_detail = $row["task_instructions"];
                    $location_count = $row["task_location_count"];
                    $question_count = $row["task_question_count"];
                    $job_list = array();

                    $job_list_data = getJobList($task_id,$paperweight);

                    if ($job_list_data["status"] == "OK"){
                        $job_list = $job_list_data["result"];
                    }


                    $task_data[$index]["task_id"] = $task_id;
                    $task_data[$index]["order_ref_id"] = $order_ref_id;
                    $task_data[$index]["project_name"] = $project_name;
                    $task_data[$index]["project_detail"] = $project_detail;
                    $task_data[$index]["location_count"] = $location_count;
                    $task_data[$index]["question_count"] = $question_count;
                    $task_data[$index]["job_list"] = $job_list;

                    $index++;

                }
            }

            if ($record_found)
            {
                $result["status"] = "OK";

                $location_list = extractActiveLocationList($task_data);

                $result["location_list"] = $location_list;

            }

            //$data = json_decode($sample, true);
            //echo json_encode($list[0]["filter_criteria"]);
            echo json_encode($result);
        }

    }

    // ** IN PROGRESS **
    /*if ($interface == "dashboard"){

        if ($action == "general_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 123,
                    "quest_ref_id": "8375530253",
                    "quest_name": "Corner Store Checkup",
                    "quest_type": "Location Discovery",
                    "quest_status": 0
                },
                {
                    "quest_id": 221,
                    "quest_ref_id": "2845710682",
                    "quest_name": "Wholesale Mapping",
                    "quest_type": "Location Discovery",
                    "quest_status": 5
                }
            ]
        }';

            $out = json_decode($_format, true);

            echo json_encode($out);
        }

        if ($action == "active_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 100,
                    "quest_ref_id": "3759285638",
                    "quest_name": "Profitability of Jamaican CDB oil",
                    "quest_type": "Location Discovery",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 20
                },
                {
                    "quest_id": 101,
                    "quest_ref_id": "4620948382",
                    "quest_name": "Rum Data Collection PM",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 60
                },
                {
                    "quest_id": 201,
                    "quest_ref_id": "2956386501",
                    "quest_name": "Questionnaire Design for Rum Brand Survey",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 80
                }
            ]
        }';

            $out = json_decode($_format, true);

            echo json_encode($out);
        }

        if ($action == "completed_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 231,
                    "quest_ref_id": "1967350385",
                    "quest_name": "Google Earth Log",
                    "quest_type": "Location Discovery",
                    "quest_status": 3,
                    "response_total": 100,
                    "response_count": 100
                },
                {
                    "quest_id": 101,
                    "quest_ref_id": "20486723928",
                    "quest_name": "Mystery Shopping",
                    "quest_type": "Retail Audit",
                    "quest_status": 3,
                    "response_total": 100,
                    "response_count": 100
                }
            ]
        }';

            $out = json_decode($_format, true);

            echo json_encode($out);
        }
    }*/

    // ** COMPLETED **
    if ($interface == "my_orders"){

        // ** COMPLETED **
        if ($action == "general_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $record_found = false;
            $result = array();
            $task_data = array();
            $result["status"] = "NO_DATA";
            $index = 0;

            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }
            else{
                echo json_encode($result);
                return;
            }


            $quest_query = "select * from " . TABLE_TASKS . " where creator_net_id = '$network_id' and task_service_type = 3 and task_type = 0 and task_status in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_DRAFT . ")";
            $quest_result = $paperweight->query($quest_query);
            if ($quest_result != null){
                while ($row = $quest_result->fetch_array()){
                    $record_found = true;

                    $quest_activity = $row["task_activity"];
                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        $quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        $quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        $quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        $quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                    }
                    else{
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }

                    $task_data[$index]["quest_id"] = $row["task_id"];
                    $task_data[$index]["quest_ref_id"] = $row["task_ref_id"];
                    $task_data[$index]["quest_name"] = $row["task_topic"];
                    $task_data[$index]["quest_type"] = $quest_type;
                    $task_data[$index]["quest_status"] = intval($row["task_status"]);
                    $task_data[$index]["date_modified"] = $row["task_posted_on"];

                    $index++;
                }
            }

            if ($record_found)
            {
                $result["status"] = "OK";
                $result["quest_list"] = $task_data;
            }

            echo json_encode($result);
        }

        // ** COMPLETED **
        if ($action == "active_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $record_found = false;
            $result = array();
            $task_data = array();
            $result["status"] = "NO_DATA";
            $index = 0;


            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }
            else{
                echo json_encode($result);
                return;
            }


            $quest_query = "select * from " . TABLE_TASKS . " where creator_net_id = '$network_id' and task_service_type = 3 and task_type = 0 and task_status in (" . TASK_STATUS_ACTIVE . "," . TASK_STATUS_AWARDED . ")";
            $quest_result = $paperweight->query($quest_query);
            if ($quest_result != null){
                while ($row = $quest_result->fetch_array()){
                    $record_found = true;

                    $quest_activity = $row["task_activity"];
                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        $quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        $quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        $quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        $quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                    }
                    else{
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }

                    $stat = $row["task_status"];
                    if ($stat == TASK_STATUS_AWARDED){
                        $stat = TASK_STATUS_ACTIVE;
                    }

                    $task_id = $row["task_id"];

                    $task_data[$index]["quest_id"] = $task_id;
                    $task_data[$index]["quest_ref_id"] = $row["task_ref_id"];
                    $task_data[$index]["quest_name"] = $row["task_topic"];
                    $task_data[$index]["quest_type"] = $quest_type;
                    $task_data[$index]["quest_status"] = intval($stat);
                    $task_data[$index]["date_modified"] = $row["task_posted_on"];

                    $total_response_total = 0;
                    $total_response_count = 0;

                    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
                    $location_result = $paperweight->query($location_query);
                    if ($location_result != null)
                    {

                        while ($rec = $location_result->fetch_array())
                        {

                            $job_id = $rec["job_id"];
                            $response_total = $rec["survey_total"];
                            $progress = getLocationProgress($job_id, $paperweight);

                            //the number of actually completed questionnaires
                            $response_count = $progress["combined_total"];

                            $total_response_total += $response_total;
                            $total_response_count += $response_count;

                        }

                    }

                    $task_data[$index]["response_total"] = intval($total_response_total);
                    $task_data[$index]["response_count"] = intval($total_response_count);

                    $index++;
                }
            }

            if ($record_found)
            {
                $result["status"] = "OK";
                $result["quest_list"] = $task_data;
            }

            /*$_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 123,
                    "quest_ref_id": "3759285638",
                    "quest_name": "Profitability of Jamaican CDB oil",
                    "quest_type": "Location Discovery",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 20
                },
                {
                    "quest_id": 124,
                    "quest_ref_id": "4620948382",
                    "quest_name": "Rum Data Collection PM",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 60
                },
                {
                    "quest_id": 125,
                    "quest_ref_id": "2956386501",
                    "quest_name": "Questionnaire Design for Rum Brand Survey",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 1,
                    "response_total": 100,
                    "response_count": 80
                }
            ]
            }';*/

            //$out = json_decode($_format, true);

            echo json_encode($result);
        }

        // ** COMPLETED **
        if ($action == "completed_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);

            $record_found = false;
            $result = array();
            $task_data = array();
            $result["status"] = "NO_DATA";
            $index = 0;


            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }
            else{
                echo json_encode($result);
                return;
            }


            $quest_query = "select * from " . TABLE_TASKS . " where creator_net_id = '$network_id' and task_service_type = 3 and task_type = 0 and task_status in (" . TASK_STATUS_COMPLETED . ")";
            $quest_result = $paperweight->query($quest_query);
            if ($quest_result != null){
                while ($row = $quest_result->fetch_array()){
                    $record_found = true;

                    $quest_activity = $row["task_activity"];
                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        $quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        $quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        $quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        $quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                    }
                    else{
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }

                    $stat = $row["task_status"];
                    if ($stat == TASK_STATUS_AWARDED){
                        $stat = TASK_STATUS_ACTIVE;
                    }

                    $task_id = $row["task_id"];

                    $task_data[$index]["quest_id"] = $task_id;
                    $task_data[$index]["quest_ref_id"] = $row["task_ref_id"];
                    $task_data[$index]["quest_name"] = $row["task_topic"];
                    $task_data[$index]["quest_type"] = $quest_type;
                    $task_data[$index]["quest_status"] = intval($stat);
                    $task_data[$index]["date_completed"] = $row["task_completed_on"];

                    $total_response_total = 0;
                    $total_response_count = 0;

                    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
                    $location_result = $paperweight->query($location_query);
                    if ($location_result != null)
                    {

                        while ($rec = $location_result->fetch_array())
                        {

                            $job_id = $rec["job_id"];
                            $response_total = $rec["survey_total"];
                            $progress = getLocationProgress($job_id, $paperweight);

                            //the number of actually completed questionnaires
                            $response_count = $progress["combined_total"];

                            $total_response_total += $response_total;
                            $total_response_count += $response_count;

                        }

                    }

                    $task_data[$index]["response_total"] = intval($total_response_total);
                    $task_data[$index]["response_count"] = intval($total_response_count);

                    $index++;
                }
            }

            if ($record_found)
            {
                $result["status"] = "OK";
                $result["quest_list"] = $task_data;
            }

            /*$_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 123,
                    "quest_ref_id": "1967350385",
                    "quest_name": "Corner Store Registration",
                    "quest_type": "Location Discovery",
                    "quest_status": 3,
                    "response_total": 100,
                    "response_count": 100,
                    "date_completed":"2020-09-21 08:09:04"
                },
                {
                    "quest_id": 201,
                    "quest_ref_id": "1886723927",
                    "quest_name": "Mystery Shopping",
                    "quest_type": "Retail Audit",
                    "quest_status": 3,
                    "response_total": 100,
                    "response_count": 100,
                    "date_completed":"2020-09-21 08:09:04"
                }
            ]
            }';*/

            //$out = json_decode($_format, true);

            echo json_encode($result);
        }

        // ** COMPLETED **
        if ($action == "cancelled_quest_list"){
            $data = json_decode($param_json, true);
            $user_id = text_clean($data["user_id"]);


            /*$_format = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_id": 123,
                    "quest_ref_id": "1967350385",
                    "quest_name": "Google Earth Log",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 4,
                    "date_modified":"2020-09-21 08:09:04"
                },
                {
                    "quest_id": 201,
                    "quest_ref_id": "2623641843",
                    "quest_name": "Mystery Shopping BK",
                    "quest_type": "Retail Audit",
                    "quest_status": 4,
                    "date_modified":"2020-09-21 08:09:04"
                }
                ]
            }';*/

            $record_found = false;
            $result = array();
            $task_data = array();
            $result["status"] = "NO_DATA";
            $index = 0;


            $network_data = getNetworkRelationship($user_id,$paperweight);
            $network_id = '';

            if ($network_data["status"] == "OK"){
                $network_id = $network_data["network_id"];
            }
            else{
                echo json_encode($result);
                return;
            }

            $quest_query = "select * from " . TABLE_TASKS . " where creator_net_id = '$network_id' and task_service_type = 3 and task_type = 0 and task_status in (" . TASK_STATUS_CANCELLED . ")";
            $quest_result = $paperweight->query($quest_query);
            if ($quest_result != null){
                while ($row = $quest_result->fetch_array()){
                    $record_found = true;

                    $quest_activity = $row["task_activity"];
                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        $quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        $quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        $quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        $quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                    }
                    else{
                        $quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                    }

                    $task_data[$index]["quest_id"] = $row["task_id"];
                    $task_data[$index]["quest_ref_id"] = $row["task_ref_id"];
                    $task_data[$index]["quest_name"] = $row["task_topic"];
                    $task_data[$index]["quest_type"] = $quest_type;
                    $task_data[$index]["quest_status"] = intval($row["task_status"]);
                    $task_data[$index]["date_modified"] = $row["task_posted_on"];

                    $index++;

                }
            }

            if ($record_found)
            {
                $result["status"] = "OK";
                $result["quest_list"] = $task_data;
            }

            echo json_encode($result);

        }


    }

    // ** TEMPLATE **
    if ($interface == ""){
        if ($action == ""){
            $data = json_decode($param_json, true);
            //$user_id = text_clean($data["user_id"]);

            $_format = '{
            "status": "OK",
            "team_list": [
                {
                    "user_id": "121",
                    "user_ref_id": "146902",
                    "user_name": "Kadan Salmon",
                    "user_type": 0,
                    "user_email": "kadan_salmon@yahoo.com",
                    "reg_date": "2019-05-27 10:20:34",
                    "net_state": 1,
                    "score": "0.0",
                    "quest_completed": 0,
                    "quest_active": 0
                }
            ]
        }';

            $out = json_decode($_format, true);

            echo json_encode($out);
        }
    }

}

if (isset($_REQUEST["action"]))
{

    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];


    //** INCOMPLETED **
    if ($action == 'register_client')
    {

        $data = json_decode($param_json, true);

        $task_id = text_clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }

    //** INCOMPLETED **
    if ($action == 'register_agent')
    {
        //$data = json_decode($param_json, true);
        $data = $_REQUEST;
        //$data[""] = $_REQUEST[""];


        $screen_name = stringCase(text_clean($data["user_screen_name"]));
        $email = stringCase(text_clean($data["user_email"]));
        $password = encryptPassword(text_clean($data["user_password"]));
        $first_name = stringCase(text_clean($data["user_first_name"]));
        $last_name = stringCase(text_clean($data["user_last_name"]));
        $gender = text_clean($data["user_sex"]);
        $mobile = text_clean($data["user_mobile"]);
        $country_id = text_clean($data["user_country_id"]);
        $state_id = text_clean($data["user_state_id"]);
        $city_id = text_clean($data["user_city_id"]);
        $zip = text_clean($data["user_zip"]);
        $county = text_clean($data["user_county"]);
        $parish = text_clean($data["user_parish"]);
        $is_experienced = text_clean($data["user_is_experienced"]);
        //$more_cv_data = text_clean($data["user_more_cv_data"]);
        $user_assistance_company = "";//text_clean($data["user_is_experienced"]);
        $user_deg_id = 0;//text_clean($data["user_is_experienced"]);

        $user_type = USER_TYPE_RESEARCHER;
        $user_active = STATE_ACTIVE;
        $user_is_approved = VERIFIED;
        $email_is_verified = VERIFIED;//todo : remove auto email verification
        $user_regdate = getCurrentTime();
        $user_ref_id = generateUserReferenceId();

        //psuedo profile data
        $user_test_passed = VERIFIED;
        $user_sample_essay = VERIFIED;

        //network data
        $network_id = text_clean($data["n_id"]);// please validate this first
        if(!isset($data["n_id"]) || $network_id == ""){
            $network_id = getDefaultNetwork($paperweight);
        }
        $network_role = NETWORK_ROLE_COLLECTOR;
        $relationship_id = generateNumericId();

        $result = array();
        $result["status"] = STATUS_SIGNUP_FAILED;



        //insert into table user
        $add_user = "insert into " . TABLE_USERS . " (user_ref_id,user_email,user_password,user_screen_name,user_first_name,user_last_name,user_sex,user_country_id,user_state_id,user_city_id,user_county,user_parish,user_regdate,user_type,user_email_verified,user_active,user_is_approved) values('$user_ref_id','$email','$password','$screen_name','$first_name','$last_name','$gender','$country_id','$state_id','$city_id','$county','$parish','$user_regdate','$user_type','$email_is_verified','$user_active','$user_is_approved')";
        //$add_user_result = null;//$paperweight->query($add_user);

        $add_user_result = $paperweight->query($add_user);

        if($add_user_result != null && $add_user_result->is_row_affected()){

            $query_new_user = "select * from " . TABLE_USERS . " where user_ref_id = '$user_ref_id' and user_email = '$email'";
            $query_new_user_result = $paperweight->query($query_new_user);

            if ($query_new_user_result != null)
            {
                $row = $query_new_user_result->fetch_array();
                if ($row != null)
                {

                    $user_id = $row["user_id"];
                    $add_user_profile = "insert into " . TABLE_USER_PROFILE . " (userprofile_user_id,user_mobile,user_is_experienced,user_assistance_company,user_deg_id,user_test_passed,user_sample_essay) values ('$user_id','$mobile','$is_experienced','$user_assistance_company','$user_deg_id','$user_test_passed','$user_sample_essay')";
                    $add_user_network = "insert into " . TABLE_NETWORK_RELATIONSHIP . " (relationship_id,network_id,network_role,update_time,user_id) values ('$relationship_id','$network_id','$network_role','$user_regdate','$user_id')";

                    $add_user_profile_result = $paperweight->query($add_user_profile);
                    if($add_user_profile_result != null && $add_user_profile_result->is_row_affected()){
                        $add_user_network_result = $paperweight->query($add_user_network);
                        if($add_user_network_result != null && $add_user_network_result->is_row_affected()){
                            $result["status"] = STATUS_OK;
                        }
                    }

                }
            }

        }

        $result["status"] = STATUS_OK;

        if ($result["status"] == STATUS_OK){

            //$attrs_session = array('user_id', 'user_email', 'user_screen_name');

            /*session_start();
            $_SESSION['logged_user'] = array();
            $_SESSION['logged_user']["user_id"] = 121;
            $_SESSION['logged_user']["user_email"] = "kadan_salmon@yahoo.com";
            $_SESSION['logged_user']["user_screen_name"] = "Commander";
            $_SESSION['logged_user']["user_type"] = 1;
            $_SESSION['logged_user']["user_active"] = 1;
            $_SESSION['logged_user']["user_email_verified"] = 1;
            $_SESSION['logged_user']["user_deactivate_request"] = 0;*/

        }


        /*$login_token = generate_token();
        $login_time = getCurrentTime();
        $login_state = LOGIN_STATE_VALID;
        $user_id = $row_data["user_id"];
        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id) values ('$login_token','$login_time','$login_state','$user_id')";
        $details_result = $this->db_connector->query($details_query);
        if($details_result != null && $details_result->is_row_affected()){
            //$this->isLoggedin = true;

            $result["user_id"] = $row_data["user_id"];
            $result["login_token"] = $login_token;
            $result["status"] = STATUS_OK;

            return $result;
        }*/


        //$_COOKIE["help"] = "mee";
        //setcookie("help","me");



        /*$index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;*/

        //echo json_encode($result);

        /*$result["user"] = $add_user;
        $result["user_profile"] = $add_user_profile;
        $result["user_network"] = $add_user_network;*/

        //$result["session"] = session_id();
        echo json_encode($result);


    }

    //** DEPRECATED **
    if ($action == 'dash_general_quest_list')
    {
        $data = json_decode($param_json, true);
        $user_id = text_clean($data["user_id"]);

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        //$data = json_decode($sample, true);

        $res = '{
            "status": "OK",
            "quest_list": [
                {
                    "quest_ref_id": "2623641843",
                    "quest_name": "Stark Industry\'s Customer Review",
                    "quest_type": "Sentiment Survey",
                    "quest_status": 0
                }
            ]
        }';
        $result["status"] = "NO_DATA";

        $network_relationship = getNetworkRelationship($user_id,$paperweight);

        $rel_status = $network_relationship["status"];


        if ($rel_status == "OK"){
            $network_role = $network_relationship["network_role"];
            $network_id = $network_relationship["network_id"];
        }
        else{
            $network_role = NETWORK_ROLE_COLLECTOR;
            $network_id = "nid_hfg589368HWrvsp"; //getDefaultNetworkId();
        }


        //todo show based on network id and not USER_ID
        //$task_status = "(" . TASK_STATUS_CANCELLED . "," . TASK_STATUS_PENDING . "," . TASK_STATUS_DRAFT . ")";
        $task_status = "(" . TASK_STATUS_PENDING . "," . TASK_STATUS_DRAFT . ")";

        $task_query = "select * from " . TABLE_TASKS . " where task_user_id = '$user_id' and task_service_type = 3 and task_status in $task_status order by task_posted_on desc";

        $record_found = false;
        $task_data = array();
        $index = 0;

        if ($network_role == NETWORK_ROLE_COMMANDER){
            $task_result = $paperweight->query($task_query);

            if ($task_result != null)
            {
                while ($row = $task_result->fetch_array())
                {
                    $record_found = true;

                    $task_id = $row["task_id"];
                    $order_ref_id = $row["task_ref_id"];
                    $project_name = $row["task_topic"];
                    $project_detail = $row["task_instructions"];
                    $location_count = $row["task_location_count"];
                    $question_count = $row["task_question_count"];
                    $job_list = array();

                    $job_list_data = getJobList($task_id,$paperweight);

                    if ($job_list_data["status"] == "OK"){
                        $job_list = $job_list_data["result"];
                    }


                    $task_data[$index]["task_id"] = $task_id;
                    $task_data[$index]["order_ref_id"] = $order_ref_id;
                    $task_data[$index]["project_name"] = $project_name;
                    $task_data[$index]["project_detail"] = $project_detail;
                    $task_data[$index]["location_count"] = $location_count;
                    $task_data[$index]["question_count"] = $question_count;
                    $task_data[$index]["job_list"] = $job_list;

                    $index++;

                }
            }

        }


        if ($record_found)
        {
            $result["status"] = "OK";

            $general_data = extractActiveProjectData($task_data);

            //$result["collector"] = $task_data;
            $result["active_jobs"] = $general_data["active_jobs"];
            $result["active_locations"] = $general_data["active_locations"];
            $result["collector_total"] = $general_data["collector_total"];
            $result["collector_count"] = $general_data["collector_count"];
            $result["response_total"] = $general_data["response_total"];
            $result["response_count"] = $general_data["response_count"];
            $result["top_location_list"] = extractTopLocationList($task_data);
            $result["project_list"] = extractActiveProjectList($task_data);

        }

        echo json_encode($result);

    }

    //** DEPRECATED **
    if ($action == 'dash_active_quest_list')
    {

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        //$data = json_decode($sample, true);


        $result["status"] = "NO_DATA";

        $record_found = false;
        $task_data = array();
        $index = 0;

        $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
        $task_result = $paperweight->query($task_query);

        if ($task_result != null)
        {
            while ($row = $task_result->fetch_array())
            {
                $record_found = true;

                $task_id = $row["task_id"];
                $order_ref_id = $row["task_ref_id"];
                $project_name = $row["task_topic"];
                $project_detail = $row["task_instructions"];
                $location_count = $row["task_location_count"];
                $question_count = $row["task_question_count"];
                $job_list = array();

                $job_list_data = getJobList($task_id,$paperweight);

                if ($job_list_data["status"] == "OK"){
                    $job_list = $job_list_data["result"];
                }


                $task_data[$index]["task_id"] = $task_id;
                $task_data[$index]["order_ref_id"] = $order_ref_id;
                $task_data[$index]["project_name"] = $project_name;
                $task_data[$index]["project_detail"] = $project_detail;
                $task_data[$index]["location_count"] = $location_count;
                $task_data[$index]["question_count"] = $question_count;
                $task_data[$index]["job_list"] = $job_list;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $general_data = extractActiveProjectData($task_data);

            //$result["collector"] = $task_data;
            $result["active_jobs"] = $general_data["active_jobs"];
            $result["active_locations"] = $general_data["active_locations"];
            $result["collector_total"] = $general_data["collector_total"];
            $result["collector_count"] = $general_data["collector_count"];
            $result["response_total"] = $general_data["response_total"];
            $result["response_count"] = $general_data["response_count"];
            $result["top_location_list"] = extractTopLocationList($task_data);
            $result["project_list"] = extractActiveProjectList($task_data);

        }

        echo json_encode($result);

    }



    //https://api.queritel.com/api/general/qworkservices.php?action=demo&param_json={"task_id":180}
    if ($action == "demo")
    {
        //$data = json_decode($param_json, true);

        //echo "This is demo <br>";
        //echo createEmailInvitationBody("google.com","Kadan Salmon");

        //echo getDefaultNetwork($paperweight);
        echo json_encode(getOfficialNetworks($paperweight));
    }

    /*
     *  @api get_job_instance
     *  @param task_id
     *  @uses gets general job_instance data for specific [task_id] (used by : Admin Field Management)
     *

        {
    "status": "OK | NO_JOBS",
    "result": [
        {
            "location": "Address Location 1",
            "lat": 17.596855,
            "lng": -127.596855,
            "country": "Country 1",
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location": "Address Location 2",
            "lat": 17.596855,
            "lng": -127.596855,
            "country": "Country 2",
            "response_total": 40,
            "response_count": 6,
            "progress": [
                {
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 4
                },
                {
                    "fname": "First-2",
                    "lname": "Last-2",
                    "response_total": 10,
                    "response_count": 2
                }
            ]
        }
    ]
}

     */
    // ** SAMPLE **
    if ($action == 'get_job_instance')
    {

        $data = json_decode($param_json, true);

        $task_id = text_clean($data["task_id"]);
        $index = 0;

        $result["status"] = "NO_JOBS";
        $data = array();

        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);

        if ($location_result != null)
        {

            while ($row = $location_result->fetch_array())
            {
                $result["status"] = "OK";

                $job_id = $row["job_id"];
                $address = $row["address"];
                $lat = $row["location_lat"];
                $lng = $row["location_lon"];
                $country = $row["country"];
                $response_total = $row["survey_total"];

                $progress = getLocationProgress($job_id, $paperweight);

                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];

                $data[$index]["location"] = $address;
                $data[$index]["lat"] = $lat;
                $data[$index]["lng"] = $lng;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];

                $index++;

            }

        }

        $result["result"] = $data;

        echo json_encode($result);

    }

    /*
     *  @api send_message
     *  @param
     *  @uses processes a send message request
     *
     * {
        "status": "OK",
        "send_result":
        {
            "timestamp" :"' . $stamp . '",
            "message_id": "' . $mID . '",
            "sender_id": -1,
            "recipient_id": ' . $o_rec . '"
        }

        }
     */
    //SAMPLE
    if ($action == 'send_message'){
        $data_p = json_decode($param_json, true);

        $o_body = text_clean($data_p["body"]);
        $o_rec = text_clean($data_p["recipient_id"]);

        $stamp = getCurrentTime();
        $sender = - 1;
        $body = $o_body;
        $mID = getRandomString(8);


        //$data = json_decode($sample, true);
        $f["timestamp"] = $stamp;
        $f["message_id"] = $mID;
        $f["sender_id"] = -1;
        $f["recipient_id"] = $o_rec;
        $f["body"] = $body;

        $data["status"] = "OK";
        $data["send_result"] = $f;
        echo json_encode($data);
    }

    /*
     *
     *  @api get_active_project
     *  @param
     *  @uses gets all active jobs (projects)
     *

        {
    "status": "OK | NO_DATA",
    "active_jobs": 2,
    "active_locations": 2,
    "collector_total": 8,
    "collector_count": 2,
    "response_total": 80,
    "response_count": 2,
    "top_location_list": [
        {
            "iso": "country-iso",
            "name": "country-name",
            "count": "job-location-count"
        }
    ],
    "project_list": [
        {
            "order_ref_id": "task-reference-id",
            "project_name": "task_topic",
            "project_detail": "task_instructions",
            "question_count": "task_question_count",
            "response_total": "task_respondent_count",
            "response_count": "responses-for-this-proj",
            "collector_total": "collector-needed",
            "collector_count": "accepted-so-far"
        }
    ]
}

     */
    //SAMPLE
    if ($action == 'get_active_project__')
    {

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $sample = '{
    "status": "OK",
    "active_jobs": 2,
    "active_locations": 3,
    "collector_total": 12,
    "collector_count": 2,
    "response_total": 120,
    "response_count": 2,
    "top_location_list": [
        {
            "iso": "JM",
            "name": "Jamaica",
            "count": 2
        },
        {
            "iso": "CL",
            "name": "Chile",
            "count": 1
        }
    ],
    "project_list": [
        {
            "order_ref_id": "2623641843",
            "project_name": "Stark Industry\'s Customer Review",
            "project_detail": "To determine the public\'s attitude to Stark Industry\'s profiteering from the selling of weapons of mass destruction",
            "location_count": 2,
            "question_count": 10,
            "response_total": 80,
            "response_count": 1,
            "collector_total": 8,
            "collector_count": 1
        },
        {
            "order_ref_id": "1080041606",
            "project_name": "Grace Kennedy Expansion Review",
            "project_detail": "Responses must be obtained from individuals who were born in latin america",
            "location_count": 1,
            "question_count": 25,
            "response_total": 40,
            "response_count": 0,
            "collector_total": 4,
            "collector_count": 0
        }
    ]
}';

        $data = json_decode($sample, true);

        //$task_id = text_clean($data["task_id"]);
        /*$index = 0;
        $result["status"] = "NO_JOBS";
        $data = array();
        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);
        if ($location_result != null) {
            while ($row = $location_result->fetch_array()) {
                $result["status"] = "OK";
                $job_id = $row["job_id"];
                $address = $row["address"];
                $country = $row["country"];
                $response_total = $row["survey_total"];
                $progress = getLocationProgress($job_id, $paperweight);
                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];
                $data[$index]["location"] = $address;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];
                $index++;
            }
        }
        $result["result"] = $data;
        */

        echo json_encode($data);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    // ** SAMPLE **
    if ($action == 'get_active_project')
    {

        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        //$data = json_decode($sample, true);


        $result["status"] = "NO_DATA";

        $record_found = false;
        $task_data = array();
        $index = 0;

        $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
        $task_result = $paperweight->query($task_query);

        if ($task_result != null)
        {
            while ($row = $task_result->fetch_array())
            {
                $record_found = true;

                $task_id = $row["task_id"];
                $order_ref_id = $row["task_ref_id"];
                $project_name = $row["task_topic"];
                $project_detail = $row["task_instructions"];
                $location_count = $row["task_location_count"];
                $question_count = $row["task_question_count"];
                $job_list = array();

                $job_list_data = getJobList($task_id,$paperweight);

                if ($job_list_data["status"] == "OK"){
                    $job_list = $job_list_data["result"];
                }


                $task_data[$index]["task_id"] = $task_id;
                $task_data[$index]["order_ref_id"] = $order_ref_id;
                $task_data[$index]["project_name"] = $project_name;
                $task_data[$index]["project_detail"] = $project_detail;
                $task_data[$index]["location_count"] = $location_count;
                $task_data[$index]["question_count"] = $question_count;
                $task_data[$index]["job_list"] = $job_list;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $general_data = extractActiveProjectData($task_data);

            //$result["collector"] = $task_data;
            $result["active_jobs"] = $general_data["active_jobs"];
            $result["active_locations"] = $general_data["active_locations"];
            $result["collector_total"] = $general_data["collector_total"];
            $result["collector_count"] = $general_data["collector_count"];
            $result["response_total"] = $general_data["response_total"];
            $result["response_count"] = $general_data["response_count"];
            $result["top_location_list"] = extractTopLocationList($task_data);
            $result["project_list"] = extractActiveProjectList($task_data);

        }

        echo json_encode($result);

    }

    /*
     *
     *  @api get_active_location
     *  @param
     *  @uses gets all active jobs along with their locations and the data collectors connected to the job
     *
     {
    "status": "OK | NO_DATA",
    "location_list": [
        {
            "location_id": "100275",
            "lat": 18.493093,
            "lng": -77.658104,
            "location": "Albert Street, Falmouth, Jamaica",
            "order_ref_id": "2623641843",
            "country": "Jamaica",
            "country_iso": "JM",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "26",
                    "user_ref_id": "664801",
                    "fname": "Tracy-Ann",
                    "lname": "Wiltshire",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "108086",
            "lat": 18.006166,
            "lng": -76.812691,
            "location": "85 Hagley Park Rd, Kingston, Jamaica",
            "order_ref_id": "2623641843",
            "country": "Jamaica",
            "country_iso": "JM",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "28",
                    "user_ref_id": "223340",
                    "fname": "Colleen",
                    "lname": "Williams",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "131418",
            "lat": -33.417751,
            "lng": -70.606346,
            "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
            "order_ref_id": "1080041606",
            "country": "Chile",
            "country_iso": "CL",
            "collector_total": 4,
            "collector_count": 0,
            "response_total": 40,
            "response_count": 0,
            "progress": []
        }
    ]
}
     */
    //SAMPLE
    if ($action == 'get_active_location__') {
        $data_p = json_decode($param_json, true);
        $list = $data_p["filter_list"];
        $sample = '{
        "status": "OK",
        "location_list": [
            {
                "location_id": "100275",
                "lat": 18.493093,
                "lng": -77.658104,
                "location": "Albert Street, Falmouth, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "26",
                        "user_ref_id": "664801",
                        "fname": "Tracy-Ann",
                        "lname": "Wiltshire",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "108086",
                "lat": 18.006166,
                "lng": -76.812691,
                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "28",
                        "user_ref_id": "223340",
                        "fname": "Colleen",
                        "lname": "Williams",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "131418",
                "lat": -33.417751,
                "lng": -70.606346,
                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                "order_ref_id": "1080041606",
                "country": "Chile",
                "country_iso": "CL",
                "collector_total": 4,
                "collector_count": 0,
                "response_total": 40,
                "response_count": 0,
                "progress": []
            }
        ]
    }';
        if (count($list) > 0) {
            for ($i = 0;$i < count($list);$i++) {
                if ($list[$i]["filter_criteria"] == "2623641843") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                }
                if ($list[$i]["filter_criteria"] == "1080041606") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                }
            }
        }
        //filter_type
        //filter_state
        //filter_criteria
        //filter_list
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $data = json_decode($sample, true);
        //echo json_encode($list[0]["filter_criteria"]);
        echo json_encode($data);
    }

    // ** SAMPLE **
    if ($action == 'get_active_location') {
        $data_p = json_decode($param_json, true);
        $list = $data_p["filter_list"];

        /*if (count($list) > 0) {
            for ($i = 0;$i < count($list);$i++) {
                if ($list[$i]["filter_criteria"] == "2623641843") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                }
                if ($list[$i]["filter_criteria"] == "1080041606") {
                    if ($list[$i]["filter_state"] == "inc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "131418",
                                "lat": -33.417751,
                                "lng": -70.606346,
                                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                                "order_ref_id": "1080041606",
                                "country": "Chile",
                                "country_iso": "CL",
                                "collector_total": 4,
                                "collector_count": 0,
                                "response_total": 40,
                                "response_count": 0,
                                "progress": []
                            }
                        ]
                    }';
                    }
                    if ($list[$i]["filter_state"] == "exc") {
                        $sample = '{
                        "status": "OK",
                        "location_list": [
                            {
                                "location_id": "100275",
                                "lat": 18.493093,
                                "lng": -77.658104,
                                "location": "Albert Street, Falmouth, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "26",
                                        "user_ref_id": "664801",
                                        "fname": "Tracy-Ann",
                                        "lname": "Wiltshire",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            },
                            {
                                "location_id": "108086",
                                "lat": 18.006166,
                                "lng": -76.812691,
                                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                                "order_ref_id": "2623641843",
                                "country": "Jamaica",
                                "country_iso": "JM",
                                "collector_total": 4,
                                "collector_count": 1,
                                "response_total": 40,
                                "response_count": 1,
                                "progress": [
                                    {
                                        "user_id": "28",
                                        "user_ref_id": "223340",
                                        "fname": "Colleen",
                                        "lname": "Williams",
                                        "response_total": 10,
                                        "response_count": 1
                                    }
                                ]
                            }
                        ]
                    }';
                    }
                }
            }
        }*/
        //filter_type
        //filter_state
        //filter_criteria
        //filter_list
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},

        $result["status"] = "NO_DATA";

        $task_data = array();
        $index = 0;
        $record_found = false;

        $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4) order by task_posted_on desc";
        $task_result = $paperweight->query($task_query);

        if ($task_result != null)
        {
            while ($row = $task_result->fetch_array())
            {
                $record_found = true;

                $task_id = $row["task_id"];
                $order_ref_id = $row["task_ref_id"];
                $project_name = $row["task_topic"];
                $project_detail = $row["task_instructions"];
                $location_count = $row["task_location_count"];
                $question_count = $row["task_question_count"];
                $job_list = array();

                $job_list_data = getJobList($task_id,$paperweight);

                if ($job_list_data["status"] == "OK"){
                    $job_list = $job_list_data["result"];
                }


                $task_data[$index]["task_id"] = $task_id;
                $task_data[$index]["order_ref_id"] = $order_ref_id;
                $task_data[$index]["project_name"] = $project_name;
                $task_data[$index]["project_detail"] = $project_detail;
                $task_data[$index]["location_count"] = $location_count;
                $task_data[$index]["question_count"] = $question_count;
                $task_data[$index]["job_list"] = $job_list;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $location_list = extractActiveLocationList($task_data);

            $result["location_list"] = $location_list;

        }

        //$data = json_decode($sample, true);
        //echo json_encode($list[0]["filter_criteria"]);
        echo json_encode($result);
    }

    /*
     *
     *  @api get_active_location-deprecated
     *  @param
     *  @uses gets all active jobs along with their locations and the data collectors connected to the job
     *
        {
    "status": "OK | NO_JOBS",
    "active_jobs": 2,
    "active_locations": 2,
    "collector_total": 8,
    "collector_count": 2,
    "response_total": 80,
    "response_count": 2,
    "location_list": [
        {
            "location_id": "job-instance-id-1",
            "lat": 17.8945743,
            "lng": -127.8995574,
            "location": "location 1",
            "order_ref_id": "task-reference-id",
            "country": "Country 1",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "user-id",
                    "user_ref_id": "user-reference-id",
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        },
        {
            "location_id": "job-instance-id-2",
            "lat": 18.8945743,
            "lng": -128.8995574,
            "location": "location 2",
            "order_ref_id": "task-reference-id",
            "country": "Country 2",
            "collector_total": 4,
            "collector_count": 1,
            "response_total": 40,
            "response_count": 1,
            "progress": [
                {
                    "user_id": "user-id",
                    "user_ref_id": "user-reference-id",
                    "fname": "First",
                    "lname": "Last",
                    "response_total": 10,
                    "response_count": 1
                }
            ]
        }
    ]
}
     */
    //SAMPLE
    if ($action == 'get_active_location-deprecated'){
        //{lat: 18.222, lng: -77.222},
        //{lat: 18.459, lng: -77.459},
        $sample = '{
        "status": "OK",
        "active_jobs": 2,
        "active_locations": 3,
        "collector_total": 8,
        "collector_count": 2,
        "response_total": 80,
        "response_count": 2,
        "location_list": [
            {
                "location_id": "100275",
                "lat": 18.493093,
                "lng": -77.658104,
                "location": "Albert Street, Falmouth, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "26",
                        "user_ref_id": "664801",
                        "fname": "Tracy-Ann",
                        "lname": "Wiltshire",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "108086",
                "lat": 18.006166,
                "lng": -76.812691,
                "location": "85 Hagley Park Rd, Kingston, Jamaica",
                "order_ref_id": "2623641843",
                "country": "Jamaica",
                "country_iso": "JM",
                "collector_total": 4,
                "collector_count": 1,
                "response_total": 40,
                "response_count": 1,
                "progress": [
                    {
                        "user_id": "28",
                        "user_ref_id": "223340",
                        "fname": "Colleen",
                        "lname": "Williams",
                        "response_total": 10,
                        "response_count": 1
                    }
                ]
            },
            {
                "location_id": "131418",
                "lat": -33.417751,
                "lng": -70.606346,
                "location": "Plaza de Armas, Santiago, RegiÃ³n Metropolitana, Chile",
                "order_ref_id": "1080041606",
                "country": "Chile",
                "country_iso": "CL",
                "collector_total": 4,
                "collector_count": 0,
                "response_total": 40,
                "response_count": 0,
                "progress": []
            }
        ]
    }';
        $data = json_decode($sample, true);
        //$task_id = text_clean($data["task_id"]);
        //=====
        /*$index = 0;
        $result["status"] = "NO_JOBS";
        $data = array();
        $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
        $location_result = $paperweight->query($location_query);
        if ($location_result != null) {
            while ($row = $location_result->fetch_array()) {
                $result["status"] = "OK";
                $job_id = $row["job_id"];
                $address = $row["address"];
                $country = $row["country"];
                $response_total = $row["survey_total"];
                $progress = getLocationProgress($job_id, $paperweight);
                //the number of actually completed questionnaires
                $response_count = $progress["combined_total"];
                $data[$index]["location"] = $address;
                $data[$index]["country"] = $country;
                $data[$index]["response_total"] = $response_total;
                $data[$index]["response_count"] = $response_count;
                $data[$index]["progress"] = $progress["progress"];
                $index++;
            }
        }
        $result["result"] = $data;*/
        //======
        echo json_encode($data);
        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    /*
    *
    *  @api get_data_collector_list
    *  @param
    *  @uses gets the completed list of all activated data collectors
    *

    {
    "status": "OK | NO_DATA",
    "collector_list": [
        {
            "user_id": "user-id",
            "user_ref_id": "user-reference-id",
            "user_email": "email 1",
            "fname": "First 1",
            "lname": "Last 1",
            "user_phone": "Phone 1",
            "gender": "gender 1",
            "country": "coountry 1",
            "country_iso": "iso 1"
        },
        {
            "user_id": "user-id",
            "user_ref_id": "user-reference-id",
            "user_email": "email 2",
            "fname": "First 2",
            "lname": "Last 2",
            "user_phone": "Phone 2",
            "gender": "gender 2",
            "country": "coountry 2",
            "country_iso": "iso 2"
        }
    ]
}
    */
    //SAMPLE
    if ($action == 'get_data_collector_list _DEMO')
    {

        $result["status"] = "NO_DATA";
        $result["collector_list"] = array();
        $collector_list = array();

        //$record_found = false;
        $record_found = true;

        $i = 0;
        $collector_list[$i]["user_id"] = 22;
        $collector_list[$i]["user_ref_id"] = 758453;
        $collector_list[$i]["user_email"] = "anderson.tailor@gmail.com";
        $collector_list[$i]["fname"] = "Anderson";
        $collector_list[$i]["lname"] = "Tailor";
        $collector_list[$i]["user_phone"] = "(876)392-9856";
        $collector_list[$i]["gender"] = "male";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 1;
        $collector_list[$i]["user_id"] = 28;
        $collector_list[$i]["user_ref_id"] = 223340;
        $collector_list[$i]["user_email"] = "colleen.williams@gmail.com";
        $collector_list[$i]["fname"] = "Colleen";
        $collector_list[$i]["lname"] = "Williams";
        $collector_list[$i]["user_phone"] = "(876)472-8365";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 2;
        $collector_list[$i]["user_id"] = 26;
        $collector_list[$i]["user_ref_id"] = 664801;
        $collector_list[$i]["user_email"] = "tracy.wiltshire@gmail.com";
        $collector_list[$i]["fname"] = "Tracy-Ann";
        $collector_list[$i]["lname"] = "Wiltshire";
        $collector_list[$i]["user_phone"] = "(876)786-6543";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";

        $i = 3;
        $collector_list[$i]["user_id"] = 30;
        $collector_list[$i]["user_ref_id"] = 944596;
        $collector_list[$i]["user_email"] = "sandra.wilson@gmail.com";
        $collector_list[$i]["fname"] = "Sandra";
        $collector_list[$i]["lname"] = "Wilson";
        $collector_list[$i]["user_phone"] = "(876)832-4752";
        $collector_list[$i]["gender"] = "female";
        $collector_list[$i]["country"] = "Jamaica";
        $collector_list[$i]["country_iso"] = "JM";


        if ($record_found)
        {
            $result["status"] = "OK";

            $result["collector_list"] = $collector_list;

        }

        echo json_encode($result);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

    // ** SAMPLE **
    if ($action == 'get_data_collector_list')
    {

        $result["status"] = "NO_DATA";
        $result["collector_list"] = array();
        $collector_list = array();
        $record_found = false;

        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $verified_by_admin = VERIFIED;

        $index = 0;


        $user_query = "select * from " . TABLE_USERS . " where user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin'";
        $user_result = $paperweight->query($user_query);

        if ($user_result != null)
        {
            while ($row = $user_result->fetch_array())
            {
                $record_found = true;

                $user_id = $row["user_id"];
                $user_ref_id = $row["user_ref_id"];
                $user_email = stringCase($row["user_email"],STRING_CASE_LOWER);
                $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
                $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
                $user_phone = $row["user_phone_number"];
                $gender = ($row["user_sex"] == GENDER_MALE) ? "male" : "female";
                $country = ""; //$row[""];
                $country_iso = ""; // $row[""];


                $collector_list[$index]["user_id"] = $user_id;
                $collector_list[$index]["user_ref_id"] = $user_ref_id;
                $collector_list[$index]["user_email"] = $user_email;
                $collector_list[$index]["fname"] = $fname;
                $collector_list[$index]["lname"] = $lname;
                $collector_list[$index]["user_phone"] = $user_phone;
                $collector_list[$index]["gender"] = $gender;
                $collector_list[$index]["country"] = $country;
                $collector_list[$index]["country_iso"] = $country_iso;

                $index++;

            }
        }

        if ($record_found)
        {
            $result["status"] = "OK";

            $result["collector_list"] = $collector_list;

        }

        echo json_encode($result);

        //"task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = 1 and task_status not in (0,3,4)"

    }

}

function updateDueDate($task_id,$days_hours_mins, $database){
    //DAYS-HOURS-MINUTES
    $extra_obj = explode("-",$days_hours_mins);
    $days = $extra_obj[0];
    $hours = $extra_obj[1];
    $minutes = $extra_obj[2];
    $minutes_to_add = 0;

    if ($days > 0){
        $hours += ($days * 24);
    }
    if ($hours > 0){
        $minutes += ($hours * 60);
    }
    if ($minutes > 0){
        $minutes_to_add += $minutes;
    }

    $result = false;


    $get_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $get_query_result = $database->query($get_query);

    if($get_query_result != null && $get_query_result->is_row_found()){
        if($row = $get_query_result->fetch_array()){
            $task_due_date = $row["task_due_date"];


            //$old_time_utc = "2021-07-28 07:00:00";
            $old_time_utc = $task_due_date;
            $interval_spec = "PT" . $minutes_to_add . "M";

            $time = new DateTime($old_time_utc,new DateTimeZone("UTC"));
            $time->add(new DateInterval($interval_spec));
            $new_time_utc = $time->format("Y-m-d H:i:s");

            /*$sub = array();
            $sub["minutes_to_add"] = $minutes_to_add;
            $sub["old_time_utc"] = $old_time_utc;
            $sub["new_time_utc"] = $new_time_utc;
            $sub["extra_obj"] = $extra_obj;
            $sub["extra"] = $days_hours_mins;*/



            $sql_query = "update " . TABLE_TASKS . " set `task_due_date` = '$new_time_utc' where `task_id` = '$task_id'";
            $sql_query_result = $database->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){
                $result = true;
            }
        }
    }


    return $result;
}


//completely remove a task (all reference to the task id) from the database
function eraseTask($task_id,$paperweight){

    $removed = false;

    $task_query = "delete from " . TABLE_TASKS . " where task_id = '$task_id'";
    $job_query = "delete from " . TABLE_JOBS . " where task_id = '$task_id'";
    $response_query = "delete from " . TABLE_RESPONSE . " where task_id = '$task_id'";
    $tag_query = "delete from " . TABLE_JOB_TAGS . " where task_id = '$task_id'";

    $task_result = $paperweight->query($task_query);
    $job_result = $paperweight->query($job_query);
    $response_result = $paperweight->query($response_query);
    $tag_result = $paperweight->query($tag_query);

    if($task_result != null && $task_result->is_row_affected()){
        $removed = true;
    }

    return $removed;
}

//has the task activity changed.. if so erase the project to recreate it
function hasActivityChanged($task_activity,$task_id,$paperweight){
    $changed = false;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null){
        if ($row = $task_result->fetch_array()){
            $activity = $row["task_activity"];

            if ($activity != $task_activity){
                $changed = true;
            }

        }

    }

    return $changed;
}


function getTagEffort($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result = array();

    $result["status"] = "NO_DATA";


    $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_effort'";
    $tag_result = $paperweight->query($tag_query);

    if ($tag_result != null){
        if ($row = $tag_result->fetch_array()){
            $tag_data = $row["tag_data"];
            $decoded = json_decode($tag_data,true);

            $result["status"] = "OK";
            $result["level"] = $decoded["level"];

        }

    }

    return $result;
}


function getPayPerResponse($task_id,$paperweight){

    $result = array();
    $result["status"] = "NO_DATA";

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null){
        while ($row = $location_result->fetch_array()){
            $cpq = $row["cpq"];
            if ($cpq != null){
                $result["status"] = "OK";
                $result["cpq"] = $cpq;
                break;
            }
        }
    }

    return $result;

}

/*
 * get job tags for editing the data
 */
function getJobTags($job_id,$paperweight){
    $record_found = false;
    $index = 0;

    $data = array();
    $result = array();

    $tag_query = "select * from " . TABLE_JOB_TAGS . " where job_id = '$job_id'";
    $tag_result = $paperweight->query($tag_query);

    if ($tag_result != null && $tag_result->is_row_found()){
        while ($row = $tag_result->fetch_array()){
            $record_found = true;

            $tag_id = $row["tag_id"];
            $tag_label = $row["tag_label"];
            $tag_data = $row["tag_data"];

            $decoded = json_decode($tag_data,true);

            $data[$index]["unique_id"] = $tag_id;
            $data[$index]["tag_label"] = $tag_label;
            $data[$index]["tag_data"] = $decoded;

            $index++;
        }

    }

    if ($record_found){
        $result = $data;
    }

    return $result;
}

/*
 * Get location detail for editing purposes
 */
function getLocationDetail($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result["status"] = "NO_DATA";
    $result["result"] = array();
    $data = array();

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null)
    {
        while ($row = $location_result->fetch_array())
        {
            $record_found = true;

            $job_id = $row["job_id"];
            $address = $row["address"];
            $location_state = $row["state"];
            $lat = $row["location_lat"];
            $lng = $row["location_lon"];
            $country_name = stringCase($row["country"],STRING_CASE_CAP_EACH);
            $country_iso = stringCase($row["country_code"],STRING_CASE_UPPER);
            $response_total = $row["survey_total"];
            $collector_total = $row["researcher_required"];
            //$collector_count = $row["researcher_count"];

            //$progress = getLocationProgress($job_id, $paperweight);

            //the number of actually completed questionnaires
            //$response_count = $progress["combined_total"];

            $data[$index]["country"] = $country_name;
            $data[$index]["country_code"] = $country_iso;
            $data[$index]["state"] = $location_state;
            $data[$index]["address"] = $address;
            $data[$index]["lat"] = $lat;
            $data[$index]["lng"] = $lng;
            $data[$index]["researchers"] = $collector_total;
            $data[$index]["responses"] = $response_total;
            $data[$index]["local_id"] = "location_" . ($index + 1);
            $data[$index]["unique_id"] = $job_id;
            $tags = getJobTags($job_id,$paperweight);
            $data[$index]["job_tags"] = $tags;

            //$data[$index]["progress"] = $progress["progress"];

            $index++;

        }
    }

    if ($record_found){
        $result["status"] = "OK";
        $result["result"] = $data;
    }


    return $result;
}


function addLocationDetail($location_detail,$paperweight){
    $task_ref_id = $location_detail["task_ref_id"];
    $task_id = $location_detail["task_id"];
    $user_id = $location_detail["user_id"];
    $cpq = $location_detail["cpq"];
    $activity_type = $location_detail["activity_type"];

    $location_count = $location_detail["location_count"];
    $location_list = $location_detail["location_list"];

    if($location_count > 0){
        //if we have location to process

        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = generateNumericId();
            $update_time = getCurrentTime();

            $required_researchers = text_clean($location_list[$x]["researchers"]);
            $required_responses = text_clean($location_list[$x]["responses"]);

            $address = text_clean($location_list[$x]["address"]);
            $state = text_clean($location_list[$x]["state"]);
            $country = text_clean($location_list[$x]["country"]);
            $country_code = text_clean($location_list[$x]["country_code"]);
            $location_lat = text_clean($location_list[$x]["lat"]);
            $location_lon = text_clean($location_list[$x]["lng"]);
            $job_tags = $location_list[$x]["job_tags"];


            //insert new job instance
            $add_job = "insert into " . TABLE_JOBS . " (job_id,update_time,task_id,user_id,address,state,country,country_code,location_lat,location_lon,researcher_required,survey_total,cpq) values ('$location_id','$update_time','$task_id','$user_id','$address','$state','$country','$country_code','$location_lat','$location_lon','$required_researchers','$required_responses','$cpq')";
            $add_job_result = $paperweight->query($add_job);
            if($add_job_result != null && $add_job_result->is_row_affected()){

                $tag_count = count($job_tags);
                if($tag_count > 0){
                    for($i = 0; $i < $tag_count; $i++){

                        $tag_id = generateNumericId();
                        $tag_label = $job_tags[$i]["tag_label"];
                        $tag_data = json_encode($job_tags[$i]["tag_data"]);


                        //insert new tag
                        $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                        $add_tag_result = $paperweight->query($add_tag);
                        if($add_tag_result != null && $add_tag_result->is_row_affected()){

                        }


                    }
                }

            }


        }
    }

    if (isset($location_detail["tag_effort"])){
        $update_time = getCurrentTime();
        $tag_id = generateNumericId();
        $tag_label = "tag_effort";

        $d = array();
        $d["level"] = $location_detail["tag_effort"];
        $tag_data = json_encode($d);

        $add_effort = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$update_time','$tag_label','$tag_data')";
        $add_effort_result = $paperweight->query($add_effort);
    }

}


//remove locations from the database that are no longer present after update
function removeDeletedLocations($locationDetails,$task_id,$paperweight){

    $index = 0;
    $update_found = false;
    $update_array = array();
    $update_string = " (";

    $location_count = $locationDetails["location_count"];
    $location_list = $locationDetails["location_list"];

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            if (!empty($location_id)){
                if ($x == 0){
                    $update_string .= "'$location_id'";
                    $update_found = true;
                }
                else{
                    $update_string .= ",'$location_id'";
                    $update_found = true;
                }
            }

        }

        if (!$update_found){
            $update_string .= "''";
        }

    }
    else{
        $update_string .= "''";
    }

    $update_string .= ") ";


    $location_query = "delete from " . TABLE_JOBS . " where task_id = '$task_id' and job_id not in " . $update_string;
    $location_result = $paperweight->query($location_query);

}


//remove tags from the database that are no longer present after update
function removeDeletedLTags($locationDetails,$task_id,$paperweight){
    $index = 0;
    $update_found = false;
    $update_array = array();
    $update_string = " (";


    $location_count = $locationDetails["location_count"];
    $location_list = $locationDetails["location_list"];

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            $job_tags = $location_list[$x]["job_tags"];

            $tag_count = count($job_tags);
            if($tag_count > 0){
                for($i = 0; $i < $tag_count; $i++){

                    $tag_id = $job_tags[$i]["unique_id"];
                    if (!empty($tag_id)){

                        if ($index == 0){
                            $update_string .= "'$tag_id'";
                        }
                        else{
                            $update_string .= ",'$tag_id'";
                        }

                        $update_found = true;

                        $index++;

                    }

                }
            }

        }

        if (!$update_found){
            $update_string .= "''";
        }

    }
    else{
        $update_string .= "''";
    }

    $update_string .= ") ";

    //SELECT * FROM initia19_paperweight.job_tag where task_id = 263 and job_id is not null and job_id not in ('51090173')

    $tag_query = "delete from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and job_id is not null and tag_id not in " . $update_string;
    $tag_result = $paperweight->query($tag_query);

}


function updateLocationDetail($location_detail,$paperweight){
    $task_ref_id = $location_detail["task_ref_id"];
    $task_id = $location_detail["task_id"];
    $user_id = $location_detail["user_id"];
    $cpq = $location_detail["cpq"];
    $activity_type = $location_detail["activity_type"];

    $location_count = $location_detail["location_count"];
    $location_list = $location_detail["location_list"];

    //purge database of unwanted locations
    removeDeletedLocations($location_detail,$task_id,$paperweight);
    removeDeletedLTags($location_detail,$task_id,$paperweight);


    $string = '';


    $location_exist = false;

    if($location_count > 0){
        //if we have location to process
        for($x = 0; $x < $location_count; $x++){
            //for each job instance

            $location_id = $location_list[$x]["unique_id"];
            if (!empty($location_id)){
                $location_exist = true;
            }
            else{
                $location_exist = false;
                $location_id = generateNumericId();
            }


            $update_time = getCurrentTime();

            $required_researchers = text_clean($location_list[$x]["researchers"]);
            $required_responses = text_clean($location_list[$x]["responses"]);

            $address = text_clean($location_list[$x]["address"]);
            //$address = text_clean($location_list[$x]["address"]);
            $state = text_clean($location_list[$x]["state"]);
            $country = text_clean($location_list[$x]["country"]);
            $country_code = text_clean($location_list[$x]["country_code"]);
            $location_lat = text_clean($location_list[$x]["lat"]);
            $location_lon = text_clean($location_list[$x]["lng"]);
            $job_tags = $location_list[$x]["job_tags"];

            if ($location_exist){

                //update existing job instance
                $update_job = "update " . TABLE_JOBS . " set update_time = '$update_time',address = '$address',state = '$state',country = '$country',country_code = '$country_code',location_lat = '$location_lat',location_lon = '$location_lon',researcher_required = '$required_researchers',survey_total = '$required_responses',cpq = '$cpq' where job_id = '$location_id'";
                $update_job_result = $paperweight->query($update_job);
                if($update_job_result != null && $update_job_result->is_row_affected()){

                    $tag_exist = false;

                    $tag_count = count($job_tags);
                    if($tag_count > 0){
                        for($i = 0; $i < $tag_count; $i++){

                            $tag_id = $job_tags[$i]["unique_id"];
                            if (!empty($tag_id)){
                                $tag_exist = true;
                            }
                            else{
                                $tag_exist = false;
                                $tag_id = generateNumericId();
                            }

                            $tag_label = $job_tags[$i]["tag_label"];
                            $tag_data = json_encode($job_tags[$i]["tag_data"]);

                            if ($tag_exist){
                                //update existing tag
                                $update_tag = "update " . TABLE_JOB_TAGS . " set update_time = '$update_time',tag_label = '$tag_label',tag_data = '$tag_data' where tag_id = '$tag_id'";
                                $update_tag_result = $paperweight->query($update_tag);
                                if($update_tag_result != null && $update_tag_result->is_row_affected()){

                                }
                            }
                            else{
                                //insert new tag
                                $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                                $add_tag_result = $paperweight->query($add_tag);
                                if($add_tag_result != null && $add_tag_result->is_row_affected()){

                                }
                            }

                        }
                    }

                }
            }
            else{
                //insert new job instance
                $add_job = "insert into " . TABLE_JOBS . " (job_id,update_time,task_id,user_id,address,state,country,country_code,location_lat,location_lon,researcher_required,survey_total,cpq) values ('$location_id','$update_time','$task_id','$user_id','$address','$state','$country','$country_code','$location_lat','$location_lon','$required_researchers','$required_responses','$cpq')";
                $add_job_result = $paperweight->query($add_job);
                if($add_job_result != null && $add_job_result->is_row_affected()){

                    $tag_count = count($job_tags);
                    if($tag_count > 0){
                        for($i = 0; $i < $tag_count; $i++){

                            $tag_id = generateNumericId();
                            $tag_label = $job_tags[$i]["tag_label"];
                            $tag_data = json_encode($job_tags[$i]["tag_data"]);


                            //insert new tag
                            $add_tag = "insert into " . TABLE_JOB_TAGS . " (tag_id,task_id,job_id,update_time,tag_label,tag_data) values ('$tag_id','$task_id','$location_id','$update_time','$tag_label','$tag_data')";
                            $add_tag_result = $paperweight->query($add_tag);
                            if($add_tag_result != null && $add_tag_result->is_row_affected()){

                            }


                        }
                    }

                }

            }



        }

    }

    if (isset($location_detail["tag_effort"])){
        $update_time = getCurrentTime();
        $tag_id = generateNumericId();
        $tag_label = "tag_effort";

        $d = array();
        $d["level"] = $location_detail["tag_effort"];
        $tag_data = json_encode($d);

        $update_effort = "update " . TABLE_JOB_TAGS . " set update_time = '$update_time', tag_data = '$tag_data' where task_id = '$task_id' and tag_label = '$tag_label'";
        $add_effort_result = $paperweight->query($update_effort);
    }

}


function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}


//@NOTE : CREATE DataCollector CLASS TO HOLD ALL USER DATA === last location, persistent state, id, #, list of jobs, outstanding payments



/*function sendMail($to, $subject, $body, $extra_headers=''){
    $send_email_by = CONF_EMAIL_SEND_VIA;
    if($send_email_by==CONF_EMAIL_SEND_VIA_SMTP){
        $res = sendSmtpMail($to, $subject, $body);

        if($res['status']!='sent' || $res['reject_reason']!='')
        {
            $message = "Hi,<br><br>";
            $message .= "Current status to send email for ".$subject." to ".$res['email']." is ".$res['status'];
            $message .= ", due to: ".$res['reject_reason'];
            $message .= ".<br><br>";
            $message .= "Thanks,<br><br>";
            $message .= CONF_WEBSITE_NAME." Team";
            $sub = 'Mail could not sent via SMTP on '.CONF_WEBSITE_URL;
            mail(CONF_ADMIN_EMAIL_ID, $sub, $message);
        }
        else{
            return true;
        }
    }

    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' .CONF_EMAILS_FROM_NAME. '<'. CONF_EMAILS_FROM . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}*/
/*

//$to = "kadian.salmon@queritel.com";
        $to = "kadansalmon.ks@gmail.com";
        $subject = "This is a Debug test";
        $body = "This serves as an email debugging test3";

        sendMail($to, $subject, $body, $extra_headers='');

 */

function createEmailInvitationBody($url,$organization_name){

    $date = date("M d, Y h:i");
    $timezone = date_default_timezone_get();
    //$url = "https://www.google.com"; //' . $url . '
    $org_name = $organization_name;//"Queritel Business'";


    $body = '
    
    <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
	<tbody>
		<tr style="background:#bf0000 none repeat scroll 0px 0px;">
			<td style="padding:0px;">
				<table border="0" width="100%" cellspacing="0" cellpadding="0">
					<tbody>
						<tr>
							<td style="padding:10px 20px;">
								<a href="https://queritel.com" target="_blank" rel="noopener noreferrer"><img src="https://queritel.com/images/cms/white-logo-01%2520copy.png" alt="Queritel.com" width="76" height="32"  style=""></a>
							</td>
							<td style="text-align:right;vertical-align:top;padding:10px 20px 0px 0px;"><span style="font-size:13px;color:#fff;vertical-align:top;">' . $date . ' ' . $timezone . '</span></td>
						</tr>
						<tr>
							<td colspan="2">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tbody>
										<tr>
											<td style="background:#eeeeee;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="vertical-align:bottom;text-align:center;">
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">&nbsp;</h2>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hello there,</h2>
																<p style="color:#3e434a;font-size:14px;font-weight:bold;margin:0px;">You have been invited to be apart of the ' . $org_name . ' Data Collection Network.</p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">Click the link below or copy it to your browser\'s address bar to proceed with your registration</p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="' . $url . '" target="_blank" rel="noopener noreferrer">Click here to register your account</a></p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">&nbsp;</p>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="background:#3b3f46;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="color:#fff;font-weight:bold;text-align:center;padding:5px 0 10px;">Find us on :</td>
														</tr>
														<tr>
															<td style="padding-bottom:25px;">
																<table border="0" width="100%" cellspacing="0" cellpadding="0">
																	<tbody>
																		<tr>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.facebook.com/Queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/facebook.png" alt="Facebook" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://twitter.com/Queritel" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/twitter.png" alt="Twitter" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.instagram.com/queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/instagram.png" alt="Instagram" width="16"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://www.linkedin.com/company/queritel/" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://queritel.com/images/linkedin.png" alt="Linkedin" width="16"></a>
																			</td>
																		</tr>
																	</tbody>
																</table>
															</td>
														</tr>
														<tr>
															<td style="text-align:center;color:#f2f2f2;font-size:14px;font-weight:bold;">
																<div>Thanks! &nbsp; Queritel, <a style="color:#fff;" href="https://queritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
																<div>
																	<br> </div>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="text-align:center;padding-bottom:10px;background:rgb(191,0,0);">
												<div style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Need help? Have feedback? Feel free to Contact&nbsp;<a style="color:#fff;" href="http://queritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
												
												<span style="color:rgb(255,255,255);font-size:12px;font-weight:600;padding:8px 0px 0px;">Copyright © 2020 Queritel</span>
											</td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</tbody>
</table>
    
    ';

    //return $timezone;
    return $body;
}
function _createEmailBody_OLD(){

    $date = date("M d, Y h:i");
    $timezone = date_default_timezone_get();


    $body = '
    
    <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
	<tbody>
		<tr style="background:#bf0000 none repeat scroll 0px 0px;">
			<td style="padding:0px;">
				<table border="0" width="100%" cellspacing="0" cellpadding="0">
					<tbody>
						<tr>
							<td style="padding:10px 20px;">
								<a href="https://queritel.com" target="_blank" rel="noopener noreferrer"><img src="https://queritel.com/images/cms/white-logo-01%2520copy.png" alt="Queritel.com" width="76" height="32"  style=""></a>
							</td>
							<td style="text-align:right;vertical-align:top;padding:10px 20px 0px 0px;"><span style="font-size:13px;color:#fff;vertical-align:top;">' . $date . ' ' . $timezone . '</span></td>
						</tr>
						<tr>
							<td colspan="2">
								<table border="0" width="100%" cellspacing="0" cellpadding="0">
									<tbody>
										<tr>
											<td style="background:#eeeeee;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="vertical-align:bottom;text-align:center;">
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">&nbsp;</h2>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hello Queritel Contributor,</h2>
																<p style="color:#3e434a;font-size:14px;font-weight:bold;margin:0px;">Thank you for your willingness to work with queritel.com.</p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">Click the link below or copy-paste it in your browser\'s address bar to confirm your email and proceed with your registration</p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com%2Fuser%2Fverify_email%2Fa2FkaWFuLnNhbG1vbkBxdWVyaXRlbC5jb20%253D_K8R8PXCZTK8KXO3" target="_blank" rel="noopener noreferrer">Click here to verify your account</a></p>
																<p style="color:#3e434a;font-size:13px;margin:4px 0px;">&nbsp;</p>
																<h2 style="color:#1d1e1f;font-size:29px;font-weight:600;margin:0px 0px 15px;">Hola colaborador de Queritel,</h2>
																<p style="margin:4px 0px;"><span style="font-size:13px;font-weight:bold;color:rgb(62,67,74);">Gracias por su disposiciÃ³n a trabajar con queritel.com.</span></p>
																<p style="margin:4px 0px;"><span style="font-size:13px;color:rgb(62,67,74);">Haga clic en el enlace a continuaciÃ³n o cÃ³pielo y péguelo en la barra de direcciones de su navegador para confirmar su correo electrÃ³nico y continuar con su registro</span></p>
																<p><a style="font-size:15px;margin:20px 0;color:#fff;text-decoration:none;border:2px solid #bf0000;padding:0px 20px;height:35px;line-height:32px;background:#bf0000;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com%2Fuser%2Fverify_email%2Fa2FkaWFuLnNhbG1vbkBxdWVyaXRlbC5jb20%253D_K8R8PXCZTK8KXO3" target="_blank" rel="noopener noreferrer">Haga clic aquÃ&shy; para verificar su cuenta</a></p>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="background:#3b3f46;">
												<table border="0" width="100%" cellspacing="0" cellpadding="0">
													<tbody>
														<tr>
															<td style="color:#fff;font-weight:bold;text-align:center;padding:5px 0 10px;">Find us on | Encuéntranos en :</td>
														</tr>
														<tr>
															<td style="padding-bottom:25px;">
																<table border="0" width="100%" cellspacing="0" cellpadding="0">
																	<tbody>
																		<tr>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fwww.facebook.com%2FQueritel%2F" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ffacebook.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Facebook" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ffacebook.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="%7B--%7D" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ftwitter.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Twitter" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Ftwitter.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="%7BCONF_INSTAGRAM%7D" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Finstagram.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Instagram" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Finstagram.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																			<td style="vertical-align:middle;text-align:center;">
																				<a style="color:#fff;text-decoration:none;font-size:13px;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fwww.linkedin.com%2Fcompany%2Fqueritel%2F" target="_blank" rel="noopener noreferrer"><img style="vertical-align: middle; padding: 0px 8px 0px 0px;" src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Flinkedin.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ" alt="Linkedin" width="16" data-original-src="https://office.queritel.com/index.php/apps/mail/proxy?src=http%3A%2F%2Fqueritel.com%2Fimages%2Flinkedin.png&amp;requesttoken=BZ8GWv2bGbFVniqprgq44f6umJDUxJsZ"></a>
																			</td>
																		</tr>
																	</tbody>
																</table>
															</td>
														</tr>
														<tr>
															<td style="text-align:center;color:#f2f2f2;font-size:14px;font-weight:bold;">
																<div>Thanks! Â¡Gracias!&nbsp; Queritel, <a style="color:#fff;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=http%3A%2F%2Fqueritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
																<div>
																	<br> </div>
															</td>
														</tr>
													</tbody>
												</table>
											</td>
										</tr>
										<tr>
											<td style="text-align:center;padding-bottom:10px;background:rgb(191,0,0);">
												<div style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Need help? Have feedback? Feel free to Contact&nbsp;<a style="color:#fff;" href="https://office.queritel.com/index.php/apps/mail/redirect?src=https%3A%2F%2Fqueritel.com" target="_blank" rel="noopener noreferrer">queritel.com</a></div>
												<div><span style="color:rgb(255,255,255);font-size:13px;font-weight:600;">Â¿Necesitas ayuda? Â¿Tienes comentarios? Siéntase libre de contactar queritel.com</span></div><span style="color:rgb(255,255,255);font-size:12px;font-weight:600;padding:8px 0px 0px;">Copyright Â© 2020 Queritel</span></td>
										</tr>
									</tbody>
								</table>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</tbody>
</table>
    
    ';

    //return $timezone;
    return $body;
}
function sendMail($to, $subject, $body, $extra_headers=''){
    $headers  = 'MIME-Version: 1.0' . "\r\n";
    $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

    $headers .= 'From: ' . "Queritel" . '<'. "queritel@queritel.co" . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}

//get user detail for viewing team information
function getUserDetail($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $email = stringCase($row["user_email"],STRING_CASE_LOWER);


            $result["user_id"] = $user_id;
            $result["user_ref_id"] = $row["user_ref_id"];
            $result["user_name"] = $fname . ' ' . $lname;
            $result["user_email"] = $email;
            $result["reg_date"] = $row["user_regdate"];


        }
    }

    return $result;
}


//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;


        }
    }

    return $result;
}

function network_rel_list($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];

            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;


        }
    }

    return $result;
}

function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $result["status"] = "NO_REL";

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $result["status"] = "OK";

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $result["network_id"] = $network_id;
            $result["network_role"] = $network_role;
            $result["relationship_state"] = $network_rel_state;

        }
    }


    return $result;
}

function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}
function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}

function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {
        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}


/*
 *  @uses : gets an array of the Data Collector progress at a specific job location
 *
 *  "combined_total" : 0
 *  "progress": [
{
"fname": "First",
"lname": "Last",
"response_total": 10,
"response_count": 4
},
{
"fname": "First-2",
"lname": "Last-2",
"response_total": 10,
"response_count": 2
}
]
 */
function getLocationProgress($job_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;

    $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {
        while ($row = $response_result->fetch_array())
        {
            $response_total = $row["survey_count"];
            $response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];
            $user_info = query_user($user_id, $paperweight);

            $progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            $progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            $progress[$index]["user_id"] = $user_info["user_id"];
            $progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            $progress[$index]["response_total"] = intval($response_total);
            $progress[$index]["response_count"] = intval($response_count);

            $combined_total = $combined_total + $response_count;

            $index++;

        }
    }

    $result["combined_total"] = intval($combined_total);
    $result["progress"] = $progress;

    return $result;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null)
    {

        $row = $user_result->fetch_array();

        if ($row != null)
        {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];

            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;


        }
    }

    return $result;
}

function extractActiveLocationList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];

            /*$project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;*/

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $record_found = true;

                    $location_id = $job["location_id"];
                    $location = $job["location"];
                    $location_state = $job["location_state"];
                    $lat = $job["lat"];
                    $lng = $job["lng"];
                    $country  = $job["country"];
                    $country_iso  = $job["country_iso"];
                    $response_total  = $job["response_total"];
                    $response_count  = $job["response_count"];
                    $collector_total  = $job["collector_total"];
                    $collector_count  = $job["collector_count"];
                    $progress  = $job["progress"];

                    $record = array();

                    $record["location_id"] = $location_id;
                    $record["location"] = $location;
                    $record["order_ref_id"] = $order_ref_id;
                    $record["location_state"] = $location_state;
                    $record["lat"] = $lat;
                    $record["lng"] = $lng;
                    $record["country"] = $country;
                    $record["country_iso"] = $country_iso;
                    $record["response_total"] = $response_total;
                    $record["response_count"] = $response_count;
                    $record["collector_total"] = $collector_total;
                    $record["collector_count"] = $collector_count;
                    $record["progress"] = $progress;

                    array_push($result_list,$record);

                }
            }

        }
    }

    return $result_list;
}
function extractActiveProjectList($task_data){

    $result_list = array();

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            $record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);

        }
    }

    return $result_list;
}
function extractActiveProjectData($task_data){

    $result_list = array();
    //$location_list = array();

    //$record_found = false;

    $active_jobs_ = 0;
    $active_locations_ = 0;
    $collector_total_ = 0;
    $collector_count_ = 0;
    $response_total_ = 0;
    $response_count_ = 0;



    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            $order_ref_id = $task["order_ref_id"];
            $project_name = $task["project_name"];
            $project_detail = $task["project_detail"];
            $location_count = $task["location_count"];
            $question_count = $task["question_count"];
            $collector_total = 0;
            $collector_count = 0;
            $response_total = 0;
            $response_count = 0;


            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    //$country_iso = $job["country_iso"];
                    $record_found = true;

                    $collector_total += $job["collector_total"];
                    $collector_count += $job["collector_count"];
                    $response_total += $job["response_total"];
                    $response_count += $job["response_count"];

                }
            }

            /*$record = array();

            $record["order_ref_id"] = $order_ref_id;
            $record["project_name"] = $project_name;
            $record["project_detail"] = $project_detail;
            $record["location_count"] = $location_count;
            $record["question_count"] = $question_count;
            $record["response_total"] = $response_total;
            $record["response_count"] = $response_count;
            $record["collector_total"] = $collector_total;
            $record["collector_count"] = $collector_count;

            array_push($result_list,$record);*/

            $active_jobs_ += 1;
            $active_locations_ += $location_count;
            $collector_total_ += $collector_total;
            $collector_count_ += $collector_count;
            $response_total_ += $response_total;
            $response_count_ += $response_count;

        }
    }

    $result_list["active_jobs"] = $active_jobs_;
    $result_list["active_locations"] = $active_locations_;
    $result_list["collector_total"] = $collector_total_;
    $result_list["collector_count"] = $collector_count_;
    $result_list["response_total"] = $response_total_;
    $result_list["response_count"] = $response_count_;

    /*if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }*/

    return $result_list;
}
function extractTopLocationList($task_data){
    $result_list = array();
    $location_list = array();

    $record_found = false;

    $count = count($task_data);

    if ($count > 0){
        for ($i = 0; $i < $count; $i++){
            $task = $task_data[$i];
            $job_list = $task["job_list"];
            $job_list_count = count($job_list);

            if ($job_list_count > 0){
                for ($x = 0; $x < $job_list_count; $x++){
                    $job = $job_list[$x];
                    $country_iso = $job["country_iso"];
                    $record_found = true;

                    if (isset($location_list[$country_iso])){
                        $location_list[$country_iso]["count"] += 1;
                    }
                    else{
                        $location_list[$country_iso]["iso"] = $country_iso;
                        $location_list[$country_iso]["name"] = $job["country"];
                        $location_list[$country_iso]["count"] = 1;
                    }


                }
            }

        }
    }

    if ($record_found){
        foreach ($location_list as $key => $value){
            array_push($result_list,$value);
        }
    }

    return $result_list;
}
//get the job list for viewing the location instance including the data collector progress
function getJobList($task_id,$paperweight){
    $record_found = false;
    $index = 0;

    $result["status"] = "NO_JOBS";
    $data = array();

    $location_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
    $location_result = $paperweight->query($location_query);

    if ($location_result != null)
    {
        while ($row = $location_result->fetch_array())
        {
            $record_found = true;

            $job_id = $row["job_id"];
            $address = $row["address"];
            $location_state = $row["state"];
            $lat = $row["location_lat"];
            $lng = $row["location_lon"];
            $country_name = stringCase($row["country"],STRING_CASE_CAP_EACH);
            $country_iso = stringCase($row["country_code"],STRING_CASE_UPPER);
            $response_total = $row["survey_total"];
            $collector_total = $row["researcher_required"];
            $collector_count = $row["researcher_count"];

            $progress = getLocationProgress($job_id, $paperweight);

            //the number of actually completed questionnaires
            $response_count = $progress["combined_total"];

            $data[$index]["location_id"] = $job_id;
            $data[$index]["location"] = $address;
            $data[$index]["location_state"] = $location_state;
            $data[$index]["lat"] = $lat;
            $data[$index]["lng"] = $lng;
            $data[$index]["country"] = $country_name;
            $data[$index]["country_iso"] = $country_iso;
            $data[$index]["response_total"] = $response_total;
            $data[$index]["response_count"] = $response_count;
            $data[$index]["collector_total"] = $collector_total;
            $data[$index]["collector_count"] = $collector_count;
            $data[$index]["progress"] = $progress["progress"];

            $index++;

        }
    }

    if ($record_found){
        $result["status"] = "OK";
    }

    $result["result"] = $data;

    return $result;
}

//todo : API Debug
//debugAPIResponse("update_quest",json_encode($data,JSON_PRETTY_PRINT));

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}