<?php

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting scripts

//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_RESPONSE", "survey_response");

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");


include("../includes/headers/classes.php");//has all the classes needed for queritel back-end
include("../includes/headers/miscellaneous.php");//additional functions
include("../includes/headers/strings.php");//has all the constants needed


$paperweight = new Database(MAIN_DB_USERNAME,MAIN_DB_PASSWORD,MAIN_DB_NAME);




if (isset($_POST["action"])){
    $action = $_POST["action"];
    $param_json = $_POST["param_json"];

    /**
     *  @api get_state
     *  @param survey_id
     *
     *  @return :
     *
     *  status = OK | NOT_ASSIGNED
     *  order_id
     *  publish_state = PUBLISHED | NOT_PUBLISHED
     *
     */
    if ($action == 'get_state'){
        $data = json_decode($param_json, true);

        $survey_id = clean($data["survey_id"]);

        $result["status"] = "NOT_ASSIGNED";

        //task_ref_id

        $task_query = "select * from " . TABLE_TASKS . " where survey_id = '$survey_id'";
        $task_result = $paperweight->query($task_query);

        if($task_result != null){
            $row = $task_result->fetch_array();
            if($row != null){
                $survey_ready = $row["survey_ready"];
                $task_ref_id = $row["task_ref_id"];

                if($survey_ready == 1){
                    $result["publish_state"] = "PUBLISHED";
                }
                elseif($survey_ready == 0){
                    $result["publish_state"] = "NOT_PUBLISHED";
                }
                $result["order_id"] = $task_ref_id;
                $result["status"] = "OK";
            }
        }





        echo json_encode($result);

    }

    /**
     *  @api assign
     *  @param survey_id
     *  @param order_id
     *
     *  @return :
     *
     *  status = OK | NOT_ASSIGNED
     *  order_id
     *  publish_state = PUBLISHED | NOT_PUBLISHED
     *
     */
    if ($action == 'assign'){
        $data = json_decode($param_json, true);

        $survey_id = clean($data["survey_id"]);
        $order_id = clean($data["order_id"]);

        $result["status"] = "OPERATION_FAILED";

        //task_ref_id

        $task_query = "select * from " . TABLE_TASKS . " where survey_id = '$survey_id'";
        $task_result = $paperweight->query($task_query);



        if($task_result != null && !$task_result->is_row_found()){

            $url = "https://insight.queritel.com/index.php/$survey_id?lang=en";

            $update_task = "update " . TABLE_TASKS . " set survey_url = '$url', survey_id = '$survey_id' where task_ref_id = '$order_id'";
            $update_result = $paperweight->query($update_task);

            //$result["status"] = $update_task;

            if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = "OK";

                $t_query = "select * from " . TABLE_TASKS . " where survey_id = '$survey_id'";
                $t_result = $paperweight->query($t_query);

                if($t_result != null){
                    $row = $t_result->fetch_array();
                    if($row != null){
                        $survey_ready = $row["survey_ready"];
                        $task_ref_id = $row["task_ref_id"];

                        if($survey_ready == 1){
                            $result["publish_state"] = "PUBLISHED";
                        }
                        elseif($survey_ready == 0){
                            $result["publish_state"] = "NOT_PUBLISHED";
                        }
                        $result["order_id"] = $task_ref_id;
                        //$result["status"] = "OK";
                    }
                }

            }


        }
        elseif($task_result != null && $task_result->is_row_found()){//if its found then we cant use it
            $result["status"] = "ALREADY_ASSIGNED";
            $row = $task_result->fetch_array();
            if($row != null){
                $survey_ready = $row["survey_ready"];
                $task_ref_id = $row["task_ref_id"];

                if($survey_ready == 1){
                    $result["publish_state"] = "PUBLISHED";
                }
                elseif($survey_ready == 0){
                    $result["publish_state"] = "NOT_PUBLISHED";
                }
                $result["order_id"] = $task_ref_id;
                //$result["status"] = "OK";
            }
        }


        echo json_encode($result);

    }

    /**
     *  @api publish
     *  @param survey_id
     *
     *  @return :
     *
     *  status = OK | OPERATION_FAILED
     *  order_id
     *
     */
    if ($action == 'publish'){
        $data = json_decode($param_json, true);

        $survey_id = clean($data["survey_id"]);
        //$order_id = clean($data["order_id"]);

        $result["status"] = "OPERATION_FAILED";

        //task_ref_id

        $task_query = "select * from " . TABLE_TASKS . " where survey_id = '$survey_id'";
        $task_result = $paperweight->query($task_query);

        if($task_result != null){

            $row = $task_result->fetch_array();

            $ready_state = $row["survey_ready"];
            $order_id = $row["task_ref_id"];

            if($ready_state == 0){
                $update_task = "update " . TABLE_TASKS . " set survey_ready = 1 where survey_id = '$survey_id'";
                $update_result = $paperweight->query($update_task);

                if($update_result != null && $update_result->is_row_affected()){
                    $result["status"] = "OK";
                    $result["order_id"] = $order_id;
                }
            }
            else{
                $result["status"] = "OK";
                $result["order_id"] = $order_id;
            }



        }


        echo json_encode($result);

    }

    /**
     *  @api unpublish
     *  @param survey_id
     *
     *  @return :
     *
     *  status = OK | OPERATION_FAILED
     *  order_id
     *
     */
    if ($action == 'unpublish'){
        $data = json_decode($param_json, true);

        $survey_id = clean($data["survey_id"]);
        //$order_id = clean($data["order_id"]);

        $result["status"] = "OPERATION_FAILED";

        //task_ref_id

        $task_query = "select * from " . TABLE_TASKS . " where survey_id = '$survey_id'";
        $task_result = $paperweight->query($task_query);

        if($task_result != null){

            $row = $task_result->fetch_array();

            $ready_state = $row["survey_ready"];
            $order_id = $row["task_ref_id"];

            if($ready_state == 1){
                $update_task = "update " . TABLE_TASKS . " set survey_ready = 0 where survey_id = '$survey_id'";
                $update_result = $paperweight->query($update_task);

                if($update_result != null && $update_result->is_row_affected()){
                    $result["status"] = "OK";
                    $result["order_id"] = $order_id;
                }
            }
            else{
                $result["status"] = "OK";
                $result["order_id"] = $order_id;
            }



        }


        echo json_encode($result);

    }

}
