<?php

/*
 * Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : Main class for all operations relating to customer
 */


class Customer
{

    private $db_connector;
    private $isLoggedin = false;//is the Customer logged in
    private $isActive = false;//is this Customer's account still active
    private $hasCurrentLocation = false;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //Customer details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $password = null;
    private $userName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;
    private $locationCountry = null;
    private $locationCountryCode = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $userType = null;
    private $locationAddress_1 = null;
    private $locationAddress_2 = null;
    private $userRef = null;
    private $managerId = null;
    private $storeId = null;


    function __construct(Database $db_connector)
    {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null, null);

    }

    public function get_db_connector()
    {
        return $this->db_connector;
    }

    public function isLoggedin()
    {
        return $this->isLoggedin;
    }

    public function isActive()
    {
        return $this->isActive;
    }

    public function get_userId()
    {
        return $this->userId;
    }

    public function get_loginToken()
    {
        return $this->loginToken;
    }

    public function get_email()
    {
        return $this->email;
    }

    public function get_encrytedPassword()
    {
        return $this->password;
    }

    public function get_userName()
    {
        return $this->userName;
    }

    public function get_firstName()
    {
        return $this->firstName;
    }

    public function get_lastName()
    {
        return $this->lastName;
    }

    public function get_gender()
    {
        return $this->gender;
    }

    public function get_locationCountry()
    {
        return $this->locationCountry;
    }

    public function get_locationCountryCode()
    {
        return $this->locationCountryCode;
    }

    public function get_locationState()
    {
        return $this->locationState;
    }

    public function get_locationCity()
    {
        return $this->locationCity;
    }

    public function get_registrationDate()
    {
        return $this->registrationDate;
    }

    public function get_phoneNumber()
    {
        return $this->phoneNumber;
    }

    public function getCurrentLocation()
    {
        return $this->currentLocation;
    }

    public function getUserType()
    {
        return $this->userType;
    }

    public function getUserRef()
    {
        return $this->userRef;
    }

    public function getLocationAddress1()
    {
        return $this->locationAddress_1;
    }

    public function getLocationAddress2()
    {
        return $this->locationAddress_2;
    }

    public function getManagerId()
    {
        return $this->managerId;
    }

    public function getStoreId()
    {
        return $this->storeId;
    }

    public function getHostInfo()
    {
        return $this->host_info;
    }

    public function setCurrentLocation($lat, $lon)
    {
        $currentLocation = new LocationPoint(null, null);

        if (!empty($lat) && !empty($lon)) {
            $currentLocation = new LocationPoint($lat, $lon);
        }

        $this->currentLocation = $currentLocation;

    }

    public function set_db_connector($db_connector)
    {
        $this->db_connector = $db_connector;
    }

    public function set_isLoggedin($isLoggedin)
    {
        $this->isLoggedin = $isLoggedin;
    }

    public function set_isActive($isActive)
    {
        $this->isActive = $isActive;
    }

    public function set_userId($userId)
    {
        $this->userId = $userId;
    }

    public function set_loginToken($loginToken)
    {
        $this->loginToken = $loginToken;
    }

    public function set_email($email)
    {
        $this->email = $email;
    }

    public function set_encrytedPassword($password)
    {
        $this->password = $password;
    }

    public function set_userName($userName)
    {
        $this->userName = $userName;
    }

    public function set_firstName($firstName)
    {
        $this->firstName = $firstName;
    }

    public function set_lastName($lastName)
    {
        $this->lastName = $lastName;
    }

    public function set_gender($gender)
    {
        $this->gender = $gender;
    }

    public function set_locationCountry($locationCountry)
    {
        $this->locationCountry = $locationCountry;
    }

    public function set_locationCountryCode($locationCountryCode)
    {
        $this->locationCountryCode = $locationCountryCode;
    }

    public function set_locationState($locationState)
    {
        $this->locationState = $locationState;
    }

    public function set_locationCity($locationCity)
    {
        $this->locationCity = $locationCity;
    }

    public function set_registrationDate($registrationDate)
    {
        $this->registrationDate = $registrationDate;
    }

    public function set_phoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
    }

    public function setUserType($userType)
    {
        $this->userType = $userType;
    }

    public function setUserRef($userRef)
    {
        $this->userRef = $userRef;
    }

    public function setLocationAddress1($locationAddress_1)
    {
        $this->locationAddress_1 = $locationAddress_1;
    }

    public function setLocationAddress2($locationAddress_2)
    {
        $this->locationAddress_2 = $locationAddress_2;
    }

    public function setManagerId($managerId)
    {
        $this->managerId = $managerId;
    }

    public function setStoreId($storeId)
    {
        $this->storeId = $storeId;
    }

    public function signout($user_id, $login_token)
    {
//        $user_type = USER_TYPE_RESEARCHER;
//        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";

        $result = getErrorStatus(ERROR_MSG_INVALID_LOGIN);


        if ($this->db_connector != null) {
            $login_result = $this->db_connector->query($login_check_query);
            if ($login_result != null && $login_result->is_row_found()) {
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if ($update_result != null && $update_result->is_row_affected()) {
                    $result = getOKStatus();
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;

    }

    public function login($username, $password)
    {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);

        $user_type = USER_TYPE_CUSTOMER;
        $not_deleted = 0;
        //$verified_by_admin = VERIFIED;
        //$verified_email = VERIFIED;

        $result = getErrorStatus(ERROR_MSG_INVALID_CRED);


        if ($this->db_connector != null) {
            $login_query = "select * from " . TABLE_PEOPLE . " where lower(email) = '$provided_username' and password = '$provided_password' and user_type in ('" . USER_TYPE_CUSTOMER . "')";

            $login_result = $this->db_connector->query($login_query);

            if ($login_result != null && $login_result->is_row_found()) {

                if ($row_data = $login_result->fetch_array()) {
                    $actual_uname = $row_data["email"];
                    $actual_pass = $row_data["password"];
                    $user_id = $row_data["person_id"];
                    $user_type = $row_data["user_type"];

                    if (($actual_uname == $provided_username) && ($actual_pass == $provided_password)) {

                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;

                        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state','$user_id','$user_type')";
                        $details_result = $this->db_connector->query($details_query);

                        if ($details_result != null && $details_result->is_row_affected()) {
                            //$this->isLoggedin = true;

                            $result = getOKStatus();
                            $result["user_id"] = $user_id;
                            $result["user_type"] = $user_type;
                            $result["login_token"] = $login_token;

                            return $result;
                        }

                    }

                }
            }


        }

        return $result;

    }

    public function __verifyLogin_old__($user_id, $login_token)
    {
        $not_deleted = 0;
        $login_state = LOGIN_STATE_VALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
        $user_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id' and user_type in ('" . USER_TYPE_MANAGER . "','" . USER_TYPE_EMPLOYEE . "') and deleted = '$not_deleted'";

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        if ($this->db_connector != null) {
            $login_result = $this->db_connector->query($login_check_query);
            if ($login_result != null && $login_result->is_row_found()) {
                $user_result = $this->db_connector->query($user_check_query);
                if ($user_result != null && $user_result->is_row_found()) {
                    $result = getOKStatus();

                    /*$version_data = getAPP_VERSION_DATA();

                    if (hasAgent()){
                        $result[MOBILE_VERSION_NAME] = $version_data[MOBILE_VERSION_NAME];
                        $result[MOBILE_VERSION_CODE] = $version_data[MOBILE_VERSION_CODE];
                        $result[MOBILE_VERSION_COMMENT] = $version_data[MOBILE_VERSION_COMMENT];
                        $result[MOBILE_VERSION_PRIORITY] = $version_data[MOBILE_VERSION_PRIORITY];
                    }*/

                    $this->isLoggedin = true;
                    $this->isActive = true;
                } else {
                    $result = getErrorStatus(ERROR_MSG_USER_SUSPENDED);
                }

            }
        }

        return $result;

    }

    public function verifyLogin($user_id, $login_token)
    {
        $not_deleted = 0;
        $login_state = LOGIN_STATE_VALID;
        $user_type_cus = USER_TYPE_CUSTOMER;
        $user_type_guest = USER_TYPE_GUEST;

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        if (!empty($user_id) && !empty($login_token)) {
            //if this is a customer
            $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state' and user_type = '$user_type_cus'";

            if ($this->db_connector != null) {
                $login_result = $this->db_connector->query($login_check_query);
                if ($login_result != null && $login_result->is_row_found()) {
                    $this->isLoggedin = true;
                    $this->isActive = true;

                    $result = getOKStatus();
                    $result["user_type"] = $user_type_cus;
                    $result["login_token"] = null;

                } else {
                    //if the customer is not verified : then log them in as a guest
                    $login_token = generate_token();
                    $login_time = getCurrentTime();
                    $login_state = LOGIN_STATE_VALID;

                    $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
                    $details_result = $this->db_connector->query($details_query);

                    if ($details_result != null && $details_result->is_row_affected()) {
                        $this->isLoggedin = false;
                        $this->isActive = true;

                        $result = getOKStatus();
                        //$result["user_id"] = null;
                        $result["user_type"] = $user_type_guest;
                        $result["login_token"] = $login_token;

                    }

                }
            }

        } elseif (empty($user_id) && !empty($login_token)) {
            //if this is a re-visiting guest
            $login_check_query = "select * from " . TABLE_LOGIN . " where token_id = '$login_token' and login_state = '$login_state' and user_type = '$user_type_guest'";

            if ($this->db_connector != null) {
                $login_result = $this->db_connector->query($login_check_query);
                if ($login_result != null && $login_result->is_row_found()) {
                    $this->isLoggedin = false;
                    $this->isActive = true;

                    $result = getOKStatus();
                    //$result["user_id"] = null;
                    $result["user_type"] = $user_type_guest;
                    $result["login_token"] = $login_token;

                } else {

                    $login_token = generate_token();
                    $login_time = getCurrentTime();
                    $login_state = LOGIN_STATE_VALID;

                    $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
                    $details_result = $this->db_connector->query($details_query);

                    if ($details_result != null && $details_result->is_row_affected()) {
                        $this->isLoggedin = false;
                        $this->isActive = true;

                        $result = getOKStatus();
                        //$result["user_id"] = null;
                        $result["user_type"] = $user_type_guest;
                        $result["login_token"] = $login_token;

                    }

                }
            }

        } else {
            //if this is a new guest

            $login_token = generate_token();
            $login_time = getCurrentTime();
            $login_state = LOGIN_STATE_VALID;

            $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
            $details_result = $this->db_connector->query($details_query);

            if ($details_result != null && $details_result->is_row_affected()) {
                $this->isLoggedin = false;
                $this->isActive = true;

                $result = getOKStatus();
                //$result["user_id"] = null;
                $result["user_type"] = $user_type_guest;
                $result["login_token"] = $login_token;

            }

        }

        return $result;
    }

    public function initializeCustomer($user_id, $login_token = "")
    {

        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if ($user_id != null) {
            $this->userId = $user_id;
        } else {
            return false;
        }
        if ($login_token != null) {
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_PEOPLE . " where person_id = '$user_id'";
        //$employee_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id'";

        if ($this->db_connector != null) {
            $user_result = $this->db_connector->query($user_check_query);
            //$employee_result = $this->db_connector->query($employee_check_query);

            //if(($user_result != null && $user_result->is_row_found()) && ($employee_result != null && $employee_result->is_row_found())){
            if (($user_result != null && $user_result->is_row_found())) {
                $row = $user_result->fetch_array();
                //$row_emp = $employee_result->fetch_array();


                //if($row != null && $row_emp != null){
                if ($row != null) {
                    $this->email = stringCase($row["email"]);
                    $this->password = $row["password"];
                    $this->userType = $row["user_type"];
                    $this->userRef = $row["user_ref_id"];
                    $this->locationAddress_1 = stringCase($row["address_1"]);
                    $this->locationAddress_2 = stringCase($row["address_2"]);
                    $this->phoneNumber = $row["phone_number"];
                    $this->userName = null;
                    $this->firstName = stringCase($row["first_name"], STRING_CASE_CAP_FIRST);
                    $this->lastName = stringCase($row["last_name"], STRING_CASE_CAP_FIRST);
                    $this->locationCountryCode = stringCase($row["country"], STRING_CASE_UPPER);
                    $this->managerId = $user_id;
                    //$this->managerId = $row_emp["manager_id"];
                    //if ($this->userType == USER_TYPE_MANAGER){
                    //$this->managerId = $row["person_id"];
                    //}


                    if ($row["gender"] == GENDER_MALE_CODE) {
                        $this->gender = GENDER_MALE;
                    } elseif ($row["gender"] == GENDER_FEMALE_CODE) {
                        $this->gender = GENDER_FEMALE;
                    }

                    $this->registrationDate = $row["created_on"];

                    $this->locationCountry = $row["country"];
                    $this->locationCity = $row["city"];
                    $this->locationState = $row["state"];

                    $account_deleted = $row["deleted"];

                    if ($account_deleted == 0) {
                        $this->isActive = true;
                    }
                    return true;

                }

            }
        }

        return false;
    }

    //todo: REMOVE MODULE
    public function getStoreData()
    {
        $result = array();

        $manager_id = $this->managerId;
        $user_type = USER_TYPE_MANAGER;

        $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id' and user_type = '$user_type'";
        $manager_result = $this->db_connector->query($manager_query);

        if ($manager_result != null && $manager_result->is_row_found()) {

            if ($row = $manager_result->fetch_array()) {
                $result["phone_number"] = $row["phone_number"];
                $result["store_id"] = $row["user_ref_id"];
                $result["manager_id"] = $row["person_id"];

                $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
                $store_result = $this->db_connector->query($store_query);
                if ($store_result != null && $store_result->is_row_found()) {
                    while ($config = $store_result->fetch_array()) {

                        if ($config["key"] == "company") {
                            $result["name"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "company_logo") {
                            $result["logo"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "address") {
                            $result["address"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_code") {
                            $result["currency_code"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_decimals") {
                            $result["currency_decimals"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "number_locale") {
                            $result["number_locale"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "discoverable") {
                            $result["discoverable"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "country_codes") {
                            $result["country_codes"] = text_clean($config["value"]);
                            //break;
                        }

                        if ($config["key"] == "email") {
                            $result["email"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "phone") {
                            $result["phone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "store_type") {
                            $result["store_type"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "coordinates") {
                            $result["coordinates"] = $config["value"];
                            //break;
                        }
                    }
                }

            }
        }

        return $result;
    }

    public function setProfileData($data)
    {
        $set = new stdClass();
        $set->first_name = text_clean($data['fname']);
        $set->last_name = text_clean($data['lname']);
        $set->email = text_clean($data['email']);
        $set->gender = $this->setGender(text_clean($data['fname']));
        $set->phone_number = text_clean($data['phone_number']);
        $set->address_1 = text_clean($data['location_address_1']);
        $set->address_2 = text_clean($data['location_address_2']);
        $set->city = text_clean($data['location_city']);
        $set->state = text_clean($data['location_state']);
        $set->zip = text_clean($data['country_code']);

        if ((new DB($this->db_connector))
            ->table(TABLE_PEOPLE)
            ->set($set)
            ->where(array('person_id', '=', text_clean($data['user_id'])))
            ->update()) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function setGender(string $gender)
    {
        return $gender == GENDER_FEMALE ? GENDER_FEMALE_CODE : GENDER_MALE_CODE;
    }

    public function signUp($data)
    {
        $first_name = stringCase(text_clean($data["fname"]));
        $last_name = stringCase(text_clean($data["lname"]));
        $password_txt = text_clean($data["password"]);
        $password = encryptPassword($password_txt);
        $email = stringCase(text_clean($data["email"]));
        $gender = text_clean($data["gender"]);
        if ($gender == GENDER_MALE) {
            $gender = GENDER_MALE_CODE;
        } elseif ($gender == GENDER_FEMALE) {
            $gender = GENDER_FEMALE_CODE;
        } elseif ($gender == GENDER_NOT_TO_SAY) {
            $gender = GENDER_NOT_TO_SAY_CODE;
        } else {
            $gender = null;
        }
        $phone_number = text_clean($data["phone_number"]);
        $location_address_1 = stringCase(text_clean($data["location_address_1"]));
        $location_address_2 = stringCase(text_clean($data["location_address_2"]));
        $location_city = stringCase(text_clean($data["location_city"]));
        $location_state = stringCase(text_clean($data["location_state"]));
        $postal_code = isset($data["postal_code"]) ? stringCase(text_clean($data["postal_code"])) : null;
        $country_code = stringCase(text_clean($data["country_code"]), STRING_CASE_UPPER);

        $user_type = USER_TYPE_CUSTOMER;
        $user_ref_id = generateUserReferenceId();
        $creation_time = getCurrentTime();

        $comments = null;

        $add_user = "insert into " . TABLE_PEOPLE . " (first_name, last_name, gender, phone_number, email, password, address_1, address_2, city, state, zip, country, comments, user_type, user_ref_id, created_on) values('$first_name','$last_name','$gender','$phone_number','$email', '$password','$location_address_1','$location_address_2','$location_city','$location_state','$postal_code','$country_code','$comments','$user_type','$user_ref_id','$creation_time')";
        $add_user_result = $this->db_connector->query($add_user);
        if ($add_user_result != null && $add_user_result->is_row_affected()) {
            return getOKStatus();
        }
        return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    }

    public function resetPassword(string $email)
    {
        $passwordBroker = new PasswordBroker($this->db_connector, $email);

        $token = $passwordBroker->create();

        if ($token == false) return getErrorStatus(ERROR_SENDING_EMAIL);

        return $this->sendPasswordResetNotification($token, $email);
    }

    private function sendPasswordResetNotification($token, string $email)
    {
        if ((new Notification($token, $email))->sendMail())
            return getOKStatus();
        return getErrorStatus(ERROR_SENDING_EMAIL);
    }

    public function changePassword(string $user_id, string $new_password)
    {
        $new_password = encryptPassword($new_password);

        $update_query = "update " . TABLE_EMPLOYEE . " set password = '$new_password' where person_id = '$user_id'";

        $result = getErrorStatus(ERROR_MSG_UN_CHANGED);

        if ($this->db_connector != null) {
            $update_result = $this->db_connector->query($update_query);
            if ($update_result != null && $update_result->is_row_affected()) {
                $result = getOKStatus();
            }
        }

        return $result;
    }

    public function setCart($data)
    {

        $product_id = text_clean($data['product_id']);
        $quantity = text_clean($data['quantity']);
        $unit_price = text_clean($data['unit_price']);
        $person_id = text_clean($data['user_id']);
        $store_id = text_clean($data['store_id']);
        $query = "insert into " . TABLE_CART . " (`product_id`,`quantity`,`unit_price`, `person_id`,`store_id`) VALUES ('$product_id','$quantity','$unit_price','$person_id','$store_id')";

        if ($this->db_connector != null) {
            $select_result = $this->db_connector->query($query);
            if (!is_null($select_result) && $select_result->is_row_affected()) return getOKStatus();
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);

    }

    public function getCartList(string $user_id, string $store_id)
    {

//        $query = "select product_id, unit_price, quantity, product_image_url from " . TABLE_CART . " WHERE `person_id` = '$user_id' and `store_id` = '$store_id'";
        $query = "select product_id, I.unit_price, quantity, pic_filename as product_image_url
from ospos_cart C
         left outer join ospos_items I on C.product_id = I.item_id
WHERE `person_id` = '$user_id'
  and `store_id` = '$store_id'";
//        $query1 = "select json_object('total', sum(unit_price)) as total,
//       concat(
//               '[',
//               group_concat(json_object(
//                       'unit_price', unit_price,
//                       'product_id', product_id,
//                       'quantity', quantity,
//                       'pic_filename', pic_filename
//                   ))
//           ,
//               ']'
//           )                                 as items
//from (select product_id, I.unit_price, quantity, pic_filename
//      from ospos_cart C
//               left outer join ospos_items I on C.product_id = I.item_id
//      WHERE `person_id` = '$user_id'
//        and `store_id` = '$store_id') as items";

        if (!is_null($this->db_connector)) {
            $select_query = $this->db_connector->query($query);

//            $row = $select_query->fetch_assoc();
//            $res = $row['total'];
//            $res['status'] = getOKStatus();
//            $items = $row['items'];
//            foreach ($items as )
            $res = getOKStatus();
            $vals = array();
            $sum = 0;
            while ($row = $select_query->fetch_assoc()) {
                $row['product_id'] = intval($row['product_id']);
                $row['unit_price'] = doubleval($row['unit_price']);
                $row['quantity'] = doubleval($row['quantity']);
                $row['product_image_url'] = IMG_ITEM_ROOT . $row['product_image_url'];
                array_push($vals, $row);
                $sum += doubleval($row['unit_price']);
            }
            $res['total'] = doubleval($sum);
            $res['cart_product_list'] = $vals;
            return $res;
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);

    }

    public function completeSale($data, $user_id)
    {
        $result = getErrorStatus(ERROR_MSG_INVALID_LOGIN);

        if ($this->db_connector != null) {
            try {

                $this->db_connector->transaction();
                $sale_id = $this->sales($data, $user_id);
                if (!$sale_id) throw new Exception("sale not completed");
                if (!$this->saleItems($data['product_list'], $sale_id)) throw new Exception("sale items not inserted to db");
//                if (!$this->salesPayments($sale_id, $data)) throw new Exception("sale payments not inserted");
                $this->db_connector->commit();

                $result = getOKStatus();
                $result['order_id'] = $sale_id;
                return $result;

            } catch (Exception $exception) {
                $this->db_connector->rollback();
            }
        }

        return $result;
    }

    protected function saleItems($items, $sale_id)
    {

        $Query = "INSERT INTO " . TABLE_SALES_ITEMS . " (SALE_ID, ITEM_ID, QUANTITY_PURCHASED, ITEM_UNIT_PRICE, DISCOUNT, DISCOUNT_TYPE) VALUES ";
        $update_quantities = array();
        foreach ($items as $item) {

            $product_id = text_clean($item['product_id']);
//            $description = text_clean($item['description']);
            $quantity_purchased = text_clean($item['quantity']);
            $unit_price = text_clean($item['unit_price']);
//            $item_cost_price = floatval($unit_price) * intval($quantity_purchased);
            $discount_type = text_clean($item['discount_type']) == DISCOUNT_TYPE_PERCENTAGE ? '0' : '1';
            $discount = text_clean($item['discount']);

            $value = new stdClass();
            $value->quantity = text_clean($item['quantity']);
            $value->item_id = text_clean($item['product_id']);

            array_push($update_quantities, $value);
            $Query .= "('$sale_id','$product_id', '$quantity_purchased', '$unit_price', '$discount', '$discount_type'),";
        }
        $Query = rtrim($Query, ",");

        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                (new Item($this->db_connector))->updateProductQuantities($update_quantities, 'sale');
                return true;
            }
        }

        return false;
    }

    public function addStore(string $store_id, string $user_id)
    {
        $insert = new stdClass();
        $insert->customer_id = $user_id;
        $insert->store_id = $store_id;

        $res = (new DB($this->db_connector))->rawQuery(get_insert_query(TABLE_CUSTOMER_STORES, array($insert)))->insert();

        if ($res) {
            $res = getOKStatus();
            $res['store_id'] = $store_id;
            $store = $this->getStoreInfo(array('manager_id' => $this->getManagerIdByStoreId($store_id)));
            $res['store_name'] = $store['name'];
            $res['currency_code'] = $store['currency_code'];
            return $res;
        }
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function removeStore(string $store_id, string $user_id): array
    {
        $set = new stdClass();
        $set->deleted = 1;

        $where = new stdClass();
        $where->customer_id = $user_id;
        $where->store_id = $store_id;

        $res = (new DB($this->db_connector))->rawQuery(get_update_query(TABLE_CUSTOMER_STORES, $set, $where))->update();

        if ($res) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function getStoreList(string $user_id)
    {

        $Stores = array();
        $managers = $this->getStoreManagersByUser($user_id);
//        echo json_encode($managers);
        foreach ($managers as $store) {
//            echo json_encode($store);
            $Store = array();
            $Store["store_id"] = $store["user_ref_id"];
            $Store["manager_id"] = $store["person_id"];

            $result = $this->getStoreInfo($Store);

            $is_connected = false;
            if ($this->isLoggedin()) {
                $is_connected = checkCustomerLink($Store["store_id"], $this->db_connector, $this);
            }

            if (!isset($result["coordinates"])) {
                $result["coordinates"] = array("lat" => null, "lng" => null);
            }
            if (!isset($result["discoverable"])) {
                $result["discoverable"] = false;
            }
            if (!isset($result["store_type"])) {
                $result["store_type"] = STORE_TYPE_GROCERYSTORE;
            }


            $result["is_connected"] = $is_connected;

            array_push($Stores, $result);
        }

        $res = getOKStatus();
        $res['store_list'] = $Stores;
        return $res;

    }

    public function getCartsStoreList()
    {
        $Query = "select ifnull(
               CONCAT(
                       '[',
                       GROUP_CONCAT(JSON_OBJECT(
                               'store_id', store_id,
                               'store_name', value
                           )),
                       ']'
                   ),
               '[]') as cart_stores
from (select distinct store_id, AP.`value`
      from ospos_cart C
               inner join ospos_people P on user_ref_id = store_id
               inner join ospos_app_config AP on P.person_id = AP.manager_id
      where AP.`key` = 'company')
         as cart_stores";
        if (is_null($this->db_connector)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['cart_store_list'] = json_decode(($this->db_connector->fetch_assoc($Query))['cart_stores']);
        return $res;
    }

    protected function salesPayments($sale_id, $data)
    {
        $payment_type = text_clean($data['payment_method']);
        $payment_amount = text_clean($data['payment_total']);
        $employee_id = text_clean($data['user_id']);

        $Query = "INSERT INTO " . TABLE_SALES_PAYMENTS . " (sale_id, payment_type, payment_amount, employee_id) VALUES ('$sale_id', '$payment_type', '$payment_amount', '$employee_id')";
        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                return true;
            }
        }

        return false;
    }

    protected function sales($data, $user_id)
    {
        $store_id = text_clean($data['store_id']);
        $pickup_date = text_clean($data['pickup_date']);
        $manager = $this->getManagerIdByStoreId($store_id);

        $Query = "insert into ospos_sales (customer_id, store_id, manager_id, pickup, sale_status)
values ($user_id, '$store_id', '$manager','$pickup_date', 1)";

//        $Query = "INSERT INTO " . TABLE_SALES . " (customer_id, comment, invoice_number, quote_number, sale_type, manager_id) VALUES ('$customer_id', '$comment', '$invoice_number', '$quote_number', '$sale_type', '$user_id')";
        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                return $insert_query->insert_id();
            }
        }

        return false;
    }

    private function getStoreManagersByUser(string $user_id)
    {
        $Query = "select person_id, user_ref_id from ospos_people where user_ref_id in (select store_id from ospos_customer_stores where customer_id = $user_id and deleted = 0)";

        if ($this->db_connector != null) {
            $select_query = $this->db_connector->query($Query);
            if ($select_query != null && $select_query->is_row_found()) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    array_push($res, $row);
                }
                return $res;
//                return $select_query->fetch_array();
            }

        }

        return array();
    }

    private function getStoreInfo($result)
    {

        $manager_id = $result['manager_id'];
        $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
        $store_result = $this->db_connector->query($store_query);
        if ($store_result != null) {
            while ($row2 = $store_result->fetch_array()) {
                if ($row2["key"] == "address") {
                    $result["address"] = $row2["value"];
                }
                if ($row2["key"] == "company") {
                    $result["name"] = stringCase($row2["value"], STRING_CASE_CAP_EACH);
                    //$result["name"] = "Keviñ";
                }
                if ($row2["key"] == "company_logo") {
                    $result["logo_url"] = IMG_LOGO_ROOT . $row2["value"];
                }

                if ($row2["key"] == "currency_code") {
                    $result["currency_code"] = stringCase($row2["value"], STRING_CASE_UPPER);
                }
                if ($row2["key"] == "currency_decimals") {
                    $result["currency_decimals"] = intval($row2["value"]);
                    //break;
                }
                if ($row2["key"] == "country_codes") {
                    $result["country_codes"] = stringCase($row2["value"], STRING_CASE_UPPER);
                }
                if ($row2["key"] == "email") {
                    $result["email"] = stringCase($row2["value"]);
                }
                if ($row2["key"] == "number_locale") {
                    $result["number_locale"] = ($row2["value"]);
                }
                if ($row2["key"] == "discoverable") {
                    $result["discoverable"] = ($row2["value"] == 1);
                }
                if ($row2["key"] == "phone") {
                    $result["phone_number"] = ($row2["value"]);
                }
                if ($row2["key"] == "store_type") {
                    $result["store_type"] = stringCase($row2["value"]);
                }
                if ($row2["key"] == "coordinates") {
                    $result["coordinates"] = (empty($row2["value"]) ? array("lat" => null, "lng" => null) : json_decode($row2["value"], true));
                }

            }

            return $result;

        }

    }

    public function getOrder($order_id)
    {
        $order_model = new Order($this->db_connector, $order_id);
        $order_data = $order_model->getSalesById();
        if ($order_data == null) return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = getOKStatus();
        $order_items = $order_model->getSaleItemsByOrderId();
        if ($order_items != null) $order_data['product_list'] = $order_items;
        $result['order_data'] = $order_data;
        return $result;
    }

    private function getManagerIdByStoreId(string $store_id)
    {
        $Query = "select person_id from ospos_people where user_ref_id = '$store_id'";

        if ($this->db_connector != null) {
            $select_query = $this->db_connector->query($Query);
            if ($select_query != null && $select_query->is_row_found()) {

                return ($select_query->fetch_object())->person_id;
            }

        }

        return null;
    }

}