<?php


class ProductsService
{
    var $conn;
    var $user_id;

    /**
     * ProductsService constructor.
     * @param Database $cornersave
     * @param null $getManagerId
     */
    public function __construct(\Database $cornersave, $getManagerId)
    {
        $this->conn = $cornersave;
        $this->user_id = $getManagerId;
    }

    public function getProductList($data, $store_id)
    {
        $search_id = text_clean($data["search_id"]);
//        $search_limit = text_clean($data["search_limit"]);
//        $offset_index = text_clean($data["offset_index"]);
        $category_id = text_clean($data["category_id"]);

//        $limit_from = intval($offset_index);
//        $row_count = $search_limit;

        $category_id_check = null;
        $category_name = null;

        if (!empty($category_id)) {
            $category_name = generate_category_name($category_id);
            $category_id_check = " and category = '$category_name' ";
        }

        $managerQ = "select person_id from ospos_people where user_ref_id = '$store_id'";
//        $managerQ = "select person_id from ospos_people where user_ref_id in (select store_id from ospos_customer_stores where customer_id = $this->user_id)";
//        echo "ew\n$managerQ\n";

        $mana = $this->getManager($managerQ);


        if (!empty($search_id)) {
            $sql_query = "select I.item_id as product_id, name as product_name, category as product_category, unit_price, cost_price, featured, brand, unit_value, unit_label, pic_url, pic_filename as image_name, catalog_id, product_type, item_number as barcode, IQ.quantity from " . TABLE_ITEMS . " I left outer join " . TABLE_ITEM_QUANTITY . " IQ on I.item_id = IQ.item_id where unit_price is not null and unit_price > 0 and deleted = 0 and manager_id in ($managerQ) $category_id_check and ((`name` like '%$search_id%') or (`item_number` like '%$search_id%') or (`brand` like '%$search_id%')) order by `name` asc";
//            $sql_query = "select * from " . TABLE_ITEMS . " where deleted = 0 and manager_id = '$this->manager_id' $category_id_check and ((`name` like '%$search_id%') or (`item_number` like '%$search_id%') or (`brand` like '%$search_id%')) order by `name` asc limit $row_count offset $limit_from";
        } else {
//            $sql_query = "select * from " . TABLE_ITEMS . " where deleted = 0 and manager_id = '$this->manager_id' $category_id_check limit $row_count offset $limit_from ";
            $sql_query = "select I.item_id as product_id, name as product_name, category as product_category, unit_price, cost_price, featured, brand, unit_value, unit_label, pic_url, pic_filename as image_name, catalog_id, product_type, item_number as barcode, IQ.quantity from " . TABLE_ITEMS . " I left outer join " . TABLE_ITEM_QUANTITY . " IQ on I.item_id = IQ.item_id where unit_price is not null and unit_price > 0 and deleted = 0 and manager_id in ($managerQ) $category_id_check ";
        }

//        echo $sql_query;
        $res = (new Products($this->conn, $mana))
            ->findAll($sql_query);
        if (is_null($res)) $res = array();
        $result = getOKStatus();
        $result['product_list'] = $res;
        return $result;
    }

    private function getManager($query)
    {

//        $Query = "select person_id from ospos_people where user_ref_id in (select store_id from ospos_customer_stores where customer_id = $user_id)";

        if ($this->conn != null) {
            $select_query = $this->conn->query($query);
            if ($select_query != null && $select_query->is_row_found()) {
                $res = '';
//                while ($row = $select_query->fetch_assoc()) {
//                    echo $row['person_id'];
//                    $res .= $row['person_id'].",";
//                }
//                $res = rtrim($res, ",");
//                return $res;
                return ($select_query->fetch_object())->person_id;
            }

        }

        return '';

    }
}