<?php


class DB
{


    var $table;
    var $conn;
    var $set;
    var $where;
    var $query;
    var $rawQuery = '';

    /**
     * DB constructor.
     * @param $table
     */
    public function __construct($database)
    {
        $this->conn = $database;
    }

    public function table($table)
    {
        $this->table = $table;
        return $this;
    }

    public function set($set)
    {
        foreach ($set as $key => $value) {
            $this->set .= " $key = '" . $value . "',";
        }

        $this->set = rtrim($this->set, ", ");
        return $this;
    }

    public function where($key)
    {
        $this->where .= " " . $key[0] . " " . $key[1] . " " . $key[2];
        return $this;
    }

    public function rawQuery($query)
    {
        $this->rawQuery = $query;
        return $this;
    }

    public function andWhere(array $key)
    {
        $this->where .= " and " . $key[0] . " " . $key[1] . " " . $key[2];
        return $this;
    }

    public function update()
    {
        if ($this->rawQuery != '') $this->query = $this->rawQuery;
        else $this->query = "update " . $this->table . " set " . $this->set . " where " . $this->where;
//        echo "\n $this->query\n";
        return !is_null($this->conn) && $this->conn->update($this->query);
    }

    public function select(array $array)
    {
        return $this;
    }

    public function buildQuery()
    {
        if ($this->rawQuery != '') {
            $this->query = $this->rawQuery;
            return;
        };
        if (!empty($this->select)) {
            $this->query .= $this->select;
        } else {
            $this->query .= " * ";
        }
        $this->query .= " from " . $this->table;
        if (!empty($this->left_outer_join)) {
            $this->query .= $this->left_outer_join;
        }
        if (!empty($this->where)) {
            $this->query .= " where" . $this->where;
        }
    }


    private function formatDBResponse($row)
    {
        if (isset($row['stock_type'])) $row['stock_type'] = $row['stock_type'] == 1 ? "non_stock" : "stock";
        if (isset($row['reorder_level'])) $row['reorder_level'] = intval($row['reorder_level']);
        if (isset($row['quantity'])) $row['quantity'] = intval($row['quantity']);
        if (isset($row['product_id'])) $row['product_id'] = intval($row['product_id']);
        if (isset($row['featured'])) $row['featured'] = $row['featured'] == 1;
        if (isset($row['cost_price'])) $row['cost_price'] = floatval($row['cost_price']);
        if (isset($row['unit_price'])) $row['display_price'] = $row['unit_price'];
        if (isset($row['unit_price'])) $row['unit_price'] = floatval($row['unit_price']);
        if (isset($row['receiving_id'])) $row['receiving_id'] = intval($row['receiving_id']);
        if (isset($row['received_by_id'])) $row['received_by_id'] = intval($row['received_by_id']);
        if (isset($row['supplied_by_id'])) $row['supplied_by_id'] = intval($row['supplied_by_id']);
        if (isset($row['product_list'])) $row['product_list'] = json_decode($row['product_list']);
        if (isset($row['chart_data'])) $row['chart_data'] = json_decode($row['chart_data']);
        if (isset($row['transaction_data'])) $row['transaction_data'] = json_decode($row['transaction_data']);
        if (isset($row['customers'])) $row['customers'] = json_decode($row['customers']);
        if (isset($row['employee_list'])) $row['employee_list'] = json_decode($row['employee_list']);
        return $row;
    }

    private function getItem(string $query)
    {
        $select_query = $this->conn->query($query);
        if (is_null($select_query)) return null;
        return $this->formatDBResponse($select_query->fetch_assoc());
    }


    private function getList(string $query)
    {
        $select_query = $this->conn->query($query);
        if (is_null($select_query)) return null;
        $result = array();
        while ($row = $select_query->fetch_assoc()) {
            array_push($result, $this->formatDBResponse($row));
        }
        return $result;
    }

    public function findAll()
    {
        $this->buildQuery();
//        if ($this->rawQuery == '') $this->buildQuery();
//        else $this->query = $this->rawQuery;
        echo "\n$this->query\n";
        return is_null($this->conn) ? null : $this->getList($this->query);
    }

    public function findOne()
    {
        $this->buildQuery();
        return is_null($this->conn) ? null : ($this->getItem($this->query));
    }

    public function insert()
    {
        $this->buildQuery();
        return !is_null($this->conn) && $this->conn->insert($this->query);
    }
}