<?php


class Products
{

    var $conn;
    private $manager_id;

    /**
     * Products constructor.
     * @param Database $conn
     * @param int $manager_id
     */
    public function __construct(\Database $conn, $manager_id)
    {
        $this->conn = $conn;
        $this->manager_id = $manager_id;
    }

    public function findAll(string $sql_query)
    {
        if (is_null($this->conn)) return null;
        $result = $this->conn->query($sql_query);
        $res = array();
        if (is_null($result)) return $res;

        $currency = (new Config($this->conn, $this->manager_id))->getConfigValue(array('currency_code'));
        while ($row = $result->fetch_assoc()) {

            if (isset($row['quantity'])) $row['quantity'] = intval($row['quantity']);
            if (isset($row['product_id'])) $row['product_id'] = intval($row['product_id']);
            if (isset($row['featured'])) $row['featured'] = $row['featured'] == 1;
            if (isset($row['cost_price'])) $row['cost_price'] = floatval($row['cost_price']);
            if (isset($row['unit_price'])) $row['display_price'] = intval($row['unit_price']);
            if (isset($row['unit_price'])) $row['unit_price'] = floatval($row['unit_price']);
            $row['currency'] = $currency['value'];
            $row['pic_url'] = IMG_ITEM_ROOT . $row['image_name'];
            array_push($res, $row);
        }

        return $res;
    }
}