<?php


/**
 * Class Customer
 */
class Customer
{

    /**
     * @var
     */
    var $conn;
    /**
     * @var mixed|string
     */
    var $manager_id;


    /**
     * Customer constructor.
     * @param $conn
     * @param string $manager_id
     */
    public function __construct($conn, $manager_id = '')
    {
        $this->conn = $conn;
        $this->manager_id = $manager_id;
    }

    /**
     * @param $object
     * @return bool
     */
    public function updateVerifiedUser($object): bool
    {
        $discount_type = $this->getDiscount($object->discount_type);
        $Query = "UPDATE ospos_customers SET points = $object->points, discount_type = $discount_type, discount = $object->discount where id = $object->customer_id and manager_id = $this->manager_id";

        return !is_null($this->conn) && $this->conn->update($Query);
    }

    private function getDiscount($discount_type): int
    {
        if ($discount_type == DISCOUNT_TYPE_FIXED) return DISCOUNT_TYPE_FIXED_CODE;
        else  return DISCOUNT_TYPE_PERCENT_CODE;
    }

    public function delete($customer_id): bool
    {
        $Query = "update ospos_customers set deleted = '1' where person_id = $customer_id and manager_id = $this->manager_id";
        return !is_null($this->conn) && $this->conn->update($Query);
    }
}