<?php


class ExpenseCategory
{

    var $conn;

    /**
     * ExpenseCategory constructor.
     * @param Database $db_connector
     */
    public function __construct(\Database $db_connector)
    {
        $this->conn = $db_connector;
    }

    public function getList($manager_id): ?array
    {
        $query = "select expense_category_id as category_id, category_name, category_description
from " . TABLE_EXPENSE_CATEGORIES;


        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            if (!is_null($select_query)) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['category_id'] = intval($row['category_id']);
                    array_push($res, $row);
                }

                return $res;
            }
        }

        return null;
    }

    public function add(array $values)
    {
        $query = get_insert_query(TABLE_EXPENSE_CATEGORIES, $values);
        if (!is_null($this->conn)) {
            return $this->conn->get_insert_id($query);
        }
        return null;
    }

    public function deleted(stdClass $set, stdClass $where)
    {
        $query = get_update_query(TABLE_EXPENSE_CATEGORIES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }
}