<?php


class Supplier
{
    private $conn;
    private $person_id;

    public function __construct($db_connector, $person_id = '')
    {
        $this->conn = $db_connector;
        $this->person_id = $person_id;
    }

    public function getSupplierList()
    {
        $Query = "SELECT S.person_id AS supplier_id, S.company_name, P.email, P.phone_number, S.category as supplier_category FROM " . TABLE_SUPPLIERS . " S inner join " . TABLE_PEOPLE . " P on S.person_id = P.person_id AND S.deleted = '0' where S.manager_id = " . $this->person_id;
        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $supplier = $row;
                    $supplier['supplier_id'] = intval($row['supplier_id']);
                    $supplier['supplier_category'] = $this->getSupplierType($row['supplier_category']);
                    array_push($res, $supplier);
                }
                return $res;
            }
        }

        return null;
    }

    public function getMarketSupplierList()
    {
        $Query = "SELECT S.person_id AS supplier_id, S.company_name, P.email, P.phone_number, S.category as supplier_category, supplier_url, is_connected FROM " . TABLE_SUPPLIERS . " S inner join " . TABLE_PEOPLE . " P on S.person_id = P.person_id AND S.deleted = '0'";
        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $supplier = $row;
                    $supplier['supplier_id'] = intval($row['supplier_id']);
                    $supplier['supplier_category'] = $this->getSupplierType($row['supplier_category']);
                    $supplier['is_connected'] = $this->getSupplierType($row['supplier_category']) == 1;
                    array_push($res, $supplier);
                }
                return $res;
            }
        }

        return null;
    }

    public function getSupplierById()
    {
        $Query = "SELECT S.person_id AS supplier_id, S.company_name, P.last_name as lname, P.first_name as fname, CASE  WHEN P.gender = 1 THEN 'male' when P.gender = '2' then 'female' else 'not_to_say' end           as gender, P.email, P.phone_number, P.address_1 as location_address_1, P.address_2 as location_address_2, P.city as location_city, P.state as location_state, P.zip as postal_code, IF(P.country = '', null , P.country) as country_code, P.comments, S.account_number, S.tax_id, S.category as supplier_category FROM " . TABLE_SUPPLIERS . " S inner join " . TABLE_PEOPLE . " P on S.person_id = P.person_id where S.person_id = '$this->person_id'";

        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null && $select_query->is_row_affected()) {
                $row = $select_query->fetch_assoc();
                $row['supplier_id'] = intval($row['supplier_id']);
                return $row;
            }
        }

        return null;
    }

    /**
     * @return false
     */
    public function deleteSupplier(): bool
    {
        $Query = "UPDATE " . TABLE_SUPPLIERS . " SET deleted = '1' WHERE person_id = '$this->person_id'";

        if ($this->conn != null) {
            return $this->conn->update($Query);
        }

        return false;
    }

    /**
     * @param $category_id
     * @return string
     */
    public static function getSupplierType($category_id): string
    {
        if ($category_id == 0) return GOODS_SUPPLIER;
        else return COST_SUPPLIER;
    }

    protected function getSupplierIdByType($category_id): string
    {
        if ($category_id == GOODS_SUPPLIER) return CODE_SUPPLIER_GOOD;
        else return CODE_COST_GOOD;
    }

    public function addSupplier($object, $person_id): bool
    {
        $category = $this->getSupplierIdByType($object->supplier_category);

        $Query = "INSERT INTO ospos_suppliers (person_id, company_name, agency_name, account_number, tax_id, category,
                             manager_id)
VALUES ($person_id, '$object->company_name', '', '$object->account_number', '$object->tax_id', '$object->tax_id', $category)";

        if ($this->conn != null) return $this->conn->insert($Query);

        return false;
    }
}