<?php


class OrderService
{
    var $db_connector;
    var $manager_id;

    /**
     * OrderService constructor.
     * @param $cornersave
     */
    public function __construct($cornersave, $manager_id)
    {
        $this->db_connector = $cornersave;
        $this->manager_id = $manager_id;
    }

    public function confirm_online_order($order_id)
    {
        $set = new stdClass();
        $set->is_online = 1;
        $set->sale_status = 3;

        $where = new stdClass();
        $where->sale_id = $order_id;

        if ((new Order($this->db_connector))->mark_order_delivered($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function mark_order_delivered($order_id)
    {
        $set = new stdClass();
        $set->is_delivered = 1;
        $set->sale_status = 0;

        $where = new stdClass();
        $where->sale_id = $order_id;

        if ((new Order($this->db_connector))->mark_order_delivered($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function cancelOrder(string $order_id, $getManagerId): array
    {
        $set = new stdClass();
        $set->customer_cancel = 1;
        $set->sale_status = 2;

        $where = new stdClass();
        $where->sale_id = $order_id;
        $where->manager_id = $getManagerId;

        if ((new Order($this->db_connector))->updateOrder($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function suspendSale($data, $getManagerId): array
    {
        try {

//            $this->db_connector->transaction();

            if (!$this->suspendMainSale($data, $getManagerId)) throw new Exception("sale suspension failed");

//            if (!$this->suspendSaleItems($data['product_list'], $data['order_id'], $getManagerId)) throw new Exception("sale items suspension failed");

//            $this->db_connector->commit();

            $result = getOKStatus();
            $result['order_id'] = text_clean($data['order_id']);

            return $result;

        } catch (Exception $e) {
            $this->db_connector->rollback();
            debugAPIResponse(ACTION_SUSPEND_SALE, $e);
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function suspendMainSale($data, $getManagerId)
    {

        $set = new stdClass();
        $set->sale_status = 1;

        $where = new stdClass();
        $where->sale_id = text_clean($data['order_id']);

        return (new Order($this->db_connector))->updateOrder($set, $where);
    }

    private function suspendSaleItems(mixed $product_list, mixed $order_id, $getManagerId)
    {
        return false;
    }

    public function getOrderList()
    {
        $list = (new Order($this->db_connector))->getOrderList($this->manager_id);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['order_list'] = $list;
        return $result;
    }
}