<?php


class ReportingService
{

    var $connection;
    var $manager;
    public $query;

    /**
     * ReportingService constructor.
     * @param $cornersave
     * @param $getMechantId
     */
    public function __construct($cornersave, $getMechantId)
    {
        $this->connection = $cornersave;
        $this->manager = $getMechantId;
        $this->query = new Query($cornersave);
    }

    public function getTransactionList()
    {
        $query = $this->query->rawQuery((new Reporting)->getTrnList($this->manager))->findOne();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['transaction_data'] = $query['transaction_data'];
        return $res;
    }

    public function getCustomerList()
    {
        $query = $this->query->rawQuery((new Reporting)->getCustomerListQuery($this->manager))->findOne();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['customers'] = $query['customers'];
        return $res;
    }

    public function getTrnChart()
    {
        $query = $this->query->rawQuery((new Reporting())->getTrnChartQuery($this->manager))->findOne();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);

        $chart_data = $query['chart_data'];
        $max = PHP_INT_MIN;
        $min = PHP_INT_MAX;
        foreach ($chart_data as $data) {
            $max = max($max, $data->revenue);
            $min = min($min, $data->revenue);
        }
        $res = getOKStatus();
        $res['max_revenue'] = $max;
        $res['min_revenue'] = $min;
        $res['chart_data'] = $chart_data;
        return $res;
    }

    public function getDiscountList()
    {
    }

    public function getCustomerChartData()
    {
    }

    public function getDiscountChartData()
    {
    }

    public function getEmployeeList()
    {
        $query = $this->query->rawQuery((new Reporting)->getEmployeeListQuery($this->manager))->findOne();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['employee_list'] = $query['employee_list'];
        return $res;
    }

    public function getEmployeeChartData()
    {
    }

    public function getSupplierList()
    {
    }

    public function getSupplierChartData()
    {
    }

    public function getPaymentList()
    {
    }

    public function getPaymentChartData()
    {
    }

    public function getItemList()
    {
        $query = $this->query->rawQuery((new Reporting)->getItemList($this->manager))->findAll();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['inventory_data'] = $query;
        return $res;
    }

    public function getItemChartData()
    {
    }

    public function getCategoryList()
    {
    }

    public function getCategoryChartData()
    {
    }

    public function getLowInvList()
    {
        $query = $this->query->table(TABLE_ITEMS)
            ->select(array('reorder_level', 'receiving_quantity as quantity', 'name as product_name', 'item_number as barcode', 'stock_type'))
            ->where(array('reorder_level', '>=', 'receiving_quantity'))
            ->andWhere(array('manager_id', '=', $this->manager))
            ->findAll();

        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['inventory_data'] = $query;
        return $res;
    }

    public function getSummaryInventoryList()
    {
        $query = $this->query->table(TABLE_ITEMS)
            ->select(array('reorder_level', 'receiving_quantity as quantity', 'category as category_name', 'cost_price', 'unit_price',
                'name as product_name', 'item_number as barcode', 'stock_type', 'item_number as barcode'))
            ->where(array('manager_id', '=', $this->manager))
            ->findAll();

        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['inventory_data'] = $query;
        return $res;
    }

    public function getReceivingList()
    {
        $query = $this->query->rawQuery((new Reporting)->getReceivingListQuery($this->manager))->findAll();
        if (is_null($query)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['receiving_data'] = $query;
        return $res;
    }
}