<?php


class SubscriptionsService
{
    private $package_list;
    private $filter;
    private $db_connector;

    /**
     * Subscriptions constructor.
     * @param Database $db_connector
     * @param $package_list
     * @param $filter
     */
    public function __construct($db_connector, $package_list, $filter)
    {
        $this->filter = $filter;
        $this->package_list = $package_list;
        $this->db_connector = $db_connector;
    }

    public function getPackages(): array
    {
        $res = getOKStatus();
        $package_list = array();
        $subscription = new Subscription($this->db_connector);

        if (!empty($this->package_list)) {


            try {
                foreach ($this->package_list as $package) {
                    $package_store = ($subscription->getPackageData($package));
                    if (isset($package_store) && $package_store['package_id'] != null) {
                        $package_store['cordinates'] = json_decode($package_store['cordinates']);
                        array_push($package_list, $package_store);
                    }
                }
            } catch (Exception $ex) {
                die($ex);
            }
            $res['package_list'] = $package_list;

        } else {
            try {
                $package_store = ($subscription->getPackageDataByFilter($this->filter));
                $res['package_list'] = $package_store;
            } catch (Exception $ex) {
                die($ex);
            }
        }

        return $res;
    }
}