<?php

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');
/**
 * @Author : Kadian Salmon
 * Date : Sep 16, 2019
 * Purpose : process all api request for mobile application
 * @link : https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?agent=android
 * @link : https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?agent=ios
 *
 */

//------------------------------------------
define("QUESTION_SET", 10);//respondents per location
define("RESEARCHER_PER_LOC", 4);//researcher per location

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("INSIGHT_DB_USERNAME", "initia19_lime880");
define("INSIGHT_DB_PASSWORD", "[2ST4)V2p6");
define("INSIGHT_DB_NAME", "initia19_lime880");
define("INSIGHT_DOMAIN", "insight.queritel.com");

define("PASSWORD_SALT","ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK","OK");
define("STATUS_ERROR","ERROR");
/*{
    "status": "ERROR",
    "error": {
        "name": "opFailed", //([ERROR NAME CONSTANTS])
        "message": "INV_TKN" | "USR_SPND" | "UNK_ERR" //([ERROR MESSAGE CONSTANTS])
    }
}*/

define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED","LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");


//ERROR NAME CONSTANTS
define("ERROR_NAME_OP_FAILED","opFailed");

//ERROR MESSAGE CONSTANTS
define("ERROR_MSG_INVALID_CRED","INV_CR"); //("The Credentials provided are invalid")
define("ERROR_MSG_INVALID_LOGIN","INV_LGN");//("The user is not Logged in")
define("ERROR_MSG_INVALID_TOKEN","INV_TKN");//("The Login token is invalid") {re-entering the password is needed}
define("ERROR_MSG_USER_SUSPENDED","USR_SPND");//("The account has been suspended")
define("ERROR_MSG_USER_DEACTIVATED","USR_DEAC");//("The account has been deactivated")
define("ERROR_MSG_USER_UNKNOWN","UNK_ERR");//("An unknown error was encountered")
define("ERROR_MSG_USER_ACC_DUPLICATE","ACC_DUPLICATE");//("The user already exist")
define("ERROR_MSG_INVALID_TAX_ID","INV_TAX_ID");//("The tax id provided when setting up the bank account was invalid")



//unique prefix (used to generate unique IDs)
define("UNIQUE_NETWORK","net-"); //unique data collection network
define("UNIQUE_TEAM","team-"); //unique team
define("UNIQUE_NOTIFICATION","note-"); //unique notification id (one way msg)
define("UNIQUE_MSG","msg-"); //unique message
define("UNIQUE_PAYMENT","pay-");//unique payment instance
define("UNIQUE_TRANSACTION","trans-"); //unique transaction instance
define("UNIQUE_ACCOUNT","acc-");//unique account instance
define("UNIQUE_ACTIVITY","aty-");//unique user activity instance
define("UNIQUE_PENALTY","pty-");//unique cancel quest/other penalty
define("UNIQUE_RELATIONSHIP","rel-");//unique relationship instance
define("UNIQUE_FILE","file-");//unique file
define("UNIQUE_INVITATION","ivn-");//unique invitation instance
define("UNIQUE_PULSE","pul-");//unique pulse instance
define("UNIQUE_PULSE_QUESTION","que-");//unique pulse instance
//define("UNIQUE_SUBMISSION","sub-");

//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED",2);
define("SURVEY_STATE_CANCELLED",3);

//survey instrument state
define("SURVEY_INSTRUMENT_READY", 1);
define("SURVEY_INSTRUMENT_NOT_READY", 0);



//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);


//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state / network relationship state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);


//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");
define("TABLE_SUBMISSIONS", "submission_response");
define("TABLE_MESSAGE", "message");
define("TABLE_PAYOUT_ACCOUNT", "payout_account");
define("TABLE_AGENT_PAYMENT", "app_agent_payment");
define("TABLE_AGENT_CASH_OUT", "app_agent_cashout");
define("TABLE_CASH_OUT_TRANSACTION", "app_cashout_transaction");
define("TABLE_REALTIME_NOTIFICATION", "realtime_notification");

//payout account type
define("ACCOUNT_TYPE_AMAZON_GIFT_CARD", "type_amazon_card");
define("ACCOUNT_TYPE_DING_MOBILE_TOP_UP", "type_ding");
//define("ACCOUNT_TYPE_REWARDS_GENIUS", "type_rewards_genius");
define("ACCOUNT_TYPE_PAYONEER", "type_payoneer");
define("ACCOUNT_TYPE_PAYPAL", "type_paypal");
define("ACCOUNT_TYPE_BANK_ACCOUNT", "type_bank");

//payout account function (the purpose of the specific account type)
define("ACCOUNT_FUNCTION_GIFT_CARD", "function_gift_card"); //("Gift Card")
define("ACCOUNT_FUNCTION_MOBILE", "function_mobile"); //("Mobile Recharge")
define("ACCOUNT_FUNCTION_CASH_OUT", "function_cash_out"); //("Monetary Cash Out")


//task status
define("TASK_STATUS_PENDING",   0);
define("TASK_STATUS_ACTIVE",    1);
define("TASK_STATUS_AWARDED",   2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT",     5);
define("TASK_STATUS_DISABLED",  6);

//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
define("ACTIVITY_TYPE_VOX", "activity_vox");
define("ACTIVITY_TYPE_POLL", "activity_poll");
//----------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");


//task activity category
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
define("ACTIVITY_CATEGORY_VOX", "category_vox");
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");
//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");

//user presence activity (the activity state that can be logged)
define("USER_ACTIVITY_ACCEPT_QUEST", "check_available");//the user queried available quest

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_PRIVATE", 0); //collectors cannot be used by other networks
define("NETWORK_POSITION_OFFICIAL", 1); //collectors can be used by other networks
define("NETWORK_POSITION_DEFAULT", 2); //this is the primary official network (all user registered without a specific network)

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CUSTOMER", 0);

//gender
define("GENDER_FEMALE", 0);
define("GENDER_MALE", 1);
define("GENDER_NON_BINARY", 2);
define("GENDER_NOT_TO_SAY", 3);
define("GENDER_FEMALE_STRING", "female");
define("GENDER_MALE_STRING", "male");
define("GENDER_NON_BINARY_STRING", "non_binary");
define("GENDER_NOT_TO_SAY_STRING", "prefer_not_to_say");



//API KEY | AND CONSTANTS
define("SERVER_MAP_KEY", "AIzaSyCAbro3HYflhyhj9Z55xCMSZDBLABLABnM");
define("FIREBASE_SERVER_KEY", "AIzaSyD8Xf2XrVxrtq0sngAJrRULYniemVn8MJM");
define("FIREBASE_SENDER_ID", "114414183492");

define("PUSH_NOTIFICATION_TOPIC_NEW_QUEST", "/topics/new_quest");
define("PUSH_NOTIFICATION_TOPIC_BROADCAST", "/topics/new_broadcast");
define("PUSH_NOTIFICATION_TOPIC_MESSAGE", "/topics/new_message");

define("PUSH_NOTIFICATION_STATUS_NEW_QUEST", "new_quest");
define("PUSH_NOTIFICATION_STATUS_BROADCAST", "new_broadcast");
define("PUSH_NOTIFICATION_STATUS_MESSAGE", "new_message");


//define("NEW_REQUEST_TOPIC", "/topics/new_request");
//define("NEW_LOCATION_TOPIC", "/topics/location_changed");
//define("NEW_DRIVER_TOPIC", "/topics/driver_added");

//API KEY - PAYOUTS
define("DING_MOBILE_RECHARGE_KEY", "ApyJWyuifmb6YMuJhu7wAW");
define("AMAZON_GIFT_INCENTIVE_KEY", "AKIAWWFS6UKLHJAGJY55");


//EMAIL TEMPLATE FUNCTION NAME
define("EMAIL_TEMPLATE_AGENT_WELCOME","agent_welcome");
define("EMAIL_TEMPLATE_PAYOUT_AMAZON","payout_amazon");

//--------------------------------------------------------


include("../../../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../../../includes/headers/strings.php");//has all the constants needed


/**
 * @Title Official Mobile Application Version Information
 * @Obj VERSION_NAME : This the version string name is is only used for labeling
 * @Obj VERSION_CODE : This is the actual version code used to maintain app version
 * @Obj VERSION_COMMENT : This is an optional string to be used in messaging
 * @Obj VERSION_PRIORITY : (0 -> This update is not priority and can be ignored by the user | 1 -> This update cannot be ignored)
 * @Usage : verifyLogin and processed by SplashScreen on the mobile App
 */
define("MOBILE_AGENT_ANDROID", "android");
define("MOBILE_AGENT_IOS", "ios");
define("MOBILE_VERSION_NAME", "version_name");
define("MOBILE_VERSION_CODE", "version_code");
define("MOBILE_VERSION_COMMENT", "version_comment");
define("MOBILE_VERSION_PRIORITY", "version_priority");

define("ANDROID_VERSION_NAME", "1.4.1.8-18");
define("ANDROID_VERSION_CODE", 31);

//define("ANDROID_VERSION_NAME", "1.4.1.8-17");
//define("ANDROID_VERSION_CODE", 30);

//define("ANDROID_VERSION_NAME", "1.4.1.8-16");
//define("ANDROID_VERSION_CODE", 29);



define("ANDROID_VERSION_COMMENT", ".");
define("ANDROID_VERSION_PRIORITY", 1);

define("IOS_VERSION_NAME", "1.0");
define("IOS_VERSION_CODE", 1);
define("IOS_VERSION_COMMENT", ".");
define("IOS_VERSION_PRIORITY", 1);

//API ACTIONS
define("ACTION_LOG_IN", "log_in");
define("ACTION_SIGN_UP", "sign_up");
define("ACTION_SIGN_OUT", "sign_out");
define("ACTION_GET_AVAILABLE_JOBS", "available_jobs");
define("ACTION_GET_ACTIVE_JOBS", "active_jobs");
define("ACTION_GET_COMPLETED_JOBS", "completed_jobs");
define("ACTION_ACCEPT_JOB", "accept_job");
define("ACTION_CANCEL_JOB", "cancel_job");
define("ACTION_GET_JOB_DETAIL", "get_job_detail");

define("ACTION_SUBMISSION_START", "submission_start");
define("ACTION_SUBMISSION_COMPLETE", "submission_complete");
define("ACTION_SEND_NOTIFICATION_ID", "send_notification_id");
define("ACTION_AUTHENTICATE_USER", "authenticate_user");
define("ACTION_GET_USER_DATA", "get_user_data");
define("ACTION_CHANGE_PASSWORD", "change_password");
//new actions
//define("", "");
define("ACTION_GET_WALLET_DATA", "get_wallet_data");
define("ACTION_SEND_DIRECT_MESSAGE", "send_direct_message");
define("ACTION_GET_DIRECT_MESSAGE_THREAD", "get_direct_message_thread");
define("ACTION_GET_DIRECT_MESSAGE_ITEM", "get_direct_message_item");
define("ACTION_GET_MESSAGE_LIST", "get_message_list");

define("ACTION_ADD_PRIMARY_ACCOUNT", "add_primary_bank_account");
define("ACTION_UPDATE_PRIMARY_ACCOUNT", "update_primary_bank_account");
define("ACTION_GET_PRIMARY_ACCOUNT", "get_primary_bank_account");

//LOCATION BASED VARIABLES
define("DEFAULT_LANGUAGE_CODE","en");
define("LOCATION_GREEN_ZONE", 16000); //16 km -> Users must be within the GREEN_ZONE in order to accept quest
define("SYSTEM_CURRENCY", "USD"); //The base currency used by the system
define("COUNTRY_JAMAICA", "JM"); //Country code for jamaica
define("COUNTRY_CHILE", "CL"); //Country code for chile

//profile survey from insights
define("PROFILE_SURVEY_TOKEN", "https://insight.queritel.com/index.php/738622?lang=en");




include 'email/email_handler.php';


$paperweight = new Database(MAIN_DB_USERNAME,MAIN_DB_PASSWORD,MAIN_DB_NAME);


//profile_survey_token
$action = $_GET["action"];
if ($action == "demo")
{

    //https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?action=demo&param_json={%22user_id%22:823,%22lat%22:%2277.00%22,%22lng%22:%2213.00%22}

    $param_json = $_GET["param_json"];
    $data = json_decode($param_json, true);

    //329
    $user_id =      text_clean($data["user_id"]);
    //$lat =          text_clean($data["lat"]);
    //$lng =          text_clean($data["lng"]);
    //$response_id =  text_clean($data["response_id"]);

    //echo "This is demo <br>";
    //echo createEmailInvitationBody("google.com","Kadan Salmon");

    //echo getDefaultNetwork($paperweight);
    //echo json_encode(getOfficialNetworks($paperweight));

    /*$letters = array("a","b","c","d");

    foreach ($letters as $let){
        echo $let . "<br>";
    }*/

    //echo json_encode(getNetworkRelationship(125, $paperweight));
    //echo json_encode(isFromOfficialNetwork(329, $paperweight));
    //echo json_encode(isFromOfficialNetwork(121, $paperweight));
    //echo json_encode(isFromOfficialNetwork(377, $paperweight));

    //$client = new HostInfo();


    //echo json_encode($client->getCountry_flag());

    $lat = 17.9973836;
    $lng = -76.7896984;

    //$user_id = 823;

    $researcher = new Researcher($paperweight);
    $researcher->initializeResearcher($user_id);

    //$researcher->setCurrentLocation($lat,$lng);

    //$result = $researcher->getCurrentLocation();

    //$result = $researcher->startSubmission($response_id);
    //$result = $researcher->completeSubmission($response_id,);

    $task_id = 297;
    $passed_network_id = getQuestCreatorNetwork($task_id,$paperweight);

    $result = array();
    $data = array();
    $message_thread = array();


    /*

    $message_id = "pywxqjo-7175664-RRTWUNB";
    $recipient_id = 0;
    $recipient_network_id = "nid_jsy827459OFksye";
    $sender_id = 329;
    $sender_network_id = null;
    $timestamp = getCurrentTime();
    $task_id = 289;
    $msg_body = "this is my message body";

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $message_id = "jfhyfgr-8476395-HDKDJGT";
    $recipient_id = 329;
    $recipient_network_id = null;
    $sender_id = 0;
    $sender_network_id = "nid_jsy827459OFksye";
    $timestamp = "2021-03-11 08:14:58";
    $task_id = 289;
    $msg_body = "this is my message body sent by the company";

    $index = 1;

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $data[$index]["body"] = "Hello kadian";
    */


    $result["status"] = STATUS_OK;
    $result["message_thread"] = array();

    //if sender is not null (check if user is sender)


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){

        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);


            $data["message_id"] = $message_id;
            $data["recipient_id"] = intval($recipient_id);
            $data["recipient_network"] = $recipient_network_id;
            $data["sender_id"] = intval($sender_id);
            $data["sender_network"] = $sender_network_id;
            $data["task_id"] = intval($task_id);
            $data["timestamp"] = $timestamp;
            $data["body"] = ($msg_body);

            $message_thread[] = $data;

        }

        $result["status"] = STATUS_OK;
        $result["message_thread"] = $message_thread;

    }
    //$result = $researcher->startSubmission(79446052);
    //$result = $researcher->completeSubmission(79446052,30742304);
    //$result = $researcher->completeQuestionnaire(79446052);

    //$result = new LocationPoint(null,null);

    /*if (!$result->isEmpty()){
        echo "Location was found";
    }
    else{
        echo "Location was not found";
    }*/

    //echo $result->isEmpty();
    //echo $result->isEmpty();

    //$paperweight->getConnector()->set_charset("utf8");

    echo "Current character set is: " . $paperweight->getConnector()->character_set_name();

    //echo json_export($result);
    //echo json_encode($result);

}

if (isset($_POST["action"])){
    $action = $_POST["action"];
    $param_json = $_POST["param_json"];


    if ($action == "--"){
        $data = json_decode($param_json, true);

        $number_locale = text_clean($data["number_locale"]);
        $value = text_clean($data["value"]);

        $sent = email_agent_welcome("kadansalmon.ks@gmail.com","Kadan Salmon","en");

        $result = array();
        $result["sent and logged"] = $sent;

        echo json_export($result);
    }

    if ($action == ACTION_SIGN_UP){
        $data = json_decode($param_json, true);


        /*
            fname -
            lname -
            email -
            password -
            gender -
            -- additions --
            phone_number -
            date_of_birth -
            country_code -
            location_state -
            location_city -
            location_address -
            invitation_code
            language_code
         */
        $signup_success = false;
        $researcher = new Researcher($paperweight);

        $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);


        //todo : API Debug
        debugAPIResponse(ACTION_SIGN_UP,json_encode($data,JSON_PRETTY_PRINT));



        $first_name = stringCase(text_clean($data["fname"]));
        $last_name = stringCase(text_clean($data["lname"]));
        //$screen_name = stringCase(text_clean($data[""]));
        $screen_name = $first_name . " " . $last_name;
        $email = stringCase(text_clean($data["email"]));
        $password = encryptPassword(text_clean($data["password"]));
        $gender = text_clean($data["gender"]);
        if ($gender == GENDER_MALE_STRING){
            $gender = GENDER_MALE;
        }
        elseif ($gender == GENDER_FEMALE_STRING){
            $gender = GENDER_FEMALE;
        }
        elseif ($gender == GENDER_NON_BINARY_STRING){
            $gender = GENDER_NON_BINARY;
        }
        elseif ($gender == GENDER_NOT_TO_SAY_STRING){
            $gender = GENDER_NOT_TO_SAY;
        }
        else{
            $gender = null;
        }

        $mobile = text_clean($data["phone_number"]);

        $date_of_birth = text_clean($data["date_of_birth"]);
        $country_code = stringCase(text_clean($data["country_code"]),STRING_CASE_UPPER);
        $location_state = stringCase(text_clean($data["location_state"]));
        $location_city = stringCase(text_clean($data["location_city"]));
        $location_address = stringCase(text_clean($data["location_address"]));
        $invitation_referrer = text_clean($data["invitation_code"]);
        $language_code = stringCase(text_clean($data["language_code"]));

        $ethnicity = text_clean($data["ethnicity"]);
        $marital_status = text_clean($data["marital_status"]);
        $education = text_clean($data["education"]);
        $employment_status = text_clean($data["employment_status"]);
        $employment_industry = text_clean($data["employment_industry"]);
        $occupation = text_clean($data["occupation"]);


        $country_id = null;
        $state_id = null;
        $city_id = null;
        $zip = null;
        $county = null;
        $parish = null;
        $is_experienced = 2; //1 - yes | 2 - no
        //$is_experienced = text_clean($data["user_is_experienced"]);
        //$more_cv_data = text_clean($data["user_more_cv_data"]);
        $user_assistance_company = "";//text_clean($data["user_is_experienced"]);
        $user_deg_id = 0;//text_clean($data["user_is_experienced"]);

        $user_type = USER_TYPE_RESEARCHER;
        $user_active = STATE_ACTIVE;
        $user_is_approved = VERIFIED;
        $email_is_verified = VERIFIED; //todo : remove auto email verification
        $user_regdate = getCurrentTime();
        $user_ref_id = generateUserReferenceId();


        //psuedo profile data
        $user_test_passed = VERIFIED;
        $user_sample_essay = VERIFIED;


        //network data
        $network_id = text_clean($data["n_id"]);// please validate this first
        if(!isset($data["n_id"]) || $network_id == ""){
            $network_id = getDefaultNetwork($paperweight);
            //$network_id = "nid_jsy827459OFksye"; //demo network
        }
        $network_role = NETWORK_ROLE_COLLECTOR;
        $relationship_id = generateNumericId();

        if (!empty($first_name) && !empty($last_name) && !empty($email) && !empty($password)){
            //insert into table user
            $add_user = "insert into " . TABLE_USERS . " (user_ref_id,user_email,user_password,user_screen_name,user_first_name,user_last_name,user_sex,user_country_id,user_state_id,user_city_id,user_county,user_parish,user_regdate,user_type,user_email_verified,user_active,user_is_approved,phone_number,date_of_birth,country_code,location_state,location_city,location_address,language_code,invitation_referrer) values('$user_ref_id','$email','$password','$screen_name','$first_name','$last_name','$gender','$country_id','$state_id','$city_id','$county','$parish','$user_regdate','$user_type','$email_is_verified','$user_active','$user_is_approved','$mobile','$date_of_birth','$country_code','$location_state','$location_city','$location_address','$language_code','$invitation_referrer')";
            $add_user_result = $paperweight->query($add_user);

            if($add_user_result != null && $add_user_result->is_row_affected()){

                $query_new_user = "select * from " . TABLE_USERS . " where user_ref_id = '$user_ref_id' and user_email = '$email'";
                $query_new_user_result = $paperweight->query($query_new_user);

                if ($query_new_user_result != null && $query_new_user_result->is_row_found())
                {
                    if ($row = $query_new_user_result->fetch_array())
                    {
                        //--- ADD AGENT PROFILE data

                        $user_id = $row["user_id"];
                        $add_user_profile = "insert into " . TABLE_USER_PROFILE . " (userprofile_user_id,user_mobile,user_is_experienced,user_assistance_company,user_deg_id,user_test_passed,user_sample_essay,ethnicity,marital_status,education,employment_status,employment_industry,occupation) values ('$user_id','$mobile','$is_experienced','$user_assistance_company','$user_deg_id','$user_test_passed','$user_sample_essay','$ethnicity','$marital_status','$education','$employment_status','$employment_industry','$occupation')";
                        $add_user_network = "insert into " . TABLE_NETWORK_RELATIONSHIP . " (relationship_id,network_id,network_role,update_time,user_id) values ('$relationship_id','$network_id','$network_role','$user_regdate','$user_id')";

                        $add_user_profile_result = $paperweight->query($add_user_profile);
                        if($add_user_profile_result != null && $add_user_profile_result->is_row_affected()){
                            $add_user_network_result = $paperweight->query($add_user_network);
                            if($add_user_network_result != null && $add_user_network_result->is_row_affected()){

                                $signup_success = true;

                            }
                        }

                    }
                }

            }
        }


        if ($signup_success){



            $result = $researcher->getOKStatus();
        }


        echo json_export($result);
    }

    if ($action == ACTION_LOG_IN){
        $data = json_decode($param_json, true);

        $username = strtolower(text_clean($data["username"]));
        $password = text_clean($data["password"]);
        $login_data = $data["login_data"];


        $researcher = new Researcher($paperweight);

        $result = $researcher->login($username, $password,$login_data);

        echo json_export($result);

    }
    if ($action == ACTION_SIGN_OUT){
        $data = json_decode($param_json, true);

        $user_id = clean($data["user_id"]);
        $login_token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);
        //$researcher->initializeResearcher($user_id,$login_token);

        $obj = $researcher->signout($user_id, $login_token);

        $researcher->removeNotificationToken($user_id,$login_token);


        echo json_encode($obj);

    }
    if ($action == ACTION_AUTHENTICATE_USER){
        $data = json_decode($param_json, true);

        $user_id = clean($data["user_id"]);
        $login_token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] != STATUS_OK){

            $result = $researcher->getErrorStatus(ERROR_MSG_INVALID_TOKEN);
        }

        echo json_export($result);
    }

    if ($action == ACTION_GET_AVAILABLE_JOBS){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        /*if ($user_id == 329){
            $user_id = 1539;
            $login_token = 96929186;
        }*/
        //if ($user_id == 329){
            //$user_id = 885;
            //$login_token = 78172866;
        //}

        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){



            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getAvailableJobs();
        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_ACTIVE_JOBS){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getActiveJobs();
        }


        echo json_export($result);
    }
    if ($action == ACTION_GET_COMPLETED_JOBS){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);


        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->getCompletedJobs();
        }


        echo json_export($result);
    }
    //todo : add task id when accepting
    if ($action == ACTION_ACCEPT_JOB){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $task_id =       text_clean($data["task_id"]);
        $job_id =       text_clean($data["job_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            //todo : API Debug
            //debugAPIResponse(ACTION_ACCEPT_JOB,json_encode($data,JSON_PRETTY_PRINT));


            $result = $researcher->acceptJob($job_id,$researcher);
        }

        echo json_export($result);
    }
    if ($action == ACTION_CANCEL_JOB){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $response_id =  text_clean($data["response_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        //todo : API Debug
        debugAPIResponse(ACTION_CANCEL_JOB,json_encode($data,JSON_PRETTY_PRINT));


        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->cancelJob($response_id);
        }

        echo json_export($result);
    }
    if ($action == ACTION_GET_JOB_DETAIL){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $response_id = text_clean($data["response_id"]);
        //$lat = clean($data["lat"]);
        //$lng = clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $result = $researcher->getJobDetail($response_id);
        }

        echo json_export($result);
    }

    if ($action == ACTION_SUBMISSION_START){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $response_id = text_clean($data["response_id"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);

        //todo : API Debug
        //debugAPIResponse(ACTION_SUBMISSION_START,json_encode($data,JSON_PRETTY_PRINT));



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->startSubmission($response_id);
        }


        echo json_export($result);
    }
    if ($action == ACTION_SUBMISSION_COMPLETE){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $response_id = text_clean($data["response_id"]);
        $submission_id = text_clean($data["submission_id"]);
        $percent_completion = text_clean($data["percent_completion"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse(ACTION_SUBMISSION_COMPLETE,json_encode($data,JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            if (empty($percent_completion)){
                $percent_completion = 100;
            }
            if ($percent_completion > 100){
                $percent_completion = 100;
            }

            $result = $researcher->completeSubmission($response_id,$submission_id,$percent_completion);
        }


        echo json_export($result);
    }

    if ($action == "profile_survey_start"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $response_id = text_clean($data["response_id"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            if (!$researcher->isProfileSurveyCompleted()){
                $result = $researcher->getOKStatus();
                $result["survey_url"] = $researcher->startProfileSurvey($researcher);
            }

        }

        echo json_export($result);
    }
    if ($action == "profile_survey_complete"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $percent_completion = text_clean($data["percent_completion"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);

        //todo : API Debug
        //debugAPIResponse(ACTION_SUBMISSION_COMPLETE,json_encode($data,JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            if (!$researcher->isProfileSurveyCompleted()){

                $new_completed = $researcher->completeProfileSurvey();

                if ($new_completed){
                    $result = $researcher->getOKStatus();
                }

            }
        }

        echo json_export($result);
    }

    if ($action == "get_message_list__"){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $job_id =       text_clean($data["job_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }

        echo json_export($result);
    }
    if ($action == "get_message_thread__"){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $job_id =       text_clean($data["job_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }

        echo json_export($result);
    }
    if ($action == "send_message__"){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $job_id =       text_clean($data["job_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }

        echo json_export($result);
    }



    //todo : USER CHECK HERE
    if ($action == "get_message_list_dev"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));




        $result = array();
        $data = array();
        $message_list = array();
        $processed_array = array();


        $result["status"] = STATUS_OK;
        $result["message_list"] = array();

        $msg_query = "select * from " . TABLE_MESSAGE . " where (sender_id = '$user_id' or recipient_id = '$user_id')";
        $msg_result = $paperweight->query($msg_query);

        if($msg_result != null && $msg_result->is_row_found()){

            $data = array();
            $quest_section = array();

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = ($row["message_body"]);
                $read = $row["read"];
                $unread = 0;


                if (!isset($processed_array[$task_id])){
                    $quest_detail = getQuestDetail($task_id,$paperweight);
                    $network_detail = getNetworkDetails($quest_detail["creator_net_id"],$paperweight);


                    //if has task (true) & network (true) - specific task message
                    //if has task (false) & network (true) - specific network message
                    //if has task (false) & network (false) - Queritel Administration

                    if (empty($quest_detail)){

                    }


                    $data["quest_name"] = $quest_detail["task_topic"];
                    $data["network_name"] = $network_detail["organization_name"];
                    $data["network_id"] = $quest_detail["creator_net_id"];
                    $data["task_id"] = intval($task_id);
                    $data["timestamp"] = $timestamp;
                    $data["msg_body"] = $msg_body;

                    if (($recipient_id == $user_id) && $read == 0){
                        $unread = 1;
                    }

                    $data["unread"] = intval($unread);

                    $processed_array[$task_id] = $data;
                }
                else{

                    $processed_array[$task_id]["timestamp"] = $timestamp;
                    $processed_array[$task_id]["msg_body"] = $msg_body;

                    if (($recipient_id == $user_id) && $read == 0){
                        $prev_unread = $processed_array[$task_id]["unread"];
                        $new_unread = $prev_unread + 1;

                        $processed_array[$task_id]["unread"] = $new_unread;

                    }
                }

            }

            foreach ($processed_array as $quest_message_entry) {
                $quest_message_entry["unread"] = 0;//todo : REMOVE when messages can be marked
                $message_list[] = $quest_message_entry;
            }


            $result["status"] = STATUS_OK;
            $result["message_list"] = $message_list;

        }



        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo generate_msg_id();
    }
    if ($action == "get_direct_message_thread_dev"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $network_id =  text_clean($data["network_id"]);//
        $task_id =  text_clean($data["task_id"]);


        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));


        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        /*

        chatBubble1.setMessageId("udhfytb-7487365-HTRDYTI");
        chatBubble1.setRecipientId(329);
        chatBubble1.setSenderId(-1);
        chatBubble1.setSenderNetwork("nid_jsy827459OFksye");
        chatBubble1.setRecipientNetwork(null);
        chatBubble1.setTimestamp("2021-02-25 16:00:00");
        chatBubble1.setTask_id(292);
        chatBubble1.setRead(false);//have i marked this message as [READ] (i am the recipient)
        chatBubble1.setBelongToCurrentUser(false);//was this message sent by me (this is not mine becuz i didnt send it)
        chatBubble1.setMsgBody("We noticed that you have not accessed the application in while, is there a problem");

      */
        /*"status": "OK",
       "message_thread": [
           {
               "message_id": "pywxqjo-7175664-RRTWUNB",--
               "recipient_id": 0,--
               "recipient_network": "nid_jsy827459OFksye",--
               "sender_id": 329,--
               "sender_network": null,--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body"
           },
           {
               "message_id": "jfhyfgr-8476395-HDKDJGT",--
               "recipient_id": 329,--
               "recipient_network": null,--
               "sender_id": 0,--
               "sender_network": "nid_jsy827459OFksye",--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body sent by the company"
           }
       ]
        */

        $passed_network_id = $network_id; //getQuestCreatorNetwork($task_id,$paperweight);

        $result = array();
        $data = array();
        $message_thread = array();





        /*

        $message_id = "pywxqjo-7175664-RRTWUNB";
        $recipient_id = 0;
        $recipient_network_id = "nid_jsy827459OFksye";
        $sender_id = 329;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = 289;
        $msg_body = "this is my message body";




        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;



        $message_id = "jfhyfgr-8476395-HDKDJGT";
        $recipient_id = 329;
        $recipient_network_id = null;
        $sender_id = 0;
        $sender_network_id = "nid_jsy827459OFksye";
        $timestamp = "2021-03-11 08:14:58";
        $task_id = 289;
        $msg_body = "this is my message body sent by the company";

        $index = 1;

        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;
        //$data[$index]["body"] = "Hello kadian";
        */


        $result["status"] = STATUS_OK;
        $result["message_thread"] = array();

        //if sender is not null (check if user is sender)


        $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and (task_id = '$task_id' or task_id is null)";
        $msg_result = $paperweight->query($msg_query);

        $img_sent_index = 0;
        $img_get_index = 0;

        if($msg_result != null && $msg_result->is_row_found()){

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = ($row["message_body"]);
                $is_read = false;
                $is_sent = ($sender_id == $user_id);


                $data["message_id"] = $message_id;
                $data["recipient_id"] = intval($recipient_id);
                $data["recipient_network"] = $recipient_network_id;
                $data["sender_id"] = intval($sender_id);
                $data["sender_network"] = $sender_network_id;
                $data["task_id"] = intval($task_id);
                $data["timestamp"] = $timestamp;
                $data["is_sent"] = $is_sent;
                $data["is_read"] = $is_read;
                $data["image_url"] = null;
                $data["body"] = ($msg_body);

                if ($is_sent && ($img_sent_index == 0) ){
                    //$data["image_url"] = "https://queritel.com/assets/img/persons/03.png";
                    $img_sent_index = 1;
                }

                if (!$is_sent && ($img_get_index == 0) ){
                    //$data["image_url"] = "https://queritel.com/assets/img/persons/02.png";
                    $img_get_index = 1;
                }


                $message_thread[] = $data;

            }

            $result["status"] = STATUS_OK;
            $result["message_thread"] = $message_thread;

        }








        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        //echo json_export($result);
        echo json_export($result);
        //echo json_export($user_id);
    }
    if ($action == "send_direct_message_dev"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $msg_data =             $data["message_data"];
        $recipient_network =    text_clean($msg_data["recipient_network_id"]);
        $task_id_ =             text_clean($msg_data["task_id"]);
        $body =                 text_clean($msg_data["body"]);

        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));

        //$body = mb_convert_encoding(($MSG_DATA["body"]), 'UTF-8', 'ISO-8859-1');


        //$message_id = generate_msg_id();
        $message_id = generate_unique_id(UNIQUE_MSG);
        $recipient_id = null;
        //$recipient_network_id = $recipient_network;
        $recipient_network_id = getQuestCreatorNetwork($task_id_,$paperweight);
        $sender_id = $user_id;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = $task_id_;
        $msg_body = $body;
        $msg_type = "msg_text";


        $result = array();
        $data = array();

        $data["message_id"] = $message_id;
        $data["recipient_id"] = intval($recipient_id);
        $data["recipient_network"] = $recipient_network_id;
        $data["sender_id"] = intval($sender_id);
        $data["sender_network"] = $sender_network_id;
        $data["task_id"] = intval($task_id);
        $data["timestamp"] = $timestamp;
        $data["body"] = $msg_body;

        $data["image_url"] = "https://queritel.com/assets/img/persons/03.png";



        $result["status"] = STATUS_ERROR;

        $send_msg = "insert into " . TABLE_MESSAGE . " (message_id, send_time, sender_id, message_body, send_lat, send_lon, task_id, recipient_network_id, message_type) values ('$message_id','$timestamp','$sender_id','$msg_body','$lat','$lng','$task_id','$recipient_network_id','$msg_type')";
        $send_msg_result = $paperweight->query($send_msg);

        if($send_msg_result != null && $send_msg_result->is_row_affected()){
            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;
                //broadcast update to researcher and admin
            }*/

            $result["status"] = STATUS_OK;
            $result["message_data"] = $data;

        }





        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
    }


    //almost done -- ACTION_GET_MESSAGE_LIST
    if ($action == "get_message_list"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);




        $result = array();
        $data = array();
        $message_list = array();
        $processed_array = array();


        $result["status"] = STATUS_OK;
        $result["message_list"] = array();

        $msg_query = "select * from " . TABLE_MESSAGE . " where (sender_id = '$user_id' or recipient_id = '$user_id')";
        $msg_result = $paperweight->query($msg_query);

        if($msg_result != null && $msg_result->is_row_found()){

            $data = array();
            $quest_section = array();

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = ($row["message_body"]);
                $read = $row["read"];
                $unread = 0;


                if (!isset($processed_array[$task_id])){
                    $quest_detail = getQuestDetail($task_id,$paperweight);
                    $network_detail = getNetworkDetails($quest_detail["creator_net_id"],$paperweight);

                    if (empty($quest_detail)){
                        $quest_detail = array();
                        $network_detail = array();
                        $network_id = null;
                        $task_id = -1;

                        if ($user_id == $sender_id){
                            $network_id = $recipient_network_id;
                        }
                        else{
                            $network_id = $sender_network_id;
                        }
                        $network_detail = getNetworkDetails($network_id,$paperweight);


                        $quest_detail["task_topic"] = $network_detail["organization_name"];
                        $quest_detail["creator_net_id"] = $network_id;
                    }


                    $data["quest_name"] = $quest_detail["task_topic"];
                    $data["network_name"] = $network_detail["organization_name"];
                    $data["network_id"] = $quest_detail["creator_net_id"];
                    $data["task_id"] = $task_id;
                    $data["timestamp"] = $timestamp;
                    $data["msg_body"] = $msg_body;

                    if (($recipient_id == $user_id) && $read == 0){
                        $unread = 1;
                    }

                    $data["unread"] = intval($unread);

                    $processed_array[$task_id] = $data;
                }
                else{

                    $processed_array[$task_id]["timestamp"] = $timestamp;
                    $processed_array[$task_id]["msg_body"] = $msg_body;

                    if (($recipient_id == $user_id) && $read == 0){
                        $prev_unread = $processed_array[$task_id]["unread"];
                        $new_unread = $prev_unread + 1;

                        $processed_array[$task_id]["unread"] = $new_unread;

                    }
                }

            }

            foreach ($processed_array as $quest_message_entry) {
                $quest_message_entry["unread"] = 0;//todo : REMOVE when messages can be marked
                $message_list[] = $quest_message_entry;
            }


            $result["status"] = STATUS_OK;
            $result["message_list"] = $message_list;

        }



        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo generate_msg_id();
    }
    //almost done
    if ($action == "get_direct_message_thread"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $network_id =  text_clean($data["network_id"]);//
        $task_id =  text_clean($data["task_id"]);


        //todo : API Debug
        //debugAPIResponse("get_direct_message_thread",json_encode($data,JSON_PRETTY_PRINT));


        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        /*

        chatBubble1.setMessageId("udhfytb-7487365-HTRDYTI");
        chatBubble1.setRecipientId(329);
        chatBubble1.setSenderId(-1);
        chatBubble1.setSenderNetwork("nid_jsy827459OFksye");
        chatBubble1.setRecipientNetwork(null);
        chatBubble1.setTimestamp("2021-02-25 16:00:00");
        chatBubble1.setTask_id(292);
        chatBubble1.setRead(false);//have i marked this message as [READ] (i am the recipient)
        chatBubble1.setBelongToCurrentUser(false);//was this message sent by me (this is not mine becuz i didnt send it)
        chatBubble1.setMsgBody("We noticed that you have not accessed the application in while, is there a problem");

      */
        /*"status": "OK",
       "message_thread": [
           {
               "message_id": "pywxqjo-7175664-RRTWUNB",--
               "recipient_id": 0,--
               "recipient_network": "nid_jsy827459OFksye",--
               "sender_id": 329,--
               "sender_network": null,--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body"
           },
           {
               "message_id": "jfhyfgr-8476395-HDKDJGT",--
               "recipient_id": 329,--
               "recipient_network": null,--
               "sender_id": 0,--
               "sender_network": "nid_jsy827459OFksye",--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body sent by the company"
           }
       ]
        */

        $passed_network_id = $network_id; //getQuestCreatorNetwork($task_id,$paperweight);

        $result = array();
        $data = array();
        $message_thread = array();





        /*

        $message_id = "pywxqjo-7175664-RRTWUNB";
        $recipient_id = 0;
        $recipient_network_id = "nid_jsy827459OFksye";
        $sender_id = 329;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = 289;
        $msg_body = "this is my message body";




        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;



        $message_id = "jfhyfgr-8476395-HDKDJGT";
        $recipient_id = 329;
        $recipient_network_id = null;
        $sender_id = 0;
        $sender_network_id = "nid_jsy827459OFksye";
        $timestamp = "2021-03-11 08:14:58";
        $task_id = 289;
        $msg_body = "this is my message body sent by the company";

        $index = 1;

        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;
        //$data[$index]["body"] = "Hello kadian";
        */


        $result["status"] = STATUS_OK;
        $result["message_thread"] = array();

        //if sender is not null (check if user is sender)


        $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and (task_id = '$task_id' or task_id is null)";
        $msg_result = $paperweight->query($msg_query);

        $img_sent_index = 0;
        $img_get_index = 0;

        if($msg_result != null && $msg_result->is_row_found()){

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = ($row["message_body"]);
                $is_read = false;
                $is_sent = ($sender_id == $user_id);


                $data["message_id"] = $message_id;
                $data["recipient_id"] = intval($recipient_id);
                $data["recipient_network"] = $recipient_network_id;
                $data["sender_id"] = intval($sender_id);
                $data["sender_network"] = $sender_network_id;
                $data["task_id"] = intval($task_id);
                $data["timestamp"] = $timestamp;
                $data["is_sent"] = $is_sent;
                $data["is_read"] = $is_read;
                $data["image_url"] = null;
                $data["body"] = ($msg_body);

                if ($is_sent && ($img_sent_index == 0) ){
                    //$data["image_url"] = "https://queritel.com/assets/img/persons/03.png";
                    $img_sent_index = 1;
                }

                if (!$is_sent && ($img_get_index == 0) ){
                    //$data["image_url"] = "https://queritel.com/assets/img/persons/02.png";
                    $img_get_index = 1;
                }


                $message_thread[] = $data;

            }

            $result["status"] = STATUS_OK;
            $result["message_thread"] = $message_thread;

        }








        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        //echo json_export($result);
        echo json_export($result);
        //echo json_export($user_id);
    }
    //almost done
    if ($action == ACTION_GET_DIRECT_MESSAGE_ITEM){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $message_id =  text_clean($data["message_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        /*

        chatBubble1.setMessageId("udhfytb-7487365-HTRDYTI");
        chatBubble1.setRecipientId(329);
        chatBubble1.setSenderId(-1);
        chatBubble1.setSenderNetwork("nid_jsy827459OFksye");
        chatBubble1.setRecipientNetwork(null);
        chatBubble1.setTimestamp("2021-02-25 16:00:00");
        chatBubble1.setTask_id(292);
        chatBubble1.setRead(false);//have i marked this message as [READ] (i am the recipient)
        chatBubble1.setBelongToCurrentUser(false);//was this message sent by me (this is not mine becuz i didnt send it)
        chatBubble1.setMsgBody("We noticed that you have not accessed the application in while, is there a problem");

      */



        //$message_id = strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtoupper(getRandomString(7));
        $recipient_id = 329;
        $recipient_network_id = null;
        $sender_id = 0;
        $sender_network_id = null;
        $timestamp = "2021-02-25 16:00:00";
        $task_id = 289;
        $msg_body = "We noticed that you have not accessed the application in while, is there a problem";


        $result = array();
        $data = array();

        $data["message_id"] = $message_id;
        $data["recipient_id"] = intval($recipient_id);
        $data["recipient_network"] = $recipient_network_id;
        $data["sender_id"] = intval($sender_id);
        $data["sender_network"] = $sender_network_id;
        $data["task_id"] = intval($task_id);
        $data["timestamp"] = $timestamp;
        $data["body"] = $msg_body;


        $result["status"] = STATUS_OK;
        $result["message_data"] = $data;





        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
    }
    //almost done todo add email
    if ($action == "send_direct_message"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $msg_data =             $data["message_data"];
        $recipient_network =    text_clean($msg_data["recipient_network_id"]);
        $task_id_ =             text_clean($msg_data["task_id"]);
        $body =                 text_clean($msg_data["body"]);

        //$body = mb_convert_encoding(($MSG_DATA["body"]), 'UTF-8', 'ISO-8859-1');


        //$message_id = generate_msg_id();
        $message_id = generate_unique_id(UNIQUE_MSG);
        $recipient_id = null;
        //$recipient_network_id = $recipient_network;
        $recipient_network_id = getQuestCreatorNetwork($task_id_,$paperweight);
        $sender_id = $user_id;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = $task_id_;
        $msg_body = $body;
        $msg_type = "msg_text";


        $result = array();
        $data = array();

        $data["message_id"] = $message_id;
        $data["recipient_id"] = intval($recipient_id);
        $data["recipient_network"] = $recipient_network_id;
        $data["sender_id"] = intval($sender_id);
        $data["sender_network"] = $sender_network_id;
        $data["task_id"] = intval($task_id);
        $data["timestamp"] = $timestamp;
        $data["body"] = $msg_body;

        $data["image_url"] = "https://queritel.com/assets/img/persons/03.png";



        $result["status"] = STATUS_ERROR;

        $send_msg = "insert into " . TABLE_MESSAGE . " (message_id, send_time, sender_id, message_body, send_lat, send_lon, task_id, recipient_network_id, message_type) values ('$message_id','$timestamp','$sender_id','$msg_body','$lat','$lng','$task_id','$recipient_network_id','$msg_type')";
        $send_msg_result = $paperweight->query($send_msg);

        if($send_msg_result != null && $send_msg_result->is_row_affected()){
            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;
                //broadcast update to researcher and admin
            }*/

            $result["status"] = STATUS_OK;
            $result["message_data"] = $data;

        }





        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
    }



    if ($action == "get_message_list_client"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $task_id =  text_clean($data["task_id"]);

        if ($user_id == 125){
            //$user_id = 35;
            //$task_id = 292;
        }

        //$login_token =  text_clean($data["task_id"]);

        //$lat =          text_clean($data["lat"]);
        //$lng =          text_clean($data["lng"]);

        $network_id = "";
        //$sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
            //$sender_network_id = $network_id;
        }

        $quest_creator = getQuestCreatorNetwork($task_id,$paperweight);




        $result = array();
        $data_array = array();
        $message_list = array();

        $result["status"] = STATUS_OK;
        $result["network_id"] = $network_id;
        $result["message_list"] = array();

        $val = '{
                    "status": "OK",
                    "network_id": "",
                    "message_list": [
                        {
                            "user_id" : "329",
                            "fname" : "Kevin",
                            "lname" : "Smith",
                            "msg_body" : "Restart your application kevin",
                            "timestamp" : "2021-03-12 23:17:08",
                            "unread": 0
                        },
                        {
                            "user_id" : "121",
                            "fname" : "Kadan",
                            "lname" : "Salmon",
                            "msg_body" : "Did you confirm that your location was on?",
                            "timestamp" : "2021-03-12 18:05:41",
                            "unread": 0
                        }
                    ]
                }';


        if ($network_id == $quest_creator){

            $linked_agents = getQuestAgents($task_id, $paperweight);
            if (!empty($linked_agents)){

                foreach ($linked_agents as $agent) {
                    $last_msg = getLastMsg($agent["user_id"],$network_id,$task_id,$paperweight);

                    $data_array["user_id"] = $agent["user_id"];
                    $data_array["fname"] = $agent["fname"];
                    $data_array["lname"] = $agent["lname"];

                    $data_array["msg_body"] = $last_msg["msg_body"];
                    $data_array["timestamp"] = $last_msg["timestamp"];
                    $data_array["unread"] = $last_msg["unread"];

                    $message_list[] = $data_array;

                }

            }

        }

        $result["message_list"] = $message_list;



        //289 -- my

        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo json_export($result);
        //echo generate_msg_id();
    }
    if ($action == "send_direct_message_client_multi"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $task_id =  text_clean($data["task_id"]);
        $agent_id =          text_clean($data["agent_id"]);


        $sample_msg_body_en = "Earn Money Recommending Queritel to New People. 

Earn 100 JMD for Every Successful recommendation made.

Invite other persons between the ages of 18-55 to sign up on the Queritel app using your user code. You can find your user code in the profile section of your Queritel app.

For each person who is recruited they must become activated by completing their first Quest to Qualify as a Successful Recruit.

At the end of each week recommendations are reviewed and your Queritel wallet is updated. 

This offer runs from September 27 to October 31 2021.";


        $sample_msg_body_cl = "GANA DINERO RECOMENDANDO QUERITEL A NUEVAS PERSONAS. 

Gana 700 CLP por cada recomendación realizada con éxito.
Invita a personas de entre 18 y 55 años a registrarse en la aplicación Queritel utilizando tu código de usuario. Puedes encontrar tu código de usuario en la sección de perfil de tu app Queritel.

Cada persona reclutada debe activarse completando su primera Búsqueda para calificar como Reclutamiento Exitoso.
Al final de cada semana se revisan las recomendaciones y se actualiza tu billetera Queritel.

Esta oferta está vigente del 27 de septiembre al 31 de octubre de 2021";


        $sample_msg_body_pr = "GANA DINERO RECOMENDANDO QUERITEL A NUEVAS PERSONAS. 

Gana $0.50 USD por cada recomendación realizada con éxito.
Invita a personas de entre 18 y 55 años a registrarse en la aplicación Queritel utilizando tu código de usuario. Puedes encontrar tu código de usuario en la sección de perfil de tu app Queritel.
Cada persona reclutada debe activarse completando su primera Búsqueda para calificar como Reclutamiento Exitoso.
Al final de cada semana se revisan las recomendaciones y se actualiza tu billetera Queritel.

Esta oferta está vigente del 27 de septiembre al 31 de octubre de 2021";

        //$msg_body =          text_clean($data["body"]);
        $msg_body =          text_clean($sample_msg_body_pr);

        //$MSG_DATA =             $data["message_data"];
        //$recipient_id_ =        text_clean($MSG_DATA["recipient_id"]);
        //$sender_network_id_ =   text_clean($MSG_DATA["sender_network_id"]);
        //$task_id_ =             text_clean($MSG_DATA["task_id"]);
        //$body =                 text_clean($MSG_DATA["body"]);


        //sendNewQuestNotification($paperweight,"PR");


        /*
        "user_id": USER_ID,
            "task_id": QUEST_ID,
            "agent_id": agent_id,
            "body" : msg*/

        $network_id = "";
        $sender_network_id = "";

        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
            $sender_network_id = $network_id;
        }


        $task_id = null;
        $country_code = "PR";

        $sql_query = "select * from " . TABLE_USERS . " where country_code = '$country_code'";// and user_id = '1856'
        $sql_query_result = $paperweight->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            while($row = $sql_query_result->fetch_array()){

                $agent_id = $row["user_id"];

                $message_id = generate_unique_id(UNIQUE_MSG);
                $recipient_id = $agent_id;

                //$recipient_network_id = $recipient_network;
                //$recipient_network_id = getQuestCreatorNetwork($task_id_,$paperweight);
                $sender_id = $user_id;
                //$sender_network_id = $sender_network_id_;
                $timestamp = getCurrentTime();
                //$task_id = $task_id_;
                //$msg_body = $body;
                $msg_type = "msg_text";


                $result = array();
                $data_new = array();

                $data_new["message_id"] = $message_id;
                $data_new["recipient_id"] = $recipient_id;
                $data_new["recipient_network"] = null;
                $data_new["sender_id"] = $sender_id;
                $data_new["sender_network"] = $sender_network_id;
                $data_new["task_id"] = $task_id;
                $data_new["timestamp"] = $timestamp;
                $data_new["body"] = clean_reverse($msg_body);

                //$result["status"] = STATUS_ERROR;



                $result["status"] = STATUS_OK;
                $result["message_data"] = $data_new;

                $send_msg = "insert into " . TABLE_MESSAGE . " (message_id, send_time, sender_id, recipient_id, message_body, task_id, sender_network_id, message_type) values ('$message_id','$timestamp','$sender_id','$recipient_id','$msg_body','$task_id','$sender_network_id','$msg_type')";
                $send_msg_result = $paperweight->query($send_msg);
                //$send_msg_result = null;

                if($send_msg_result != null && $send_msg_result->is_row_affected()){
                    //success

                    //$update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                    //$update_result = $this->db_connector->query($update_job);

                    /*if($update_result != null && $update_result->is_row_affected()){
                        $result["status"] = STATUS_OK;


                        //broadcast update to researcher and admin

                    }*/

                    $result["status"] = STATUS_OK;
                    $result["message_data"] = $data_new;

                    sendNewMessageNotification($agent_id,$paperweight);

                }

            }
        }

        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
    }
    if ($action == "send_direct_message_client"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $task_id =  text_clean($data["task_id"]);
        $agent_id =          text_clean($data["agent_id"]);
        $msg_body =          text_clean($data["body"]);

        //$MSG_DATA =             $data["message_data"];
        //$recipient_id_ =        text_clean($MSG_DATA["recipient_id"]);
        //$sender_network_id_ =   text_clean($MSG_DATA["sender_network_id"]);
        //$task_id_ =             text_clean($MSG_DATA["task_id"]);
        //$body =                 text_clean($MSG_DATA["body"]);



        /*
        "user_id": USER_ID,
            "task_id": QUEST_ID,
            "agent_id": agent_id,
            "body" : msg*/

        $network_id = "";
        $sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
            $sender_network_id = $network_id;
        }



        $message_id = generate_unique_id(UNIQUE_MSG);
        $recipient_id = $agent_id;
        //$recipient_network_id = $recipient_network;
        //$recipient_network_id = getQuestCreatorNetwork($task_id_,$paperweight);
        $sender_id = $user_id;
        //$sender_network_id = $sender_network_id_;
        $timestamp = getCurrentTime();
        //$task_id = $task_id_;
        //$msg_body = $body;
        $msg_type = "msg_text";


        $result = array();
        $data_new = array();

        $data_new["message_id"] = $message_id;
        $data_new["recipient_id"] = intval($recipient_id);
        $data_new["recipient_network"] = null;
        $data_new["sender_id"] = intval($sender_id);
        $data_new["sender_network"] = $sender_network_id;
        $data_new["task_id"] = intval($task_id);
        $data_new["timestamp"] = $timestamp;
        $data_new["body"] = clean_reverse($msg_body);



        //$result["status"] = STATUS_ERROR;



        $result["status"] = STATUS_OK;
        $result["message_data"] = $data_new;

        $send_msg = "insert into " . TABLE_MESSAGE . " (message_id, send_time, sender_id, recipient_id, message_body, task_id, sender_network_id, message_type) values ('$message_id','$timestamp','$sender_id','$recipient_id','$msg_body','$task_id','$sender_network_id','$msg_type')";
        $send_msg_result = $paperweight->query($send_msg);

        if($send_msg_result != null && $send_msg_result->is_row_affected()){
            //success

            //$update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
            //$update_result = $this->db_connector->query($update_job);

            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;


                //broadcast update to researcher and admin

            }*/

            $result["status"] = STATUS_OK;
            $result["message_data"] = $data_new;

            sendNewMessageNotification($agent_id,$paperweight);

        }





        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
    }
    if ($action == "get_direct_message_thread_client"){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$network_id =  text_clean($data["network_id"]);//
        $task_id =  text_clean($data["task_id"]);
        $agent_id =  text_clean($data["agent_id"]);



        //$lat =          text_clean($data["lat"]);
        //$lng =          text_clean($data["lng"]);

        /*

        chatBubble1.setMessageId("udhfytb-7487365-HTRDYTI");
        chatBubble1.setRecipientId(329);
        chatBubble1.setSenderId(-1);
        chatBubble1.setSenderNetwork("nid_jsy827459OFksye");
        chatBubble1.setRecipientNetwork(null);
        chatBubble1.setTimestamp("2021-02-25 16:00:00");
        chatBubble1.setTask_id(292);
        chatBubble1.setRead(false);//have i marked this message as [READ] (i am the recipient)
        chatBubble1.setBelongToCurrentUser(false);//was this message sent by me (this is not mine becuz i didnt send it)
        chatBubble1.setMsgBody("We noticed that you have not accessed the application in while, is there a problem");

      */
        /*"status": "OK",
       "message_thread": [
           {
               "message_id": "pywxqjo-7175664-RRTWUNB",--
               "recipient_id": 0,--
               "recipient_network": "nid_jsy827459OFksye",--
               "sender_id": 329,--
               "sender_network": null,--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body"
           },
           {
               "message_id": "jfhyfgr-8476395-HDKDJGT",--
               "recipient_id": 329,--
               "recipient_network": null,--
               "sender_id": 0,--
               "sender_network": "nid_jsy827459OFksye",--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body sent by the company"
           }
       ]
        */

        $network_id = "";
        $sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
        }

        $quest_creator = getQuestCreatorNetwork($task_id,$paperweight);

        if ($network_id == $quest_creator){
            $sender_network_id = "$network_id";
        }

        $result = array();
        $data = array();
        $message_thread = array();



        /*

        $message_id = "pywxqjo-7175664-RRTWUNB";
        $recipient_id = 0;
        $recipient_network_id = "nid_jsy827459OFksye";
        $sender_id = 329;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = 289;
        $msg_body = "this is my message body";




        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;



        $message_id = "jfhyfgr-8476395-HDKDJGT";
        $recipient_id = 329;
        $recipient_network_id = null;
        $sender_id = 0;
        $sender_network_id = "nid_jsy827459OFksye";
        $timestamp = "2021-03-11 08:14:58";
        $task_id = 289;
        $msg_body = "this is my message body sent by the company";

        $index = 1;

        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;
        //$data[$index]["body"] = "Hello kadian";
        */


        $result["status"] = STATUS_OK;
        //$result["agent_id"] = $agent_id;
        $result["message_thread"] = array();

        //if sender is not null (check if user is sender)


        $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$sender_network_id' or recipient_network_id = '$sender_network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
        $msg_result = $paperweight->query($msg_query);

        if($msg_result != null && $msg_result->is_row_found()){

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = $row["message_body"];

                $data["message_id"] = $message_id;
                $data["recipient_id"] = intval($recipient_id);
                $data["recipient_network"] = $recipient_network_id;
                $data["sender_id"] = intval($sender_id);
                $data["sender_network"] = $sender_network_id;
                $data["task_id"] = intval($task_id);
                $data["timestamp"] = $timestamp;
                $data["body"] = $msg_body;

                $message_thread[] = $data;

            }

            $result["status"] = STATUS_OK;
            $result["message_thread"] = $message_thread;

        }








        /*$researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);
            $result = $researcher->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo json_export($user_id);
    }



    if ($action == ''){
        $data = json_decode($param_json, true);

        $user_id = strtolower(clean($data["user_id"]));
        $login_token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);

        $obj = $researcher->signout($user_id, $login_token);

        echo json_encode($obj);
    }
    if ($action == ''){
        $data = json_decode($param_json, true);

        $user_id = strtolower(clean($data["user_id"]));
        $login_token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);

        $obj = $researcher->signout($user_id, $login_token);

        echo json_encode($obj);
    }
    if ($action == ''){
        $data = json_decode($param_json, true);

        $user_id = strtolower(clean($data["user_id"]));
        $login_token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);

        $obj = $researcher->signout($user_id, $login_token);

        echo json_encode($obj);
    }
    if ($action == ''){
        $data = json_decode($param_json, true);
    }
    if ($action == 'debug_verify'){
        $data = json_decode($param_json, true);

        $id = strtolower(clean($data["user_id"]));
        $token = clean($data["login_token"]);


        $researcher = new Researcher($paperweight);

        $obj = $researcher->verifyLogin($id, $token);
        echo json_encode($obj);

    }


    //todo - update : completed_quest | active_quest | xp_points | earning_data
    if ($action == ACTION_GET_USER_DATA){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            /*
                user_data.occupation = result_obj["occupation"];
                user_data.education = result_obj["education"];
                user_data.employment_status = result_obj["employment_status"];
                user_data.marital_status = result_obj["marital_status"];
                user_data.phone_model = result_obj["phone_model"];
            */

            $user_data["fname"] = stringCase($researcher->get_firstName(),STRING_CASE_CAP_FIRST);
            $user_data["lname"] = stringCase($researcher->get_lastName(),STRING_CASE_CAP_FIRST);
            $user_data["user_name"] = $researcher->get_screenName();
            $user_data["email"] = $researcher->get_email();
            $user_data["user_ref"] = $researcher->getUserRefId();
            $user_data["gender"] = $researcher->get_gender();
            $user_data["reg_date"] = $researcher->get_registrationDate();
            $user_data["phone_number"] = $researcher->get_phoneNumber();
            $user_data["location_address"] = $researcher->getLocationAddress();
            $user_data["location_city"] = $researcher->get_locationCity();
            $user_data["location_state"] = $researcher->get_locationState();
            $user_data["country_name"] = $researcher->get_locationCountry();
            $user_data["country_code"] = $researcher->getLocationCountryCode();
            $user_data["date_of_birth"] = $researcher->getDateOfBirth();
            $user_data["language_code"] = $researcher->getLanguageCode();
            $user_data["occupation"] = $researcher->getOccupation();
            $user_data["education"] = $researcher->getEducation();
            $user_data["ethnicity"] = $researcher->getEthnicity();
            $user_data["marital_status"] = $researcher->getMaritalStatus();
            $user_data["employment_status"] = $researcher->getEmploymentStatus();
            $user_data["employment_industry"] = $researcher->getEmploymentIndustry();
            $user_data["profile_lock"] = !$researcher->isProfileSurveyCompleted();

            $user_data["completed_quest"] = 0;
            $user_data["active_quest"] = 0;
            $user_data["xp_points"] = 0;

            $earning_data = array();
            $earning_data["amount_earned"] = 0;
            $earning_data["currency"] = $researcher->getCurrencyCode();

            $user_data["earning_data"] = $earning_data;

            $result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    //todo : incomplete -> ACTION_CHANGE_PASSWORD = "change_password"
    if ($action == "change_password"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $old_password = text_clean($data["password"]);
        $new_password = text_clean($data["new_password"]);

        //todo : API Debug
        //debugAPIResponse("change_password",json_encode($data,JSON_PRETTY_PRINT));



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            //$researcher->setCurrentLocation($lat,$lng);

            debugGeneralLog($action,$data, $researcher);

            if (encryptPassword($old_password) == $researcher->get_encrytedPassword()){
                $result = $researcher->getOKStatus();
            }
            else{
                $result = $researcher->getErrorStatus(ERROR_MSG_INVALID_CRED);
            }

            /* Request
            {
                    "user_id": 21654,
                    "login_token": 849345537,
                    "password": "my.pass", //([The user's current password])
                    "new_password": "my.new.pass" //([The new password])
                }
            */

        }

        echo json_export($result);
    }



    //define("ACTION_SEND_NOTIFICATION_ID", "send_notification_id");
    //ACTION_SEND_NOTIFICATION_ID = "send_notification_id"


    //debug api actions
    if ($action == "__demo__"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //token_id, notification_id, notification_hash, user_id
            $user_id = "329";
            $login_token = "54775555";
            //$notification_id1 = "clSNTsi3SY6VvcdI_hdjlN:APA91bFw1Zw9KW4XsHGgrWRtc-8VBRhRabNdd74FzAyxNzN-rYH8uOJgsM3iq0qq8yEI4jgtSUqpjHqM1dZZfFjjl2ycyf1vWc6aH16VaupTPLLQdGhdzmgYH10DP7Vni325mR8KCPRt";
            //$notification_id1 = "clSNTsi3SY6VvcdI_hdjlN:APA91bFw1Zw9KW4XsHGgrWRtc-8VBRhRabNdd74FzAyxNzN-rYH8uOJgsM3iq0qq8yEI4jgtSUqpjHqM1dZZfFjjl2ycyf1vWc6aH16VaupTPLLQdGhdzmgYH10DP7Vni325mR8KCPRt";
            //$notification_hash = md5($notification_id);
            //$notification_id1_ios = "fDesJRrw503tt8Fpu8ahkD:APA91bEfcIcy-j5Ajcwgel1nMB01gh98ZA-yfeP-d4z2CMJWX6AnSRxsZC92ATvrQwHzEZ-GZC2n_PKOiI3OQV_6rR7GDUX1br2590Jjhqw2t_hsAJg8QYb-2RA1F7rYKmpdHde5j4aM";
            //$notification_id1_ios = "cdHUyQZrcUOhiCaz5IGJJh:APA91bEzNd_k8oQ3crl6LYhJsXVrnGOBGOQevodstHuvnx7pgWKYq3WT_4fq-JN9GM68VkUoVh6VlLAIm_PWCBnvdb4u-Nf6kfpOHm0xKmNwnoGWoaASWr3PhUwqnxqnZOmRY29v5_6y";
            //$notification_id1_ios = "cdHUyQZrcUOhiCaz5IGJJh:APA91bEzNd_k8oQ3crl6LYhJsXVrnGOBGOQevodstHuvnx7pgWKYq3WT_4fq-JN9GM68VkUoVh6VlLAIm_PWCBnvdb4u-Nf6kfpOHm0xKmNwnoGWoaASWr3PhUwqnxqnZOmRY29v5_6y";
            $notification_id1_ios_old = "fDesJRrw503tt8Fpu8ahkD:APA91bEfcIcy-j5Ajcwgel1nMB01gh98ZA-yfeP-d4z2CMJWX6AnSRxsZC92ATvrQwHzEZ-GZC2n_PKOiI3OQV_6rR7GDUX1br2590Jjhqw2t_hsAJg8QYb-2RA1F7rYKmpdHde5j4aM";
            $notification_id1_ios_old2 = "cdHUyQZrcUOhiCaz5IGJJh:APA91bEzNd_k8oQ3crl6LYhJsXVrnGOBGOQevodstHuvnx7pgWKYq3WT_4fq-JN9GM68VkUoVh6VlLAIm_PWCBnvdb4u-Nf6kfpOHm0xKmNwnoGWoaASWr3PhUwqnxqnZOmRY29v5_6y";
            $notification_id1_ios_old3 = "dY8vSMqqg039npxgsgAwhR:APA91bGB4miOoywcPxaIvFY-9bo7kYhKAq0EbRYuIbLqJBP-uI1m-cAoi8gIbKab8Q0NUK5uQKJKmUux4ZpU5I7kikGG5ttdcCWtoEj7gdpmhN5K9hVQFK9u3ddydn3r6Di8XSz-X5Mn";
            $notification_id1_ios = "c0jN-zbavkm0i-HlDGUPYP:APA91bEzfZ1s0vVaKqGqYYcYDPLacI23Adu3hr63PZplDJpjG81IIuaN70stZx_k9giHJJXn2neZK4YdTcfT4xj--RyY5YEiLNTJ075HVqaEGqQmFbQuTyrGpYoPT4tGOuy0UNQuHui3";
            $notification_id1_android = "dfbrByvTTM-7ls9--Nnykx:APA91bH7Q6n0c514bpaythCWys0ThmRlGSeSmQLzl8DyGZ8D5Zt0VcjeYVXROOAyMhQ_MVHVZQiLZLFKieZ7LfusPhgaYBxFChPlAJBOSO8-ajHgPEfJDeMccUKOC9jKO42zfOxHF3C4";

            //$notification_id1_ios = "dY8vSMqqg039npxgsgAwhR:APA91bGB4miOoywcPxaIvFY-9bo7kYhKAq0EbRYuIbLqJBP-uI1m-cAoi8gIbKab8Q0NUK5uQKJKmUux4ZpU5I7kikGG5ttdcCWtoEj7gdpmhN5K9hVQFK9u3ddydn3r6Di8XSz-X5Mn";
            //sendNewQuestNotification($paperweight,"JM");
            //sendNewQuestNotification($paperweight,"CL");
            //sendNewQuestNotification($paperweight,"PR");
            //sendNewMessageNotification(329,$paperweight);
            //$researcher->removeAllNotificationToken();

            /*{
                "aps" : {
                "alert" : {
                    "body" : "great match!",
                    "title" : "Portugal vs. Denmark",
                },
                "badge" : 1,
                },
                "customKey" : "customValue"
            }*/

            /*,
              "payload": {
                    "status": "new_quest",
                    "extra": {
                        "message": "empty"
                    }
                }*/




            $stri = '{
                    "to": "' . $notification_id1_ios . '",
                    "data": {
                        "action": "action",
                        "anyThing": "message_title",
                        "anyOtherThing": "message_body"
                    },
                    "notification": {
                        "body": "Message title available here",
                        "title": "The content of the nneotification 2",
                        "icon": "app_icon"
                    }
             }';

            $stri_and_works = '{
                    "to": "' . $notification_id1_ios . '",
                    "data": {
                        "payload": {
                            "status": "new_quest",
                            "extra": {
                                "message": "testing"
                            }
                        }
                    },
                    "notification": {
                        "body": "Message title available here  -- thus s",
                        "title": "The content of the notification 2",
                        "icon": "app_icon"
                    }
             }';

            //"priority" : "high"
            $stri_and_works_android = '{
                    "to": "' . $notification_id1_android . '",
                    "content_available": false,
                    "data": {
                        "payload": {
                            "status": "new_quest",
                            "extra": {
                                "message": "testing"
                            }
                        }
                    },
                    "notification": {
                        "body": "Message title available here  -- new",
                        "title": "The content of the notification 2",
                        "icon": "app_icon"
                    }
             }';
            $stri_and_works_ios = '{
                    "to": "' . $notification_id1_ios . '",
                    "data": {
                        "payload": {
                            "status": "new_quest",
                            "extra": {
                                "message": "testing"
                            }
                        }
                    },
                    "notification": {
                        "body": "Message title available here  -- thus s",
                        "title": "The content of the notification 2",
                        "icon": "app_icon"
                    }
             }';

            $stri_and_works_ios_without = '{
                    "to": "' . $notification_id1_ios . '",
                    "content_available": true,
                    "data": {
                        "payload": {
                            "status": "new_quest",
                            "extra": {
                                "message": "testing"
                            }
                        }
                    }
             }';
            $stri_and_works_ios_without_2 = '{
                    "to": "' . $notification_id1_ios . '",
                    "content_available": false,
                    "data": {
                        "payload": {
                            "status": "new_quest",
                            "extra": {
                                "message": "testing"
                            }
                        }
                    },
                    "notification": {
                        "body": "Message title available here  -- thus s",
                        "title": "The content of the notification 2",
                        "icon": "app_icon"
                    }
             }';




            $test_obj = json_decode($stri_and_works_ios_without,true);

            //$test_obj["registration_ids"] = array($notification_id1_ios,$notification_id1_android);
            //$test_obj["registration_ids"] = array($notification_id1_ios);

            /*$message = array();
            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = "iOS, official Notification Test";
            $message["payload"] = $payload;*/
            //sendFCM($message,$notification_id1_ios);
            //
            //
            //todo sendFCM($test_obj,$notification_id1_ios);


            $id = $notification_id1_ios;
            //$id = $notification_id1_android;

            $url = 'https://fcm.googleapis.com/fcm/send';
            $fields = array();
            $fields['data'] = $test_obj;
            if (is_array($id)) {
                $fields["registration_ids"] = $id;
            }
            else {
                $fields["to"] = $id;
            }
            //$encoded_fields = json_encode($fields);
            //$encoded_fields = json_encode($test_obj);
            //$headers = array(
            //    'Authorization: key=' . FIREBASE_SERVER_KEY,
            //    'Content-Type: application/json'
            //);
            //$ch = curl_init();
            //curl_setopt($ch, CURLOPT_URL, $url);
            //curl_setopt($ch, CURLOPT_POST, true);
            //curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            //curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            //curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

            //$result = curl_exec($ch);
            //echo $result;
            //curl_close($ch);


            //echo json_encode($test_obj);

            //$message = array();

            //$payload = array();
            //$payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
            //$payload["extra"]["message"] = "empty";

            //$message["payload"] = $payload;

            //$sub["payload"] = $payload;

            //$message["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;

            //sendFCM($message,$notification_id1);

            //$updated = $researcher->updateNotificationToken($notification_id1);
            //$updated = $researcher->removeNotificationToken();
            //$updated = $researcher->removeAllNotificationToken();




            //$sub["update_notification"] = $updated;

            //$rec = array();

            //modify Chilean RUT in database
            /*$pending_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where country_code = 'CL' and tax_id_number is not null";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $rut_user = $row["tax_id_number"];
                    $user_id_code = $row["user_id"];

                    $rut_data = verifyRUT($rut_user);
                    $tax_id_number = $rut_data["rut"];
                    if ($rut_data["verified"]){
                        $full_name = $rut_data["full_name"];

                        $rec[$rut_user]["user_id"] = $row["user_id"];
                        $rec[$rut_user]["full_name"] = $full_name;
                        $rec[$rut_user]["formatted_rut"] = $tax_id_number;

                        $sql_query = "update " . TABLE_PAYOUT_ACCOUNT . " set `full_name` = '$full_name', `tax_id_number` = '$tax_id_number' where `user_id` = '$user_id_code'";
                        $sql_query_result = $paperweight->query($sql_query);
                    }

                }

                //$primary_balance = floatval($total_pending);

            }*/



            //$sub["rut_result"] = verifyRUT($extra);
            /*$task_id = 344;


            $result["result"] = getQuestAgents($task_id, $paperweight);


            //
            $primary_balance = 0; //vista
            $total_pending = 0;

            $index = 0;
            $rec = array();*/


            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];


                    if (($percent_completion < 100 && $percent_completion != 0) && $is_price_moderated == 0){
                        $_percent = $percent_completion / 100;
                        $new_price = $_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            $pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            /*$task_id = 390;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);
            sendNewQuestNotification($paperweight,"JM");*/
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;


            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

        // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }
    if ($action == "remove_incomplete_response"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];

                    if (($percent_completion < 100) && $is_price_moderated == 0){
                        $fifteen_percent = 0.15;
                        $new_price = $fifteen_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            $task_id = $extra;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
               while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);
            //sendNewQuestNotification($paperweight,"JM");
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;





            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

       // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }

    if ($action == "debug_insert_payment_not_approved"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //----todo PAYOUT----
            $pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0 and payment_id is null";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $assigned = $row["survey_count"];
                    $completed = $row["survey_completed"];
                    $percent_completion = $row["percent_completion"];
                    $local_currency = $row["local_currency"];
                    $local_currency_rate = $row["local_currency_rate"];
                    $price = $row["price"];
                    $currency = $row["currency"];
                    $task_id = $row["task_id"];
                    $sector_id = $row["job_id"];
                    $response_id = $row["response_id"];
                    $rec_user = $row["user_id"];


                    $update_time = getCurrentTime();
                    $payment_id = generate_unique_id(UNIQUE_PAYMENT);

                    $handled_externally = 0; //handled by queritel

                    $task_data = $researcher->getTaskRaw($task_id);
                    if ($task_data != null){
                        $handled_externally = $task_data["handle_payment"];
                    }


                    //update_time, payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate
                    //$update_time,$payment_id, $task_id, $sector_id, $response_id, $user_id, $price, $currency, $handled_externally, $local_currency, $local_currency_rate

                    //$rec_user
                    $insert_payment_query = "insert into " . TABLE_AGENT_PAYMENT . " (update_time,payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate) values ('$update_time','$payment_id','$task_id','$sector_id','$response_id','$rec_user','$price','$currency','$handled_externally','$local_currency','$local_currency_rate')";
                    $insert_payment_result = $paperweight->query($insert_payment_query);
                    if($insert_payment_result != null && $insert_payment_result->is_row_affected()){

                        $update = "update " . TABLE_RESPONSE . " set payment_id = '$payment_id', payment_date = '$update_time' where response_id = '$response_id' and user_id = '$rec_user'";
                        $update_result = $paperweight->query($update);
                        if($update_result != null && $update_result->is_row_affected()){}

                    }


                }

            }
            echo json_export($rec);
            //----todo PAYOUT----



            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];

                    if (($percent_completion < 100) && $is_price_moderated == 0){
                        $fifteen_percent = 0.15;
                        $new_price = $fifteen_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            /*$task_id = $extra;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);*/
            //sendNewQuestNotification($paperweight,"JM");
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;





            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

        // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }
    if ($action == "debug_insert_payment_approved"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //----todo PAYOUT----
            $pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1 and payment_id is null";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $assigned = $row["survey_count"];
                    $completed = $row["survey_completed"];
                    $percent_completion = $row["percent_completion"];
                    $local_currency = $row["local_currency"];
                    $local_currency_rate = $row["local_currency_rate"];
                    $price = $row["price"];
                    $currency = $row["currency"];
                    $task_id = $row["task_id"];
                    $sector_id = $row["job_id"];
                    $response_id = $row["response_id"];
                    $rec_user = $row["user_id"];


                    $update_time = getCurrentTime();
                    $payment_id = generate_unique_id(UNIQUE_PAYMENT);

                    $handled_externally = 0; //handled by queritel

                    $task_data = $researcher->getTaskRaw($task_id);
                    if ($task_data != null){
                        $handled_externally = $task_data["handle_payment"];
                    }


                    //update_time, payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate
                    //$update_time,$payment_id, $task_id, $sector_id, $response_id, $user_id, $price, $currency, $handled_externally, $local_currency, $local_currency_rate

                    //$rec_user
                    $insert_payment_query = "insert into " . TABLE_AGENT_PAYMENT . " (update_time,payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate,approved,approved_time) values ('$update_time','$payment_id','$task_id','$sector_id','$response_id','$rec_user','$price','$currency','$handled_externally','$local_currency','$local_currency_rate','1','$update_time')";
                    $insert_payment_result = $paperweight->query($insert_payment_query);
                    if($insert_payment_result != null && $insert_payment_result->is_row_affected()){

                        $update = "update " . TABLE_RESPONSE . " set payment_id = '$payment_id', payment_date = '$update_time' where response_id = '$response_id' and user_id = '$rec_user'";
                        $update_result = $paperweight->query($update);
                        if($update_result != null && $update_result->is_row_affected()){
                            $rec[] = "$payment_id -- paid --";
                        }

                    }


                }

            }
            echo json_export($rec);
            //----todo PAYOUT----



            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];

                    if (($percent_completion < 100) && $is_price_moderated == 0){
                        $fifteen_percent = 0.15;
                        $new_price = $fifteen_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            /*$task_id = $extra;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);*/
            //sendNewQuestNotification($paperweight,"JM");
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;





            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

        // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }


    if ($action == "insert_payment"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //----todo PAYOUT----
            $pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1 and payment_id is null";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $assigned = $row["survey_count"];
                    $completed = $row["survey_completed"];
                    $percent_completion = $row["percent_completion"];
                    $local_currency = $row["local_currency"];
                    $local_currency_rate = $row["local_currency_rate"];
                    $price = $row["price"];
                    $currency = $row["currency"];
                    $task_id = $row["task_id"];
                    $sector_id = $row["job_id"];
                    $response_id = $row["response_id"];
                    $rec_user = $row["user_id"];


                    $update_time = getCurrentTime();
                    $payment_id = generate_unique_id(UNIQUE_PAYMENT);

                    $handled_externally = 0; //handled by queritel

                    $task_data = $researcher->getTaskRaw($task_id);
                    if ($task_data != null){
                        $handled_externally = $task_data["handle_payment"];
                    }


                    //update_time, payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate
                    //$update_time,$payment_id, $task_id, $sector_id, $response_id, $user_id, $price, $currency, $handled_externally, $local_currency, $local_currency_rate

                    //$rec_user
                    $insert_payment_query = "insert into " . TABLE_AGENT_PAYMENT . " (update_time,payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate,approved,approved_time) values ('$update_time','$payment_id','$task_id','$sector_id','$response_id','$rec_user','$price','$currency','$handled_externally','$local_currency','$local_currency_rate','1','$update_time')";
                    $insert_payment_result = $paperweight->query($insert_payment_query);
                    if($insert_payment_result != null && $insert_payment_result->is_row_affected()){

                        $update = "update " . TABLE_RESPONSE . " set payment_id = '$payment_id', payment_date = '$update_time' where response_id = '$response_id' and user_id = '$rec_user'";
                        $update_result = $paperweight->query($update);
                        if($update_result != null && $update_result->is_row_affected()){
                            $rec[] = "$payment_id -- paid --";
                        }

                    }


                }

            }
            echo json_export($rec);
            //----todo PAYOUT----



            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];

                    if (($percent_completion < 100) && $is_price_moderated == 0){
                        $fifteen_percent = 0.15;
                        $new_price = $fifteen_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            /*$task_id = $extra;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);*/
            //sendNewQuestNotification($paperweight,"JM");
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;





            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

        // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }

    if ($action == "payment - migration"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $sub = array();
            $sub["current_user"] = $researcher->get_userId();



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";

            //----todo DEBUG SET LOCAL CURRENCY----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 3";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        $local = "JMD";
                        $local_rate = $researcher->getCurrencyRate($local);

                        $update_response = "update " . TABLE_RESPONSE . " set local_currency = '$local', local_currency_rate = '$local_rate' where response_id = '$response_id'";
                        $update_result = $paperweight->query($update_response);


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

               //$final_list = array();

               //foreach ($rec as $index => $item) {
               //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
               //        $final_list[] = $rec[$index];
               //    }
               //}

                //$primary_balance = floatval($total_pending);

            }
            //echo json_export($final_list);
            */
            //----todo DEBUG SET LOCAL CURRENCY----


            //--todo PAYOUT MIGRATION-----
            $pending_query = "select * from " . TABLE_AGENT_PAYMENT . " where approved = 1 and paid = 0 group by user_id";
            //$pending_query = "select * from " . TABLE_AGENT_PAYMENT . " where approved = 1 group by user_id";
            $pending_result = $paperweight->query($pending_query);
            $all_payment = array();
            if($pending_result != null && $pending_result->is_row_found()){
                while($row = $pending_result->fetch_array()){
                    $user_rec_id = $row["user_id"];
                    $local_currency = $row["local_currency"];

                    $user_data = query_user($user_rec_id, $paperweight);

                    $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                    $researcher->initializeResearcher($user_rec_id);
                    $researcher->setCurrencyCode($local_currency);

                    $current_wallet_data = $researcher->getWalletData();
                    //$result["wallet_data"] = $current_wallet_data;
                    //$result["bank_data"] = $bank_data;


                    if($current_wallet_data != null){
                        $currency_w = $current_wallet_data["currency"];
                        $available_amount_local = $current_wallet_data["available_amount"];
                        $usd_available_amount = $current_wallet_data["usd_available_amount"];

                        if ($bank_data["is_valid"]){}
                        else{
                            //todo - trigger payment auto migrate
                            $transaction_id = generate_unique_id(UNIQUE_TRANSACTION);
                            $transaction_time = getCurrentTime();
                            $transaction_amount = 0;

                            $account_id = null;
                            $account_type = null;

                            $local_amount = $current_wallet_data["available_amount"];


                            $insert_cash_query = "insert into " . TABLE_AGENT_CASH_OUT . " (transaction_id, account_id, account_type, transaction_time, user_id, transaction_amount) values ('$transaction_id','$account_id','$account_type','$transaction_time','$user_rec_id','$transaction_amount')";
                            $insert_cash_result = $paperweight->query($insert_cash_query);
                            if($insert_cash_result != null && $insert_cash_result->is_row_affected()){

                                $updated_usd = 0;
                                $local_funds_taken = 0; //local funds already accounted for


                                $payment_query = "select * from " . TABLE_AGENT_PAYMENT . " where user_id = '$user_rec_id' and local_currency = '$currency_w' and handled_externally = 0 and paid = 0 and approved = 1 order by amount desc";
                                $payment_result = $paperweight->query($payment_query);

                                if($payment_result != null && $payment_result->is_row_found()){
                                    while($row = $payment_result->fetch_array()){

                                        //payment_id, amount, local_currency, local_currency_rate, amount_paid

                                        $payment_id = $row["payment_id"];
                                        $local_currency_rate = $row["local_currency_rate"];
                                        $local_currency = $row["local_currency"];
                                        $amount = ($row["amount"] == null) ? 0 : $row["amount"];
                                        $amount_paid = ($row["amount_paid"] == null) ? 0 : $row["amount_paid"];
                                        $amount_remaining = $amount - $amount_paid;


                                        $local_converted_amount = floatval($amount_remaining * $local_currency_rate);

                                        if (round($local_funds_taken,3) < round($local_amount,3)){
                                            //if more funds are required

                                            $funds_required = ($local_amount - $local_funds_taken);

                                            if (round($funds_required,3) >= round($local_converted_amount,3)){
                                                //payment entry has less than or the exact amount required
                                                $subtracted_local_funds = ($local_converted_amount);
                                                $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                                                $new_amount_paid = ($amount_paid + $subtracted_usd_funds);
                                                $paid = 1;
                                                $paid_time = getCurrentTime();


                                                $insert_trans_query = "insert into " . TABLE_CASH_OUT_TRANSACTION . " (update_time, transaction_amount, local_currency, local_currency_rate, transaction_id, user_id, payment_id) values ('$transaction_time','$subtracted_usd_funds','$local_currency','$local_currency_rate','$transaction_id','$user_rec_id','$payment_id')";
                                                $insert_trans_result = $paperweight->query($insert_trans_query);
                                                if($insert_trans_result != null && $insert_trans_result->is_row_affected()){

                                                    $update_agent_payment = "update " . TABLE_AGENT_PAYMENT . " set amount_paid = '$new_amount_paid', paid = '$paid', paid_time = '$paid_time' where payment_id = '$payment_id' and user_id = '$user_rec_id'";
                                                    $update_agent_payment_result = $paperweight->query($update_agent_payment);
                                                    //if($update_agent_payment_result != null && $update_agent_payment_result->is_row_affected()){}

                                                }


                                                $local_funds_taken += $subtracted_local_funds;
                                                $updated_usd += $subtracted_usd_funds;
                                            }
                                            else{
                                                //payment entry has more than amount required
                                                $subtracted_local_funds = ($funds_required);
                                                $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                                                $new_amount_paid = ($amount_paid + $subtracted_usd_funds);
                                                $paid = 0;

                                                $insert_trans_query = "insert into " . TABLE_CASH_OUT_TRANSACTION . " (update_time, transaction_amount, local_currency, local_currency_rate, transaction_id, user_id, payment_id) values ('$transaction_time','$subtracted_usd_funds','$local_currency','$local_currency_rate','$transaction_id','$user_id','$payment_id')";
                                                $insert_trans_result = $paperweight->query($insert_trans_query);
                                                if($insert_trans_result != null && $insert_trans_result->is_row_affected()){

                                                    $update_agent_payment = "update " . TABLE_AGENT_PAYMENT . " set amount_paid = '$new_amount_paid', paid = '$paid' where payment_id = '$payment_id' and user_id = '$user_rec_id'";
                                                    $update_agent_payment_result = $paperweight->query($update_agent_payment);
                                                    //if($update_agent_payment_result != null && $update_agent_payment_result->is_row_affected()){}

                                                }

                                                $local_funds_taken += $subtracted_local_funds;
                                                $updated_usd += $subtracted_usd_funds;

                                            }

                                        }
                                        else{
                                            break;
                                        }


                                    }
                                }


                                $update_cashout = "update " . TABLE_AGENT_CASH_OUT . " set transaction_amount = '$updated_usd', approved = '1', approved_time = '$transaction_time', confirmed = '1', confirmed_time = '$transaction_time' where transaction_id = '$transaction_id' and user_id = '$user_rec_id'";
                                $update_result = $paperweight->query($update_cashout);
                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = $researcher->getOKStatus();
                                }

                            }

                            $obj = array();
                            $obj["user_id"] = $user_rec_id;
                            //$obj["wallet_data"] = $current_wallet_data;
                            //$obj["bank_data"] = $bank_data;
                            $all_payment[] = $obj;
                        }

                    }


                }

                $result = $all_payment;
            }
            //--todo PAYOUT MIGRATION-----


            //----todo PAYOUT----
            $pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1 and payment_id is null";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $assigned = $row["survey_count"];
                    $completed = $row["survey_completed"];
                    $percent_completion = $row["percent_completion"];
                    $local_currency = $row["local_currency"];
                    $local_currency_rate = $row["local_currency_rate"];
                    $price = $row["price"];
                    $currency = $row["currency"];
                    $task_id = $row["task_id"];
                    $sector_id = $row["job_id"];
                    $response_id = $row["response_id"];
                    $rec_user = $row["user_id"];


                    $update_time = getCurrentTime();
                    $payment_id = generate_unique_id(UNIQUE_PAYMENT);

                    $handled_externally = 0; //handled by queritel

                    $task_data = $researcher->getTaskRaw($task_id);
                    if ($task_data != null){
                        $handled_externally = $task_data["handle_payment"];
                    }


                    //update_time, payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate
                    //$update_time,$payment_id, $task_id, $sector_id, $response_id, $user_id, $price, $currency, $handled_externally, $local_currency, $local_currency_rate

                    //$rec_user
                    $insert_payment_query = "insert into " . TABLE_AGENT_PAYMENT . " (update_time,payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate,approved,approved_time) values ('$update_time','$payment_id','$task_id','$sector_id','$response_id','$rec_user','$price','$currency','$handled_externally','$local_currency','$local_currency_rate','1','$update_time')";
                    $insert_payment_result = $paperweight->query($insert_payment_query);
                    if($insert_payment_result != null && $insert_payment_result->is_row_affected()){

                        $update = "update " . TABLE_RESPONSE . " set payment_id = '$payment_id', payment_date = '$update_time' where response_id = '$response_id' and user_id = '$rec_user'";
                        $update_result = $paperweight->query($update);
                        if($update_result != null && $update_result->is_row_affected()){
                            $rec[] = "$payment_id -- paid --";
                        }

                    }


                }

            }
            echo json_export($rec);
            //----todo PAYOUT----



            //----todo MODERATE PAYOUT----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            //$clp_rate = $researcher->getCurrencyRate("CLP");

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $response_id = $row["response_id"];
                    $task_id = $row["task_id"];
                    $percent_completion = $row["percent_completion"];
                    $is_price_moderated = $row["is_price_moderated"];
                    $price = $row["price"];

                    if (($percent_completion < 100) && $is_price_moderated == 0){
                        $fifteen_percent = 0.15;
                        $new_price = $fifteen_percent * $price;

                        $dat = array();

                        $dat["User ID"] = $user_rec_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Response ID"] = $response_id;
                        $dat["Task ID"] = $task_id;
                        $dat["Old Price"] = $price;
                        $dat["Percent Completion"] = $percent_completion;
                        $dat["New Price"] = $new_price;

                        $rec[] = $dat;

                        $update_response_q = "update " . TABLE_RESPONSE . " set is_price_moderated = 1, original_price = $price, price = $new_price where response_id = '$response_id' and user_id = '$user_rec_id'";
                        $response_q_result = $paperweight->query($update_response_q);

                       // break;
                    }





                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                //$final_list = array();
                //foreach ($rec as $index => $item) {
                //    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                //        $final_list[] = $rec[$index];
                //    }
                //}

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($rec);*/
            //----todo MODERATE PAYOUT----


            //----todo PAYOUT (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }



                        //$rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;


                        //$sub_obj = array();
                        //$sub_obj["[Survey ID]"] = $row["survey_id"];
                        //$sub_obj["[Survey Token]"] = $row["survey_token"];
                        //$sub_obj["[Location ID]"] = $row["job_id"];
                        //$sub_obj["[Quest Price (USD)]"] = $row["price"];
                        //$sub_obj["[Quest Price (CLP)]"] = $researcher->getConvertedFunds($row["price"]);

                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (CLP)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;

                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];




                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (CL)----



            //----todo PAYOUT (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;



                        $sub_str = null;

                        $sub_str = "[Survey ID] = " . (empty($row["survey_id"]) ? "No-Data" : $row["survey_id"]) . " , ";
                        $sub_str .= "[Survey Token] = " . (empty($row["survey_token"]) ? "No-Data" : $row["survey_token"]) . " , ";
                        $sub_str .= "[Location ID] = " . $row["job_id"] . " , ";
                        $sub_str .= "[Completion] = " . $row["percent_completion"] . "% , ";
                        $sub_str .= "[Quest Price (USD)] = " . $row["price"] . " , ";
                        $sub_str .= "[Quest Price (JMD)] = " . $researcher->getConvertedFunds($row["price"]) . " <->";

                        $rec[$user_list[$user_rec_id]]["extra_data"][] = $sub_str;


                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 0.25) && ($rec[$index]["User ID"] != "1074") && ($rec[$index]["User ID"] != "329")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (JM)----


            //----todo PAYOUT (PR)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("USD");
            $researcher->setCurrencyCode("USD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && ($user_data["country_code"] == "PR" || $user_data["country_code"] == "US")){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (USD) at [" . $clp_rate . " USD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo PAYOUT (PR)----


            //----todo TOTAL EARNINGS (CL)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("CLP");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "CL"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["R.U.T (Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];


                        }



                        $rec[$user_list[$user_rec_id]]["Total Earned (USD)"] += $row["price"];

                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);

                        $rec[$user_list[$user_rec_id]]["Total Earned (CLP) at [" . $clp_rate . " CLP - 1 USD]"] = $converted_value;

                    }

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Total Earned (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);*/
            //----todo TOTAL EARNINGS (CL)----



            //----todo TOTAL EARNINGS (JM)----
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);
            $index = 0;
            $user_list = array();
            $rec = array();
            $clp_rate = $researcher->getCurrencyRate("JMD");
            $researcher->setCurrencyCode("JMD");
            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $user_rec_id = $row["user_id"];
                    $user_data = query_user($user_rec_id, $paperweight);


                    if (!empty($user_data) && $user_data["country_code"] == "JM"){

                        if (!isset($user_list[$user_rec_id])){
                            $user_list[$user_rec_id] = $index;
                            $index++;

                            $bank_data = $researcher->getPrimaryBankAccount($user_rec_id);

                            $rec[$user_list[$user_rec_id]]["User ID"] = $user_rec_id;
                            $rec[$user_list[$user_rec_id]]["First and Last Name"] = $user_data["fname"] . " " . $user_data["lname"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Sign Up)"] = $user_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Sign Up)"] = $user_data["user_email"];

                            $rec[$user_list[$user_rec_id]]["Has Banking Data"] = $bank_data["is_valid"];
                            $rec[$user_list[$user_rec_id]]["Full Name(Banking)"] = $bank_data["full_name"];
                            $rec[$user_list[$user_rec_id]]["Phone Number (Banking)"] = $bank_data["phone_number"];
                            $rec[$user_list[$user_rec_id]]["Email (Banking)"] = $bank_data["email"];
                            $rec[$user_list[$user_rec_id]]["User Address (Banking)"] = $bank_data["location_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Name (Banking)"] = $bank_data["bank_name"];
                            $rec[$user_list[$user_rec_id]]["Bank Address (Banking)"] = $bank_data["bank_address"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Number (Banking)"] = $bank_data["bank_account_number"];
                            $rec[$user_list[$user_rec_id]]["Bank Account Type (Banking)"] = $bank_data["bank_account_type"];
                            $rec[$user_list[$user_rec_id]]["Tax ID(Banking)"] = $bank_data["tax_id_number"];
                            //$rec[$user_list[$user_rec_id]]["Phone Number"] = $bank_data["full_name"];

                        }

                        $rec[$user_list[$user_rec_id]]["Amount (USD)"] += $row["price"];
                        $converted_value = $researcher->getConvertedFunds($rec[$user_list[$user_rec_id]]["Amount (USD)"]);
                        $rec[$user_list[$user_rec_id]]["Amount (JMD) at [" . $clp_rate . " JMD - 1 USD]"] = $converted_value;




                        //$rec[$user_rec_id]["user_id"] = $user_rec_id;
                        //$rec[$user_rec_id]["full_name"] = $user_data["fname"] . " " . $user_data["lname"];
                        //$rec[$user_rec_id]["price"] += $row["price"];

                    }

                    //$price = $row["price"];

                    //$total_pending += $price;

                }

                $final_list = array();

                foreach ($rec as $index => $item) {
                    if(($rec[$index]["Amount (USD)"] > 1) && ($rec[$index]["User ID"] != "1074")){
                        $final_list[] = $rec[$index];
                    }
                }

                //$primary_balance = floatval($total_pending);

            }
            echo json_export($final_list);
            */
            //----todo TOTAL EARNINGS (JM)----



            //----todo  GET UNCOMPLETED LOCATIONS ----
            /*$location_list = array();
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = 338";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select count(survey_completed) as completed_count from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 2";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){
                        $row2 = $res_result->fetch_array();

                        $count = $row2["completed_count"];

                        if ($count == 0){
                            $uncompleted = array();
                            $uncompleted["Address"] = $row["address"];
                            $uncompleted["Region"] = $row["state"];
                            $uncompleted["Country"] = $row["country"];
                            $uncompleted["Latitude"] = $row["location_lat"];
                            $uncompleted["Longitude"] = $row["location_lon"];
                            $uncompleted["Unique Location ID"] = $row["job_id"];
                            $uncompleted["Not Completed"] = true;
                            $uncompleted["Accepted by a Data Collector"] = $row["researcher_count"] != 0;
                            $uncompleted["Cost Per Submission"] = floatval($row["cpq"]);

                            $location_list[] = $uncompleted;
                        }
                    }
                }
            }
            */
            //echo json_export($location_list);
            //----todo GET UNCOMPLETED LOCATIONS ----


            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----
            /*$task_id = $extra;
            $user_count = 0;
            $pending_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id'";
            $pending_result = $paperweight->query($pending_query);
            if($pending_result != null && $pending_result->is_row_found()){
                while ($row = $pending_result->fetch_array()){
                    $job_id = $row["job_id"];
                    //$researcher_required = $row["researcher_required"];
                    //$researcher_count = $row["researcher_count"];

                    $res_query = "select * from " . TABLE_RESPONSE . " where job_id = '$job_id' and survey_state = 1";
                    $res_result = $paperweight->query($res_query);
                    if($res_result != null && $res_result->is_row_found()){

                        while ($row2 = $res_result->fetch_array()){
                            $response_id = $row2["response_id"];

                            $assigned = $row2["survey_count"];

                            $job = $researcher->getJobRaw($job_id);

                            $general_assigned = $job["survey_assigned"];
                            $researcher_count = $job["researcher_count"];


                            //set value for job instance
                            $new_assigned = $general_assigned - $assigned;
                            $new_researcher = $researcher_count - 1;

                            //set value for response
                            $survey_state = SURVEY_STATE_CANCELLED;

                            //update response to 'cancelled'
                            $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                            $response_q_result = $paperweight->query($update_response_q);

                            if($response_q_result != null && $response_q_result->is_row_affected()){
                                $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                                $update_result = $paperweight->query($update_job);

                                if($update_result != null && $update_result->is_row_affected()){
                                    $result = array();
                                    $result["status"] = STATUS_OK;

                                    $user_count++;
                                    //broadcast update to researcher and admin
                                }

                            }
                        }

                    }
                }
            }
            $result["msg"] = "$user_count Users Removed";
            echo json_export($result);*/
            //sendNewQuestNotification($paperweight,"JM");
            //----todo REMOVE USERS WITH INCOMPLETE RESPONSE ----


            //----todo  GET ASSIGNED COLLECTORS ----
            /*$collector_list = getQuestAgents(360, $paperweight);
            $output_list = array();

            foreach ($collector_list as $collector) {
                $output = array();
                $output["Unique ID"] = $collector["user_id"];
                $output["Full Name"] = $collector["fname"] . " " . $collector["lname"];
                $output["Phone Number"] = $collector["phone_number"];
                $output["Email"] = $collector["email"];

                $output_list[] = $output;
            }
            */
            //echo json_export($output_list);
            //----todo  GET ASSIGNED COLLECTORS ----

            //todo : add update due date to queritel web api
            //$result["result"] = updateDueDate($extra);
            //$result["result"] = $rec;





            //https://api.dingconnect.com/api/V1/SendTransfer
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/GetProducts");
            //$result = connectDingAPI("https://api.dingconnect.com/api/V1/SendTransfer");
        }

        // echo json_export($output_list);
        //echo json_export($location_list);
        //echo json_export($final_list);
        //echo json_export($result);
        //echo $result;
    }


    if ($action == "amazon_test"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $extra =        text_clean($data["extra"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){

            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            //email_payout_amazon("kadansalmon.ks@gmail.com","$100",strtoupper(getRandomString(20)), "en");
            //email_payout_amazon("kadansalmon.ks@gmail.com","$100",strtoupper(getRandomString(20)), "es");
            //email_payout_amazon("kadian.salmon@queritel.com","$100",strtoupper(getRandomString(20)), "en");

            //todo fix - google emails are not being delivered
            //echo email_agent_welcome("shani.bennett@queritel.com","Shani", $extra);
            //echo email_agent_welcome("kadian.salmon@queritel.com","Kadan", $extra);
            //echo email_agent_welcome("kadansalmon.ks@gmail.com","Kadan", $extra);

            // send the email
            //email_agent_welcome("kadian.salmon@queritel.com","Kadan", $extra);
            //email_payout_amazon("kadian.salmon@queritel.com","$10",strtoupper(getRandomString(20)), "es");
            //email_payout_amazon("kadian.salmon@queritel.com","$10",strtoupper(getRandomString(20)), "es");

            //email_payout_amazon("shani.bennett@queritel.com","$10",strtoupper(getRandomString(20)), "en");
            //email_payout_amazon("kadian.salmon@queritel.com","$10",strtoupper(getRandomString(20)), "en");

            //triggerEmailSMTP("","","","");

            //echo dirname(__DIR__);

            $result["result"] = "result triggered";
            //sendNewQuestNotificationUser($paperweight,"790"); //790
            //sendNewQuestNotificationUser($paperweight,"2241");
            //sendNewQuestNotificationUser($paperweight,"2003");
            //sendNewQuestNotificationUser($paperweight,"1858");
            //sendNewQuestNotificationUser($paperweight,"1857");
            //sendNewQuestNotificationUser($paperweight,"1856");
            //sendNewQuestNotificationUser($paperweight,"1855");
            //sendNewQuestNotificationUser($paperweight,"1701");
            //sendNewQuestNotificationUser($paperweight,"1419");
            //sendNewQuestNotificationUser($paperweight,"1389");
            //sendNewQuestNotificationUser($paperweight,"1245");
            //sendNewQuestNotificationUser($paperweight,"1237");
            //sendNewQuestNotificationUser($paperweight,"309");



        }

        echo json_encode($result);
    }



    if ($action == "get_primary_bank_account"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            //$result = $researcher->getAvailableJobs();
            $result = $researcher->getOKStatus();

            /*$code = '{
                  "status": "OK",
                  "account_data": {
                        "account_id": null
                    }
            }';*/

            //acc-bcdxrtz-4187457-taaawmm
            //"date_of_birth": "1997-08-28",
            /*$code = '{
                  "status": "OK",
                  "account_data": {
                        "account_id": "acc-bcdxrtz-4187457-taaawmm",
                        "version_code": 0,
                        "is_valid": true,
                        "fname": "Kadan",
                        "mname": "davros",
                        "lname": "Salmon",
                        "email": "kevin.smith@queritel.com",
                        "date_of_birth": "1997-08-28",
                        "phone_number": " 15555215554",
                        "country_code": "CL",
                        "location_state": "Region Metropolitana",
                        "location_city": "santiago",
                        "location_address": "185 Bellavista",
                        "bank_name": "BancoEstado",
                        "bank_address": "Bandera 66",
                        "bank_account_number": "756498576",
                        "bank_account_type": "Savings",
                        "tax_id_number": "272185964"
                    }
            }';*/
            /* $code = '{
                  "status": "OK",
                  "account_data": {
                        "account_id": "acc-bcdxrtz-4187457-taaawmm",
                        "version_code": 0,
                        "is_valid": false,
                        "fname": "Kadan",
                        "mname": "davros",
                        "lname": "Salmon",
                        "email": "kevin.smith@queritel.com",
                        "date_of_birth": "1997-08-28",
                        "phone_number": " 15555215554",
                        "country_code": "CL",
                        "location_state": "Region Metropolitana",
                        "location_city": "santiago",
                        "location_address": "185 Bellavista",
                        "bank_name": "BancoEstado",
                        "bank_address": "Bandera 66",
                        "bank_account_number": "756498576",
                        "bank_account_type": "Savings",
                        "tax_id_number": "272185964"
                    }
            }';*/

            /*$code = '{
                  "status": "OK",
                  "account_data": {
                        "is_valid": false,
                        "account_id": null,
                        "version_code": null,
                        "fname": "Kadan",
                        "mname": "davros",
                        "lname": "Salmon",
                        "email": "kevin.smith@queritel.com"


                    }
            }';

            $code_obj = json_decode($code,true);*/

            $result["account_data"] = $researcher->getPrimaryBankAccount();


        }

        echo json_export($result);
    }
    if ($action == "add_primary_bank_account"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse("add_primary_bank_account",json_encode($data,JSON_PRETTY_PRINT));



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            //$researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $add_account_success = false;
            $account_data_valid = true;

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_BANK_ACCOUNT;
            $creation_time = getCurrentTime();
            $user_id = $researcher->get_userId();
            $fname = stringCase(text_clean($data["fname"]));
            $mname = stringCase(text_clean($data["mname"]));
            $lname = stringCase(text_clean($data["lname"]));

            $email = stringCase(text_clean($data["email"]));
            $date_of_birth = text_clean($data["date_of_birth"]);
            $phone_number = text_clean($data["phone_number"]);
            $country_code = stringCase(text_clean($data["country_code"]),STRING_CASE_UPPER);
            $location_state = stringCase(text_clean($data["location_state"]));
            $location_city = stringCase(text_clean($data["location_city"]));
            $location_address = stringCase(text_clean($data["location_address"]));
            $bank_name = text_clean($data["bank_name"]);
            $bank_address = text_clean($data["bank_address"]);
            $bank_account_number = text_clean($data["bank_account_number"]);
            $bank_account_type = text_clean($data["bank_account_type"]);
            $tax_id_number = text_clean($data["tax_id_number"]);

            $full_name = null;


            //country specific consideration
            if (!empty($tax_id_number)){
                if ($country_code == COUNTRY_CHILE){
                    $rut_data = verifyRUT($tax_id_number);

                    $tax_id_number = $rut_data["rut"];

                    if ($rut_data["verified"]){
                        $full_name = $rut_data["full_name"];
                    }
                    else{
                        $result = $researcher->getErrorStatus(ERROR_MSG_INVALID_TAX_ID);
                        $account_data_valid = false;
                    }
                }
            }

            if ($account_data_valid){
                $add_account = "insert into " . TABLE_PAYOUT_ACCOUNT . " (account_id, account_type, creation_time, user_id, version_code, fname, mname, lname, email, date_of_birth, phone_number, country_code, location_state, location_city, location_address, bank_name, bank_address, bank_account_number, bank_account_type, tax_id_number,full_name) values('$account_id','$account_type','$creation_time','$user_id','$version_code','$fname','$mname','$lname','$email','$date_of_birth','$phone_number','$country_code','$location_state','$location_city','$location_address','$bank_name','$bank_address','$bank_account_number','$bank_account_type','$tax_id_number','$full_name')";
                $add_account_result = $paperweight->query($add_account);

                if($add_account_result != null && $add_account_result->is_row_affected()){

                    $add_account_success = true;

                }

                if ($add_account_success){
                    $result = $researcher->getOKStatus();

                    $result["account_id"] = $account_id;
                    $result["version_code"] = $version_code;
                }
            }


        }

        echo json_export($result);
    }
    if ($action == "update_primary_bank_account"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse("update_primary_bank_account",json_encode($data,JSON_PRETTY_PRINT));

        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        //$isVerified = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            //$researcher->setCurrentLocation($lat,$lng);

            //$result = $researcher->getOKStatus();
            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $add_account_success = false;
            $account_data_valid = true;

            $account_id = text_clean($data["account_id"]);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_BANK_ACCOUNT;
            $update_time = getCurrentTime();
            $user_id = $researcher->get_userId();
            $fname = stringCase(text_clean($data["fname"]));
            $mname = stringCase(text_clean($data["mname"]));
            $lname = stringCase(text_clean($data["lname"]));

            $email = stringCase(text_clean($data["email"]));
            $date_of_birth = text_clean($data["date_of_birth"]);
            $phone_number = text_clean($data["phone_number"]);
            $country_code = stringCase(text_clean($data["country_code"]),STRING_CASE_UPPER);
            $location_state = stringCase(text_clean($data["location_state"]));
            $location_city = stringCase(text_clean($data["location_city"]));
            $location_address = stringCase(text_clean($data["location_address"]));
            $bank_name = text_clean($data["bank_name"]);
            $bank_address = text_clean($data["bank_address"]);
            $bank_account_number = text_clean($data["bank_account_number"]);
            $bank_account_type = text_clean($data["bank_account_type"]);
            $tax_id_number = text_clean($data["tax_id_number"]);

            $full_name = null;


            //hh-----------
            if (!empty($account_id)){

                $account_data = $researcher->getPrimaryBankAccount();

                $version_code = $account_data["version_code"] + 1;

                //COUNTRY SPECIFIC CONSIDERATION
                if (!empty($tax_id_number)){

                    if ($country_code == COUNTRY_CHILE){
                        $rut_data = verifyRUT($tax_id_number);

                        $tax_id_number = $rut_data["rut"];

                        if ($rut_data["verified"]){
                            $full_name = $rut_data["full_name"];
                        }
                        else{
                            $result = $researcher->getErrorStatus(ERROR_MSG_INVALID_TAX_ID);
                            $account_data_valid = false;
                        }
                    }
                }

                if ($account_data_valid){

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `update_time` = '$update_time', `version_code` = '$version_code', `fname` = '$fname', `mname` = '$mname', `lname` = '$lname', `email` = '$email', `date_of_birth` = '$date_of_birth', `phone_number` = '$phone_number', `country_code` = '$country_code', `location_state` = '$location_state', `location_city` = '$location_city', `location_address` = '$location_address', `bank_name` = '$bank_name', `bank_address` = '$bank_address', `bank_account_number` = '$bank_account_number', `bank_account_type` = '$bank_account_type', `tax_id_number` = '$tax_id_number', `full_name` = '$full_name' where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $add_account_success = true;

                    }

                    if ($add_account_success){
                        $result = $researcher->getOKStatus();

                        $result["account_id"] = $account_id;
                        $result["version_code"] = $version_code;
                    }
                }

            }




            //Update  Set id, account_id, account_type, creation_time, update_time, user_id, deleted, deleted_time, version_code, fname, mname, lname, full_name, email, date_of_birth, phone_number, country_code, location_state, location_city, location_address, bank_name, bank_address, bank_account_number, bank_account_type, tax_id_number = @id, account_id, account_type, creation_time, update_time, user_id, deleted, deleted_time, version_code, fname, mname, lname, full_name, email, date_of_birth, phone_number, country_code, location_state, location_city, location_address, bank_name, bank_address, bank_account_number, bank_account_type, tax_id_number


            /*$account_data = $researcher->getPrimaryBankAccount();
            //$result = $researcher->getAvailableJobs();
            $result = $researcher->getOKStatus();
            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $result["account_id"] = $account_id;
            $result["version_code"] = $version_code;*/


        }

        echo json_export($result);
    }


    if ($action == "get_survey_image_link"){
        $data = json_decode($param_json, true);

        $user_id =        text_clean($data["user_id"]);
        $login_token =    text_clean($data["login_token"]);
        $original_name =  text_clean($data["original_name"]); //name with extension
        $local_path =     text_clean($data["local_path"]); //the file path on the users' device
        $lat =            text_clean($data["lat"]);
        $lng =            text_clean($data["lng"]);

        debugAPIResponse("get_survey_image_link",json_encode($data,JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng); //b5abacbb9d49f1066cc0bc35c533824a


            $timestamp = getCurrentTime();
            $random_seed = getRandomNumber(10);
            $random_name = md5($timestamp . $random_seed); //does not include extension

            $temporary = explode(".", $original_name);
            $file_extension = strtolower(end($temporary));


            $result = $researcher->getOKStatus();
            $result["image_name"] = $random_name;
            $result["local_path"] = $local_path;
            $result["image_link"] = "https://api.queritel.com/api/resources/images/insights/" . "$random_name.$file_extension";


        }

        echo json_export($result);
    }
    if ($action == "upload_survey_image"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$original_name =  text_clean($data["original_name"]); //name with extension
        $image_name =  text_clean($data["image_name"]); //name without extension
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        debugAPIResponse("upload_survey_image_prev",json_encode($data,JSON_PRETTY_PRINT));
        debugAPIResponse("upload_survey_image_prev_file",json_encode($_FILES,JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //$temporary = explode(".", $original_name);
            //$file_extension = strtolower(end($temporary));
            $validextensions = array("jpeg","jpg","png","gif");


            if (isset($_FILES["image"]["tmp_name"])){
                $fileName = $_FILES['image']['name'];
                $fileType = $_FILES['image']['type'];
                $fileSize = $_FILES["image"]["size"];
                $sourcePath = $_FILES['image']['tmp_name'];

                //todo : debug log
                $upload_log = array();
                $upload_log["user_log"] = $data;
                //$upload_log["user_log"]["lat"] = $lat;
                //$upload_log["user_log"]["lng"] = $lng;
                $upload_log["image_log"] = $_FILES;
                debugAPIResponse("upload_survey_image",json_encode($upload_log,JSON_PRETTY_PRINT));

                $temporary = explode(".", $fileName);
                $file_extension = strtolower(end($temporary));

                $full_name = "$image_name.$file_extension";
                $targetPath = "../../../../resources/images/insights/" . $full_name;
                //$targetPath = $full_name;



                if (move_uploaded_file($sourcePath, $targetPath)){
                    $result = $researcher->getOKStatus();
                    $result["image_name"] = $image_name;
                }

            }


            //$result["image_name"] = $random_name;
            //$result["image_link"] = "https://api.queritel.com/api/resources/images/insights/" . "$random_name.$file_extension";

        }

        echo json_export($result);
    }


    if ($action == ACTION_SEND_NOTIFICATION_ID){
        //updateNotificationToken($notification_id);
        //removeNotificationToken();
        //removeAllNotificationToken();
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $notification_id = text_clean($data["notification_id"]);

        //todo : API Debug - remove commented
        //debugAPIResponse("send_notification_id",json_encode($data,JSON_PRETTY_PRINT));

        /*if (getAgent() == MOBILE_AGENT_ANDROID){
            debugAPIResponse("send_notification_android",json_encode($data,JSON_PRETTY_PRINT));
        }
        else{
            debugAPIResponse("send_notification_id",json_encode($data,JSON_PRETTY_PRINT));

            $message = array();
            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = "iOS, official Notification Test - delta";
            $message["payload"] = $payload;
            sendFCM($message,$notification_id);
        }*/

        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            //$researcher->setCurrentLocation($lat,$lng);

            $updated = $researcher->updateNotificationToken($notification_id);

            if ($updated){
                $result = $researcher->getOKStatus();
            }
            else{
                $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            }

        }

        echo json_export($result);
    }


    //todo : incomplete -> ACTION_GET_QUEST_FILE_LIST = "get_quest_file_list"
    if ($action == "get_quest_file_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $task_id =      text_clean($data["task_id"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $code = '{
                  "status": "OK",
                  "file_list": [
                    {
                      "file_name": "Permission Document",
                      "file_ext": "ext_pdf",
                      "file_url": "https://api.queritel.com/api/uploads/queritel/insights/other/sample-file.pdf"
                    },
                    {
                      "file_name": "Instruction Document",
                      "file_ext": "ext_docx",
                      "file_url": "https://example-files.online-convert.com/document/docx/example.docx"
                    }
                  ]
                }';

            $code_obj = json_decode($code,true);

            $result["file_list"] = array();


            if ($user_id == 329 || $user_id == 1069){
                $result["file_list"] = $code_obj["file_list"];
            }
        }

        echo json_export($result);
    }

    //todo - testing
    if ($action == "get_wallet_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $wallet_data = array();
            $wallet_data["pending_amount"] = 0;
            $wallet_data["available_amount"] = 0;
            $wallet_data["currency"] = $researcher->getCurrencyCode();
            $wallet_data["payout_method"] = false;
            $wallet_data["cash_out"] = false;


            $current_wallet_data = $researcher->getWalletData();

            if ($current_wallet_data != null){
                $wallet_data["pending_amount"] = $current_wallet_data["pending_amount"];
                $wallet_data["available_amount"] = $current_wallet_data["available_amount"];
                $wallet_data["currency"] = $current_wallet_data["currency"];
                $wallet_data["payout_method"] = $current_wallet_data["payout_method"];
                $wallet_data["cash_out"] = $current_wallet_data["cash_out"];
            }

            $result = $researcher->getOKStatus();
            $result["wallet_data"] = $wallet_data;

            //$researcher->getCurrencyCode();
            //payout_method - payout method available
            //cash_out - means cash out is available

            //$primary_balance = 2.25; //home + Encuentra un mayorista
            //$primary_balance = 12.25; //eol
            //$primary_balance = 0; //vista
            //$primary_balance = 0.25; //home
            //$primary_balance = 0;


            //$primary_balance = 0;
            //$total_pending = 0;

            //id, response_id, update_time, job_id, task_id, , survey_id, survey_count, survey_completed, survey_state, survey_start, survey_end, price, currency, payment_date, payment_id, verified


            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '$user_id' and survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $price = $row["price"];

                    $total_pending += $price;

                }

                $primary_balance = floatval($total_pending);

            }

            $result["wallet_data"]["pending_amount"] = $researcher->getConvertedFunds($primary_balance);*/
            //$result["wallet_data"]["available_amount"] = $researcher->getConvertedFunds($primary_balance);

            //todo : evaluate currency conversion
            /*$currency = $researcher->getCurrencyCode();
            $primary_balance = $researcher->getConvertedFunds($primary_balance);

            if($researcher->get_userId() == 1069){
                //$primary_balance = 500;
            }



            //todo remove cash_out_history : place it in earnings

            $code = '{
                  "status": "OK",
                  "wallet_data": {
                       "pending_amount": ' . $primary_balance . ',
                       "available_amount": 0,
                       "currency": "' . $currency . '",
                       "payout_method": false,
                       "cash_out": false
                  }
                }';*/


        }

        echo json_export($result);
    }

    //todo - BUG
    if ($action == "get_earning_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            //$researcher->getCurrencyCode();

            //payout_method - payout method available
            //cash_out - means cash out is available

            //$primary_balance = 2.25; //home + Encuentra un mayorista
            //$primary_balance = 12.25; //eol
            $total_earned = 0; //vista
            //$primary_balance = 0.25; //home
            //$primary_balance = 0;
            $earned = 0;



            //$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '1249' and survey_state = 2 and verified = 0";
            /*$pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '$user_id' and survey_state = 2 and verified = 0";
            $pending_result = $paperweight->query($pending_query);

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $price = $row["price"];

                    $total_pending += $price;

                }

                $primary_balance = floatval($total_pending);

            }*/

            $pending_query = "select * from " . TABLE_RESPONSE . " where user_id = '$user_id' and survey_state = 2 and verified = 1";
            $pending_result = $paperweight->query($pending_query);

            if($pending_result != null && $pending_result->is_row_found()){

                while($row = $pending_result->fetch_array()){

                    $price = $row["price"];

                    $earned += $price;

                }

                $total_earned = floatval($earned);

            }

            //todo : evaluate currency conversion
            $currency = $researcher->getCurrencyCode();
            $total_earned = $researcher->getConvertedFunds($total_earned);


            //$total_earned = 500;

            $code = '{
              "status": "OK",
              "earning_data": {
                "amount_earned": ' . $total_earned . ',
                "currency": "' . $currency . '"
              },
              "cash_out_history": [
                {
                  "cash_out_time": "2021-03-11 07:28:49",
                  "cash_out_id": "kevin.smith@queritel.com",
                  "display_name": "Kevin\'s PayPal Account",
                  "account_id": "acc-utyhfhf-958857-jjfhfh",
                  "account_type": "type_paypal",
                  "account_provider": "PayPal",
                  "amount": 2000,
                  "currency": "CLP"
                },
                {
                  "cash_out_time": "2021-03-15 07:28:49",
                  "cash_out_id": "+18764420992",
                  "display_name": "My Mother\'s Number",
                  "account_id": "acc-hfjdslk-867490-gdlskif",
                  "account_type": "type_ding",
                  "account_provider": "Ding TopUp",
                  "amount": 800,
                  "currency": "CLP"
                }
              ]
            }';

            /*$code = '{
                  "status": "OK",
                  "wallet_data": {
                       "available_amount": 0,
                       "available_currency": "USD",
                       "payout_method": false
                  },
                  "cash_out_history": []
                }';*/

            /*{"account_id": null}*/

            $code_obj = json_decode($code,true);

            $result["earning_data"] = $code_obj["earning_data"];
            $result["cash_out_history"] = array();

            if ($user_id == 329){
                $result["cash_out_history"] = $code_obj["cash_out_history"];
            }


        }


        echo json_export($result);
    }



    if ($action == "mark_as_read"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            //todo : API Debug
            debugAPIResponse("mark_as_read",json_encode($data,JSON_PRETTY_PRINT));

            $result = $researcher->getOKStatus();

        }

        echo json_export($result);
    }

    //ACTION_GET_TEAM_LIST
    //ACTION_ADD_TEAM
    //ACTION_REMOVE_TEAM
    if ($action == "get_team_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $code = '{
                  "status": "OK",
                  "team_list": [
                    {
                      "network_id": "net-hdkshfl-9384653-shflcjs",
                      "team_name": "Market Research Services",
                      "team_id": "team-eqitpqm-6977877-asjshff"
                    },
                    {
                      "network_id": "net-xkdnfbd-7493749-xgcjzlx",
                      "team_name": "ODPEM Jamaica",
                      "team_id": "team-hfjdlsn-4847563-sldnvck"
                    }
                  ]
                }';

            $code_obj = json_decode($code,true);

            $result["team_list"] = array();


            if ($user_id == 329){
                $result["team_list"] = $code_obj["team_list"];
            }

        }

        echo json_export($result);
    }
    if ($action == "add_team"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse("add_team",json_encode(json_decode($param_json, true),JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

        }

        echo json_export($result);
    }
    if ($action == "remove_team"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse("remove_team",json_encode(json_decode($param_json, true),JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

        }

        echo json_export($result);
    }



    //ACTION_GET_PAYOUT_ACCOUNT_LIST = "get_pay_acc_list" --
    //ACTION_GET_SUPPORTED_PAYOUT_LIST = "get_supported_pay_list" --
    //ACTION_CASH_OUT = "request_cash_out" --

    //ACTION_ADD_PAYONEER_ACCOUNT = "add_payoneer" --
    //ACTION_ADD_AMAZON_ACCOUNT = "add_amazon_card" --
    //ACTION_ADD_MOBILE_ACCOUNT = "add_ding" --
    //ACTION_ADD_PAYPAL_ACCOUNT = "add_paypal" --

    //ACTION_UPDATE_AMAZON_ACCOUNT = "update_amazon_card" --
    //ACTION_UPDATE_PAYONEER_ACCOUNT = "update_payoneer" --
    //ACTION_UPDATE_PAYPAL_ACCOUNT = "update_paypal" --
    //ACTION_UPDATE_MOBILE_ACCOUNT = "update_ding" --

    //ACTION_GET_AMAZON_ACCOUNT = "get_amazon_card" --
    //ACTION_GET_PAYONEER_ACCOUNT = "get_payoneer" --
    //ACTION_GET_PAYPAL_ACCOUNT = "get_paypal" --
    //ACTION_GET_MOBILE_ACCOUNT = "get_ding" --
    //ACTION_GET_SERVICE_PROVIDER_LIST = "get_ding_service_providers" --

    //ACTION_REMOVE_PAYOUT_ACCOUNT = "remove_payout_account" --


    //define("ACCOUNT_TYPE_AMAZON_GIFT_CARD", "type_amazon_card");
    //define("ACCOUNT_TYPE_DING_MOBILE_TOP_UP", "type_ding");
    //define("ACCOUNT_TYPE_PAYONEER", "type_payoneer");
    //define("ACCOUNT_TYPE_PAYPAL", "type_paypal");
    //define("ACCOUNT_TYPE_BANK_ACCOUNT", "type_bank");


    //todo : API Debug
    //debugAPIResponse("__" . $action,json_encode(json_decode($param_json, true),JSON_PRETTY_PRINT));
    //debugAPIResponse($action,json_encode(json_decode($param_json, true),JSON_PRETTY_PRINT));

    //get_payout_account_list
    //get_supported_payout_list

    //todo - test
    if ($action == "request_cash_out"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =          text_clean($data["account_id"]);
        $local_amount =          text_clean($data["amount"]);


        //todo : API Debug
        debugAPIResponse("request_cash_out",json_encode(json_decode($param_json, true),JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $current_wallet_data = $researcher->getWalletData();

            if ($current_wallet_data != null){
                $usd_pending_amount =       $current_wallet_data["usd_pending_amount"];
                $usd_available_amount =   $current_wallet_data["usd_available_amount"];
                $pending_amount =           $current_wallet_data["pending_amount"];
                $available_amount =       $current_wallet_data["available_amount"];
                $currency =               $current_wallet_data["currency"];
                $payout_method =           $current_wallet_data["payout_method"];
                $cash_out =               $current_wallet_data["cash_out"];


                $is_request_valid = false;
                $account_type = null;

                $account_data = $researcher->getPayoutAccountDataRaw($account_id);
                if ($account_data != null){
                    $account_type = $account_data["account_type"];
                    $account_user = $account_data["user_id"];
                    $country_code = $researcher->getLocationCountryCode();

                    $supported_detail = getSupportedPayoutDetail($country_code,$account_type);
                    $cash_out_min = $researcher->getConvertedFunds($supported_detail["cash_out_min"],$currency);
                    $cash_out_max = $researcher->getConvertedFunds($supported_detail["cash_out_max"],$currency);


                    $loc_am = round($local_amount, 3);
                    $avail_am = round($available_amount, 3);

                    $co_min = round($cash_out_min, 3);
                    $co_max = round($cash_out_max, 3);

                    if ($loc_am <= $avail_am){
                        if (($loc_am >= $co_min) && ($loc_am <= $co_max)){
                            $is_request_valid = true;
                        }
                    }

                }



                if ($is_request_valid){
                    $transaction_id = generate_unique_id(UNIQUE_TRANSACTION);
                    $transaction_time = getCurrentTime();
                    $transaction_amount = 0;


                    $insert_cash_query = "insert into " . TABLE_AGENT_CASH_OUT . " (transaction_id, account_id, account_type, transaction_time, user_id, transaction_amount) values ('$transaction_id','$account_id','$account_type','$transaction_time','$user_id','$transaction_amount')";
                    $insert_cash_result = $paperweight->query($insert_cash_query);
                    if($insert_cash_result != null && $insert_cash_result->is_row_affected()){

                        $updated_usd = 0;
                        $local_funds_taken = 0; //local funds already accounted for


                        $payment_query = "select * from " . TABLE_AGENT_PAYMENT . " where user_id = '$user_id' and local_currency = '$currency' and handled_externally = 0 and paid = 0 and approved = 1 order by amount desc";
                        $payment_result = $paperweight->query($payment_query);

                        if($payment_result != null && $payment_result->is_row_found()){
                            while($row = $payment_result->fetch_array()){

                                //payment_id, amount, local_currency, local_currency_rate, amount_paid

                                $payment_id = $row["payment_id"];
                                $local_currency_rate = $row["local_currency_rate"];
                                $local_currency = $row["local_currency"];
                                $amount = ($row["amount"] == null) ? 0 : $row["amount"];
                                $amount_paid = ($row["amount_paid"] == null) ? 0 : $row["amount_paid"];
                                $amount_remaining = $amount - $amount_paid;


                                $local_converted_amount = floatval($amount_remaining * $local_currency_rate);

                                if (round($local_funds_taken,3) < round($local_amount,3)){
                                    //if more funds are required

                                    $funds_required = ($local_amount - $local_funds_taken);

                                    if (round($funds_required,3) >= round($local_converted_amount,3)){
                                        //payment entry has less than or the exact amount required
                                        $subtracted_local_funds = ($local_converted_amount);
                                        $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                                        $new_amount_paid = ($amount_paid + $subtracted_usd_funds);
                                        $paid = 1;
                                        $paid_time = getCurrentTime();


                                        $insert_trans_query = "insert into " . TABLE_CASH_OUT_TRANSACTION . " (update_time, transaction_amount, local_currency, local_currency_rate, transaction_id, user_id, payment_id) values ('$transaction_time','$subtracted_usd_funds','$local_currency','$local_currency_rate','$transaction_id','$user_id','$payment_id')";
                                        $insert_trans_result = $paperweight->query($insert_trans_query);
                                        if($insert_trans_result != null && $insert_trans_result->is_row_affected()){

                                            $update_agent_payment = "update " . TABLE_AGENT_PAYMENT . " set amount_paid = '$new_amount_paid', paid = '$paid', paid_time = '$paid_time' where payment_id = '$payment_id' and user_id = '$user_id'";
                                            $update_agent_payment_result = $paperweight->query($update_agent_payment);
                                            //if($update_agent_payment_result != null && $update_agent_payment_result->is_row_affected()){}

                                        }


                                        $local_funds_taken += $subtracted_local_funds;
                                        $updated_usd += $subtracted_usd_funds;
                                    }
                                    else{
                                        //payment entry has more than amount required
                                        $subtracted_local_funds = ($funds_required);
                                        $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                                        $new_amount_paid = ($amount_paid + $subtracted_usd_funds);
                                        $paid = 0;

                                        $insert_trans_query = "insert into " . TABLE_CASH_OUT_TRANSACTION . " (update_time, transaction_amount, local_currency, local_currency_rate, transaction_id, user_id, payment_id) values ('$transaction_time','$subtracted_usd_funds','$local_currency','$local_currency_rate','$transaction_id','$user_id','$payment_id')";
                                        $insert_trans_result = $paperweight->query($insert_trans_query);
                                        if($insert_trans_result != null && $insert_trans_result->is_row_affected()){

                                            $update_agent_payment = "update " . TABLE_AGENT_PAYMENT . " set amount_paid = '$new_amount_paid', paid = '$paid' where payment_id = '$payment_id' and user_id = '$user_id'";
                                            $update_agent_payment_result = $paperweight->query($update_agent_payment);
                                            //if($update_agent_payment_result != null && $update_agent_payment_result->is_row_affected()){}

                                        }

                                        $local_funds_taken += $subtracted_local_funds;
                                        $updated_usd += $subtracted_usd_funds;

                                    }

                                }
                                else{
                                    break;
                                }


                            }
                        }


                        $update_cashout = "update " . TABLE_AGENT_CASH_OUT . " set transaction_amount = '$updated_usd' where transaction_id = '$transaction_id' and user_id = '$user_id'";
                        $update_result = $paperweight->query($update_cashout);
                        if($update_result != null && $update_result->is_row_affected()){
                            $result = $researcher->getOKStatus();
                        }

                    }
                }

            }

        }

        echo json_export($result);
    }



    //todo - test
    if ($action == "get_payout_account_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $account_list = array();
            $excluded_acc_type_1 = ACCOUNT_TYPE_BANK_ACCOUNT;

            $payment_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where user_id = '$user_id' and account_type not in ('$excluded_acc_type_1') and deleted = 0";
            $payment_result = $paperweight->query($payment_query);

            if($payment_result != null && $payment_result->is_row_found()){
                while($row = $payment_result->fetch_array()){
                    $account_data = array();

                    $account_id = $row["account_id"];
                    $account_type = $row["account_type"];
                    $display_name = $row["display_name"];
                    $created_time = $row["creation_time"];
                    $account_provider = null;
                    $cash_out_id = null;
                    $cash_out_min = 0;
                    $cash_out_max = 0;

                    if ($account_type == ACCOUNT_TYPE_DING_MOBILE_TOP_UP){
                        $cash_out_id = $row["phone_number"];
                    }
                    else{
                        $cash_out_id = $row["email"];
                    }



                    $country_code = $researcher->getLocationCountryCode();
                    $supported_detail = getSupportedPayoutDetail($country_code,$account_type);

                    $cash_out_min = $researcher->getConvertedFunds($supported_detail["cash_out_min"]);
                    $cash_out_max = $researcher->getConvertedFunds($supported_detail["cash_out_max"]);
                    $account_provider = $supported_detail["account_provider"];


                    $account_data["account_id"] = $account_id;
                    $account_data["account_type"] = $account_type;
                    $account_data["display_name"] = $display_name;
                    $account_data["account_provider"] = $account_provider;
                    $account_data["created_time"] = $created_time;
                    $account_data["cash_out_id"] = $cash_out_id;
                    $account_data["cash_out_min"] = $cash_out_min;
                    $account_data["cash_out_max"] = $cash_out_max;

                    $account_list[] = $account_data;
                }
            }

            /*$code = '{
              "status": "OK",
              "account_list": [
                {
                  "account_id": "acc-utyhfhf-958857-jjfhfh",
                  "account_type": "type_paypal",
                  "display_name": "Kevin\'s PayPal Account",
                  "account_provider": "PayPal",
                  "created_time": "2021-03-11 07:28:49",
                  "cash_out_id": "kevin.smith@queritel.com",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                },
                {
                  "account_id": "acc-hfjdslk-867490-gdlskif",
                  "account_type": "type_ding",
                  "display_name": "My Mother\'s Number",
                  "account_provider": "Ding TopUp",
                  "created_time": "2021-03-15 07:28:49",
                  "cash_out_id": "+18764420992",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                }
              ]
            }';
            $code_obj = json_decode($code,true);
            $result["account_list"] = array();

            if ($user_id == 329 || $user_id == 1069){
                $result["account_list"] = $code_obj["account_list"];
            }*/

            $result["account_list"] = $account_list;



        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_supported_payout_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $country_code = $researcher->getLocationCountryCode();

            $supported_list = getSupportedPayoutList($country_code);

            $result["supported_list"] = $supported_list;


            /*$code = '{
              "status": "OK",
              "supported_list": [
                {
                  "account_type": "type_paypal",
                  "account_provider": "PayPal",
                  "account_function": "function_cash_out",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                },
                {
                  "account_type": "type_ding",
                  "account_provider": "Ding TopUp",
                  "account_function": "function_mobile",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                },
                {
                  "account_type": "type_amazon_card",
                  "account_provider": "Amazon",
                  "account_function": "function_gift_card",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                },
                {
                  "account_type": "type_payoneer",
                  "account_provider": "Payoneer",
                  "account_function": "function_cash_out",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                }
              ]
            }';

            $code_real = '{
              "status": "OK",
              "supported_list": [
                {
                  "account_type": "type_paypal",
                  "account_provider": "PayPal",
                  "account_function": "function_cash_out",
                  "cash_out_min": 100,
                  "cash_out_max": 2000
                }
              ]
            }';
            $code_obj = json_decode($code,true);
            $code_obj_real = json_decode($code_real,true);

            $result["supported_list"] = $code_obj_real["supported_list"];

            if ($user_id == 329 || $user_id == 1069){
                $result["supported_list"] = $code_obj["supported_list"];
            }*/


        }

        echo json_export($result);
    }



    //todo - test
    if ($action == "remove_payout_account"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =   text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //param
            $delete_time = getCurrentTime();

            $deleted = 0;
            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    //$version_code = $row["version_code"] + 1;

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `deleted_time` = '$delete_time', `deleted` = 1 where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $result = $researcher->getOKStatus();

                    }

                }

            }


            //$result = $researcher->getOKStatus();

            //$account_id = generate_unique_id(UNIQUE_ACCOUNT);

            //$result["account_id"] = $account_id;
            //$result["version_code"] = 1;

        }

        echo json_export($result);
    }


    //todo - test
    if ($action == "add_paypal"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        /*{
          "user_id": 329,
          "login_token": 99735571,
          "display_name": "Kadan Salmon",
          "email": "kadian.salmon@queritel.com"
        }*/


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);


            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_PAYPAL;
            $creation_time = getCurrentTime();

            //param
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));


            $add_account = "insert into " . TABLE_PAYOUT_ACCOUNT . " (account_id, account_type, creation_time, user_id, version_code, display_name, email) values('$account_id','$account_type','$creation_time','$user_id','$version_code','$display_name','$email')";
            $add_account_result = $paperweight->query($add_account);

            if($add_account_result != null && $add_account_result->is_row_affected()){
                $result = $researcher->getOKStatus();

                $result["account_id"] = $account_id;
                $result["version_code"] = $version_code;
            }





            /*$result = $researcher->getOKStatus();

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "add_ding"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_DING_MOBILE_TOP_UP;
            $creation_time = getCurrentTime();

            //param
            $display_name = stringCase(text_clean($data["display_name"]));
            $phone_number = stringCase(text_clean($data["phone_number"]));
            $country_code = stringCase(text_clean($data["country_code"]),STRING_CASE_UPPER);
            $service_provider_code = stringCase(text_clean($data["service_provider"]));

            $provider_data = getDingServiceProviderDetail($service_provider_code);

            $service_provider_name = null;

            if ($provider_data != null){
                $service_provider_name = $provider_data["name"];
            }


            $add_account = "insert into " . TABLE_PAYOUT_ACCOUNT . " (account_id, account_type, creation_time, user_id, version_code, display_name, phone_number,country_code,service_provider_code,service_provider_name) values('$account_id','$account_type','$creation_time','$user_id','$version_code','$display_name','$phone_number','$country_code','$service_provider_code','$service_provider_name')";
            $add_account_result = $paperweight->query($add_account);

            if($add_account_result != null && $add_account_result->is_row_affected()){
                $result = $researcher->getOKStatus();

                $result["account_id"] = $account_id;
                $result["version_code"] = $version_code;
            }


            /*$result = $researcher->getOKStatus();
            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "add_amazon_card"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_AMAZON_GIFT_CARD;
            $creation_time = getCurrentTime();

            //param
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));


            $add_account = "insert into " . TABLE_PAYOUT_ACCOUNT . " (account_id, account_type, creation_time, user_id, version_code, display_name, email) values('$account_id','$account_type','$creation_time','$user_id','$version_code','$display_name','$email')";
            $add_account_result = $paperweight->query($add_account);

            if($add_account_result != null && $add_account_result->is_row_affected()){
                $result = $researcher->getOKStatus();

                $result["account_id"] = $account_id;
                $result["version_code"] = $version_code;
            }


            /*$result = $researcher->getOKStatus();

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "add_payoneer"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);



        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);
            $version_code = 1;
            $account_type = ACCOUNT_TYPE_PAYONEER;
            $creation_time = getCurrentTime();

            //param
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));


            $add_account = "insert into " . TABLE_PAYOUT_ACCOUNT . " (account_id, account_type, creation_time, user_id, version_code, display_name, email) values('$account_id','$account_type','$creation_time','$user_id','$version_code','$display_name','$email')";
            $add_account_result = $paperweight->query($add_account);

            if($add_account_result != null && $add_account_result->is_row_affected()){
                $result = $researcher->getOKStatus();

                $result["account_id"] = $account_id;
                $result["version_code"] = $version_code;
            }




            /*$result = $researcher->getOKStatus();

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "update_paypal"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =   text_clean($data["account_id"]);

        /*{
          "user_id": 329,
          "login_token": 99735571,
          "display_name": "Kadan Salmon",
          "email": "kadian.salmon@queritel.com"
        }*/


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //param
            $update_time = getCurrentTime();
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));

            $deleted = 0;
            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $version_code = $row["version_code"] + 1;

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `update_time` = '$update_time', `version_code` = '$version_code', `display_name` = '$display_name', `email` = '$email' where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $result = $researcher->getOKStatus();

                        $result["account_id"] = $account_id;
                        $result["version_code"] = $version_code;

                    }

                }

            }

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "update_ding"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =   text_clean($data["account_id"]);

        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //param
            $update_time = getCurrentTime();
            $display_name = stringCase(text_clean($data["display_name"]));
            $phone_number = text_clean($data["phone_number"]);
            $country_code = stringCase(text_clean($data["country_code"]), STRING_CASE_UPPER);
            $service_provider_code = stringCase(text_clean($data["service_provider"]), STRING_CASE_LOWER);


            $deleted = 0;
            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $provider_data = getDingServiceProviderDetail($service_provider_code);

                    $service_provider_name = null; //todo - ding map

                    if ($provider_data != null){
                        $service_provider_name = $provider_data["name"];
                    }

                    $version_code = $row["version_code"] + 1;

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `update_time` = '$update_time', `version_code` = '$version_code', `display_name` = '$display_name', `phone_number` = '$phone_number', `country_code` = '$country_code', `service_provider_code` = '$service_provider_code', `service_provider_name` = '$service_provider_name' where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $result = $researcher->getOKStatus();

                        $result["account_id"] = $account_id;
                        $result["version_code"] = $version_code;

                    }

                }

            }

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "update_amazon_card"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =   text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //param
            $update_time = getCurrentTime();
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));

            $deleted = 0;
            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $version_code = $row["version_code"] + 1;

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `update_time` = '$update_time', `version_code` = '$version_code', `display_name` = '$display_name', `email` = '$email' where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $result = $researcher->getOKStatus();

                        $result["account_id"] = $account_id;
                        $result["version_code"] = $version_code;

                    }

                }

            }

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "update_payoneer"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $account_id =   text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            //param
            $update_time = getCurrentTime();
            $display_name = stringCase(text_clean($data["display_name"]));
            $email = stringCase(text_clean($data["email"]));

            $deleted = 0;
            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $version_code = $row["version_code"] + 1;

                    $update_account = "update " . TABLE_PAYOUT_ACCOUNT . " set `update_time` = '$update_time', `version_code` = '$version_code', `display_name` = '$display_name', `email` = '$email' where `account_id` = '$account_id'";
                    $update_account_result = $paperweight->query($update_account);

                    if($update_account_result != null && $update_account_result->is_row_affected()){

                        $result = $researcher->getOKStatus();

                        $result["account_id"] = $account_id;
                        $result["version_code"] = $version_code;

                    }

                }

            }

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_amazon_card"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $account_id =   text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_type = ACCOUNT_TYPE_AMAZON_GIFT_CARD;
            $deleted = 0;

            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $account_data = array();

                    $account_data["account_id"] = $row["account_id"];
                    $account_data["account_type"] = $row["account_type"];
                    $account_data["version_code"] = intval($row["version_code"]);
                    $account_data["display_name"] = stringCase($row["display_name"],STRING_CASE_CAP_EACH);
                    $account_data["email"] = stringCase($row["email"]);

                    $result = $researcher->getOKStatus();
                    $result["account_data"] = $account_data;

                }

            }


            /*$result = $researcher->getOKStatus();

            $code = '{
              "status": "OK",
              "account_data": {
                "account_id": "acc-wlikhqy-1762074-vaiwyxx",
                "account_type": "type_amazon_card",
                "version_code": 1,
                "display_name": "Kadan Salmon",
                "email": "kadian.salmon@queritel.com"
              }
            }';
            $code_obj = json_decode($code,true);
            $result["account_data"] = $code_obj["account_data"];*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_paypal"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $account_id =  text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_type = ACCOUNT_TYPE_PAYPAL;
            $deleted = 0;

            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $account_data = array();

                    $account_data["account_id"] = $row["account_id"];
                    $account_data["account_type"] = $row["account_type"];
                    $account_data["version_code"] = intval($row["version_code"]);
                    $account_data["display_name"] = stringCase($row["display_name"],STRING_CASE_CAP_EACH);
                    $account_data["email"] = stringCase($row["email"]);

                    $result = $researcher->getOKStatus();
                    $result["account_data"] = $account_data;

                }

            }


            /*$result = $researcher->getOKStatus();

            $code = '{
              "status": "OK",
              "account_data": {
                "account_id": "acc-wlikhqy-1762074-vaiwyxx",
                "account_type": "type_paypal",
                "version_code": 1,
                "display_name": "Kadan Salmon",
                "email": "kadian.salmon@queritel.com"
              }
            }';
            $code_obj = json_decode($code,true);
            $result["account_data"] = $code_obj["account_data"];*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_payoneer"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $account_id =  text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_type = ACCOUNT_TYPE_PAYONEER;
            $deleted = 0;

            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $account_data = array();

                    $account_data["account_id"] = $row["account_id"];
                    $account_data["account_type"] = $row["account_type"];
                    $account_data["version_code"] = intval($row["version_code"]);
                    $account_data["display_name"] = stringCase($row["display_name"],STRING_CASE_CAP_EACH);
                    $account_data["email"] = stringCase($row["email"]);

                    $result = $researcher->getOKStatus();
                    $result["account_data"] = $account_data;

                }

            }

            /*$result = $researcher->getOKStatus();

            $code = '{
              "status": "OK",
              "account_data": {
                "account_id": "acc-wlikhqy-1762074-vaiwyxx",
                "account_type": "type_payoneer",
                "version_code": 1,
                "display_name": "Kadan Salmon",
                "email": "kadian.salmon@queritel.com"
              }
            }';
            $code_obj = json_decode($code,true);
            $result["account_data"] = $code_obj["account_data"];*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_ding"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);
        $account_id =  text_clean($data["account_id"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);


            $result = $researcher->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $account_type = ACCOUNT_TYPE_DING_MOBILE_TOP_UP;
            $deleted = 0;

            $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id' and deleted = '$deleted' and user_id = '$user_id'";
            $account_result = $paperweight->query($account_query);
            if($account_result != null && $account_result->is_row_found()){

                if($row = $account_result->fetch_array()){

                    $account_data = array();

                    $account_data["account_id"] = $row["account_id"];
                    $account_data["account_type"] = $row["account_type"];
                    $account_data["version_code"] = intval($row["version_code"]);
                    $account_data["display_name"] = stringCase($row["display_name"],STRING_CASE_CAP_EACH);
                    $account_data["phone_number"] = $row["phone_number"];
                    $account_data["country_code"] = $row["country_code"];
                    $account_data["service_provider_name"] = $row["service_provider_name"];
                    $account_data["service_provider"] = $row["service_provider_code"];

                    $result = $researcher->getOKStatus();
                    $result["account_data"] = $account_data;

                }

            }


            /*$result = $researcher->getOKStatus();

            $code = '{
              "status": "OK",
              "account_data": {
                "account_id": "acc-wlikhqy-1762074-vaiwyxx",
                "account_type": "type_ding",
                "version_code": 1,
                "display_name": "Kadan Salmon",
                "phone_number": "7865904586",
                "country_code": "JM",
                "service_provider_name": "Digicel",
                "service_provider": "provider_jm_digicel"
              }
            }';
            $code_obj = json_decode($code,true);
            $result["account_data"] = $code_obj["account_data"];*/

        }

        echo json_export($result);
    }

    //todo - test
    if ($action == "get_ding_service_providers"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $country_code = text_clean($data["country_code"]);

        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);



            $supported_list = array();
            $supported_list = getDingServiceProviderList($country_code);

            $result = $researcher->getOKStatus();
            $result["supported_list"] = $supported_list;



            /*$code = '{
              "status": "OK",
              "supported_list": [
                {
                  "country_code": "'. $country_code .'",
                  "name": "Digicel",
                  "service_provider": "provider_'. strtolower($country_code) .'_digicel"
                },
                {
                  "country_code": "'. $country_code .'",
                  "name": "Flow",
                  "service_provider": "provider_'. strtolower($country_code) .'_flow"
                }
              ]
            }';
            $code_obj = json_decode($code,true);
            $result["supported_list"] = $code_obj["supported_list"];*/

        }

        echo json_export($result);
    }




    //ACTION_HAS_PULSE = "is_pulse_available" //(check if pulses are available)
    //ACTION_GET_PULSE_LIST = "get_pulse_list" //(this gets a list of all the pulse available to th user)
    //ACTION_GET_QUESTION = "get_pulse_question" //(this gets a specific quest based on the question_id)
    //ACTION_SUBMIT_ANSWER = "submit_pulse_answer" //(this submits the response for a specific question)


    //define("ACTION_HAS_PULSE", "is_pulse_available");
    //define("ACTION_GET_PULSE_LIST", "get_pulse_list");
    //define("ACTION_GET_QUESTION", "get_pulse_question");
    //define("ACTION_SUBMIT_ANSWER", "submit_pulse_answer");

    if ($action == "is_pulse_available"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();
            $result["is_available"] = false;

            if ($user_id == 329 || $user_id == 1069){
                $result["is_available"] = true;
            }


        }

        echo json_export($result);
    }
    if ($action == "get_pulse_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $code = '{
               "status": "OK",
               "pulse_list": [
                  {
                     "pulse_id": "pul-hdkshfl-9384653-shflcjs",
                     "pulse_name": "Depression state",
                     "question_list": [
                        {
                           "question_id": "que-hfgdlki-5648379-gfhdjsu",
                           "question_type": "type_ranking",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Favorite Fruit",
                           "question_text": "Rank your Favorite Fruit",
                           "question_details": {
                                "instructions": "Arrange the options by holding down the right button on the option"
                            },
                           "instructions": "Arrange the options by holding down the right button on the option",
                           "answer_options": [
                              {
                                 "answer_id": "ans-hdkfuej-7498346-ahydgeo",
                                 "answer_text": "Apples"
                              },
                              {
                                 "answer_id": "ans-kfjhdus-8376593-soiufhe",
                                 "answer_text": "Mangoes"
                              },
                              {
                                 "answer_id": "ans-hfbvmro-3947583-dhfkrih",
                                 "answer_text": "Grapes"
                              }
                           ]
                        },
                        {
                           "question_id": "que-jdhfieu-8476398-jfuosje",
                           "question_type": "type_single_select",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Happiness State",
                           "question_text": "How happy are you?",
                           "question_details": { 
                                "instructions": "Select a single item from the list of options provided"
                            },
                           "answer_options": [
                              {
                                 "answer_id": "ans-hdkfuej-7498346-ahydgeo",
                                 "answer_text": "Not happy at all"
                              },
                              {
                                 "answer_id": "ans-kfjhdus-8376593-soiufhe",
                                 "answer_text": "A little happy"
                              },
                              {
                                 "answer_id": "ans-hfbvmro-3947583-dhfkrih",
                                 "answer_text": "Extreamly happy"
                              }
                           ]
                        },
                        {
                           "question_id": "que-yfgdhfl-7563896-hglodge",
                           "question_type": "type_multiple_select",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Happiness State Multiple",
                           "question_text": "How happy are you?",
                           "question_details": { 
                                "instructions": "Select one or more item from the list of options provided" 
                            },
                           "answer_options": [
                              {
                                 "answer_id": "ans-hdkfuej-7498346-ahydgeo",
                                 "answer_text": "Not happy at all"
                              },
                              {
                                 "answer_id": "ans-kfjhdus-8376593-soiufhe",
                                 "answer_text": "A little happy"
                              },
                              {
                                 "answer_id": "ans-hfbvmro-3947583-dhfkrih",
                                 "answer_text": "Extreamly happy"
                              }
                           ]
                        }
                        
                     ]
                  },
                  {
                     "pulse_id": "pul-hdkshfl-9384653-shflcjs",
                     "pulse_name": "Tech Opinions",
                     "question_list": [
                        {
                           "question_id": "que-hdgfsks-7563987-jfhdosp",
                           "question_type": "type_rating",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Preferred Media",
                           "question_text": "Rate the facebook application",
                           "instructions": "Rate by selecting the star that corresponds to the scale",
                           "question_details": {
                              "instructions": "Rate by selecting the star that corresponds to the scale",
                              "option_style": "star",
                              "option_min": 1,
                              "option_max": 5,
                              "option_step": 1
                           }
                        },
                        {
                           "question_id": "que-gdfsjht-2435645-hggdkip",
                           "question_type": "type_file_upload",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "ML training image (cat)",
                           "question_text": "Upload a picture of your Cat",
                           "question_details": {
                              "instructions": "The image must be clear"
                           }
                        },
                        {
                           "question_id": "que_kghfjdu_6573546_hgjskop",
                           "question_type": "type_text_display",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Opinion on C++",
                           "question_text": "How do you feel about C++",
                           "question_details": {
                              "instructions": "just a few of your opinions about the C++ language for game dev",
                              "character_max": 100
                           }
                        },
                        {
                           "question_id": "que-hfgslop-7563902-jghdldd",
                           "question_type": "type_numerical",
                           "question_time": "2021-03-12 18:04:04",
                           "question_name": "Opinion on ML",
                           "question_text": "How much would you pay for a book about ML?",
                           "question_details": {
                              "instructions": "This is really a test",
                              "prefix": "$",
                              "suffix": "USD"
                           }
                        }
                     ]
                  }
               ]
            }';
            $code_obj = json_decode($code,true);
            $result["pulse_list"] = $code_obj["pulse_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_pulse_question"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $code = '{
               "status": "OK",
               "question_data": {
                  "question_id": "que-jdhfieu-8476398-jfuosje",
                  "question_type": "type_single_select",
                  "question_time": "2021-03-12 18:04:04",
                  "question_name": "Happiness State",
                  "question_text": "How happy are you?",
                  "answer_options": [
                     {
                        "answer_id": "ans-hdkfuej-7498346-ahydgeo",
                        "answer_text": "Not happy at all"
                     },
                     {
                        "answer_id": "ans-kfjhdus-8376593-soiufhe",
                        "answer_text": "A little happy"
                     },
                     {
                        "answer_id": "ans-hfbvmro-3947583-dhfkrih",
                        "answer_text": "Extreamly happy"
                     }
                  ]
               }
            }';
            $code_obj = json_decode($code,true);
            $result["question_data"] = $code_obj["question_data"];

        }

        echo json_export($result);
    }
    if ($action == "submit_pulse_answer"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        //todo : API Debug
        debugAPIResponse("submit_pulse_answer",json_encode($data,JSON_PRETTY_PRINT));


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            //$account_id = generate_unique_id(UNIQUE_ACCOUNT);

            //$result["account_id"] = $account_id;
            //$result["version_code"] = 1;

        }

        echo json_export($result);
    }


    //================== ADDITIONAL API ==================
    //ACTION_ = ""
    //define("ACTION_", "");
    if ($action == "-template-get-sample-"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $code = '{
                  "status": "OK",
                  "team_list": [
                    {
                      "network_id": "net-hdkshfl-9384653-shflcjs",
                      "team_name": "Market Research Services",
                      "team_id": "team-eqitpqm-6977877-asjshff"
                    },
                    {
                      "network_id": "net-xkdnfbd-7493749-xgcjzlx",
                      "team_name": "ODPEM Jamaica",
                      "team_id": "team-hfjdlsn-4847563-sldnvck"
                    }
                  ]
                }';
            $code_obj = json_decode($code,true);
            $result[""] = $code_obj[""];

        }

        echo json_export($result);
    }
    if ($action == "-template-set-sample-"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;

        }

        echo json_export($result);
    }
    if ($action == "template"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $researcher = new Researcher($paperweight);
        $isVerified = $researcher->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $researcher->initializeResearcher($user_id);
            $researcher->setCurrentLocation($lat,$lng);

            $result = $researcher->getOKStatus();

        }

        echo json_export($result);
    }

    //get_profile_data
    //get_team_list
    //add_team
    //get_wallet_data
    //--get_earning_data--
    //change_password
    //add_payment_account (bank, etc)


}


//todo - modify for chile
//DING : this returns the custom sku map (must go in DB table) todo - [ADD TO DATABASE]
function getDingServiceProviderMap(){
    //this is the custom ding SKU map
    /*{
      "JM": [
        {
          "service_provider": "provider_jm_digicel",
          "name": "Digicel",
          "country_code": "JM",
          "SkuCode": "JM_DC_TopUp",
          "SendCurrency": "USD",
          "SendMin": 5,
          "SendMax": 5
        }
      ]
    }*/
    $map = array();

    $JM = array();
    $CL = array();

    $JM_1["service_provider"] = "provider_jm_digicel";
    $JM_1["name"] = "Digicel";
    $JM_1["country_code"] = "JM";
    $JM_1["SkuCode"] = "JM_DC_TopUp";
    $JM_1["SendCurrency"] = "USD";
    $JM_1["ReceiveCurrency"] = "JMD";
    $JM_1["SendMin"] = 5;
    $JM_1["SendMax"] = 5;

    $JM_2["service_provider"] = "provider_jm_flow";
    $JM_2["name"] = "Flow";
    $JM_2["country_code"] = "JM";
    $JM_2["SkuCode"] = "";
    $JM_2["SendCurrency"] = "USD";
    $JM_2["ReceiveCurrency"] = "JMD";
    $JM_2["SendMin"] = 5;
    $JM_2["SendMax"] = 5;

    $JM[] = $JM_1;



    $map["JM"] = $JM;
    //$map["CL"] = $CL;

    return $map;
}

//DING : this returns a list that will be used on the app
function getDingServiceProviderList($country_code){
    $map = getDingServiceProviderMap();
    $list = array();

    /*[
        {
          "country_code": "JM",
          "name": "Digicel",
          "service_provider": "provider_jm_digicel" //()
        }
      ]*/


    if (isset($map[$country_code])){
        foreach ($map[$country_code] as $index => $item) {
            $provider = array();

            $provider["service_provider"] = $item["service_provider"];
            $provider["name"] = $item["name"];
            $provider["country_code"] = $item["country_code"];

            $list[] = $provider;
        }
    }


    return $list;
}

//DING : this returns the data when provided with a service_provider_code
function getDingServiceProviderDetail($service_provider_code){
    $map = getDingServiceProviderMap();
    $detail = null;

    /*
        {
          "country_code": "JM",
          "name": "Digicel",
          "service_provider": "provider_jm_digicel" //()
        }
      */

    $key_found = false;

    foreach ($map as $key => $value_array) {
        foreach ($value_array as $index => $item) {

            if ($item["service_provider"] == $service_provider_code) {
                $detail = array();

                $detail["service_provider"] = $item["service_provider"];
                $detail["name"] = $item["name"];
                $detail["country_code"] = $item["country_code"];
                $detail["SkuCode"] = $item["SkuCode"];
                $detail["SendCurrency"] = $item["SendCurrency"];
                $detail["ReceiveCurrency"] = $item["ReceiveCurrency"];
                $detail["SendMin"] = $item["SendMin"];
                $detail["SendMax"] = $item["SendMax"];

                $key_found = true;

                break;
            }

        }

        if ($key_found) {
            break;
        }

    }


    return $detail;
}


//TODO - in progress
//PAYOUT : this returns the payout account types map (must go in db table) todo - [ADD TO DATABASE]
function getSupportedPayoutMap(){
    //table : country_code, - if no country, then all country can use the method

    /*[
       {
         "account_type": "type_paypal",
         "account_provider": "PayPal",
         "account_function": "function_cash_out",
         "cash_out_min": 100,
         "cash_out_max": 2000
       },
       {
         "account_type": "type_ding",
         "account_provider": "Ding TopUp",
         "account_function": "function_mobile",
         "cash_out_min": 100,
         "cash_out_max": 2000
       },
       {
         "account_type": "type_amazon_card",
         "account_provider": "Amazon",
         "account_function": "function_gift_card",
         "cash_out_min": 100,
         "cash_out_max": 2000
       },
       {
         "account_type": "type_payoneer",
         "account_provider": "Payoneer",
         "account_function": "function_cash_out",
         "cash_out_min": 100,
         "cash_out_max": 2000
       }
      ]*/
    /*{
      "JM": [
        {
          "account_type": "type_paypal",
          "account_provider": "PayPal", //(Must be displayed to the user)
          "account_function": "function_cash_out", //([PAY-OUT ACCOUNT FUNCTION CONSTANTS] for constants to check for) (The string for this must be displayed )
          "cash_out_min": 100,
          "cash_out_max": 2000
        }
      ],
    "GENERAL": [
        {
          "account_type": "type_paypal",
          "account_provider": "PayPal", //(Must be displayed to the user)
          "account_function": "function_cash_out", //([PAY-OUT ACCOUNT FUNCTION CONSTANTS] for constants to check for) (The string for this must be displayed )
          "cash_out_min": 100,
          "cash_out_max": 2000
        }
      ]
    }*/
    $map = array();

    $JM = array();
    $CL = array();
    $GENERAL = array();

    //minimum cash out values - https://queritel.com/mobiterms

    $JM_1["account_type"] = "type_paypal";
    $JM_1["account_provider"] = "PayPal";
    $JM_1["account_function"] = "function_cash_out";
    $JM_1["cash_out_min"] = 5;
    $JM_1["cash_out_max"] = 100;

    $JM_2["account_type"] = "type_ding";
    $JM_2["account_provider"] = "Ding TopUp";
    $JM_2["account_function"] = "function_mobile";
    $JM_2["cash_out_min"] = 5;
    $JM_2["cash_out_max"] = 50;

    $JM_3["account_type"] = "type_amazon_card";
    $JM_3["account_provider"] = "Amazon";
    $JM_3["account_function"] = "function_gift_card";
    $JM_3["cash_out_min"] = 1;
    $JM_3["cash_out_max"] = 50;

    $JM_4["account_type"] = "type_payoneer";
    $JM_4["account_provider"] = "Payoneer";
    $JM_4["account_function"] = "function_cash_out";
    $JM_4["cash_out_min"] = 50;
    $JM_4["cash_out_max"] = 200;

    $JM[] = $JM_1;
    $JM[] = $JM_2;
    $JM[] = $JM_3;
    $JM[] = $JM_4;


    $CL_1["account_type"] = "type_paypal";
    $CL_1["account_provider"] = "PayPal";
    $CL_1["account_function"] = "function_cash_out";
    $CL_1["cash_out_min"] = 5;
    $CL_1["cash_out_max"] = 100;

    $CL_2["account_type"] = "type_ding";
    $CL_2["account_provider"] = "Ding TopUp";
    $CL_2["account_function"] = "function_mobile";
    $CL_2["cash_out_min"] = 5;
    $CL_2["cash_out_max"] = 50;

    $CL_3["account_type"] = "type_amazon_card";
    $CL_3["account_provider"] = "Amazon";
    $CL_3["account_function"] = "function_gift_card";
    $CL_3["cash_out_min"] = 1;
    $CL_3["cash_out_max"] = 50;

    $CL_4["account_type"] = "type_payoneer";
    $CL_4["account_provider"] = "Payoneer";
    $CL_4["account_function"] = "function_cash_out";
    $CL_4["cash_out_min"] = 50;
    $CL_4["cash_out_max"] = 200;

    $CL[] = $CL_1;
    $CL[] = $CL_2;
    $CL[] = $CL_3;
    $CL[] = $CL_4;


    $GENERAL_1["account_type"] = "type_paypal";
    $GENERAL_1["account_provider"] = "PayPal";
    $GENERAL_1["account_function"] = "function_cash_out";
    $GENERAL_1["cash_out_min"] = 5;
    $GENERAL_1["cash_out_max"] = 100;

    $GENERAL_2["account_type"] = "type_ding";
    $GENERAL_2["account_provider"] = "Ding TopUp";
    $GENERAL_2["account_function"] = "function_mobile";
    $GENERAL_2["cash_out_min"] = 5;
    $GENERAL_2["cash_out_max"] = 50;

    $GENERAL_3["account_type"] = "type_amazon_card";
    $GENERAL_3["account_provider"] = "Amazon";
    $GENERAL_3["account_function"] = "function_gift_card";
    $GENERAL_3["cash_out_min"] = 1;
    $GENERAL_3["cash_out_max"] = 50;

    $GENERAL_4["account_type"] = "type_payoneer";
    $GENERAL_4["account_provider"] = "Payoneer";
    $GENERAL_4["account_function"] = "function_cash_out";
    $GENERAL_4["cash_out_min"] = 50;
    $GENERAL_4["cash_out_max"] = 200;

    $GENERAL[] = $GENERAL_1;
    $GENERAL[] = $GENERAL_2;
    $GENERAL[] = $GENERAL_3;
    $GENERAL[] = $GENERAL_4;



    $map["JM"] = $JM;
    $map["CL"] = $CL;
    $map["GENERAL"] = $GENERAL;

    return $map;
}

//PAYOUT : this returns a list that will be used on the app
function getSupportedPayoutList($country_code){
    $map = getSupportedPayoutMap();
    $list = array();

    /*[
        {
          "account_type": "type_paypal",
          "account_provider": "PayPal", //(Must be displayed to the user)
          "account_function": "function_cash_out", //([PAY-OUT ACCOUNT FUNCTION CONSTANTS] for constants to check for) (The string for this must be displayed )
          "cash_out_min": 100,
          "cash_out_max": 2000
        }
      ]*/


    if (isset($map[$country_code])){
        foreach ($map[$country_code] as $index => $item) {
            $provider = array();

            $provider["account_type"] = $item["account_type"];
            $provider["account_provider"] = $item["account_provider"];
            $provider["account_function"] = $item["account_function"];
            $provider["cash_out_min"] = $item["cash_out_min"];
            $provider["cash_out_max"] = $item["cash_out_max"];

            $list[] = $provider;
        }
    }
    else{
        foreach ($map["GENERAL"] as $index => $item) {
            $provider = array();

            $provider["account_type"] = $item["account_type"];
            $provider["account_provider"] = $item["account_provider"];
            $provider["account_function"] = $item["account_function"];
            $provider["cash_out_min"] = $item["cash_out_min"];
            $provider["cash_out_max"] = $item["cash_out_max"];

            $list[] = $provider;
        }
    }


    return $list;
}

//PAYOUT : this returns the data when provided with a country_code & account_type
function getSupportedPayoutDetail($country_code,$account_type){
    $map = getSupportedPayoutMap();
    $detail = null;

    /*
        {
            "account_type": "type_paypal",
            "account_provider": "PayPal",
            "account_function": "function_cash_out",
            "cash_out_min": 100,
            "cash_out_max": 2000
        }
      */


    if (isset($map[$country_code])){
        foreach ($map[$country_code] as $index => $item) {

            if ($account_type == $item["account_type"]){
                $detail = array();

                $detail["account_type"] = $item["account_type"];
                $detail["account_provider"] = $item["account_provider"];
                $detail["account_function"] = $item["account_function"];
                $detail["cash_out_min"] = $item["cash_out_min"];
                $detail["cash_out_max"] = $item["cash_out_max"];

                break;
            }
        }
    }
    else{
        foreach ($map["GENERAL"] as $index => $item) {

            if ($account_type == $item["account_type"]){
                $detail = array();

                $detail["account_type"] = $item["account_type"];
                $detail["account_provider"] = $item["account_provider"];
                $detail["account_function"] = $item["account_function"];
                $detail["cash_out_min"] = $item["cash_out_min"];
                $detail["cash_out_max"] = $item["cash_out_max"];

                break;
            }
        }
    }


    return $detail;
}





//INSIGHT : This is checks if the survey url is running on the insight platform
function isInsightSurvey($survey_url){
    $is_insight_survey = false;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);

    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    return $is_insight_survey;
}

//INSIGHT : this get the insight survey id or NULL
function getInsightSurveyID($survey_url){
    $is_insight_survey = false;
    $survey_id = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];
    }

    return $survey_id;
}

//INSIGHT : this gets the updated link with the token appended
function getUpdatedInsightSurveyLink($survey_url,$survey_token,$language_code = null){ //add language code
    $is_insight_survey = false;
    $url = $survey_url;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $search = "lang";
        $params = array();
        $query = parse_url($survey_url, PHP_URL_QUERY);
        parse_str($query,$params);

        if(preg_match("/{$search}/i", $query)){
            //if the url has "lang"
            foreach ($params as $key => $value) {
                if ($key == "lang") {
                    $item_search = "lang=$value";
                    $item_replace = "lang=$language_code";

                    if($language_code != null){
                        $survey_url = str_replace($item_search,$item_replace,$survey_url);
                    }

                }
            }
        }
        else {
            //if the url does not have "lang"
            if($language_code != null){
                $survey_url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'lang=' . $language_code;
            }
        }


        $url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'token=' . $survey_token;
    }

    return $url;
}


//INSIGHT : this gets a unique token from the survey database and reserves a spot
function getUniqueInsightSurveyToken($survey_url, $researcher = null){
    $is_insight_survey = false;
    $survey_id = null;
    $available_token = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];

        $survey_response_table = "lsnm_survey_" . $survey_id;
        $survey_token_table = "lsnm_tokens_" . $survey_id;

        $insight_db = new Database(INSIGHT_DB_USERNAME,INSIGHT_DB_PASSWORD,INSIGHT_DB_NAME);

        $available_token = null;
        $has_available_token = false;
        $reservation_time = getCurrentTime("Y-m-d H:i");


        //get previously assigned token
        $user_ref_id = $researcher->getUserRefId();
        $fname = $researcher->get_firstName();
        $lname = $researcher->get_lastName();
        $email = $researcher->get_email();


        $sql_prev_token = "select * from " . $survey_token_table . " where attribute_1 = '$user_ref_id' and (completed is null or completed in ('N'))"; //previous token is still available
        $sql_prev_query_result = $insight_db->query($sql_prev_token);
        if($sql_prev_query_result != null && $sql_prev_query_result->is_row_found()){
            while($row = $sql_prev_query_result->fetch_array()){
                $token_id = $row["tid"];
                $available_token = $row["token"];

                $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time' where `tid` = '$token_id'";
                $update_query_result = $insight_db->query($update_query);
                if($update_query_result != null && $update_query_result->is_row_affected()){
                    //$has_available_token = true;
                }

                break;
            }
        }
        else{
            $sql_query = "select * from " . $survey_token_table . " where sent is null or sent in ('N')"; //token is available
            $sql_query_result = $insight_db->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $token_id = $row["tid"];
                    $available_token = $row["token"];

                    $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time', email = '$email', attribute_1 = '$user_ref_id', firstname = '$fname', lastname = '$lname' where `tid` = '$token_id'";
                    $update_query_result = $insight_db->query($update_query);
                    if($update_query_result != null && $update_query_result->is_row_affected()){
                        //$has_available_token = true;
                    }

                    break;
                }
            }
        }






    }

    return $available_token;
}

//============= THIRD PARTY API START =================

/**
 * @usage - This will be used for mobile recharge
 * @methods GetCurrencies
 * @methods GetRegions
 * @methods GetCountries
 * @methods GetProviders
 * @methods GetProviderStatus
 * @methods GetProducts
 * @methods GetProductDescriptions
 * @methods SendTransfer
 * @methods GetBalance
 *
 *
 * @link connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
 *
 *
 * @COUNT 9
 */


//5 -
//18765197487 -

$get_prod = array();


$payload = array();
$payload["SkuCode"] = "JM_DC_TopUp";
$payload["SendValue"] = 5;
$payload["SendCurrencyIso"] = "usd";
$payload["AccountNumber"] = "18765197487";
$payload["DistributorRef"] = "#659075749";

$settings = array();
$settings["Name"] = "Queritel Payout";
$settings["Value"] = "5 usd";

$payload["Settings"] = $settings;
$payload["ValidateOnly"] = false;
$payload["BillRef"] = "Queritel Reference : 1967048";

/*{
  "SkuCode": "string",
  "SendValue": 0,
  "SendCurrencyIso": "string",
  "AccountNumber": "string",
  "DistributorRef": "string",
  "Settings": [
    {
      "Name": "string",
      "Value": "string"
    }
  ],
  "ValidateOnly": true,
  "BillRef": "string"
}*/




//DING MOBILE RECHARGE : needs to be fixed
function connectDingAPI($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json','api_key: ApyJWyuifmb6YMuJhu7wAW'));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            'Content-Type: application/json',
            'api_key: ' . DING_MOBILE_RECHARGE_KEY
        ));


    $payload = array();
    $payload["SkuCode"] = "JM_DC_TopUp";
    $payload["SendValue"] = 5;
    $payload["SendCurrencyIso"] = "USD";
    //$payload["AccountNumber"] = "18765197487";
    $payload["AccountNumber"] = "18762971769";
    $payload["DistributorRef"] = "#659075749";

    //$settings = array();
    //$settings["Name"] = "Queritel Payout";
    //$settings["Value"] = "5 usd";
    //$settings["Name"] = "";
    //$settings["Value"] = "";

    //$payload["Settings"] = $settings;
    $payload["ValidateOnly"] = true;
    $payload["BillRef"] = "Queritel Reference : 1967048";



    //$fields = array();
    //$fields['data'] = $message;
    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $res = curl_exec($ch);

    curl_close($ch);

    //$res = json_decode($res, true);
    //$res = json_decode($res, true);

    return $res;
}




//FIREBASE NOTIFICATION BASE
function sendFCM($message, $id) {
    /*if(!function_exists(curl_exec)){
        LogReport("unsetRequestTopicListener : " . "curl is not installed");
        return;
    }*/

    /*
     $stri_and_works_ios_without = '{
            "to": "' . $notification_id1_ios . '",
            "content_available": true,
            "data": {
                "payload": {
                    "status": "new_quest",
                    "extra": {
                        "message": "testing"
                    }
                }
            }
     }';
     */

    //$message =  array
    $url = 'https://fcm.googleapis.com/fcm/send';

    $fields = array();
    $fields['content_available'] = true; //This is to ensure that notifications are delivered to the iOS device
    $fields['data'] = $message;
    /*"notification": {
         "body": "Message title available here  -- thus s",
         "title": "The content of the notification 2",
         "icon": "app_icon"
     }*/


    if (is_array($id)) {
        //1000 id limit
        $fields["registration_ids"] = $id;
    }
    else {
        $fields["to"] = $id;
    }


    $encoded_fields = json_encode($fields);
    $headers = array(
        'Authorization: key=' . FIREBASE_SERVER_KEY,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    //echo $result;

    curl_close($ch);

    return $result;
}

//VERIFY CHILEAN R.U.T
function verifyRUT($chilean_rut){
    $__lnk = 'https://api.libreapi.cl/';
    $__out = '{
                "data": {
                    "rut": "272.185.964-8",
                    "name": "Full Name",
                    "activities": [
                        {
                            "name": "Actividades De Consultoria De Gestion",
                            "code": 702000,
                            "category": "Segunda",
                            "subject_to_vat": false,
                            "date": "2020-06-18T00:00:00Z"
                        }
                    ]
                },
                "status": "success"
            }';



    //$url = "https://api.libreapi.cl/rut/validate?rut=" . $chilean_rut;
    $url = "https://api.libreapi.cl/rut/activities?rut=" . $chilean_rut;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    //$payload = array();
    //$payload["var_1"] = "value";

    //$encoded_fields = json_encode($payload);
    //curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_object = json_decode($result, true);

    $output = array();
    $output["rut"] = $chilean_rut;
    $output["verified"] = false;
    $output["full_name"] = null;
    $output["activities"] = null;

    if (($result_object["status"] == "success")){
        $output["rut"] = $result_object["data"]["rut"];

        if (!empty($result_object["data"]["name"])){
            $output["verified"] = true;
            $output["full_name"] = $result_object["data"]["name"];
            $output["activities"] = $result_object["data"]["activities"];
        }
    }

    curl_close($ch);

    return $output;
}




//THIRD-PARTY API TEMPLATE
function __api_template__($url){
    $__lnk = 'https://';
    $__out = '';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    $payload = array();
    $payload["var_1"] = "value";

    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    //$result_object = json_decode($result, true);

    curl_close($ch);

    return $result;
}


//============= THIRD PARTY API END ===================


function sendNewQuestNotificationUser($paperweight,$user_id){
    //$note_id = array();


    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $note_id = $row["notification_id"];

            //$message = array();
            //$payload = array();
            //$payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            //$payload["extra"]["message"] = null;
            //$message["payload"] = $payload;

            $payload = array();
            $message = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
            $payload["extra"]["message"] = null;
            $message["payload"] = $payload;

            sendFCM($message,$note_id);

        }
    }
}
function sendNewQuestNotification($paperweight,$country_code){
    //$note_id = array();

    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION;
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $user_id = $row["user_id"];

            $user_data = query_user($user_id,$paperweight);
            $code = $user_data["country_code"];

            //country_code

            if ($country_code == $code){

                $note_id = $row["notification_id"];
                $message = array();

                $payload = array();
                $payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
                $payload["extra"]["message"] = null;
                $message["payload"] = $payload;
                sendFCM($message,$note_id);

            }
        }
    }
}
function sendNewMessageNotification($user_id,$paperweight){
    //$note_id = array();


    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $note_id = $row["notification_id"];

            $message = array();
            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = null;
            $message["payload"] = $payload;
            sendFCM($message,$note_id);

        }
    }
}


//users who accepted the specific quest
function getQuestAgents($task_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;
    $processed_array = array();

    $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {

        $data = array();

        while ($row = $response_result->fetch_array())
        {

            //$response_total = $row["survey_count"];
            //$response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];


            if (!isset($processed_array[$user_id])){

                $user_info = query_user($user_id, $paperweight);

                $data["user_id"] = $user_info["user_id"];
                $data["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
                $data["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
                $data["phone_number"] = $user_info["phone_number"];
                $data["email"] = $user_info["user_email"];


                $processed_array[$user_id] = $data;

                $progress[$index] = $data;

                $index++;
            }

            //$progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["user_id"] = $user_info["user_id"];


            //$progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            //$progress[$index]["response_total"] = intval($response_total);
            //$progress[$index]["response_count"] = intval($response_count);

            //$combined_total = $combined_total + $response_count;
        }
    }

    //$result["combined_total"] = intval($combined_total);
    //$result["progress"] = $progress;

    return $progress;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];


            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;
            $result["country_code"] = $row["country_code"];
            $result["phone_number"] = $row["phone_number"];
            $result["user_email"] = $row["user_email"];


        }
    }

    return $result;
}
function getLastMsg($agent_id,$network_id,$task_id,$paperweight){
    //get the last communication between an agent and the network
    //as well as the unread messages
    $last_msg = array();
    $last_msg["msg_body"] = "";
    $last_msg["timestamp"] = "";
    $last_msg["unread"] = 0; //the combined unread messages


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$network_id' or recipient_network_id = '$network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){


        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);
            $read = $row["read"];
            $unread = 0;


            $last_msg["msg_body"] = $msg_body;
            $last_msg["timestamp"] = $timestamp;

            if (($recipient_network_id == $network_id) && $read == 0){
                $prev_unread = $last_msg["unread"];
                $new_unread = $prev_unread + 1;

                $last_msg["unread"] = $new_unread;

            }

        }

    }


    return $last_msg;
}


/**
 * This function will check if a string is inside a string-array
 * irregardless of the case of the string
 *
 *  */
function isContainedIn($str, $str_array, $case_sensitive = false) {


    if($case_sensitive == false){
        $needle = strtolower($str);
        $haystack = strtolower($str_array);
    }
    else{
        $needle = $str;
        $haystack = $str_array;
    }

    $found = preg_match("/$needle/", $haystack);


    if($found){

        return true;
    }
    else{

        return false;
    }
}
function notificationTokenHash($notification_id){
    return md5("05624" . $notification_id);
}
function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function random_number($length = 5) {
    $characters = '01234567898576479201';
    $charactersLength = strlen($characters);
    $randomNumber = '';

    for ($i = 0; $i < $length; $i++) {
        $randomNumber .= $characters[true_random(0, $charactersLength - 1)];
    }
    return $randomNumber;
}
function generate_token() {
    return getRandomNumber(4) . "" . getRandomNumber(4);
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}

//experimental id generator
function get_guid() {
    // Get an RFC-4122 compliant globally unique identifier
    try {
        $data = PHP_MAJOR_VERSION < 7 ? openssl_random_pseudo_bytes(16) : random_bytes(16);
    } catch (Exception $e) {
        $data = openssl_random_pseudo_bytes(16);
    }
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);    // Set version to 0100
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);    // Set bits 6-7 to 10
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}


function hasAgent(){
    $has_agent = isset($_GET["agent"]);
    //$app_agent = clean($_GET["agent"]);

    //if (!$has_agent){
        //$has_agent = true;
        //$app_agent = MOBILE_AGENT_ANDROID;
    //}

    return $has_agent;
}
function getAgent(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = text_clean($_GET["agent"]);

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    return $app_agent;
}
function getAPP_VERSION_DATA(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = clean($_GET["agent"]);
    $results = array();

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    if ($has_agent && ($app_agent == MOBILE_AGENT_ANDROID)){
        $results[MOBILE_VERSION_NAME] = ANDROID_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = ANDROID_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = ANDROID_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = ANDROID_VERSION_PRIORITY;
    }
    else if ($has_agent && ($app_agent == MOBILE_AGENT_IOS)){
        $results[MOBILE_VERSION_NAME] = IOS_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = IOS_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = IOS_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = IOS_VERSION_PRIORITY;
    }

    return $results;
}


//debug----
function getQuestCreatorNetwork($task_id,$paperweight){
    $network_id = null;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $network_id = $row["creator_net_id"];
        }
    }

    return $network_id;
}
function getQuestDetail($task_id,$paperweight){
    $detail = array();

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $detail["task_id"] = $row["task_id"];
            $detail["creator_net_id"] = $row["creator_net_id"];
            $detail["task_ref_id"] = $row["task_ref_id"];
            $detail["task_user_id"] = $row["task_user_id"];
            $detail["task_status"] = $row["task_status"];
            $detail["task_topic"] = $row["task_topic"];
            $detail["task_budget"] = $row["task_budget"];
            $detail["task_instructions"] = $row["task_instructions"];
            $detail["task_posted_on"] = $row["task_posted_on"];
            $detail["task_completed_on"] = $row["task_completed_on"];
            $detail["task_respondent_count"] = $row["task_respondent_count"];
            $detail["task_question_count"] = $row["task_question_count"];
            $detail["task_location_count"] = $row["task_location_count"];
            $detail["survey_url"] = $row["survey_url"];
            $detail["completion_url"] = $row["completion_url"];
            $detail["survey_ready"] = $row["survey_ready"];
            $detail["task_time_day"] = $row["task_time_day"];
            $detail["task_question_type"] = $row["task_question_type"];
            $detail["my_network"] = $row["my_network"];
            $detail["network_id"] = $row["network_id"];
            $detail["task_category"] = $row["task_category"];
            $detail["task_activity"] = $row["task_activity"];
            $detail["task_start_date"] = $row["task_start_date"];
            $detail["task_due_date"] = $row["task_due_date"];
            $detail["handle_payment"] = $row["handle_payment"];
            $detail["workforce_timezone"] = $row["workforce_timezone"];
            $detail["workforce_country"] = $row["workforce_country"];
        }
    }

    return $detail;
}
//debug----

//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;


        }
    }

    return $result;
}
function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}
function isFromNetwork($user_id, $network_id, $paperweight,$check_active = true){
    //check_active - check to make sure the relationship is active

    $is_from_network = false;

    if ($check_active){
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and relationship_state = '" . STATE_ACTIVE . "'";
    }
    else{
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "'";
    }

    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $is_from_network = true;
        }
    }

    return $is_from_network;
}
function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {
        while ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result[] = $net;

        }
    }


    return $result;
}
function isFromOfficialNetwork($user_id, $paperweight,$check_active = true){
    $from_official = false;

    $official_networks = getOfficialNetworks($paperweight);
    $network_relationship = getNetworkRelationship($user_id,$paperweight);

    if (!empty($network_relationship)){
        foreach ($network_relationship as $relation){
            $network_id = $relation["network_id"];
            $network_role = $relation["network_role"];
            $network_rel_state = $relation["relationship_state"];

            if ($check_active){
                if (in_array($network_id,$official_networks) && $network_rel_state == STATE_ACTIVE){
                    $from_official = true;
                }
            }
            else{
                if (in_array($network_id,$official_networks)){
                    $from_official = true;
                }
            }
        }
    }

    return $from_official;
}
function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}

//Location-Based functions
function getDistanceBetweenAccurate(LocationPoint $point1, LocationPoint $point2) {
    //get the distance from driver's location to the request origin [to see how close the driver is]
    //returns array("SUCCESS","distance_value")
    //unit = metrics(meters)

    $output["status"] = "FAILED";

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $origin = $point1->getLatitude() . "," . $point1->getLongitude();
    $destination = $point2->getLatitude() . "," . $point2->getLongitude();

    $url2 = "https://map.google.com/maps/api/distancematrix/json?units=metric&origins={$origin}&destinations={$destination}&key=" . SERVER_MAP_KEY;
    $fil2 = file_get_contents($url2);

    $results = json_decode($fil2, true);


    if ($results["status"] == "OK") {
        if ($results["rows"][0]["elements"][0]["status"] == "OK") {
            $distance_in_meters = $results["rows"][0]["elements"][0]["distance"]["value"];
            $output["status"] = "SUCCESS";
            $output["distance"] = $distance_in_meters;
        }
    }

    return $output;
}
function getRad($var) {
    return $var * pi() / 180;
}
function getDistanceBetweenGeneral(LocationPoint $point1, LocationPoint $point2) {
    $EARTH_MEAN_RADIUS_METERS = 6378137; //earths mean radius in meters

    $output = null;

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $distanceLat = getRad($point2->getLatitude() - $point1->getLatitude());
    $distanceLon = getRad($point2->getLongitude() - $point1->getLongitude());

    $a = sin($distanceLat / 2) * sin($distanceLat / 2) + cos(getRad($point1->getLatitude())) * cos(getRad($point2->getLatitude())) * sin($distanceLon / 2) * sin($distanceLon / 2);
    $angular_distance = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance_meters = intval($EARTH_MEAN_RADIUS_METERS * $angular_distance);

    $output = $distance_meters;

    return $output;
}

function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    //$handle = fopen("checked/" . $fname, "a");
    $handle = fopen("" . $fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}


function debugGeneralLog($action,$data, $researcher) {

    $fname = $researcher->get_firstName();
    $lname = $researcher->get_lastName();
    $user_id = $researcher->get_userId();
    $token = $researcher->get_loginToken();
    //$date = getCurrentTime();
    $country_code = $researcher->getLocationCountryCode();

    $encoded = json_encode($data,JSON_UNESCAPED_UNICODE);

    //debugPaywallLog($row_data);

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $date = $time->format('d-M-Y h:i:s');
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);

    //$heading = "User ID, Session Token, First Name, Last Name, Activity, Date, Country, Data\n";
    //$row_data = "$user_id, $token, $fname, $lname, $action, $date, $country_code, $encoded\n";

    $heading = "User ID\t Session Token\t First Name\t Last Name\t Activity\t Date\t Country\t Data\n";
    $row_data = "$user_id\t $token\t $fname\t $lname\t $action\t $date\t $country_code\t $encoded\n";

    $fname = "__general_log.csv";

    if (!file_exists( $fname)){
        $handle = fopen($fname, "w");

        $heading = "User ID\t Session Token\t First Name\t Last Name\t Activity\t Date\t Country\t Data\n";

        fwrite($handle, $heading);
        fclose($handle);
    }

    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $row_data);
    fclose($handle);

    return true;
}

function __get_template__($paperweight){
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }
}
function __insert_template__($paperweight){
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __update_template__($paperweight){
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __delete_template__($paperweight){
    $module = array();

    $sql_query = "delete from " . "_TABLE_NAME_" . " where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}

/*
 * Author : Kadian Salmon
 * Date : Sep 16, 2019
 * Purpose : Main class for all operations relating to researcher
 */
class Researcher {
    private $db_connector;
    private $isLoggedin;//is the researcher logged in
    private $isActive;//is this researcher's account still active
    private $hasCurrentLocation;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //researcher details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $user_ref_id = null;
    private $language_code = null;
    private $password = null;
    private $screenName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;

    private $occupation = null;
    private $education = null;
    private $marital_status = null;
    private $ethnicity = null;
    private $employment_status = null;
    private $employment_industry = null;


    private $locationCountry = null;
    private $locationCountryCode = null;
    private $currencyCode = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $locationAddress = null;
    private $date_of_birth = null;



    public function __construct(Database $db_connector) {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null,null);

    }


    public function get_db_connector() {
        return $this->db_connector;
    }

    public function isLoggedin() {
        return $this->isLoggedin;
    }

    public function isActive() {
        return $this->isActive;
    }

    public function get_userId() {
        return $this->userId;
    }

    public function get_loginToken() {
        return $this->loginToken;
    }

    public function get_email() {
        return $this->email;
    }

    public function getUserRefId()
    {
        return $this->user_ref_id;
    }

    public function get_encrytedPassword() {
        return $this->password;
    }

    public function get_screenName() {
        return $this->screenName;
    }

    public function get_firstName() {
        return $this->firstName;
    }

    public function get_lastName() {
        return $this->lastName;
    }

    public function get_gender() {
        return $this->gender;
    }

    public function get_locationCountry() {
        return $this->locationCountry;
    }

    public function getLanguageCode()
    {
        return $this->language_code;
    }


    public function get_locationState() {
        return $this->locationState;
    }

    public function get_locationCity() {
        return $this->locationCity;
    }

    public function get_registrationDate() {
        return $this->registrationDate;
    }

    public function get_phoneNumber() {
        return $this->phoneNumber;
    }

    public function getCurrentLocation(){
        return $this->currentLocation;
    }

    public function getLocationCountryCode()
    {
        return $this->locationCountryCode;
    }

    public function getLocationAddress()
    {
        return $this->locationAddress;
    }

    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    //todo - get currency from signup
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }


    public function getOccupation()
    {
        return $this->occupation;
    }
    public function getEducation()
    {
        return $this->education;
    }
    public function getMaritalStatus()
    {
        return $this->marital_status;
    }
    public function getEthnicity()
    {
        return $this->ethnicity;
    }
    public function getEmploymentStatus()
    {
        return $this->employment_status;
    }
    public function getEmploymentIndustry()
    {
        return $this->employment_industry;
    }


    public function setEmploymentIndustry($employment_industry)
    {
        $this->employment_industry = $employment_industry;
    }
    public function setEthnicity($ethnicity)
    {
        $this->ethnicity = $ethnicity;
    }
    public function setEmploymentStatus($employment_status)
    {
        $this->employment_status = $employment_status;
    }
    public function setMaritalStatus($marital_status)
    {
        $this->marital_status = $marital_status;
    }
    public function setOccupation($occupation)
    {
        $this->occupation = $occupation;
    }
    public function setEducation($education)
    {
        $this->education = $education;
    }



    public function setLanguageCode($language_code)
    {
        $this->language_code = $language_code;
    }

    public function setCurrentLocation($lat,$lon){
        $currentLocation = new LocationPoint(null,null);

        if (!empty($lat) && !empty($lon)){
            $currentLocation = new LocationPoint($lat,$lon);
        }

        $this->currentLocation = $currentLocation;

    }

    public function set_db_connector($db_connector) {
        $this->db_connector = $db_connector;
    }

    public function set_isLoggedin($isLoggedin) {
        $this->isLoggedin = $isLoggedin;
    }

    public function set_isActive($isActive) {
        $this->isActive = $isActive;
    }

    public function set_userId($userId) {
        $this->userId = $userId;
    }

    public function set_loginToken($loginToken) {
        $this->loginToken = $loginToken;
    }

    public function set_email($email) {
        $this->email = $email;
    }

    public function setUserRefId($user_ref_id)
    {
        $this->user_ref_id = $user_ref_id;
    }

    public function set_encrytedPassword($password) {
        $this->password = $password;
    }

    public function set_screenName($screenName) {
        $this->screenName = $screenName;
    }

    public function set_firstName($firstName) {
        $this->firstName = $firstName;
    }

    public function set_lastName($lastName) {
        $this->lastName = $lastName;
    }

    public function set_gender($gender) {
        $this->gender = $gender;
    }

    public function set_locationCountry($locationCountry) {
        $this->locationCountry = $locationCountry;
    }

    public function set_locationState($locationState) {
        $this->locationState = $locationState;
    }

    public function set_locationCity($locationCity) {
        $this->locationCity = $locationCity;
    }

    public function set_registrationDate($registrationDate) {
        $this->registrationDate = $registrationDate;
    }

    public function set_phoneNumber($phoneNumber) {
        $this->phoneNumber = $phoneNumber;
    }

    public function setLocationCountryCode($locationCountryCode)
    {
        $this->locationCountryCode = $locationCountryCode;
    }

    public function setLocationAddress($locationAddress)
    {
        $this->locationAddress = $locationAddress;
    }

    public function setDateOfBirth($date_of_birth)
    {
        $this->date_of_birth = $date_of_birth;
    }

    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }



    //todo : currency support to get rates from database table
    public function getCurrencyRate($currency = SYSTEM_CURRENCY){
        //This rate listing is relative to the SYSTEM_CURRENCY = "USD"

        $RATE = array();
        $RATE["USD"] = 1;
        $RATE["JMD"] = 140;
        $RATE["CLP"] = 730;

        if (!isset($RATE[$currency])){
            return $RATE[SYSTEM_CURRENCY];
        }
        else{
            return $RATE[$currency];
        }
    }

    //todo : currency support to convert funds to desired currency
    public function getConvertedFunds($usd_funds, $currency = null)
    {
        $converted_funds = 0;

        if($currency == null){
            $currency = $this->currencyCode;
        }

        if ($currency == null){
            $currency = SYSTEM_CURRENCY;
        }

        $rate = $this->getCurrencyRate($currency);

        $converted_funds = floatval($usd_funds * $rate);

        return $converted_funds;
    }

    public function signout($user_id,$login_token) {
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";


        $result["status"] = STATUS_OK;


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if($update_result != null && $update_result->is_row_affected()){
                    $result["status"] = STATUS_OK;
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;

    }

    public function login($username,$password,$login_data_arr) {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $verified_by_admin = VERIFIED;
        $verified_email = VERIFIED;

        $login_data = null;
        if (!empty($login_data_arr)){
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }
        else{
            $login_data_arr = array();
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_CRED);


        if($this->db_connector != null){
            $login_query = "select * from " . TABLE_USERS . " where lower(user_email) = '$provided_username' and user_password = '$provided_password' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin' and user_email_verified = '$verified_email'";

            $login_result = $this->db_connector->query($login_query);

            if($login_result != null && $login_result->is_row_found()){
                $row_data = $login_result->fetch_array();

                if($row_data != null){
                    $actual_uname = $row_data["user_email"];
                    $actual_pass = $row_data["user_password"];

                    if(($actual_uname == $provided_username) && ($actual_pass == $provided_password)){

                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;
                        $user_id = $row_data["user_id"];


                        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,login_data) values ('$login_token','$login_time','$login_state','$user_id','$login_data')";
                        $details_result = $this->db_connector->query($details_query);

                        if($details_result != null && $details_result->is_row_affected()){
                            //$this->isLoggedin = true;
                            $result = $this->getOKStatus();

                            $result["user_id"] = $row_data["user_id"];
                            $result["login_token"] = $login_token;

                            return $result;
                        }


                    }

                }
            }


        }

        return $result;

    }

    public function verifyLogin($user_id,$login_token) {
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_VALID;
        $verified_by_admin = VERIFIED;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin'";

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                $user_result = $this->db_connector->query($user_check_query);
                if($user_result != null && $user_result->is_row_found()){
                    $result = $this->getOKStatus();

                    $version_data = getAPP_VERSION_DATA();

                    if (hasAgent()){
                        $result[MOBILE_VERSION_NAME] = $version_data[MOBILE_VERSION_NAME];
                        $result[MOBILE_VERSION_CODE] = $version_data[MOBILE_VERSION_CODE];
                        $result[MOBILE_VERSION_COMMENT] = $version_data[MOBILE_VERSION_COMMENT];
                        $result[MOBILE_VERSION_PRIORITY] = $version_data[MOBILE_VERSION_PRIORITY];
                    }

                    $this->isLoggedin = true;
                    $this->userId = $user_id;
                    //$this->userId = 1468; -- hugo
                    $this->loginToken = $login_token;
                }
                else{
                    $result = $this->getErrorStatus(ERROR_MSG_USER_DEACTIVATED);
                }

            }
        }

       return $result;

    }

    public function initializeResearcher($user_id,$login_token="") {
        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if($user_id != null){
            $this->userId = $user_id;
            //$this->userId = 1468; -- hugo
        }
        else{
            return false;
        }
        if($login_token != null){
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
        $user_profile_check_query = "select * from " . TABLE_USER_PROFILE . " where userprofile_user_id = '$user_id'";

        if($this->db_connector != null){
            $user_result = $this->db_connector->query($user_check_query);
            $user_profile_result = $this->db_connector->query($user_profile_check_query);
            if($user_result != null && $user_result->is_row_found()){
                $row = $user_result->fetch_array();
                $row_profile = $user_profile_result->fetch_array();

                if($row != null){
                    $this->email = strtolower($row["user_email"]);
                    $this->password = $row["user_password"];
                    $this->screenName = strtolower($row["user_screen_name"]);
                    $this->firstName = strtolower($row["user_first_name"]);
                    $this->lastName = strtolower($row["user_last_name"]);

                    if ($row["user_sex"] == GENDER_MALE){
                        $this->gender = GENDER_MALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_FEMALE){
                        $this->gender = GENDER_FEMALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NON_BINARY){
                        $this->gender = GENDER_NON_BINARY_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NOT_TO_SAY){
                        $this->gender = GENDER_NOT_TO_SAY_STRING;
                    }

                    $this->registrationDate = $row["user_regdate"];


                    $account_state = $row["user_active"];
                    $countryId = $row["user_country_id"];
                    $countryCode = $row["country_code"];
                    $phone_number = $row["phone_number"];
                    $location_address = $row["location_address"];
                    $date_of_birth = $row["date_of_birth"];
                    $user_ref_id = $row["user_ref_id"];
                    $language_code = $row["language_code"];

                    if ($row_profile != null){
                        $this->occupation = $row_profile["occupation"];
                        $this->education = $row_profile["education"];
                        $this->ethnicity = $row_profile["ethnicity"];
                        $this->marital_status = $row_profile["marital_status"];
                        $this->employment_status = $row_profile["employment_status"];
                        $this->employment_industry = $row_profile["employment_industry"];
                    }

                    $this->user_ref_id = $user_ref_id;
                    $this->language_code = $language_code;


                    if($account_state == STATE_ACTIVE){
                        $this->isActive = true;
                    }


                    if($countryCode != null){
                        $this->locationCountryCode = $countryCode;
                    }
                    //else{
                        //if no country is recorded then get the user's current country based on ip
                        //$this->locationCountryCode = $ip_country_code;
                    //}

                    /*if($countryId != null){
                        $this->locationCountry = Country::getCountry($countryId, $this->db_connector);
                    }*/

                    $ip_country_code = $this->host_info->getCountry_code();
                    $ip_currency_code = $this->host_info->getCurrency();

                    //todo - STORE USER'S CURRENCY CODE AT SIGN UP based on their country
                    if ($ip_currency_code != null){
                        //get currency based on current country
                        $this->currencyCode = $ip_currency_code;
                    }
                    else{
                        $this->currencyCode = SYSTEM_CURRENCY;
                    }


                    if($phone_number != null){
                        $this->phoneNumber = $phone_number;
                    }

                    if($location_address != null){
                        $this->locationAddress = $location_address;
                    }
                    if($date_of_birth != null){
                        $this->date_of_birth = $date_of_birth;
                    }

                    /*if ($this->get_userId() == "1077"){
                        $this->host_info->setCountry_code("JM");
                    }*/

                    return true;

                }

            }
        }

        return false;


    }

    public function updateNotificationToken($notification_id){
        $user_id = $this->get_userId();
        $login_token = $this->get_loginToken();
        $notification_hash = md5($notification_id);

        $updated = false;

        $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token' and notification_hash = '$notification_hash'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_found()){
            $updated = true;
        }
        else{
            $sql_query_2 = "insert into " . TABLE_REALTIME_NOTIFICATION . " (token_id,notification_id,notification_hash,user_id) values ('$login_token','$notification_id','$notification_hash','$user_id')";
            $sql_query_result_2 = $this->db_connector->query($sql_query_2);
            if($sql_query_result_2 != null && $sql_query_result_2->is_row_affected()){
                $updated = true;
            }
        }

        return $updated;
    }

    public function removeNotificationToken($user_id,$login_token){

        //$user_id = $this->get_userId();
        //$login_token = $this->get_loginToken();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }

    public function removeAllNotificationToken(){
        $user_id = $this->get_userId();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }



    public function getAvailableJobs() {

        $available = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $available;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){

            $official_networks = getOfficialNetworks($this->db_connector);
            //$isOfficialCollector = isFromOfficialNetwork($this->userId,$this->db_connector);
            $network_relationship = getNetworkRelationship($this->userId, $this->db_connector);

            $current_time = getCurrentTime();


            //$team_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_id is not '281' and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            //$team_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $team_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and  task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $team_result = $this->db_connector->query($team_query);

            if($team_result != null && $team_result->is_row_found()){
                while($team_data = $team_result->fetch_array()){
                    $creator_network = $team_data["creator_net_id"];

                    if (!empty($network_relationship)){
                        foreach ($network_relationship as $relation){
                            $network_id = $relation["network_id"];
                            $network_role = $relation["network_role"];
                            $network_rel_state = $relation["relationship_state"];

                            if (($network_id == $creator_network) && ($network_role == NETWORK_ROLE_COLLECTOR) && ($network_rel_state == STATE_ACTIVE)){

                                $approved_id[] = $team_data["task_id"];
                                $approved_data[] = $team_data;

                            }

                        }
                    }

                }
            }

            //$task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_INACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_INACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $creator_network = $team_data["creator_net_id"];

                    if (!empty($network_relationship)){
                        $is_available = false;//is the quest already available to the user

                        foreach ($network_relationship as $relation){
                            $network_id = $relation["network_id"];
                            $network_role = $relation["network_role"];
                            $network_rel_state = $relation["relationship_state"];

                            if (!$is_available){
                                if (in_array($network_id,$official_networks) || ($network_id == $creator_network)){
                                    if (($network_id == $creator_network) && ($network_rel_state == STATE_ACTIVE)){
                                        $approved_id[] = $task_data["task_id"];
                                        $approved_data[] = $task_data;
                                        $is_available = true;

                                    }
                                    elseif (($network_id != $creator_network)){
                                        $approved_id[] = $task_data["task_id"];
                                        $approved_data[] = $task_data;

                                        $is_available = true;
                                    }
                                }
                            }

                        }
                    }



                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnAvailableJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $available[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found && ((getAgent() == MOBILE_AGENT_ANDROID) || (getAgent() == MOBILE_AGENT_IOS))){
            //$result = $this->getOKStatus();
            $result["jobs"] = $available;
        }

        if ((getAgent() == MOBILE_AGENT_IOS)){
            $place_holder = array();

            $place_holder["task_id"] = "1000";
            $place_holder["survey_url"] = "https://www.queritel.com";
            $place_holder["project_description"] = "System Upgrade is in progress";
            //$place_holder["project_title"] = "System Upgrade in progress";
            $place_holder["project_title"] = "SYSTEM UPGRADE IN PROGRESS";

            $place_holder["job_id"] = "0000000000";
            $place_holder["user_id"] = null;
            $place_holder["profile_lock"] = false;
            $place_holder["location_address"] = "Queritel";
            $place_holder["location_country"] = "Queritel";
            $place_holder["location_state"] = "Queritel";
            $place_holder["location_lat"] = 0;
            $place_holder["location_lon"] = 0;
            $place_holder["researcher_required"] = 0;
            $place_holder["researcher_count"] = 0;
            $place_holder["customer"] = null;

            $place_holder["start_date"] = "0000-00-00 00:00:00";
            $place_holder["end_date"] = "0000-00-00 00:00:00";
            $place_holder["activity_type"] = ACTIVITY_TYPE_VOX;
            $place_holder["activity_category"] = ACTIVITY_CATEGORY_VOX;
            $place_holder["meter_radius"] = 10;
            $place_holder["tag_effort"] = 1;
            $place_holder["green_zone"] = 10; //a lock is placed on all quest out of this range

            $place_holder["price"] = $this->getConvertedFunds(0);
            $place_holder["currency"] = $this->getCurrencyCode();
            $place_holder["survey_count"] = 0;

            //$result["jobs"][] = $place_holder;

            //$result["jobs"] = array();
        }

        if (($this->get_userId() == 329)){
            //$result["jobs"] = array();
        }



        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/



        return $result;

    }

    public function getActiveJobs(){
        $active = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $active;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){
            $current_time = getCurrentTime();

            //$task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";

            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $approved_id[] = $task_data["task_id"];
                    $approved_data[] = $task_data;
                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnActiveJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $active[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found){
            //$result = $this->getOKStatus();
            $result["jobs"] = $active;
        }

        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/

        return $result;
    }

    public function getCompletedJobs() {
        $completed = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $completed;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){
            $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";// and survey_ready = 1
            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $approved_id[] = $task_data["task_id"];
                    $approved_data[] = $task_data;
                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnCompletedJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $completed[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found){
            //$result = $this->getOKStatus();
            $result["jobs"] = $completed;
        }

        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/


        return $result;
    }



    //todo : change to $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    public function acceptJob($job_id,$researcher) {

        $result["status"] = STATUS_OPERATION_FAILED;

        $job_query = "select * from " . TABLE_JOBS . " where job_id = '$job_id' and researcher_count < researcher_required";
        $job_result = $this->db_connector->query($job_query);

        if ($job_result != null && $job_result->is_row_found()){
            if($row = $job_result->fetch_array()){

                $response_id = generate_token();
                $update_time = getCurrentTime();
                $user_id = $this->get_userId();

                $local_currency_code = $this->getCurrencyCode();
                $local_currency_rate = $this->getCurrencyRate($local_currency_code);

                $job_id = $row["job_id"];
                $task_id = $row["task_id"];
                //$survey_id = $row["survey_id"];
                $cpq = $row["cpq"];
                //$researcher_required = $row["researcher_required"];

                $questionnaire_total = $row["survey_total"];
                $questionnaire_assigned = $row["survey_assigned"];
                $assignable = 0;//the number of questionnaires the reseacher could be assigned

                $remaining = $questionnaire_total - $questionnaire_assigned;

                //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                $question_set = $questionnaire_total / $row["researcher_required"];


                if($remaining > $question_set){
                    $assignable = $question_set;//lets cap it at the default
                }
                elseif($remaining <= $question_set){
                    $assignable = $remaining;//lets give the 'whats left'
                }

                $price = $assignable * $cpq;
                $researcher_count = $row["researcher_count"] + 1;
                $new_assigned = $questionnaire_assigned + $assignable;

                $check_criteria = false;//should we check if this researcher has responded to the task already

                if($check_criteria){
                    $response_check = "select * from " . TABLE_RESPONSE . " where user_id = '$user_id' and task_id = '$task_id' and survey_state = 1";
                    $response_result = $this->db_connector->query($response_check);

                    if($response_result != null && !$response_result->is_row_found()){
                        $check_linked = true;
                    }
                    else{
                        $check_linked = false;
                    }

                }
                else{
                    $check_linked = true;//bypass check
                }
                if($check_linked){
                    //this is a unique response
                    $current_location = $researcher->getCurrentLocation();
                    $lat = null;
                    $lng = null;
                    if (!$current_location->isEmpty()){
                        $lat = $current_location->getLatitude();
                        $lng = $current_location->getLongitude();
                    }

                    $task = $this->getTaskRaw($task_id);
                    $survey_id = null;
                    $survey_token = null;

                    if($task != null) {
                        $survey_url = $task["survey_url"];

                        if (isInsightSurvey($survey_url)){
                            $survey_id = getInsightSurveyID($survey_url);
                            $survey_token = getUniqueInsightSurveyToken($survey_url,$researcher);
                        }
                    }

                    $accept_query = "insert into " . TABLE_RESPONSE . " (response_id,update_time,job_id,task_id,user_id,survey_id,survey_token,survey_count,price,local_currency,local_currency_rate,accepted_lat,accepted_lon) values ('$response_id','$update_time','$job_id','$task_id','$user_id','$survey_id','$survey_token','$assignable','$price','$local_currency_code','$local_currency_rate','$lat','$lng')";

                    $accept_result = $this->db_connector->query($accept_query);
                    if($accept_result != null && $accept_result->is_row_affected()){
                        //success

                        $update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                        $update_result = $this->db_connector->query($update_job);

                        if($update_result != null && $update_result->is_row_affected()){
                            //$result["status"] = STATUS_OK;
                            $result = $this->getOKStatus();

                            //broadcast update to researcher and admin
                        }

                    }
                }

            }
        }


        return $result;

    }

    //todo : change to $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    public function cancelJob($response_id) {

        $result["status"] = STATUS_OPERATION_FAILED;


        $survey_state = SURVEY_STATE_PROGRESS;
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            if($row = $response_result->fetch_array()){
                //$task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = $row["survey_count"];


                $job = $this->getJobRaw($job_id);
                $general_assigned = $job["survey_assigned"];
                $researcher_count = $job["researcher_count"];

                //set value for job instance
                $new_assigned = $general_assigned - $assigned;
                $new_researcher = $researcher_count - 1;

                //set value for response
                $survey_state = SURVEY_STATE_CANCELLED;

                //update response to 'cancelled'
                $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                $response_q_result = $this->db_connector->query($update_response_q);

                if($response_q_result != null && $response_q_result->is_row_affected()){
                    $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                    $update_result = $this->db_connector->query($update_job);

                    if($update_result != null && $update_result->is_row_affected()){
                        $result["status"] = STATUS_OK;

                        //broadcast update to researcher and admin
                    }

                }


            }
        }

        return $result;

    }


    public function startProfileSurvey($researcher) {

        //this is triggered to allow the mobile user to start or complete the profile survey

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;
        //$result["submission_id"] = null;

        //$survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;
        $language_code = $this->language_code;
        $survey_url = PROFILE_SURVEY_TOKEN;
        $survey_token = null;


        $query_survey_token = "select profile_survey_token from " . TABLE_USERS . " where profile_survey_completed = 0 and profile_survey_token is not null and user_id = '$user_id'";
        $query_survey_token_result = $this->db_connector->query($query_survey_token);
        if($query_survey_token_result != null && $query_survey_token_result->is_row_found()){

            $row_data = $query_survey_token_result->fetch_array();
            $survey_token = $row_data["profile_survey_token"];

            $survey_url = getUpdatedInsightSurveyLink(PROFILE_SURVEY_TOKEN,$survey_token,$language_code);
        }
        else{
            $survey_token = getUniqueInsightSurveyToken(PROFILE_SURVEY_TOKEN, $researcher);


            $update_profile = "update " . TABLE_USERS . " set profile_survey_token = '$survey_token' where profile_survey_completed = 0 and user_id = '$user_id'";
            $update_result = $this->db_connector->query($update_profile);

            if ($update_result != null && $update_result->is_row_affected()){
                $survey_url = getUpdatedInsightSurveyLink(PROFILE_SURVEY_TOKEN,$survey_token,$language_code);
            }
        }

        return $survey_url;
    }
    public function completeProfileSurvey() {

        //this is triggered after the user has completed the profile survey

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;
        $is_completed = false;

        //$survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;
        $completed_time = getCurrentTime();

        $update_profile = "update " . TABLE_USERS . " set profile_survey_completed = 1, profile_survey_completed_date = '$completed_time' where profile_survey_completed = 0 and user_id = '$user_id'";
        $update_result = $this->db_connector->query($update_profile);

        if ($update_result != null && $update_result->is_row_affected()){
            $is_completed = true;
        }

        return $is_completed;

    }

    public function isProfileSurveyCompleted(){
        $is_completed = false;
        $user_id = $this->userId;

        $query_survey_token = "select * from " . TABLE_USERS . " where profile_survey_completed = 1 and user_id = '$user_id'";
        $query_survey_token_result = $this->db_connector->query($query_survey_token);
        if($query_survey_token_result != null && $query_survey_token_result->is_row_found()){
            $is_completed = true;
        }

        return $is_completed;
    }


    public function startSubmission($response_id) {

        //this is triggered when the start quest button is pressed
        //if the questionnaire being completed is the final ;
        //then this job is now completed and the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;
        //$result["submission_id"] = null;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;
        $submission_id = null;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = intval($row["survey_count"]);
                $completed = intval($row["survey_completed"]);

                if($completed < $assigned){
                    //as long as there are submissions to be made

                    $current_location = $this->getCurrentLocation();

                    $lat = null;
                    $lng = null;

                    if (!$current_location->isEmpty()){
                        $lat = $current_location->getLatitude();
                        $lng = $current_location->getLongitude();
                    }

                    if($completed == 0){
                        //if this response is just starting .. update the start time
                        //check if unfinished submissions exist, update the start time and use it, and if not create it
                        $start = getCurrentTime();
                        $update_response = "update " . TABLE_RESPONSE . " set survey_start = '$start' where response_id = '$response_id'";
                        $update_result = $this->db_connector->query($update_response);

                        if ($update_result != null && $update_result->is_row_affected()){
                            $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                            $submission_result = $this->db_connector->query($submission_query);
                            if($submission_result != null && $submission_result->is_row_found()){
                                //if an unfinished submission was found, use its id
                                if($submission_entry = $submission_result->fetch_array()){
                                    $submission_id = $submission_entry["submission_id"];

                                    $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                    $update_sub_result = $this->db_connector->query($update_submission);
                                    if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                                }
                            }
                            else{
                                //if an unfinished submission was NOT found, create a submission entry
                                $submission_id = generate_token();

                                $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                                $insert_sub_result = $this->db_connector->query($insert_submission_query);
                                if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                            }
                        }
                    }
                    else{
                        $start = getCurrentTime();
                        //if this response already has submissions .. check if unfinished submissions exist, update the start time and use it, and if not create it
                        $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                        $submission_result = $this->db_connector->query($submission_query);
                        if($submission_result != null && $submission_result->is_row_found()){
                            //if an unfinished submission was found, use its id
                            if($submission_entry = $submission_result->fetch_array()){
                                $submission_id = $submission_entry["submission_id"];

                                $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                $update_sub_result = $this->db_connector->query($update_submission);
                                if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                            }
                        }
                        else{
                            //if an unfinished submission was NOT found, create a submission entry
                            $submission_id = generate_token();

                            $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                            $insert_sub_result = $this->db_connector->query($insert_submission_query);
                            if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                        }

                    }

                    $result = $this->getOKStatus();
                    $result["submission_id"] = $submission_id;
                }

            }

        }

        return $result;
    }

    public function completeSubmission($response_id,$submission_id,$percent_completion) {

        //this is triggered when a questionnaire is completed
        //if the questionnaire being completed is the final ;
        //then this job is now completed ant the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = $row["survey_count"];
                $completed = $row["survey_completed"];
                $current_percent_completion = $row["percent_completion"];
                $is_price_moderated = $row["is_price_moderated"];
                $original_price = $row["price"];
                $new_price = $original_price;

                if($completed < $assigned){
                    //if more is to be completed
                    $new_completed_count = $completed + 1;
                    $final = ($assigned - 1);


                    //check if its the final submission
                    if($completed == $final){
                        $current_location = $this->getCurrentLocation();
                        $lat = null;
                        $lng = null;
                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }

                        $new_survey_state = SURVEY_STATE_COMPLETED;
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){

                            $moderated = false;

                            if (($new_percent_completion < 100 && $new_percent_completion != 0) && $is_price_moderated == 0){
                                $_percent = $new_percent_completion / 100;
                                $new_price = $_percent * $original_price;

                                $moderated = true;

                            }

                            if ($moderated){
                                $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', survey_state = '$new_survey_state', survey_end = '$completion_time', percent_completion = '$new_percent_completion', percent_completion = '$new_percent_completion', is_price_moderated = 1, original_price = $original_price, price = $new_price where response_id = '$response_id' and user_id = '$user_id'";
                            }
                            else{
                                $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', survey_state = '$new_survey_state', survey_end = '$completion_time', percent_completion = '$new_percent_completion' where response_id = '$response_id' and user_id = '$user_id'";

                            }

                            $update_result = $this->db_connector->query($update);
                        }

                        $this->surveyFinished($task_id,$job_id,$response_id);
                    }
                    else{
                        //if this is not the final submission
                        $current_location = $this->getCurrentLocation();

                        $lat = null;
                        $lng = null;

                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){
                            $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', percent_completion = '$new_percent_completion' where response_id = '$response_id'";
                            $update_result = $this->db_connector->query($update);
                        }

                    }

                    $result = $this->getOKStatus();

                }

            }

        }

        return $result;

    }

    public function getJobDetail($response_id) {

        $detail = null;

        $result["status"] = STATUS_OPERATION_FAILED;
        $result["detail"] = $detail;


        $survey_state = SURVEY_STATE_PROGRESS;
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $customer_id = null;
                $address = null;
                $state = null;
                $country = null;
                $location_lat = null;
                $location_lon = null;
                $researcher_required = null;
                $researcher_count = null;
                $survey_url = null;
                $project_title = null;
                $project_description = null;

                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $survey_assigned = $row["survey_count"];
                $survey_completed = $row["survey_completed"];
                $survey_state = $row["survey_state"];
                $survey_start = $row["survey_start"];
                $survey_end = $row["survey_end"];
                $price = $row["price"];
                $payment_date = $row["payment_date"];
                $verified = $row["verified"];


                $job = $this->getJobRaw($job_id);
                $task = $this->getTaskRaw($task_id);

                if($job != null){
                    $customer_id = $job["user_id"];
                    $address = $job["address"];
                    $state = $job["state"];
                    $country = $job["country"];
                    $location_lat = $job["location_lat"];
                    $location_lon = $job["location_lon"];
                    $researcher_required = $job["researcher_required"];
                    $researcher_count = $job["researcher_count"];
                    $zone_radius = $this->getTagRadius($task_id,$job_id);
                }

                if($task != null){
                    $detail["survey_url"] = $task["survey_url"];

                    if (isInsightSurvey($task["survey_url"]) && !empty($row["survey_token"])){

                        $detail["survey_url"] = getUpdatedInsightSurveyLink($task["survey_url"],$row["survey_token"],$this->getLanguageCode());

                    }
                    $detail["project_description"] = $task["task_instructions"];
                    $detail["project_title"] = $task["task_topic"];

                    $quest_activity = $task["task_activity"];
                    $quest_category = ACTIVITY_CATEGORY_DISCOVER;

                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                        $quest_category = ACTIVITY_CATEGORY_DISCOVER;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                        //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                        $quest_category = ACTIVITY_CATEGORY_VOX;

                    }


                    $detail["start_date"] = $task["task_start_date"];
                    $detail["end_date"] = $task["task_due_date"];
                    $detail["activity_type"] = $quest_activity;
                    $detail["activity_category"] = $quest_category;
                    $detail["meter_radius"] = $this->getTagRadius($task_id,$job_id);
                    $detail["tag_effort"] = $this->getTagEffort($task_id);
                    $detail["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius;

                }

                $detail["response_id"] = $response_id;
                $detail["job_id"] = $job_id;
                $detail["task_id"] = $task_id;
                $detail["user_id"] = $customer_id;//customer

                $detail["survey_count"] = $survey_assigned;
                $detail["survey_completed"] = $survey_completed;
                $detail["survey_start"] = $survey_start;
                $detail["survey_end"] = $survey_end;
                $detail["price"] = $this->getConvertedFunds($price);
                $detail["currency"] = $this->getCurrencyCode();
                $detail["payment_date"] = $payment_date;
                $detail["is_approved"] = ($verified == 1);

                $detail["location_address"] = $address;
                $detail["location_country"] = $country;
                $detail["location_state"] = $state;
                $detail["location_lat"] = $location_lat;
                $detail["location_lon"] = $location_lon;
                $detail["researcher_required"] = $researcher_required;
                $detail["researcher_count"] = $researcher_count;

                if($this->get_userId() == "329" && $task_id == 228){
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/435635?lang=en";
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/"; //getUserMedia samples
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/gum/"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture3.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/664954?lang=en"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/114771?lang=en"; // Quest 2
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/981233?lang=en"; // Quest 3
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/187196?lang=en"; // Quest unknown
                    /*$detail["survey_url"] = "https://dev.queritel.com/sample.html?ver=1.0.0"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/745439?lang=en"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture2.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://source.queritel.com/cam"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/record/"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://w3c-test.org/html-media-capture/capture_image_environment-manual.html"; //media capture

                    if (isInsightSurvey($detail["survey_url"]) && !empty($row["survey_token"])){

                        $detail["survey_url"] = getUpdatedInsightSurveyLink($detail["survey_url"],$row["survey_token"]);

                    }*/

                    $detail["meter_radius"] = 10000;
                }


                $result["status"] = STATUS_OK;
                $result["detail"] = $detail;

            }

        }

        return $result;
    }

    //this is used to get the user's primary bank account data
    public function getPrimaryBankAccount($user_id = null) {


        $result = array();
        $result["is_valid"] = false;
        $result["account_id"] = null;
        $result["account_type"] = null;
        $result["version_code"] = null;
        $result["fname"] = null;
        $result["mname"] = null;
        $result["lname"] = null;
        $result["full_name"] = null;
        $result["email"] = null;
        $result["date_of_birth"] = null;
        $result["phone_number"] = null;
        $result["country_code"] = null;
        $result["location_state"] = null;
        $result["location_city"] = null;
        $result["location_address"] = null;
        $result["bank_name"] = null;
        $result["bank_address"] = null;
        $result["bank_account_number"] = null;
        $result["bank_account_type"] = null;
        $result["tax_id_number"] = null;


        if ($user_id == null){
            $user_id = $this->userId;
        }

        $account_type = ACCOUNT_TYPE_BANK_ACCOUNT;
        $deleted = 0;

        $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_type = '$account_type' and deleted = '$deleted' and user_id = '$user_id'";
        $account_result = $this->db_connector->query($account_query);

        if($account_result != null && $account_result->is_row_found()){

            if($row = $account_result->fetch_array()){

                $result["is_valid"] = true;
                $result["account_id"] = $row["account_id"];
                $result["account_type"] = $row["account_type"];
                $result["version_code"] = $row["version_code"];
                $result["fname"] = stringCase($row["fname"],STRING_CASE_CAP_FIRST);
                $result["mname"] = stringCase($row["mname"]);
                $result["lname"] = stringCase($row["lname"],STRING_CASE_CAP_FIRST);
                $result["full_name"] = $row["full_name"];
                $result["email"] = stringCase($row["email"]);
                $result["date_of_birth"] = $row["date_of_birth"];
                $result["phone_number"] = $row["phone_number"];
                $result["country_code"] = stringCase($row["country_code"],STRING_CASE_UPPER);
                $result["location_state"] = stringCase($row["location_state"],STRING_CASE_CAP_EACH);
                $result["location_city"] = stringCase($row["location_city"],STRING_CASE_CAP_EACH);
                $result["location_address"] = $row["location_address"];
                $result["bank_name"] = $row["bank_name"];
                $result["bank_address"] = $row["bank_address"];
                $result["bank_account_number"] = $row["bank_account_number"];
                $result["bank_account_type"] = $row["bank_account_type"];
                $result["tax_id_number"] = $row["tax_id_number"];

            }

        }

        return $result;
    }

    //todo fix cash-out flag
    public function getWalletData($user_id = null) {

        if ($user_id == null){
            $user_id = $this->userId;
        }

        /*{
           "usd_pending_amount": 0,
           "usd_available_amount": 0,
           "pending_amount": 0,
           "available_amount": 0,
           "currency": "USD",
           "payout_method": false, //if true, that means the user has declared payout options
           "cash_out": false //if true, the cash out button must be enabled
        }*/

        $wallet_data = null;
        $cash_out = false;
        $payout_method = false;

        $current_currency = $this->getCurrencyCode(); //current operating currency
        $total_pending = 0;
        $total_available = 0;

        $total_pending_usd = 0;
        $total_available_usd = 0;


        $payment_query = "select * from " . TABLE_AGENT_PAYMENT . " where user_id = '$user_id' and local_currency = '$current_currency' and handled_externally = 0 and paid = 0";
        $payment_result = $this->db_connector->query($payment_query);

        if($payment_result != null && $payment_result->is_row_found()){
            while($row = $payment_result->fetch_array()){
                $local_currency_rate = $row["local_currency_rate"];
                $amount = ($row["amount"] == null) ? 0 : $row["amount"];
                $amount_paid = ($row["amount_paid"] == null) ? 0 : $row["amount_paid"];
                $amount_remaining = $amount - $amount_paid;
                $approved = $row["approved"] == 1;

                $local_converted_amount = floatval($amount_remaining * $local_currency_rate);

                if ($approved){
                    $total_available_usd += $amount_remaining;
                    $total_available += $local_converted_amount;
                }
                else{
                    $total_pending_usd = $amount_remaining;
                    $total_pending += $local_converted_amount;
                }

            }

            //todo update cashout check
            if (round($total_available_usd,3) >= 1 ){
                $cash_out = true;
            }

            $wallet_data = array();
            $wallet_data["usd_pending_amount"] = floatval($total_pending_usd);
            $wallet_data["usd_available_amount"] = floatval($total_available_usd);
            $wallet_data["pending_amount"] = floatval($total_pending);
            $wallet_data["available_amount"] = floatval($total_available);
            $wallet_data["currency"] = $current_currency;
            $wallet_data["payout_method"] = $payout_method;
            $wallet_data["cash_out"] = $cash_out;
        }


        return $wallet_data;
    }

    //this is called when a questionnaire submission of a quest is finished
    //todo deprecated
    private function logSubmissions($task_id,$job_id,$response_id){
        $current_location = $this->getCurrentLocation();

        $lat = null;
        $lng = null;

        if (!$current_location->isEmpty()){
            $lat = $current_location->getLatitude();
            $lng = $current_location->getLongitude();
        }

        $submission_id = generate_token();
        $update_time = getCurrentTime();
        $user_id = $this->get_userId();

        $log_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,completion_time,completion_lat,completion_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$update_time','$lat','$lng')";
        $log_result = $this->db_connector->query($log_submission_query);

        if($log_result != null && $log_result->is_row_affected()){
            //success

            //$update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
            //$update_result = $this->db_connector->query($update_job);

            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;


                //broadcast update to researcher and admin

            }*/

        }
    }

    //this is called when all submissions of a survey is finished
    private function surveyFinished($task_id,$sector_id,$response_id){

        $user_id = $this->userId;
        $completed_survey_state = SURVEY_STATE_COMPLETED;


        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and job_id = '$sector_id' and task_id = '$task_id' and survey_state = '$completed_survey_state' and user_id = '$user_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            if($row = $response_result->fetch_array()){

                $assigned = $row["survey_count"];
                $completed = $row["survey_completed"];
                $percent_completion = $row["percent_completion"];
                $local_currency = $row["local_currency"];
                $local_currency_rate = $row["local_currency_rate"];
                $price = $row["price"];
                $currency = $row["currency"];

                $update_time = getCurrentTime();
                $payment_id = generate_unique_id(UNIQUE_PAYMENT);

                $handled_externally = 0; //handled by queritel

                $task_data = $this->getTaskRaw($task_id);
                if ($task_data != null){
                    $handled_externally = $task_data["handle_payment"];
                }

                //update_time, payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate
                //$update_time,$payment_id, $task_id, $sector_id, $response_id, $user_id, $price, $currency, $handled_externally, $local_currency, $local_currency_rate

                $insert_payment_query = "insert into " . TABLE_AGENT_PAYMENT . " (update_time,payment_id, task_id, sector_id, response_id, user_id, amount, currency, handled_externally, local_currency, local_currency_rate) values ('$update_time','$payment_id','$task_id','$sector_id','$response_id','$user_id','$price','$currency','$handled_externally','$local_currency','$local_currency_rate')";
                $insert_payment_result = $this->db_connector->query($insert_payment_query);
                if($insert_payment_result != null && $insert_payment_result->is_row_affected()){

                    $update = "update " . TABLE_RESPONSE . " set payment_id = '$payment_id', payment_date = '$update_time' where response_id = '$response_id' and user_id = '$user_id'";
                    $update_result = $this->db_connector->query($update);
                    if($update_result != null && $update_result->is_row_affected()){}

                }

            }
        }

    }

    //this is called to update the users realtime presence
    private function logPresence(){}

    //this is called to log the user's activity
    private function logActivity(){}

    //returns the jobs from the given id that this researcher qualifies for
    //NOTE: this will be null is =>
    //1 - if user is already attached to one of these jobs
    //2 - if these jobs dont require more researchers
    //3 - if there are no jobs


    function getJobTags($job_id){
        $record_found = false;
        $index = 0;

        $data = array();
        $result = array();


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            while ($row = $tag_result->fetch_array()){
                $record_found = true;

                $tag_id = $row["tag_id"];
                $tag_label = $row["tag_label"];
                $tag_data = $row["tag_data"];

                $decoded = json_decode($tag_data,true);

                $data[$index]["unique_id"] = $tag_id;
                $data[$index]["tag_label"] = $tag_label;
                $data[$index]["tag_data"] = $decoded;

                $index++;
            }

        }

        if ($record_found){
            $result = $data;
        }

        return $result;
    }
    private function getTagRadius($task_id,$job_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        //$result = array();

        //$result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_radius' and job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["value"];

            }

        }

        return $effort;
    }
    private function getTagEffort($task_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        $result = array();

        $result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_effort'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["level"];

            }

        }

        return $effort;
    }
    private function ___returnAvailableJobs___($task_id) {
        //this gets all the jobs tied to this task

        $result = null;
        if($this->db_connector != null){
            //available = survey ready, admin approved, not finished, not cancelled
            $sql = "select * from " . TABLE_TASKS . " where task_id = '$task_id' and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ")";
            $task_result = $this->db_connector->query($sql);

            if($task_result == null){
                return $result;
            }

            $task_data = $task_result->fetch_array();

            if($task_data != null && $task_data["task_location_count"] > 0){

                $check_criteria = false;//should we check if this researcher is linked to the task

                if($check_criteria){
                    //do not consider cancelled as a linked job
                    $linkedJobs = $this->linkedJobs($task_id,false);

                    if($linkedJobs == null){
                        $check_linked = true;
                    }
                    else{
                        $check_linked = false;
                    }

                }
                else{
                    $check_linked = true;//bypass check
                }


                //T O D O - RE-ENABLE IP LOCATION CRITERIA SELECTION
                if($check_linked){//if this researcher is not already linked to this task then process to see if it is available
                    $country_code = $this->host_info->getCountry_code();
                    //$country_code = "JM";
                    //task is available to be check by the researcher
                    $job_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id' and country_code = '$country_code' and researcher_required > researcher_count and survey_total > 0";
                    $job_result = $this->db_connector->query($job_query);
                    $index = 0;

                    if($job_result == null){
                        return $result;
                    }

                    while($row = $job_result->fetch_array()){
                        /**
                         * // TODO :=> DO ADDITIONAL CRITERIA CHECK HERE
                         */

                        $result[$index]["job_id"] = $row["job_id"];
                        $result[$index]["task_id"] = $task_id;
                        $result[$index]["user_id"] = $row["user_id"];
                        $result[$index]["location_address"] = $row["address"];
                        $result[$index]["location_country"] = $row["country"];
                        $result[$index]["location_state"] = $row["state"];
                        $result[$index]["location_lat"] = $row["location_lat"];
                        $result[$index]["location_lon"] = $row["location_lon"];
                        $result[$index]["researcher_required"] = $row["researcher_required"];
                        $result[$index]["researcher_count"] = $row["researcher_count"];
                        $result[$index]["survey_url"] = $task_data["survey_url"];
                        $result[$index]["project_description"] = $task_data["task_instructions"];
                        $result[$index]["project_title"] = $task_data["task_topic"];
                        $result[$index]["customer"] = "";//$task_data["task_topic"];//lets ignor this for now

                        $cpq = $row["cpq"];//cost per questionnaire
                        $questionnaire_total = $row["survey_total"];
                        $questionnaire_assigned = $row["survey_assigned"];
                        $assignable = 0;//the number of questionnaires the reseacher viewing these results, could be assigned

                        $remaining = $questionnaire_total - $questionnaire_assigned;

                        //TODO fix here
                        //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                        $question_set = $questionnaire_total / $row["researcher_required"];

                        if($remaining > $question_set){
                            $assignable = $question_set;//lets cap it at the default
                        }
                        elseif($remaining <= $question_set){
                            $assignable = $remaining;//lets show the 'whats left'
                        }

                        $price = $assignable * $cpq;

                        $result[$index]["price"] = $price;
                        $result[$index]["questionnaire_count"] = $assignable;

                        $index++;
                    }


                }

            }

        }

        return $result;
    }



    //todo : reset from ghana - [GH]
    private function returnAvailableJobs($task_id,$task_data) {
        //this gets all the jobs tied to this task

        $result = null;
        if($this->db_connector != null){
            //available = survey ready, admin approved, not finished, not cancelled

            $check_connection = false; //should we check if the researcher is already connected to this quest and prevent further connections
            $has_connection = false; //is the researcher connected to this quest
            $preliminary_check_passed = false; //preliminary criteria check passed


            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;

                $check_connection = true; //if this is a vox, then ensure that the researcher has only 1 connection
            }


            if (($task_id == 375) ){
                $check_connection = true;
            }

            //todo - add $this->passedPreliminaryCheck($task_data)
            if($check_connection){
                //do not consider a cancelled quest as a connected quest
                $linkedJobs = $this->linkedJobs($task_id,false);

                if($linkedJobs == null){
                    $has_connection = false; //does not already have a connection to this quest, so check for available quest
                    $preliminary_check_passed = true;
                }
                else{
                    $has_connection = true; //already has a connection, so prevent check for available quest
                    $preliminary_check_passed = false;
                }

            }
            else{
                $preliminary_check_passed = true;
            }


            //todo - add $this->isValidTarget($target_id, $task_data)
            if($preliminary_check_passed){//if this researcher is not already linked to this task then process to see if it is available
                $signup_country_code = $this->getLocationCountryCode();
                $country_code = $this->host_info->getCountry_code();

                //$country_code = "JM";

                $country_code_check = "country_code = '$country_code'";

                if ($country_code !== $signup_country_code){
                    if (!empty($country_code) && !empty($signup_country_code)){
                        $country_code_check = "country_code in ('$country_code','$signup_country_code')";
                    }
                    else{
                        if (!empty($signup_country_code)){
                            $country_code_check = "country_code = '$signup_country_code'";
                        }
                        elseif (!empty($country_code)){
                            $country_code_check = "country_code = '$country_code'";
                        }
                    }
                }

                if($this->get_userId() == "329"){
                    //$country_code = "JM";
                    //$this->currencyCode = "JMD";
                    //$country_code = "PR";
                    //$this->currencyCode = "JMD";
                }

                $job_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id' and $country_code_check and researcher_required > researcher_count and survey_total > 0";
                $job_result = $this->db_connector->query($job_query);
                $index = 0;

                if($job_result == null){
                    return $result;
                }

                while($row = $job_result->fetch_array()){

                    //start_date
                    //activity_type
                    //activity_category
                    //meter_radius

                    $zone_radius = $this->getTagRadius($task_id,$row["job_id"]);

                    /**
                     * TODO :=> DO ADDITIONAL CRITERIA CHECK HERE : for each zone
                     */
                    if ($quest_category == ACTIVITY_CATEGORY_VOX){
                        //location guard check

                        if (!$this->currentLocation->isEmpty()){
                            //has a current location then check if researcher is in the zone

                            $zone_lat = $row["location_lat"];
                            $zone_lng = $row["location_lon"];

                            $zone_location = new LocationPoint($zone_lat,$zone_lng);
                            $distance_between = getDistanceBetweenGeneral($this->currentLocation,$zone_location);

                            if($distance_between > $zone_radius){
                                continue; //skip this vox zone
                            }

                        }
                        else{
                            //has no current location

                            //todo : targeting check
                            //continue; //skip this vox zone
                        }

                    }
                    else{//todo -- remove this (zones will not be blocked)
                        /*if (!$this->currentLocation->isEmpty()){
                            //has a current location then check if researcher is in the zone

                            $zone_lat = $row["location_lat"];
                            $zone_lng = $row["location_lon"];

                            $zone_location = new LocationPoint($zone_lat,$zone_lng);
                            $distance_between = getDistanceBetweenGeneral($this->currentLocation,$zone_location);

                            if($distance_between > LOCATION_GREEN_ZONE){
                                continue; //skip this red zone
                            }

                        }
                        else{
                            //has no current location

                            continue; //skip this no zone
                        }*/
                    }


                    $result[$index]["task_id"] = $task_id;
                    $result[$index]["survey_url"] = $task_data["survey_url"];
                    $result[$index]["project_description"] = $task_data["task_instructions"];
                    $result[$index]["project_title"] = $task_data["task_topic"];

                    $result[$index]["job_id"] = $row["job_id"];
                    $result[$index]["user_id"] = $row["user_id"];
                    $result[$index]["profile_lock"] = false; //!$this->isProfileSurveyCompleted()
                    $result[$index]["location_address"] = $row["address"];
                    $result[$index]["location_country"] = $row["country"];
                    $result[$index]["location_state"] = $row["state"];
                    $result[$index]["location_lat"] = $row["location_lat"];
                    $result[$index]["location_lon"] = $row["location_lon"];
                    $result[$index]["researcher_required"] = $row["researcher_required"];
                    $result[$index]["researcher_count"] = $row["researcher_count"];
                    $result[$index]["customer"] = "";//$task_data["task_topic"];//lets ignor this for now

                    $result[$index]["start_date"] = $task_data["task_start_date"];
                    $result[$index]["end_date"] = $task_data["task_due_date"];
                    $result[$index]["activity_type"] = $quest_activity;
                    $result[$index]["activity_category"] = $quest_category;
                    $result[$index]["meter_radius"] = $zone_radius;
                    $result[$index]["tag_effort"] = $this->getTagEffort($task_id);
                    $result[$index]["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius; //a lock is placed on all quest out of this range

                    $cpq = $row["cpq"];//cost per questionnaire
                    $questionnaire_total = $row["survey_total"];
                    $questionnaire_assigned = $row["survey_assigned"];
                    $assignable = 0;//the number of questionnaires the researcher viewing these results, could be assigned

                    $remaining = $questionnaire_total - $questionnaire_assigned;

                    //TODO fix here
                    //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                    $question_set = $questionnaire_total / $row["researcher_required"];

                    if($remaining > $question_set){
                        $assignable = $question_set;//lets cap it at the default
                    }
                    elseif($remaining <= $question_set){
                        $assignable = $remaining;//lets show the 'whats left'
                    }

                    $price = $assignable * $cpq;

                    $result[$index]["price"] = $this->getConvertedFunds($price);
                    $result[$index]["currency"] = $this->getCurrencyCode();
                    $result[$index]["survey_count"] = $assignable;

                    $index++;
                }


            }

        }

        return $result;
    }
    private function returnActiveJobs($task_id,$task_data) {
        //this gets all the active jobs tied to this task

        $results = null;
        if($this->db_connector != null){
            //active = survey ready, admin approved, not finished, not cancelled

            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;
            }



            $linkedJobs = $this->linkedJobs($task_id);
            if($linkedJobs != null){//if this researcher is already linked to this task then get the jobs that apply
                $index = 0;

                foreach($linkedJobs as $response){
                    $zone_radius = $this->getTagRadius($task_id,$response["job_id"]);

                    //iterate through all the linked job responses(because that is returned by the linked function)
                    $survey_state = $response["survey_state"];
                    if($survey_state == SURVEY_STATE_PROGRESS){
                        //if this job is active; set up variables for the response

                        $results[$index]["response_id"] = $response["response_id"];
                        //$results[$index]["update_time"] = $response["update_time"];
                        $results[$index]["job_id"] = $response["job_id"];
                        $results[$index]["task_id"] = $response["task_id"];
                        $results[$index]["user_id"] = $task_data["user_id"];//customer

                        $results[$index]["survey_url"] = $task_data["survey_url"];
                        if (isInsightSurvey($task_data["survey_url"]) && !empty($response["survey_token"])){

                            $results[$index]["survey_url"] = getUpdatedInsightSurveyLink($task_data["survey_url"],$response["survey_token"],$this->getLanguageCode());

                        }

                        //$results[$index]["survey_url"] = getUpdatedInsightSurveyLink("https://insight.queritel.com/index.php/243676?lang=en","Ckz3dafzmrNXjkx");


                        $results[$index]["project_description"] = $task_data["task_instructions"];
                        $results[$index]["project_title"] = $task_data["task_topic"];


                        $results[$index]["start_date"] = $task_data["task_start_date"];
                        $results[$index]["end_date"] = $task_data["task_due_date"];
                        $results[$index]["activity_type"] = $quest_activity;
                        $results[$index]["activity_category"] = $quest_category;
                        $results[$index]["meter_radius"] = $zone_radius;
                        $results[$index]["tag_effort"] = $this->getTagEffort($task_id);
                        $results[$index]["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius; //a lock is placed on all quest out of this range


                        $results[$index]["survey_count"] = $response["survey_count"];
                        $results[$index]["survey_completed"] = $response["survey_completed"];
                        $results[$index]["survey_start"] = $response["survey_start"];
                        $results[$index]["survey_end"] = $response["survey_end"];
                        $results[$index]["price"] = $this->getConvertedFunds($response["price"]);
                        $results[$index]["currency"] = $this->getCurrencyCode();
                        $results[$index]["payment_date"] = $response["payment_date"];

                        //lets get the job instance this is associated with
                        $job = $this->getJobRaw($response["job_id"]);
                        if($job != null){
                            //lets set all the job details that can not be obtaind from the response table

                            $results[$index]["location_address"] = $job["address"];
                            $results[$index]["location_country"] = $job["country"];
                            $results[$index]["location_state"] = $job["state"];
                            $results[$index]["location_lat"] = $job["location_lat"];
                            $results[$index]["location_lon"] = $job["location_lon"];
                            $results[$index]["researcher_required"] = $job["researcher_required"];
                            $results[$index]["researcher_count"] = $job["researcher_count"];
                        }


                        if($this->get_userId() == "329" && $response["task_id"] == 228){
                            //$results[$index]["survey_url"] = "https://www.surveymonkey.com/r/V3XWFVL"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/sample.html?ver=1.0.0"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/482584?lang=es"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/425385?lang=en"; //new image sample
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/816821?lang=en"; //new image sample (automated)
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/922537?lang=en"; //location + profile data

                            /*$survey_url = "https://insight.queritel.com/index.php/885886?lang=en";
                            /*$survey_url = "https://insight.queritel.com/index.php/759147?lang=en"; //fruit survey (no token)
                            $survey_url = "https://insight.queritel.com/index.php/885886";
                            if (isInsightSurvey($survey_url) && !empty($response["survey_token"])){

                                $results[$index]["survey_url"] = getUpdatedInsightSurveyLink($survey_url,$response["survey_token"]);

                            }
                            else{
                                $results[$index]["survey_url"] = $survey_url; //location + profile data 2

                            }*/

                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/435635?lang=en";
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/"; //getUserMedia samples
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/gum/"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture3.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/664954?lang=en"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/114771?lang=en"; // Quest 2
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/981233?lang=en"; // Quest 3
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/187196?lang=en"; // Quest unknown

                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/745439?lang=en"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture2.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://source.queritel.com/cam"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/record/"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://w3c-test.org/html-media-capture/capture_image_environment-manual.html"; //media capture
                            $results[$index]["meter_radius"] = 10000;
                        }


                        $index++;

                    }

                }

            }

        }

        return $results;
    }
    private function returnCompletedJobs($task_id,$task_data) {
        //this gets all the jobs tied to this task

        $results = null;
        if($this->db_connector != null){

            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;
            }

            $linkedJobs = $this->linkedJobs($task_id);
            if($linkedJobs != null){//if this researcher is already linked to this task then get the jobs that apply
                $index = 0;

                foreach($linkedJobs as $response){
                    //iterate through all the linked job responses(because that is returned by the linked function)
                    $survey_state = $response["survey_state"];
                    if($survey_state == SURVEY_STATE_COMPLETED){
                        //if this job is active; set up variables for the response

                        $results[$index]["response_id"] = $response["response_id"];
                        //$results[$index]["update_time"] = $response["update_time"];
                        $results[$index]["job_id"] = $response["job_id"];
                        $results[$index]["task_id"] = $response["task_id"];
                        $results[$index]["user_id"] = $task_data["user_id"];//customer
                        $results[$index]["survey_url"] = $task_data["survey_url"];

                        $results[$index]["project_description"] = $task_data["task_instructions"];
                        $results[$index]["project_title"] = $task_data["task_topic"];

                        $results[$index]["start_date"] = $task_data["task_start_date"];
                        $results[$index]["end_date"] = $task_data["task_due_date"];
                        $results[$index]["activity_type"] = $quest_activity;
                        $results[$index]["activity_category"] = $quest_category;
                        $results[$index]["meter_radius"] = $this->getTagRadius($task_id,$response["job_id"]);
                        $results[$index]["tag_effort"] = $this->getTagEffort($task_id);


                        $results[$index]["survey_count"] = $response["survey_count"];
                        $results[$index]["survey_completed"] = $response["survey_completed"];
                        $results[$index]["survey_start"] = $response["survey_start"];
                        $results[$index]["survey_end"] = $response["survey_end"];
                        $results[$index]["price"] = $this->getConvertedFunds($response["price"]);
                        $results[$index]["currency"] = $this->getCurrencyCode();
                        $results[$index]["payment_date"] = $response["payment_date"];
                        $results[$index]["is_approved"] = ($response["verified"] == 1);
                        //response_status : pending, approved, rejected

                        //lets get the job instance this is associated with
                        $job = $this->getJobRaw($response["job_id"]);
                        if($job != null){
                            //lets set all the job details that can not be obtaind from the response table
                            $results[$index]["location_address"] = $job["address"];
                            $results[$index]["location_country"] = $job["country"];
                            $results[$index]["location_state"] = $job["state"];
                            $results[$index]["location_lat"] = $job["location_lat"];
                            $results[$index]["location_lon"] = $job["location_lon"];
                            $results[$index]["researcher_required"] = $job["researcher_required"];
                            $results[$index]["researcher_count"] = $job["researcher_count"];
                        }

                        $index++;

                    }

                }

            }

        }

        return $results;
    }

    public function getErrorStatus($error_msg){
        $result = array();
        $error = array();
        $error["name"] = ERROR_NAME_OP_FAILED;
        $error["message"] = $error_msg;
        $result["status"] = STATUS_ERROR;
        $result["error"] = $error;

        return $result;
    }
    public function getOKStatus(){
        $result = array();
        $result["status"] = STATUS_OK;

        return $result;
    }

    public function getPayoutAccountDataRaw($account_id){
        $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_id = '$account_id'";
        $account_result = $this->db_connector->query($account_query);

        if($account_result != null && $account_result->is_row_found()){
            $row = $account_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }

    //gets a list of jobs(of task_id) the researcher is linked to whether completed of otherwise
    //linked = matched task & user id for survey_response
    //returns Array if linked or null if not
    public function linkedJobs($task_id, $include_cancelled = true){

        if($include_cancelled){
            //check all records {cancelled,in progress,completed}
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";

        }
        else{
            //if this is falsed == then do not consider 'SURVEY_STATE_CANCELLED' as linked
            //return all records that arent cancelled
            //if records that arent cancelled are found.. then this researcher is linked
            //check records {finished,completed}
            $survey_state = SURVEY_STATE_CANCELLED;
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId' and survey_state not in ($survey_state)";

        }

        //$response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";
        $response_result = $this->db_connector->query($response_query);
        $index = 0;
        $results = null;

        if($response_result != null && $response_result->is_row_found()){
            while($row = $response_result->fetch_array()){
                $results[$index]["response_id"] = $row["response_id"];
                //$results[$index]["update_time"] = $row["update_time"];
                $results[$index]["job_id"] = $row["job_id"];
                $results[$index]["task_id"] = $row["task_id"];
                $results[$index]["user_id"] = $row["user_id"];//researcher
                $results[$index]["survey_id"] = $row["survey_id"];
                $results[$index]["survey_token"] = $row["survey_token"];
                $results[$index]["survey_count"] = $row["survey_count"];
                $results[$index]["survey_completed"] = $row["survey_completed"];
                $results[$index]["survey_state"] = $row["survey_state"];
                $results[$index]["survey_start"] = $row["survey_start"];
                $results[$index]["survey_end"] = $row["survey_end"];
                $results[$index]["price"] = $row["price"];
                $results[$index]["payment_date"] = $row["payment_date"];
                $results[$index]["verified"] = $row["verified"];

                $index++;
            }

        }

        return $results;
    }
    //get jobs based on where clause; return database result
    public function getJobsWhere($where_clause){
        $result = null;
        $job_query = "select * from " . TABLE_JOBS . " where $where_clause";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){

            return $job_result;

        }

        return null;
    }
    //returns row
    public function getTaskRaw($task_id){
        $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
        $task_result = $this->db_connector->query($task_query);

        if($task_result != null && $task_result->is_row_found()){
            $row = $task_result->fetch_array();

            if($row != null){
                return $row;
            }
        }

        return null;
    }
    public function getResponseRaw($response_id){
        $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$response_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            $row = $response_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }
    public function getJobRaw($job_id){
        $job_query = "select * from " . TABLE_JOBS . " where job_id = '$job_id'";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){
            $row = $job_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }

}


/**
 * @purpose : for processing the country table of the paperweight database
 **/
class Country {

    public static function getCountry($countryId, Database $db_handle) {
        if($db_handle == null){

            return null;
        }


        $sql = "select (country_name) from " . TABLE_COUNTRY . " where country_id = '$countryId'";
        if($db_handle != null){
            $result = $db_handle->query($sql);
            if($result != null){
                while($row = $result->fetch_array()){
                    return Country::parseCountry($row["country_name"]);
                    //return $row["country_name"];
                }

            }
        }

        return null;
    }

    /**
     * @purpose : strips the string of all non alphabet
     *       */
    public static function parseCountry($string){
        $array = explode(" ", $string);
        $text_only = preg_grep('/[[:alpha:]]/', $array);
        $new_text = strtolower(join(" ", $text_only));

        return $new_text;
    }

    /**
     * @purpose : check if either string is in the other
     *       */
    public static function isContainedIn($str, $str_array,$case_sensitive = false){

        if($case_sensitive == false){
            $needle = strtolower($str);
            $haystack = strtolower($str_array);
        }
        else{
            $needle = $str;
            $haystack = $str_array;
        }

        $found = preg_match("/$needle/", $haystack);
        if($found){

            return true;
        }
        else{
            //check the other way round
            $found2 = preg_match("/$haystack/",$needle );

            if($found2){
                return true;
            }
            else{
                return false;
            }

        }

        return false;

    }

}

/**
 * Author : Kadian Salmon
 * Date : Sep 17, 2019
 * Purpose : Job is responsible for holding a job instance
 */
class Job {
    private $job_id;
    private $update_time;
    private $task_id;
    private $user_id;
    private $address;
    private $state;
    private $country;
    private $country_code;
    private $customer;
    private $lat;
    private $lng;
    private $researcher_required;
    private $researcher_count;
    private $survey_id;
    private $survey_total;
    private $survey_assigned;
    private $price;


    function __construct() {

    }

    public function getJob_id() {
        return $this->job_id;
    }

    public function getUpdate_time() {
        return $this->update_time;
    }

    public function getTask_id() {
        return $this->task_id;
    }

    public function getUser_id() {
        return $this->user_id;
    }

    public function getAddress() {
        return $this->address;
    }

    public function getState() {
        return $this->state;
    }

    public function getCountry() {
        return $this->country;
    }

    public function getCountry_code() {
        return $this->country_code;
    }

    public function getCustomer() {
        return $this->customer;
    }

    public function getLat() {
        return $this->lat;
    }

    public function getLng() {
        return $this->lng;
    }

    public function getResearcher_required() {
        return $this->researcher_required;
    }

    public function getResearcher_count() {
        return $this->researcher_count;
    }

    public function getSurvey_id() {
        return $this->survey_id;
    }

    public function getSurvey_total() {
        return $this->survey_total;
    }

    public function getSurvey_assigned() {
        return $this->survey_assigned;
    }

    public function getPrice() {
        return $this->price;
    }

    public function setJob_id($job_id) {
        $this->job_id = $job_id;
        return $this;
    }

    public function setUpdate_time($update_time) {
        $this->update_time = $update_time;
        return $this;
    }

    public function setTask_id($task_id) {
        $this->task_id = $task_id;
        return $this;
    }

    public function setUser_id($user_id) {
        $this->user_id = $user_id;
        return $this;
    }

    public function setAddress($address) {
        $this->address = $address;
        return $this;
    }

    public function setState($state) {
        $this->state = $state;
        return $this;
    }

    public function setCountry($country) {
        $this->country = $country;
        return $this;
    }

    public function setCountry_code($country_code) {
        $this->country_code = $country_code;
        return $this;
    }

    public function setCustomer($customer) {
        $this->customer = $customer;
        return $this;
    }

    public function setLat($lat) {
        $this->lat = $lat;
        return $this;
    }

    public function setLng($lng) {
        $this->lng = $lng;
        return $this;
    }

    public function setResearcher_required($researcher_required) {
        $this->researcher_required = $researcher_required;
        return $this;
    }

    public function setResearcher_count($researcher_count) {
        $this->researcher_count = $researcher_count;
        return $this;
    }

    public function setSurvey_id($survey_id) {
        $this->survey_id = $survey_id;
        return $this;
    }

    public function setSurvey_total($survey_total) {
        $this->survey_total = $survey_total;
        return $this;
    }

    public function setSurvey_assigned($survey_assigned) {
        $this->survey_assigned = $survey_assigned;
        return $this;
    }

    public function setPrice($price) {
        $this->price = $price;
        return $this;
    }



}
class JobResponse {
    private $response_id;
    private $update_time;
    private $job_id;
    private $task_id;
    private $user_id;
    private $survey_id;
    private $survey_count;
    private $survey_completed;
    private $survey_state;
    private $survey_start;
    private $survey_end;
    private $price;
    private $payment_date;



    function __construct() {

    }

    public function getResponse_id() {
        return $this->response_id;
    }

    public function getUpdate_time() {
        return $this->update_time;
    }

    public function getJob_id() {
        return $this->job_id;
    }

    public function getTask_id() {
        return $this->task_id;
    }

    public function getUser_id() {
        return $this->user_id;
    }

    public function getSurvey_id() {
        return $this->survey_id;
    }

    public function getSurvey_count() {
        return $this->survey_count;
    }

    public function getSurvey_completed() {
        return $this->survey_completed;
    }

    public function getSurvey_state() {
        return $this->survey_state;
    }

    public function getSurvey_start() {
        return $this->survey_start;
    }

    public function getSurvey_end() {
        return $this->survey_end;
    }

    public function getPrice() {
        return $this->price;
    }

    public function getPayment_date() {
        return $this->payment_date;
    }

    public function setResponse_id($response_id) {
        $this->response_id = $response_id;
        return $this;
    }

    public function setUpdate_time($update_time) {
        $this->update_time = $update_time;
        return $this;
    }

    public function setJob_id($job_id) {
        $this->job_id = $job_id;
        return $this;
    }

    public function setTask_id($task_id) {
        $this->task_id = $task_id;
        return $this;
    }

    public function setUser_id($user_id) {
        $this->user_id = $user_id;
        return $this;
    }

    public function setSurvey_id($survey_id) {
        $this->survey_id = $survey_id;
        return $this;
    }

    public function setSurvey_count($survey_count) {
        $this->survey_count = $survey_count;
        return $this;
    }

    public function setSurvey_completed($survey_completed) {
        $this->survey_completed = $survey_completed;
        return $this;
    }

    public function setSurvey_state($survey_state) {
        $this->survey_state = $survey_state;
        return $this;
    }

    public function setSurvey_start($survey_start) {
        $this->survey_start = $survey_start;
        return $this;
    }

    public function setSurvey_end($survey_end) {
        $this->survey_end = $survey_end;
        return $this;
    }

    public function setPrice($price) {
        $this->price = $price;
        return $this;
    }

    public function setPayment_date($payment_date) {
        $this->payment_date = $payment_date;
        return $this;
    }



}

