<?php
header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');
/**
 * @Author : Kadian Salmon
 * Date : Sep 16, 2019
 * Purpose : process all api request for mobile application
 * @link : https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?agent=android
 * @link : https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?agent=ios
 *
 */

//------------------------------------------
define("QUESTION_SET", 10);//respondents per location
define("RESEARCHER_PER_LOC", 4);//researcher per location

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("PASSWORD_SALT","ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK","OK");
define("STATUS_ERROR","ERROR");
/*{
    "status": "ERROR",
    "error": {
        "name": "opFailed", //([ERROR NAME CONSTANTS])
        "message": "INV_TKN" | "USR_SPND" | "UNK_ERR" //([ERROR MESSAGE CONSTANTS])
    }
}*/

define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED","LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");


//ERROR NAME CONSTANTS
define("ERROR_NAME_OP_FAILED","opFailed");

//ERROR MESSAGE CONSTANTS
define("ERROR_MSG_INVALID_CRED","INV_CR"); //("The Credentials provided are invalid")
define("ERROR_MSG_INVALID_LOGIN","INV_LGN");//("The user is not Logged in")
define("ERROR_MSG_INVALID_TOKEN","INV_TKN");//("The Login token is invalid") {re-entering the password is needed}
define("ERROR_MSG_USER_SUSPENDED","USR_SPND");//("The account has been suspended")
define("ERROR_MSG_USER_DEACTIVATED","USR_DEAC");//("The account has been deactivated")
define("ERROR_MSG_USER_UNKNOWN","UNK_ERR");//("An unknown error was encountered")
define("ERROR_MSG_USER_ACC_DUPLICATE","ACC_DUPLICATE");//("The user already exist")
define("ERROR_MSG_INVALID_TAX_ID","INV_TAX_ID");//("The tax id provided when setting up the bank account was invalid")




//unique prefix (used to generate unique IDs)
define("UNIQUE_NETWORK","net-"); //un
define("UNIQUE_TEAM","team-"); //un
define("UNIQUE_NOTIFICATION","note-"); //unique notification id (one way msg)
define("UNIQUE_MSG","msg-"); //un
define("UNIQUE_PAYMENT","pay-");
define("UNIQUE_TRANSACTION","trans-");
define("UNIQUE_ACCOUNT","acc-");
define("UNIQUE_ACTIVITY","aty-");
define("UNIQUE_PENALTY","pty-");
define("UNIQUE_RELATIONSHIP","rel-");
define("UNIQUE_FILE","file-");
define("UNIQUE_INVITATION","ivn-");
//define("UNIQUE_SUBMISSION","sub-");

//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED",2);
define("SURVEY_STATE_CANCELLED",3);

//survey instrument state
define("SURVEY_INSTRUMENT_READY", 1);
define("SURVEY_INSTRUMENT_NOT_READY", 0);



//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);


//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state / network relationship state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);


//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");
define("TABLE_SUBMISSIONS", "submission_response");
define("TABLE_MESSAGE", "message");
define("TABLE_PAYOUT_ACCOUNT", "payout_account");
define("TABLE_REALTIME_NOTIFICATION", "realtime_notification");

//payout account type
define("ACCOUNT_TYPE_AMAZON_GIFT_CARD", "type_amazon_card");
define("ACCOUNT_TYPE_DING_MOBILE_TOP_UP", "type_ding");
//define("ACCOUNT_TYPE_REWARDS_GENIUS", "type_rewards_genius");
define("ACCOUNT_TYPE_PAYONEER", "type_payoneer");
define("ACCOUNT_TYPE_PAYPAL", "type_paypal");
define("ACCOUNT_TYPE_BANK_ACCOUNT", "type_bank");

//payout account function (the purpose of the specific account type)
define("ACCOUNT_FUNCTION_GIFT_CARD", "function_gift_card"); //("Gift Card")
define("ACCOUNT_FUNCTION_MOBILE", "function_mobile"); //("Mobile Recharge")
define("ACCOUNT_FUNCTION_CASH_OUT", "function_cash_out"); //("Monetary Cash Out")


//task status
define("TASK_STATUS_PENDING",   0);
define("TASK_STATUS_ACTIVE",    1);
define("TASK_STATUS_AWARDED",   2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT",     5);
define("TASK_STATUS_DISABLED",  6);

//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
define("ACTIVITY_TYPE_VOX", "activity_vox");
define("ACTIVITY_TYPE_POLL", "activity_poll");
//----------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");


//task activity category
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
define("ACTIVITY_CATEGORY_VOX", "category_vox");
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");
//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");

//user presence activity (the activity state that can be logged)
define("USER_ACTIVITY_ACCEPT_QUEST", "check_available");//the user queried available quest

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_PRIVATE", 0); //collectors cannot be used by other networks
define("NETWORK_POSITION_OFFICIAL", 1); //collectors can be used by other networks
define("NETWORK_POSITION_DEFAULT", 2); //this is the primary official network (all user registered without a specific network)

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CUSTOMER", 0);

//gender
define("GENDER_MALE", 1);
define("GENDER_FEMALE", 0);
define("GENDER_MALE_STRING", "male");
define("GENDER_FEMALE_STRING", "female");


//API KEY | AND CONSTANTS
define("SERVER_MAP_KEY", "AIzaSyCAbro3HYflhyhj9Z55xCMSZDBLABLABnM");
define("FIREBASE_SERVER_KEY", "AIzaSyD8Xf2XrVxrtq0sngAJrRULYniemVn8MJM");
define("FIREBASE_SENDER_ID", "114414183492");

define("PUSH_NOTIFICATION_TOPIC_NEW_QUEST", "/topics/new_quest");
define("PUSH_NOTIFICATION_TOPIC_BROADCAST", "/topics/new_broadcast");
define("PUSH_NOTIFICATION_TOPIC_MESSAGE", "/topics/new_message");

define("PUSH_NOTIFICATION_STATUS_NEW_QUEST", "new_quest");
define("PUSH_NOTIFICATION_STATUS_BROADCAST", "new_broadcast");
define("PUSH_NOTIFICATION_STATUS_MESSAGE", "new_message");


//define("NEW_REQUEST_TOPIC", "/topics/new_request");
//define("NEW_LOCATION_TOPIC", "/topics/location_changed");
//define("NEW_DRIVER_TOPIC", "/topics/driver_added");

//API KEY - PAYOUTS
define("DING_MOBILE_RECHARGE_KEY", "ApyJWyuifmb6YMuJhu7wAW");
define("AMAZON_GIFT_INCENTIVE_KEY", "AKIAWWFS6UKLHJAGJY55");




//--------------------------------------------------------


include("../../../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../../../includes/headers/strings.php");//has all the constants needed


/**
 * @Title Official Mobile Application Version Information
 * @Obj VERSION_NAME : This the version string name is is only used for labeling
 * @Obj VERSION_CODE : This is the actual version code used to maintain app version
 * @Obj VERSION_COMMENT : This is an optional string to be used in messaging
 * @Obj VERSION_PRIORITY : (0 -> This update is not priority and can be ignored by the user | 1 -> This update cannot be ignored)
 * @Usage : verifyLogin and processed by SplashScreen on the mobile App
 */
define("MOBILE_AGENT_ANDROID", "android");
define("MOBILE_AGENT_IOS", "ios");
define("MOBILE_VERSION_NAME", "version_name");
define("MOBILE_VERSION_CODE", "version_code");
define("MOBILE_VERSION_COMMENT", "version_comment");
define("MOBILE_VERSION_PRIORITY", "version_priority");


//define("ANDROID_VERSION_NAME", "1.4.1.8-16");
//define("ANDROID_VERSION_CODE", 29);

define("ANDROID_VERSION_NAME", "1.4.1.8-15");
define("ANDROID_VERSION_CODE", 28);



define("ANDROID_VERSION_COMMENT", ".");
define("ANDROID_VERSION_PRIORITY", 1);

define("IOS_VERSION_NAME", "1.0");
define("IOS_VERSION_CODE", 1);
define("IOS_VERSION_COMMENT", ".");
define("IOS_VERSION_PRIORITY", 1);

//API ACTIONS
define("ACTION_LOG_IN", "log_in");
define("ACTION_SIGN_UP", "sign_up");
define("ACTION_SIGN_OUT", "sign_out");
define("ACTION_GET_AVAILABLE_JOBS", "available_jobs");
define("ACTION_GET_ACTIVE_JOBS", "active_jobs");
define("ACTION_GET_COMPLETED_JOBS", "completed_jobs");
define("ACTION_ACCEPT_JOB", "accept_job");
define("ACTION_CANCEL_JOB", "cancel_job");
define("ACTION_GET_JOB_DETAIL", "get_job_detail");

define("ACTION_SUBMISSION_START", "submission_start");
define("ACTION_SUBMISSION_COMPLETE", "submission_complete");
define("ACTION_SEND_NOTIFICATION_ID", "send_notification_id");
define("ACTION_AUTHENTICATE_USER", "authenticate_user");
define("ACTION_GET_USER_DATA", "get_user_data");
define("ACTION_CHANGE_PASSWORD", "change_password");
//new actions
//define("", "");
define("ACTION_GET_WALLET_DATA", "get_wallet_data");
define("ACTION_SEND_DIRECT_MESSAGE", "send_direct_message");
define("ACTION_GET_DIRECT_MESSAGE_THREAD", "get_direct_message_thread");
define("ACTION_GET_DIRECT_MESSAGE_ITEM", "get_direct_message_item");
define("ACTION_GET_MESSAGE_LIST", "get_message_list");

define("ACTION_ADD_PRIMARY_ACCOUNT", "add_primary_bank_account");
define("ACTION_UPDATE_PRIMARY_ACCOUNT", "update_primary_bank_account");
define("ACTION_GET_PRIMARY_ACCOUNT", "get_primary_bank_account");

//LOCATION BASED VARIABLES
define("LOCATION_GREEN_ZONE", 16000); //16 km -> Users must be within the GREEN_ZONE in order to accept quest
define("SYSTEM_CURRENCY", "USD"); //The base currency used by the system
define("COUNTRY_JAMAICA", "JM"); //Country code for jamaica
define("COUNTRY_CHILE", "CL"); //Country code for chile




//$paperweight = new Database(MAIN_DB_USERNAME,MAIN_DB_PASSWORD,MAIN_DB_NAME);
//$paperweight->getConnector()->set_charset("utf8mb4");


$action = $_GET["action"];
if ($action == "demo")
{

    //https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?action=demo&param_json={%22user_id%22:823,%22lat%22:%2277.00%22,%22lng%22:%2213.00%22}

    $param_json = $_GET["param_json"];
    $data = json_decode($param_json, true);

    //329
    $user_id =      text_clean($data["user_id"]);
    //$lat =          text_clean($data["lat"]);
    //$lng =          text_clean($data["lng"]);
    //$response_id =  text_clean($data["response_id"]);

    //echo "This is demo <br>";
    //echo createEmailInvitationBody("google.com","Kadan Salmon");

    //echo getDefaultNetwork($paperweight);
    //echo json_encode(getOfficialNetworks($paperweight));

    /*$letters = array("a","b","c","d");

    foreach ($letters as $let){
        echo $let . "<br>";
    }*/

    //echo json_encode(getNetworkRelationship(125, $paperweight));
    //echo json_encode(isFromOfficialNetwork(329, $paperweight));
    //echo json_encode(isFromOfficialNetwork(121, $paperweight));
    //echo json_encode(isFromOfficialNetwork(377, $paperweight));

    //$client = new HostInfo();


    //echo json_encode($client->getCountry_flag());

    $lat = 17.9973836;
    $lng = -76.7896984;

    //$user_id = 823;

    $researcher = new Researcher($paperweight);
    $researcher->initializeResearcher($user_id);

    //$researcher->setCurrentLocation($lat,$lng);

    //$result = $researcher->getCurrentLocation();

    //$result = $researcher->startSubmission($response_id);
    //$result = $researcher->completeSubmission($response_id,);

    $task_id = 297;
    $passed_network_id = getQuestCreatorNetwork($task_id,$paperweight);

    $result = array();
    $data = array();
    $message_thread = array();


    /*

    $message_id = "pywxqjo-7175664-RRTWUNB";
    $recipient_id = 0;
    $recipient_network_id = "nid_jsy827459OFksye";
    $sender_id = 329;
    $sender_network_id = null;
    $timestamp = getCurrentTime();
    $task_id = 289;
    $msg_body = "this is my message body";




    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;



    $message_id = "jfhyfgr-8476395-HDKDJGT";
    $recipient_id = 329;
    $recipient_network_id = null;
    $sender_id = 0;
    $sender_network_id = "nid_jsy827459OFksye";
    $timestamp = "2021-03-11 08:14:58";
    $task_id = 289;
    $msg_body = "this is my message body sent by the company";

    $index = 1;

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;
    //$data[$index]["body"] = "Hello kadian";
    */


    $result["status"] = STATUS_OK;
    $result["message_thread"] = array();

    //if sender is not null (check if user is sender)


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){

        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);


            $data["message_id"] = $message_id;
            $data["recipient_id"] = intval($recipient_id);
            $data["recipient_network"] = $recipient_network_id;
            $data["sender_id"] = intval($sender_id);
            $data["sender_network"] = $sender_network_id;
            $data["task_id"] = intval($task_id);
            $data["timestamp"] = $timestamp;
            $data["body"] = ($msg_body);

            $message_thread[] = $data;

        }

        $result["status"] = STATUS_OK;
        $result["message_thread"] = $message_thread;

    }
    //$result = $researcher->startSubmission(79446052);
    //$result = $researcher->completeSubmission(79446052,30742304);
    //$result = $researcher->completeQuestionnaire(79446052);

    //$result = new LocationPoint(null,null);

    /*if (!$result->isEmpty()){
        echo "Location was found";
    }
    else{
        echo "Location was not found";
    }*/

    //echo $result->isEmpty();
    //echo $result->isEmpty();

    //$paperweight->getConnector()->set_charset("utf8");

    echo "Current character set is: " . $paperweight->getConnector()->character_set_name();

    //echo json_export($result);
    //echo json_encode($result);

}

if ($action == "replace")
{
    $lime_db = new Database("initia19_lime880","[2ST4)V2p6","initia19_lime880");//MAIN_DB_NAME

    //https://api.queritel.com/api/mobile/queritel/insight/workservice/db_bridge.php?action=replace&param_json={%22user_id%22:823,%22lat%22:%2277.00%22,%22lng%22:%2213.00%22}

    $old_script = "
    $(document).on('ready pjax:scriptcomplete',function(){

        // Identify this question
        var q1ID = '{QID}';
        var q1 = $('#question'+q1ID);


        
        const API_URL2 = \"https://api.queritel.com/api/insights/image_file.php\";
        const CAMERA_ENVIRONMENT = \"environment\";
        const CAMERA_FACING = \"user\";

        var file = document.querySelector('#image-file');
        var imgContainer = document.querySelector('#img-container');
        var imgPreview = document.querySelector('#image-preview');
        var uploadSuccess = document.querySelector('#upload-success');
        var startTime = 0;
        var endTime = 0;




        setupForm();


        //var nextButton = document.getElementById('ls-button-submit');
        //var imgOutput = document.getElementById(\"image-output\");
        var globalImageData = undefined;
        var globalImageName = undefined;


        function sendPost(url,action,param_json,callback) {

            var method = \"POST\";
            //var xmlHttpReq = false;
            var self = this;
            var msg=\"\";


            var xmlHttpReq = new XMLHttpRequest();

            if (window.XMLHttpRequest) {
                xmlHttpReq = new XMLHttpRequest();
            }
            else if (window.ActiveXObject) {
                // IE
                xmlHttpReq = new ActiveXObject(\"Microsoft.XMLHTTP\");
            }

            xmlHttpReq.open(\"POST\", url, true);
            xmlHttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xmlHttpReq.onreadystatechange = function() {

                if (xmlHttpReq.readyState === 4)
                {

                    if(xmlHttpReq.status !== 200){
                        //console.log(\"POST request failed at : \" + url);
                        //console.log('OOPS! Connection Error.');
                        return;
                    }

                    callback(xmlHttpReq.responseText);
                }
                else
                {
                    //console.log(\"POST request failed at : \" + url);
                    //console.log(self.xmlHttpReq.readyState);
                }
            }

            var postData = \"action=\" + action + \"&param_json=\" + param_json;

            xmlHttpReq.send(postData);
        }
        function sendFormPost(url,action,formDataEntry,param_json,callback) {

            var method = \"POST\";
            //var xmlHttpReq = false;
            var self = this;
            var msg=\"\";

            var xmlHttpReq = new XMLHttpRequest();

            if (window.XMLHttpRequest) {
                xmlHttpReq = new XMLHttpRequest();
            }
            else if (window.ActiveXObject) {
                // IE
                xmlHttpReq = new ActiveXObject(\"Microsoft.XMLHTTP\");
            }

            xmlHttpReq.open(\"POST\", url, true);
            //xmlHttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            //xmlHttpReq.setRequestHeader('Content-Type', 'multipart/form-data');

            xmlHttpReq.onreadystatechange = function() {

                if (xmlHttpReq.readyState == 4)
                {

                    if(xmlHttpReq.status != 200){
                        //console.log(\"POST request failed at : \" + url);
                        //console.log('OOPS! Connection Error.');
                        return;
                    }

                    callback(xmlHttpReq.responseText);
                }
                else
                {
                    //console.log(\"POST request failed at : \" + url);
                    //console.log(self.xmlHttpReq.readyState);
                }
            }

            //var formData = new FormData(formElement);
            let formData = formDataEntry;
            formData.append(\"action\", action);
            formData.append(\"param_json\",param_json);

            xmlHttpReq.send(formData);
        }
        function makeid(length) {
            var result           = '';
            var characters       = '0123456789';


            var charactersLength = characters.length;
            for ( var i = 0; i < length; i++ ) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            return result;
        }
        function setImageLink_textarea(link) {
            $('textarea', q1).val(link);
            $('textarea:hidden[id^=\"answer\"]', q1).val(link);
        }
        function setImageLink(link) {
            $('input[id^=\"answer\"]', q1).val(link);
            $('input:hidden[id^=\"answer\"]', q1).val(link);
        }
        
        function save_image2(id,form_data) {
            sendFormPost(API_URL2 + \"?id=\" + id,\"upload_image\",form_data,null,function (response) {
                //console

                console.log(response);
                let strResponse = JSON.parse(response);

                if(strResponse[\"status\"] === \"OK\"){
                    let image_link = strResponse[\"link\"];

                    uploadSuccess.setAttribute('data-status', \"success\");
                    //alert(\"Seconds to Upload : \" + endTimer());
                    console.log(\"Seconds to Upload : \" + endTimer());
                    console.log(response);

                    setImageLink(image_link);

                }
                else {
                    uploadSuccess.setAttribute('data-status', \"pending\");
                    console.log(response);
                }

            });
        }
        function usePicture2(form_data) {

            let image_name = makeid(15);
            //let image_link = \"https://api.queritel.com/api/resources/images/insights/\" + image_name + \".jpeg\";

            save_image2(image_name,form_data);
            //setImageLink(image_link);

            //globalImageName = image_name + \".jpeg\";

        }


        /*================== BREAKPOINT ========================*/


        function setupForm_textarea() {
            $('textarea', q1).css(\"display\", \"none\");
        }

        function setupForm() {
            $('input', q1).css(\"display\", \"none\");
        }

        function startTimer() {
            startTime = 0;
            endTime = 0;
            startTime = new Date().getTime() / 1000;
        }
        function endTimer() {
            endTime = new Date().getTime() / 1000;

            return endTime - startTime;
        }

        /*file.onchange = () => {
            let imgURL = URL.createObjectURL(file.files[0]);
            let img = document.createElement('img');

            img.onload = () => {
                URL.revokeObjectURL(imgURL);
            };

            img.src = imgURL;
            img.style.width = '100%';
            img.onclick = () => {
                img.style.width = (!!img.style.width) ? null : '100%';
            };

            *while (imgContainer.lastElementChild) {
                imgContainer.removeChild(imgContainer.lastElementChild);
            }*
            imgPreview.src = img.src;
            //imgContainer.append(img);



            setTimeout(imgSize, 100);
            function imgSize() {
                let img = imgPreview;//document.getElementById('imgId');

                let width = img.clientWidth;
                let height = img.clientHeight;

                takeSnapshot(img);

                if (globalImageData !== undefined){
                    usePicture(globalImageData);
                }
            }

        };*/

        function getBase64(file,onComplete) {
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function () {
                onComplete(reader.result);
                //console.log(reader.result);
            };
            reader.onerror = function (error) {
                //console.log('Error: ', error);
            };
        }
        function __getBase64Image__(src, callback) {
            const img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = () => {
                const canvas = document.createElement('canvas');
                const ctx = canvas.getContext('2d');
                let dataURL;
                canvas.height = img.naturalHeight;
                canvas.width = img.naturalWidth;
                ctx.drawImage(img, 0, 0);
                //dataURL = canvas.toDataURL(outputFormat);
                let imageData = canvas.toDataURL(\"image/jpeg\");
                let newData = imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");

                callback(newData);
            };

            img.src = src;
            if (img.complete || img.complete === undefined) {
                //img.src = \"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==\";
                img.src = src;
            }
        }

        function getBase64Image(src, callback) {
            const img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = () => {
                const canvas = document.createElement('canvas');
                const ctx = canvas.getContext('2d');
                let dataURL;
                canvas.height = img.clientHeight;//$(img).height();
                canvas.width = img.clientWidth;
                ctx.drawImage(img, 0, 0);
                //dataURL = canvas.toDataURL(outputFormat);
                let imageData = canvas.toDataURL(\"image/jpeg\");
                let newData = imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");

                callback(newData);
            };

            img.src = src;
            if (img.complete || img.complete === undefined) {
                //img.src = \"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==\";
                img.src = src;
            }
        }

        function getDataUrl(img) {
            // Create canvas
            const canvas = document.createElement('canvas');
            const ctx = canvas.getContext('2d');
            // Set width and height
            canvas.width = img.width;
            canvas.height = img.height;
            // Draw the image
            ctx.drawImage(img, 0, 0,img.width,img.height);

            let imageData = canvas.toDataURL(\"image/jpeg\");
            return imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");
        }

        //get file name and extension
        /*var imageType = /image.* /;
        if (!file.type.match(imageType)) return;*/
        /*var fullPath = document.getElementById('upload').value;
        if (fullPath) {
            var startIndex = (fullPath.indexOf('\\') >= 0 ? fullPath.lastIndexOf('\\') : fullPath.lastIndexOf('/'));
            var filename = fullPath.substring(startIndex);
            if (filename.indexOf('\\') === 0 || filename.indexOf('/') === 0) {
                filename = filename.substring(1);
            }
            alert(filename);
        }*/



        file.onchange = () => {

            let imgURL = URL.createObjectURL(file.files[0]);
            let img = document.createElement('img');

            img.onload = () => {
                URL.revokeObjectURL(imgURL);
            };

            img.src = imgURL;
            img.style.width = '100%';
            img.onclick = () => {
                img.style.width = (!!img.style.width) ? null : '100%';
            };

            /*while (imgContainer.lastElementChild) {
                imgContainer.removeChild(imgContainer.lastElementChild);
            }*/
            imgPreview.src = img.src;
            //imgContainer.append(img);


            /*imgPreview.addEventListener('load', function (event) {
                const dataUrl = getDataUrl(event.currentTarget);

                //console.log(dataUrl);
                uploadSuccess.setAttribute('data-status', \"loading\");
                usePicture(dataUrl);
            });*/

            
            //----VERSION 4---- (multipart content of the file - as a form file)
            var formData = new FormData();
            formData.append('image_file', file.files[0]);
            startTimer();
            uploadSuccess.setAttribute('data-status', \"loading\");

            usePicture2(formData);

        };

    });

    /*
    function resize(){
        //define the width to resize e.g 600px
        var resize_width = 600;//without px

        //get the image selected
        var item = document.querySelector('#uploader').files[0];

        //create a FileReader
        var reader = new FileReader();

        //image turned to base64-encoded Data URI.
        reader.readAsDataURL(item);
        reader.name = item.name;//get the image's name
        reader.size = item.size; //get the image's size
        reader.onload = function(event) {
            var img = new Image();//create a image
            img.src = event.target.result;//result is base64-encoded Data URI
            img.name = event.target.name;//set name (optional)
            img.size = event.target.size;//set size (optional)
            img.onload = function(el) {
                var elem = document.createElement('canvas');//create a canvas

                //scale the image to 600 (width) and keep aspect ratio
                var scaleFactor = resize_width / el.target.width;
                elem.width = resize_width;
                elem.height = el.target.height * scaleFactor;

                //draw in canvas
                var ctx = elem.getContext('2d');
                ctx.drawImage(el.target, 0, 0, elem.width, elem.height);

                //get the base64-encoded Data URI from the resize image
                var srcEncoded = ctx.canvas.toDataURL(el.target, 'image/jpeg', 0);

                //assign it to thumb src
                document.querySelector('#image').src = srcEncoded;

                /*Now you can send \"srcEncoded\" to the server and
                convert it to a png o jpg. Also can send
                \"el.target.name\" that is the file's name.* /

                /*Also if you want to download tha image use this * /
                / *
                var a = document.createElement(\"a\"); //Create <a>
                a.href =  srcEncoded; //set srcEncoded as src
                a.download = \"myimage.png\"; //set a name for the file
                a.click();

                * /


            }
        }
    }
    */

    /*//scale the image to 600 (width) and keep aspect ratio
      var scaleFactor = resize_width / el.target.width;
      elem.width = resize_width;
      elem.height = el.target.height * scaleFactor;

      //draw in canvas
      var ctx = elem.getContext('2d');
      ctx.drawImage(el.target, 0, 0, elem.width, elem.height);

      //get the base64-encoded Data URI from the resize image
      var srcEncoded = ctx.canvas.toDataURL(el.target, 'image/jpeg', 0);

      //assign it to thumb src
      document.querySelector('#image').src = srcEncoded;*/

    /*function add_new_file_uploader(addBtn) {
    var currentRow = $(addBtn).parent().parent();
    var newRow = $(currentRow).clone();
    $(newRow).find('.previewImage, .imagePreviewTable').hide();
    $(newRow).find('.removeButton').show();
    $(newRow).find('table.imagePreviewTable').find('tr').remove();
    $(newRow).find('input.multipleImageFileInput').val('');
    $(addBtn).parent().parent().parent().append(newRow);
}

function remove_file_uploader(removeBtn) {
    $(removeBtn).parent().parent().remove();
}

function show_image_preview(file_selector) {
    //files selected using current file selector
    var files = file_selector.files;
    //Container of image previews
    var imageContainer = $(file_selector).next('table.imagePreviewTable');
    //Number of images selected
    var number_of_images = files.length;
    //Build image preview row
    var imagePreviewRow = $('<tr class=\"imagePreviewRow_0\"><td valign=top style=\"width: 510px;\"></td>' +
        '<td valign=top><input type=\"button\" value=\"X\" title=\"Remove Image\" class=\"removeImageButton\" imageIndex=\"0\" onclick=\"remove_selected_image(this)\" /></td>' +
        '</tr> ');
    //Add image preview row
    $(imageContainer).html(imagePreviewRow);
    if (number_of_images > 1) {
        for (var i =1; i<number_of_images; i++) {
            **
             *Generate class name of the respective image container appending index of selected images,
             *sothat we can match images selected and the one which is previewed
             *
    var newImagePreviewRow = $(imagePreviewRow).clone().removeClass('imagePreviewRow_0').addClass('imagePreviewRow_'+i);
    $(newImagePreviewRow).find('input[type=\"button\"]').attr('imageIndex', i);
    $(imageContainer).append(newImagePreviewRow);
    }
    }
    for (var i = 0; i < files.length; i++) {
        var file = files[i];
        **
         * Allow only images
         *
        var imageType = /image.*;
        if (!file.type.match(imageType)) {
            continue;
        }

        **
         * Create an image dom object dynamically
         *
        var img = document.createElement(\"img\");

        **
         * Get preview area of the image
         *
        var preview = $(imageContainer).find('tr.imagePreviewRow_'+i).find('td:first');

        **
         * Append preview of selected image to the corresponding container
         *
        preview.append(img);

        **
         * Set style of appended preview(Can be done via css also)
         *
        preview.find('img').addClass('previewImage').css({'max-width': '500px', 'max-height': '500px'});

        **
         * Initialize file reader
         *
        var reader = new FileReader();
        **
         * Onload event of file reader assign target image to the preview
         *
        reader.onload = (function(aImg) { return function(e) { aImg.src = e.target.result; }; })(img);
        **
         * Initiate read
         *
        reader.readAsDataURL(file)
    }
    *
     * Show preview
     *
    $(imageContainer).show();
    }

    function remove_selected_image(close_button)
    {
        **
         * Remove this image from preview
         *
        var imageIndex = $(close_button).attr('imageindex');
        $(close_button).parents('.imagePreviewRow_' + imageIndex).remove();
    }

    function upload_images_selected(event, formObj)
    {
        event.preventDefault();
        //Get number of images
        var imageCount = $('.previewImage').length;
        //Get all multi select inputs
        var fileInputs = document.querySelectorAll('.multipleImageFileInput');
        //Url where the image is to be uploaded
        var url= \"/upload-directory/\";
        //Get number of inputs
        var number_of_inputs = $(fileInputs).length;
        var inputCount = 0;

        //Iterate through each file selector input
        $(fileInputs).each(function(index, input){

            fileList = input.files;
            // Create a new FormData object.
            var formData = new FormData();
            //Extra parameters can be added to the form data object
            formData.append('bulk_upload', '1');
            formData.append('username', $('input[name=\"username\"]').val());
            //Iterate throug each images selected by each file selector and find if the image is present in the preview
            for (var i = 0; i < fileList.length; i++) {
                if ($(input).next('.imagePreviewTable').find('.imagePreviewRow_'+i).length != 0) {
                    var file = fileList[i];
                    // Check the file type.
                    if (!file.type.match('image.*')) {
                        continue;
                    }
                    // Add the file to the request.
                    formData.append('image_uploader_multiple[' +(inputCount++)+ ']', file, file.name);
                }
            }
            // Set up the request.
            var xhr = new XMLHttpRequest();
            xhr.open('POST', url, true);
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var jsonResponse = JSON.parse(xhr.responseText);
                    if (jsonResponse.status == 1) {
                        $(jsonResponse.file_info).each(function(){
                            //Iterate through response and find data corresponding to each file uploaded
                            var uploaded_file_name = this.original;
                            var saved_file_name = this.target;
                            var file_name_input = '<input type=\"hidden\" class=\"image_name\" name=\"image_names[]\" value=\"' +saved_file_name+ '\" />';
                            file_info_container.append(file_name_input);

                            imageCount--;
                        })
                        //Decrement count of inputs to find all images selected by all multi select are uploaded
                        number_of_inputs--;
                        if(number_of_inputs == 0) {
                            //All images selected by each file selector is uploaded
                            //Do necessary acteion post upload
                            $('.overlay').hide();
                        }
                    } else {
                        if (typeof jsonResponse.error_field_name != 'undefined') {
                            //Do appropriate error action
                        } else {
                            alert(jsonResponse.message);
                        }
                        $('.overlay').hide();
                        event.preventDefault();
                        return false;
                    }
                } else {
                    *alert('Something went wrong!');*
                    $('.overlay').hide();
                    event.preventDefault();
                }
            };
            xhr.send(formData);
        })

        return false;
    }*/
";

    //Search Criteria : ==CAM_QUESTION_TAG==
    $new_script = "$(document).on('ready pjax:scriptcomplete',function(){
        //==CAM_QUESTION_TAG==

        // Identify this question
        var q1ID = '{QID}';
        var q1 = $('#question'+q1ID);


        const API_URL2 = \"https://api.queritel.com/api/insights/image_file.php\";
        const CAMERA_ENVIRONMENT = \"environment\";
        const CAMERA_FACING = \"user\";

        var file = document.querySelector('#image-file');
        //var image_capture = document.querySelector('#img-capture');
        var image_capture = document.querySelector('#image-file');
        var imgContainer = document.querySelector('#img-container');
        var imgPreview = document.querySelector('#image-preview');
        var uploadSuccess = document.querySelector('#upload-success');
        var startTime = 0;
        var endTime = 0;




        setupForm();


        //var nextButton = document.getElementById('ls-button-submit');
        //var imgOutput = document.getElementById(\"image-output\");
        var globalImageData = undefined;
        var globalImageName = undefined;





        function sendPost(url,action,param_json,callback) {

            var method = \"POST\";
            //var xmlHttpReq = false;
            var self = this;
            var msg=\"\";


            var xmlHttpReq = new XMLHttpRequest();

            if (window.XMLHttpRequest) {
                xmlHttpReq = new XMLHttpRequest();
            }
            else if (window.ActiveXObject) {
                // IE
                xmlHttpReq = new ActiveXObject(\"Microsoft.XMLHTTP\");
            }

            xmlHttpReq.open(\"POST\", url, true);
            xmlHttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xmlHttpReq.onreadystatechange = function() {

                if (xmlHttpReq.readyState === 4)
                {

                    if(xmlHttpReq.status !== 200){
                        //console.log(\"POST request failed at : \" + url);
                        //console.log('OOPS! Connection Error.');
                        return;
                    }

                    callback(xmlHttpReq.responseText);
                }
                else
                {
                    //console.log(\"POST request failed at : \" + url);
                    //console.log(self.xmlHttpReq.readyState);
                }
            }

            var postData = \"action=\" + action + \"&param_json=\" + param_json;

            xmlHttpReq.send(postData);
        }
        function sendFormPost(url,action,formDataEntry,param_json,callback) {

            var method = \"POST\";
            //var xmlHttpReq = false;
            var self = this;
            var msg=\"\";

            var xmlHttpReq = new XMLHttpRequest();

            if (window.XMLHttpRequest) {
                xmlHttpReq = new XMLHttpRequest();
            }
            else if (window.ActiveXObject) {
                // IE
                xmlHttpReq = new ActiveXObject(\"Microsoft.XMLHTTP\");
            }

            xmlHttpReq.open(\"POST\", url, true);
            //xmlHttpReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            //xmlHttpReq.setRequestHeader('Content-Type', 'multipart/form-data');

            xmlHttpReq.onreadystatechange = function() {

                if (xmlHttpReq.readyState == 4)
                {

                    if(xmlHttpReq.status != 200){
                        //console.log(\"POST request failed at : \" + url);
                        //console.log('OOPS! Connection Error.');
                        return;
                    }

                    callback(xmlHttpReq.responseText);
                }
                else
                {
                    //console.log(\"POST request failed at : \" + url);
                    //console.log(self.xmlHttpReq.readyState);
                }
            }

            //var formData = new FormData(formElement);
            let formData = formDataEntry;
            formData.append(\"action\", action);
            formData.append(\"param_json\",param_json);

            xmlHttpReq.send(formData);
        }
        function makeid(length) {
            var result           = '';
            var characters       = '0123456789';


            var charactersLength = characters.length;
            for ( var i = 0; i < length; i++ ) {
                result += characters.charAt(Math.floor(Math.random() * charactersLength));
            }
            return result;
        }
        function setImageLink_textarea(link) {
            $('textarea', q1).val(link);
            $('textarea:hidden[id^=\"answer\"]', q1).val(link);
        }
        function setImageLink(link) {
            $('input[id^=\"answer\"]', q1).val(link);
            $('input:hidden[id^=\"answer\"]', q1).val(link);
        }

        function save_image2(id,form_data) {
            sendFormPost(API_URL2 + \"?id=\" + id,\"upload_image\",form_data,null,function (response) {
                //console

                console.log(response);
                let strResponse = JSON.parse(response);

                if(strResponse[\"status\"] === \"OK\"){
                    let image_link = strResponse[\"link\"];

                    uploadSuccess.setAttribute('data-status', \"success\");
                    //alert(\"Seconds to Upload : \" + endTimer());
                    console.log(\"Seconds to Upload : \" + endTimer());
                    console.log(response);

                    setImageLink(image_link);

                }
                else {
                    uploadSuccess.setAttribute('data-status', \"pending\");
                    console.log(response);
                }

            });
        }
        function usePicture2(form_data) {

            let image_name = makeid(15);
            //let image_link = \"https://api.queritel.com/api/resources/images/insights/\" + image_name + \".jpeg\";

            save_image2(image_name,form_data);
            //setImageLink(image_link);

            //globalImageName = image_name + \".jpeg\";

        }

        //== CRITICAL ==: check if current script is viewed inside queritel client (local function)
        function isQueritelAgent() {
            let browser_agent = navigator.userAgent;
            let nav = browser_agent.split(/(?=.*(opera|safari|firefox|QueritelClient))(?=.*chrome).*/i);
            let is_queritel_agent = false;

            if (nav.includes(\"QueritelClient\")){
                console.log(\"=== Queritel Client has been detected ===\");

                is_queritel_agent = true;
            }

            return is_queritel_agent;
        }

        //== CRITICAL ==: mobile bridge triggered from mobile device and uploads the image url (bridge function)
        window.mobileBridgeLoadURLResult = function (url) {
            //This operation will be triggered by the mobile app

            console.log(\"=== Mobile Bridge has been detected ===\");
            //========== LOCAL CODE BODY ===============
            setImageLink(url);
            uploadSuccess.setAttribute('data-status', \"success\");
        }

        //== CRITICAL ==: todo mobile bridge triggered from mobile device and uploads the image data (bridge function)
        window.mobileBridgeLoadDataResult = function (img_data_result) {
            //This operation will be triggered by the mobile app

            console.log(\"=== Mobile Bridge has been detected ===\");
            //========== LOCAL CODE BODY ===============

            //let imgDataPreview = document.getElementById(\"img_data_result\");
            //imgDataPreview.value = img_data_result;

            let imgPreview = document.getElementById(\"image-preview\");
            imgPreview.src = img_data_result;

        }

        //== CRITICAL ==: tells the queritel client to start native image capture (local function)
        function triggerNativeImageCapture(){
            //try the android bridge
            try{
                mobileApplicationBridge.triggerImageCapture();
            } catch (e) {
                //this is not an android
            }

            //try the iOS bridge
            try{
                let result_obj = {
                    \"status\" : \"triggerImageCapture\"
                };

                window.webkit.messageHandlers.mobileApplicationBridge.postMessage(JSON.stringify(result_obj));
            } catch (e) {
                //this is not an iOS
            }
        }



        /*================== BREAKPOINT ========================*/


        function setupForm_textarea() {
            $('textarea', q1).css(\"display\", \"none\");
        }

        function setupForm() {
            $('input', q1).css(\"display\", \"none\");
        }

        function startTimer() {
            startTime = 0;
            endTime = 0;
            startTime = new Date().getTime() / 1000;
        }
        function endTimer() {
            endTime = new Date().getTime() / 1000;

            return endTime - startTime;
        }

        function getBase64(file,onComplete) {
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function () {
                onComplete(reader.result);
                //console.log(reader.result);
            };
            reader.onerror = function (error) {
                //console.log('Error: ', error);
            };
        }
        function __getBase64Image__(src, callback) {
            const img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = () => {
                const canvas = document.createElement('canvas');
                const ctx = canvas.getContext('2d');
                let dataURL;
                canvas.height = img.naturalHeight;
                canvas.width = img.naturalWidth;
                ctx.drawImage(img, 0, 0);
                //dataURL = canvas.toDataURL(outputFormat);
                let imageData = canvas.toDataURL(\"image/jpeg\");
                let newData = imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");

                callback(newData);
            };

            img.src = src;
            if (img.complete || img.complete === undefined) {
                //img.src = \"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==\";
                img.src = src;
            }
        }

        function getBase64Image(src, callback) {
            const img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = () => {
                const canvas = document.createElement('canvas');
                const ctx = canvas.getContext('2d');
                let dataURL;
                canvas.height = img.clientHeight;//$(img).height();
                canvas.width = img.clientWidth;
                ctx.drawImage(img, 0, 0);
                //dataURL = canvas.toDataURL(outputFormat);
                let imageData = canvas.toDataURL(\"image/jpeg\");
                let newData = imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");

                callback(newData);
            };

            img.src = src;
            if (img.complete || img.complete === undefined) {
                //img.src = \"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==\";
                img.src = src;
            }
        }

        function getDataUrl(img) {
            // Create canvas
            const canvas = document.createElement('canvas');
            const ctx = canvas.getContext('2d');
            // Set width and height
            canvas.width = img.width;
            canvas.height = img.height;
            // Draw the image
            ctx.drawImage(img, 0, 0,img.width,img.height);

            let imageData = canvas.toDataURL(\"image/jpeg\");
            return imageData.replace(/^data:image\/png/, \"data:application/octet-stream\");
        }

        image_capture.onclick = () => {

            triggerNativeImageCapture();

        }

        file.onchange = () => {

            let imgURL = URL.createObjectURL(file.files[0]);
            let img = document.createElement('img');

            img.onload = () => {
                URL.revokeObjectURL(imgURL);
            };

            img.src = imgURL;
            img.style.width = '100%';
            img.onclick = () => {
                img.style.width = (!!img.style.width) ? null : '100%';
            };

            imgPreview.src = img.src;

            //----VERSION 4---- (multipart content of the file - as a form file)
            var formData = new FormData();
            formData.append('image_file', file.files[0]);
            startTimer();
            uploadSuccess.setAttribute('data-status', \"loading\");

            if(!isQueritelAgent()){
                usePicture2(formData);
            }


        };

    });";
    $new_script_array = str_split($new_script);


    //todo : modify survey
    $survey_id = 167855;

    //echo "Hello";
    //exit(0);



    //$old_script = stripslashes($old_script);
    //$old_script = htmlspecialchars_decode($old_script);

    //$question_query = "select * from lsnm_questions where sid = '544665' and type = 'S' and question like '%$old_script%'";
    $question_query = "select * from lsnm_questions where sid = '$survey_id' and type = 'S'";
    $question_result = $lime_db->query($question_query);
    //$question_result = null;

    $count = 10;
    $counter = 1;
    $completed_counter = 0;

    if($question_result != null && $question_result->is_row_found()){

        while($row = $question_result->fetch_array()){

            /*$message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);*/


            /*$data["message_id"] = $message_id;
            $data["recipient_id"] = intval($recipient_id);
            $data["recipient_network"] = $recipient_network_id;
            $data["sender_id"] = intval($sender_id);
            $data["sender_network"] = $sender_network_id;
            $data["task_id"] = intval($task_id);
            $data["timestamp"] = $timestamp;
            $data["body"] = ($msg_body);*/

            /*$message_thread[] = $data;*/

            $question = $row["question"];
            $qid = $row["qid"];
            //$question .= "This is Just Some extra text to be loaded";
            //$old_script = $old_script;
            //$output_array = array();


            $all_chars = str_split($question);
            $all_chars_count = count($all_chars);
            $all_chars_part_1 = array();
            $all_chars_part_2 = array();
            $all_chars_new = array();

            $finish = false;
            $is_extra = false;
            $inside_script = false;
            $index = 0;
            $is_listening = false;
            $found_end = false;
            $collected_text = array();

            //CAMERA_ENVIRONMENT
            $cam_question_detected = false;


            while (!$finish){

                if ($inside_script){
                    //echo "Found script tag at index : $index => with " . implode("", $collected_text);
                    if ($index < $all_chars_count){
                        //more text to process

                        if (!$is_extra){
                            //this is directly inside the script tag

                            if ($is_listening){
                                if ((implode("",$collected_text) == "</script>")){
                                    $is_listening = false;
                                    $is_extra = true;

                                    if ($found_end){
                                        $all_chars_part_2[] = $all_chars[$index];
                                    }
                                    $index++;
                                    continue;
                                }
                                else{
                                    if ($all_chars[$index] == ">"){
                                        $collected_text[] = $all_chars[$index];

                                        if ((implode("",$collected_text) == "</script>")){
                                            $is_listening = false;
                                            $is_extra = true;
                                            //$collected_text = array();
                                        }
                                        else{
                                            $collected_text = array();
                                            $is_listening = false;
                                        }

                                        if ($found_end){
                                            $all_chars_part_2[] = $all_chars[$index];
                                        }
                                        $index++;
                                        continue;

                                    }
                                    else{
                                        $collected_text[] = $all_chars[$index];

                                        if ($found_end){
                                            $all_chars_part_2[] = $all_chars[$index];
                                        }
                                        $index++;
                                        continue;
                                    }
                                }
                            }
                            else{ //if not listening
                                if ($all_chars[$index] == "<"){
                                    $collected_text[] = $all_chars[$index];
                                    $is_listening = true;

                                    if ($all_chars[$index+1] == "/" && $all_chars[$index+2] == "s" && $all_chars[$index+3] == "c" && $all_chars[$index+4] == "r" && $all_chars[$index+5] == "i" && $all_chars[$index+6] == "p" && $all_chars[$index+7] == "t" && $all_chars[$index+8] == ">"){
                                        $found_end = true;
                                    }

                                    if ($found_end){
                                        $all_chars_part_2[] = $all_chars[$index];
                                    }
                                    $index++;
                                    continue;
                                }
                                else{
                                    //CAMERA_ENVIRONMENT
                                    if ($all_chars[$index] == "C"){
                                        //$collected_text[] = $all_chars[$index];
                                        //$is_listening = true;

                                        if (!$found_end && $all_chars[$index+1] == "A" && $all_chars[$index+2] == "M" && $all_chars[$index+3] == "E" && $all_chars[$index+4] == "R" && $all_chars[$index+5] == "A" && $all_chars[$index+6] == "_" && $all_chars[$index+7] == "E" && $all_chars[$index+8] == "N" && $all_chars[$index+9] == "V" && $all_chars[$index+10] == "I" && $all_chars[$index+11] == "R" && $all_chars[$index+12] == "O" && $all_chars[$index+13] == "N" && $all_chars[$index+14] == "M" && $all_chars[$index+15] == "E" && $all_chars[$index+16] == "N" && $all_chars[$index+17] == "T"){
                                            $cam_question_detected = true;
                                        }

                                        if ($found_end){
                                            $all_chars_part_2[] = $all_chars[$index];
                                        }
                                        $index++;
                                        continue;
                                    }

                                    if ($found_end){
                                        $all_chars_part_2[] = $all_chars[$index];
                                    }
                                    $index++;
                                    continue;
                                }
                            }
                        }
                        else{
                            //this is after the end of the script tag
                            $all_chars_part_2[] = $all_chars[$index];
                            $index++;
                        }

                        /*for ($i = 0; $i < 500000; $i++){

                            //unset($all_chars[$index]);

                            //$index++;
                        }
                        echo implode("", $all_chars_part_1);
                        echo $all_chars_count . " and index : $index";
                        $finish = true;*/

                    }
                    else{
                        $finish = true;
                        $inside_script = false;
                        continue;
                    }
                }
                else{//out of script tag
                    if ($is_listening){
                        if ((implode("",$collected_text) == "<script>")){
                            $is_listening = false;
                            $inside_script = true;

                            $all_chars_part_1[] = $all_chars[$index];
                            $index++;
                            continue;
                        }
                        else{
                            if ($all_chars[$index] == ">"){
                                $collected_text[] = $all_chars[$index];

                                if ((implode("",$collected_text) == "<script>")){
                                    $is_listening = false;
                                    $inside_script = true;
                                    //$collected_text = array();
                                }
                                else{
                                    $collected_text = array();
                                    $is_listening = false;
                                }

                                $all_chars_part_1[] = $all_chars[$index];
                                $index++;
                                continue;

                            }
                            else{
                                $collected_text[] = $all_chars[$index];

                                $all_chars_part_1[] = $all_chars[$index];
                                $index++;
                                continue;
                            }
                        }
                    }
                    else{ //if not listening
                        if ($all_chars[$index] == "<"){
                            $collected_text[] = $all_chars[$index];
                            $is_listening = true;

                            $all_chars_part_1[] = $all_chars[$index];
                            $index++;
                            continue;
                        }
                        else{
                            $all_chars_part_1[] = $all_chars[$index];
                            $index++;
                            continue;
                        }
                    }

                }


                //$finish = true;
            }

            //echo implode("", $all_chars_part_1);
            //echo implode("", $new_script_array);
            //echo implode("", $all_chars_part_2);

            $new_text = implode("", $all_chars_part_1) . implode("", $new_script_array) . implode("", $all_chars_part_2);
            $new_text =  addslashes($new_text);

            //$question_query = "select * from lsnm_questions where sid = '544665' and type = 'S'";

            //19676
            if ($cam_question_detected){
                echo "Camera Detected at Quest ID : $qid -> TRUE\n";

                $sql_query = "update lsnm_questions set `question` = '$new_text' where qid = '$qid' and `sid` = '$survey_id' and `type` = 'S'";
                $sql_query_result = $lime_db->query($sql_query);
                //$sql_query_result = null;
                if($sql_query_result != null && $sql_query_result->is_row_affected()){
                    echo "$counter : Updated Quest ID : $qid -> TRUE\n";
                    $completed_counter++;
                }
                else{
                    echo "$counter : Updated Quest ID : $qid -> FALSE\n";
                }
            }
            else{
                echo "$counter : Camera Detected at Quest ID : $qid -> FALSE\n";
            }


            $counter++;

            //echo $new_text;

            //echo "\n\n\n================================================================================================================================================================ OLD SCRIPT ======================================================================================================================================================\n\n\n";

            /*if ($count <= 0){
                break;
            }
            $count--;*/

            //$new_string = str_replace(htmlentities($old_script),"<script> This is my replacment</script>",($question));

            //echo $question;

            //echo "\n\n\n\n\n\n\n\n\n";

            //echo $old_script;



        }
        echo "\n\nUpdated Successfully : $completed_counter";

    }

}




//DING MOBILE RECHARGE : needs to be fixed
function connectDingAPI($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json','api_key: ApyJWyuifmb6YMuJhu7wAW'));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            'Content-Type: application/json',
            'api_key: ' . DING_MOBILE_RECHARGE_KEY
        ));


    $payload = array();
    $payload["SkuCode"] = "JM_DC_TopUp";
    $payload["SendValue"] = 5;
    $payload["SendCurrencyIso"] = "USD";
    //$payload["AccountNumber"] = "18765197487";
    $payload["AccountNumber"] = "18762971769";
    $payload["DistributorRef"] = "#659075749";

    //$settings = array();
    //$settings["Name"] = "Queritel Payout";
    //$settings["Value"] = "5 usd";
    //$settings["Name"] = "";
    //$settings["Value"] = "";

    //$payload["Settings"] = $settings;
    $payload["ValidateOnly"] = true;
    $payload["BillRef"] = "Queritel Reference : 1967048";



    //$fields = array();
    //$fields['data'] = $message;
    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $res = curl_exec($ch);

    curl_close($ch);

    //$res = json_decode($res, true);
    //$res = json_decode($res, true);

    return $res;
}

//FIREBASE NOTIFICATION BASE
function sendFCM($message, $id) {
    /*if(!function_exists(curl_exec)){
        LogReport("unsetRequestTopicListener : " . "curl is not installed");
        return;
    }*/

    //$message =  array
    $url = 'https://fcm.googleapis.com/fcm/send';

    $fields = array();
    $fields['data'] = $message;

    if (is_array($id)) {
        $fields["registration_ids"] = $id;
    }
    else {
        $fields["to"] = $id;
    }


    $encoded_fields = json_encode($fields);

    $headers = array(
        'Authorization: key=' . FIREBASE_SERVER_KEY,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    curl_close($ch);

    return $result;
}

//VERIFY CHILEAN R.U.T
function verifyRUT($chilean_rut){
    $__lnk = 'https://api.libreapi.cl/';
    $__out = '{
                "data": {
                    "rut": "272.185.964-8",
                    "name": "Full Name",
                    "activities": [
                        {
                            "name": "Actividades De Consultoria De Gestion",
                            "code": 702000,
                            "category": "Segunda",
                            "subject_to_vat": false,
                            "date": "2020-06-18T00:00:00Z"
                        }
                    ]
                },
                "status": "success"
            }';



    //$url = "https://api.libreapi.cl/rut/validate?rut=" . $chilean_rut;
    $url = "https://api.libreapi.cl/rut/activities?rut=" . $chilean_rut;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    //$payload = array();
    //$payload["var_1"] = "value";

    //$encoded_fields = json_encode($payload);
    //curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_object = json_decode($result, true);

    $output = array();
    $output["rut"] = $chilean_rut;
    $output["verified"] = false;
    $output["full_name"] = null;
    $output["activities"] = null;

    if (($result_object["status"] == "success")){
        $output["rut"] = $result_object["data"]["rut"];

        if (!empty($result_object["data"]["name"])){
            $output["verified"] = true;
            $output["full_name"] = $result_object["data"]["name"];
            $output["activities"] = $result_object["data"]["activities"];
        }
    }

    curl_close($ch);

    return $output;
}




//THIRD-PARTY API TEMPLATE
function __api_template__($url){
    $__lnk = 'https://';
    $__out = '';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    $payload = array();
    $payload["var_1"] = "value";

    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    //$result_object = json_decode($result, true);

    curl_close($ch);

    return $result;
}


//============= THIRD PARTY API END ===================

function sendNewQuestNotification($paperweight,$country_code){
    //$note_id = array();

    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION;
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $user_id = $row["user_id"];

            $user_data = query_user($user_id,$paperweight);
            $code = $user_data["country_code"];

            //country_code

            if ($country_code == $code){

                $note_id = $row["notification_id"];
                $message = array();

                $payload = array();
                $payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
                $payload["extra"]["message"] = "empty";
                $message["payload"] = $payload;
                sendFCM($message,$note_id);

            }
        }
    }
}
function sendNewMessageNotification($user_id,$paperweight){
    //$note_id = array();


    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $note_id = $row["notification_id"];

            $message = array();

            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = "empty";

            $message["payload"] = $payload;

            sendFCM($message,$note_id);

        }
    }
}

//users who accepted the specific quest
function getQuestAgents($task_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;
    $processed_array = array();

    $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {

        $data = array();

        while ($row = $response_result->fetch_array())
        {

            //$response_total = $row["survey_count"];
            //$response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];


            if (!isset($processed_array[$user_id])){

                $user_info = query_user($user_id, $paperweight);

                $data["user_id"] = $user_info["user_id"];
                $data["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
                $data["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
                $data["phone_number"] = $user_info["phone_number"];
                $data["email"] = $user_info["user_email"];


                $processed_array[$user_id] = $data;

                $progress[$index] = $data;

                $index++;
            }

            //$progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["user_id"] = $user_info["user_id"];


            //$progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            //$progress[$index]["response_total"] = intval($response_total);
            //$progress[$index]["response_count"] = intval($response_count);

            //$combined_total = $combined_total + $response_count;
        }
    }

    //$result["combined_total"] = intval($combined_total);
    //$result["progress"] = $progress;

    return $progress;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];


            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;
            $result["country_code"] = $row["country_code"];
            $result["phone_number"] = $row["phone_number"];
            $result["user_email"] = $row["user_email"];


        }
    }

    return $result;
}
function getLastMsg($agent_id,$network_id,$task_id,$paperweight){
    //get the last communication between an agent and the network
    //as well as the unread messages
    $last_msg = array();
    $last_msg["msg_body"] = "";
    $last_msg["timestamp"] = "";
    $last_msg["unread"] = 0; //the combined unread messages


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$network_id' or recipient_network_id = '$network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){


        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);
            $read = $row["read"];
            $unread = 0;


            $last_msg["msg_body"] = $msg_body;
            $last_msg["timestamp"] = $timestamp;

            if (($recipient_network_id == $network_id) && $read == 0){
                $prev_unread = $last_msg["unread"];
                $new_unread = $prev_unread + 1;

                $last_msg["unread"] = $new_unread;

            }

        }

    }


    return $last_msg;
}

/**
 * This function will check if a string is inside a string-array
 * irregardless of the case of the string
 *
 *  */
function isContainedIn($str, $str_array, $case_sensitive = false) {


    if($case_sensitive == false){
        $needle = strtolower($str);
        $haystack = strtolower($str_array);
    }
    else{
        $needle = $str;
        $haystack = $str_array;
    }

    $found = preg_match("/$needle/", $haystack);


    if($found){

        return true;
    }
    else{

        return false;
    }
}
function notificationTokenHash($notification_id){
    return md5("05624" . $notification_id);
}
function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function random_number($length = 5) {
    $characters = '01234567898576479201';
    $charactersLength = strlen($characters);
    $randomNumber = '';

    for ($i = 0; $i < $length; $i++) {
        $randomNumber .= $characters[true_random(0, $charactersLength - 1)];
    }
    return $randomNumber;
}
function generate_token() {
    return getRandomNumber(4) . "" . getRandomNumber(4);
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}



function hasAgent(){
    $has_agent = isset($_GET["agent"]);
    //$app_agent = clean($_GET["agent"]);

    //if (!$has_agent){
        //$has_agent = true;
        //$app_agent = MOBILE_AGENT_ANDROID;
    //}

    return $has_agent;
}
function getAgent(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = clean($_GET["agent"]);

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    return $app_agent;
}
function getAPP_VERSION_DATA(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = clean($_GET["agent"]);
    $results = array();

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    if ($has_agent && ($app_agent == MOBILE_AGENT_ANDROID)){
        $results[MOBILE_VERSION_NAME] = ANDROID_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = ANDROID_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = ANDROID_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = ANDROID_VERSION_PRIORITY;
    }
    else if ($has_agent && ($app_agent == MOBILE_AGENT_IOS)){
        $results[MOBILE_VERSION_NAME] = IOS_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = IOS_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = IOS_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = IOS_VERSION_PRIORITY;
    }

    return $results;
}


//debug----
function getQuestCreatorNetwork($task_id,$paperweight){
    $network_id = null;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $network_id = $row["creator_net_id"];
        }
    }

    return $network_id;
}
function getQuestDetail($task_id,$paperweight){
    $detail = array();

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $detail["task_id"] = $row["task_id"];
            $detail["creator_net_id"] = $row["creator_net_id"];
            $detail["task_ref_id"] = $row["task_ref_id"];
            $detail["task_user_id"] = $row["task_user_id"];
            $detail["task_status"] = $row["task_status"];
            $detail["task_topic"] = $row["task_topic"];
            $detail["task_budget"] = $row["task_budget"];
            $detail["task_instructions"] = $row["task_instructions"];
            $detail["task_posted_on"] = $row["task_posted_on"];
            $detail["task_completed_on"] = $row["task_completed_on"];
            $detail["task_respondent_count"] = $row["task_respondent_count"];
            $detail["task_question_count"] = $row["task_question_count"];
            $detail["task_location_count"] = $row["task_location_count"];
            $detail["survey_url"] = $row["survey_url"];
            $detail["completion_url"] = $row["completion_url"];
            $detail["survey_ready"] = $row["survey_ready"];
            $detail["task_time_day"] = $row["task_time_day"];
            $detail["task_question_type"] = $row["task_question_type"];
            $detail["my_network"] = $row["my_network"];
            $detail["network_id"] = $row["network_id"];
            $detail["task_category"] = $row["task_category"];
            $detail["task_activity"] = $row["task_activity"];
            $detail["task_start_date"] = $row["task_start_date"];
            $detail["task_due_date"] = $row["task_due_date"];
            $detail["handle_payment"] = $row["handle_payment"];
            $detail["workforce_timezone"] = $row["workforce_timezone"];
            $detail["workforce_country"] = $row["workforce_country"];
        }
    }

    return $detail;
}
//debug----

//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;


        }
    }

    return $result;
}
function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}
function isFromNetwork($user_id, $network_id, $paperweight,$check_active = true){
    //check_active - check to make sure the relationship is active

    $is_from_network = false;

    if ($check_active){
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and relationship_state = '" . STATE_ACTIVE . "'";
    }
    else{
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "'";
    }

    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $is_from_network = true;
        }
    }

    return $is_from_network;
}
function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        while ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result[] = $net;

        }
    }


    return $result;
}
function isFromOfficialNetwork($user_id, $paperweight,$check_active = true){
    $from_official = false;

    $official_networks = getOfficialNetworks($paperweight);
    $network_relationship = getNetworkRelationship($user_id,$paperweight);

    if (!empty($network_relationship)){
        foreach ($network_relationship as $relation){
            $network_id = $relation["network_id"];
            $network_role = $relation["network_role"];
            $network_rel_state = $relation["relationship_state"];

            if ($check_active){
                if (in_array($network_id,$official_networks) && $network_rel_state == STATE_ACTIVE){
                    $from_official = true;
                }
            }
            else{
                if (in_array($network_id,$official_networks)){
                    $from_official = true;
                }
            }
        }
    }

    return $from_official;
}
function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}

//Location-Based functions
function getDistanceBetweenAccurate(LocationPoint $point1, LocationPoint $point2) {
    //get the distance from driver's location to the request origin [to see how close the driver is]
    //returns array("SUCCESS","distance_value")
    //unit = metrics(meters)

    $output["status"] = "FAILED";

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $origin = $point1->getLatitude() . "," . $point1->getLongitude();
    $destination = $point2->getLatitude() . "," . $point2->getLongitude();

    $url2 = "https://map.google.com/maps/api/distancematrix/json?units=metric&origins={$origin}&destinations={$destination}&key=" . SERVER_MAP_KEY;
    $fil2 = file_get_contents($url2);

    $results = json_decode($fil2, true);


    if ($results["status"] == "OK") {
        if ($results["rows"][0]["elements"][0]["status"] == "OK") {
            $distance_in_meters = $results["rows"][0]["elements"][0]["distance"]["value"];
            $output["status"] = "SUCCESS";
            $output["distance"] = $distance_in_meters;
        }
    }

    return $output;
}
function getRad($var) {
    return $var * pi() / 180;
}
function getDistanceBetweenGeneral(LocationPoint $point1, LocationPoint $point2) {
    $EARTH_MEAN_RADIUS_METERS = 6378137; //earths mean radius in meters

    $output = null;

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $distanceLat = getRad($point2->getLatitude() - $point1->getLatitude());
    $distanceLon = getRad($point2->getLongitude() - $point1->getLongitude());

    $a = sin($distanceLat / 2) * sin($distanceLat / 2) + cos(getRad($point1->getLatitude())) * cos(getRad($point2->getLatitude())) * sin($distanceLon / 2) * sin($distanceLon / 2);
    $angular_distance = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance_meters = intval($EARTH_MEAN_RADIUS_METERS * $angular_distance);

    $output = $distance_meters;

    return $output;
}

function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}

function __get_template__($paperweight){
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }
}
function __insert_template__($paperweight){
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __update_template__($paperweight){
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __delete_template__($paperweight){
    $module = array();

    $sql_query = "delete from " . "_TABLE_NAME_" . " where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}

/**
 * @purpose : for processing the country table of the paperweight database
 **/
class Country {

    public static function getCountry($countryId, Database $db_handle) {
        if($db_handle == null){

            return null;
        }


        $sql = "select (country_name) from " . TABLE_COUNTRY . " where country_id = '$countryId'";
        if($db_handle != null){
            $result = $db_handle->query($sql);
            if($result != null){
                while($row = $result->fetch_array()){
                    return Country::parseCountry($row["country_name"]);
                    //return $row["country_name"];
                }

            }
        }

        return null;
    }

    /**
     * @purpose : strips the string of all non alphabet
     *       */
    public static function parseCountry($string){
        $array = explode(" ", $string);
        $text_only = preg_grep('/[[:alpha:]]/', $array);
        $new_text = strtolower(join(" ", $text_only));

        return $new_text;
    }

    /**
     * @purpose : check if either string is in the other
     *       */
    public static function isContainedIn($str, $str_array,$case_sensitive = false){

        if($case_sensitive == false){
            $needle = strtolower($str);
            $haystack = strtolower($str_array);
        }
        else{
            $needle = $str;
            $haystack = $str_array;
        }

        $found = preg_match("/$needle/", $haystack);
        if($found){

            return true;
        }
        else{
            //check the other way round
            $found2 = preg_match("/$haystack/",$needle );

            if($found2){
                return true;
            }
            else{
                return false;
            }

        }

        return false;

    }

}

/**
 * Author : Kadian Salmon
 * Date : Sep 17, 2019
 * Purpose : Job is responsible for holding a job instance
 */
class Job {
    private $job_id;
    private $update_time;
    private $task_id;
    private $user_id;
    private $address;
    private $state;
    private $country;
    private $country_code;
    private $customer;
    private $lat;
    private $lng;
    private $researcher_required;
    private $researcher_count;
    private $survey_id;
    private $survey_total;
    private $survey_assigned;
    private $price;


    function __construct() {

    }

    public function getJob_id() {
        return $this->job_id;
    }

    public function getUpdate_time() {
        return $this->update_time;
    }

    public function getTask_id() {
        return $this->task_id;
    }

    public function getUser_id() {
        return $this->user_id;
    }

    public function getAddress() {
        return $this->address;
    }

    public function getState() {
        return $this->state;
    }

    public function getCountry() {
        return $this->country;
    }

    public function getCountry_code() {
        return $this->country_code;
    }

    public function getCustomer() {
        return $this->customer;
    }

    public function getLat() {
        return $this->lat;
    }

    public function getLng() {
        return $this->lng;
    }

    public function getResearcher_required() {
        return $this->researcher_required;
    }

    public function getResearcher_count() {
        return $this->researcher_count;
    }

    public function getSurvey_id() {
        return $this->survey_id;
    }

    public function getSurvey_total() {
        return $this->survey_total;
    }

    public function getSurvey_assigned() {
        return $this->survey_assigned;
    }

    public function getPrice() {
        return $this->price;
    }

    public function setJob_id($job_id) {
        $this->job_id = $job_id;
        return $this;
    }

    public function setUpdate_time($update_time) {
        $this->update_time = $update_time;
        return $this;
    }

    public function setTask_id($task_id) {
        $this->task_id = $task_id;
        return $this;
    }

    public function setUser_id($user_id) {
        $this->user_id = $user_id;
        return $this;
    }

    public function setAddress($address) {
        $this->address = $address;
        return $this;
    }

    public function setState($state) {
        $this->state = $state;
        return $this;
    }

    public function setCountry($country) {
        $this->country = $country;
        return $this;
    }

    public function setCountry_code($country_code) {
        $this->country_code = $country_code;
        return $this;
    }

    public function setCustomer($customer) {
        $this->customer = $customer;
        return $this;
    }

    public function setLat($lat) {
        $this->lat = $lat;
        return $this;
    }

    public function setLng($lng) {
        $this->lng = $lng;
        return $this;
    }

    public function setResearcher_required($researcher_required) {
        $this->researcher_required = $researcher_required;
        return $this;
    }

    public function setResearcher_count($researcher_count) {
        $this->researcher_count = $researcher_count;
        return $this;
    }

    public function setSurvey_id($survey_id) {
        $this->survey_id = $survey_id;
        return $this;
    }

    public function setSurvey_total($survey_total) {
        $this->survey_total = $survey_total;
        return $this;
    }

    public function setSurvey_assigned($survey_assigned) {
        $this->survey_assigned = $survey_assigned;
        return $this;
    }

    public function setPrice($price) {
        $this->price = $price;
        return $this;
    }



}
class JobResponse {
    private $response_id;
    private $update_time;
    private $job_id;
    private $task_id;
    private $user_id;
    private $survey_id;
    private $survey_count;
    private $survey_completed;
    private $survey_state;
    private $survey_start;
    private $survey_end;
    private $price;
    private $payment_date;



    function __construct() {

    }

    public function getResponse_id() {
        return $this->response_id;
    }

    public function getUpdate_time() {
        return $this->update_time;
    }

    public function getJob_id() {
        return $this->job_id;
    }

    public function getTask_id() {
        return $this->task_id;
    }

    public function getUser_id() {
        return $this->user_id;
    }

    public function getSurvey_id() {
        return $this->survey_id;
    }

    public function getSurvey_count() {
        return $this->survey_count;
    }

    public function getSurvey_completed() {
        return $this->survey_completed;
    }

    public function getSurvey_state() {
        return $this->survey_state;
    }

    public function getSurvey_start() {
        return $this->survey_start;
    }

    public function getSurvey_end() {
        return $this->survey_end;
    }

    public function getPrice() {
        return $this->price;
    }

    public function getPayment_date() {
        return $this->payment_date;
    }

    public function setResponse_id($response_id) {
        $this->response_id = $response_id;
        return $this;
    }

    public function setUpdate_time($update_time) {
        $this->update_time = $update_time;
        return $this;
    }

    public function setJob_id($job_id) {
        $this->job_id = $job_id;
        return $this;
    }

    public function setTask_id($task_id) {
        $this->task_id = $task_id;
        return $this;
    }

    public function setUser_id($user_id) {
        $this->user_id = $user_id;
        return $this;
    }

    public function setSurvey_id($survey_id) {
        $this->survey_id = $survey_id;
        return $this;
    }

    public function setSurvey_count($survey_count) {
        $this->survey_count = $survey_count;
        return $this;
    }

    public function setSurvey_completed($survey_completed) {
        $this->survey_completed = $survey_completed;
        return $this;
    }

    public function setSurvey_state($survey_state) {
        $this->survey_state = $survey_state;
        return $this;
    }

    public function setSurvey_start($survey_start) {
        $this->survey_start = $survey_start;
        return $this;
    }

    public function setSurvey_end($survey_end) {
        $this->survey_end = $survey_end;
        return $this;
    }

    public function setPrice($price) {
        $this->price = $price;
        return $this;
    }

    public function setPayment_date($payment_date) {
        $this->payment_date = $payment_date;
        return $this;
    }



}

