<?php

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');
/**
 * @Author : Kadian Salmon
 * Date : Aug 2, 2021
 * Purpose : process all api request for payment
 * @link : https://api.queritel.com/api/payment/queritel/v1/api.php?action=init_transaction
 * @link : https://api.queritel.com/api/payment/queritel/v1/api.php?action=log_transaction
 *
 */


require 'vendor/autoload.php';

include("../../../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../../../includes/headers/strings.php");//has all the constants needed


// Set your secret key. Remember to switch to your live secret key in production.
// See your keys here: https://dashboard.stripe.com/apikeys

\Stripe\Stripe::setApiKey('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');
//\Stripe\Stripe::setApiKey('sk_test_51HJPlPJyH9e69bzmLefuJnDLy1tq8GOkDD6NqZ7cx9obJYq6kqza5bx5hJ9tAoEVRxNugBCuIUFJMHVg4fpuoAfh00KxNxU02N');


if (isset($_REQUEST["action"])){
    $action = $_REQUEST["action"];

    if ($action == "init_transaction"){

        $org_name = filter_var($_REQUEST["org_name"]);
        $email = filter_var($_REQUEST["email"]);
        $amount = filter_var($_REQUEST["amount"]);
        $comment = filter_var($_REQUEST["comment"]);
        $invoice_number = filter_var($_REQUEST["invoice_number"]);


        $currency = "usd";
        //$transaction_id = "trans_yrhfgsk_5647387_hdjksol";
        //$transaction_id = "-";
        $description = 'Queritel Payment';

        $amount_converted = $amount * 100;
        //clean text




        $intent = \Stripe\PaymentIntent::create([
            'amount' => $amount_converted,
            'currency' => $currency,
            'description' => $description,
            'receipt_email' => $email,
            'payment_method_types' => ['card'],
            'metadata' => [
                'integration_check' => 'accept_a_payment',
                'comment' => $comment,
                'invoice_number' => $invoice_number,
                'org_name' => $org_name
            ],
        ]);


        $transaction_data = array();
        $transaction_data["client_secret"] = $intent->client_secret;
        $transaction_data["amount"] = $amount;
        $transaction_data["currency"] = strtoupper($currency);
        $transaction_data["email"] = $email;
        $transaction_data["org_name"] = $org_name;
        $transaction_data["invoice_number"] = $invoice_number;
        $transaction_data["comment"] = $comment;
        $transaction_data["description"] = $description;

        /*$transaction_data = array();
        $transaction_data["client_secret"] = $intent->client_secret;
        $transaction_data["amount"] = 120;
        $transaction_data["currency"] = $currency;
        $transaction_data["email"] = "kadan.salmon@queritel.com";
        $transaction_data["transaction_id"] = $transaction_id;
        $transaction_data["invoice_number"] = "#9870590";
        $transaction_data["comment"] = "This is just a short comment";
        $transaction_data["description"] = $description;
        */

        echo json_encode($transaction_data);

    }

    if ($action == "log_transaction"){

        $org_name = filter_var($_REQUEST["org_name"]);
        $email = filter_var($_REQUEST["email"]);
        $amount = filter_var($_REQUEST["amount"]);
        $comment = filter_var($_REQUEST["comment"]);
        $invoice_number = filter_var($_REQUEST["invoice_number"]);
        $stripe_id = filter_var($_REQUEST["stripe_id"]);
        $currency = filter_var($_REQUEST["currency"]);

        //todo : API Debug
        debugAPIResponse("log_transaction",json_encode($_REQUEST,JSON_PRETTY_PRINT));

        $transaction_data = array();
        $transaction_data["transaction_id"] = generate_token();


        echo json_encode($transaction_data);
    }

}

function generate_token() {
    return generate_unique_id("trans");
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . strtolower(getRandomString(7)) . "_" . getRandomNumber(7) . "_" . strtolower(getRandomString(7));
}
function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}
